/*************************************************************************
 *
 *  $RCSfile: WeakTable.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.util;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import java.util.Enumeration;
import java.util.Hashtable;

import com.sun.star.lib.sandbox.Disposable;

import com.sun.star.lib.sandbox.generic.Dispatcher;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterBase;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory;


public class WeakTable {
	public static final boolean DEBUG = false;


	static Hashtable __methodss = new Hashtable();
	static public Hashtable __getMethodsAsTable(Class zClass) {
		Hashtable methods_tab = (Hashtable)__methodss.get(zClass);

		if(methods_tab == null) {
			methods_tab = new Hashtable();

			Method methods[] = zClass.getMethods();

			for(int i = 0; i < methods.length; ++ i) {
				methods_tab.put(methods[i].getName(), methods[i]);
			}

			__methodss.put(zClass, methods_tab);
		}

		return methods_tab;
	}


	protected Hashtable _hashtable                = new Hashtable();
	protected int       _refObject_count;
	protected int       _refObject_countTotal;
	protected int       _refererObject_count;
	protected int       _refererObject_countTotal;


	static class IDispatcher implements Dispatcher {
		Hashtable _methods;

		public Object invoke(Object object, String name, Object params[]) throws Exception, IllegalAccessException {
			if(_methods == null)
				_methods = __getMethodsAsTable(object.getClass());

			Method method = (Method)_methods.get(name);

			Object result = null;

			if(method == null) {
				System.err.println(getClass().getName() + ".invoke:" + name + " " + params);
				Thread.currentThread().dumpStack();
			}
			else {
				try {
					result = method.invoke(object, params);
				}
				catch(InvocationTargetException invocationTargetException) {
					if(DEBUG) System.err.println("##### " + getClass().getName() + ".invoke - exception occurred: " + invocationTargetException.getTargetException());

					throw (Exception)invocationTargetException.getTargetException();
				}
			}

			return result;
		}
	}

	public void clear() {
		_hashtable.clear();
	}
	
	public boolean contains(Object object) {
		return _hashtable.contains(object);
	}

	public boolean containsKey(Object key) {
		return _hashtable.containsKey(key);
	}

	private Object createProxy(RefObject refObject, Class zInterface) 
		throws IllegalAccessException,
			   InstantiationException
	{
  		Class zClass = DispatcherAdapterFactory.createDispatcherAdapter(zInterface, RefererObject.class.getName().replace('.', '/'));
  		RefererObject refererObject = (RefererObject)zClass.newInstance();
  		refererObject.setObject(new IDispatcher(), refObject._object);
		refererObject.setRefObject(refObject, this);
		
		return refererObject;
	}

	public static Object __getObject(Object object) {
		if(object instanceof RefererObject)
			object = ((RefererObject)object)._refObject._object;

		return object;
	}

	public Object get(Object key, Class zInterface) {
		RefObject refObject = (RefObject)_hashtable.get(key);

		Object object = null;

		try {
			if(refObject != null && zInterface != null)
				object = createProxy(refObject, zInterface);
		}
		catch(IllegalAccessException illegalAccessException) {
			System.err.println(getClass().getName() + " .get - IllegalAccessException: " + illegalAccessException);
		}
		catch(InstantiationException instantiationException) {
			System.err.println(getClass().getName() + " .get - InstantiationException: " + instantiationException);
		}

		return object;
	}

	public boolean isEmpty() {
		return _hashtable.isEmpty();
	}

	public Enumeration keys() {
		return _hashtable.keys();
	}

	public Object put(Object key, Object object, Class zInterface) {
		object = __getObject(object);

		if(DEBUG) System.err.println("####### WeakTable.put:" + key + " " + object + " "  + zInterface);

		try {
			RefObject refObject = new RefObject(object, _hashtable, key);

			_hashtable.put(key, refObject);

			object = createProxy(refObject, zInterface);
		}
		catch(IllegalAccessException illegalAccessException) {
			System.err.println(getClass().getName() + " .put - IllegalAccessException: " + illegalAccessException);
		}
		catch(InstantiationException instantiationException) {
			System.err.println(getClass().getName() + " .put - InstantiationException: " + instantiationException);
		}

		return object;
	}

	public void remove(Object key) {
		_hashtable.remove(key);
	}

	public int size() {
		return _hashtable.size();
	}

	public boolean reset() {
		boolean result = _hashtable.isEmpty();

		if(!result) {
			System.err.println("WeakTable warning - objects left!!!");
			
			System.err.println("WeakTable - refs left: " + _refObject_count + " refs total:" + _refObject_countTotal);
			System.err.println("WeakTable - referers left: " + _refererObject_count + " referers total:" + _refererObject_countTotal);
			
			Enumeration elements = _hashtable.elements();
			while(elements.hasMoreElements()) {
				RefObject refObject = (RefObject)elements.nextElement();
				System.err.println("#### " + refObject);
				if(refObject._object instanceof Disposable)
					((Disposable)refObject._object).dispose();
			}
		}

		return result;
	}
}

