/*************************************************************************
 *
 *  $RCSfile: windows.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/23 16:41:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if defined WNT

#include "windows.hxx"

#include "sunversion.hxx"
#include "javainfoimpl.hxx"
#include "osl/file.h"
#include <windows.h>

#define HKEY_SUN_JRE "Software\\JavaSoft\\Java Runtime Environment"
#define HKEY_SUN_SDK "Software\\JavaSoft\\Java Development Kit"

using namespace rtl;
using namespace jvmaccess::impl;

namespace {

bool getJavaInfoFromRegistry( const char* szRegKey, std::vector<SunVersion>& vecVersion,
                                  std::vector<OUString>& vecJavaHome)
{
    HKEY    hRoot;
    sal_Int32 count= 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, szRegKey, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
    {
        DWORD dwIndex = 0;
        DWORD nNameLen;
        char bufVersion[1024];
        FILETIME fileTime;
        nNameLen = sizeof(bufVersion);

        // Iterate over all subkeys of HKEY_LOCAL_MACHINE\Software\JavaSoft\Java Runtime Environment
        while (RegEnumKeyEx(hRoot, dwIndex, bufVersion, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
        {
            HKEY    hKey;
            // Open a Java Runtime Environment sub key, e.g. "1.4.0"
            if (RegOpenKeyEx(hRoot, bufVersion, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
            {
                // This entry may not have an RuntimeLib entry. Only if we find a RuntimeLib entry we process this
                // data further.
                DWORD   dwType;
                DWORD   dwTmpPathLen= 0;
                // Get the path to the runtime lib for every JRE entry
                // Find out how long the runtime lib path is and allocate memory to hold the path
                if( RegQueryValueEx(hKey, "JavaHome", 0, &dwType, NULL, &dwTmpPathLen)== ERROR_SUCCESS)
                {
                    char* szTmpPath= (char *) malloc( dwTmpPathLen);
                    // Get the path for the runtime lib
                    if(RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) szTmpPath, &dwTmpPathLen) == ERROR_SUCCESS)
                    {
                        // There can be several version entries refering to the same java (runtimelib),e.g 1.4 and 1.4.1
                        // We use the one with the more accurate (higher) version.
                        OUString usHome= OUString::createFromAscii(szTmpPath);
                        OUString usVersion= OUString::createFromAscii(bufVersion);
                        // check if there is already an entry with the same runtime lib
                        // if so, we use the one with the more accurate version
                        bool bAppend= true;
                        OUString usHomeUrl;
                        if (osl_getFileURLFromSystemPath(usHome.pData, & usHomeUrl.pData) ==
                            osl_File_E_None)
                        {
                            SunVersion curVersion = initVersion(usHomeUrl);
                            if(curVersion)
                            {
                                //iterate over the vector with java home strings
                                typedef std::vector<OUString>::iterator ItHome;
                                typedef std::vector<SunVersion>::iterator ItVer;
                                ItVer itVersion= vecVersion.begin();
                                for(ItHome itHome= vecJavaHome.begin();
                                    itHome != vecJavaHome.end(); itHome++, itVersion++)
                                {
                                    if(usHome.equals(*itHome))
                                    {
                                        bAppend= false;
                                        //We will use the one with more accurate version
                                        if(curVersion > *itVersion)
                                        {
                                            itVersion= vecVersion.erase(itVersion);
                                            vecVersion.insert(itVersion,curVersion);
                                        }
                                        break;
                                    }
                                }
                                // Save the version and RuntimeLib
                                if(bAppend)
                                {
                                    vecJavaHome.push_back(usHome);
                                    vecVersion.push_back(curVersion);
                                    count++;
                                }
                            }
                        }
                    }
                    free( szTmpPath);
                    RegCloseKey(hKey);
                }
            }
            dwIndex ++;
            nNameLen = sizeof(bufVersion);
        }
        RegCloseKey(hRoot);
    }
    return true;
}

}

bool
jvmaccess::impl::getSDKInfoFromRegistry(std::vector<SunVersion>& vecVersion,
                                        std::vector<OUString>& vecJavaHome)
{
    return getJavaInfoFromRegistry(HKEY_SUN_SDK, vecVersion, vecJavaHome);
}

bool
jvmaccess::impl::getJREInfoFromRegistry(std::vector<SunVersion>& vecVersion,
                                        std::vector<OUString>& vecJavaHome)
{
    return getJavaInfoFromRegistry(HKEY_SUN_JRE, vecVersion, vecJavaHome);
}

#endif // WNT
