/*************************************************************************
 *
 *  $RCSfile: register.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _REGISTER_HXX_
#define _REGISTER_HXX_

#include <tools/presys.h>
#include <shlobj.h>
#include <tools/postsys.h>

#define VCL_NEED_BASETSD

#include <rtl/ustring.hxx>

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

#ifndef _CONSTANTS_HXX_
#include "constants.hxx"
#endif

//---------------------------------------
// constants
//---------------------------------------

const int MOD_WRITER  = 0x1;
const int MOD_CALC    = 0x2;
const int MOD_IMPRESS = 0x4;
const int MOD_ACTIVEX = 0x40;

//-----------------------------------------
// registers StarOffice for MS document
// types and as default HTML editor if
// specified
//-----------------------------------------

void Register4MsDoc(
    int Register, 
    const rtl::OUString& aOfficeExePath, 
    ResMgr* aResMgr,
    bool InstallForAllUser);

//-----------------------------------------
// 
//-----------------------------------------

void Unregister4MsDoc(
    int Unregister, 
    const rtl::OUString& aOfficeExePath,
    ResMgr* aResMgr,
    bool InstallForAllUser);

//-----------------------------------------
// restores the entries for the selected
// registry entries
//-----------------------------------------

void Unregister4MsDocAll(
    const rtl::OUString& aOfficeExePath, 
    ResMgr* aResMgr,
    bool InstallForAllUser);

//-----------------------------------------
// restores lost settings formerly made
// with Register4MsDoc
//-----------------------------------------

void RepairRegister4MsDocSettings(
    const rtl::OUString& aOfficeExePath, 
    ResMgr* aResMgr,
    bool InstallForAllUser);

/** Returns whether we are registered for 
*/
bool IsRegisteredFor(
    const rtl::OUString& aOfficeExePath, 
    ResMgr* aResMgr, 
    bool InstallForAllUser, 
    int State);

/** Returns whether we should preselect the
    registration checkbox for a certain
    application type or not
*/
bool query_preselect_registration_for_ms_application(
    int Register, 
    const rtl::OUString& aOfficeExePath, 
    ResMgr* aResMgr, 
    bool InstallForAllUser);
    
//-----------------------------------------
// StarOffice 6.0 saved the registration
// state in HKEY_LOCAL_MACHINE\Software\
// Microsoft\Windows\CurrentVersion\Uninstall\
// StarOffice 6.0\Reg4MsdocState we move this
// value if available to the new registry
// location
//-----------------------------------------

int FixReturnRegistrationState(bool InstallForAllUser);

//-----------------------------------------
// register and unregister ActiveX control 
//-----------------------------------------

void RegisterActiveX4MSDoc( const ::rtl::OUString& aActiveXPath, int nPref, bool InstallForAllUser );
void UnregisterActiveX4MSDoc( const ::rtl::OUString& aActiveXPath, int nPref, bool InstallForAllUser );
void UnregisterActiveX4MSDocAll( const ::rtl::OUString& aActiveXPath, bool InstallForAllUser );

#endif
