/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: functab.h,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:46:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
// functab.h : header file
//////////////////////////////////////////////////////////////////
#ifndef SC_FUNCTAB
#define SC_FUNCTAB


#include <tools/solar.h>
#include <compiler.hxx>

// Maximale Anzahl der Parameter (fuer FixedFunc)
const BYTE nMaxParamCount	= 5;
// Identifier fuer Variable Anzahl Parameter
const BYTE nVarParam		= 0xff;
// Typ der Formel bzw des Parameters (Referenz, Wert, Feld)
const BYTE nTypeErr			= 0;	// FehlerCode: FunktionsParameter unbekannt
const BYTE nTypeRef			= 1;
const BYTE nTypeVal			= 2;
const BYTE nTypeArr			= 3;
const BYTE nTypeIgnore		= 4;	// parameter and it's subexpression to be
									// completely ignored (for example in ocCeil, ocFloor)
const BYTE nTypeInsert		= 5;	// default parameter to be inserted (i.e. ocAdress)

struct SFuncData
{
	USHORT  nOp;
	USHORT	nIndex;
	BYTE	nFuncType;
	BOOL	bVolatile;
	BYTE	nParamCount;
	BYTE	nVarParamTypeCount;		// Anzahl der angegebenen Typen variabler Parameter
	BYTE	nParamType[nMaxParamCount];

	void	Copy( const SFuncData& rCpy )
				{
				nOp = rCpy.nOp;
				nIndex = rCpy.nIndex;
				nFuncType = rCpy.nFuncType;
				bVolatile = rCpy.bVolatile;
				nParamCount = rCpy.nParamCount;
				nVarParamTypeCount = rCpy.nVarParamTypeCount;
				for( UINT16 nCnt = 0 ; nCnt < nMaxParamCount ; nCnt++ )
					nParamType[ nCnt ] = rCpy.nParamType[ nCnt ];
				}
};

const SFuncData* GetFuncData( OpCode eOp );

#endif
