/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmsearch.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:44:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif // _SVX_FMRESIDS_HRC

// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif


// auto strip #ifndef _SV_SVAPP_HXX //autogen
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include <dialmgr.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_SRCHXTRA_HXX
// auto strip #include "srchxtra.hxx"
// auto strip #endif // _SVX_SRCHXTRA_HXX

// auto strip #ifndef _OSL_MUTEX_HXX_
// auto strip #include <osl/mutex.hxx>
// auto strip #endif

// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif

// auto strip #ifndef _SFXFILEREC_HXX //autogen
// auto strip #include <svtools/filerec.hxx>
// auto strip #endif

// auto strip #ifndef _FMSRCIMP_HXX
// auto strip #include "fmsrcimp.hxx"
// auto strip #endif //  _FMSRCIMP_HXX

// auto strip #ifndef _FMSRCCF_HXX_
// auto strip #include "fmsrccfg.hxx"
// auto strip #endif // _FMSRCCF_HXX_

#ifndef _FMSEARCH_HRC
#include "fmsearch.hrc"
#endif // _FMSEARCH_HRC

#ifndef _FMSEARCH_HXX
#include "fmsearch.hxx"
#endif // _FMSEARCH_HXX

// auto strip #ifndef _SVX_SRCHDLG_HXX
// auto strip #include "srchdlg.hxx"
// auto strip #endif

// auto strip #ifndef _SVTOOLS_CJKOPTIONS_HXX
// auto strip #include <svtools/cjkoptions.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
// auto strip #include <com/sun/star/i18n/TransliterationModules.hpp>
// auto strip #endif

// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::i18n;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::util;

//------------------------------------------------------------------------
//STRIP001 sal_Bool IsSearchableControl(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface>& _xControl, ::rtl::OUString* pCurrentText)
//STRIP001 {
//STRIP001 	if (!_xControl.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTextComponent> xAsText(_xControl, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if (xAsText.is())
//STRIP001 	{
//STRIP001 		if (pCurrentText)
//STRIP001 			*pCurrentText = xAsText->getText();
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XListBox> xListBox(_xControl, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if (xListBox.is())
//STRIP001 	{
//STRIP001 		if (pCurrentText)
//STRIP001 			*pCurrentText = xListBox->getSelectedItem();
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XCheckBox> xCheckBox(_xControl, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if (xCheckBox.is())
//STRIP001 	{
//STRIP001 		if (pCurrentText)
//STRIP001 		{
//STRIP001 			switch ((TriState)xCheckBox->getState())
//STRIP001 			{
//STRIP001 				case STATE_NOCHECK: *pCurrentText = ::rtl::OUString::createFromAscii("0"); break;
//STRIP001 				case STATE_CHECK: *pCurrentText = ::rtl::OUString::createFromAscii("1"); break;
//STRIP001 				default: *pCurrentText = ::rtl::OUString::createFromAscii(""); break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 #define INIT_MEMBERS()	\
//STRIP001      m_flSearchFor              (this, ResId(FL_SEARCHFOR))         \
//STRIP001 	,m_rbSearchForText			(this, ResId(RB_SEARCHFORTEXT))		\
//STRIP001 	,m_rbSearchForNull			(this, ResId(RB_SEARCHFORNULL))		\
//STRIP001 	,m_rbSearchForNotNull		(this, ResId(RB_SEARCHFORNOTNULL))	\
//STRIP001 	,m_cmbSearchText			(this, ResId(CMB_SEARCHTEXT))		\
//STRIP001     ,m_flWhere                  (this, ResId(FL_WHERE))             \
//STRIP001 	,m_ftForm					(this, ResId(FT_FORM))				\
//STRIP001 	,m_lbForm					(this, ResId(LB_FORM))				\
//STRIP001 	,m_rbAllFields				(this, ResId(RB_ALLFIELDS))			\
//STRIP001 	,m_rbSingleField			(this, ResId(RB_SINGLEFIELD))		\
//STRIP001 	,m_lbField					(this, ResId(LB_FIELD))				\
//STRIP001     ,m_flOptions                (this, ResId(FL_OPTIONS))           \
//STRIP001 	,m_ftPosition				(this, ResId(FT_POSITION))			\
//STRIP001 	,m_lbPosition				(this, ResId(LB_POSITION))			\
//STRIP001 	,m_cbUseFormat				(this, ResId(CB_USEFORMATTER))		\
//STRIP001 	,m_cbCase					(this, ResId(CB_CASE))				\
//STRIP001 	,m_cbBackwards				(this, ResId(CB_BACKWARD))			\
//STRIP001 	,m_cbStartOver				(this, ResId(CB_STARTOVER))			\
//STRIP001 	,m_cbWildCard				(this, ResId(CB_WILDCARD))			\
//STRIP001 	,m_cbRegular				(this, ResId(CB_REGULAR))			\
//STRIP001 	,m_cbApprox					(this, ResId(CB_APPROX))			\
//STRIP001 	,m_pbApproxSettings			(this, ResId(PB_APPROXSETTINGS))	\
//STRIP001 	,m_aHalfFullFormsCJK		(this, ResId(CB_HALFFULLFORMS))		\
//STRIP001 	,m_aSoundsLikeCJK			(this, ResId(CB_SOUNDSLIKECJK))		\
//STRIP001 	,m_aSoundsLikeCJKSettings	(this, ResId(PB_SOUNDSLIKESETTINGS))	\
//STRIP001     ,m_flState                  (this, ResId(FL_STATE))             \
//STRIP001 	,m_ftRecordLabel			(this, ResId(FT_RECORDLABEL))		\
//STRIP001 	,m_ftRecord					(this, ResId(FT_RECORD))			\
//STRIP001 	,m_ftHint					(this, ResId(FT_HINT))				\
//STRIP001 	,m_pbSearchAgain			(this, ResId(PB_SEARCH))			\
//STRIP001 	,m_pbClose					(this, ResId(1))					\
//STRIP001 	,m_pbHelp					(this, ResId(1))					\
//STRIP001 	,m_pConfig( NULL )												\
//STRIP001 	,m_pPreSearchFocus( NULL )
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchDialog::FmSearchDialog(Window* pParent, const Reference< XResultSet >& xCursor, const UniString& strVisibleFields,
//STRIP001 	const UniString& sInitialText, const Reference< XNumberFormatsSupplier >& xFormatSupplier, SEARCH_MODE eMode)
//STRIP001 	:ModalDialog(pParent, SVX_RES(RID_SVXDLG_SEARCHFORM))
//STRIP001 	,INIT_MEMBERS()
//STRIP001 {
//STRIP001 	// hier muss ich die ListBox fuer die Kontextauswahl entfernen :
//STRIP001 	sal_Int32 nUpper = m_lbForm.GetPosPixel().Y();
//STRIP001 	sal_Int32 nDifference = m_rbAllFields.GetPosPixel().Y() - nUpper;
//STRIP001 
//STRIP001 	// einige Controls muessen nach oben verschoben werden
//STRIP001     Control* pFieldsToMove[] = { &m_rbAllFields, &m_rbSingleField, &m_lbField, &m_flOptions, &m_ftPosition, &m_lbPosition,
//STRIP001 			&m_cbUseFormat, &m_cbCase, &m_cbBackwards, &m_cbStartOver, &m_cbWildCard, &m_cbRegular, &m_cbApprox,
//STRIP001 			&m_pbApproxSettings, &m_aHalfFullFormsCJK, &m_aSoundsLikeCJK, &m_aSoundsLikeCJKSettings,
//STRIP001             &m_flState, &m_ftRecordLabel, &m_ftRecord, &m_ftHint };
//STRIP001     implMoveControls(pFieldsToMove, sizeof(pFieldsToMove)/sizeof(pFieldsToMove[0]), nDifference, &m_flWhere);
//STRIP001 
//STRIP001     Point pt = m_rbAllFields.GetPosPixel();
//STRIP001     pt.X() = m_ftForm.GetPosPixel().X();
//STRIP001     m_rbAllFields.SetPosPixel( pt );
//STRIP001     pt = m_rbSingleField.GetPosPixel();
//STRIP001     pt.X() = m_ftForm.GetPosPixel().X();
//STRIP001     m_rbSingleField.SetPosPixel( pt );
//STRIP001 
//STRIP001 	// und die beiden ueberfluessigen muessen weg
//STRIP001 	m_ftForm.Hide();
//STRIP001 	m_lbForm.Hide();
//STRIP001 
//STRIP001 	m_pSearchEngine = new FmSearchEngine(
//STRIP001 		::legacy_binfilters::getLegacyProcessServiceFactory(), xCursor, strVisibleFields, xFormatSupplier, eMode );
//STRIP001 	initCommon( xCursor );
//STRIP001 	Init(strVisibleFields, sInitialText);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::initCommon( const Reference< XResultSet >& _rxCursor )
//STRIP001 {
//STRIP001 	// init the engine
//STRIP001 	DBG_ASSERT( m_pSearchEngine, "FmSearchDialog::initCommon: have no engine!" );
//STRIP001 	m_pSearchEngine->SetProgressHandler(LINK(this, FmSearchDialog, OnSearchProgress));
//STRIP001 
//STRIP001 	// some layout changes according to available CJK options
//STRIP001 	SvtCJKOptions aCJKOptions;
//STRIP001 	if (!aCJKOptions.IsJapaneseFindEnabled())
//STRIP001 	{
//STRIP001 		sal_Int32 nUpper = m_pbApproxSettings.GetPosPixel().Y();
//STRIP001 		sal_Int32 nDifference = m_aSoundsLikeCJKSettings.GetPosPixel().Y() - nUpper;
//STRIP001 
//STRIP001 		// hide the options for the japanese search
//STRIP001         Control* pFieldsToMove[] = { &m_flState, &m_ftRecordLabel, &m_ftRecord, &m_ftHint };
//STRIP001         implMoveControls(pFieldsToMove, sizeof(pFieldsToMove)/sizeof(pFieldsToMove[0]), nDifference, &m_flOptions);
//STRIP001 
//STRIP001 		m_aSoundsLikeCJK.Hide();
//STRIP001 		m_aSoundsLikeCJKSettings.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!aCJKOptions.IsCJKFontEnabled())
//STRIP001 	{
//STRIP001 		m_aHalfFullFormsCJK.Hide();
//STRIP001 
//STRIP001 		// never ignore the width (ignoring is expensive) if the option is not available at all
//STRIP001 		// 04.12.2001 - 91973 - fs@openoffice.org
//STRIP001 		m_pSearchEngine->SetIgnoreWidthCJK( sal_False );
//STRIP001 	}
//STRIP001 
//STRIP001 	// some initial record texts
//STRIP001 	m_ftRecord.SetText( String::CreateFromInt32( _rxCursor->getRow() ) );
//STRIP001 	m_pbClose.SetHelpText(String());
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchDialog::FmSearchDialog(Window* pParent, const UniString& sInitialText, const UniString& strContexts, sal_Int16 nInitialContext,
//STRIP001 	const Link& lnkContextSupplier, SEARCH_MODE eMode)
//STRIP001 	:ModalDialog(pParent, SVX_RES(RID_SVXDLG_SEARCHFORM))
//STRIP001 	,INIT_MEMBERS()
//STRIP001 	,m_lnkContextSupplier(lnkContextSupplier)
//STRIP001 {
//STRIP001 	DBG_ASSERT(m_lnkContextSupplier.IsSet(), "FmSearchDialog::FmSearchDialog : have no ContextSupplier !");
//STRIP001 
//STRIP001 	// erst mal die Informationen fuer den initialen Kontext
//STRIP001 	FmSearchContext fmscInitial;
//STRIP001 	fmscInitial.nContext = nInitialContext;
//STRIP001 	m_lnkContextSupplier.Call(&fmscInitial);
//STRIP001 	DBG_ASSERT(fmscInitial.xCursor.is(), "FmSearchDialog::FmSearchDialog : invalid data supplied by ContextSupplier !");
//STRIP001 	DBG_ASSERT(fmscInitial.strUsedFields.GetTokenCount(';') == (xub_StrLen)fmscInitial.arrFields.size(),
//STRIP001 		"FmSearchDialog::FmSearchDialog : invalid data supplied by ContextSupplied !");
//STRIP001 #if (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 	for (sal_Int32 i=0; i<(sal_Int32)fmscInitial.arrFields.size(); ++i)
//STRIP001 		DBG_ASSERT(fmscInitial.arrFields.at(i).is(), "FmSearchDialog::FmSearchDialog : invalid data supplied by ContextSupplier !");
//STRIP001 #endif // (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 
//STRIP001 	for (xub_StrLen j=0; j<strContexts.GetTokenCount(';'); ++j)
//STRIP001 	{
//STRIP001 		m_arrContextFields.push_back(String());
//STRIP001 		m_lbForm.InsertEntry(strContexts.GetToken(j, ';'));
//STRIP001 	}
//STRIP001 	m_lbForm.SelectEntryPos(nInitialContext);
//STRIP001 
//STRIP001 	m_lbForm.SetSelectHdl(LINK(this, FmSearchDialog, OnContextSelection));
//STRIP001 
//STRIP001 	if (m_arrContextFields.size() == 1)
//STRIP001 	{	// remove the context selection listbox and rearrange the controls accordingly
//STRIP001 		sal_Int32 nUpper = m_lbForm.GetPosPixel().Y();
//STRIP001 		sal_Int32 nDifference = m_rbAllFields.GetPosPixel().Y() - nUpper;
//STRIP001 
//STRIP001 		// move all controls below the affected ones up
//STRIP001         Control* pFieldsToMove[] = { &m_rbAllFields, &m_rbSingleField, &m_lbField, &m_flOptions, &m_ftPosition, &m_lbPosition,
//STRIP001 				&m_cbUseFormat, &m_cbCase, &m_cbBackwards, &m_cbStartOver, &m_cbWildCard, &m_cbRegular, &m_cbApprox,
//STRIP001 				&m_pbApproxSettings, &m_aHalfFullFormsCJK, &m_aSoundsLikeCJK, &m_aSoundsLikeCJKSettings,
//STRIP001                 &m_flState, &m_ftRecordLabel, &m_ftRecord, &m_ftHint };
//STRIP001 
//STRIP001         implMoveControls(pFieldsToMove, sizeof(pFieldsToMove)/sizeof(pFieldsToMove[0]), nDifference, &m_flWhere);
//STRIP001 
//STRIP001         Point pt = m_rbAllFields.GetPosPixel();
//STRIP001         pt.X() = m_ftForm.GetPosPixel().X();
//STRIP001         m_rbAllFields.SetPosPixel( pt );
//STRIP001         pt = m_rbSingleField.GetPosPixel();
//STRIP001         pt.X() = m_ftForm.GetPosPixel().X();
//STRIP001         m_rbSingleField.SetPosPixel( pt );
//STRIP001 
//STRIP001         // hide dispensable controls
//STRIP001 		m_ftForm.Hide();
//STRIP001 		m_lbForm.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pSearchEngine = new FmSearchEngine(
//STRIP001 		::legacy_binfilters::getLegacyProcessServiceFactory(), fmscInitial.xCursor, fmscInitial.strUsedFields, fmscInitial.arrFields, eMode );
//STRIP001 	initCommon( fmscInitial.xCursor );
//STRIP001 
//STRIP001 	if (fmscInitial.sFieldDisplayNames.Len() != 0)
//STRIP001 	{	// use the display names if supplied
//STRIP001 		DBG_ASSERT(fmscInitial.sFieldDisplayNames.GetTokenCount() == fmscInitial.strUsedFields.GetTokenCount(),
//STRIP001 			"FmSearchDialog::FmSearchDialog : invalid initial context description !");
//STRIP001 		Init(fmscInitial.sFieldDisplayNames, sInitialText);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Init(fmscInitial.strUsedFields, sInitialText);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::implMoveControls(Control** _ppControls, sal_Int32 _nControls, sal_Int32 _nUp, Control* _pToResize)
//STRIP001 {
//STRIP001 	for (sal_Int32 i=0; i<_nControls; ++i)
//STRIP001 	{
//STRIP001 		Point pt = _ppControls[i]->GetPosPixel();
//STRIP001 		pt.Y() -= _nUp;
//STRIP001 		_ppControls[i]->SetPosPixel(pt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// resize myself
//STRIP001     Size sz = GetSizePixel();
//STRIP001 	sz.Height() -= _nUp;
//STRIP001 	SetSizePixel(sz);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 FmSearchDialog::~FmSearchDialog()
//STRIP001 {
//STRIP001 	if (m_aDelayedPaint.IsActive())
//STRIP001 		m_aDelayedPaint.Stop();
//STRIP001 
//STRIP001 	SaveParams();
//STRIP001 
//STRIP001 	if (m_pConfig)
//STRIP001 	{
//STRIP001 		delete m_pConfig;
//STRIP001 		m_pConfig = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	delete m_pSearchEngine;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::Init(const UniString& strVisibleFields, const UniString& sInitialText)
//STRIP001 {
//STRIP001 	// die Initialisierung all der Controls
//STRIP001 	m_rbSearchForText.SetClickHdl(LINK(this, FmSearchDialog, OnClickedFieldRadios));
//STRIP001 	m_rbSearchForNull.SetClickHdl(LINK(this, FmSearchDialog, OnClickedFieldRadios));
//STRIP001 	m_rbSearchForNotNull.SetClickHdl(LINK(this, FmSearchDialog, OnClickedFieldRadios));
//STRIP001 
//STRIP001 	m_rbAllFields.SetClickHdl(LINK(this, FmSearchDialog, OnClickedFieldRadios));
//STRIP001 	m_rbSingleField.SetClickHdl(LINK(this, FmSearchDialog, OnClickedFieldRadios));
//STRIP001 
//STRIP001 	m_pbSearchAgain.SetClickHdl(LINK(this, FmSearchDialog, OnClickedSearchAgain));
//STRIP001 	m_pbApproxSettings.SetClickHdl(LINK(this, FmSearchDialog, OnClickedSpecialSettings));
//STRIP001 	m_aSoundsLikeCJKSettings.SetClickHdl(LINK(this, FmSearchDialog, OnClickedSpecialSettings));
//STRIP001 
//STRIP001 	m_lbPosition.SetSelectHdl(LINK(this, FmSearchDialog, OnPositionSelected));
//STRIP001 	m_lbField.SetSelectHdl(LINK(this, FmSearchDialog, OnFieldSelected));
//STRIP001 
//STRIP001 	m_cmbSearchText.SetModifyHdl(LINK(this, FmSearchDialog, OnSearchTextModified));
//STRIP001 	m_cmbSearchText.EnableAutocomplete(sal_False);
//STRIP001 
//STRIP001 	m_cbUseFormat.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbBackwards.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbStartOver.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbCase.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbWildCard.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbRegular.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_cbApprox.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_aHalfFullFormsCJK.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 	m_aSoundsLikeCJK.SetToggleHdl(LINK(this, FmSearchDialog, OnCheckBoxToggled));
//STRIP001 
//STRIP001 	// die Listboxen fuellen
//STRIP001 	// die Methoden des Feldvergleiches
//STRIP001 	UniString strListBoxEntries(SVX_RES(RID_STR_RECORDSEARCH_METHODS));
//STRIP001 	xub_StrLen i;
//STRIP001 	for (i=0; i<strListBoxEntries.GetTokenCount(); ++i)
//STRIP001 		m_lbPosition.InsertEntry(strListBoxEntries.GetToken(i));
//STRIP001 	m_lbPosition.SelectEntryPos(MATCHING_ANYWHERE);
//STRIP001 
//STRIP001 	// die Feld-Listbox
//STRIP001 	for (i=0; i<strVisibleFields.GetTokenCount(';'); ++i)
//STRIP001 		m_lbField.InsertEntry(strVisibleFields.GetToken(i, ';'));
//STRIP001 
//STRIP001 
//STRIP001 	m_pConfig = new FmSearchConfigItem;
//STRIP001 	LoadParams();
//STRIP001 
//STRIP001 	m_cmbSearchText.SetText(sInitialText);
//STRIP001 	// wenn die Edit-Zeile den Text veraendert hat (weil er zum Beispiel Steuerzeichen enthielt, wie das bei Memofeldern der Fall
//STRIP001 	// sein kann), nehme ich einen leeren UniString
//STRIP001 	UniString sRealSetText = m_cmbSearchText.GetText();
//STRIP001 	if (!sRealSetText.Equals(sInitialText))
//STRIP001 		m_cmbSearchText.SetText(UniString());
//STRIP001 	LINK(this, FmSearchDialog, OnSearchTextModified).Call(&m_cmbSearchText);
//STRIP001 
//STRIP001 	// initial die ganzen UI-Elemente fuer die Suche an
//STRIP001 	m_aDelayedPaint.SetTimeoutHdl(LINK(this, FmSearchDialog, OnDelayedPaint));
//STRIP001 	m_aDelayedPaint.SetTimeout(500);
//STRIP001 	EnableSearchUI(sal_True);
//STRIP001 
//STRIP001 	if ( m_rbSearchForText.IsChecked() )
//STRIP001 		m_cmbSearchText.GrabFocus();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 sal_Bool FmSearchDialog::Close()
//STRIP001 {
//STRIP001 	// Wenn der Close-Button disabled ist und man im Dialog ESC drueckt, dann wird irgendwo vom Frame trotzdem Close aufgerufen,
//STRIP001 	// was ich allerdings nicht will, wenn ich gerade mitten in einer (eventuell in einem extra Thread laufenden) Suche bin
//STRIP001 	if (!m_pbClose.IsEnabled())
//STRIP001 		return sal_False;
//STRIP001 	return ModalDialog::Close();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnClickedFieldRadios, Button*, pButton)
//STRIP001 {
//STRIP001 	if ((pButton == &m_rbSearchForText) || (pButton == &m_rbSearchForNull) || (pButton == &m_rbSearchForNotNull))
//STRIP001 	{
//STRIP001 		EnableSearchForDependees(sal_True);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		// die Feldlistbox entsprechend en- oder disablen
//STRIP001 		if (pButton == &m_rbSingleField)
//STRIP001 		{
//STRIP001 			m_lbField.Enable();
//STRIP001 			m_pSearchEngine->RebuildUsedFields(m_lbField.GetSelectEntryPos());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			m_lbField.Disable();
//STRIP001 			m_pSearchEngine->RebuildUsedFields(-1);
//STRIP001 		}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnClickedSearchAgain, Button*, pButton)
//STRIP001 {
//STRIP001 	if (m_pbClose.IsEnabled())
//STRIP001 	{	// der Button hat die Funktion 'Suchen'
//STRIP001 		UniString strThisRoundText = m_cmbSearchText.GetText();
//STRIP001 		// zur History dazu
//STRIP001 		m_cmbSearchText.RemoveEntry(strThisRoundText);
//STRIP001 		m_cmbSearchText.InsertEntry(strThisRoundText, 0);
//STRIP001 			// das Remove/Insert stellt a) sicher, dass der UniString nicht zweimal auftaucht, b), dass die zuletzt gesuchten Strings am
//STRIP001 			// Anfang stehen
//STRIP001 		// und die Listenlaenge beschraenken
//STRIP001 		while (m_cmbSearchText.GetEntryCount() > MAX_HISTORY_ENTRIES)
//STRIP001 			m_cmbSearchText.RemoveEntry(m_cmbSearchText.GetEntryCount()-1);
//STRIP001 
//STRIP001 		// den 'Ueberlauf'-Hint rausnehmen
//STRIP001 		m_ftHint.SetText(UniString());
//STRIP001 		m_ftHint.Invalidate();
//STRIP001 
//STRIP001 		if (m_cbStartOver.IsChecked())
//STRIP001 		{
//STRIP001 			m_cbStartOver.Check(sal_False);
//STRIP001 			EnableSearchUI(sal_False);
//STRIP001 			if (m_rbSearchForText.IsChecked())
//STRIP001 				m_pSearchEngine->StartOver(strThisRoundText);
//STRIP001 			else
//STRIP001 				m_pSearchEngine->StartOverSpecial(m_rbSearchForNull.IsChecked());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			EnableSearchUI(sal_False);
//STRIP001 			if (m_rbSearchForText.IsChecked())
//STRIP001 				m_pSearchEngine->SearchNext(strThisRoundText);
//STRIP001 			else
//STRIP001 				m_pSearchEngine->SearchNextSpecial(m_rbSearchForNull.IsChecked());
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	// der Button hat die Fukntion 'Abbrechen'
//STRIP001 		DBG_ASSERT(m_pSearchEngine->GetSearchMode() != SM_BRUTE, "FmSearchDialog, OnClickedSearchAgain : falscher Modus !");
//STRIP001 			// der CancelButton wird normalerweise nur disabled, wenn ich in einem Thread oder mit Reschedule arbeite
//STRIP001 		m_pSearchEngine->CancelSearch();
//STRIP001 			// mein ProgressHandler wird gerufen, wenn es wirklich zu Ende ist, das hier war nur eine Anforderung
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnClickedSpecialSettings, Button*, pButton )
//STRIP001 {
//STRIP001 	if (&m_pbApproxSettings == pButton)
//STRIP001 	{
//STRIP001 		SvxSearchSimilarityDialog dlgLevSettings(this, m_pSearchEngine->GetLevRelaxed(), m_pSearchEngine->GetLevOther(),
//STRIP001 			m_pSearchEngine->GetLevShorter(), m_pSearchEngine->GetLevLonger());
//STRIP001 		if (dlgLevSettings.Execute() == RET_OK)
//STRIP001 		{
//STRIP001 			m_pSearchEngine->SetLevRelaxed(dlgLevSettings.IsRelaxed());
//STRIP001 			m_pSearchEngine->SetLevOther(dlgLevSettings.GetOther());
//STRIP001 			m_pSearchEngine->SetLevShorter(dlgLevSettings.GetShorter());
//STRIP001 			m_pSearchEngine->SetLevLonger(dlgLevSettings.GetLonger());
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (&m_aSoundsLikeCJKSettings == pButton)
//STRIP001 	{
//STRIP001 		SfxItemSet aSet( SFX_APP()->GetPool() );
//STRIP001 		SvxJSearchOptionsDialog aDlg( this, aSet, RID_SVXPAGE_JSEARCH_OPTIONS, m_pSearchEngine->GetTransliterationFlags() );
//STRIP001 		aDlg.Execute();
//STRIP001 
//STRIP001 		INT32 nFlags = aDlg.GetTransliterationFlags();
//STRIP001 		m_pSearchEngine->SetTransliterationFlags(nFlags);
//STRIP001 
//STRIP001 		m_cbCase.Check(m_pSearchEngine->GetCaseSensitive());
//STRIP001 		OnCheckBoxToggled( &m_cbCase );
//STRIP001 		m_aHalfFullFormsCJK.Check( !m_pSearchEngine->GetIgnoreWidthCJK() );
//STRIP001 		OnCheckBoxToggled( &m_aHalfFullFormsCJK );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnSearchTextModified, ComboBox*, pEdit)
//STRIP001 {
//STRIP001 	if ((m_cmbSearchText.GetText().Len() != 0) || !m_rbSearchForText.IsChecked())
//STRIP001 		m_pbSearchAgain.Enable();
//STRIP001 	else
//STRIP001 		m_pbSearchAgain.Disable();
//STRIP001 
//STRIP001 	m_pSearchEngine->InvalidatePreviousLoc();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnPositionSelected, ListBox*, pBox)
//STRIP001 {
//STRIP001 	DBG_ASSERT(pBox->GetSelectEntryCount() == 1, "FmSearchDialog::OnMethodSelected : unerwartet : nicht genau ein Eintrag selektiert !");
//STRIP001 
//STRIP001 	m_pSearchEngine->SetPosition(m_lbPosition.GetSelectEntryPos());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnFieldSelected, ListBox*, pBox)
//STRIP001 {
//STRIP001 	DBG_ASSERT(pBox->GetSelectEntryCount() == 1, "FmSearchDialog::OnFieldSelected : unerwartet : nicht genau ein Eintrag selektiert !");
//STRIP001 
//STRIP001 	m_pSearchEngine->RebuildUsedFields(m_rbAllFields.IsChecked() ? -1 : (sal_Int16)m_lbField.GetSelectEntryPos());
//STRIP001 		// ruft auch m_pSearchEngine->InvalidatePreviousLoc auf
//STRIP001 
//STRIP001 	sal_Int16 nCurrentContext = m_lbForm.GetSelectEntryPos();
//STRIP001 	if (nCurrentContext != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		m_arrContextFields[nCurrentContext] = UniString(m_lbField.GetSelectEntry());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnCheckBoxToggled, CheckBox*, pBox)
//STRIP001 {
//STRIP001 	sal_Bool bChecked = pBox->IsChecked();
//STRIP001 
//STRIP001 	// Formatter oder case -> an die Engine weiterreichen
//STRIP001 	if (pBox == &m_cbUseFormat)
//STRIP001 		m_pSearchEngine->SetFormatterUsing(bChecked);
//STRIP001 	else if (pBox == &m_cbCase)
//STRIP001 		m_pSearchEngine->SetCaseSensitive(bChecked);
//STRIP001 	// Richtung -> weiterreichen und Checkbox-Text fuer StartOver neu setzen
//STRIP001 	else if (pBox == &m_cbBackwards)
//STRIP001 	{
//STRIP001 		UniString strButtonText(SVX_RES(RID_STR_RECORDSEARCH_BUTTONS));
//STRIP001 		m_cbStartOver.SetText(strButtonText.GetToken(bChecked ? 1 : 0));
//STRIP001 
//STRIP001 		m_pSearchEngine->SetDirection(!bChecked);
//STRIP001 	}
//STRIP001 	// Aehnlichkeitssuche oder regulaerer Ausdruck
//STRIP001 	else if ((pBox == &m_cbApprox) || (pBox == &m_cbRegular) || (pBox == &m_cbWildCard))
//STRIP001 	{
//STRIP001 		// die beiden jeweils anderen Boxes disablen oder enablen
//STRIP001 		CheckBox* pBoxes[] = { &m_cbWildCard, &m_cbRegular, &m_cbApprox };
//STRIP001 		for (int i=0; i<sizeof(pBoxes)/sizeof(CheckBox*); ++i)
//STRIP001 			if (pBoxes[i] != pBox)
//STRIP001 				if (bChecked)
//STRIP001 					pBoxes[i]->Disable();
//STRIP001 				else
//STRIP001 					pBoxes[i]->Enable();
//STRIP001 
//STRIP001 		// an die Engine weiterreichen
//STRIP001 		m_pSearchEngine->SetWildcard(m_cbWildCard.IsEnabled() ? m_cbWildCard.IsChecked() : sal_False);
//STRIP001 		m_pSearchEngine->SetRegular(m_cbRegular.IsEnabled() ? m_cbRegular.IsChecked() : sal_False);
//STRIP001 		m_pSearchEngine->SetLevenshtein(m_cbApprox.IsEnabled() ? m_cbApprox.IsChecked() : sal_False);
//STRIP001 			// (Boxes, die disabled sind, muessen als sal_False an die Engine gehen)
//STRIP001 
//STRIP001 		// die Position-Listbox anpassen (ist bei Wildcard-Suche nicht erlaubt)
//STRIP001 		if (pBox == &m_cbWildCard)
//STRIP001 			if (bChecked)
//STRIP001 			{
//STRIP001 				m_ftPosition.Disable();
//STRIP001 				m_lbPosition.Disable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				m_ftPosition.Enable();
//STRIP001 				m_lbPosition.Enable();
//STRIP001 			}
//STRIP001 
//STRIP001 		// und den Button fuer die Aehnlichkeitssuche
//STRIP001 		if (pBox == &m_cbApprox)
//STRIP001 			if (bChecked)
//STRIP001 				m_pbApproxSettings.Enable();
//STRIP001 			else
//STRIP001 				m_pbApproxSettings.Disable();
//STRIP001 	}
//STRIP001 	else if (pBox == &m_aHalfFullFormsCJK)
//STRIP001 	{
//STRIP001 		// forward to the search engine
//STRIP001 		m_pSearchEngine->SetIgnoreWidthCJK( !bChecked );
//STRIP001 	}
//STRIP001 	else if (pBox == &m_aSoundsLikeCJK)
//STRIP001 	{
//STRIP001 		m_aSoundsLikeCJKSettings.Enable(bChecked);
//STRIP001 
//STRIP001 		// two other buttons which depend on this one
//STRIP001 		sal_Bool bEnable =	(	m_rbSearchForText.IsChecked()
//STRIP001 							&&	!m_aSoundsLikeCJK.IsChecked()
//STRIP001 							)
//STRIP001 						 ||	!SvtCJKOptions().IsJapaneseFindEnabled();
//STRIP001 		m_cbCase.Enable(bEnable);
//STRIP001 		m_aHalfFullFormsCJK.Enable(bEnable);
//STRIP001 
//STRIP001 		// forward to the search engine
//STRIP001 		m_pSearchEngine->SetTransliteration( bChecked );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::InitContext(sal_Int16 nContext)
//STRIP001 {
//STRIP001 	FmSearchContext fmscContext;
//STRIP001 	fmscContext.nContext = nContext;
//STRIP001 
//STRIP001 	sal_uInt32 nResult = m_lnkContextSupplier.Call(&fmscContext);
//STRIP001 	DBG_ASSERT(nResult > 0, "FmSearchDialog::InitContext : ContextSupplier didn't give me any controls !");
//STRIP001 
//STRIP001 	// packen wir zuerst die Feld-Namen in die entsprechende Listbox
//STRIP001 	m_lbField.Clear();
//STRIP001 
//STRIP001 	if (fmscContext.sFieldDisplayNames.Len() != 0)
//STRIP001 	{
//STRIP001 		// use the display names if supplied
//STRIP001 		DBG_ASSERT(fmscContext.sFieldDisplayNames.GetTokenCount() == fmscContext.strUsedFields.GetTokenCount(),
//STRIP001 			"FmSearchDialog::InitContext : invalid context description supplied !");
//STRIP001 		for (xub_StrLen i=0; i<fmscContext.sFieldDisplayNames.GetTokenCount(); ++i)
//STRIP001 			m_lbField.InsertEntry(fmscContext.sFieldDisplayNames.GetToken(i));
//STRIP001 	}
//STRIP001 	else
//STRIP001 		// else use the field names
//STRIP001 		for (xub_StrLen i=0; i<fmscContext.strUsedFields.GetTokenCount(); ++i)
//STRIP001 			m_lbField.InsertEntry(fmscContext.strUsedFields.GetToken(i));
//STRIP001 
//STRIP001 	if (nContext < (sal_Int32)m_arrContextFields.size() && m_arrContextFields[nContext].Len())
//STRIP001 	{
//STRIP001 		m_lbField.SelectEntry(m_arrContextFields[nContext]);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_lbField.SelectEntryPos(0);
//STRIP001 		if (m_rbSingleField.IsChecked() && (m_lbField.GetEntryCount() > 1))
//STRIP001 			m_lbField.GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	// dann geben wir der Engine Bescheid
//STRIP001 	m_pSearchEngine->SwitchToContext(fmscContext.xCursor, fmscContext.strUsedFields, fmscContext.arrFields,
//STRIP001 		m_rbAllFields.IsChecked() ? -1 : 0);
//STRIP001 
//STRIP001 	// und die Position des neuen Cursors anzeigen
//STRIP001 	m_ftRecord.SetText(String::CreateFromInt32(fmscContext.xCursor->getRow()));
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmSearchDialog, OnContextSelection, ListBox*, pBox)
//STRIP001 {
//STRIP001 	InitContext(pBox->GetSelectEntryPos());
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::EnableSearchUI(sal_Bool bEnable)
//STRIP001 {
//STRIP001 	// wenn die Controls disabled werden sollen, schalte ich mal eben kurz ihr Paint aus und verzoegert wieder an
//STRIP001 	if (!bEnable)
//STRIP001 		EnableControlPaint(sal_False);
//STRIP001 	else
//STRIP001 	{	// beim Enablen teste ich, ob der Timer fuer das delayed paint aktiv ist und stoppe ihn wenn noetig
//STRIP001 		if (m_aDelayedPaint.IsActive())
//STRIP001 			m_aDelayedPaint.Stop();
//STRIP001 	}
//STRIP001 	// (das ganze geht unten noch weiter)
//STRIP001 	// diese kleine Verrenkung fuehrt hoffentlich dazu, dass es nicht flackert, wenn man die SearchUI schnell hintereinander
//STRIP001 	// aus- und wieder einschaltet (wie das bei einem kurzen Suchvorgang zwangslaeufig der Fall ist)
//STRIP001 
//STRIP001 	if ( !bEnable )
//STRIP001 	{
//STRIP001 		// if one of my children has the focus, remember it 
//STRIP001 		// 104332 - 2002-10-17 - fs@openoffice.org
//STRIP001 		Window* pFocusWindow = Application::GetFocusWindow( );
//STRIP001 		if ( pFocusWindow && IsChild( pFocusWindow ) )
//STRIP001 			m_pPreSearchFocus = pFocusWindow;
//STRIP001 		else
//STRIP001 			m_pPreSearchFocus = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	// der Suchen-Button hat einen Doppelfunktion, seinen Text entsprechend anpassen
//STRIP001 	UniString strButtonText(SVX_RES(RID_STR_RECORDSEARCH_BUTTONS));
//STRIP001 	m_pbSearchAgain.SetText(strButtonText.GetToken(bEnable ? 2 : 3));
//STRIP001 
//STRIP001 	// jetzt Controls en- oder disablen
//STRIP001 	if (m_pSearchEngine->GetSearchMode() != SM_BRUTE)
//STRIP001 	{
//STRIP001         m_flSearchFor.Enable        (bEnable);
//STRIP001 		m_rbSearchForText.Enable	(bEnable);
//STRIP001 		m_rbSearchForNull.Enable	(bEnable);
//STRIP001 		m_rbSearchForNotNull.Enable	(bEnable);
//STRIP001         m_flWhere.Enable            (bEnable);
//STRIP001 		m_ftForm.Enable				(bEnable);
//STRIP001 		m_lbForm.Enable				(bEnable);
//STRIP001 		m_rbAllFields.Enable		(bEnable);
//STRIP001 		m_rbSingleField.Enable		(bEnable);
//STRIP001 		m_lbField.Enable			(bEnable && m_rbSingleField.IsChecked());
//STRIP001         m_flOptions.Enable          (bEnable);
//STRIP001 		m_cbBackwards.Enable		(bEnable);
//STRIP001 		m_cbStartOver.Enable		(bEnable);
//STRIP001 		m_pbClose.Enable			(bEnable);
//STRIP001 		EnableSearchForDependees	(bEnable);
//STRIP001 
//STRIP001 		if ( !bEnable )
//STRIP001 		{	// this means we're preparing for starting a search
//STRIP001 			// In this case, EnableSearchForDependees disabled the search button
//STRIP001 			// But as we're about to use it for cancelling the search, we really need to enable it, again
//STRIP001 			// 07.12.2001 - 95246 - fs@openoffice.org
//STRIP001 			m_pbSearchAgain.Enable( sal_True );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// und den Rest fuer das delayed paint
//STRIP001 	if (!bEnable)
//STRIP001 		m_aDelayedPaint.Start();
//STRIP001 	else
//STRIP001 		EnableControlPaint(sal_True);
//STRIP001 
//STRIP001 	if ( bEnable )
//STRIP001 	{	// restore focus
//STRIP001 		// 104332 - 2002-10-17 - fs@openoffice.org
//STRIP001 		if ( m_pPreSearchFocus )
//STRIP001 		{
//STRIP001 			m_pPreSearchFocus->GrabFocus();
//STRIP001 			if ( WINDOW_EDIT == m_pPreSearchFocus->GetType() )
//STRIP001 			{
//STRIP001 				Edit* pEdit = static_cast< Edit* >( m_pPreSearchFocus );
//STRIP001 				pEdit->SetSelection( Selection( 0, pEdit->GetText().Len() ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		m_pPreSearchFocus = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::EnableSearchForDependees(sal_Bool bEnable)
//STRIP001 {
//STRIP001 	sal_Bool bSearchingForText = m_rbSearchForText.IsChecked();
//STRIP001 	m_pbSearchAgain.Enable(bEnable && (!bSearchingForText || (m_cmbSearchText.GetText().Len() != 0)));
//STRIP001 
//STRIP001 	bEnable = bEnable && bSearchingForText;
//STRIP001 
//STRIP001 	sal_Bool bEnableRedundants = !m_aSoundsLikeCJK.IsChecked() || !SvtCJKOptions().IsJapaneseFindEnabled();
//STRIP001 
//STRIP001 	m_cmbSearchText.Enable			(bEnable);
//STRIP001 	m_ftPosition.Enable				(bEnable && !m_cbWildCard.IsChecked());
//STRIP001 	m_cbWildCard.Enable				(bEnable && !m_cbRegular.IsChecked() && !m_cbApprox.IsChecked());
//STRIP001 	m_cbRegular.Enable				(bEnable && !m_cbWildCard.IsChecked() && !m_cbApprox.IsChecked());
//STRIP001 	m_cbApprox.Enable				(bEnable && !m_cbWildCard.IsChecked() && !m_cbRegular.IsChecked());
//STRIP001 	m_pbApproxSettings.Enable		(bEnable && m_cbApprox.IsChecked());
//STRIP001 	m_aHalfFullFormsCJK.Enable		(bEnable && bEnableRedundants);
//STRIP001 	m_aSoundsLikeCJK.Enable			(bEnable);
//STRIP001 	m_aSoundsLikeCJKSettings.Enable	(bEnable && m_aSoundsLikeCJK.IsChecked());
//STRIP001 	m_lbPosition.Enable				(bEnable && !m_cbWildCard.IsChecked());
//STRIP001 	m_cbUseFormat.Enable			(bEnable);
//STRIP001 	m_cbCase.Enable					(bEnable && bEnableRedundants);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::EnableControlPaint(sal_Bool bEnable)
//STRIP001 {
//STRIP001     Control* pAffectedControls[] = { &m_flSearchFor, &m_rbSearchForText, &m_cmbSearchText, &m_rbSearchForNull, &m_rbSearchForNotNull,
//STRIP001         &m_rbSearchForText, &m_flWhere, &m_rbAllFields, &m_rbSingleField, &m_lbField, &m_flOptions, &m_ftPosition, &m_lbPosition,
//STRIP001 		&m_cbUseFormat, &m_cbCase, &m_cbBackwards, &m_cbStartOver, &m_cbWildCard, &m_cbRegular, &m_cbApprox, &m_pbApproxSettings,
//STRIP001 		&m_pbSearchAgain, &m_pbClose };
//STRIP001 
//STRIP001 	if (!bEnable)
//STRIP001 		for (sal_Int16 i=0; i<sizeof(pAffectedControls)/sizeof(pAffectedControls[0]); ++i)
//STRIP001 		{
//STRIP001 			pAffectedControls[i]->SetUpdateMode(bEnable);
//STRIP001 			pAffectedControls[i]->EnablePaint(bEnable);
//STRIP001 		}
//STRIP001 	else
//STRIP001 		for (sal_Int16 i=0; i<sizeof(pAffectedControls)/sizeof(pAffectedControls[0]); ++i)
//STRIP001 		{
//STRIP001 			pAffectedControls[i]->EnablePaint(bEnable);
//STRIP001 			pAffectedControls[i]->SetUpdateMode(bEnable);
//STRIP001 		}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnDelayedPaint, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	EnableControlPaint(sal_True);
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::OnFound(const ::com::sun::star::uno::Any& aCursorPos, sal_Int16 nFieldPos)
//STRIP001 {
//STRIP001 	FmFoundRecordInformation friInfo;
//STRIP001 	friInfo.nContext = m_lbForm.GetSelectEntryPos();
//STRIP001 		// wenn ich keine Suche in Kontexten mache, steht hier was ungueltiges drin, aber dann ist es auch egal
//STRIP001 	friInfo.aPosition = aCursorPos;
//STRIP001 	if (m_rbAllFields.IsChecked())
//STRIP001 		friInfo.nFieldPos = nFieldPos;
//STRIP001 	else
//STRIP001 		friInfo.nFieldPos = m_lbField.GetSelectEntryPos();
//STRIP001 		// das setzt natuerlich voraus, dass ich wirklich in dem Feld gesucht habe, dass in der Listbox ausgewaehlt ist,
//STRIP001 		// genau das wird auch in RebuildUsedFields sichergestellt
//STRIP001 
//STRIP001 	// dem Handler Bescheid sagen
//STRIP001 	sal_Int16 nResult = (sal_Int16)m_lnkFoundHandler.Call(&friInfo);
//STRIP001 
//STRIP001 	// und wieder Focus auf mich
//STRIP001 	if (nResult & FM_SEARCH_GETFOCUS_ASYNC)
//STRIP001 		Application::PostUserEvent(LINK(this, FmSearchDialog, AsyncGrabFocus));
//STRIP001 	else
//STRIP001 		m_cmbSearchText.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, AsyncGrabFocus, void*, EMPTYTAG)
//STRIP001 {
//STRIP001 	m_cmbSearchText.GrabFocus();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmSearchDialog, OnSearchProgress, FmSearchProgress*, pProgress)
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 		// diese eine Methode Thread-sicher machen (das ist ein Overkill, die ganze restliche Applikation dafuer zu blockieren,
//STRIP001 		// aber im Augenblick haben wir kein anderes Sicherheitskonpzept)
//STRIP001 
//STRIP001 	switch (pProgress->aSearchState)
//STRIP001 	{
//STRIP001 		case FmSearchProgress::STATE_PROGRESS:
//STRIP001 			if (pProgress->bOverflow)
//STRIP001 			{
//STRIP001 				UniString strHint = SVX_RESSTR(RID_STR_SEARCH_OVERFLOW).GetToken(m_cbBackwards.IsChecked() ? 1 : 0);
//STRIP001 				m_ftHint.SetText(strHint);
//STRIP001 				m_ftHint.Invalidate();
//STRIP001 			}
//STRIP001 
//STRIP001 			m_ftRecord.SetText(String::CreateFromInt32(1 + pProgress->nCurrentRecord));
//STRIP001 			m_ftRecord.Invalidate();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FmSearchProgress::STATE_PROGRESS_COUNTING:
//STRIP001 			m_ftHint.SetText(SVX_RESSTR(RID_STR_SEARCH_COUNTING));
//STRIP001 			m_ftHint.Invalidate();
//STRIP001 
//STRIP001 			m_ftRecord.SetText(String::CreateFromInt32(pProgress->nCurrentRecord));
//STRIP001 			m_ftRecord.Invalidate();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FmSearchProgress::STATE_SUCCESSFULL:
//STRIP001 			OnFound(pProgress->aBookmark, (sal_Int16)pProgress->nFieldIndex);
//STRIP001 			EnableSearchUI(sal_True);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FmSearchProgress::STATE_ERROR:
//STRIP001 		case FmSearchProgress::STATE_NOTHINGFOUND:
//STRIP001 		{
//STRIP001 			sal_uInt16 nErrorId = (FmSearchProgress::STATE_ERROR == pProgress->aSearchState)
//STRIP001 				? RID_SVXERR_SEARCH_GENERAL_ERROR
//STRIP001 				: RID_SVXERR_SEARCH_NORECORD;
//STRIP001 			ErrorBox(this, SVX_RES(nErrorId)).Execute();
//STRIP001 		}
//STRIP001 			// KEIN break !
//STRIP001 		case FmSearchProgress::STATE_CANCELED:
//STRIP001 			EnableSearchUI(sal_True);
//STRIP001 			if (m_lnkCanceledNotFoundHdl.IsSet())
//STRIP001 			{
//STRIP001 				FmFoundRecordInformation friInfo;
//STRIP001 				friInfo.nContext = m_lbForm.GetSelectEntryPos();
//STRIP001 					// wenn ich keine Suche in Kontexten mache, steht hier was ungueltiges drin, aber dann ist es auch egal
//STRIP001 				friInfo.aPosition = pProgress->aBookmark;
//STRIP001 				m_lnkCanceledNotFoundHdl.Call(&friInfo);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	m_ftRecord.SetText(String::CreateFromInt32(1 + pProgress->nCurrentRecord));
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::LoadParams()
//STRIP001 {
//STRIP001 	FmSearchParams aParams(m_pConfig->getParams());
//STRIP001 
//STRIP001 	const ::rtl::OUString* pHistory		=					aParams.aHistory.getConstArray();
//STRIP001 	const ::rtl::OUString* pHistoryEnd	=	pHistory	+	aParams.aHistory.getLength();
//STRIP001 	for (; pHistory != pHistoryEnd; ++pHistory)
//STRIP001 		m_cmbSearchText.InsertEntry( *pHistory );
//STRIP001 
//STRIP001 	// die Einstellungen nehme ich an meinen UI-Elementen vor und rufe dann einfach den entsprechenden Change-Handler auf,
//STRIP001 	// dadurch werden die Daten an die SearchEngine weitergereicht und alle abhaengigen Enstellungen vorgenommen
//STRIP001 
//STRIP001 	// aktuelles Feld
//STRIP001 	sal_uInt16 nInitialField = m_lbField.GetEntryPos( String( aParams.sSingleSearchField ) );
//STRIP001 	if (nInitialField == COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 		nInitialField = 0;
//STRIP001 	m_lbField.SelectEntryPos(nInitialField);
//STRIP001 	LINK(this, FmSearchDialog, OnFieldSelected).Call(&m_lbField);
//STRIP001 	// alle/einzelnes Feld (NACH dem Selektieren des Feldes, da OnClickedFieldRadios dort einen gueltigen Eintrag erwartet)
//STRIP001 	if (aParams.bAllFields)
//STRIP001 	{
//STRIP001 		m_rbSingleField.Check(sal_False);
//STRIP001 		m_rbAllFields.Check(sal_True);
//STRIP001 		LINK(this, FmSearchDialog, OnClickedFieldRadios).Call(&m_rbAllFields);
//STRIP001 		// OnClickedFieldRadios ruft auch um RebuildUsedFields
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		m_rbAllFields.Check(sal_False);
//STRIP001 		m_rbSingleField.Check(sal_True);
//STRIP001 		LINK(this, FmSearchDialog, OnClickedFieldRadios).Call(&m_rbSingleField);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Position im Feld
//STRIP001 	m_lbPosition.SelectEntryPos(aParams.nPosition);
//STRIP001 	LINK(this, FmSearchDialog, OnPositionSelected).Call(&m_lbPosition);
//STRIP001 
//STRIP001 	// Feld-Formatierung/Case-Sensitivitaet/Richtung
//STRIP001 	m_cbUseFormat.Check(aParams.bUseFormatter);
//STRIP001 	m_cbCase.Check( aParams.isCaseSensitive() );
//STRIP001 	m_cbBackwards.Check(aParams.bBackwards);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbUseFormat);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbCase);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbBackwards);
//STRIP001 
//STRIP001 	m_aHalfFullFormsCJK.Check( !aParams.isIgnoreWidthCJK( ) );	// BEWARE: this checkbox has a inverse semantics!
//STRIP001 	m_aSoundsLikeCJK.Check( aParams.bSoundsLikeCJK );
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_aHalfFullFormsCJK);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_aSoundsLikeCJK);
//STRIP001 
//STRIP001 	// die drei Checkboxen fuer spezielle Sucharten
//STRIP001 	// erst mal alle ruecksetzen
//STRIP001 	m_cbWildCard.Check(sal_False);
//STRIP001 	m_cbRegular.Check(sal_False);
//STRIP001 	m_cbApprox.Check(sal_False);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbWildCard);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbRegular);
//STRIP001 	LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(&m_cbApprox);
//STRIP001 
//STRIP001 	// dann die richtige setzen
//STRIP001 	CheckBox* pToCheck = NULL;
//STRIP001 	if (aParams.bWildcard)
//STRIP001 		pToCheck = &m_cbWildCard;
//STRIP001 	if (aParams.bRegular)
//STRIP001 		pToCheck = &m_cbRegular;
//STRIP001 	if (aParams.bApproxSearch)
//STRIP001 		pToCheck = &m_cbApprox;
//STRIP001 	if (aParams.bSoundsLikeCJK)
//STRIP001 		pToCheck = &m_aSoundsLikeCJK;
//STRIP001 	if (pToCheck)
//STRIP001 	{
//STRIP001 		pToCheck->Check(sal_True);
//STRIP001 		LINK(this, FmSearchDialog, OnCheckBoxToggled).Call(pToCheck);
//STRIP001 	}
//STRIP001 
//STRIP001 	// die Levenshtein-Parameter direkt an der SearchEngine setzen
//STRIP001 	m_pSearchEngine->SetLevRelaxed(aParams.bLevRelaxed);
//STRIP001 	m_pSearchEngine->SetLevOther(aParams.nLevOther);
//STRIP001 	m_pSearchEngine->SetLevShorter(aParams.nLevShorter);
//STRIP001 	m_pSearchEngine->SetLevLonger(aParams.nLevLonger);
//STRIP001 
//STRIP001 	m_pSearchEngine->SetTransliterationFlags( aParams.getTransliterationFlags( ) );
//STRIP001 
//STRIP001 	m_rbSearchForText.Check(sal_False);
//STRIP001 	m_rbSearchForNull.Check(sal_False);
//STRIP001 	m_rbSearchForNotNull.Check(sal_False);
//STRIP001 	switch (aParams.nSearchForType)
//STRIP001 	{
//STRIP001 		case 1: m_rbSearchForNull.Check(sal_True); break;
//STRIP001 		case 2: m_rbSearchForNotNull.Check(sal_True); break;
//STRIP001 		default: m_rbSearchForText.Check(sal_True); break;
//STRIP001 	}
//STRIP001 	LINK(this, FmSearchDialog, OnClickedFieldRadios).Call(&m_rbSearchForText);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmSearchDialog::SaveParams() const
//STRIP001 {
//STRIP001 	if (!m_pConfig)
//STRIP001 		return;
//STRIP001 
//STRIP001 	FmSearchParams aCurrentSettings;
//STRIP001 
//STRIP001 	aCurrentSettings.aHistory.realloc( m_cmbSearchText.GetEntryCount() );
//STRIP001 	::rtl::OUString* pHistory = aCurrentSettings.aHistory.getArray();
//STRIP001 	for (sal_uInt16 i=0; i<m_cmbSearchText.GetEntryCount(); ++i, ++pHistory)
//STRIP001 		*pHistory = m_cmbSearchText.GetEntry(i);
//STRIP001 
//STRIP001 	aCurrentSettings.sSingleSearchField			= m_lbField.GetSelectEntry();
//STRIP001 	aCurrentSettings.bAllFields					= m_rbAllFields.IsChecked();
//STRIP001 	aCurrentSettings.nPosition					= m_pSearchEngine->GetPosition();
//STRIP001 	aCurrentSettings.bUseFormatter				= m_pSearchEngine->GetFormatterUsing();
//STRIP001 	aCurrentSettings.setCaseSensitive			( m_pSearchEngine->GetCaseSensitive() );
//STRIP001 	aCurrentSettings.bBackwards					= !m_pSearchEngine->GetDirection();
//STRIP001 	aCurrentSettings.bWildcard					= m_pSearchEngine->GetWildcard();
//STRIP001 	aCurrentSettings.bRegular					= m_pSearchEngine->GetRegular();
//STRIP001 	aCurrentSettings.bApproxSearch				= m_pSearchEngine->GetLevenshtein();
//STRIP001 	aCurrentSettings.bLevRelaxed				= m_pSearchEngine->GetLevRelaxed();
//STRIP001 	aCurrentSettings.nLevOther					= m_pSearchEngine->GetLevOther();
//STRIP001 	aCurrentSettings.nLevShorter				= m_pSearchEngine->GetLevShorter();
//STRIP001 	aCurrentSettings.nLevLonger					= m_pSearchEngine->GetLevLonger();
//STRIP001 
//STRIP001 	aCurrentSettings.bSoundsLikeCJK				= m_pSearchEngine->GetTransliteration();
//STRIP001 	aCurrentSettings.setTransliterationFlags	( m_pSearchEngine->GetTransliterationFlags() );
//STRIP001 
//STRIP001 	if (m_rbSearchForNull.IsChecked())
//STRIP001 		aCurrentSettings.nSearchForType = 1;
//STRIP001 	else if (m_rbSearchForNotNull.IsChecked())
//STRIP001 		aCurrentSettings.nSearchForType = 2;
//STRIP001 	else
//STRIP001 		aCurrentSettings.nSearchForType = 0;
//STRIP001 
//STRIP001 	m_pConfig->setParams( aCurrentSettings );
//STRIP001 }

}
