/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_numfmtlb.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:05:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
//STRIP001 #include <com/sun/star/lang/XMultiServiceFactory.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//STRIP001 #include <comphelper/processfactory.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _UNO_LINGU_HXX
//STRIP001 #include <bf_svx/unolingu.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
//STRIP001 #include <unotools/localedatawrapper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _LANG_HXX //autogen
//STRIP001 #include <tools/lang.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _ZFORMAT_HXX //autogen
//STRIP001 #define _ZFORLIST_DECLARE_TABLE
//STRIP001 #include <svtools/zformat.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXENUMITEM_HXX
//STRIP001 #include <svtools/eitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SVXIDS_HRC //autogen
//STRIP001 #include <bf_svx/svxids.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_NUMINF_HXX //autogen
//STRIP001 #define ITEMID_NUMBERINFO SID_ATTR_NUMBERFORMAT_INFO
//STRIP001 #include <bf_svx/numinf.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_NUMFMT_HXX //autogen
//STRIP001 #include <bf_svx/numfmt.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _TBLNUMFM_HXX
//STRIP001 #include <tblnumfm.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWTYPES_HXX
//STRIP001 #include <swtypes.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEW_HXX
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include <wrtsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _NUMFMTLB_HXX
//STRIP001 #include <numfmtlb.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _UTLUI_HRC
//STRIP001 #include <utlui.hrc>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP001 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP001 #endif
//STRIP001 
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 #define C2S(cChar) UniString::CreateFromAscii(cChar)
//STRIP001 
//STRIP001 // STATIC DATA -----------------------------------------------------------
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 					nFormatType: Formate dieses Typs anzeigen
//STRIP001 					nDefFmt:     Dieses Format selektieren und ggf vorher
//STRIP001 								 einfuegen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 NumFormatListBox::NumFormatListBox( Window* pWin, const ResId& rResId,
//STRIP001 									short nFormatType, ULONG nDefFmt,
//STRIP001 									BOOL bUsrFmts ) :
//STRIP001 	ListBox				( pWin, rResId ),
//STRIP001 	nCurrFormatType 	(-1),
//STRIP001 	nStdEntry			(0),
//STRIP001 	bOneArea			(FALSE),
//STRIP001 	nDefFormat			(nDefFmt),
//STRIP001 	pVw					(0),
//STRIP001     pOwnFormatter       (0),
//STRIP001     bUseAutomaticLanguage(TRUE),
//STRIP001     bShowLanguageControl(FALSE)
//STRIP001 {
//STRIP001 	Init(nFormatType, bUsrFmts);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 NumFormatListBox::NumFormatListBox( Window* pWin, SwView* pView,
//STRIP001 									const ResId& rResId, short nFormatType,
//STRIP001 									ULONG nDefFmt, BOOL bUsrFmts ) :
//STRIP001 	ListBox				( pWin, rResId ),
//STRIP001 	nCurrFormatType 	(-1),
//STRIP001 	nStdEntry			(0),
//STRIP001 	bOneArea			(FALSE),
//STRIP001 	nDefFormat			(nDefFmt),
//STRIP001 	pVw					(pView),
//STRIP001     pOwnFormatter       (0),
//STRIP001     bUseAutomaticLanguage(TRUE),
//STRIP001     bShowLanguageControl(FALSE)
//STRIP001 {
//STRIP001 	Init(nFormatType, bUsrFmts);
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------15.06.98 11:29-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 
//STRIP001 void NumFormatListBox::Init(short nFormatType, BOOL bUsrFmts)
//STRIP001 {
//STRIP001 	SwView *pView = GetView();
//STRIP001 
//STRIP001 	if (pView)
//STRIP001 		eCurLanguage = pView->GetWrtShell().GetCurLang();
//STRIP001 	else
//STRIP001 		eCurLanguage = SvxLocaleToLanguage( GetAppLocaleData().getLocale() );
//STRIP001 
//STRIP001 	if (bUsrFmts == FALSE)
//STRIP001    	{
//STRIP001 		Reference< XMultiServiceFactory > xMSF = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 		pOwnFormatter = new SvNumberFormatter(xMSF, eCurLanguage);
//STRIP001 	}
//STRIP001 
//STRIP001 	SetFormatType(nFormatType);
//STRIP001 	SetDefFormat(nDefFormat);
//STRIP001 
//STRIP001 	SetSelectHdl(LINK(this, NumFormatListBox, SelectHdl));
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 NumFormatListBox::~NumFormatListBox()
//STRIP001 {
//STRIP001 	if (pOwnFormatter)
//STRIP001 		delete pOwnFormatter;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwView* NumFormatListBox::GetView()
//STRIP001 {
//STRIP001 	if( pVw )
//STRIP001 		return pVw;
//STRIP001 	return ::GetActiveView();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void NumFormatListBox::SetFormatType(const short nFormatType)
//STRIP001 {
//STRIP001 	if (nCurrFormatType == -1 ||
//STRIP001 		(nCurrFormatType & nFormatType) == 0)	// Es gibt Mischformate, wie z.B. DateTime
//STRIP001 	{
//STRIP001 		SvNumberFormatter* pFormatter;
//STRIP001 
//STRIP001 		if( pOwnFormatter )
//STRIP001 			pFormatter = pOwnFormatter;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SwView *pView = GetView();
//STRIP001 			SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001 			pFormatter = rSh.GetNumberFormatter();
//STRIP001 		}
//STRIP001 
//STRIP001 		Clear();	// Alle Eintraege in der Listbox entfernen
//STRIP001 
//STRIP001 		NfIndexTableOffset eOffsetStart = NF_NUMBER_START;
//STRIP001 		NfIndexTableOffset eOffsetEnd = NF_NUMBER_START;
//STRIP001 
//STRIP001 		switch( nFormatType )
//STRIP001 		{
//STRIP001 		case NUMBERFORMAT_NUMBER:
//STRIP001 			eOffsetStart=NF_NUMBER_START;
//STRIP001 			eOffsetEnd=NF_NUMBER_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_PERCENT:
//STRIP001 			eOffsetStart=NF_PERCENT_START;
//STRIP001 			eOffsetEnd=NF_PERCENT_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_CURRENCY:
//STRIP001 			eOffsetStart=NF_CURRENCY_START;
//STRIP001 			eOffsetEnd=NF_CURRENCY_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_DATETIME:
//STRIP001 			eOffsetStart=NF_DATE_START;
//STRIP001 			eOffsetEnd=NF_TIME_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_DATE:
//STRIP001 			eOffsetStart=NF_DATE_START;
//STRIP001 			eOffsetEnd=NF_DATE_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_TIME:
//STRIP001 			eOffsetStart=NF_TIME_START;
//STRIP001 			eOffsetEnd=NF_TIME_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_SCIENTIFIC:
//STRIP001 			eOffsetStart=NF_SCIENTIFIC_START;
//STRIP001 			eOffsetEnd=NF_SCIENTIFIC_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_FRACTION:
//STRIP001 			eOffsetStart=NF_FRACTION_START;
//STRIP001 			eOffsetEnd=NF_FRACTION_END;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_LOGICAL:
//STRIP001 			eOffsetStart=NF_BOOLEAN;
//STRIP001 			eOffsetEnd=NF_BOOLEAN;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_TEXT:
//STRIP001 			eOffsetStart=NF_TEXT;
//STRIP001 			eOffsetEnd=NF_TEXT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_ALL:
//STRIP001 			eOffsetStart=NF_NUMERIC_START;
//STRIP001 			eOffsetEnd = NfIndexTableOffset( NF_INDEX_TABLE_ENTRIES - 1 );
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("what a format?");
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		const SvNumberformat* pFmt;
//STRIP001 		USHORT nPos, i = 0;
//STRIP001 		ULONG  nFormat;
//STRIP001 		Color* pCol;
//STRIP001 		double fVal = GetDefValue( pFormatter, nFormatType );
//STRIP001 		String sValue;
//STRIP001 
//STRIP001 		ULONG nSysNumFmt = pFormatter->GetFormatIndex(
//STRIP001 										NF_NUMBER_SYSTEM, eCurLanguage );
//STRIP001 		ULONG nSysShortDateFmt = pFormatter->GetFormatIndex(
//STRIP001 										NF_DATE_SYSTEM_SHORT, eCurLanguage );
//STRIP001 		ULONG nSysLongDateFmt = pFormatter->GetFormatIndex(
//STRIP001 										NF_DATE_SYSTEM_LONG, eCurLanguage );
//STRIP001 
//STRIP001 		for( long nIndex = eOffsetStart; nIndex <= eOffsetEnd; ++nIndex )
//STRIP001 		{
//STRIP001 			nFormat = pFormatter->GetFormatIndex(
//STRIP001 							(NfIndexTableOffset)nIndex, eCurLanguage );
//STRIP001 			pFmt = pFormatter->GetEntry( nFormat );
//STRIP001 
//STRIP001 			if( nFormat == pFormatter->GetFormatIndex( NF_NUMBER_STANDARD,
//STRIP001 														eCurLanguage )
//STRIP001 				|| ((SvNumberformat*)pFmt)->GetOutputString( fVal, sValue, &pCol )
//STRIP001 				|| nFormatType == NUMBERFORMAT_UNDEFINED )
//STRIP001 					sValue = pFmt->GetFormatstring();
//STRIP001 			else if( nFormatType == NUMBERFORMAT_TEXT )
//STRIP001 			{
//STRIP001 				String sTxt(C2S("\"ABC\""));
//STRIP001 				pFormatter->GetOutputString( sTxt, nFormat, sValue, &pCol);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (nFormat != nSysNumFmt		&&
//STRIP001 				nFormat != nSysShortDateFmt	&&
//STRIP001 				nFormat != nSysLongDateFmt)
//STRIP001 			{
//STRIP001 				nPos = InsertEntry( sValue );
//STRIP001 				SetEntryData( nPos, (void*)nFormat );
//STRIP001 
//STRIP001 				if( nFormat == pFormatter->GetStandardFormat(
//STRIP001 										nFormatType, eCurLanguage ) )
//STRIP001 					nStdEntry = i;
//STRIP001 				++i;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!pOwnFormatter)
//STRIP001 		{
//STRIP001 			nPos = InsertEntry(SW_RESSTR( STR_DEFINE_NUMBERFORMAT ));
//STRIP001 			SetEntryData( nPos, NULL );
//STRIP001 		}
//STRIP001 
//STRIP001 		SelectEntryPos( nStdEntry );
//STRIP001 
//STRIP001 		nCurrFormatType = nFormatType;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void NumFormatListBox::SetDefFormat(const ULONG nDefFmt)
//STRIP001 {
//STRIP001 	if (nDefFmt == ULONG_MAX)
//STRIP001 	{
//STRIP001 		nDefFormat = nDefFmt;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001     SvNumberFormatter* pFormatter;
//STRIP001     if (pOwnFormatter)
//STRIP001         pFormatter = pOwnFormatter;
//STRIP001     else
//STRIP001     {
//STRIP001         SwView *pView = GetView();
//STRIP001         SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001         pFormatter = rSh.GetNumberFormatter();
//STRIP001     }
//STRIP001 
//STRIP001     short nType = pFormatter->GetType(nDefFmt);
//STRIP001 
//STRIP001     SetFormatType(nType);
//STRIP001 
//STRIP001     ULONG nFormat = pFormatter->GetFormatForLanguageIfBuiltIn(nDefFmt, eCurLanguage);
//STRIP001 
//STRIP001     for (USHORT i = 0; i < GetEntryCount(); i++)
//STRIP001     {
//STRIP001         if (nFormat == (ULONG)GetEntryData(i))
//STRIP001         {
//STRIP001             SelectEntryPos(i);
//STRIP001             nStdEntry = i;
//STRIP001             nDefFormat = GetFormat();
//STRIP001             return;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // Kein Eintrag gefunden:
//STRIP001     double fValue = GetDefValue(pFormatter, nType);
//STRIP001     String sValue;
//STRIP001     Color* pCol = 0;
//STRIP001 
//STRIP001     if (nType == NUMBERFORMAT_TEXT)
//STRIP001     {
//STRIP001         String sTxt(C2S("\"ABC\""));
//STRIP001         pFormatter->GetOutputString(sTxt, nDefFmt, sValue, &pCol);
//STRIP001     }
//STRIP001     else
//STRIP001         pFormatter->GetOutputString(fValue, nDefFmt, sValue, &pCol);
//STRIP001 
//STRIP001     USHORT nPos = 0;
//STRIP001     while ((ULONG)GetEntryData(nPos) == ULONG_MAX)
//STRIP001         nPos++;
//STRIP001 
//STRIP001 //
//STRIP001     ULONG nSysNumFmt = pFormatter->GetFormatIndex( NF_NUMBER_SYSTEM, eCurLanguage);
//STRIP001     ULONG nSysShortDateFmt = pFormatter->GetFormatIndex( NF_DATE_SYSTEM_SHORT, eCurLanguage);
//STRIP001     ULONG nSysLongDateFmt = pFormatter->GetFormatIndex( NF_DATE_SYSTEM_LONG, eCurLanguage);
//STRIP001     BOOL bSysLang = FALSE;
//STRIP001     if( eCurLanguage == GetAppLanguage() )
//STRIP001         bSysLang = TRUE;
//STRIP001     ULONG nNumFormatForLanguage = pFormatter->GetFormatForLanguageIfBuiltIn(nSysNumFmt, LANGUAGE_SYSTEM );
//STRIP001     ULONG nShortDateFormatForLanguage = pFormatter->GetFormatForLanguageIfBuiltIn(nSysShortDateFmt, LANGUAGE_SYSTEM );
//STRIP001     ULONG nLongDateFormatForLanguage = pFormatter->GetFormatForLanguageIfBuiltIn(nSysLongDateFmt, LANGUAGE_SYSTEM );
//STRIP001 
//STRIP001     if(nDefFmt == nSysNumFmt||
//STRIP001         nDefFmt == nSysShortDateFmt||
//STRIP001         nDefFmt == nSysLongDateFmt||
//STRIP001         bSysLang && (nDefFmt == nNumFormatForLanguage ||
//STRIP001         nDefFmt == nShortDateFormatForLanguage ||
//STRIP001         nDefFmt == nLongDateFormatForLanguage ))
//STRIP001         sValue += String(SW_RES(RID_STR_SYSTEM));
//STRIP001 
//STRIP001     nPos = InsertEntry(sValue, nPos);   // Als ersten numerischen Eintrag einfuegen
//STRIP001     SetEntryData(nPos, (void*)nDefFmt);
//STRIP001     SelectEntryPos(nPos);
//STRIP001 	nDefFormat = GetFormat();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 ULONG NumFormatListBox::GetFormat() const
//STRIP001 {
//STRIP001 	USHORT nPos = GetSelectEntryPos();
//STRIP001 
//STRIP001 	return (ULONG)GetEntryData(nPos);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 const String& NumFormatListBox::GetFormatStr() const
//STRIP001 {
//STRIP001 	return aEmptyStr;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( NumFormatListBox, SelectHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	USHORT nPos = pBox->GetSelectEntryPos();
//STRIP001 	String sDefine(SW_RES( STR_DEFINE_NUMBERFORMAT ));
//STRIP001 	SwView *pView = GetView();
//STRIP001 
//STRIP001 	if( pView && nPos == pBox->GetEntryCount() - 1 &&
//STRIP001 		pBox->GetEntry( nPos ) == sDefine )
//STRIP001 	{
//STRIP001 		SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001 		SvNumberFormatter* pFormatter = rSh.GetNumberFormatter();
//STRIP001 
//STRIP001 		SfxItemSet aCoreSet( rSh.GetAttrPool(),
//STRIP001 			SID_ATTR_NUMBERFORMAT_VALUE, SID_ATTR_NUMBERFORMAT_VALUE,
//STRIP001 			SID_ATTR_NUMBERFORMAT_INFO, SID_ATTR_NUMBERFORMAT_INFO,
//STRIP001 			SID_ATTR_NUMBERFORMAT_ONE_AREA, SID_ATTR_NUMBERFORMAT_ONE_AREA,
//STRIP001 			SID_ATTR_NUMBERFORMAT_NOLANGUAGE, SID_ATTR_NUMBERFORMAT_NOLANGUAGE,
//STRIP001             SID_ATTR_NUMBERFORMAT_ADD_AUTO, SID_ATTR_NUMBERFORMAT_ADD_AUTO, 
//STRIP001 			0 );
//STRIP001 
//STRIP001 		double fValue = GetDefValue( pFormatter, nCurrFormatType);
//STRIP001 
//STRIP001 		ULONG nFormat = pFormatter->GetStandardFormat( nCurrFormatType, eCurLanguage);
//STRIP001 		aCoreSet.Put( SfxUInt32Item( SID_ATTR_NUMBERFORMAT_VALUE, nFormat ));
//STRIP001 
//STRIP001 		aCoreSet.Put( SvxNumberInfoItem( pFormatter, fValue,
//STRIP001 											SID_ATTR_NUMBERFORMAT_INFO ) );
//STRIP001 
//STRIP001 		if( (NUMBERFORMAT_DATE | NUMBERFORMAT_TIME) & nCurrFormatType )
//STRIP001 			aCoreSet.Put(SfxBoolItem(SID_ATTR_NUMBERFORMAT_ONE_AREA, bOneArea));
//STRIP001 
//STRIP001         aCoreSet.Put(SfxBoolItem(SID_ATTR_NUMBERFORMAT_NOLANGUAGE, !bShowLanguageControl));
//STRIP001         aCoreSet.Put(SfxBoolItem(SID_ATTR_NUMBERFORMAT_ADD_AUTO, bUseAutomaticLanguage));
//STRIP001 
//STRIP001 		SwNumFmtDlg* pDlg = new SwNumFmtDlg(this, aCoreSet);
//STRIP001 
//STRIP001 		if (RET_OK == pDlg->Execute())
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pItem = pView->GetDocShell()->
//STRIP001 							GetItem( SID_ATTR_NUMBERFORMAT_INFO );
//STRIP001 
//STRIP001 			if( pItem && 0 != ((SvxNumberInfoItem*)pItem)->GetDelCount() )
//STRIP001 			{
//STRIP001 				const ULONG* pDelArr = ((SvxNumberInfoItem*)pItem)->GetDelArray();
//STRIP001 
//STRIP001 				for ( USHORT i = 0; i < ((SvxNumberInfoItem*)pItem)->GetDelCount(); i++ )
//STRIP001 					pFormatter->DeleteEntry( pDelArr[i] );
//STRIP001 			}
//STRIP001 
//STRIP001             const SfxItemSet* pOutSet = pDlg->GetOutputItemSet();
//STRIP001             if( SFX_ITEM_SET == pOutSet->GetItemState(
//STRIP001 				SID_ATTR_NUMBERFORMAT_VALUE, FALSE, &pItem ))
//STRIP001 			{
//STRIP001                 UINT32 nFormat = ((SfxUInt32Item*)pItem)->GetValue();
//STRIP001 				// oj #105473# change order of calls
//STRIP001 				eCurLanguage = pFormatter->GetEntry(nFormat)->GetLanguage();
//STRIP001 				// SetDefFormat uses eCurLanguage to look for if this format already in the list
//STRIP001                 SetDefFormat(nFormat);                
//STRIP001 			}
//STRIP001             if( bShowLanguageControl && SFX_ITEM_SET == pOutSet->GetItemState(
//STRIP001                 SID_ATTR_NUMBERFORMAT_ADD_AUTO, FALSE, &pItem ))
//STRIP001             {
//STRIP001                 bUseAutomaticLanguage = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001             }
//STRIP001         }
//STRIP001 		else
//STRIP001 			SetDefFormat(nFormat);
//STRIP001 
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 double NumFormatListBox::GetDefValue(SvNumberFormatter* pFormatter, const short nFormatType) const
//STRIP001 {
//STRIP001 	double fDefValue = 0.0;
//STRIP001 
//STRIP001 	switch (nFormatType)
//STRIP001 	{
//STRIP001 		case NUMBERFORMAT_DATE:
//STRIP001 		case NUMBERFORMAT_DATE|NUMBERFORMAT_TIME:
//STRIP001 			fDefValue = SVX_NUMVAL_DATE;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_TIME:
//STRIP001 			fDefValue = SVX_NUMVAL_TIME;
//STRIP001 			break;
//STRIP001 /*		{
//STRIP001 			String sValue("31.8.1997 16:57:34");
//STRIP001 			ULONG nFormat = pFormatter->GetStandardFormat(nFormatType, LANGUAGE_GERMAN);
//STRIP001 			pFormatter->IsNumberFormat( sValue, nFormat, fDefValue );
//STRIP001 		}
//STRIP001 		break;*/
//STRIP001 
//STRIP001 		case NUMBERFORMAT_TEXT:
//STRIP001 		case NUMBERFORMAT_UNDEFINED:
//STRIP001 		case NUMBERFORMAT_ENTRY_NOT_FOUND:
//STRIP001 			fDefValue = 0;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_CURRENCY:
//STRIP001 			fDefValue = SVX_NUMVAL_CURRENCY;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_PERCENT:
//STRIP001 			fDefValue = SVX_NUMVAL_PERCENT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NUMBERFORMAT_LOGICAL:
//STRIP001 			fDefValue = SVX_NUMVAL_BOOLEAN;
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			fDefValue = SVX_NUMVAL_STANDARD;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return fDefValue;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void NumFormatListBox::Clear()
//STRIP001 {
//STRIP001 	ListBox::Clear();
//STRIP001 	nCurrFormatType = -1;
//STRIP001 }

}
