/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_linepolypolygon.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:28:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <canvas/canvastools.hxx>

#include <dx_linepolypolygon.hxx>

#ifndef _BGFX_TOOLS_CANVASTOOLS_HXX
#include <basegfx/tools/canvastools.hxx>
#endif

using namespace ::com::sun::star;

namespace dxcanvas
{

    LinePolyPolygon::LinePolyPolygon( 
		const uno::Sequence< uno::Sequence< geometry::RealPoint2D > >& points ) 
	:   ::canvas::tools::LinePolyPolygonBase( ::basegfx::unotools::polyPolygonFromPoint2DSequenceSequence( points ) ),
		mpGdiPlusUser( GDIPlusUser::createInstance() ),
        mpPath( tools::graphicsPathFromRealPoint2DSequence( points ) )
    {
    }

    LinePolyPolygon::~LinePolyPolygon()
    {
    }

    void SAL_CALL LinePolyPolygon::addPolyPolygon( 
		const geometry::RealPoint2D& position, 
        const uno::Reference< rendering::XPolyPolygon2D >& polyPolygon ) throw (uno::RuntimeException)
    {
		// call parent
		::canvas::tools::LinePolyPolygonBase::addPolyPolygon(position, polyPolygon );

		// TODO
    }

    void SAL_CALL LinePolyPolygon::setFillRule( rendering::FillRule fillRule ) throw (uno::RuntimeException)
    {
		// call parent
		::canvas::tools::LinePolyPolygonBase::setFillRule(fillRule);

        // TODO
    }

    void SAL_CALL LinePolyPolygon::setClosed( 
		sal_Int32 index, 
        sal_Bool 	closedState ) throw (uno::RuntimeException)
    {
		// call parent
		::canvas::tools::LinePolyPolygonBase::setClosed(index, closedState);

		// TODO
    }

    void SAL_CALL LinePolyPolygon::setPoints( 
		const uno::Sequence< uno::Sequence< geometry::RealPoint2D > >& points, 
        sal_Int32 nPolygonIndex, 
        sal_Int32 nPointIndex ) throw (uno::RuntimeException)
    {
		// call parent
		::canvas::tools::LinePolyPolygonBase::setPoints(points, nPolygonIndex, nPointIndex);

		// TODO
        mpPath = tools::graphicsPathFromRealPoint2DSequence( points );
    }

    void SAL_CALL LinePolyPolygon::setPoint( 
		const geometry::RealPoint2D& point, 
        sal_Int32 nPolygonIndex, 
        sal_Int32 nPointIndex ) throw (uno::RuntimeException)
    {
		// call parent
		::canvas::tools::LinePolyPolygonBase::setPoint(point, nPolygonIndex, nPointIndex);

		// TODO
    }

    ::rtl::OUString SAL_CALL LinePolyPolygon::getImplementationName() throw (uno::RuntimeException)
    {
        return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( LINEPOLYPOLYGON_IMPLEMENTATION_NAME ) );
    }

#define SERVICE_NAME "com.sun.star.rendering.LinePolyPolygon"

    sal_Bool SAL_CALL LinePolyPolygon::supportsService( const ::rtl::OUString& ServiceName ) throw (uno::RuntimeException)
    {
        return ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM ( SERVICE_NAME ) );
    }

    uno::Sequence< ::rtl::OUString > SAL_CALL LinePolyPolygon::getSupportedServiceNames(  ) throw (uno::RuntimeException)
    {
        uno::Sequence< ::rtl::OUString > aRet(1);
        aRet[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME ) );

        return aRet;
    }

    GraphicsPathSharedPtr LinePolyPolygon::getGraphicsPath() const
    {
        return mpPath;
    }
}

// eof
