/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_texture.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:33:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <dx_texture.hxx>

namespace dxcanvas
{
	/* Implementation of Dx_Texture class */

    Texture::Texture( const COMReference<IDirectDrawSurface>& 	rDDSurface,
                      const COMReference<IDirect3DTexture2>& 	rD3DTexture,
                      const ::basegfx::B2IRectangle&			rTextureRect,
                      const ::basegfx::B2ISize&					rTextureTotalSize,
                      const ::basegfx::B2ISize&					rTextureScreenSize,
                      bool										bIsShared ) :
        mpSurface( rDDSurface ),
        mpTexture( rD3DTexture ),
        maTextureRect( rTextureRect ),
        maTextureTotalSize( rTextureTotalSize ),
        maTextureScreenSize( rTextureScreenSize ),
        mbIsShared( bIsShared )
    {
    }

    Texture::~Texture()
    {
    }

    SurfaceGraphicsSharedPtr Texture::getGraphics()
    {
        return SurfaceGraphicsSharedPtr( new SurfaceGraphics( mpSurface ) );
    }

    bool Texture::contentLost() const
    {
        if( mpSurface.is() )
            return const_cast<Texture*>(this)->mpSurface->IsLost() == DDERR_SURFACELOST;

        // TODO(F1): Somehow, try to handle the case 'desktop resolution
        // change' in windowed mode. We then have to recreate all
        // surfaces

        return false;
    }
    
    ::basegfx::B1DRange Texture::calcURange() const
    {
        return ::basegfx::B1DRange( (double)maTextureRect.getMinX() / maTextureTotalSize.getX(),
                                    (double)maTextureRect.getMaxX() / maTextureTotalSize.getX() );
    }
    
    ::basegfx::B1DRange Texture::calcVRange() const
    {
        return ::basegfx::B1DRange( (double)maTextureRect.getMinY() / maTextureTotalSize.getY(),
                                    (double)maTextureRect.getMaxY() / maTextureTotalSize.getY() );
    }

}
