/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: packer2.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:49:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROGRESSHANDLER_HPP_
#include <com/sun/star/ucb/XProgressHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

class INetURLObject;

/* *******************************************************************\
  
	file format for packer files
  
	[File Header]
	ULONG	ID				'SZIP' for fast file verification
	USHORT	Version			Version that is needed to extract this archive
	USHORT	Disk			Number of this disk in a spanned disk set
	USHORT	MaxDisk			Number of disks in a spanned disk set
	ULONG	UID				Unique ID for this spanned disk set to
							verify that other files belong to this set
  
	[Directory Header]
	USHORT	Files			Number of files in this archive
	Local File Header...	A Local File Header for each file in this
							archive
  
	[Local File Header]
	USHORT	Disk			The number of the disk this file starts on
	ULONG	Offset			The offset of this file on that disk
	USHORT	Compression		Compression method
	ULONG	Size			The Size of this file
	ULONG	CompressedSize	The Size of this file compressed
	USHORT	NameLenght		The Length of the file name in bytes
	n*USHORT	FileName	The Filename as a unicode string

	each file in a set starts with a [File Header]. Only on the first
	file it is followed by an [Directory Header].
  
\* ******************************************************************/

const ULONG PACK_ID = ((('S' << 8 | 'Z' ) << 8 | 'I' ) << 8 | 'P' );
const USHORT HEADER_SIZE = 2*sizeof( ULONG ) + 3*sizeof( USHORT );

class LocalFileHeader
{
private:
	USHORT	m_nCompression;		// compression method

	ULONG	m_nCompressedSize;	// compressed size
	ULONG	m_nUnCompressedSize;// uncompressed size

	::rtl::OUString	m_aFileName;		// name of this file;
	String	m_aSourcePath;

	USHORT	m_nDiskNumberStart;	// the disk where this file starts
	ULONG	m_nRelativeOffset;	// relative offset of local header

	void	init();
public:
	LocalFileHeader();
	LocalFileHeader( const LocalFileHeader& rFile );
	LocalFileHeader( const ::rtl::OUString& rFileName, ULONG nSize, USHORT nCompression = 0 );

	USHORT	getHeaderSize() const;
	ULONG	writeHeader( SvFileStream& rStrm ) const;
	ULONG	readHeader( SvFileStream& rStrm );

	::rtl::OUString	getFileName() const { return m_aFileName; }
	String	getSourcePath() const { return m_aSourcePath; }

	void	setCompressedSize( ULONG nSize ) { m_nCompressedSize = nSize; }
	ULONG	getCompressedSize() const { return m_nCompressedSize; }

	void	setUnCompressedSize( ULONG nSize ) { m_nUnCompressedSize = nSize; }
	ULONG	getUnCompressedSize() const { return m_nUnCompressedSize; }

	void	setDisk( USHORT nDisk ) { m_nDiskNumberStart = nDisk; }
	USHORT	getDisk() const { return m_nDiskNumberStart; }

	void	setOffset( ULONG nOffset ) { m_nRelativeOffset = nOffset; }
	ULONG	getOffset() const { return m_nRelativeOffset; }

	void	setCompression( USHORT nCompression ) { m_nCompression = nCompression; }
	USHORT	getCompression() const { return m_nCompression; }
	BOOL	isCompressed() const { return m_nCompression != 0; }
};

DECLARE_LIST( LocalFileHeaderList, LocalFileHeader* );

struct Packer_Recover
{
	USHORT	mnDisk;
	ULONG	mnFileSizeToGo;
	LocalFileHeader* mpHeader;
	ULONG	mnStartOffset;
	ULONG	mnProgress;
};

class UnoPacker_Impl
{
private:
	USHORT	m_nDisk;
	USHORT	m_nMaxDisk;
	ULONG	m_nUID;
	USHORT	m_nCompression;
	ULONG	mnProgress;
	ULONG	mnProgressBytes;

	BOOL	mbRemovable;		// is set to true if destination/source is a removable media
	BOOL	mbDynamic;
	ULONG	m_nDiskSize;
	::rtl::OUString	m_aRootDir;
	String	m_aTempFile;
	String	m_aOutFile;

	String maActualFile;		// source file for error context

	::rtl::OUString	m_aExtraData;

	LocalFileHeaderList	m_aFiles;

	Packer_Recover mRecover;

	::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionHandler > mxErrorHandler;
	::com::sun::star::uno::Reference< ::com::sun::star::ucb::XProgressHandler > mxProgressHandler;

	ULONG RequestDisk( INetURLObject& rURL, sal_Int32 nDisk );
	BOOL HandleError( ::com::sun::star::uno::Any& rAny, USHORT eContinuations );
	BOOL HandleError( ULONG nFileError, USHORT eContinuations );
	void UpdateProgress( ULONG nDeltaBytes );

	void reset();
	ULONG initDirectoryHeader( const ::com::sun::star::uno::Sequence< ::rtl::OUString >& input );
	ULONG packFiles();
	void CalculateFileOffsets();
	ULONG writeArchive( const ::rtl::OUString& destination, BOOL bRecover );
	ULONG WriteDynamicHeader( const ::rtl::OUString& destination );
	SvFileStream* createInputStream( LocalFileHeader* pHeader );
	void getParameter( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs ); 

	BOOL readHeaders( const ::rtl::OUString& source );
	ULONG readHeader( SvFileStream& rStream, ULONG& nPID, USHORT &nVersion, USHORT &nDisk, USHORT& nMaxDisk, ULONG& nID );
	ULONG readFileHeader( SvFileStream& rStream );
	ULONG unpackArchive( const ::rtl::OUString& source );
	SvFileStream* createOutputStream( LocalFileHeader* pHeader );

public:
	UnoPacker_Impl( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs );
	~UnoPacker_Impl();

	sal_Bool pack( const ::com::sun::star::uno::Sequence< ::rtl::OUString >& input, const ::rtl::OUString& destination );
	sal_Bool unpack( const ::rtl::OUString& source, const ::rtl::OUString& destinationpath, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& files );

	::rtl::OUString getExtraData( const ::rtl::OUString& source );
	::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess > getContent( const ::rtl::OUString& source );
};

/*
** this class implements the index access to an archive content
*/

#include <cppuhelper/implbase2.hxx> 

class UnoArchiveContent : public ::cppu::WeakAggImplHelper2< ::com::sun::star::container::XIndexAccess, ::com::sun::star::lang::XServiceInfo >
{
private:
	LocalFileHeaderList	m_aFiles;

public:
	UnoArchiveContent() throw() {};
	UnoArchiveContent( const LocalFileHeaderList& rFiles ) throw();
	virtual ~UnoArchiveContent() throw();

    // XServiceInfo
    ::rtl::OUString	SAL_CALL getImplementationName() throw();
    static ::rtl::OUString	getImplementationName_Static() throw()
                            {
								return ::rtl::OUString::createFromAscii("com.sun.star.extensions.ArchiverContent");
                            }
    sal_Bool SAL_CALL supportsService(const ::rtl::OUString& ServiceName) throw();
    ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(void) throw();
    static ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames_Static(void) throw();

	// XIndexAccess
    virtual sal_Int32 SAL_CALL getCount(void) throw(  ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Any SAL_CALL getByIndex(sal_Int32 Index) throw(  ::com::sun::star::uno::RuntimeException, ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException );

	// XElementAccess
    virtual ::com::sun::star::uno::Type SAL_CALL getElementType(void) throw(  ::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL hasElements(void) throw(  ::com::sun::star::uno::RuntimeException);
};


