/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: gdimtftools.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:26:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>
#include <gdimtftools.hxx>

#ifndef _COM_SUN_STAR_DOCUMENT_XEXPORTER_HPP_
#include <com/sun/star/document/XExporter.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XFILTER_HPP_
#include <com/sun/star/document/XFilter.hpp>
#endif
#ifndef _COM_SUN_STAR_GRAPHIC_XGRAPHIC_HPP_ 
#include <com/sun/star/graphic/XGraphic.hpp>
#endif
#ifndef _COM_SUN_STAR_GRAPHIC_XGRAPHICRENDERER_HPP_ 
#include <com/sun/star/graphic/XGraphicRenderer.hpp>
#endif

#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE1_HXX_
#include <cppuhelper/compbase1.hxx>
#endif

#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_METAACT_HXX
#include <vcl/metaact.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_GDIMTF_HXX 
#include <vcl/gdimtf.hxx>
#endif
#ifndef _SV_METAACT_HXX 
#include <vcl/metaact.hxx>
#endif
#ifndef _SV_ANIMATE_HXX
#include <vcl/animate.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif


using namespace ::com::sun::star;


// free support functions
// ======================

namespace presentation
{
    namespace internal 
    {
        namespace
        {
            // TODO(E2): Detect the case when svx/drawing layer is not
            // in-process, or even not on the same machine, and
            // fallback to metafile streaming!

#if 0
            // Conservative way: stream mtf in and out
            bool getMetaFile( const uno::Reference< lang::XComponent >& 	xSource, 
                              const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                              GDIMetaFile& 									rMtf,
                              bool											bVerboseComments,
                              bool 											bBackgroundOnly )
            {
                SvMemoryStream aStream( 1024, 1024 );
                uno::Reference< io::XOutputStream > xOut( new utl::OOutputStreamWrapper( aStream ) );
            
                // -> stuff that into UnoGraphicExporter.
                uno::Reference< lang::XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
                if( !xFactory.is() )
                    return false;

                // creating the graphic exporter
                uno::Reference< document::XExporter > xExporter( xFactory->createInstance( 
                                                                     rtl::OUString::createFromAscii("com.sun.star.drawing.GraphicExportFilter")), 
                                                                 uno::UNO_QUERY);
                uno::Reference< document::XFilter > xFilter( xExporter, uno::UNO_QUERY );

                if( !xExporter.is() || !xFilter.is() )
                    return false;

                uno::Sequence< beans::PropertyValue > aProps(3);
                aProps[0].Name = rtl::OUString::createFromAscii("FilterName");
                aProps[0].Value <<= rtl::OUString::createFromAscii("SVM");

                aProps[1].Name = rtl::OUString::createFromAscii("OutputStream");
                aProps[1].Value <<= xOut;

                uno::Sequence< beans::PropertyValue > aFilterData(4);
                aFilterData[0].Name = rtl::OUString::createFromAscii("VerboseComments");
                aFilterData[0].Value <<= bVerboseComments;

                aFilterData[1].Name = rtl::OUString::createFromAscii("ExportOnlyBackground");
                aFilterData[1].Value <<= bBackgroundOnly;

                aFilterData[2].Name = rtl::OUString::createFromAscii("Version");
                const sal_Int32 nVersion = SOFFICE_FILEFORMAT_50; 
                aFilterData[2].Value <<= nVersion; 

                aFilterData[3].Name = rtl::OUString::createFromAscii("CurrentPage");
                aFilterData[3].Value <<= uno::Reference< uno::XInterface >( xContainingPage,
                                                                            uno::UNO_QUERY_THROW );

                aProps[2].Name = rtl::OUString::createFromAscii("FilterData");
                aProps[2].Value <<= aFilterData;

                xExporter->setSourceDocument( xSource );
                xFilter->filter( aProps );

                xOut = NULL; // release wrapper
                aStream.Seek( STREAM_SEEK_TO_BEGIN ); // rewind

                aStream >> rMtf;
            
                return aStream.GetError() == 0;
            }
#else

            // For fixing #i48102#, have to be a _lot_ more selective
            // on which metafiles to convert to bitmaps. The problem
            // here is that we _always_ get the shape content as a
            // metafile, even if we have a bitmap graphic shape. Thus,
            // calling GetBitmapEx on such a Graphic (see below) will
            // result in one poorly scaled bitmap into another,
            // somewhat arbitrarily sized bitmap.
            bool hasUnsupportedActions( const GDIMetaFile& rMtf )
            {
                // search metafile for RasterOp action
                MetaAction* pCurrAct;

                // TODO(Q3): avoid const-cast
                for( pCurrAct = const_cast<GDIMetaFile&>(rMtf).FirstAction(); 
                     pCurrAct; 
                     pCurrAct = const_cast<GDIMetaFile&>(rMtf).NextAction() )
                {
                    switch( pCurrAct->GetType() )
                    {
                        case META_MOVECLIPREGION_ACTION:
                            // FALLTHROUGH intended
                        case META_RASTEROP_ACTION:
                            // FALLTHROUGH intended
                        case META_REFPOINT_ACTION:
                            // FALLTHROUGH intended
                        case META_WALLPAPER_ACTION:
                            // FALLTHROUGH intended
                        case META_TEXTRECT_ACTION:
                            return true; // at least one unsupported
                                         // action encountered
                    }
                }

                return false; // no unsupported action found
            }

            typedef ::cppu::WeakComponentImplHelper1< graphic::XGraphicRenderer > DummyRenderer_Base;

            class DummyRenderer : 
                public DummyRenderer_Base,
                public ::comphelper::OBaseMutex
            {
            public:
                DummyRenderer() : 
                    DummyRenderer_Base( m_aMutex ),
                    mxGraphic()
                {
                }

                //---  XGraphicRenderer  -----------------------------------
                virtual void SAL_CALL render( const uno::Reference< graphic::XGraphic >& rGraphic ) throw (uno::RuntimeException)
                {
                    ::osl::MutexGuard aGuard( m_aMutex );
                    mxGraphic = rGraphic;
                }

                /** Retrieve GDIMetaFile from renderer

                	@param bForeignSource
	                When true, the source of the metafile might be a
	                foreign application. The metafile is checked
	                against unsupported content, and, if necessary,
	                returned as a pre-rendererd bitmap.
                 */
                GDIMetaFile getMtf( bool bForeignSource ) const
                {
                    ::osl::MutexGuard aGuard( m_aMutex );
                    
                    Graphic aGraphic( mxGraphic );

                    if( aGraphic.GetType() == GRAPHIC_BITMAP ||
                        (bForeignSource && 
                         hasUnsupportedActions(aGraphic.GetGDIMetaFile()) ) )
                    {
                        // wrap bitmap into GDIMetafile
                        GDIMetaFile 	aMtf;
                        ::Point			aEmptyPoint;

                        ::BitmapEx		aBmpEx( aGraphic.GetBitmapEx() );

                        aMtf.AddAction( new MetaBmpExAction( aEmptyPoint,
                                                             aBmpEx ) );
                        aMtf.SetPrefSize( aBmpEx.GetPrefSize() );
                        aMtf.SetPrefMapMode( aBmpEx.GetPrefMapMode() );

                        return aMtf;
                    }
                    else
                    {
                        return aGraphic.GetGDIMetaFile();
                    }
                }

            private:
                // ref-counted UNO object, _we_ destroy ourselves
                virtual ~DummyRenderer();

                uno::Reference< graphic::XGraphic >	mxGraphic;
            };

            // outline, to have vtable generated here
            DummyRenderer::~DummyRenderer()
            {
            }

            // Quick'n'dirty way: tunnel Graphic (only works for
            // in-process slideshow, of course)
            bool getMetaFile( const uno::Reference< lang::XComponent >& 	xSource, 
                              const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                              GDIMetaFile& 									rMtf,
                              bool											bVerboseComments,
                              bool 											bBackgroundOnly,
                              bool											bForeignSource )
            {
                // create dummy XGraphicRenderer, which receives the
                // generated XGraphic from the GraphicExporter

                // TODO(P3): Move creation of DummyRenderer out of the
                // loop! Either by making it static, or transforming
                // the whole thing here into a class.
                DummyRenderer*						 		pRenderer( new DummyRenderer() );
                uno::Reference< graphic::XGraphicRenderer > xRenderer( pRenderer );

                // -> stuff that into UnoGraphicExporter.
                uno::Reference< lang::XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
                if( !xFactory.is() )
                    return false;

                // creating the graphic exporter
                uno::Reference< document::XExporter > xExporter( xFactory->createInstance( 
                                                                     rtl::OUString::createFromAscii("com.sun.star.drawing.GraphicExportFilter")), 
                                                                 uno::UNO_QUERY);
                uno::Reference< document::XFilter > xFilter( xExporter, uno::UNO_QUERY );

                if( !xExporter.is() || !xFilter.is() )
                    return false;

                uno::Sequence< beans::PropertyValue > aProps(3);
                aProps[0].Name = rtl::OUString::createFromAscii("FilterName");
                aProps[0].Value <<= rtl::OUString::createFromAscii("SVM");

                aProps[1].Name = rtl::OUString::createFromAscii("GraphicRenderer");
                aProps[1].Value <<= xRenderer;

                uno::Sequence< beans::PropertyValue > aFilterData(4);
                aFilterData[0].Name = rtl::OUString::createFromAscii("VerboseComments");
                aFilterData[0].Value <<= bVerboseComments;

                aFilterData[1].Name = rtl::OUString::createFromAscii("ExportOnlyBackground");
                aFilterData[1].Value <<= bBackgroundOnly;

                aFilterData[2].Name = rtl::OUString::createFromAscii("Version");
                const sal_Int32 nVersion = SOFFICE_FILEFORMAT_50; 
                aFilterData[2].Value <<= nVersion; 

                aFilterData[3].Name = rtl::OUString::createFromAscii("CurrentPage");
                aFilterData[3].Value <<= uno::Reference< uno::XInterface >( xContainingPage,
                                                                            uno::UNO_QUERY_THROW );

                aProps[2].Name = rtl::OUString::createFromAscii("FilterData");
                aProps[2].Value <<= aFilterData;

                xExporter->setSourceDocument( xSource );
                if( !xFilter->filter( aProps ) )
                    return false;

                rMtf = pRenderer->getMtf( bForeignSource );

                // pRenderer is automatically destroyed when xRenderer
                // goes out of scope

                // TODO(E3): Error handling. Exporter might have
                // generated nothing, a bitmap, threw an exception,
                // whatever.
                return true;
            }
#endif
        }

        bool getMetaFile( const uno::Reference< drawing::XShape >& 		xShape, 
                          const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                          GDIMetaFile& 									o_rMtf,
                          bool											bVerboseComments,
                          bool											bForeignSource )
        {
            return getMetaFile( uno::Reference< lang::XComponent >( 
                                    xShape,
                                    uno::UNO_QUERY ),
                                xContainingPage,
                                o_rMtf,
                                bVerboseComments,
                                false,
                                bForeignSource );
        }

        bool getBackgroundMetaFile( const uno::Reference< drawing::XDrawPage >& xPage, 
                                    const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                                    GDIMetaFile& 							    o_rMtf,
                                    bool									    bVerboseComments,
                                    bool										bForeignSource )
        {
            return getMetaFile( uno::Reference< lang::XComponent >( 
                                    xPage,
                                    uno::UNO_QUERY ),
                                xContainingPage,
                                o_rMtf,
                                bVerboseComments,
                                true,
                                bForeignSource );
        }

        void removeTextActions( GDIMetaFile& rMtf )
        {
            // search metafile for text output
            MetaAction* pCurrAct;

            int nActionIndex(0);
            pCurrAct = rMtf.FirstAction(); 
            while( pCurrAct )
            {
                switch( pCurrAct->GetType() )
                {
                    case META_TEXTCOLOR_ACTION:
                    case META_TEXTFILLCOLOR_ACTION:
                    case META_TEXTLINECOLOR_ACTION:
                    case META_TEXTALIGN_ACTION:
                    case META_FONT_ACTION:
                    case META_LAYOUTMODE_ACTION:
                    case META_TEXT_ACTION:
                    case META_TEXTARRAY_ACTION:
                    case META_TEXTRECT_ACTION:
                    case META_STRETCHTEXT_ACTION:
                    case META_TEXTLINE_ACTION:
                    {
                        // remove every text-related actions
                        pCurrAct = rMtf.NextAction();

                        rMtf.RemoveAction( nActionIndex );
                        break;
                    }

                    default:
                        pCurrAct = rMtf.NextAction();
                        ++nActionIndex;
                        break;
                }
            }
        }

        bool getAnimationFromGraphic( VectorOfMtfAnimationFrames& o_rFrames,
                                      const Graphic&			  rGraphic )
        {
            o_rFrames.clear();

            if( !rGraphic.IsAnimated() )
                return false;

            // some loop invariants
            Animation 	aAnimation( rGraphic.GetAnimation() );            
            const Point aEmptyPoint;
            const Size  aAnimSize( aAnimation.GetDisplaySizePixel() );              

            // setup alpha VDev, into which all bitmaps are painted
            // (want to normalize animations to n bitmaps of same
            // size. An Animation, though, can contain bitmaps of
            // varying sizes and different update modes)
            VirtualDevice aVDev( *::Application::GetDefaultDevice(), 0, 0 );
            aVDev.SetOutputSizePixel( aAnimSize );
            aVDev.EnableMapMode( FALSE );

            // setup alpha VDev, from which potential background
            // restores are performed
            VirtualDevice aRestoreVDev( *::Application::GetDefaultDevice(), 0, 0 );
            aRestoreVDev.SetOutputSizePixel( aAnimSize );
            aRestoreVDev.EnableMapMode( FALSE );

            Disposal eLastDisposal( DISPOSE_BACK );

            for( USHORT i=0, nCount=aAnimation.Count(); i<nCount; ++i )
            {
                // potentially restore vdev background from
                // aRestoreVDev
                if( eLastDisposal != DISPOSE_BACK &&
                    eLastDisposal != DISPOSE_NOT )
                {
                    aRestoreVDev.DrawOutDev( aEmptyPoint, 
                                             aAnimSize, 
                                             aEmptyPoint, 
                                             aAnimSize, 
                                             aVDev );
                }

                const AnimationBitmap& rAnimBmp( aAnimation.Get(i) );

                aVDev.DrawBitmapEx( rAnimBmp.aPosPix, 
                                    rAnimBmp.aSizePix, 
                                    rAnimBmp.aBmpEx );

                // extract current aVDev content into a new animation
                // frame
                GDIMetaFileSharedPtr pMtf( new GDIMetaFile() );
                pMtf->AddAction( 
                    new MetaBmpExAction( aEmptyPoint,
                                         aVDev.GetBitmapEx(
                                             aEmptyPoint,
                                             aAnimSize ) ) );

                // setup mtf dimensions and pref map mode (for
                // simplicity, keep it all in pixel. the metafile
                // renderer scales it down to (1, 1) box anyway)
                pMtf->SetPrefMapMode( MapMode() );
                pMtf->SetPrefSize( aAnimSize );

                o_rFrames.push_back( MtfAnimationFrame( pMtf,
                                                        rAnimBmp.nWait / 1000.0 ) );

                // restore background, if requested
                if( DISPOSE_NOT != rAnimBmp.eDisposal )
                {
                    if( DISPOSE_BACK == rAnimBmp.eDisposal )
                    {
                        // restore original background -> clear VDev
                        aVDev.Erase();
                    }
                    else
                    {
                        // restore previously saved frame
                        aVDev.DrawOutDev( aEmptyPoint, 
                                          aAnimSize, 
                                          aEmptyPoint, 
                                          aAnimSize, 
                                          aRestoreVDev );
                    }
                }
                
                eLastDisposal = rAnimBmp.eDisposal;
            }

            return !o_rFrames.empty();
        }
    }
}

