/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: i_array.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:23:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_ARRAY_HXX
#define UDM_ARRAY_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/accessor.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/object.hxx>


namespace udm
{

class Array : public Data
{
  protected:

  public:
    class iterator
    {
      public:
                        iterator(
                            DYN iterator_impl & let_drImpl );
                        iterator(
                            const iterator &    i_rIter );

        // OPERATORS
        iterator &      operator=(
                            const iterator &    i_rIter );
        Object          operator*() const;
        iterator &      operator++();

      private:
        Dyn<iterator_impl>
                        pi;
    };

    // LIFECYCLE
    virtual             ~Array() {}

    // OPERATORS
    Object              operator[](
                            int                 i_nIndex ) const;
    // OPERATIONS
    void                erase();
    void                add(
                            DYN Data &          let_drData );
    // INQUIRY
    uintt               size() const;
    Object              front() const;

    iterator            begin() const;
    iterator            end() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    // Locals
    virtual void        do_erase() = 0;
    virtual void        do_add(
                            DYN Data &          let_drData ) = 0;
    virtual uintt       inq_Size() const = 0;
};



inline Object
Array::operator[]( int i_nIndex ) const
    { csv_assert(false); return Object(); }




}   // namespace udm


#endif

