/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: binarystream.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:35:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/binarystream.hxx>

// NOT FULLY DEFINED SERVICES


namespace udm
{

Data::accessor_type
BinaryStream::inq_Type() const
{
 	return t_BStream;
}

Data::description
BinaryStream::inq_TypeDescription() const
{
 	return Data::description("B");
}






//*********************       BinaryStream_Null      *******************//

class BinaryStream_Null : public BinaryStream
{
  public:
    virtual             ~BinaryStream_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    // BinaryStream:
    virtual const csv::bostream &
                        inq_GetStream() const;
};

BinaryStream_Null::~BinaryStream_Null()
{
}

void                BinaryStream_Null::do_Dispose() { }
void                BinaryStream_Null::do_BinWrite( csv::bostream & ) const    {}


const csv::bostream &
BinaryStream_Null::inq_GetStream() const
{
    static const csv::StreamStr aNull_(1);
 	return aNull_;
}


template <>
BinaryStream &
get_null<BinaryStream>( csv::Type2Type<BinaryStream> )
{
    static BinaryStream * pNull_ = new BinaryStream_Null;
    return *pNull_;
}




}   // namespace udm

 
