/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unmarshal.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:13:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _BRIDGES_REMOTE_UNMARSHAL_HXX_
#define _BRIDGES_REMOTE_UNMARSHAL_HXX_

#include <com/sun/star/uno/Sequence.hxx>
#include <uno/data.h>

#include <bridges/remote/remote.h>
#include <bridges/remote/context.h>
#include <bridges/remote/helper.hxx>

typedef struct _uno_Environment uno_Environment;
struct remote_Interface;

namespace bridges_remote
{


class Unmarshal
{
public:
	Unmarshal( const sal_Int8 *pMem ,
			   sal_Int32 nLength ,
			   sal_Bool bIsLittleEndian,
			   uno_Environment *pEnvRemote = 0,
			   remote_createStubFunc callback = 0);
	
	sal_Bool unpackAndDestruct( void *pDest , const ::com::sun::star::uno::Type &rType );
	sal_Bool unpackAndDestruct( void *pDest , typelib_TypeDescription *pType );
	sal_Bool unpack( void *pDest , typelib_TypeDescription *pType );

	inline sal_Int32 getPos()
		{ return (m_pos - m_base); }
private:
	void align( sal_Int32 nAlignTo );
	inline sal_Bool checkAdditionalMem( sal_Int32 nNextMemToExpand );

	const sal_Int8 *const m_base;
	const sal_Int8 *m_pos;
	sal_Int32 m_nLength;	
	sal_Bool m_bIsLittleEndian;
	remote_createStubFunc m_callback;
	uno_Environment *m_pEnvRemote;
};

inline sal_Bool Unmarshal::checkAdditionalMem( sal_Int32 nNextMemToExpand )
{
	return ( m_pos - m_base ) + nNextMemToExpand  <= m_nLength;
}

template < class C >
inline sal_Bool operator >>= (Unmarshal & r, C& value)
{
	return r.unpackAndDestruct( &value , getCppuType( &value ) );
}

}

#endif
