/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_surfacegraphics.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:31:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <dx_winstuff.hxx>
#include <dx_impltools.hxx>
#include <dx_surfacegraphics.hxx>


namespace dxcanvas
{

    SurfaceGraphics::SurfaceGraphics( const COMReference<IDirectDrawSurface>& rSurface ) :
        maHdc( 0 ),
        mpSurface( rSurface ),
        mpGraphics( NULL )
    {
        if( !mpSurface.is() )
            return;

        if( FAILED(mpSurface->GetDC( &maHdc )) )
            return;

        mpGraphics = Gdiplus::Graphics::FromHDC( maHdc );

        if( mpGraphics )
            tools::setupGraphics( *mpGraphics );
    }

    SurfaceGraphics::SurfaceGraphics( Gdiplus::Graphics* pGraphics ) :
        maHdc( 0 ),
        mpSurface(),
        mpGraphics( pGraphics )
    {
    }

    SurfaceGraphics::~SurfaceGraphics()
    {
        if( mpGraphics != NULL )
            delete mpGraphics;
        
        if( maHdc != 0 &&
            mpSurface.is() != NULL )
        {
            mpSurface->ReleaseDC( maHdc );
        }
    }

}
