/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: WrapCatalog.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:56:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef CONNECTIVITY_ADO_WRAP_CATALOG_HXX
#define CONNECTIVITY_ADO_WRAP_CATALOG_HXX

#include "ado/WrapTypeDefs.hxx"

namespace connectivity
{
	namespace ado
	{
		class WpADOCatalog : public WpOLEBase<_ADOCatalog>
		{
		public:
			WpADOCatalog(_ADOCatalog* pInt = NULL)	:	WpOLEBase<_ADOCatalog>(pInt){}
			WpADOCatalog(const WpADOCatalog& rhs){operator=(rhs);}

			inline WpADOCatalog& operator=(const WpADOCatalog& rhs)
				{WpOLEBase<_ADOCatalog>::operator=(rhs); return *this;}

			::rtl::OUString GetObjectOwner(const ::rtl::OUString& _rName, ObjectTypeEnum _eNum);

			void putref_ActiveConnection(IDispatch* pCon);
			WpADOTables		get_Tables();
			WpADOViews		get_Views();
			WpADOGroups		get_Groups();
			WpADOUsers		get_Users();
			ADOProcedures*	get_Procedures();
			void Create();
		};
	}
}

#endif //CONNECTIVITY_ADO_WRAP_CATALOG_HXX
