#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.6 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 07:23:27 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
PRJNAME=sdk_oo
TARGET=unzip_odk

#----------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: $(PRJ)$/util$/makefile.pmk
#----------------------------------------------------------------

.IF "$(GUI)"=="WNT"
ODKPATH=$(ODKZIPPATH)$/$(ODKNAME).zip
.ELSE
ODKPATH=$(ODKZIPPATH)$/$(ODKNAME).tar.gz
.ENDIF

all: ..$/misc$/deltree.txt

..$/misc$/deltree.txt .SETDIR=$(OUT)$/bin : $(ODKPATH) ..$/..$/pack$/unzip_odk$/deltree.txt
# first clean everything
	+-$(MY_DELETE_RECURSIVE) $(PRODUCT_NAME) >& $(NULLDEV)
	+-rm -f $(ODKNAME).zip >& $(NULLDEV)
	+-rm -f $(ODKNAME).tar.gz >& $(NULLDEV)
	+-rm -f $(ODKNAME).tar >& $(NULLDEV)
	+-rm -f $(PRODUCT_NAME).zip >& $(NULLDEV)
	+-rm -f $(PRODUCT_NAME).tar.gz >& $(NULLDEV)
	+-rm -f $(PRODUCT_NAME).tar >& $(NULLDEV)
	+-rm -f ..$/misc$/$(CONVERTTAGFLAGNAME) >& $(NULLDEV)
	+-rm -f ..$/misc$/$(SDKCHECKFLAGNAME) >& $(NULLDEV)
.IF "$(GUI)"=="WNT"
	$(GNUCOPY) -p $(ODKPATH) $(ODKNAME).zip
	+-unzip -q -d . $(ODKNAME).zip
.ELSE
	$(GNUCOPY) -p $(ODKPATH) .
	+-gzip -d -f < $(ODKNAME).tar.gz | tar -xf -
.ENDIF
	+-$(RENAME) $(ODKNAME) $(PRODUCT_NAME)
	+-$(MY_DELETE_RECURSIVE) $(DESTDIRDOCU)$/DevelopersGuide
#	+rm -f $(DESTDIRDOCU)$/sdk_styles.css
#	+rm -f $(DESTDIRDOCUIMAGES)$/logo.gif
#	+rm -f $(DESTDIRDOCUIMAGES)$/sdk_logo.gif
#	+rm -f $(DESTDIRDOCUIMAGES)$/shadow_l.gif
#	+rm -f $(DESTDIRDOCUIMAGES)$/elements.jpg
	+-rm -f $(ODKNAME).zip >& $(NULLDEV)
	+-rm -f $(ODKNAME).tar.gz >& $(NULLDEV)
	+-rm -f $(ODKNAME).tar >& $(NULLDEV)
	@echo "" > ..$/misc$/deltree.txt
