/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: plugwin.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:58:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "plugwin.hxx"

#include <vcl/svapp.hxx>
#include <svtools/stritem.hxx>
#include <svtools/intitem.hxx>
#include <vcl/stdtext.hxx>
#include <tools/urlobj.hxx>
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
#include <com/sun/star/frame/XFrameActionListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HPP_
#include <com/sun/star/frame/FrameActionEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTION_HPP_
#include <com/sun/star/frame/FrameAction.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_PLUGIN_PLUGINMODE_HPP_
#include <com/sun/star/plugin/PluginMode.hpp>
#endif

#include <toolkit/helper/vclunohelper.hxx>

#include "docfile.hxx"
#include "docfilt.hxx"
#include "request.hxx"
#include "sfxsids.hrc"

void SfxPlugWindow_Impl::Resize()
{
	if ( xControl.is() )
	{
		Size aSize( GetOutputSizePixel() );
		::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >  xWin( xControl, ::com::sun::star::uno::UNO_QUERY );
		xWin->setPosSize( 0, 0, aSize.Width(), aSize.Height(), WINDOW_POSSIZE_ALL );
	}
}

SfxPlugWindow_Impl::SfxPlugWindow_Impl( Window *pParent )
	: Window( pParent )
	, nEventId( 0 )
{
//	nEventId = Application::PostUserEvent( LINK( this, SfxPlugWindow_Impl, StartPlugIn ), 0 );
}

SfxPlugWindow_Impl::~SfxPlugWindow_Impl()
{
	if ( xPlugin.is() )
	{
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >  xComp( xPlugin, ::com::sun::star::uno::UNO_QUERY );
		if ( xComp.is() )
			xComp->dispose();
		xPlugin = ::com::sun::star::uno::Reference< ::com::sun::star::plugin::XPlugin > ();
	}

	if ( xControl.is() )
	{
		::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >  xWin( xControl, ::com::sun::star::uno::UNO_QUERY );
		xWin->dispose();
	}

	if( nEventId )
	{
		Application::RemoveUserEvent( nEventId );
		nEventId = 0;
	}
}

void SfxPlugWindow_Impl::StartPlugin( const ::rtl::OUString& rURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs )
{
    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >  xMan = ::comphelper::getProcessServiceFactory();
	::com::sun::star::uno::Reference< ::com::sun::star::plugin::XPluginManager >  xPlugMgr( xMan->createInstance( DEFINE_CONST_UNICODE("com.sun.star.plugin.PluginManager") ), ::com::sun::star::uno::UNO_QUERY );
#if SUPD>564
	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >  xFact( xMan->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.DataSourceFactory") ), ::com::sun::star::uno::UNO_QUERY );
#else
	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >  xFact( xMan->createInstance( DEFINE_CONST_UNICODE("stardiv.one.frame.DataSourceFactory") ), ::com::sun::star::uno::UNO_QUERY );
#endif
	if ( xPlugMgr.is() && xFact.is() )
	{
		short nMode = ::com::sun::star::plugin::PluginMode::FULL;
		::rtl::OUString aMimeType;
		const ::com::sun::star::beans::PropertyValue* pProps = aArgs.getConstArray();
		long nLen = aArgs.getLength();
		long n;
		for ( n=0; n<nLen; n++ )
		{
			if ( pProps[n].Name.compareToAscii("ContentType")==0 )
				pProps[n].Value >>= aMimeType ;
			else if ( pProps[n].Name.compareToAscii("PluginMode")==0 )
				pProps[n].Value >>= nMode ;
		}

//		::com::sun::star::uno::Reference< ::com::sun::star::io::XActiveDataSource >  xSource = rMedium.GetDataSource();

		String aURL( rURL );
		::com::sun::star::uno::Sequence < ::com::sun::star::uno::Any > aArgs(1);
		aArgs.getArray()[0] <<= rURL ;
		String aProt( INetURLObject::GetScheme( INetURLObject( aURL ).GetProtocol() ) );
		::com::sun::star::uno::Reference< ::com::sun::star::io::XActiveDataSource >  xSource( xFact->createInstanceWithArguments( aProt , aArgs ), ::com::sun::star::uno::UNO_QUERY );

		::com::sun::star::uno::Reference< ::com::sun::star::plugin::XPluginContext >  xCtx = xPlugMgr->createPluginContext();
		::com::sun::star::uno::Sequence< ::com::sun::star::plugin::PluginDescription > aDescr = xPlugMgr->getPluginDescriptions();
		const ::com::sun::star::plugin::PluginDescription *pArr = aDescr.getConstArray();
		nLen = aDescr.getLength();
		for ( n=0; n<aDescr.getLength(); n++ )
		{
			::rtl::OUString aMime = pArr[n].Mimetype;
			if ( aMimeType == aMime )
			{
				const ::com::sun::star::uno::Sequence < ::rtl::OUString> noargs;
				xPlugin = xPlugMgr->createPlugin( xCtx, nMode, noargs, noargs, pArr[n] );
				xControl = ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > ( xPlugin, ::com::sun::star::uno::UNO_QUERY );
#if SUPD > 582
				com::sun::star::uno::Reference < class com::sun::star::awt::XWindowPeer > xTmp ( VCLUnoHelper::GetInterface(this), ::com::sun::star::uno::UNO_QUERY );
				xControl->createPeer( Application::GetVCLToolkit(), xTmp );
#endif
				::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >  xWin( xControl, ::com::sun::star::uno::UNO_QUERY );
				Resize();
				xWin->setVisible( sal_True );
				xPlugin->provideNewStream( aMime, xSource, rURL, 0l, 0l, sal_False );
				break;
			}
		}

		DBG_ASSERT( xPlugin.is(), "RegisterPlugin ging daneben" );
	}
	else
		ShowServiceNotAvailableError( NULL, DEFINE_CONST_UNICODE("PluginManager"), sal_True );

	// StatusText vom Plugin wieder loeschen
	GetpApp()->HideStatusText();
}

IMPL_LINK( SfxAsyncServiceErrorHandler_Impl, TimerHdl, Timer*, pTimer )
{
	aTimer.Stop();
	ShowServiceNotAvailableError( NULL, aService, sal_True );
	delete this;
	return 0L;
}

SFX_IMPL_XINTERFACE_1( PluginLoader, OWeakObject, ::com::sun::star::frame::XFrameLoader )
SFX_IMPL_XTYPEPROVIDER_1( PluginLoader, ::com::sun::star::frame::XFrameLoader )
SFX_IMPL_XSERVICEINFO( PluginLoader, "com.sun.star.frame.FrameLoader", "com.sun.star.comp.sfx2.PluginLoader" )
SFX_IMPL_SINGLEFACTORY( PluginLoader )

// -----------------------------------------------------------------------
PluginLoader::PluginLoader( com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory > const & )
{
	DBG_ERRORFILE( "NIJ" );
}

// -----------------------------------------------------------------------
PluginLoader::~PluginLoader()
{}

// -----------------------------------------------------------------------
void PluginLoader::load (	const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > &					rFrame		,
								const ::rtl::OUString&						rURL		,
								const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >&	rArgs		,
								const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XLoadEventListener > &		rListener	) throw ( ::com::sun::star::uno::RuntimeException )
{
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >  aWindow = rFrame->getContainerWindow () ;
	if ( aWindow.is() )
	{
		SfxPlugWindow_Impl* pWindow = new SfxPlugWindow_Impl( VCLUnoHelper::GetWindow(aWindow) );
        rFrame->setComponent( ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow > ( pWindow->GetComponentInterface(), ::com::sun::star::uno::UNO_QUERY ), ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController > () );
		rFrame->setComponent( aWindow, ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >() );
		pWindow->StartPlugin( rURL, rArgs );
		if ( rListener.is() )
			rListener->loadFinished( this );
	}
	else if ( rListener.is() )
		rListener->loadCancelled( this );
}

// -----------------------------------------------------------------------

void PluginLoader::cancel(void) throw ( ::com::sun::star::uno::RuntimeException )
{
}
