/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: bmkmenu.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:17:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "bmkmenu.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _SFXAPP_HXX
#include <app.hxx>
#endif
#include <tools/urlobj.hxx>
#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#include <svtools/pathoptions.hxx>
#include <svtools/internaloptions.hxx>
#include <unotools/localfilehelper.hxx>

#include "viewfrm.hxx"
#include "accmgr.hxx"
#include "frame.hxx"
#include "sfxresid.hxx"
#include "helper.hxx"

#include "menu.hrc"

#define INTERNETSHORTCUT_EXT			"url"
#define INTERNETSHORTCUT_ID_TAG			"InternetShortcut"
#define INTERNETSHORTCUT_URL_TAG		"URL"
#define INTERNETSHORTCUT_PASS_TAG		"Password"
#define INTERNETSHORTCUT_TITLE_TAG		"Title"
#define INTERNETSHORTCUT_TARGET_TAG		"Target"
#define INTERNETSHORTCUT_FOLDER_TAG		"Folder"
#define INTERNETSHORTCUT_FRAME_TAG		"Frame"
#define INTERNETSHORTCUT_BROWSER_TAG	"Browser"
#define INTERNETSHORTCUT_OPENAS_TAG		"OpenAs"
#define INTERNETSHORTCUT_TEMPLATE_TAG	"Template"
#define INTERNETSHORTCUT_DEFTEMPL_TAG	"DefaultTemplate"
#define INTERNETSHORTCUT_DEFURL_TAG		"DefaultURL"
#define INTERNETSHORTCUT_SOICON_TAG		"SOIcon"

#define URLFILE_CHARSET               CHARSET_ANSI

void ReadURLFile
(
    const String& rFile,
    String&	rTitle,
    String&	rURL,
    String&	rFrame,
    BOOL*	pShowAsFolder,
	USHORT&	rImageId,
    String* pOpenAs=0,
    String* pDefTempl=0,
    String* pDefURL=0
);

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;

DECLARE_LIST( SfxBmkMenuList, SfxBmkMenu* );

class SfxBmkMenu_Impl
{
private:
	static USHORT		_nMID;

public:

    String               _aURL;
    String               _aReferer;
    SfxBmkMenuList       _aSubMenuList;
    SfxBmkMenu*          _pRoot;
    BOOL                 _bInitialized;
    BOOL                 _bActivated;

    SfxBmkMenu_Impl( const String& rURL, SfxBmkMenu* pRoot );
    SfxBmkMenu_Impl( const String& rURL, const String& rReferer );
    ~SfxBmkMenu_Impl();

	static USHORT		GetMID();
	static String		GetTitle( const String& rTitle );
};

USHORT SfxBmkMenu_Impl::_nMID = BMKMENU_ITEMID_START;

SfxBmkMenu_Impl::SfxBmkMenu_Impl( const String& rURL, SfxBmkMenu* pRoot ) :
	_aURL(rURL),
	_pRoot(pRoot),
	_bInitialized(FALSE),
    _bActivated( FALSE )
{
}

SfxBmkMenu_Impl::SfxBmkMenu_Impl( const String& rURL, const String& rReferer ) :
	_aURL(rURL),
	_pRoot(0),
	_aReferer( rReferer ),
	_bInitialized(FALSE),
    _bActivated( FALSE )
{
}

SfxBmkMenu_Impl::~SfxBmkMenu_Impl()
{
	ULONG nCount = _aSubMenuList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
		delete _aSubMenuList.GetObject( n );
}

USHORT SfxBmkMenu_Impl::GetMID()
{
	_nMID++;
	if( !_nMID )
        _nMID = BMKMENU_ITEMID_START;
	return _nMID;
}

String SfxBmkMenu_Impl::GetTitle( const String& rStr )
{
	// "_..._" vorne rausschneiden
	String aTitle( rStr );
    if ( aTitle.Len() && aTitle.GetChar(0) == 0x005f)
	{
		aTitle.Erase( 0, 1 );
        while ( aTitle.Len() && aTitle.GetChar(0) != 0x005f )
			aTitle.Erase( 0, 1 );
		if ( aTitle.Len() )
			aTitle.Erase( 0, 1 );
		else
			aTitle = rStr;
	}

	return aTitle;
}

// ------------------------------------------------------------------------

ImageList* SfxBmkMenu::_pSmallImages = NULL;
ImageList* SfxBmkMenu::_pBigImages = NULL;

SfxBmkMenu::SfxBmkMenu( const String& rURL, SfxBmkMenu* pRoot )
{
    _pImp = new SfxBmkMenu_Impl( rURL, pRoot );
}

Image SfxBmkMenu::GetImage( USHORT nId, BOOL bBig )
{
	ImageList* pList = NULL;
	if ( bBig )
	{
		if ( !_pBigImages )
			_pBigImages = new ImageList( SfxResId( RID_IMGLST_BIG ) );
		pList = _pBigImages;
	}
	else
	{
		if ( !_pSmallImages )
			_pSmallImages = new ImageList( SfxResId( RID_IMGLST_SMALL ) );
		pList = _pSmallImages;
	}
	return pList->GetImage( nId );
}

SfxBmkMenu::SfxBmkMenu( const String& rURL, const String& rReferer )
{
    _pImp = new SfxBmkMenu_Impl( rURL, rReferer );
}

SfxBmkMenu::~SfxBmkMenu()
{
	delete _pImp;
}

void SfxBmkMenu::Activate()
{
	Initialize();
	_pImp->_bActivated = TRUE;
}

void SfxBmkMenu::Deactivate()
{
	PopupMenu::Deactivate();
	_pImp->_bActivated = FALSE;
}

void SfxBmkMenu::Select()
{
	String aURL( GetItemCommand( GetCurItemId() ) );
	if( !aURL.Len() )
		return;

    Reference < XFramesSupplier > xDesktop = Reference < XFramesSupplier >( ::comphelper::getProcessServiceFactory()->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Desktop") ), UNO_QUERY );
    Reference < XFrame > xFrame( xDesktop->getActiveFrame() );
    if ( !xFrame.is() )
        xFrame = Reference < XFrame >( xDesktop, UNO_QUERY );

    URL aTargetURL;
    aTargetURL.Complete = aURL;
    Reference < XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance( rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
    xTrans->parseStrict( aTargetURL );

    Reference < XDispatchProvider > xProv( xFrame, UNO_QUERY );
    Reference < XDispatch > xDisp;
	if ( xProv.is() )
        if ( aTargetURL.Protocol.compareToAscii("slot:") == COMPARE_EQUAL )
            xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
        else
            xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString::createFromAscii("_blank"), 0 );
    if ( xDisp.is() )
	{
        SfxBmkMenu* pRoot = _pImp->_pRoot;
        if( !pRoot )
            pRoot = this;

		Sequence<PropertyValue> aArgs(1);
		PropertyValue* pArg = aArgs.getArray();
		pArg[0].Name = rtl::OUString::createFromAscii("Referer");
        pArg[0].Value <<= (::rtl::OUString) pRoot->_pImp->_aReferer;
		xDisp->dispatch( aTargetURL, aArgs );
	}
}

void SfxBmkMenu::Initialize()
{
	if( _pImp->_bInitialized )
		return;

    _pImp->_bInitialized = TRUE;
    SfxAcceleratorManager* pAccMgr = SFX_APP()->GetAcceleratorManager();
    Sequence< ::rtl::OUString > aFiles = SfxContentHelper::GetFolderContents( _pImp->_aURL, sal_False, sal_True );
	const ::rtl::OUString* pFiles  = aFiles.getConstArray();
	UINT32 i, nCount = aFiles.getLength();
	for ( i = 0; i < nCount; ++i )
	{
		String aFileURL( pFiles[i] );
		INetURLObject aObj( aFileURL );

        String aTitle;
        String aURL;
        BOOL bShowAsFolder;
        String aFrame;
		USHORT nImageId = USHRT_MAX;

        ReadURLFile( aObj.GetMainURL( INetURLObject::NO_DECODE ), aTitle, aURL, aFrame, &bShowAsFolder, nImageId );

		if ( !aTitle.Len() && !aURL.Len() )
			continue;

		if ( aTitle.GetChar(0) == '_' && aTitle.GetChar(3) == '_' )
            aTitle = aTitle.Erase( 0, 4 );

        if( aURL.EqualsAscii("private:separator") )
			InsertSeparator();
		else
		{
			aURL = SvtPathOptions().SubstituteVariable( aURL );
            if ( aURL.CompareToAscii("private:factory/desktop") == 0 && SvtInternalOptions().IsRemoveMenuEntryNewWebtop() )
                continue;

            USHORT nId = CreateMenuId();
            if( !bShowAsFolder )
			{
                USHORT nTitleLen = aTitle.Len();
                if( nTitleLen > 4  && aTitle.GetChar(nTitleLen-4) == '.' && aURL.EqualsAscii( "file:",0,5 ) )
                    aTitle.Erase( nTitleLen-4 );
				Image aImage = GetImage( nImageId, FALSE );
                InsertItem( nId, aTitle, aImage );
                SetItemCommand( nId, aURL );
                if( aURL.EqualsIgnoreCaseAscii("slot:",0,5) )
                {
                    INetURLObject aURLObj( aURL );
                    KeyCode aKey(pAccMgr->GetKeyCode( aURLObj.GetURLPath().ToInt32() ) );
                    SetAccelKey( nId, aKey );
                }
            }
            else
            {
                InsertItem( nId, aTitle );
                SfxBmkMenu* pSubMenu = new SfxBmkMenu( aURL,
                        _pImp->_pRoot ? _pImp->_pRoot : this );
                _pImp->_aSubMenuList.Insert( pSubMenu, LIST_APPEND );
                SetPopupMenu( nId, pSubMenu );
            }
		}
	}
}

USHORT SfxBmkMenu::CreateMenuId()
{
    return SfxBmkMenu_Impl::GetMID();
}

String ReadURL_Impl( Config& rURLFile, const String& rFile )
{
	// read the URL from config file
    String aURL( String( rURLFile.ReadKey( INTERNETSHORTCUT_URL_TAG ), RTL_TEXTENCODING_UTF8 ) );
	aURL = SvtPathOptions().SubstituteVariable( aURL );

	// make it absolute
    INetURLObject aBase( rFile );
    DBG_ASSERT( aBase.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
	INetURLObject aOut;
	aBase.GetNewAbsURL( aURL, &aOut );
	return aOut.GetMainURL( INetURLObj::NO_DECODE );
}

void ReadURLFile
(
	const String& rFile,	  // Datei, aus der gelesen werden soll
	String& rTitle,           // Puffer fuer den Titel
	String& rURL,             // Puffer fuer den URL
    String& rFrame,           // Puffer fuer den Zielrahmen
	BOOL* pShowAsFolder,      /* Puffer fuer das Flag, ob die URL als Ordner
								 dargestellt wird:
								 NULL => wird nicht geliefert */
	USHORT& rImageId,		  // zugeordnetes Image
	String* pOpenAs,          /* Puffer fuer die Oeffnunsart
								 NULL => wird nicht geliefert */
	String* pDefTempl,         /* Standardvorlagenname */
	String* pDefURL
)
{
	// Oefnung der Datei
    String aPath;
    if ( ::utl::LocalFileHelper::ConvertURLToPhysicalName( rFile, aPath ) )
    {
        Config aCfg( aPath );
        aCfg.SetGroup( INTERNETSHORTCUT_ID_TAG );

        // Einlesung des URLs
        rURL = ReadURL_Impl( aCfg, rFile );

        // Einlesung des Ziels, in dem die URL angezeigt werden soll
        if ( pShowAsFolder )
        {
            ByteString aTemp( aCfg.ReadKey( INTERNETSHORTCUT_TARGET_TAG ) );
            *pShowAsFolder = aTemp == INTERNETSHORTCUT_FOLDER_TAG;
        }

        // Einlesung und Konvertierung des Zielrahmens
        rFrame = String( aCfg.ReadKey( INTERNETSHORTCUT_FRAME_TAG ), RTL_TEXTENCODING_UTF8 );

        String aImgStr = String( aCfg.ReadKey( INTERNETSHORTCUT_SOICON_TAG ), RTL_TEXTENCODING_UTF8 );
        if ( aImgStr.GetToken(0).EqualsAscii( "StarOfficeIcon" ) )
        {
            rImageId = aImgStr.GetToken(1).ToInt32();
        }

        // Einlesung des Oeffnungstyps
        if ( pOpenAs )
            *pOpenAs = String( aCfg.ReadKey( INTERNETSHORTCUT_OPENAS_TAG ), RTL_TEXTENCODING_UTF8 );

        if ( pDefTempl )
            *pDefTempl = String( aCfg.ReadKey( INTERNETSHORTCUT_DEFTEMPL_TAG ), RTL_TEXTENCODING_UTF8 );

        if ( pDefURL )
            *pDefURL = ReadURL_Impl( aCfg, rFile );

        // read and convert the title, dependent on the language
    #if SUPD<613//MUSTINI
        String aLangStr = SfxIniManager::Get()->SubstPathVars( String::CreateFromAscii( "$(vlang)" ) );
    #else
        String aLangStr = SvtPathOptions().SubstituteVariable( String::CreateFromAscii( "$(vlang)" ) );
    #endif
        ByteString aLang = U2S( aLangStr );
        ByteString aGroup = INTERNETSHORTCUT_ID_TAG;
        ( ( aGroup += '-' ) += aLang ) += ".W";
        aCfg.SetGroup( aGroup );
        rTitle = String( aCfg.ReadKey( INTERNETSHORTCUT_TITLE_TAG ), RTL_TEXTENCODING_UTF7 );
    }
    else
        DBG_ERROR( "Bookmark is not in the local file system!" );
}


