/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: drawshape.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:09:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_DRAWSHAPE_HXX
#define _SLIDESHOW_DRAWSHAPE_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

#include <comphelper/optionalvalue.hxx> 

#include <set>
#include <vector>

#include <activity.hxx>
#include <intrinsicanimation.hxx>
#include <attributableshape.hxx>
#include <doctreenodesupplier.hxx>
#include <drawshapesubsetting.hxx>
#include <slideshowexceptions.hxx>
#include <viewshape.hxx>


class Graphic;

namespace presentation
{
    namespace internal
    {
        class DrawShape;

        typedef ::boost::shared_ptr< DrawShape > DrawShapeSharedPtr;

        /** This class is the representation of a draw document's
            XShape, and implements the Shape, AnimatableShape, and
            AttributableShape interfaces.

            @attention this class is to be treated 'final', i.e. one
            should not derive from it.
         */
        class DrawShape : 
            public AttributableShape, 
            public DocTreeNodeSupplier,
            public IntrinsicAnimation
        {
        public:
            /** Create a shape for the given XShape

            	@param xShape
                The XShape to represent.

                @param xContainingPage
                The page that contains this shape. Needed for proper
                import (currently, the UnoGraphicExporter needs this
                information).

                @param nPrio
                Externally-determined shape priority (used e.g. for
                paint ordering). This number _must be_ unique!

                @param bForeignSource
                When true, the source of the shape metafile might be a
                foreign application. The metafile is checked against
                unsupported content, and, if necessary, returned as a
                pre-rendererd bitmap.
             */
            DrawShape( const ::com::sun::star::uno::Reference< 
                       		::com::sun::star::drawing::XShape >& 	xShape,
                       const ::com::sun::star::uno::Reference< 
                       	 	::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                       double										nPrio,
                       bool											bForeignSource ); // throw ImportFailedException;

            /** Create a shape for the given XShape and graphic content

            	@param xShape
                The XShape to represent.

                @param xContainingPage
                The page that contains this shape. Needed for proper
                import (currently, the UnoGraphicExporter needs this
                information).

                @param nPrio
                Externally-determined shape priority (used e.g. for
                paint ordering). This number _must be_ unique!

                @param rGraphic
                Graphic to display in the shape's bound rect. If this
                Graphic contains animatable content, the created
                DrawShape will return true on hasIntrinsicAnimation().
             */
            DrawShape( const ::com::sun::star::uno::Reference< 
                       		::com::sun::star::drawing::XShape >& 	xShape,
                       const ::com::sun::star::uno::Reference< 
                       	 	::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                       double										nPrio,
                       const Graphic&								rGraphic ); // throw ImportFailedException;

            virtual ~DrawShape();

            virtual ::com::sun::star::uno::Reference< 
                ::com::sun::star::drawing::XShape > getXShape() const;

            // View layer methods
            //------------------------------------------------------------------

            virtual void addViewLayer( const ViewLayerSharedPtr& 	rNewLayer,
                                       bool							bRedrawLayer );
            virtual bool removeViewLayer( const ViewLayerSharedPtr& rNewLayer );

            // attribute methods
            //------------------------------------------------------------------

            virtual ShapeAttributeLayerSharedPtr createAttributeLayer();
            virtual bool revokeAttributeLayer( const ShapeAttributeLayerSharedPtr& rLayer );
            virtual ShapeAttributeLayerSharedPtr getTopmostAttributeLayer() const;
            virtual void setVisibility( bool bVisible );
            virtual ::basegfx::B2DRectangle getPosSize() const;
            virtual ::basegfx::B2DRectangle getUpdateArea() const;
            virtual bool isVisible() const;
            virtual double getPriority() const;


            // animation methods
            //------------------------------------------------------------------

            virtual void enterAnimationMode();
            virtual void leaveAnimationMode();
            virtual bool isBackgroundDetached() const;
            virtual bool hasIntrinsicAnimation() const;


            // render methods
            //------------------------------------------------------------------

            virtual bool update() const;
            virtual bool render() const;
            virtual bool isUpdateNecessary() const;

            // Sub item specialities
            //------------------------------------------------------------------

            virtual const DocTreeNodeSupplier& 	getTreeNodeSupplier() const;
            virtual DocTreeNodeSupplier& 	   	getTreeNodeSupplier();

            virtual DocTreeNode 				getSubsetNode() const;
            virtual AttributableShapeSharedPtr 	getSubset( const DocTreeNode& rTreeNode ) const;
            virtual bool 						createSubset( AttributableShapeSharedPtr& 	o_rSubset, 
                                                              const DocTreeNode& 			rTreeNode );
            virtual bool 						revokeSubset( const AttributableShapeSharedPtr& rShape );


            // DocTreeNodeSupplier methods
            //------------------------------------------------------------------

            virtual sal_Int32 	getNumberOfTreeNodes		( DocTreeNode::NodeType eNodeType ) const; // throw ImportFailedException;
            virtual DocTreeNode getTreeNode					( sal_Int32				nNodeIndex,
                                                              DocTreeNode::NodeType	eNodeType ) const; // throw ImportFailedException;
            virtual sal_Int32 	getNumberOfSubsetTreeNodes	( const DocTreeNode& 	rParentNode,
                                                              DocTreeNode::NodeType eNodeType ) const; // throw ImportFailedException;
            virtual DocTreeNode getSubsetTreeNode			( const DocTreeNode& 	rParentNode,
                                                              sal_Int32				nNodeIndex,
                                                              DocTreeNode::NodeType	eNodeType ) const; // throw ImportFailedException;


            // IntrinsicAnimation methods
            //------------------------------------------------------------------

            /** Start shape intrinsic animation
                
            	Since the IntrinsicAnimation interface is at the same
            	object, the rShape parameter seems a bit redundant. In
            	fact, it's not, because a DrawShape can hardly
            	generate a valid shared_ptr on itself.
             */
            virtual bool startIntrinsicAnimation( const SlideShowContext& rContext,
                                                  const ShapeSharedPtr&	  rShape );
            virtual bool endIntrinsicAnimation();

            /** Display next frame of an intrinsic animation.

            	Used by IntrinsicAnimationActivity, to show the next
            	animation frame.
             */
            bool setIntrinsicAnimationFrame( ::std::size_t nCurrFrame );


        private:
            // default: disabled copy/assignment
            DrawShape(const DrawShape&);
            DrawShape& operator=( const DrawShape& );

            /** Private copy constructor

				Used to create subsetted shapes
             */
            DrawShape( const DrawShape&, const DocTreeNode& rTreeNode, double nPrio );

            GDIMetaFileSharedPtr loadMtf( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >&  	xShape, 
                                          const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                                          bool 																		    	bWithComments ) const; // throw ImportFailedException;

            int  getUpdateFlags() const;
            bool implRender( int nUpdateFlags ) const;
            void updateStateIds() const;

            ViewShape::RenderArgs 	getViewRenderArgs() const;
            ::basegfx::B2DRectangle getActualUnitShapeBounds() const;

            void ensureVerboseMtfComments() const;


            typedef ::comphelper::OptionalValue< ::basegfx::B2DRectangle > OptionalRectangle;


            /// The associated XShape
            ::com::sun::star::uno::Reference< 
                	::com::sun::star::drawing::XShape > 							mxShape;
            ::com::sun::star::uno::Reference< 
                	::com::sun::star::drawing::XDrawPage >							mxPage;

            /** A vector of metafiles actually representing the Shape.

            	If this shape is not animated, only a single entry is
            	available.
             */
            mutable VectorOfMtfAnimationFrames										maAnimationFrames;
            ::std::size_t															mnCurrFrame;
            mutable ActivitySharedPtr												mpIntrinsicAnimationActivity;

            /// Metafile of currently active frame (static for shapes w/o intrinsic animation)
            mutable GDIMetaFileSharedPtr											mpCurrMtf;

            /// Contains the current shape bounds, in unit rect space
            mutable OptionalRectangle												maCurrentShapeUnitBounds;

            // The attributes of this Shape
            const double															mnPriority;
            ::basegfx::B2DRectangle													maBounds; // always needed for rendering.
            																				  // for subset shapes, this member 
            																				  // might change when views are
            																				  // added, as minimal bounds are
            																				  // calculated

            // Pointer to modifiable shape attributes
            ShapeAttributeLayerSharedPtr											mpAttributeLayer; // only created lazily

            // The attribute states, to detect attribute changes,
            // without buffering and querying each single attribute
            mutable State::StateId 													mnAttributeTransformationState;
            mutable State::StateId 													mnAttributeClipState;
            mutable State::StateId 													mnAttributeAlphaState;
            mutable State::StateId 													mnAttributePositionState;
            mutable State::StateId 													mnAttributeContentState;

            /// the list of active view shapes (one for each registered view layer)
            typedef ::std::vector< ViewShapeSharedPtr > ViewShapeVector;
            ViewShapeVector															maViewShapes;

            /// Delegated subset handling
            mutable DrawShapeSubsetting												maSubsetting;

            /// Whether this shape is currently in animation mode (value != 0)
            int																		mnIsAnimatedCount;

            /// When true, shape metafile might contain unsupported actions
            const bool																mbForeignSource;
            
            /// Whether shape is visible (without attribute layers)
            bool																	mbIsVisible;

            /// Whether the mpMtf has verbose text comments, or not
            mutable bool															mbMtfHasComments;

            /// Whether redraw is necessary, regardless of state ids
            mutable bool 															mbForceUpdate;

            /// Whether attribute layer was revoked (making a redraw necessary)
            mutable bool 															mbAttributeLayerRevoked;
        };

        typedef ::boost::shared_ptr< DrawShape > DrawShapeSharedPtr;

    }
}

#endif /* _SLIDESHOW_DRAWSHAPE_HXX */
