/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mediashape.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:15:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_MEDIASHAPE_HXX
#define _SLIDESHOW_MEDIASHAPE_HXX

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <vector>

#include <animatableshape.hxx>
#include <slideshowexceptions.hxx>
#include <viewmediashape.hxx>
#include <intrinsicanimation.hxx>


namespace presentation
{
    namespace internal
    {
        /** Represents a media shape.

            This implementation offers support for media shapes.
			Such shapes need special treatment.
         */
        class MediaShape : public AnimatableShape,
                           public IntrinsicAnimation
        {
        public:
            /** Create a shape for the given XShape for a media object

            	@param xShape
                The XShape to represent.

                @param xContainingPage
                The page that contains this shape. Needed for proper
                import (currently, the UnoGraphicExporter needs this
                information).

                @param nPrio
                Externally-determined shape priority (used e.g. for
                paint ordering). This number _must be_ unique!
             */
            MediaShape( const ::com::sun::star::uno::Reference< 
                       		::com::sun::star::drawing::XShape >&	xShape,
                       const ::com::sun::star::uno::Reference< 
                        	::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                       double										nPrio	); // throw ImportFailedException;

            virtual ::com::sun::star::uno::Reference< 
                ::com::sun::star::drawing::XShape > getXShape() const;

            // View layer methods
            //------------------------------------------------------------------

            virtual void addViewLayer( const ViewLayerSharedPtr& 	rNewLayer,
                                       bool							bRedrawLayer );
            virtual bool removeViewLayer( const ViewLayerSharedPtr& rNewLayer );
			
            // animation methods
            //------------------------------------------------------------------

            virtual void enterAnimationMode();
            virtual void leaveAnimationMode();


            // render methods
            //------------------------------------------------------------------

            virtual bool update() const;
            virtual bool render() const;
			virtual bool isUpdateNecessary() const;


			// Shape attributes
            //------------------------------------------------------------------
			            
            virtual ::basegfx::B2DRectangle getPosSize() const;
            virtual ::basegfx::B2DRectangle getUpdateArea() const;
            virtual bool isVisible() const;
            virtual double getPriority() const;
            virtual bool isBackgroundDetached() const;
            virtual bool hasIntrinsicAnimation() const;

            // IntrinsicAnimation methods
            //------------------------------------------------------------------

            /** Start shape intrinsic animation
                
            	Since the IntrinsicAnimation interface is at the same
            	object, the rShape parameter seems a bit redundant. In
            	fact, it's not, because a MediaShape can hardly
            	generate a valid shared_ptr on itself.
             */
            virtual bool startIntrinsicAnimation( const SlideShowContext& rContext,
                                                  const ShapeSharedPtr&	  rShape );
            virtual bool endIntrinsicAnimation();
            
        private:
            
			// default: disabled copy/assignment
            MediaShape( const MediaShape& );
            MediaShape& operator=( const MediaShape& );

            /// The associated XShape
            ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > 	mxShape;

            // The attributes of this Shape
            const double															mnPriority;
            ::basegfx::B2DRectangle													maBounds;

	           /// Whether this shape is currently in animation mode (value != 0)
            int																		mnIsAnimatedCount;

            /// the list of active view shapes (one for each registered view layer)
            typedef ::std::vector< ViewMediaShapeSharedPtr > ViewMediaShapeVector;
            ViewMediaShapeVector													maViewMediaShapes;
        };

        typedef ::boost::shared_ptr< MediaShape > MediaShapeSharedPtr;
	}
}

#endif /* _SLIDESHOW_MEDIASHAPE_HXX */
