/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccessibleBrowseBoxTableCell.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:00:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVTOOLS_ACCESSIBILEBROWSEBOXTABLECELL_HXX
#define _SVTOOLS_ACCESSIBILEBROWSEBOXTABLECELL_HXX

#ifndef SVTOOLS_ACCESSIBLE_BROWSE_BOX_CELL_HXX
#include "accessiblebrowseboxcell.hxx"
#endif

#ifndef COMPHELPER_ACCESSIBLE_TEXT_HELPER_HXX
#include <comphelper/accessibletexthelper.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

namespace svt
{
	typedef ::cppu::ImplHelper2	<	::com::sun::star::accessibility::XAccessibleText
								,	::com::sun::star::accessibility::XAccessible
								>	AccessibleTextHelper_BASE;

	// implementation of a table cell of BrowseBox
	class AccessibleBrowseBoxTableCell	:public AccessibleBrowseBoxCell
										,public AccessibleTextHelper_BASE
										,public ::comphelper::OCommonAccessibleText
	{
	protected:
		// OCommonAccessibleText
		virtual ::rtl::OUString					implGetText();
		virtual ::com::sun::star::lang::Locale	implGetLocale();
		virtual void							implGetSelection( sal_Int32& nStartIndex, sal_Int32& nEndIndex );

	public:
		AccessibleBrowseBoxTableCell(const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxParent,
									IAccessibleTableProvider& _rBrowseBox,
									const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
									sal_Int32 _nRowId,
									sal_uInt16 _nColId);

		// XInterface -------------------------------------------------------------

		/** Queries for a new interface. */
		::com::sun::star::uno::Any SAL_CALL queryInterface(
				const ::com::sun::star::uno::Type& rType )
			throw ( ::com::sun::star::uno::RuntimeException );

		/** Aquires the object (calls acquire() on base class). */
		virtual void SAL_CALL acquire() throw ();

		/** Releases the object (calls release() on base class). */
		virtual void SAL_CALL release() throw ();

		// XEventListener
	    virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source )
			throw(::com::sun::star::uno::RuntimeException);

		/** @return  The index of this object among the parent's children. */
		virtual sal_Int32 SAL_CALL getAccessibleIndexInParent()
			throw ( ::com::sun::star::uno::RuntimeException );

		/** @return
				The name of this class.
		*/
		virtual ::rtl::OUString SAL_CALL getImplementationName()
			throw ( ::com::sun::star::uno::RuntimeException );

		/** @return
				The count of visible children.
		*/
		virtual sal_Int32 SAL_CALL getAccessibleChildCount()
			throw ( ::com::sun::star::uno::RuntimeException );

		/** @return
				The XAccessible interface of the specified child.
		*/
		virtual ::com::sun::star::uno::Reference<
			::com::sun::star::accessibility::XAccessible > SAL_CALL
			getAccessibleChild( sal_Int32 nChildIndex )
				throw ( ::com::sun::star::lang::IndexOutOfBoundsException,
						::com::sun::star::uno::RuntimeException );

		/** Creates a new AccessibleStateSetHelper and fills it with states of the
			current object.
			@return
				A filled AccessibleStateSetHelper.
		*/
		::utl::AccessibleStateSetHelper* implCreateStateSetHelper();

		// XAccessible ------------------------------------------------------------

		/** @return  The XAccessibleContext interface of this object. */
		virtual ::com::sun::star::uno::Reference<
			::com::sun::star::accessibility::XAccessibleContext > SAL_CALL
		getAccessibleContext()
			throw ( ::com::sun::star::uno::RuntimeException );

		// XAccessibleText
		virtual sal_Int32 SAL_CALL getCaretPosition() throw (::com::sun::star::uno::RuntimeException);
		virtual sal_Bool SAL_CALL setCaretPosition( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		virtual sal_Unicode SAL_CALL getCharacter( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > SAL_CALL getCharacterAttributes( sal_Int32 nIndex, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRequestedAttributes ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Rectangle SAL_CALL getCharacterBounds( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		virtual sal_Int32 SAL_CALL getCharacterCount() throw (::com::sun::star::uno::RuntimeException);
		virtual sal_Int32 SAL_CALL getIndexAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::rtl::OUString SAL_CALL getSelectedText() throw (::com::sun::star::uno::RuntimeException);
		virtual sal_Int32 SAL_CALL getSelectionStart() throw (::com::sun::star::uno::RuntimeException);
		virtual sal_Int32 SAL_CALL getSelectionEnd() throw (::com::sun::star::uno::RuntimeException);
		virtual sal_Bool SAL_CALL setSelection( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		virtual ::rtl::OUString SAL_CALL getText() throw (::com::sun::star::uno::RuntimeException);
		virtual ::rtl::OUString SAL_CALL getTextRange( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
        virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextAtIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextBeforeIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextBehindIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
		virtual sal_Bool SAL_CALL copyText( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
	};
}
#endif // _SVTOOLS_ACCESSIBILEBROWSEBOXTABLECELL_HXX

