/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xcpoly.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:19:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <math.h>
#include <tools/debug.hxx>
#include <tools/poly.hxx>
#include "xcpoly.hxx"

#define GLOBALOVERFLOW


DBG_NAME( XClipPolygon );
DBG_NAME( XClipPolyPolygon );

/*************************************************************************
|*
|*    XClipPolygon::Inside
|*
|*    Beschreibung		Prueft, ob Punkt sich 'innerhalb' einer Kante
|*						befindet
|*    Ersterstellung    03.05.95 KA
|*    Letzte Aenderung  03.05.95 KA
|*
*************************************************************************/

BOOL XClipPolygon::Inside(const Point& rPoint, XCPolyEdge eEdge)
{
	return 	eEdge == EDGE_LEFT 	? 	rPoint.X() >= aRect.Left() :
			eEdge == EDGE_TOP 	? 	rPoint.Y() >= aRect.Top() :
			eEdge == EDGE_RIGHT	? 	rPoint.X() <= aRect.Right()
								:	rPoint.Y() <= aRect.Bottom();
}


/*************************************************************************
|*
|*    XClipPolygon::Intersect
|*
|*    Beschreibung		Bildet Schnittpunkt einer Kante mit einer Geraden,
|* 						die durch zwei Punkte definiert ist
|*    Ersterstellung    03.05.95 KA
|*    Letzte Aenderung  03.05.95 KA
|*
*************************************************************************/

Point XClipPolygon::Intersect(const Point& rPoint1, const Point& rPoint2, XCPolyEdge eEdge)
{
	double 	fX1, fX2;
	double 	fY1, fY2;
	double  fX, fY;


	if (eEdge == EDGE_LEFT || eEdge == EDGE_RIGHT)
	{
		fX = eEdge == EDGE_LEFT ? aRect.Left() : aRect.Right();

		if (rPoint1.X() < rPoint2.X())
		{
			fX1 = rPoint1.X(); fY1 = rPoint1.Y();
			fX2 = rPoint2.X(); fY2 = rPoint2.Y();
		}
		else
		{
			fX1 = rPoint2.X(); fY1 = rPoint2.Y();
			fX2 = rPoint1.X(); fY2 = rPoint1.Y();
		}

		fY =	(double)(fY2 - fY1) / (double)(fX2 - fX1) *
				(double)(fX - fX1) +
				(double)fY1 + 0.5;

		return Point((long)fX, (long)fY);
	}
	else
	{
		fX = eEdge == EDGE_TOP ? aRect.Top() : aRect.Bottom();

		if (rPoint1.Y() < rPoint2.Y())
		{
			fX1 = rPoint1.Y(); fY1 = rPoint1.X();
			fX2 = rPoint2.Y(); fY2 = rPoint2.X();
		}
		else
		{
			fX1 = rPoint2.Y(); fY1 = rPoint2.X();
			fX2 = rPoint1.Y(); fY2 = rPoint1.X();
		}

		fY =	(double)(fY2 - fY1) / (double)(fX2 - fX1) *
				(double)(fX - fX1) +
				(double)fY1 + 0.5;

		return Point((long)fY, (long)fX);
	}
}


/*************************************************************************
|*
|*    XClipPolygon::ClipEdge
|*
|*    Beschreibung		Clipped das uebergebene Polygon an der Kante
|*
|*    Ersterstellung    03.05.95 KA
|*    Letzte Aenderung  03.05.95 KA
|*
*************************************************************************/

Polygon	XClipPolygon::ClipEdge(const Polygon& rPoly, XCPolyEdge eEdge)
{
	Polygon	aOutPoly(0);
	USHORT 	nOutSize 	= 0;
	USHORT	nInSize		= rPoly.GetSize();
	USHORT	i;
	Point	aPointP;
	Point	aPointS;


	if (nInSize > 2)
	{
		aPointS = rPoly.GetPoint(nInSize - 1);

		for (i = 0; i < nInSize; i++)
		{
			aPointP = rPoly.GetPoint(i);

			if (Inside(aPointP, eEdge))
			{
				if (Inside(aPointS, eEdge))
				{
					aOutPoly.SetSize(++nOutSize);
					aOutPoly.SetPoint(aPointP, nOutSize - 1);
				}
				else
				{
					aOutPoly.SetSize(nOutSize += 2);
					aOutPoly.SetPoint(Intersect(aPointS, aPointP, eEdge), nOutSize - 2);
					aOutPoly.SetPoint(aPointP, nOutSize - 1);
				}
			}
			else if (Inside(aPointS, eEdge))
			{
				aOutPoly.SetSize(++nOutSize);
				aOutPoly.SetPoint(Intersect(aPointS, aPointP, eEdge), nOutSize - 1);
			}

			aPointS = aPointP;
		}
	}

	return aOutPoly;
}


/*************************************************************************
|*
|*    XClipPolygon::GetClippedPolygon
|*
|*    Beschreibung		Clipped das uebergebene Polygon an allen Kanten;
|*						gibt das am Rechteck geclippte Polygon zurueck
|*
|*    Ersterstellung    03.05.95 KA
|*    Letzte Aenderung  03.05.95 KA
|*
*************************************************************************/

Polygon	XClipPolygon::GetClippedPolygon()
{
	Polygon aTempPoly =	ClipEdge(
							ClipEdge(
								ClipEdge(
									ClipEdge(aInPoly,
									EDGE_LEFT),
								EDGE_TOP),
							EDGE_RIGHT),
						EDGE_BOTTOM);


	// Post-Processing, um ungueltige Polygone zu vermeiden
	// und doppelte Punkte zu unterdruecken
	Polygon aOutPoly(0);
	USHORT	i;
	USHORT	nCount = 1;
	USHORT	nSize = aTempPoly.GetSize();
	Point	aLeastPoint;
	Point	aLastPoint;
	Point	aTempPoint;


	if (nSize > 2)
	{
		aOutPoly.SetSize(nCount++);
		aOutPoly[0] = aLeastPoint = aTempPoly[0];


		// letzten und vorletzten Punkt ermitteln
		if ((aLastPoint = aTempPoly[1]) != aLeastPoint)
		{
			aOutPoly.SetSize(nCount++);
			aOutPoly[1] = aLastPoint;
		}
		else
			aLastPoint = aLeastPoint;


		// jeden neuen Punkt mit dem letzten und vorletzten Punkt
		// vergleichen und entsprechend setzen oder nicht
		nSize--;
		for (i = 2; i < nSize; i++)
		{
			aTempPoint = aTempPoly[i];

			if ((aTempPoint != aLastPoint) && (aTempPoint != aLeastPoint))
			{
				aOutPoly.SetSize(nCount++);
				aOutPoly[nCount - 2] = aTempPoint;

				aLeastPoint = aLastPoint;
				aLastPoint	= aTempPoint;
			}
		}


		// letzter Punkt im Polygon darf nicht mit erstem Punkt zusammenfallen
		if ((aTempPoint = aTempPoly[nSize]) != aOutPoly[0])
		{
			aOutPoly.SetSize(nCount);
			aOutPoly[nCount - 1] = aTempPoint;
		}
	}


	return aOutPoly;
}


/*************************************************************************
|*
|*    XClipPolyPolygon::GetClippedPolyPolygon
|*
|*    Beschreibung		Clipped das uebergebene PolyPolygon an allen Kanten;
|*						gibt das am Rechteck geclippte PolyPolygon zurueck
|*
|*    Ersterstellung    09.05.95 KA
|*    Letzte Aenderung  09.05.95 KA
|*
*************************************************************************/

PolyPolygon	XClipPolyPolygon::GetClippedPolyPolygon()
{
	USHORT		nCount = aInPolyPoly.Count();
	PolyPolygon	aOutPolyPoly;
	Polygon		aOutPoly;
	USHORT		i;

		USHORT 	j;
		Point	aP;

	aOutPolyPoly.Clear();

	for (i = 0; i < nCount; i++)
	{
		XClipPolygon aClipPoly(aInPolyPoly.GetObject(i), aRect);
		aOutPoly = aClipPoly.GetClippedPolygon();

		for (j = 0; j < aOutPoly.GetSize(); j++)
		{
			aP = aOutPoly[j];
		}


		if (aOutPoly.GetSize() > 2)
			aOutPolyPoly.Insert(aOutPoly);
	}

	return aOutPolyPoly;
}


