/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: optpage.cxx,v $
 *
 *  $Revision: 1.45 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:46:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SW_DLLIMPLEMENTATION
#undef SW_DLLIMPLEMENTATION
#endif

#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _UIPARAM_HXX
#include <uiparam.hxx>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif

#ifndef _SVSTDARR_HXX
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SVX_HTMLMODE_HXX //autogen
#include <svx/htmlmode.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _XTABLE_HXX //autogen
#include <svx/xtable.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX
#include <svx/langitem.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX //autogen
#include <svx/dlgutil.hxx>
#endif
#ifndef _SV_WALL_HXX
#include <vcl/wall.hxx>
#endif


#ifndef _FMTCOL_HXX //autogen
#include <fmtcol.hxx>
#endif
#ifndef _CHARATR_HXX
#include <charatr.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _CHARATR_HXX
#include <charatr.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _UITOOL_HXX
#include <uitool.hxx>
#endif
#ifndef _SWATRSET_HXX
#include <swatrset.hxx>
#endif
//CHINA001 #ifndef _OPTDLG_HXX
//CHINA001 #include <optdlg.hxx>
//CHINA001 #endif
#ifndef _CFGITEMS_HXX
#include <cfgitems.hxx> //Items fuer Sw-Seiten
#endif
#ifndef _FMTCOL_HXX
#include <fmtcol.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _UIITEMS_HXX
#include <uiitems.hxx>
#endif
#ifndef _INITUI_HXX
#include <initui.hxx>
#endif
#ifndef _OPTPAGE_HXX
#include <optpage.hxx>
#endif
#ifndef _SWPRTOPT_HXX
#include <swprtopt.hxx>
#endif
#ifndef _FONTCFG_HXX
#include <fontcfg.hxx>
#endif
#ifndef _MODCFG_HXX
#include <modcfg.hxx>
#endif
#ifndef _SRCVIEW_HXX
#include <srcview.hxx>
#endif
#ifndef _SRCEDTW_HXX
#include <srcedtw.hxx>
#endif
#ifndef _CRSTATE_HXX
#include <crstate.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif

#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _CONFIG_HRC
#include <config.hrc>
#endif
#ifndef _REDLOPT_HRC
#include <redlopt.hrc>
#endif
#ifndef _OPTDLG_HRC
#include <optdlg.hrc>
#endif

#ifndef _SVX_STRARRAY_HXX
#include <svx/strarray.hxx>
#endif
#ifndef _SFXSLSTITM_HXX //CHINA001
#include <svtools/slstitm.hxx> //CHINA001
#endif //CHINA001
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXREQUEST_HXX
#include <sfx2/request.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#include <swwrtshitem.hxx> //CHINA001
#define C2S(cChar) String::CreateFromAscii(cChar)
/*******************************************************
 ******************************************************/

/*-----------------31.08.96 10.16-------------------
	TabPage Anzeige/Inhalt
--------------------------------------------------*/

SwContentOptPage::SwContentOptPage( Window* pParent,
									  const SfxItemSet& rCoreSet ) :
	SfxTabPage( pParent, SW_RES( TP_CONTENT_OPT ), rCoreSet ),
    aLineFL       ( this,   SW_RES( FL_LINE     ) ),
	aCrossCB   	  ( this,	SW_RES( CB_CROSS     ) ),
	aSolidHandleCB( this, 	SW_RES( CB_HANDLE	) ),
	aBigHandleCB  ( this, 	SW_RES( CB_BIGHANDLE) ),
    aWindowFL     ( this,   SW_RES( FL_WINDOW   ) ),
	aHScrollBox   ( this,	SW_RES( CB_HSCROLL   ) ),
	aVScrollBox   ( this,	SW_RES( CB_VSCROLL   ) ),
    aAnyRulerCB   ( this,   SW_RES( CB_ANY_RULER ) ),
    aHRulerCBox   ( this,   SW_RES( CB_HRULER   ) ),
    aHMetric      ( this,   SW_RES( LB_HMETRIC    ) ),
	aVRulerCBox   ( this,	SW_RES( CB_VRULER    ) ),
    aVRulerRightCBox( this, SW_RES( CB_VRULER_RIGHT    ) ),
    aVMetric      ( this,   SW_RES( LB_VMETRIC    ) ),
    aSmoothCBox   ( this,   SW_RES( CB_SMOOTH_SCROLL    ) ),
    aDispFL      ( this,   SW_RES( FL_DISP     ) ),
	aGrfCB        ( this,	SW_RES( CB_GRF  		) ),
	aTblCB        ( this,	SW_RES( CB_TBL		) ),
	aDrwCB        ( this,	SW_RES( CB_DRWFAST   ) ),
	aFldNameCB    ( this,	SW_RES( CB_FIELD 	) ),
	aPostItCB     ( this,	SW_RES( CB_POSTIT 	) ),
    aSettingsFL   ( this,   SW_RES( FL_SETTINGS   ) ),
    aMetricLB     ( this,   SW_RES( LB_METRIC   ) ),
    aMetricFT     ( this,   SW_RES( FT_METRIC   ) )
{
	FreeResource();
	const SfxPoolItem* pItem;
	if(SFX_ITEM_SET == rCoreSet.GetItemState(SID_HTML_MODE, FALSE, &pItem )
		&& ((SfxUInt16Item*)pItem)->GetValue() & HTMLMODE_ON)
	{
        aMetricLB.Show();
        aSettingsFL.Show();
        aMetricFT.Show();
    }
    SvtCJKOptions aCJKOptions;
    if(aCJKOptions.IsVerticalTextEnabled() )
    {
        Point aSmoothPos(aSmoothCBox.GetPosPixel());
        aSmoothPos.Y() += aSmoothPos.Y() - aVRulerCBox.GetPosPixel().Y();
        aSmoothCBox.SetPosPixel(aSmoothPos);
    }
    else
        aVRulerRightCBox.Hide();
    aVRulerCBox.SetClickHdl(LINK(this, SwContentOptPage, VertRulerHdl ));
    aAnyRulerCB.SetClickHdl(LINK(this, SwContentOptPage, AnyRulerHdl));

    SvxStringArray aMetricArr( SW_RES( STR_ARR_METRIC ) );
    for ( USHORT i = 0; i < aMetricArr.Count(); ++i )
	{
		String sMetric = aMetricArr.GetStringByPos( i );
		FieldUnit eFUnit = (FieldUnit)aMetricArr.GetValue( i );

		switch ( eFUnit )
		{
			case FUNIT_MM:
			case FUNIT_CM:
			case FUNIT_POINT:
			case FUNIT_PICA:
			case FUNIT_INCH:
			{
				// nur diese Metriken benutzen
				USHORT nPos = aMetricLB.InsertEntry( sMetric );
				aMetricLB.SetEntryData( nPos, (void*)(long)eFUnit );
                aVMetric.InsertEntry( sMetric );
                aVMetric.SetEntryData( nPos, (void*)(long)eFUnit );
                aHMetric.InsertEntry( sMetric );
                aHMetric.SetEntryData( nPos, (void*)(long)eFUnit );
			}
		}
	}
}

/*-----------------31.08.96 13.58-------------------

--------------------------------------------------*/
SwContentOptPage::~SwContentOptPage()
{
}

/*-----------------31.08.96 13.58-------------------

--------------------------------------------------*/
SfxTabPage*	SwContentOptPage::Create( Window* pParent,
								const SfxItemSet& rAttrSet)
{
	return new SwContentOptPage(pParent, rAttrSet);
}
/* -----------------------------07.04.01 16:57--------------------------------

 ---------------------------------------------------------------------------*/
static void lcl_SelectMetricLB(ListBox& rMetric, USHORT nSID, const SfxItemSet& rSet)
{
    const SfxPoolItem* pItem;
    if( rSet.GetItemState( nSID, FALSE, &pItem ) >= SFX_ITEM_AVAILABLE )
	{
        FieldUnit eFieldUnit = (FieldUnit)((SfxUInt16Item*)pItem)->GetValue();
        for ( USHORT i = 0; i < rMetric.GetEntryCount(); ++i )
		{
            if ( (int)rMetric.GetEntryData( i ) == (int)eFieldUnit )
			{
                rMetric.SelectEntryPos( i );
				break;
			}
		}
    }
    rMetric.SaveValue();
}
/*-----------------31.08.96 13.58-------------------

--------------------------------------------------*/
void SwContentOptPage::Reset(const SfxItemSet& rSet)
{
    const SwElemItem* pElemAttr = 0;

	rSet.GetItemState( FN_PARAM_ELEM , FALSE,
									(const SfxPoolItem**)&pElemAttr );
	if(pElemAttr)
    {
        aTblCB      .Check  (pElemAttr->bTable                );
        aGrfCB      .Check  (pElemAttr->bGraphic              );
        aDrwCB      .Check  (pElemAttr->bDrawing              );
        aFldNameCB  .Check  (pElemAttr->bFieldName            );
        aPostItCB   .Check  (pElemAttr->bNotes                );
        aCrossCB   .Check( pElemAttr->bCrosshair        );
        aSolidHandleCB.Check( !pElemAttr->bHandles          );
        aBigHandleCB.Check(pElemAttr->bBigHandles       );
        aHScrollBox.Check( pElemAttr->bHorzScrollbar     );
        aVScrollBox.Check( pElemAttr->bVertScrollbar     );
        aAnyRulerCB.Check( pElemAttr->bAnyRuler );
        aHRulerCBox.Check( pElemAttr->bHorzRuler         );
        aVRulerCBox.Check( pElemAttr->bVertRuler         );
        aVRulerRightCBox.Check(pElemAttr->bVertRulerRight);
        aSmoothCBox.Check( pElemAttr->bSmoothScroll      );
	}
    aMetricLB.SetNoSelection();
    lcl_SelectMetricLB(aMetricLB, SID_ATTR_METRIC, rSet);
    lcl_SelectMetricLB(aHMetric, FN_HSCROLL_METRIC, rSet);
    lcl_SelectMetricLB(aVMetric, FN_VSCROLL_METRIC, rSet);
    AnyRulerHdl(&aAnyRulerCB);
}

/*-----------------31.08.96 13.58-------------------

--------------------------------------------------*/
BOOL SwContentOptPage::FillItemSet(SfxItemSet& rSet)
{
    const SwElemItem*   pOldAttr = (const SwElemItem*)
						GetOldItem(GetItemSet(), FN_PARAM_ELEM);

	SwElemItem aElem;
	if(pOldAttr)
		aElem = *pOldAttr;
    aElem.bTable                = aTblCB        .IsChecked();
    aElem.bGraphic              = aGrfCB        .IsChecked();
    aElem.bDrawing              = aDrwCB        .IsChecked();
    aElem.bFieldName            = aFldNameCB    .IsChecked();
    aElem.bNotes                = aPostItCB     .IsChecked();
    aElem.bCrosshair     = aCrossCB   .IsChecked();
    aElem.bHandles       = !aSolidHandleCB.IsChecked();
    aElem.bBigHandles    = aBigHandleCB.IsChecked();
    aElem.bHorzScrollbar = aHScrollBox.IsChecked();
    aElem.bVertScrollbar = aVScrollBox.IsChecked();
    aElem.bAnyRuler = aAnyRulerCB.IsChecked();
    aElem.bHorzRuler     = aHRulerCBox.IsChecked();
    aElem.bVertRuler     = aVRulerCBox.IsChecked();
    aElem.bVertRulerRight= aVRulerRightCBox.IsChecked();
    aElem.bSmoothScroll  = aSmoothCBox.IsChecked();


    BOOL bRet = !pOldAttr || aElem != *pOldAttr;
	if(bRet)
        bRet = 0 != rSet.Put(aElem);
    USHORT nMPos = aMetricLB.GetSelectEntryPos();
    USHORT nGlobalMetricPos = nMPos;
	if ( nMPos != aMetricLB.GetSavedValue() )
	{
		// Doppel-Cast fuer VA3.0
		USHORT nFieldUnit = (USHORT)(long)aMetricLB.GetEntryData( nMPos );
        rSet.Put( SfxUInt16Item( SID_ATTR_METRIC, (UINT16)nFieldUnit ) );
        bRet = TRUE;
	}

    nMPos = aHMetric.GetSelectEntryPos();
    if ( nMPos != aHMetric.GetSavedValue() || nMPos != nGlobalMetricPos )
	{
		// Doppel-Cast fuer VA3.0
        USHORT nFieldUnit = (USHORT)(long)aHMetric.GetEntryData( nMPos );
        rSet.Put( SfxUInt16Item( FN_HSCROLL_METRIC, (UINT16)nFieldUnit ) );
        bRet = TRUE;
	}
    nMPos = aVMetric.GetSelectEntryPos();
    if ( nMPos != aVMetric.GetSavedValue() || nMPos != nGlobalMetricPos )
	{
		// Doppel-Cast fuer VA3.0
        USHORT nFieldUnit = (USHORT)(long)aVMetric.GetEntryData( nMPos );
        rSet.Put( SfxUInt16Item( FN_VSCROLL_METRIC, (UINT16)nFieldUnit ) );
        bRet = TRUE;
	}
    return bRet;
}
/* -----------------------------05.03.2002 15:07------------------------------

 ---------------------------------------------------------------------------*/
IMPL_LINK(SwContentOptPage, VertRulerHdl, CheckBox*, pBox)
{
    aVRulerRightCBox.Enable(pBox->IsEnabled() && pBox->IsChecked());
    return 0;
}
/* -----------------20.09.2002 11:30-----------------
 *
 * --------------------------------------------------*/
IMPL_LINK( SwContentOptPage, AnyRulerHdl, CheckBox*, pBox)
{
    BOOL bChecked = pBox->IsChecked();
    aHRulerCBox      .Enable(bChecked);
    aHMetric         .Enable(bChecked);
    aVRulerCBox      .Enable(bChecked);
    aVMetric         .Enable(bChecked);
    VertRulerHdl(&aVRulerCBox);
    return 0;
}
/*----------------- OS 27.01.95  -----------------------
 TabPage Drucker Zusatzeinstellungen
-------------------------------------------------------*/
SwAddPrinterTabPage::SwAddPrinterTabPage( Window* pParent,
									  const SfxItemSet& rCoreSet) :
	SfxTabPage( pParent, SW_RES( TP_OPTPRINT_PAGE ), rCoreSet),
	bPreview  ( FALSE ),
	aGrfCB           (this, SW_RES(CB_PGRF)),
	aTabCB           (this, SW_RES(CB_PTAB)),
	aDrawCB          (this, SW_RES(CB_PDRAW)),
	aCtrlFldCB       (this, SW_RES(CB_CTRLFLD)),
	aBackgroundCB    (this, SW_RES(CB_BACKGROUND)),
	aBlackFontCB 	 (this, SW_RES(CB_BLACK_FONT)),
    aFL1          (this, SW_RES(FL_1)),
    aSeparatorLFL    (this, SW_RES(FL_SEP_PRT_LEFT )),
    aSeparatorRFL    (this, SW_RES(FL_SEP_PRT_RIGHT)),
    aLeftPageCB      (this, SW_RES(CB_LEFTP)),
	aRightPageCB     (this, SW_RES(CB_RIGHTP)),
    aReverseCB       (this, SW_RES(CB_REVERSE)),
    aProspectCB      (this, SW_RES(CB_PROSPECT)),
    aFL2          (this, SW_RES(FL_2)),
	aNoRB            (this, SW_RES(RB_NO)),
	aOnlyRB          (this, SW_RES(RB_ONLY)),
	aEndRB           (this, SW_RES(RB_END)),
	aEndPageRB       (this, SW_RES(RB_PAGEEND)),
    aFL3          (this, SW_RES(FL_3)),
    aFL4          (this, SW_RES(FL_4)),
	aPaperFromSetupCB(this, SW_RES(CB_PAPERFROMSETUP)),
	aSingleJobsCB	 (this, SW_RES(CB_SINGLEJOBS)),
    aFaxFT           (this, SW_RES(FT_FAX)),
    aFaxLB           (this, SW_RES(LB_FAX)),
    sNone(ResId(ST_NONE)),
	bAttrModified( FALSE )
{
	Init();
	FreeResource();
    Link aLk = LINK( this, SwAddPrinterTabPage, AutoClickHdl);
	aGrfCB.SetClickHdl( aLk );
	aRightPageCB.SetClickHdl( aLk );
	aLeftPageCB.SetClickHdl( aLk );
	aTabCB.SetClickHdl( aLk );
	aDrawCB.SetClickHdl( aLk );
	aCtrlFldCB.SetClickHdl( aLk );
	aBackgroundCB.SetClickHdl( aLk );
	aBlackFontCB.SetClickHdl( aLk );
	aReverseCB.SetClickHdl( aLk );
	aProspectCB.SetClickHdl( aLk );
	aPaperFromSetupCB.SetClickHdl( aLk );
	aEndPageRB.SetClickHdl( aLk );
	aEndRB.SetClickHdl( aLk );
	aOnlyRB.SetClickHdl( aLk );
	aNoRB.SetClickHdl( aLk );
	aSingleJobsCB.SetClickHdl( aLk );
	aFaxLB.SetSelectHdl( LINK( this, SwAddPrinterTabPage, SelectHdl ) );

	const SfxPoolItem* pItem;
	if(SFX_ITEM_SET == rCoreSet.GetItemState(SID_HTML_MODE, FALSE, &pItem )
		&& ((SfxUInt16Item*)pItem)->GetValue() & HTMLMODE_ON)
	{
		aDrawCB      .Hide();
		aLeftPageCB  .Hide();
		aRightPageCB .Hide();
		aReverseCB.SetPosPixel(aLeftPageCB  .GetPosPixel());
		aProspectCB.SetPosPixel(aRightPageCB .GetPosPixel());
		aBlackFontCB.SetPosPixel(aBackgroundCB.GetPosPixel());
		aBackgroundCB.SetPosPixel(aCtrlFldCB.GetPosPixel());
		aCtrlFldCB.SetPosPixel(aDrawCB.GetPosPixel());
	}

}

//------------------------------------------------------------------------

void SwAddPrinterTabPage::SetPreview(BOOL bPrev)
{
	bPreview = bPrev;

	if (bPreview)
	{
		aLeftPageCB.Disable();
		aRightPageCB.Disable();
		aProspectCB.Disable();
        aFL3.Disable();
		aNoRB.Disable();
		aOnlyRB.Disable();
		aEndRB.Disable();
		aEndPageRB.Disable();
	}
}

//------------------------------------------------------------------------

SfxTabPage*	SwAddPrinterTabPage::Create( Window* pParent,
									   const SfxItemSet& rAttrSet )
{
	return ( new SwAddPrinterTabPage( pParent, rAttrSet ) );
}
//------------------------------------------------------------------------


BOOL 	SwAddPrinterTabPage::FillItemSet( SfxItemSet& rCoreSet )
{
	if ( bAttrModified )
	{
		SwAddPrinterItem aAddPrinterAttr (FN_PARAM_ADDPRINTER);
		aAddPrinterAttr.bPrintGraphic 	= aGrfCB.IsChecked();
		aAddPrinterAttr.bPrintTable 	= aTabCB.IsChecked();
        aAddPrinterAttr.bPrintDraw   = aDrawCB.IsChecked();
		aAddPrinterAttr.bPrintControl 	= aCtrlFldCB.IsChecked();
		aAddPrinterAttr.bPrintPageBackground = aBackgroundCB.IsChecked();
		aAddPrinterAttr.bPrintBlackFont = aBlackFontCB.IsChecked();

		aAddPrinterAttr.bPrintLeftPage	= aLeftPageCB.IsChecked();
		aAddPrinterAttr.bPrintRightPage = aRightPageCB.IsChecked();
		aAddPrinterAttr.bPrintReverse 	= aReverseCB.IsChecked();
		aAddPrinterAttr.bPrintProspect  = aProspectCB.IsChecked();
		aAddPrinterAttr.bPaperFromSetup = aPaperFromSetupCB.IsChecked();
		aAddPrinterAttr.bPrintSingleJobs = aSingleJobsCB.IsChecked();

		if (aNoRB.IsChecked()) 	aAddPrinterAttr.nPrintPostIts =
														POSTITS_NONE;
		if (aOnlyRB.IsChecked()) aAddPrinterAttr.nPrintPostIts =
														POSTITS_ONLY;
		if (aEndRB.IsChecked()) aAddPrinterAttr.nPrintPostIts =
														POSTITS_ENDDOC;
		if (aEndPageRB.IsChecked()) aAddPrinterAttr.nPrintPostIts =
														POSTITS_ENDPAGE;

        String sFax = aFaxLB.GetSelectEntry();
        aAddPrinterAttr.sFaxName = sNone == sFax ? aEmptyStr : sFax;
		rCoreSet.Put(aAddPrinterAttr);
	}
	return bAttrModified;
}
//------------------------------------------------------------------------


void 	SwAddPrinterTabPage::Reset( const SfxItemSet&  )
{
	const 	SfxItemSet&			rSet = GetItemSet();
	const 	SwAddPrinterItem*	pAddPrinterAttr = 0;

	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_ADDPRINTER , FALSE,
									(const SfxPoolItem**)&pAddPrinterAttr ))
	{
		aGrfCB.Check(			pAddPrinterAttr->bPrintGraphic);
		aTabCB.Check(			pAddPrinterAttr->bPrintTable);
        aDrawCB.Check(          pAddPrinterAttr->bPrintDraw);
		aCtrlFldCB.Check(		pAddPrinterAttr->bPrintControl);
		aBackgroundCB.Check(    pAddPrinterAttr->bPrintPageBackground);
		aBlackFontCB.Check(		pAddPrinterAttr->bPrintBlackFont);
		aLeftPageCB.Check(		pAddPrinterAttr->bPrintLeftPage);
		aRightPageCB.Check(		pAddPrinterAttr->bPrintRightPage);
		aReverseCB.Check(		pAddPrinterAttr->bPrintReverse);
		aPaperFromSetupCB.Check(pAddPrinterAttr->bPaperFromSetup);
		aProspectCB.Check(      pAddPrinterAttr->bPrintProspect);
		aSingleJobsCB.Check(    pAddPrinterAttr->bPrintSingleJobs);

		aNoRB.Check (pAddPrinterAttr->nPrintPostIts== POSTITS_NONE ) ;
		aOnlyRB.Check (pAddPrinterAttr->nPrintPostIts== POSTITS_ONLY ) ;
		aEndRB.Check (pAddPrinterAttr->nPrintPostIts== POSTITS_ENDDOC ) ;
		aEndPageRB.Check (pAddPrinterAttr->nPrintPostIts== POSTITS_ENDPAGE ) ;
        aFaxLB.SelectEntry( pAddPrinterAttr->sFaxName );
	}
}
//-----------------------------------------------------------------------

//-----------------------------------------------------------------------


void 	SwAddPrinterTabPage::Init()
{

}
//------------------------------------------------------------------------


IMPL_LINK_INLINE_START( SwAddPrinterTabPage, AutoClickHdl, CheckBox *, EMPTYARG )
{
	bAttrModified = TRUE;
	return 0;
}
IMPL_LINK_INLINE_END( SwAddPrinterTabPage, AutoClickHdl, CheckBox *, EMPTYARG )

//------------------------------------------------------------------------


void  SwAddPrinterTabPage::SetFax( const SvStringsDtor& rFaxLst )
{
    aFaxLB.InsertEntry(sNone);
    for ( USHORT i = 0; i < rFaxLst.Count(); ++i )
		aFaxLB.InsertEntry( *rFaxLst.GetObject(i) );
    aFaxLB.SelectEntryPos(0);
}

//------------------------------------------------------------------------


IMPL_LINK_INLINE_START( SwAddPrinterTabPage, SelectHdl, ListBox *, EMPTYARG )
{
	bAttrModified=TRUE;
	return 0;
}
IMPL_LINK_INLINE_END( SwAddPrinterTabPage, SelectHdl, ListBox *, EMPTYARG )

void SwAddPrinterTabPage::PageCreated (SfxAllItemSet aSet) //add CHINA001
{
	//SFX_ITEMSET_ARG (&aSet,pListItem,SfxStringListItem,SID_FAX_LIST,sal_False);
	SFX_ITEMSET_ARG (&aSet,pListItem,SfxBoolItem,SID_FAX_LIST,sal_False);
	SFX_ITEMSET_ARG (&aSet,pPreviewItem,SfxBoolItem,SID_PREVIEWFLAG_TYPE,sal_False);
	if (pPreviewItem)
	{
		SetPreview(pPreviewItem->GetValue());
		Reset(aSet);
	}
	if (pListItem && pListItem->GetValue())
	{
		SvStringsDtor aFaxList;
		const USHORT nCount = Printer::GetQueueCount();
		for (USHORT i = 0; i < nCount; ++i)
		{
			String* pString = new String( Printer::GetQueueInfo( i ).GetPrinterName());
			String* &rpString = pString;
			aFaxList.Insert(rpString, 0);
		}
		SetFax( aFaxList );
/*		SvStringsDtor aFaxList;
		const List *pList = (pListItem)->GetList();
		sal_uInt32 nCount = pList->Count();
        for(sal_uInt32 i = 0; i < nCount ; i++)
		{
			String* pString = (String*)(pList->GetObject(i));
			String* &rpString = pString;
			aFaxList.Insert(rpString, 0 );
		}
		SetFax(aFaxList);
*/
	}
}
/*-----------------03.09.96 11.53-------------------
	Tabpage Standardfonts
--------------------------------------------------*/


SwStdFontTabPage::SwStdFontTabPage( Window* pParent,
									   const SfxItemSet& rSet ) :
	SfxTabPage( pParent, SW_RES( TP_STD_FONT ), rSet),
    aStandardLbl(this, SW_RES(FT_STANDARD)),
    aStandardBox(this, SW_RES(LB_STANDARD)),
    aTitleLbl   (this, SW_RES(FT_TITLE   )),
    aTitleBox   (this, SW_RES(LB_TITLE   )),
    aListLbl    (this, SW_RES(FT_LIST    )),
    aListBox    (this, SW_RES(LB_LIST    )),
    aLabelLbl   (this, SW_RES(FT_LABEL   )),
    aLabelBox   (this, SW_RES(LB_LABEL   )),
    aIdxLbl     (this, SW_RES(FT_IDX     )),
    aIdxBox     (this, SW_RES(LB_IDX     )),
    aStdChrFL  (this, SW_RES(FL_STDCHR  )),
	aDocOnlyCB  (this, SW_RES(CB_DOCONLY )),
	aStandardPB (this, SW_RES(PB_STANDARD)),
    sScriptWestern(ResId(ST_SCRIPT_WESTERN)),
    sScriptAsian(ResId(ST_SCRIPT_ASIAN)),
    sScriptComplex(ResId(ST_SCRIPT_CTL)),
    pPrt(0),
	pFontConfig(0),
	pWrtShell(0),
	bListDefault(FALSE),
	bLabelDefault(FALSE),
	bSetListDefault(TRUE),
	bSetLabelDefault(TRUE),
	bSetIdxDefault(TRUE),
	bIdxDefault(FALSE),
    bDeletePrinter(FALSE),
    nFontGroup(FONT_GROUP_DEFAULT),
    eLanguage( GetAppLanguage() )
{
	FreeResource();
	aStandardPB.SetClickHdl(LINK(this, SwStdFontTabPage, StandardHdl));
	aStandardBox.SetModifyHdl( LINK(this, SwStdFontTabPage, ModifyHdl));
	aListBox    .SetModifyHdl( LINK(this, SwStdFontTabPage, ModifyHdl));
	aLabelBox	.SetModifyHdl( LINK(this, SwStdFontTabPage, ModifyHdl));
	aIdxBox		.SetModifyHdl( LINK(this, SwStdFontTabPage, ModifyHdl));

	aDocOnlyCB.Check(SW_MOD()->GetModuleConfig()->IsDefaultFontInCurrDocOnly());
}

/*-----------------03.09.96 11.53-------------------

--------------------------------------------------*/

SwStdFontTabPage::~SwStdFontTabPage()
{
	if(bDeletePrinter)
		delete pPrt;
}

/*-----------------03.09.96 11.53-------------------

--------------------------------------------------*/
SfxTabPage*	SwStdFontTabPage::Create( Window* pParent,
								const SfxItemSet& rAttrSet )
{
	return new SwStdFontTabPage(pParent, rAttrSet);
}

/*-----------------03.09.96 11.53-------------------

--------------------------------------------------*/
void lcl_SetColl(SwWrtShell* pWrtShell, USHORT nType,
                    SfxPrinter* pPrt, const String& rStyle,
                    USHORT nFontWhich)
{
	BOOL bDelete = FALSE;
	const SfxFont* pFnt = pPrt ? pPrt->GetFontByName(rStyle): 0;
	if(!pFnt)
	{
		pFnt = new SfxFont(FAMILY_DONTKNOW, rStyle);
		bDelete = TRUE;
	}
	SwTxtFmtColl *pColl = pWrtShell->GetTxtCollFromPool(nType);
	pColl->SetAttr(SvxFontItem(pFnt->GetFamily(), pFnt->GetName(),
                aEmptyStr, pFnt->GetPitch(), pFnt->GetCharSet(), nFontWhich));
	if(bDelete)
	{
		delete (SfxFont*) pFnt;
		bDelete = FALSE;
	}
}
/*-----------------03.09.96 11.53-------------------

--------------------------------------------------*/
BOOL SwStdFontTabPage::FillItemSet( SfxItemSet& rSet )
{
	BOOL bNotDocOnly = !aDocOnlyCB.IsChecked();
	SW_MOD()->GetModuleConfig()->SetDefaultFontInCurrDocOnly(!bNotDocOnly);

	String sStandard 	= aStandardBox.GetText();
	String sTitle 		=  aTitleBox   .GetText();
	String sList 		=  aListBox    .GetText();
	String sLabel 		=  aLabelBox   .GetText();
	String sIdx 		=  aIdxBox     .GetText();
	String sStandardBak	= aStandardBox.GetSavedValue();
	String sTitleBak 	= aTitleBox   .GetSavedValue();
	String sListBak 	= aListBox    .GetSavedValue();
	String sLabelBak 	= aLabelBox   .GetSavedValue();
	String sIdxBak  	= aIdxBox     .GetSavedValue();


	if(bNotDocOnly)
	{
        pFontConfig->SetFontStandard(sStandard, nFontGroup);
        pFontConfig->SetFontOutline(sTitle, nFontGroup);
        pFontConfig->SetFontList(sList, nFontGroup);
        pFontConfig->SetFontCaption(sLabel, nFontGroup);
        pFontConfig->SetFontIndex(sIdx, nFontGroup);
	}
	if(pWrtShell)
	{
		pWrtShell->StartAllAction();
		SfxPrinter* pPrt = pWrtShell->GetPrt();
		BOOL bMod = FALSE;
        USHORT nFontWhich = nFontGroup == FONT_GROUP_DEFAULT  ? RES_CHRATR_FONT :
            FONT_GROUP_CJK == nFontGroup ? RES_CHRATR_CJK_FONT : RES_CHRATR_CTL_FONT;
        if(sStandard != sShellStd)
		{
			BOOL bDelete = FALSE;
			const SfxFont* pFnt = pPrt ? pPrt->GetFontByName(sStandard): 0;
			if(!pFnt)
			{
				pFnt = new SfxFont(FAMILY_DONTKNOW, sStandard);
				bDelete = TRUE;
			}
			pWrtShell->SetDefault(SvxFontItem(pFnt->GetFamily(), pFnt->GetName(),
                                aEmptyStr, pFnt->GetPitch(), pFnt->GetCharSet(), nFontWhich));
			SwTxtFmtColl *pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_STANDARD);
            pColl->ResetAttr(nFontWhich);
			if(bDelete)
			{
				delete (SfxFont*) pFnt;
				bDelete = FALSE;
			}
//			lcl_SetColl(pWrtShell, RES_POOLCOLL_STANDARD, pPrt, sStandard);
			bMod = TRUE;
		}
		if(sTitle != sShellTitle )
		{
            lcl_SetColl(pWrtShell, RES_POOLCOLL_HEADLINE_BASE, pPrt, sTitle, nFontWhich);
			bMod = TRUE;
		}
		if(sList != sShellList && (!bListDefault || !bSetListDefault ))
		{
            lcl_SetColl(pWrtShell, RES_POOLCOLL_NUMBUL_BASE, pPrt, sList, nFontWhich);
			bMod = TRUE;
		}
		if(sLabel != sShellLabel && (!bLabelDefault || !bSetLabelDefault))
		{
            lcl_SetColl(pWrtShell, RES_POOLCOLL_LABEL, pPrt, sLabel, nFontWhich);
			bMod = TRUE;
		}
		if(sIdx != sShellIndex && (!bIdxDefault || !bSetIdxDefault))
		{
            lcl_SetColl(pWrtShell, RES_POOLCOLL_REGISTER_BASE, pPrt, sIdx, nFontWhich);
			bMod = TRUE;
		}
		if ( bMod )
			pWrtShell->SetModified();
		pWrtShell->EndAllAction();
	}

	return FALSE;
}

/*-----------------03.09.96 11.53-------------------

--------------------------------------------------*/
void SwStdFontTabPage::Reset( const SfxItemSet& rSet )
{
    const SfxPoolItem* pLang;
    USHORT nLangSlot = nFontGroup == FONT_GROUP_DEFAULT  ? SID_ATTR_LANGUAGE :
        FONT_GROUP_CJK == nFontGroup ? SID_ATTR_CHAR_CJK_LANGUAGE : SID_ATTR_CHAR_CTL_LANGUAGE;


    if( SFX_ITEM_SET == rSet.GetItemState(nLangSlot, FALSE, &pLang))
        eLanguage = ((const SvxLanguageItem*)pLang)->GetValue();

    String sTmp(aStdChrFL.GetText());
    String sToReplace = sScriptWestern;
    if(FONT_GROUP_CJK == nFontGroup )
        sToReplace = sScriptAsian;
    else if(FONT_GROUP_CTL == nFontGroup )
        sToReplace = sScriptComplex;

    sTmp.SearchAndReplaceAscii("%1", sToReplace);
    aStdChrFL.SetText(sTmp);
    const SfxPoolItem* pItem;

	if(SFX_ITEM_SET == rSet.GetItemState(FN_PARAM_PRINTER, FALSE, &pItem))
	{
		pPrt = (SfxPrinter*)((const SwPtrItem*)pItem)->GetValue();
	}
	else
	{
		SfxItemSet* pSet = new SfxItemSet( *rSet.GetPool(),
					SID_PRINTER_NOTFOUND_WARN, SID_PRINTER_NOTFOUND_WARN,
					SID_PRINTER_CHANGESTODOC, SID_PRINTER_CHANGESTODOC,
					0 );
		pPrt = new SfxPrinter(pSet);
		bDeletePrinter = TRUE;
	}
	const USHORT nCount = pPrt->GetFontCount();
	for (USHORT i = 0; i < nCount; ++i)
	{
		const String &rString = pPrt->GetFont(i)->GetName();
		aStandardBox.InsertEntry( rString );
		aTitleBox   .InsertEntry( rString );
		aListBox    .InsertEntry( rString );
		aLabelBox   .InsertEntry( rString );
		aIdxBox     .InsertEntry( rString );
	}
	if(SFX_ITEM_SET == rSet.GetItemState(FN_PARAM_STDFONTS, FALSE, &pItem))
	{
		 pFontConfig = (SwStdFontConfig*)((const SwPtrItem*)pItem)->GetValue();
	}

	if(SFX_ITEM_SET == rSet.GetItemState(FN_PARAM_WRTSHELL, FALSE, &pItem))
	{
		pWrtShell = (SwWrtShell*)((const SwPtrItem*)pItem)->GetValue();
	}
	String sStdBackup;
	String sOutBackup;
	String sListBackup;
	String sCapBackup;
	String sIdxBackup;

	if(!pWrtShell)
	{
       sStdBackup = pFontConfig->GetFontStandard(nFontGroup);
       sOutBackup = pFontConfig->GetFontOutline(nFontGroup);
       sListBackup= pFontConfig->GetFontList(nFontGroup);
       sCapBackup = pFontConfig->GetFontCaption(nFontGroup);
       sIdxBackup = pFontConfig->GetFontIndex(nFontGroup);
	   aDocOnlyCB.Enable(FALSE);
	}
	else
	{
		SwTxtFmtColl *pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_STANDARD);
        const SvxFontItem& rFont = !nFontGroup ? pColl->GetFont() :
                FONT_GROUP_CJK == nFontGroup ? pColl->GetCJKFont() : pColl->GetCTLFont();
        sShellStd = sStdBackup =  rFont.GetFamilyName();

		pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_HEADLINE_BASE);
        const SvxFontItem& rFontHL = !nFontGroup ? pColl->GetFont() :
                FONT_GROUP_CJK == nFontGroup ? pColl->GetCJKFont() : pColl->GetCTLFont();
        sShellTitle = sOutBackup = rFontHL.GetFamilyName();

        USHORT nFontWhich = nFontGroup == FONT_GROUP_DEFAULT  ? RES_CHRATR_FONT :
            FONT_GROUP_CJK == nFontGroup ? RES_CHRATR_CJK_FONT : RES_CHRATR_CTL_FONT;
        pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_NUMBUL_BASE);
        const SvxFontItem& rFontLS = !nFontGroup ? pColl->GetFont() :
                FONT_GROUP_CJK == nFontGroup ? pColl->GetCJKFont() : pColl->GetCTLFont();
        bListDefault = SFX_ITEM_DEFAULT == pColl->GetAttrSet().GetItemState(nFontWhich, FALSE);
        sShellList = sListBackup = rFontLS.GetFamilyName();

		pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_LABEL);
        bLabelDefault = SFX_ITEM_DEFAULT == pColl->GetAttrSet().GetItemState(nFontWhich, FALSE);
        const SvxFontItem& rFontCP = !nFontGroup ? pColl->GetFont() :
                FONT_GROUP_CJK == nFontGroup ? pColl->GetCJKFont() : pColl->GetCTLFont();
        sShellLabel = sCapBackup = rFontCP.GetFamilyName();

		pColl = pWrtShell->GetTxtCollFromPool(RES_POOLCOLL_REGISTER_BASE);
        bIdxDefault = SFX_ITEM_DEFAULT == pColl->GetAttrSet().GetItemState(nFontWhich, FALSE);
        const SvxFontItem& rFontIDX = !nFontGroup ? pColl->GetFont() :
                FONT_GROUP_CJK == nFontGroup ? pColl->GetCJKFont() : pColl->GetCTLFont();
        sShellIndex = sIdxBackup = rFontIDX.GetFamilyName();
	}
	aStandardBox.SetText(sStdBackup );
	aTitleBox   .SetText(sOutBackup );
	aListBox    .SetText(sListBackup);
	aLabelBox   .SetText(sCapBackup );
	aIdxBox     .SetText(sIdxBackup );

	aStandardBox.SaveValue();
	aTitleBox   .SaveValue();
	aListBox    .SaveValue();
	aLabelBox   .SaveValue();
	aIdxBox     .SaveValue();
}

/*-----------------07.09.96 12.28-------------------

--------------------------------------------------*/


IMPL_LINK( SwStdFontTabPage, StandardHdl, PushButton *, EMPTYARG )
{
    sal_uInt8 nFontOffset = nFontGroup * FONT_PER_GROUP;
    aStandardBox.SetText(SwStdFontConfig::GetDefaultFor(FONT_STANDARD + nFontOffset, eLanguage));
    aTitleBox   .SetText(SwStdFontConfig::GetDefaultFor(FONT_OUTLINE  + nFontOffset, eLanguage));
    aListBox    .SetText(SwStdFontConfig::GetDefaultFor(FONT_LIST     + nFontOffset, eLanguage));
    aLabelBox   .SetText(SwStdFontConfig::GetDefaultFor(FONT_CAPTION  + nFontOffset, eLanguage));
    aIdxBox     .SetText(SwStdFontConfig::GetDefaultFor(FONT_INDEX    + nFontOffset, eLanguage));

	aStandardBox.SaveValue();
	aTitleBox   .SaveValue();
	aListBox    .SaveValue();
	aLabelBox   .SaveValue();
	aIdxBox     .SaveValue();

	return 0;
}
/*-----------------17.01.97 15.43-------------------

--------------------------------------------------*/

IMPL_LINK( SwStdFontTabPage, ModifyHdl, ComboBox*, pBox )
{
	if(pBox == &aStandardBox)
	{
		String sEntry = pBox->GetText();
		if(bSetListDefault && bListDefault)
			aListBox.SetText(sEntry);
		if(bSetLabelDefault && bLabelDefault)
			aLabelBox.SetText(sEntry);
		if(bSetIdxDefault && bIdxDefault)
			aIdxBox.SetText(sEntry);
	}
	else if(pBox == &aListBox)
	{
		bSetListDefault = FALSE;
	}
	else if(pBox == &aLabelBox)
	{
		bSetLabelDefault = FALSE;
	}
	else if(pBox == &aIdxBox)
	{
		bSetIdxDefault = FALSE;
	}
	return 0;
}

void SwStdFontTabPage::PageCreated (SfxAllItemSet aSet) //add CHINA001
{
	SFX_ITEMSET_ARG (&aSet,pFlagItem,SfxUInt16Item,SID_FONTMODE_TYPE,sal_False);
	if (pFlagItem)
		SetFontMode(pFlagItem->GetValue());
}
/*-----------------18.01.97 12.14-------------------
	Optionen Tabelle
--------------------------------------------------*/

SwTableOptionsTabPage::SwTableOptionsTabPage( Window* pParent, const SfxItemSet& rSet ) :
	SfxTabPage(pParent, SW_RES(TP_OPTTABLE_PAGE), rSet),
    aHeaderCB       (this, ResId(CB_HEADER          )),
	aRepeatHeaderCB	(this, ResId(CB_REPEAT_HEADER	)),
	aDontSplitCB	(this, ResId(CB_DONT_SPLIT		)),
	aBorderCB		(this, ResId(CB_BORDER			)),
	aNumFormattingCB(this, ResId(CB_NUMFORMATTING	)),
	aNumFmtFormattingCB(this, ResId(CB_NUMFMT_FORMATTING	)),
	aNumAlignmentCB	(this, ResId(CB_NUMALIGNMENT	)),
    aSeparatorFL     (this, ResId(FL_TABLE_SEPARATOR)),
    aTableFL        (this, ResId(FL_TABLE           )),
    aTableInsertFL  (this, ResId(FL_TABLE_INSERT    )),
    aMoveFL(        this, ResId(FL_MOVE     )),
    aMoveFT(        this, ResId(FT_MOVE     )),
    aRowMoveFT(     this, ResId(FT_ROWMOVE  )),
	aRowMoveMF(		this, ResId(MF_ROWMOVE	)),
	aColMoveFT(		this, ResId(FT_COLMOVE	)),
	aColMoveMF(		this, ResId(MF_COLMOVE	)),
    aInsertFT(      this, ResId(FT_INSERT   )),
	aRowInsertFT(	this, ResId(FT_ROWINSERT)),
	aRowInsertMF(	this, ResId(MF_ROWINSERT)),
	aColInsertFT(	this, ResId(FT_COLINSERT)),
	aColInsertMF(	this, ResId(MF_COLINSERT)),
    aHandlingFT(    this, ResId(FT_HANDLING )),
	aFixRB(			this, ResId(RB_FIX		)),
	aFixFT(			this, ResId(FT_FIX		)),
	aFixPropRB(		this, ResId(RB_FIXPROP	)),
	aFixPropFT(		this, ResId(FT_FIXPROP 	)),
	aVarRB(			this, ResId(RB_VAR		)),
	aVarFT(			this, ResId(FT_VAR		)),
    pWrtShell(0),
    bHTMLMode(FALSE)
{
	FreeResource();

    Link aLnk(LINK(this, SwTableOptionsTabPage, CheckBoxHdl));
	aNumFormattingCB.SetClickHdl(aLnk);
	aNumFmtFormattingCB.SetClickHdl(aLnk);
	aHeaderCB.SetClickHdl(aLnk);
}

/*-----------------18.01.97 12.43-------------------

--------------------------------------------------*/

SwTableOptionsTabPage::~SwTableOptionsTabPage()
{
}

/*-----------------18.01.97 12.43-------------------

--------------------------------------------------*/

SfxTabPage*	SwTableOptionsTabPage::Create( Window* pParent,
								const SfxItemSet& rAttrSet )
{
	return new SwTableOptionsTabPage(pParent, rAttrSet );
}

/*-----------------18.01.97 12.42-------------------

--------------------------------------------------*/

BOOL SwTableOptionsTabPage::FillItemSet( SfxItemSet& rSet )
{
	BOOL bRet = FALSE;
	SwModuleOptions* pModOpt = SW_MOD()->GetModuleConfig();

	if(aRowMoveMF.IsModified())
		pModOpt->SetTblHMove( (USHORT)aRowMoveMF.Denormalize( aRowMoveMF.GetValue(FUNIT_TWIP)));

	if(aColMoveMF.IsModified())
		pModOpt->SetTblVMove( (USHORT)aColMoveMF.Denormalize( aColMoveMF.GetValue(FUNIT_TWIP)));

	if(aRowInsertMF.IsModified())
		pModOpt->SetTblHInsert((USHORT)aRowInsertMF.Denormalize( aRowInsertMF.GetValue(FUNIT_TWIP)));

	if(aColInsertMF.IsModified())
		pModOpt->SetTblVInsert((USHORT)aColInsertMF.Denormalize( aColInsertMF.GetValue(FUNIT_TWIP)));

	TblChgMode eMode;
	if(aFixRB.IsChecked())
		eMode = TBLFIX_CHGABS;
	else if(aFixPropRB.IsChecked())
		eMode = TBLFIX_CHGPROP;
	else
		eMode = TBLVAR_CHGABS;
	if(eMode != pModOpt->GetTblMode())
	{
		pModOpt->SetTblMode(eMode);
		// der Tabellen-Tastatur-Modus hat sich geaendert, das soll
		// jetzt auch die aktuelle Tabelle erfahren
		if(pWrtShell && SwWrtShell::SEL_TBL & pWrtShell->GetSelectionType())
		{
			pWrtShell->SetTblChgMode(eMode);
			static USHORT __READONLY_DATA aInva[] =
								{   FN_TABLE_MODE_FIX,
									FN_TABLE_MODE_FIX_PROP,
									FN_TABLE_MODE_VARIABLE,
									0
								};
			pWrtShell->GetView().GetViewFrame()->GetBindings().Invalidate( aInva );
		}

		bRet = TRUE;
	}

    SwInsertTableOptions aInsOpts( 0, 0 );

	if (aHeaderCB.IsChecked())
        aInsOpts.mnInsMode |= tabopts::HEADLINE;

	if (aRepeatHeaderCB.IsEnabled() )
		aInsOpts.mnRowsToRepeat = aRepeatHeaderCB.IsChecked()? 1 : 0;

	if (!aDontSplitCB.IsChecked())
        aInsOpts.mnInsMode |= tabopts::SPLIT_LAYOUT;

	if (aBorderCB.IsChecked())
        aInsOpts.mnInsMode |= tabopts::DEFAULT_BORDER;

	if (aHeaderCB.GetSavedValue() != aHeaderCB.GetState() ||
		aRepeatHeaderCB.GetSavedValue() != aRepeatHeaderCB.GetState() ||
		aDontSplitCB.GetSavedValue() != aDontSplitCB.GetState() ||
		aBorderCB.GetSavedValue() != aBorderCB.GetState())
	{
		pModOpt->SetInsTblFlags(bHTMLMode, aInsOpts);
	}

	if (aNumFormattingCB.GetSavedValue() != aNumFormattingCB.GetState())
	{
		pModOpt->SetInsTblFormatNum(bHTMLMode, aNumFormattingCB.IsChecked());
		bRet = TRUE;
	}

	if (aNumFmtFormattingCB.GetSavedValue() != aNumFmtFormattingCB.GetState())
	{
		pModOpt->SetInsTblChangeNumFormat(bHTMLMode, aNumFmtFormattingCB.IsChecked());
		bRet = TRUE;
	}

	if (aNumAlignmentCB.GetSavedValue() != aNumAlignmentCB.GetState())
	{
		pModOpt->SetInsTblAlignNum(bHTMLMode, aNumAlignmentCB.IsChecked());
		bRet = TRUE;
	}

    return bRet;
}
/*-----------------18.01.97 12.42-------------------

--------------------------------------------------*/
void SwTableOptionsTabPage::Reset( const SfxItemSet& rSet)
{
	const SwModuleOptions* pModOpt = SW_MOD()->GetModuleConfig();
	if ( rSet.GetItemState( SID_ATTR_METRIC ) >= SFX_ITEM_AVAILABLE )
	{
		const SfxUInt16Item& rItem = (SfxUInt16Item&)rSet.Get( SID_ATTR_METRIC );
		FieldUnit eFieldUnit = (FieldUnit)rItem.GetValue();
		::SetFieldUnit( aRowMoveMF, eFieldUnit );
		::SetFieldUnit( aColMoveMF, eFieldUnit );
		::SetFieldUnit( aRowInsertMF, eFieldUnit );
		::SetFieldUnit( aColInsertMF, eFieldUnit );
	}

	aRowMoveMF  .SetValue(aRowMoveMF.Normalize(pModOpt->GetTblHMove()), FUNIT_TWIP);
	aColMoveMF  .SetValue(aColMoveMF.Normalize(pModOpt->GetTblVMove()), FUNIT_TWIP);
	aRowInsertMF.SetValue(aRowInsertMF.Normalize(pModOpt->GetTblHInsert()), FUNIT_TWIP);
	aColInsertMF.SetValue(aColInsertMF.Normalize(pModOpt->GetTblVInsert()), FUNIT_TWIP);

	switch(pModOpt->GetTblMode())
	{
		case TBLFIX_CHGABS: 	aFixRB.Check();		break;
		case TBLFIX_CHGPROP: 	aFixPropRB.Check();	break;
		case TBLVAR_CHGABS: 	aVarRB.Check();	break;
	}
    const SfxPoolItem* pItem;
	if(SFX_ITEM_SET == rSet.GetItemState(SID_HTML_MODE, FALSE, &pItem))
	{
		bHTMLMode = 0 != (((const SfxUInt16Item*)pItem)->GetValue() & HTMLMODE_ON);
	}

	//bestimmte Controls fuer HTML verstecken
	if(bHTMLMode)
	{
/*        Point aPos(aCaptionFL.GetPosPixel());
        long nYDiff = aTableFL.GetPosPixel().Y() - aPos.Y();
        aTableFL.SetPosPixel(aPos);

		aPos = aHeaderCB.GetPosPixel();
		aPos.Y() -= nYDiff;
		aHeaderCB.SetPosPixel(aPos);

		aPos = aRepeatHeaderCB.GetPosPixel();
		aPos.Y() -= nYDiff;
		aRepeatHeaderCB.SetPosPixel(aPos);

		aPos = aDontSplitCB.GetPosPixel(); // hier muss eine Luecke geschlossen werden
		aPos.Y() -= nYDiff;
		aBorderCB.SetPosPixel(aPos);

        aPos = aTableInsertFL.GetPosPixel();
		aPos.Y() -= nYDiff;
        aTableInsertFL.SetPosPixel(aPos);

		aPos = aNumFormattingCB.GetPosPixel();
		aPos.Y() -= nYDiff;
		aNumFormattingCB.SetPosPixel(aPos);

		aPos = aNumFmtFormattingCB.GetPosPixel();
		aPos.Y() -= nYDiff;
		aNumFmtFormattingCB.SetPosPixel(aPos);

		aPos = aNumAlignmentCB.GetPosPixel();
		aPos.Y() -= nYDiff;
		aNumAlignmentCB.SetPosPixel(aPos);

        aCaptionFL.Hide();
		aCaptionCB.Hide();
		aCaptionFT.Hide();
		aCaptionPB.Hide();
*/
		aDontSplitCB.Hide();
	}

	SwInsertTableOptions aInsOpts = pModOpt->GetInsTblFlags(bHTMLMode);
	USHORT nInsTblFlags = aInsOpts.mnInsMode;

    aHeaderCB.Check(nInsTblFlags & tabopts::HEADLINE);
    aRepeatHeaderCB.Check(aInsOpts.mnRowsToRepeat > 0);
    aDontSplitCB.Check(!(nInsTblFlags & tabopts::SPLIT_LAYOUT));
    aBorderCB.Check(nInsTblFlags & tabopts::DEFAULT_BORDER);

	aNumFormattingCB.Check(pModOpt->IsInsTblFormatNum(bHTMLMode));
	aNumFmtFormattingCB.Check(pModOpt->IsInsTblChangeNumFormat(bHTMLMode));
	aNumAlignmentCB.Check(pModOpt->IsInsTblAlignNum(bHTMLMode));

    aHeaderCB.SaveValue();
	aRepeatHeaderCB.SaveValue();
	aDontSplitCB.SaveValue();
	aBorderCB.SaveValue();
	aNumFormattingCB.SaveValue();
	aNumFmtFormattingCB.SaveValue();
	aNumAlignmentCB.SaveValue();

    CheckBoxHdl(0);
}
/*-----------------18.01.97 12.42-------------------

--------------------------------------------------*/
IMPL_LINK(SwTableOptionsTabPage, CheckBoxHdl, CheckBox*, EMPTYARG)
{
	aNumFmtFormattingCB.Enable(aNumFormattingCB.IsChecked());
	aNumAlignmentCB.Enable(aNumFormattingCB.IsChecked());
	aRepeatHeaderCB.Enable(aHeaderCB.IsChecked());
	return 0;
}
void SwTableOptionsTabPage::PageCreated (SfxAllItemSet aSet) //add CHINA001
{
	SFX_ITEMSET_ARG (&aSet,pWrtSh,SwWrtShellItem,SID_WRT_SHELL,sal_False);
	if (pWrtSh)
		SetWrtShell(pWrtSh->GetValue());
}
/*  */

/*-----------------31.10.97 17:55-------------------
 TabPage fuer ShadowCrsr
--------------------------------------------------*/

SwShdwCrsrOptionsTabPage::SwShdwCrsrOptionsTabPage( Window* pParent,
													const SfxItemSet& rSet )
	: SfxTabPage(pParent, SW_RES(TP_OPTSHDWCRSR), rSet),
    aFlagFL( this, ResId( FL_SHDWCRSFLAG )),
    aOnOffCB( this, ResId( CB_SHDWCRSONOFF )),
    aFillModeFT( this, ResId( FT_SHDWCRSFILLMODE )),
    aFillMarginRB( this, ResId( RB_SHDWCRSFILLMARGIN )),
    aFillIndentRB( this, ResId( RB_SHDWCRSFILLINDENT )),
    aFillTabRB( this, ResId( RB_SHDWCRSFILLTAB )),
    aFillSpaceRB( this, ResId( RB_SHDWCRSFILLSPACE )),
    aCrsrOptFL   ( this, ResId( FL_CRSR_OPT)),
    aCrsrInProtCB( this, ResId( CB_ALLOW_IN_PROT )),
    aSeparatorFL(   this, ResId( FL_SEPARATOR_SHDW)),
    aUnprintFL   ( this,   ResId( FL_NOPRINT  ) ),
    aParaCB       ( this,   ResId( CB_PARA      ) ),
    aSHyphCB      ( this,   ResId( CB_SHYPH        ) ),
    aSpacesCB     ( this,   ResId( CB_SPACE    ) ),
    aHSpacesCB    ( this,   ResId( CB_HSPACE   ) ),
    aTabCB        ( this,   ResId( CB_TAB      ) ),
    aBreakCB      ( this,   ResId( CB_BREAK        ) ),
    aCharHiddenCB     ( this,   ResId( CB_CHAR_HIDDEN   ) ),
    aFldHiddenCB     ( this,   ResId( CB_FLD_HIDDEN   ) ),
    aFldHiddenParaCB ( this,   ResId( CB_FLD_HIDDEN_PARA ) )
{
	FreeResource();
    const SfxPoolItem* pItem = 0;
	SwShadowCursorItem aOpt;

	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_SHADOWCURSOR, FALSE, &pItem ))
		aOpt = *(SwShadowCursorItem*)pItem;

	aOnOffCB.Check( aOpt.IsOn() );

	BYTE eMode = aOpt.GetMode();
	aFillIndentRB.Check( FILL_INDENT == eMode );
	aFillMarginRB.Check( FILL_MARGIN == eMode );
	aFillTabRB.Check( FILL_TAB == eMode );
	aFillSpaceRB.Check( FILL_SPACE == eMode );

    if(SFX_ITEM_SET == rSet.GetItemState(SID_HTML_MODE, FALSE, &pItem )
		&& ((SfxUInt16Item*)pItem)->GetValue() & HTMLMODE_ON)
	{
		aTabCB		.Hide();
        aCharHiddenCB.Hide();
        aFldHiddenCB    .Hide();
        aFldHiddenParaCB.Hide();
        aBreakCB.SetPosPixel(aTabCB.GetPosPixel());
        aFlagFL         .Hide();
        aOnOffCB        .Hide();
        aFillModeFT     .Hide();
        aFillMarginRB   .Hide();
        aFillIndentRB   .Hide();
        aFillTabRB      .Hide();
        aFillSpaceRB    .Hide();
        aCrsrOptFL      .Hide();
        aCrsrInProtCB   .Hide();
        aSeparatorFL.Hide();
        long nWidth = aFlagFL.GetSizePixel().Width() + aFlagFL.GetPosPixel().X()
                                                        - aUnprintFL.GetPosPixel().X();
        Size aSize(aUnprintFL.GetSizePixel());
        aSize.Width() = nWidth;
        aUnprintFL.SetSizePixel(aSize);
    }
}

SwShdwCrsrOptionsTabPage::~SwShdwCrsrOptionsTabPage()
{
}


SfxTabPage*	SwShdwCrsrOptionsTabPage::Create( Window* pParent, const SfxItemSet& rSet )
{
	return new SwShdwCrsrOptionsTabPage( pParent, rSet );
}

BOOL SwShdwCrsrOptionsTabPage::FillItemSet( SfxItemSet& rSet )
{
	SwShadowCursorItem aOpt;
	aOpt.SetOn( aOnOffCB.IsChecked() );

	BYTE eMode;
	if( aFillIndentRB.IsChecked() )
		eMode= FILL_INDENT;
	else if( aFillMarginRB.IsChecked() )
		eMode = FILL_MARGIN;
	else if( aFillTabRB.IsChecked() )
		eMode = FILL_TAB;
	else
		eMode = FILL_SPACE;
	aOpt.SetMode( eMode );

	BOOL bRet = FALSE;
	const SfxPoolItem* pItem = 0;
	if( SFX_ITEM_SET != rSet.GetItemState( FN_PARAM_SHADOWCURSOR, FALSE, &pItem )
		||  ((SwShadowCursorItem&)*pItem) != aOpt )
	{
		rSet.Put( aOpt );
		bRet = TRUE;
	}

	if( aCrsrInProtCB.IsChecked() != aCrsrInProtCB.GetSavedValue())
	{
		rSet.Put(SfxBoolItem(FN_PARAM_CRSR_IN_PROTECTED, aCrsrInProtCB.IsChecked()));
		bRet |= TRUE;
	}

    const SwDocDisplayItem* pOldAttr = (const SwDocDisplayItem*)
						GetOldItem(GetItemSet(), FN_PARAM_DOCDISP);

	SwDocDisplayItem aDisp;
	if(pOldAttr)
		aDisp = *pOldAttr;
    //
    aDisp.bParagraphEnd         = aParaCB       .IsChecked();
    aDisp.bTab                  = aTabCB        .IsChecked();
    aDisp.bSpace                = aSpacesCB     .IsChecked();
    aDisp.bNonbreakingSpace     = aHSpacesCB    .IsChecked();
    aDisp.bSoftHyphen           = aSHyphCB      .IsChecked();
    aDisp.bFldHiddenText        = aFldHiddenCB     .IsChecked();
    aDisp.bCharHiddenText       = aCharHiddenCB.IsChecked();
    aDisp.bShowHiddenPara       = aFldHiddenParaCB .IsChecked();
    aDisp.bManualBreak          = aBreakCB      .IsChecked();

    bRet |= (!pOldAttr || aDisp != *pOldAttr);
	if(bRet)
        bRet = 0 != rSet.Put(aDisp);

    return bRet;
}

void SwShdwCrsrOptionsTabPage::Reset( const SfxItemSet& rSet )
{
	const SfxPoolItem* pItem = 0;
	SwShadowCursorItem aOpt;

	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_SHADOWCURSOR, FALSE, &pItem ))
		aOpt = *(SwShadowCursorItem*)pItem;

	aOnOffCB.Check( aOpt.IsOn() );

	BYTE eMode = aOpt.GetMode();
	aFillIndentRB.Check( FILL_INDENT == eMode );
	aFillMarginRB.Check( FILL_MARGIN == eMode );
	aFillTabRB.Check( FILL_TAB == eMode );
	aFillSpaceRB.Check( FILL_SPACE == eMode );

	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_CRSR_IN_PROTECTED, FALSE, &pItem ))
		aCrsrInProtCB.Check(((const SfxBoolItem*)pItem)->GetValue());
	aCrsrInProtCB.SaveValue();

    const SwDocDisplayItem* pDocDisplayAttr = 0;

	rSet.GetItemState( FN_PARAM_DOCDISP, FALSE,
									(const SfxPoolItem**)&pDocDisplayAttr );
	if(pDocDisplayAttr)
    {
        aParaCB     .Check  (pDocDisplayAttr->bParagraphEnd         );
        aTabCB      .Check  (pDocDisplayAttr->bTab                  );
        aSpacesCB   .Check  (pDocDisplayAttr->bSpace                );
        aHSpacesCB  .Check  (pDocDisplayAttr->bNonbreakingSpace     );
        aSHyphCB    .Check  (pDocDisplayAttr->bSoftHyphen           );
        aCharHiddenCB.Check (pDocDisplayAttr->bCharHiddenText );
        aFldHiddenCB   .Check  (pDocDisplayAttr->bFldHiddenText );
        aFldHiddenParaCB.Check (pDocDisplayAttr->bShowHiddenPara       );
        aBreakCB    .Check  (pDocDisplayAttr->bManualBreak          );
    }
}

/*-----------------31.10.97 17:55-------------------
 TabPage fuer Redlining
--------------------------------------------------*/

struct CharAttr
{
	USHORT nItemId;
	USHORT nAttr;
};

// Editieren entspricht Einfuegen-Attributen
static CharAttr __FAR_DATA aInsertAttr[] =
{
	SID_ATTR_CHAR_CASEMAP,		SVX_CASEMAP_NOT_MAPPED,
	SID_ATTR_CHAR_WEIGHT,		WEIGHT_BOLD,
	SID_ATTR_CHAR_POSTURE,  	ITALIC_NORMAL,
	SID_ATTR_CHAR_UNDERLINE,    UNDERLINE_SINGLE,
	SID_ATTR_CHAR_UNDERLINE,    UNDERLINE_DOUBLE,
    SID_ATTR_CHAR_STRIKEOUT,    STRIKEOUT_SINGLE,
    SID_ATTR_CHAR_CASEMAP,      SVX_CASEMAP_VERSALIEN,
	SID_ATTR_CHAR_CASEMAP,      SVX_CASEMAP_GEMEINE,
	SID_ATTR_CHAR_CASEMAP,      SVX_CASEMAP_KAPITAELCHEN,
	SID_ATTR_CHAR_CASEMAP,      SVX_CASEMAP_TITEL,
	SID_ATTR_BRUSH,				0,
};


/*-----------------------------------------------------------------------
	Beschreibung: Markierungsvorschau
 -----------------------------------------------------------------------*/

SwMarkPreview::SwMarkPreview( Window *pParent, const ResId& rResID ) :

	Window(pParent, rResID),
	m_aTransCol( COL_TRANSPARENT ),
	m_aMarkCol( COL_LIGHTRED ),
	nMarkPos(0)

{
	InitColors();
	SetMapMode(MAP_PIXEL);

	const Size aSz(GetOutputSizePixel());

	// Seite
	aPage.SetSize(Size(aSz.Width() - 3, aSz.Height() - 3));

	ULONG nOutWPix = aPage.GetWidth();
	ULONG nOutHPix = aPage.GetHeight();

	// PrintArea
	ULONG nLBorder = 8;
	ULONG nRBorder = 8;
	ULONG nTBorder = 4;
	ULONG nBBorder = 4;

	aLeftPagePrtArea = Rectangle(Point(nLBorder, nTBorder), Point((nOutWPix - 1) - nRBorder, (nOutHPix - 1) - nBBorder));
	USHORT nWidth = (USHORT)aLeftPagePrtArea.GetWidth();
	USHORT nKorr = (nWidth & 1) != 0 ? 0 : 1;
	aLeftPagePrtArea.SetSize(Size(nWidth / 2 - (nLBorder + nRBorder) / 2 + nKorr, aLeftPagePrtArea.GetHeight()));

	aRightPagePrtArea = aLeftPagePrtArea;
	aRightPagePrtArea.Move(aLeftPagePrtArea.GetWidth() + nLBorder + nRBorder + 1, 0);
}

SwMarkPreview::~SwMarkPreview()
{
}

void SwMarkPreview::InitColors( void )
{
	// m_aTransCol and m_aMarkCol are _not_ changed because they are set from outside!

	const StyleSettings& rSettings = GetSettings().GetStyleSettings();
	m_aBgCol = Color( rSettings.GetWindowColor() );

	BOOL bHC = m_aBgCol.IsDark();
    m_aLineCol = bHC? SwViewOption::GetFontColor() : Color( COL_BLACK );
	m_aShadowCol = bHC? m_aBgCol : rSettings.GetShadowColor();
    m_aTxtCol = bHC? SwViewOption::GetFontColor() : Color( COL_GRAY );
	m_aPrintAreaCol = m_aTxtCol;
}

void SwMarkPreview::DataChanged( const DataChangedEvent& rDCEvt )
{
	Window::DataChanged( rDCEvt );

	if( rDCEvt.GetType() == DATACHANGED_SETTINGS && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
		InitColors();
}

void SwMarkPreview::Paint(const Rectangle &rRect)
{
	// Schatten zeichnen
	Rectangle aShadow(aPage);
	aShadow += Point(3, 3);
	DrawRect( aShadow, m_aShadowCol, m_aTransCol );

	// Seite zeichnen
	DrawRect( aPage, m_aBgCol, m_aLineCol );

	// Separator zeichnen
	Rectangle aPageSeparator(aPage);
	aPageSeparator.SetSize(Size(2, aPageSeparator.GetHeight()));
	aPageSeparator.Move(aPage.GetWidth() / 2 - 1, 0);
	DrawRect( aPageSeparator, m_aLineCol, m_aTransCol );

	PaintPage(aLeftPagePrtArea);
	PaintPage(aRightPagePrtArea);

	Rectangle aLeftMark(Point(aPage.Left() + 2, aLeftPagePrtArea.Top() + 4), Size(aLeftPagePrtArea.Left() - 4, 2));
	Rectangle aRightMark(Point(aRightPagePrtArea.Right() + 2, aRightPagePrtArea.Bottom() - 6), Size(aLeftPagePrtArea.Left() - 4, 2));

	switch (nMarkPos)
	{
		case 1:		// Links
			aRightMark.SetPos(Point(aRightPagePrtArea.Left() - 2 - aRightMark.GetWidth(), aRightMark.Top()));
			break;

		case 2:		// Rechts
			aLeftMark.SetPos(Point(aLeftPagePrtArea.Right() + 2, aLeftMark.Top()));
			break;

		case 3:		// Aussen
			break;

		case 4:		// Innen
			aLeftMark.SetPos(Point(aLeftPagePrtArea.Right() + 2, aLeftMark.Top()));
			aRightMark.SetPos(Point(aRightPagePrtArea.Left() - 2 - aRightMark.GetWidth(), aRightMark.Top()));
			break;

		case 0:		// Keine
		default:
			return;
	}
	DrawRect( aLeftMark, m_aMarkCol, m_aTransCol );
	DrawRect( aRightMark, m_aMarkCol, m_aTransCol );
}

void SwMarkPreview::PaintPage(const Rectangle &rRect)
{
	// PrintArea zeichnen
	DrawRect(rRect, m_aTransCol, m_aPrintAreaCol );

	// Testabsatz zeichnen
	ULONG nLTxtBorder = 4;
	ULONG nRTxtBorder = 4;
	ULONG nTTxtBorder = 4;

	Rectangle aTextLine = rRect;
	aTextLine.SetSize(Size(aTextLine.GetWidth(), 2));
	aTextLine.Left()	+= nLTxtBorder;
	aTextLine.Right()	-= nRTxtBorder;
	aTextLine.Move(0, nTTxtBorder);

	USHORT nStep, nLines;
	const long nTxtLineHeight = aTextLine.GetHeight();

	nStep = aTextLine.GetHeight() + 2;
	nLines = (USHORT)(rRect.GetHeight() / (aTextLine.GetHeight() + 2)) - 1;

	// Text simulieren
	//
	for (USHORT i = 0; i < nLines; ++i)
	{
		if (i == (nLines - 1))
			aTextLine.SetSize(Size(aTextLine.GetWidth() / 2, aTextLine.GetHeight()));

		if (aPage.IsInside(aTextLine))
			DrawRect(aTextLine, m_aTxtCol, m_aTransCol );

		aTextLine.Move(0, nStep);
	}
	aTextLine.Move(0, -nStep);
}

void SwMarkPreview::DrawRect(const Rectangle &rRect, const Color &rFillColor, const Color &rLineColor)
{
	SetFillColor(rFillColor);
	SetLineColor(rLineColor);
	Window::DrawRect(rRect);
}

SwRedlineOptionsTabPage::SwRedlineOptionsTabPage( Window* pParent,
													const SfxItemSet& rSet )
	: SfxTabPage(pParent, SW_RES(TP_REDLINE_OPT), rSet),

    aInsertFL(          this, SW_RES( FL_TE )),
    aInsertFT(          this, SW_RES( FT_CHG_INSERT     )),
    aInsertAttrFT(          this, SW_RES( FT_INS_ATTR     )),
    aInsertLB(          this, SW_RES( LB_INS_ATTR     )),
    aInsertColorFT(     this, SW_RES( FT_INS_COL      )),
    aInsertColorLB(     this, SW_RES( LB_INS_COL      )),
    aInsertedPreviewWN( this, SW_RES( WIN_INS         )),
    aDeletedFT(         this, SW_RES( FT_CHG_DELETE     )),
    aDeletedAttrFT(         this, SW_RES( FT_DEL_ATTR     )),
    aDeletedLB(         this, SW_RES( LB_DEL_ATTR     )),
    aDeletedColorFT(    this, SW_RES( FT_DEL_COL      )),
    aDeletedColorLB(    this, SW_RES( LB_DEL_COL      )),
    aDeletedPreviewWN(  this, SW_RES( WIN_DEL         )),
    aChangedFT(         this, SW_RES( FT_CHG_CHANGE     )),
    aChangedAttrFT(         this, SW_RES( FT_CHG_ATTR     )),
    aChangedLB(         this, SW_RES( LB_CHG_ATTR     )),
    aChangedColorFT(    this, SW_RES( FT_CHG_COL      )),
    aChangedColorLB(    this, SW_RES( LB_CHG_COL      )),
    aChangedPreviewWN(  this, SW_RES( WIN_CHG         )),

	aMarkPosFT			( this, SW_RES( FT_MARKPOS )),
	aMarkPosLB			( this, SW_RES( LB_MARKPOS )),
	aMarkColorFT		( this, SW_RES( FT_LC_COL )),
	aMarkColorLB		( this, SW_RES( LB_LC_COL )),
	aMarkPreviewWN		( this, SW_RES( WIN_MARK )),
    aChangedFL          ( this, SW_RES( FL_LC )),
	sAuthor				( SW_RES( STR_AUTHOR )),
	sNone				( SW_RES( STR_NOTHING ))

{
	FreeResource();

    for(USHORT i = 0; i < aInsertLB.GetEntryCount(); i++)
    {
        String sEntry(aInsertLB.GetEntry(i));
        aDeletedLB.InsertEntry(sEntry);
        aChangedLB.InsertEntry(sEntry);
    };

    Link aLk = LINK(this, SwRedlineOptionsTabPage, AttribHdl);
	aInsertLB.SetSelectHdl( aLk );
	aDeletedLB.SetSelectHdl( aLk );
	aChangedLB.SetSelectHdl( aLk );

	aLk = LINK(this, SwRedlineOptionsTabPage, ColorHdl);
	aInsertColorLB.SetSelectHdl( aLk );
	aDeletedColorLB.SetSelectHdl( aLk );
	aChangedColorLB.SetSelectHdl( aLk );

	aLk = LINK(this, SwRedlineOptionsTabPage, ChangedMaskPrevHdl);
	aMarkPosLB.SetSelectHdl( aLk );
	aMarkColorLB.SetSelectHdl( aLk );
}

SwRedlineOptionsTabPage::~SwRedlineOptionsTabPage()
{
}

SfxTabPage*	SwRedlineOptionsTabPage::Create( Window* pParent, const SfxItemSet& rSet )
{
	return new SwRedlineOptionsTabPage( pParent, rSet );
}

BOOL SwRedlineOptionsTabPage::FillItemSet( SfxItemSet& rSet )
{
	CharAttr *pAttr;
	SwModuleOptions *pOpt = SW_MOD()->GetModuleConfig();

	AuthorCharAttr aInsertAttr;
	AuthorCharAttr aDeletedAttr;
	AuthorCharAttr aChangedAttr;

	AuthorCharAttr aOldInsertAttr(pOpt->GetInsertAuthorAttr());
	AuthorCharAttr aOldDeletedAttr(pOpt->GetDeletedAuthorAttr());
	AuthorCharAttr aOldChangedAttr(pOpt->GetFormatAuthorAttr());

	ULONG nOldMarkColor = pOpt->GetMarkAlignColor().GetColor();
	USHORT nOldMarkMode = pOpt->GetMarkAlignMode();

	USHORT nPos = aInsertLB.GetSelectEntryPos();
	if (nPos != LISTBOX_ENTRY_NOTFOUND)
	{
		pAttr = (CharAttr *)aInsertLB.GetEntryData(nPos);
		aInsertAttr.nItemId = pAttr->nItemId;
		aInsertAttr.nAttr = pAttr->nAttr;

		nPos = aInsertColorLB.GetSelectEntryPos();

		switch (nPos)
		{
			case 0:
				aInsertAttr.nColor = COL_NONE;
				break;
			case 1:
			case LISTBOX_ENTRY_NOTFOUND:
				aInsertAttr.nColor = COL_TRANSPARENT;
				break;
			default:
				aInsertAttr.nColor = aInsertColorLB.GetEntryColor(nPos).GetColor();
				break;
		}

		pOpt->SetInsertAuthorAttr(aInsertAttr);
	}

	nPos = aDeletedLB.GetSelectEntryPos();
	if (nPos != LISTBOX_ENTRY_NOTFOUND)
	{
		pAttr = (CharAttr *)aDeletedLB.GetEntryData(nPos);
		aDeletedAttr.nItemId = pAttr->nItemId;
		aDeletedAttr.nAttr = pAttr->nAttr;

		nPos = aDeletedColorLB.GetSelectEntryPos();

		switch (nPos)
		{
			case 0:
				aDeletedAttr.nColor = COL_NONE;
				break;
			case 1:
			case LISTBOX_ENTRY_NOTFOUND:
				aDeletedAttr.nColor = COL_TRANSPARENT;
				break;
			default:
				aDeletedAttr.nColor = aDeletedColorLB.GetEntryColor(nPos).GetColor();
				break;
		}

		pOpt->SetDeletedAuthorAttr(aDeletedAttr);
	}

	nPos = aChangedLB.GetSelectEntryPos();
	if (nPos != LISTBOX_ENTRY_NOTFOUND)
	{
		pAttr = (CharAttr *)aChangedLB.GetEntryData(nPos);
		aChangedAttr.nItemId = pAttr->nItemId;
		aChangedAttr.nAttr = pAttr->nAttr;

		nPos = aChangedColorLB.GetSelectEntryPos();

		switch (nPos)
		{
			case 0:
				aChangedAttr.nColor = COL_NONE;
				break;
			case 1:
			case LISTBOX_ENTRY_NOTFOUND:
				aChangedAttr.nColor = COL_TRANSPARENT;
				break;
			default:
				aChangedAttr.nColor = aChangedColorLB.GetEntryColor(nPos).GetColor();
				break;
		}

		pOpt->SetFormatAuthorAttr(aChangedAttr);
	}

	nPos = 0;
	switch (aMarkPosLB.GetSelectEntryPos())
	{
		case 0:	nPos = HORI_NONE;		break;
		case 1:	nPos = HORI_LEFT;		break;
		case 2:	nPos = HORI_RIGHT; 		break;
		case 3:	nPos = HORI_OUTSIDE;	break;
		case 4:	nPos = HORI_INSIDE;		break;
	}
	pOpt->SetMarkAlignMode(nPos);

	pOpt->SetMarkAlignColor(aMarkColorLB.GetSelectEntryColor());

	if (!(aInsertAttr == aOldInsertAttr) ||
		!(aDeletedAttr == aOldDeletedAttr) ||
		!(aChangedAttr == aOldChangedAttr) ||
	   nOldMarkColor != pOpt->GetMarkAlignColor().GetColor() ||
	   nOldMarkMode != pOpt->GetMarkAlignMode())
	{
		// Alle Dokumente aktualisieren
		TypeId aType(TYPE(SwDocShell));
		SwDocShell* pDocShell = (SwDocShell*)SfxObjectShell::GetFirst(&aType);

		while( pDocShell )
		{
			pDocShell->GetWrtShell()->UpdateRedlineAttr();
			pDocShell = (SwDocShell*)SfxObjectShell::GetNext(*pDocShell, &aType);
		}
	}

	return FALSE;
}

void SwRedlineOptionsTabPage::Reset( const SfxItemSet& rSet )
{
	const SwModuleOptions *pOpt = SW_MOD()->GetModuleConfig();

	const AuthorCharAttr &rInsertAttr = pOpt->GetInsertAuthorAttr();
	const AuthorCharAttr &rDeletedAttr = pOpt->GetDeletedAuthorAttr();
	const AuthorCharAttr &rChangedAttr = pOpt->GetFormatAuthorAttr();

	// Preview initialisieren
    InitFontStyle(aInsertedPreviewWN);
    InitFontStyle(aDeletedPreviewWN);
    InitFontStyle(aChangedPreviewWN);

	// Farblistboxen initialisieren
	String sColor;
	aInsertColorLB.SetUpdateMode(FALSE);
	aDeletedColorLB.SetUpdateMode(FALSE);
	aChangedColorLB.SetUpdateMode(FALSE);
	aMarkColorLB.SetUpdateMode(FALSE);

	aInsertColorLB.InsertEntry(sNone);
	aDeletedColorLB.InsertEntry(sNone);
	aChangedColorLB.InsertEntry(sNone);

	aInsertColorLB.InsertEntry(sAuthor);
	aDeletedColorLB.InsertEntry(sAuthor);
	aChangedColorLB.InsertEntry(sAuthor);

	XColorTable* pColorTbl = XColorTable::GetStdColorTable();
	USHORT i;
	for( i = 0; i < pColorTbl->Count(); ++i )
	{
		XColorEntry* pEntry = pColorTbl->Get( i );
		Color aColor = pEntry->GetColor();
		String sName = pEntry->GetName();

		aInsertColorLB.InsertEntry( aColor, sName );
		aDeletedColorLB.InsertEntry( aColor, sName );
		aChangedColorLB.InsertEntry( aColor, sName );
		aMarkColorLB.InsertEntry( aColor, sName );
	}
	aInsertColorLB.SetUpdateMode( TRUE );
	aDeletedColorLB.SetUpdateMode( TRUE );
	aChangedColorLB.SetUpdateMode( TRUE );
	aMarkColorLB.SetUpdateMode( TRUE );

	ULONG nColor = rInsertAttr.nColor;

	switch (nColor)
	{
		case COL_TRANSPARENT:
			aInsertColorLB.SelectEntryPos(1);
			break;
		case COL_NONE:
			aInsertColorLB.SelectEntryPos(0);
			break;
		default:
			aInsertColorLB.SelectEntry(Color(nColor));
	}

	nColor = rDeletedAttr.nColor;

	switch (nColor)
	{
		case COL_TRANSPARENT:
			aDeletedColorLB.SelectEntryPos(1);
			break;
		case COL_NONE:
			aDeletedColorLB.SelectEntryPos(0);
			break;
		default:
			aDeletedColorLB.SelectEntry(Color(nColor));
	}

	nColor = rChangedAttr.nColor;

	switch (nColor)
	{
		case COL_TRANSPARENT:
			aChangedColorLB.SelectEntryPos(1);
			break;
		case COL_NONE:
			aChangedColorLB.SelectEntryPos(0);
			break;
		default:
			aChangedColorLB.SelectEntry(Color(nColor));
	}

	aMarkColorLB.SelectEntry(pOpt->GetMarkAlignColor());

	// Attributlistboxen initialisieren
	USHORT nNum = sizeof(aInsertAttr) / sizeof(CharAttr);

	aInsertLB.SelectEntryPos(0);
	aDeletedLB.SelectEntryPos(0);
	aChangedLB.SelectEntryPos(0);
	for (i = 0; i < nNum; i++)
	{
		aInsertLB.SetEntryData(i, &aInsertAttr[i]);
		if (aInsertAttr[i].nItemId == rInsertAttr.nItemId &&
			aInsertAttr[i].nAttr == rInsertAttr.nAttr)
			aInsertLB.SelectEntryPos(i);
	}

	for (i = 0; i < nNum; i++)
	{
        aDeletedLB.SetEntryData(i, &aInsertAttr[i]);
        if (aInsertAttr[i].nItemId == rDeletedAttr.nItemId &&
            aInsertAttr[i].nAttr == rDeletedAttr.nAttr)
			aDeletedLB.SelectEntryPos(i);
	}

	for (i = 0; i < nNum; i++)
	{
        aChangedLB.SetEntryData(i, &aInsertAttr[i]);
        if (aInsertAttr[i].nItemId == rChangedAttr.nItemId &&
            aInsertAttr[i].nAttr == rChangedAttr.nAttr)
			aChangedLB.SelectEntryPos(i);
	}
    //remove strikethrough from insert and delete and underline+double underline from delete
    aInsertLB.RemoveEntry(5);
    aChangedLB.RemoveEntry(5);
    aDeletedLB.RemoveEntry(4);
    aDeletedLB.RemoveEntry(3);


	USHORT nPos = 0;
	switch (pOpt->GetMarkAlignMode())
	{
		case HORI_NONE:		nPos = 0;	break;
		case HORI_LEFT:		nPos = 1;	break;
		case HORI_RIGHT:	nPos = 2; 	break;
		case HORI_OUTSIDE:	nPos = 3;	break;
		case HORI_INSIDE:	nPos = 4;	break;
	}
	aMarkPosLB.SelectEntryPos(nPos);

	// Einstellungen in Preview anzeigen
	AttribHdl(&aInsertLB);
	ColorHdl(&aInsertColorLB);
    AttribHdl(&aDeletedLB);
	ColorHdl(&aInsertColorLB);
    AttribHdl(&aChangedLB);
    ColorHdl(&aChangedColorLB);

	ChangedMaskPrevHdl();
}

IMPL_LINK( SwRedlineOptionsTabPage, AttribHdl, ListBox *, pLB )
{
    SvxFontPrevWindow *pPrev = 0;
	ColorListBox *pColorLB;

	if (pLB == &aInsertLB)
    {
		pColorLB = &aInsertColorLB;
        pPrev = &aInsertedPreviewWN;
    }
	else if (pLB == &aDeletedLB)
    {
		pColorLB = &aDeletedColorLB;
        pPrev = &aDeletedPreviewWN;
    }
    else
    {
		pColorLB = &aChangedColorLB;
        pPrev = &aChangedPreviewWN;
    }

	SvxFont&	rFont = pPrev->GetFont();
	SvxFont&	rCJKFont = pPrev->GetCJKFont();

	rFont.SetWeight(WEIGHT_NORMAL);
	rCJKFont.SetWeight(WEIGHT_NORMAL);
	rFont.SetItalic(ITALIC_NONE);
	rCJKFont.SetItalic(ITALIC_NONE);
	rFont.SetUnderline(UNDERLINE_NONE);
	rCJKFont.SetUnderline(UNDERLINE_NONE);
	rFont.SetStrikeout(STRIKEOUT_NONE);
	rCJKFont.SetStrikeout(STRIKEOUT_NONE);
	rFont.SetCaseMap(SVX_CASEMAP_NOT_MAPPED);
	rCJKFont.SetCaseMap(SVX_CASEMAP_NOT_MAPPED);

	USHORT		nPos = pColorLB->GetSelectEntryPos();

	switch( nPos )
	{
		case 0:
			rFont.SetColor( Color( COL_BLACK ) );
			rCJKFont.SetColor( Color( COL_BLACK ) );
			break;
		case 1:
		case LISTBOX_ENTRY_NOTFOUND:
			rFont.SetColor( Color( COL_RED ) );
			rCJKFont.SetColor( Color( COL_RED ) );
			break;
		default:
			rFont.SetColor( pColorLB->GetEntryColor( nPos ) );
			rCJKFont.SetColor( pColorLB->GetEntryColor( nPos ) );
			break;
	}

	nPos = pLB->GetSelectEntryPos();
	if( nPos == LISTBOX_ENTRY_NOTFOUND )
		nPos = 0;

	CharAttr*	pAttr = ( CharAttr* ) pLB->GetEntryData( nPos );

	switch (pAttr->nItemId)
	{
		case SID_ATTR_CHAR_WEIGHT:
			rFont.SetWeight( ( FontWeight ) pAttr->nAttr );
			rCJKFont.SetWeight( ( FontWeight ) pAttr->nAttr );
			break;

		case SID_ATTR_CHAR_POSTURE:
			rFont.SetItalic( ( FontItalic ) pAttr->nAttr );
			rCJKFont.SetItalic( ( FontItalic ) pAttr->nAttr );
			break;

		case SID_ATTR_CHAR_UNDERLINE:
			rFont.SetUnderline( ( FontUnderline ) pAttr->nAttr );
			rCJKFont.SetUnderline( ( FontUnderline ) pAttr->nAttr );
			break;

		case SID_ATTR_CHAR_STRIKEOUT:
			rFont.SetStrikeout( ( FontStrikeout ) pAttr->nAttr );
			rCJKFont.SetStrikeout( ( FontStrikeout ) pAttr->nAttr );
			break;

		case SID_ATTR_CHAR_CASEMAP:
			rFont.SetCaseMap( ( SvxCaseMap ) pAttr->nAttr );
			rCJKFont.SetCaseMap( ( SvxCaseMap ) pAttr->nAttr );
			break;

		case SID_ATTR_BRUSH:
		{
			nPos = pColorLB->GetSelectEntryPos();
			if( nPos )
				pPrev->SetColor( pColorLB->GetSelectEntryColor() );
			else
				pPrev->SetColor( Color( COL_LIGHTGRAY ) );

			rFont.SetColor( Color( COL_BLACK ) );
			rCJKFont.SetColor( Color( COL_BLACK ) );
		}
		break;
	}

	pPrev->Invalidate();

	return 0;
}

IMPL_LINK( SwRedlineOptionsTabPage, ColorHdl, ColorListBox *, pColorLB )
{
    SvxFontPrevWindow *pPrev = 0;
	ListBox *pLB;

	if (pColorLB == &aInsertColorLB)
    {
		pLB = &aInsertLB;
        pPrev = &aInsertedPreviewWN;
    }
    else if (pColorLB == &aDeletedColorLB)
    {
		pLB = &aDeletedLB;
        pPrev = &aDeletedPreviewWN;
    }
    else
    {
		pLB = &aChangedLB;
        pPrev = &aChangedPreviewWN;
    }

	SvxFont&	rFont = pPrev->GetFont();
	SvxFont&	rCJKFont = pPrev->GetCJKFont();
	USHORT		nPos = pLB->GetSelectEntryPos();
	if( nPos == LISTBOX_ENTRY_NOTFOUND )
		nPos = 0;

	CharAttr*	pAttr = ( CharAttr* ) pLB->GetEntryData( nPos );

	if( pAttr->nItemId == SID_ATTR_BRUSH )
	{
		rFont.SetColor( Color( COL_BLACK ) );
		rCJKFont.SetColor( Color( COL_BLACK ) );
		nPos = pColorLB->GetSelectEntryPos();
		if( nPos && nPos != LISTBOX_ENTRY_NOTFOUND )
			pPrev->SetColor( pColorLB->GetSelectEntryColor() );
		else
			pPrev->SetColor( Color( COL_LIGHTGRAY ) );
	}
	else
	{
		nPos = pColorLB->GetSelectEntryPos();

		switch( nPos )
		{
			case 0:
				rFont.SetColor( Color( COL_BLACK ) );
				rCJKFont.SetColor( Color( COL_BLACK ) );
				break;
			case 1:
			case LISTBOX_ENTRY_NOTFOUND:
				rFont.SetColor( Color( COL_RED ) );
				rCJKFont.SetColor( Color( COL_RED ) );
				break;
			default:
				rFont.SetColor( pColorLB->GetEntryColor( nPos ) );
				rCJKFont.SetColor( pColorLB->GetEntryColor( nPos ) );
				break;
		}
	}

	pPrev->Invalidate();

	return 0;
}

IMPL_LINK( SwRedlineOptionsTabPage, ChangedMaskPrevHdl, ListBox *, pLB )
{
	aMarkPreviewWN.SetMarkPos(aMarkPosLB.GetSelectEntryPos());
	aMarkPreviewWN.SetColor(aMarkColorLB.GetSelectEntryColor().GetColor());

	aMarkPreviewWN.Invalidate();

	return 0;
}

void SwRedlineOptionsTabPage::InitFontStyle(SvxFontPrevWindow& rExampleWin)
{
	const AllSettings&	rAllSettings = Application::GetSettings();
	LanguageType		eLangType = rAllSettings.GetUILanguage();
	Color				aBackCol( rAllSettings.GetStyleSettings().GetWindowColor() );
	SvxFont&			rFont = rExampleWin.GetFont();
	SvxFont&			rCJKFont = rExampleWin.GetCJKFont();
	SvxFont&			rCTLFont = rExampleWin.GetCTLFont();

	Font				aFont( OutputDevice::GetDefaultFont( DEFAULTFONT_SERIF, eLangType,
														DEFAULTFONT_FLAGS_ONLYONE, &rExampleWin ) );
	Font				aCJKFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CJK_TEXT, eLangType,
														DEFAULTFONT_FLAGS_ONLYONE, &rExampleWin ) );
	Font				aCTLFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CTL_TEXT, eLangType,
														DEFAULTFONT_FLAGS_ONLYONE, &rExampleWin ) );
	const Size			aDefSize( 0, 12 );
	aFont.SetSize( aDefSize );
	aCJKFont.SetSize( aDefSize );
	aCTLFont.SetSize( aDefSize );

	aFont.SetFillColor( aBackCol );
	aCJKFont.SetFillColor( aBackCol );
	aCTLFont.SetFillColor( aBackCol );

	aFont.SetWeight( WEIGHT_NORMAL );
	aCJKFont.SetWeight( WEIGHT_NORMAL );
	aCTLFont.SetWeight( WEIGHT_NORMAL );

	rFont = aFont;
	rCJKFont = aCJKFont;
	rCTLFont = aCTLFont;

	const Size			aNewSize( 0, rExampleWin.GetOutputSize().Height() * 2 / 3 );
	rFont.SetSize( aNewSize );
	rCJKFont.SetSize( aNewSize );

	rExampleWin.SetFont( rFont, rCJKFont,rCTLFont );

	rExampleWin.UseResourceText();

	Wallpaper			aWall( aBackCol );
	rExampleWin.SetBackground( aWall );
	rExampleWin.Invalidate();
}


#ifndef PRODUCT
/*******************************************************
 ******************************************************/
/*----------------- OS 11.01.95  -----------------------
 TabPage Testeinstellungen
-------------------------------------------------------*/

void lcl_SetPosSize(Window& rWin, Point aPos, Size aSize)
{
	aPos = rWin.LogicToPixel(aPos, MAP_APPFONT);
	aSize = rWin.OutputDevice::LogicToPixel(aSize, MAP_APPFONT);
	rWin.SetPosSizePixel(aPos, aSize);
}

SwTestTabPage::SwTestTabPage( Window* pParent,
									  const SfxItemSet& rCoreSet) :
	SfxTabPage( pParent, WB_HIDE, rCoreSet),
    aTestFL        ( this, WB_GROUP ),
	aTest1CBox   	( this,	0 ),
	aTest2CBox    	( this,	0 ),
	aTest3CBox    	( this,	0 ),
	aTest4CBox    	( this,	0 ),
	aTest5CBox   	( this, 0 ),
	aTest6CBox   	( this,	0 ),
	aTest7CBox   	( this,	0 ),
	aTest8CBox		( this,	0 ),
	aTest9CBox		( this,	0 ),
	aTest10CBox		( this,	0 ),
	bAttrModified( FALSE )
{
	lcl_SetPosSize(*this, 		Point(0,0), Size(260 , 135));
    lcl_SetPosSize(aTestFL,   Point(6,2), Size(209,8));
	lcl_SetPosSize(aTest1CBox  , 	Point(12 , 14),	Size(74 , 10));
	lcl_SetPosSize(aTest2CBox  , 	Point(12 , 27),	Size(74 , 10));
	lcl_SetPosSize(aTest3CBox  , 	Point(12 , 40),	Size(74 , 10));
	lcl_SetPosSize(aTest4CBox  , 	Point(12 , 53),	Size(74 , 10));
	lcl_SetPosSize(aTest5CBox  , 	Point(12 , 66),	Size(74 , 10));
	lcl_SetPosSize(aTest6CBox  , 	Point(116, 14),	Size(74 , 10));
	lcl_SetPosSize(aTest7CBox  , 	Point(116, 27),	Size(74 , 10));
	lcl_SetPosSize(aTest8CBox  , 	Point(116, 40),	Size(74 , 10));
	lcl_SetPosSize(aTest9CBox  , 	Point(116, 53),	Size(74 , 10));
	lcl_SetPosSize(aTest10CBox	, 	Point(116, 66),	Size(74 , 10));

    aTestFL.SetText( String(ByteString("Einstellungen nur f\xFCr Testzwecke" ), RTL_TEXTENCODING_MS_1252));
	aTest1CBox .SetText( C2S("unused"));
	aTest2CBox .SetText( C2S("dynamic"));
	aTest3CBox .SetText( C2S("No calm"               ));
	aTest4CBox .SetText( C2S("WYSIWYG debug"         ));
	aTest5CBox .SetText( C2S("No idle format"        ));
	aTest6CBox .SetText( C2S("No screen adj"         ));
	aTest7CBox .SetText( C2S("win format"            ));
	aTest8CBox .SetText( C2S("No Scroll"             ));
	aTest9CBox .SetText( C2S("DrawingLayerNotLoading"));
	aTest10CBox.SetText( C2S("AutoFormat by Input"   ));
    aTestFL.Show();
	aTest1CBox .Show();
	aTest2CBox .Show();
	aTest3CBox .Show();
	aTest4CBox .Show();
	aTest5CBox .Show();
	aTest6CBox .Show();
	aTest7CBox .Show();
	aTest8CBox .Show();
	aTest9CBox .Show();
	aTest10CBox.Show();
	Init();

}


//------------------------------------------------------------------------


SfxTabPage*	SwTestTabPage::Create( Window* pParent,
									   const SfxItemSet& rAttrSet )
{
	return ( new SwTestTabPage( pParent, rAttrSet ) );
}
//------------------------------------------------------------------------


BOOL 	SwTestTabPage::FillItemSet( SfxItemSet& rCoreSet )
{

	if ( bAttrModified )
	{
		SwTestItem aTestItem(FN_PARAM_SWTEST);
			aTestItem.bTest1=aTest1CBox.IsChecked();
			aTestItem.bTest2=aTest2CBox.IsChecked();
			aTestItem.bTest3=aTest3CBox.IsChecked();
			aTestItem.bTest4=aTest4CBox.IsChecked();
			aTestItem.bTest5=aTest5CBox.IsChecked();
			aTestItem.bTest6=aTest6CBox.IsChecked();
			aTestItem.bTest7=aTest7CBox.IsChecked();
			aTestItem.bTest8=aTest8CBox.IsChecked();
			aTestItem.bTest9=aTest9CBox.IsChecked();
			aTestItem.bTest10=aTest10CBox.IsChecked();
		rCoreSet.Put(aTestItem);
	}
	return bAttrModified;
}
//------------------------------------------------------------------------


void SwTestTabPage::Reset( const SfxItemSet& )
{
	const SfxItemSet& rSet = GetItemSet();
	const SwTestItem* pTestAttr = 0;

	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_SWTEST , FALSE,
									(const SfxPoolItem**)&pTestAttr ))
	{
		aTest1CBox.Check(pTestAttr->bTest1);
		aTest2CBox.Check(pTestAttr->bTest2);
		aTest3CBox.Check(pTestAttr->bTest3);
		aTest4CBox.Check(pTestAttr->bTest4);
		aTest5CBox.Check(pTestAttr->bTest5);
		aTest6CBox.Check(pTestAttr->bTest6);
		aTest7CBox.Check(pTestAttr->bTest7);
		aTest8CBox.Check(pTestAttr->bTest8);
		aTest9CBox.Check(pTestAttr->bTest9);
		aTest10CBox.Check(pTestAttr->bTest10);
	}
}
//------------------------------------------------------------------------


void SwTestTabPage::Init()
{
	// handler
	Link aLk = LINK( this, SwTestTabPage, AutoClickHdl );
	aTest1CBox.SetClickHdl( aLk );
	aTest2CBox.SetClickHdl( aLk );
	aTest3CBox.SetClickHdl( aLk );
	aTest4CBox.SetClickHdl( aLk );
	aTest5CBox.SetClickHdl( aLk );
	aTest6CBox.SetClickHdl( aLk );
	aTest7CBox.SetClickHdl( aLk );
	aTest8CBox.SetClickHdl( aLk );
	aTest9CBox.SetClickHdl( aLk );
	aTest10CBox.SetClickHdl( aLk );
}
//------------------------------------------------------------------------


IMPL_LINK_INLINE_START( SwTestTabPage, AutoClickHdl, CheckBox *, EMPTYARG )
{
	bAttrModified = TRUE;
	return 0;
}
IMPL_LINK_INLINE_END( SwTestTabPage, AutoClickHdl, CheckBox *, EMPTYARG )
#endif



