/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tstMgr.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:58:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "tstMgr.hxx"

#ifndef _OSL_MODULE_HXX_
#include <osl/module.hxx>
#endif

#ifndef _RTL_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _SAL_TESTSHL_TLOG_HXX_
#include "tlog.hxx"
#endif

#ifndef _SAL_TESTSHL_TUTIL_HXX_
#include "tutil.hxx"
#endif

using namespace rtl;

// <namespace_tstutl>
namespace tstutl
{
    // pointer to function which calls entry
    typedef void* ( tstFunc )( rtl_TestResult* );
    void test_Entry_Impl( ::osl::Module& oMod, TestResult* oRes );
    void createDateTag(rtl_String** date, rtl_String* ver, rtl_String* bld );

    // <private_members>
    struct TestManager::tstMgr_Impl
    {
        ::osl::Module   m_tstmodule;
        TestLog*        m_log;
        sal_Char*       m_scename;
        sal_uInt32      m_cmdflags;
    };
    // </private_members>

    // <method_initialize>
    sal_Bool TestManager::initialize( vector< sal_Char* >& cmdln,
                                                        sal_uInt32 cmdflags )
    {
        ::rtl::OUString tstMod( cnvrtPth( ::rtl::OString( cmdln[0] ) ) );
        pImpl = new tstMgr_Impl;
        pImpl->m_log = 0;
        pImpl->m_scename  = cmdln[1];
        pImpl->m_cmdflags = cmdflags;

        return ( pImpl->m_tstmodule.load( tstMod ) );
    } // <method_initialize>

    // <method_test_Entries>
    sal_Bool TestManager::test_Entries( vector< sal_Char* > entries )
    {
        sal_Bool bOK = sal_True;                /* boolean for result */
        rtl_String* logName = 0;

        /* log required */
		if ( (pImpl->m_cmdflags & rtl_tres_Flag_LOG ) == rtl_tres_Flag_LOG )
		{
            /* create lognam from scenario filename */
            rtl_String* left = 0;
            rtl_String* right = 0;
            rtl_string_newFromStr_WithLength(&left, pImpl->m_scename,
                                        rindexof(pImpl->m_scename, '.') );
            rtl_string_newFromStr( &right, ".out" );
            rtl_string_newConcat( &logName, left, right );
            rtl_string_release( left );
            rtl_string_release( right );

		}
        /* new log object */
        if ( logName )
        {
            pImpl->m_log = new TestLog( rtl_string_getStr( logName ) );
        }
        else
        {
            pImpl->m_log = new TestLog( 0 );
        }

        if ( ! entries.empty() )
        {

            rtl_String* date = 0;
            vector< sal_Char* >::iterator iter = entries.begin();
            createDateTag( &date, 0, 0 );
            /* open logfile and create datetag first */
            pImpl->m_log->open();
            pImpl->m_log->write( rtl_string_getStr( date ) );
            pImpl->m_log->write( "\n" );
            rtl_string_release( date );

            /* test all entries in vector */
            while ( iter != entries.end() )
            {
                /* if not commented, test it */
                if ( *iter[0] != '#' )
                    bOK &= test_Entry( *iter );
                iter++;
            }
            /* close logfile */
            pImpl->m_log->close();
        }
		if( pImpl->m_log )
			delete pImpl->m_log;
        return ( bOK );
    } // </method_test_Entries>

    // <method_test_Entry>
    sal_Bool TestManager::test_Entry( sal_Char* entry )
    {
        ::rtl::TestResult oRes( entry, pImpl->m_cmdflags );
        test_Entry_Impl( pImpl->m_tstmodule, &oRes );
        pImpl->m_log->writeRes( oRes );
        return ( oRes.getData()->pFuncs->isok( oRes.getData() ) );
    } // </method_test_Entry>

    // <method_test_EntriesFromFile>
    sal_Bool TestManager::test_EntriesFromFile()
    {
        sal_Bool bOK = sal_False;
        vector< rtl_String* > entries_str;
        vector< sal_Char* > entries;

        if ( ::rtl::OString( pImpl->m_scename ).indexOf( "." ) != -1 )
        {

            if ( ! getEntriesFromFile( pImpl->m_scename, entries_str ) )
            {
                fprintf(stderr, "no entries found for file: %s",
                                                        pImpl->m_scename );
                return( bOK );
            }
            vector< rtl_String* >::iterator iter = entries_str.begin();
            while( iter != entries_str.end() )
            {
                entries.push_back( rtl_string_getStr( *iter ) );
                iter++;
            }
        }
        else
        {
            entries.push_back( pImpl->m_scename );
        }

        bOK = test_Entries( entries );

        vector< rtl_String* >::iterator iter = entries_str.begin();
        while( iter != entries_str.end() )
        {
            rtl_string_release( *iter );
            iter++;
        }

        entries_str.clear();
		entries.clear();

        return ( bOK );

    } // </method_test_EntriesFromFile>

    // <method_cleanup>
    void TestManager::cleanup()
    {
        if ( pImpl )
            delete pImpl;
    } // </method_cleanup>


    // <function_test_Entry_Impl>
    void test_Entry_Impl( ::osl::Module& oMod, ::rtl::TestResult* oRes )
    {
        tstFunc* pFunc;                             // entry pointer
        ::rtl::OString entryName( "test_" );        // entryname prefix

        // prefix entryname
		rtl_TestResult* data = oRes->getData();
        data->pExternalData = oRes;
        rtl_TestResult_vtable* funcs = data->pFuncs;
        rtl_funcstate fstate = funcs->funcstate( data );
        entryName += funcs->name( fstate );

        // get entry pointer
        pFunc = (tstFunc*) oMod.getSymbol(
                    ::rtl::OUString::createFromAscii( entryName.getStr() ) );

        if ( pFunc )
        {
            // call entry
            pFunc( data );
            if ( ! funcs->ispassed( data ) )
                oRes->end();

        }
        else
            oRes->state( sal_False, "did not find symbol" );

        // return
        return;
    } // </function_test_Entry_Impl>

	// <function_createDateTag>
    void createDateTag( rtl_String** date, rtl_String* vers, rtl_String* bld )
    {
        sal_uInt32 nLen = 0;
        sal_Char buf[16];
        sal_Char datebuf[18];

        TimeValue* tmv = (TimeValue*)malloc( sizeof( TimeValue ) );
        oslDateTime* dt = (oslDateTime*)malloc( sizeof( oslDateTime ) );
        osl_getSystemTime( tmv );
        osl_getDateTimeFromTimeValue( tmv, dt );

        cpy( datebuf, "[" );
        rtl_str_valueOfInt32( buf, dt->Year, 10 );
        cat( datebuf, buf );
        cat( datebuf, "." );
		if( dt->Month < 10 )
            cat( datebuf, "0" );
        rtl_str_valueOfInt32( buf, dt->Month, 10 );
        cat( datebuf, buf );
        cat( datebuf, "." );
		if( dt->Day < 10 )
            cat( datebuf, "0" );
        rtl_str_valueOfInt32( buf, dt->Day, 10 );
        cat( datebuf, buf );
        cat( datebuf, "//]\00" );
        free(dt);
        free(tmv);
        rtl_string_newFromStr( date, datebuf );
    } // <function_createDateTag>

} // </namespace_tstutl>
