/*
 * MacroReader.java
 *
 * Created on 21. Juli 2003, 15:08
 */
package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.XLibraryContainer;
import com.sun.star.script.XStarBasicAccess;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class MacroReader {
	/**
	 * Get macro names for a Library.
	 *
	 * @param xmsf
	 * @param libName
	 *
	 * @return macro names
	 */
	public static String[] getMacroNames(XMultiServiceFactory xmsf, String libName) {
		String[] names = null;

		XNameAccess as = macroHelper(xmsf, libName);

		if (as != null) {
			names = as.getElementNames();
		}

		return names;
	}

	/**
	 * Get document macro names for a Library.
	 *
	 * @param xm
	 * @param libName
	 *
	 * @return macro names
	 */
	public static String[] getDocumentMacroNames(XModel xm, String libName) {
		String[] names = null;

		XNameAccess as = macroHelper(xm, libName);

		if (as != null) {
			names = as.getElementNames();
		}

		return names;
	}

	/**
	 * Get macro names size.
	 *
	 * @param xmsf
	 * @param libName
	 *
	 * @return macro names size
	 */
	public static int getMacroNamesSize(XMultiServiceFactory xmsf, String libName) {
		int size = -1;

		XNameAccess as = macroHelper(xmsf, libName);

		if (as != null) {
			size = as.getElementNames().length;
		}

		return size;
	}

	/**
	 * Get document macro names size.
	 *
	 * @param xm
	 * @param libName
	 *
	 * @return macro names size
	 */
	public static int getDocumentMacroNamesSize(XModel xm, String libName) {
		int size = -1;

		XNameAccess as = macroHelper(xm, libName);

		if (as != null) {
			size = as.getElementNames().length;
		}

		return size;
	}

	/**
	 * Read a macro content.
	 *
	 * @param xmsf
	 * @param libName
	 * @param name
	 *
	 * @return result
	 */
	public static String readMacro(XMultiServiceFactory xmsf, String libName, String name) {
		String content = null;

		try {
			XNameAccess as = macroHelper(xmsf, libName);

			if ((as != null) && as.hasByName(name)) {
				content = (String) as.getByName(name);
			}
		} catch (Exception ex) {
		}

		return content;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param xmsf DOCUMENT ME!
	 * @param libName DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static XNameAccess macroHelper(XMultiServiceFactory xmsf, String libName) {
		XNameAccess as = null;

		try {
			XMultiServiceFactory msf = xmsf;
			Object obj = msf.createInstance("com.sun.star.script.ApplicationScriptLibraryContainer");
			XLibraryContainer xl = (XLibraryContainer) UnoRuntime.queryInterface(XLibraryContainer.class, obj);

			if (!xl.isLibraryLoaded(libName)) {
				xl.loadLibrary(libName);
			}

			as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);

			if ((as != null) && as.hasByName(libName)) {
				obj = as.getByName(libName);
				as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);
			} else {
				as = null;
			}
		} catch (Exception ex) {
		}

		return as;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param xm DOCUMENT ME!
	 * @param libName DOCUMENT ME!
	 * @param name DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static String readDocumentMacro(XModel xm, String libName, String name) {
		String content = null;

		try {
			XNameAccess as = macroHelper(xm, libName);

			if ((as != null) && as.hasByName(name)) {
				content = (String) as.getByName(name);
			}
		} catch (Exception ex) {
		}

		return content;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param xm DOCUMENT ME!
	 * @param libName DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static XNameAccess macroHelper(XModel xm, String libName) {
		XNameAccess as = null;

		try {
			XPropertySet xsba = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xm);

			Object obj = xsba.getPropertyValue("BasicLibraries");
			XLibraryContainer xl = (XLibraryContainer) UnoRuntime.queryInterface(XLibraryContainer.class, obj);

			if (!xl.isLibraryLoaded(libName)) {
				xl.loadLibrary(libName);
			}

			as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);

			if ((as != null) && as.hasByName(libName)) {
				obj = as.getByName(libName);
				as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);
			} else {
				as = null;
			}
		} catch (Exception ex) {
		}

		return as;
	}
}
