/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: baseencoding.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:24:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "xmlsecurity/baseencoding.hxx"

#include <xmlsec/xmlsec.h>
#include <xmlsec/base64.h>
#include <com/sun/star/uno/Sequence.hxx>

//CP : added by CP
#include <rtl/locale.h>
#include <osl/nlsupport.h> 

#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif

//CP : end


using namespace ::com::sun::star::uno ;
using ::rtl::OUString ;

//We only implment the base64 encoding at present.
::rtl::OUString SAL_CALL baseEncode( const ::com::sun::star::uno::Sequence< sal_Int8 >& rawdata, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;

		chData = xmlSecBase64Encode( ( const unsigned char* )&rawdata[0], rawdata.getLength(), 0 ) ;
		if( chData != NULL ) {
			OUString ouStr = OUString::createFromAscii( ( const sal_Char* )chData );
			xmlFree( chData ) ;

			return ouStr ;
		}
	} else {
		return OUString() ;
	}

	return OUString() ;
}

//We only implment the base64 encoding at present.
::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL baseDecode( const ::rtl::OUString& oustr, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;
		xmlSecSize chSize ;

		// add By CP
		sal_uInt16 encoding;
		rtl_Locale* pLocale = NULL;
		osl_getProcessLocale(&pLocale);
		encoding = osl_getTextEncodingFromLocale(pLocale);
		// CP end

		rtl::OString ostr = rtl::OUStringToOString( oustr , encoding ) ;
		//rtl::OString ostr = rtl::OUStringToOString( oustr , RTL_TEXTENCODING_ASCII_US ) ;

		chData = xmlStrndup( ( const xmlChar* )ostr.getStr(), ( int )ostr.getLength() ) ;

		chSize = xmlSecBase64Decode( chData, ( xmlSecByte* )chData, xmlStrlen( chData ) ) ;

		Sequence< sal_Int8 > rawData( chSize ) ;
		for( unsigned int i = 0 ; i < chSize ; i ++ )
			rawData[i] = *( chData + i ) ;

		xmlFree( chData ) ;

		return rawData ;
	}

	return ::com::sun::star::uno::Sequence< sal_Int8 >() ;
}

