/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsc.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:38:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _IMAPDLG_HXX
// auto strip #include <bf_svx/imapdlg.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOOLE2_HXX //autogen
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLG_NAME_HXX //autogen
// auto strip #include <bf_svx/dlgname.hxx>
// auto strip #endif
//#ifndef _BINDING_HXX //autogen
//#include <bf_sfx2/binding.hxx>
//#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SVDOOLE2_HXX //autogen
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTYLE_HXX //autogen
// auto strip #include <svtools/style.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
#include <bf_svx/grafctrl.hxx>

// auto strip #ifndef _SD_STLSHEET_HXX
// auto strip #include "stlsheet.hxx"
// auto strip #endif

#include "app.hrc"
#include "strings.hrc"
#include "helpids.h"
// auto strip #include "misc.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "imapinfo.hxx"
// auto strip #include "futempl.hxx"
// auto strip #include "fusel.hxx"
// auto strip #include "sdresid.hxx"
#include "drviewsh.hxx"
// auto strip #include "drawdoc.hxx"
#include "docshell.hxx"
#include "drawview.hxx"
// auto strip #include "brkdlg.hxx"
namespace binfilter {

#define	MIN_ACTIONS_FOR_DIALOG	5000	// bei mehr als 1600 Metaobjekten
										// wird beim Aufbrechen ein Dialog
										// angezeigt.
/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp03(SfxRequest& rReq)
/*N*/ {
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected( TRUE, TRUE, TRUE ) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->GroupMarked();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_UNGROUP:  // BASIC
/*?*/ 		{
/*?*/ 			pDrView->UnGroupMarked();
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_NAME_GROUP:
/*?*/ 		{
/*?*/ 			// Jetzt nur noch fuer ein Objekt moeglich (28.10.96)
/*?*/ 			const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*?*/ 			SdrObject* pObj = NULL;
/*?*/ 			ULONG nMarkCount = rMarkList.GetMarkCount();
/*?*/ 
/*?*/ 			if( nMarkCount == 1 )
/*?*/ 			{
/*?*/ 			    DBG_BF_ASSERT(0, "STRIP"); //STRIP001 String aName;
//STRIP001 /*?*/                 String aTitle( SdResId( STR_TITLE_NAMEGROUP ) );
//STRIP001 /*?*/                 String aDesc( SdResId( STR_DESC_NAMEGROUP ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 /*?*/ 				
//STRIP001 /*?*/ //              if( pObj->ISA( SdrObjGroup ) || pObj->ISA( SdrGrafObj ) || pObj->ISA( SdrOle2Obj ) )
//STRIP001 /*?*/ 					aName = pObj->GetName();
//STRIP001 /*?*/ 				
//STRIP001 /*?*/                 SvxNameDialog* pDlg = new SvxNameDialog( NULL, aName, aDesc );
//STRIP001 /*?*/ 				pDlg->SetEditHelpId( HID_SD_NAMEDIALOG_OBJECT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 pDlg->SetText( aTitle );
//STRIP001 /*?*/                 pDlg->SetCheckNameHdl( LINK( this, SdDrawViewShell, NameObjectHdl ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( pDlg->Execute() == RET_OK )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pDlg->GetName( aName );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ //					if( pObj->ISA( SdrObjGroup ) || pObj->ISA( SdrGrafObj ) || pObj->ISA( SdrOle2Obj ) )
//STRIP001 /*?*/ 						pObj->SetName( aName );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				
//STRIP001 /*?*/                 delete pDlg;
/*?*/ 			}
/*?*/ 
/*?*/ 			SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*?*/ 			rBindings.Invalidate( SID_NAVIGATOR_STATE, TRUE, FALSE );
/*?*/ 			rBindings.Invalidate( SID_CONTEXT );
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ENTER_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->EnterMarkedGroup();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LEAVE_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->LeaveOneGroup();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LEAVE_ALL_GROUPS:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->LeaveAllGroup();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ //		{
/*?*/ //			// Versuchen, die betretene Gruppe zu bekommen
/*?*/ //			SdrObject* pGroup = NULL;
/*?*/ //			SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*?*/ //			if(pPV)
/*?*/ //				pGroup = pPV->GetAktGroup();
/*?*/ //
/*?*/ //			if(nSId == SID_LEAVE_ALL_GROUPS)
/*?*/ //			{
/*?*/ //				// Alle Gruppen verlassen
/*?*/ //				pDrView->LeaveAllGroup();
/*?*/ //
/*?*/ //				// Objekt bis zur obersten Gruppe zurueckverfolgen
/*?*/ //				while(pGroup && pGroup->GetObjList() && pGroup->GetObjList()->GetOwnerObj())
/*?*/ //					pGroup = pGroup->GetObjList()->GetOwnerObj();
/*?*/ //			}
/*?*/ //			else
/*?*/ //			{
/*?*/ //				// Eine Gruppe verlassen
/*?*/ //				pDrView->LeaveOneGroup();
/*?*/ //			}
/*?*/ //
/*?*/ //			pDrView->UnmarkAll();
/*?*/ //			Cancel();
/*?*/ //			rReq.Done ();
/*?*/ //
/*?*/ //			// Falls die Gruppe geholt werden konnte, selektiere diese
/*?*/ //			if(pGroup)
/*?*/ //			{
/*?*/ //				for (USHORT nv=0; nv<pDrView->GetPageViewCount(); nv++)
/*?*/ //				{
/*?*/ //					SdrPageView* pPV = pDrView->GetPageViewPvNum(nv);
/*?*/ //					pDrView->MarkObj(pGroup, pPV);
/*?*/ //				}
/*?*/ //			}
/*?*/ //		}
/*?*/ //		break;
/*?*/ 
/*?*/ 		case SID_COMBINE:  // BASIC
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->CombineMarkedObjects(FALSE);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DISTRIBUTE_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->DistributeMarkedObjects();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_MERGE:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->MergeMarkedObjects(SDR_MERGE_MERGE);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_SUBSTRACT:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->MergeMarkedObjects(SDR_MERGE_SUBSTRACT);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_INTERSECT:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->MergeMarkedObjects(SDR_MERGE_INTERSECT);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DISMANTLE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsDismantlePossible(FALSE) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->DismantleMarkedObjects(FALSE);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->CombineMarkedObjects(TRUE);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BREAK:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/             if ( pDrView->IsBreak3DObjPossible() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/                 pDrView->Break3DObj();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/             else if ( pDrView->IsDismantlePossible(TRUE) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->DismantleMarkedObjects(TRUE);
//STRIP001 /*?*/             }
//STRIP001 /*?*/             else if ( pDrView->IsImportMtfPossible() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 				ULONG nAnz=rMarkList.GetMarkCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Summe der Metaobjekte aller sel. Metafiles erm.
//STRIP001 /*?*/ 				ULONG nCount = 0;
//STRIP001 /*?*/ 				for(ULONG nm=0; nm<nAnz; nm++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrMark*     pM=rMarkList.GetMark(nm);
//STRIP001 /*?*/ 				    SdrObject*   pObj=pM->GetObj();
//STRIP001 /*?*/ 				    SdrGrafObj*  pGraf=PTR_CAST(SdrGrafObj,pObj);
//STRIP001 /*?*/ 					SdrOle2Obj*  pOle2=PTR_CAST(SdrOle2Obj,pObj);
//STRIP001 /*?*/ 			        if (pGraf!=NULL && pGraf->HasGDIMetaFile())
//STRIP001 /*?*/ 						nCount += pGraf->GetGraphic().GetGDIMetaFile().GetActionCount();
//STRIP001 /*?*/ 					if(pOle2!=NULL && pOle2->HasGDIMetaFile())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						const GDIMetaFile* pMtf=pOle2->GetGDIMetaFile();
//STRIP001 /*?*/ 						nCount += pMtf->GetActionCount();
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// anhand der erm. Summe entscheiden ob mit
//STRIP001 /*?*/ 				// oder ohne Dialog aufgebrochen wird.
//STRIP001 /*?*/ 				if(nCount < MIN_ACTIONS_FOR_DIALOG)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// ohne Dialog aufbrechen
//STRIP001 /*?*/ 					pDrView->DoImportMarkedMtf();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// mit Dialog aufbrechen
//STRIP001 /*?*/ 					SdBreakDlg aDlg( pWindow, pDrView, GetDocSh(), nCount, nAnz );
//STRIP001 /*?*/ 					aDlg.Execute();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_3D:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (pDrView->IsConvertTo3DObjPossible())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if (pDrView->IsTextEdit())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pDrView->EndTextEdit();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 					pDrView->ConvertMarkedObjTo3D(TRUE);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FRAME_TO_TOP:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->PutMarkedToTop();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MOREFRONT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MovMarkedToTop();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MOREBACK:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MovMarkedToBtm();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FRAME_TO_BOTTOM:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->PutMarkedToBtm();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HORIZONTAL:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MirrorAllMarkedHorizontal();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_VERTICAL:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MirrorAllMarkedVertical();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_LEFT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_LEFT, SDRVALIGN_NONE);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_CENTER:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_CENTER, SDRVALIGN_NONE);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_RIGHT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_RIGHT, SDRVALIGN_NONE);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_UP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_TOP);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_MIDDLE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_CENTER);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_DOWN:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_BOTTOM);
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SELECTALL:  // BASIC
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (pFuOld && pFuOld->ISA(FuSelection) &&
//STRIP001 /*?*/                 !pView->IsFrameDragSingles() && pView->HasMarkablePoints())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( !pDrView->IsAction() )
//STRIP001 /*?*/ 					pDrView->MarkAllPoints();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->SelectAll();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_STYLE_NEW:	// BASIC ???
/*?*/ 		case SID_STYLE_APPLY:
/*?*/ 		case SID_STYLE_EDIT:
/*?*/ 		case SID_STYLE_DELETE:
/*?*/ 		case SID_STYLE_FAMILY:
/*?*/ 		case SID_STYLE_WATERCAN:
/*?*/ 		case SID_STYLE_UPDATE_BY_EXAMPLE:
/*?*/ 		case SID_STYLE_NEW_BY_EXAMPLE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( rReq.GetSlot() == SID_STYLE_EDIT && !rReq.GetArgs() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxStyleSheet* pStyleSheet = pDrView->GetStyleSheet();
//STRIP001 /*?*/ 				if( pStyleSheet && pStyleSheet->GetFamily() == SD_LT_FAMILY)
//STRIP001 /*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pStyleSheet = ((SdStyleSheet*)pStyleSheet)->GetPseudoStyleSheet();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( (pStyleSheet == NULL) && pView->IsTextEdit() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pView->EndTextEdit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pStyleSheet = pDrView->GetStyleSheet();
//STRIP001 /*?*/ 					if(pStyleSheet && pStyleSheet->GetFamily() == SD_LT_FAMILY)
//STRIP001 /*?*/ 						{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pStyleSheet = ((SdStyleSheet*)pStyleSheet)->GetPseudoStyleSheet();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( pStyleSheet == NULL )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					rReq.Ignore();
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxAllItemSet aSet(pDoc->GetPool());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxStringItem aStyleNameItem( SID_STYLE_EDIT, pStyleSheet->GetName() );
//STRIP001 /*?*/ 				aSet.Put(aStyleNameItem);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxUInt16Item aStyleFamilyItem( SID_STYLE_FAMILY, pStyleSheet->GetFamily() );
//STRIP001 /*?*/ 				aSet.Put(aStyleFamilyItem);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				rReq.SetArgs(aSet);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( rReq.GetArgs() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pFuActual = new FuTemplate( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 				if( rReq.GetSlot() == SID_STYLE_APPLY )
//STRIP001 /*?*/ 					GetViewFrame()->GetBindings().Invalidate( SID_STYLE_APPLY );
//STRIP001 /*?*/ 				Cancel();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if( rReq.GetSlot() == SID_STYLE_APPLY )
//STRIP001 /*?*/ 				GetViewFrame()->GetDispatcher()->Execute( SID_STYLE_DESIGNER, SFX_CALLMODE_ASYNCHRON );
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_IMAP:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxIMapDlg* pDlg;
//STRIP001 /*?*/ 			USHORT		nId = SvxIMapDlgChildWindow::GetChildWindowId();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			GetViewFrame()->ToggleChildWindow( nId );
//STRIP001 /*?*/ 			GetViewFrame()->GetBindings().Invalidate( SID_IMAP );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( GetViewFrame()->HasChildWindow( nId ) && ( ( pDlg = SVXIMAPDLG() ) != NULL ) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SdrMarkList&	rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( rMarkList.GetMarkCount() == 1 )
//STRIP001 /*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 UpdateIMapDlg( rMarkList.GetMark( 0 )->GetObj() );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_GRID_FRONT:
/*?*/ 		{
/*?*/ 			pDrView->SetGridFront( !pDrView->IsGridFront() );
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HELPLINES_FRONT:
/*?*/ 		{
/*?*/ 			pDrView->SetHlplFront( !pDrView->IsHlplFront() );
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			FuTemp04(rReq);
/*N*/ 		break;
/*N*/ 	};
/*N*/ };

/*************************************************************************
|*
|* Liefert die globale/Haupt-ID zurueck, also die ID, ueber die die
|* Toolbox ausgeloest wird
|*
\************************************************************************/

/*N*/ USHORT SdDrawViewShell::GetIdBySubId( USHORT nSId )
/*N*/ {
/*N*/ 	USHORT nMappedSId = 0;
/*N*/ 	switch( nSId )
/*N*/ 	{
/*N*/ 		case SID_OBJECT_ROTATE:
/*N*/ 		case SID_OBJECT_MIRROR:
/*N*/ 		case SID_OBJECT_TRANSPARENCE:
/*N*/ 		case SID_OBJECT_GRADIENT:
/*N*/ 		case SID_OBJECT_SHEAR:
/*N*/ 		case SID_OBJECT_CROOK_ROTATE:
/*N*/ 		case SID_OBJECT_CROOK_SLANT:
/*N*/ 		case SID_OBJECT_CROOK_STRETCH:
/*N*/         case SID_CONVERT_TO_3D_LATHE:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_OBJECT_CHOOSE_MODE;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_OBJECT_ALIGN_LEFT:
/*N*/ 		case SID_OBJECT_ALIGN_CENTER:
/*N*/ 		case SID_OBJECT_ALIGN_RIGHT:
/*N*/ 		case SID_OBJECT_ALIGN_UP:
/*N*/ 		case SID_OBJECT_ALIGN_MIDDLE:
/*N*/ 		case SID_OBJECT_ALIGN_DOWN:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_OBJECT_ALIGN;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_FRAME_TO_TOP:
/*N*/ 		case SID_MOREFRONT:
/*N*/ 		case SID_MOREBACK:
/*N*/ 		case SID_FRAME_TO_BOTTOM:
/*N*/ 		case SID_BEFORE_OBJ:
/*N*/ 		case SID_BEHIND_OBJ:
/*N*/ 		case SID_REVERSE_ORDER:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_POSITION;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_ZOOM_OUT:
/*N*/ 		case SID_ZOOM_IN:
/*N*/ 		case SID_SIZE_REAL:
/*N*/ 		case SID_ZOOM_PANNING:
/*N*/ 		case SID_SIZE_PAGE:
/*N*/ 		case SID_SIZE_PAGE_WIDTH:
/*N*/ 		case SID_SIZE_ALL:
/*N*/ 		case SID_SIZE_OPTIMAL:
/*N*/ 		case SID_ZOOM_NEXT:
/*N*/ 		case SID_ZOOM_PREV:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_ZOOM_TOOLBOX;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_ATTR_CHAR:
/*N*/ 		case SID_TEXT_FITTOSIZE:
/*N*/ 		case SID_DRAW_CAPTION:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_TEXT;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_RECT:
/*N*/ 		case SID_DRAW_SQUARE:
/*N*/ 		case SID_DRAW_RECT_ROUND:
/*N*/ 		case SID_DRAW_SQUARE_ROUND:
/*N*/ 		case SID_DRAW_RECT_NOFILL:
/*N*/ 		case SID_DRAW_SQUARE_NOFILL:
/*N*/ 		case SID_DRAW_RECT_ROUND_NOFILL:
/*N*/ 		case SID_DRAW_SQUARE_ROUND_NOFILL:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_RECTANGLES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_ELLIPSE:
/*N*/ 		case SID_DRAW_CIRCLE:
/*N*/ 		case SID_DRAW_PIE:
/*N*/ 		case SID_DRAW_CIRCLEPIE:
/*N*/ 		case SID_DRAW_ELLIPSECUT:
/*N*/ 		case SID_DRAW_CIRCLECUT:
/*N*/ 		case SID_DRAW_ARC:
/*N*/ 		case SID_DRAW_CIRCLEARC:
/*N*/ 		case SID_DRAW_ELLIPSE_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLE_NOFILL:
/*N*/ 		case SID_DRAW_PIE_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLEPIE_NOFILL:
/*N*/ 		case SID_DRAW_ELLIPSECUT_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLECUT_NOFILL:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_ELLIPSES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/         case SID_DRAW_BEZIER_NOFILL:
/*N*/ 		case SID_DRAW_POLYGON_NOFILL:
/*N*/ 		case SID_DRAW_XPOLYGON_NOFILL:
/*N*/         case SID_DRAW_FREELINE_NOFILL:
/*N*/         case SID_DRAW_BEZIER_FILL:
/*N*/ 		case SID_DRAW_POLYGON:
/*N*/ 		case SID_DRAW_XPOLYGON:
/*N*/         case SID_DRAW_FREELINE:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_LINES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_LINE:
/*N*/ 		case SID_DRAW_XLINE:
/*N*/ 		case SID_DRAW_MEASURELINE:
/*N*/ 		case SID_LINE_ARROW_START:
/*N*/ 		case SID_LINE_ARROW_END:
/*N*/ 		case SID_LINE_ARROWS:
/*N*/ 		case SID_LINE_ARROW_CIRCLE:
/*N*/ 		case SID_LINE_CIRCLE_ARROW:
/*N*/ 		case SID_LINE_ARROW_SQUARE:
/*N*/ 		case SID_LINE_SQUARE_ARROW:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_ARROWS;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_3D_CUBE:
/*N*/ 		case SID_3D_TORUS:
/*N*/ 		case SID_3D_SPHERE:
/*N*/ 		case SID_3D_SHELL:
/*N*/ 		case SID_3D_HALF_SPHERE:
/*N*/ 		case SID_3D_CYLINDER:
/*N*/ 		case SID_3D_CONE:
/*N*/ 		case SID_3D_PYRAMID:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_3D_OBJECTS;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_INSERT_DIAGRAM:
/*N*/ #ifdef STARIMAGE_AVAILABLE
/*N*/ 		case SID_INSERT_IMAGE:
/*N*/ #endif
/*N*/ 		case SID_ATTR_TABLE:
/*N*/ 		case SID_INSERTFILE:
/*N*/ 		case SID_INSERT_GRAPHIC:
/*N*/ 		case SID_INSERTPAGE:
/*N*/ 	    case SID_INSERT_MATH:
/*N*/ 	    case SID_INSERT_FLOATINGFRAME:
/*N*/ 	    case SID_INSERT_OBJECT:
/*N*/         case SID_INSERT_PLUGIN:
/*N*/ 		case SID_INSERT_SOUND:
/*N*/ 		case SID_INSERT_VIDEO:
/*N*/         case SID_INSERT_APPLET:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_INSERT;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/         case SID_TOOL_CONNECTOR:
/*N*/         case SID_CONNECTOR_ARROW_START:
/*N*/         case SID_CONNECTOR_ARROW_END:
/*N*/         case SID_CONNECTOR_ARROWS:
/*N*/         case SID_CONNECTOR_CIRCLE_START:
/*N*/         case SID_CONNECTOR_CIRCLE_END:
/*N*/         case SID_CONNECTOR_CIRCLES:
/*N*/         case SID_CONNECTOR_LINE:
/*N*/         case SID_CONNECTOR_LINE_ARROW_START:
/*N*/         case SID_CONNECTOR_LINE_ARROW_END:
/*N*/         case SID_CONNECTOR_LINE_ARROWS:
/*N*/         case SID_CONNECTOR_LINE_CIRCLE_START:
/*N*/         case SID_CONNECTOR_LINE_CIRCLE_END:
/*N*/         case SID_CONNECTOR_LINE_CIRCLES:
/*N*/         case SID_CONNECTOR_CURVE:
/*N*/         case SID_CONNECTOR_CURVE_ARROW_START:
/*N*/         case SID_CONNECTOR_CURVE_ARROW_END:
/*N*/         case SID_CONNECTOR_CURVE_ARROWS:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLE_START:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLE_END:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLES:
/*N*/         case SID_CONNECTOR_LINES:
/*N*/         case SID_CONNECTOR_LINES_ARROW_START:
/*N*/         case SID_CONNECTOR_LINES_ARROW_END:
/*N*/         case SID_CONNECTOR_LINES_ARROWS:
/*N*/         case SID_CONNECTOR_LINES_CIRCLE_START:
/*N*/         case SID_CONNECTOR_LINES_CIRCLE_END:
/*N*/         case SID_CONNECTOR_LINES_CIRCLES:
/*N*/         {
/*N*/             nMappedSId = SID_DRAWTBX_CONNECTORS;
/*N*/         }
/*N*/ 	}
/*N*/ 	return( nMappedSId );
/*N*/ }

/*************************************************************************
|*
|* Fuellt das SlotArray, um das aktuelle Mapping des ToolboxSlots zu
|* bekommen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::MapSlot( USHORT nSId )
/*N*/ {
/*N*/ 	USHORT nMappedSId = GetIdBySubId( nSId );
/*N*/ 
/*N*/ 	if( nMappedSId > 0 )
/*N*/ 	{
/*N*/ 		USHORT nID = GetArrayId( nMappedSId ) + 1;
/*N*/ 		pSlotArray[ nID ] = nSId;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Ermoeglicht ueber das SlotArray ein ImageMapping
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateToolboxImages( SfxItemSet &rSet, BOOL bPermanent )
/*N*/ {
/*N*/ 	if( !bPermanent )
/*N*/ 	{
/*N*/ 		USHORT nId = GetArrayId( SID_ZOOM_TOOLBOX ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_ZOOM_TOOLBOX, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_DRAWTBX_INSERT ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_DRAWTBX_INSERT, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_POSITION ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_POSITION, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_OBJECT_ALIGN ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_OBJECT_ALIGN, pSlotArray[nId] ) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		for( USHORT nId = 0; nId < SLOTARRAY_COUNT; nId += 2 )
/*N*/ 		{
/*N*/ 			rSet.Put( TbxImageItem( pSlotArray[nId], pSlotArray[nId+1] ) );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Gibt den gemappten Slot zurueck
|*
\************************************************************************/

//STRIP001 USHORT SdDrawViewShell::GetMappedSlot( USHORT nSId )
//STRIP001 {
//STRIP001 	USHORT nSlot = 0;
//STRIP001 	USHORT nId = GetArrayId( nSId );
//STRIP001 	if( nId != USHRT_MAX )
//STRIP001 		nSlot = pSlotArray[ nId+1 ];
//STRIP001 
//STRIP001 	// Wenn der Slot noch auf sich selbst gemapped ist, muss 0 zurueck-
//STRIP001 	// gegeben werden, da sonst der Slot immer wieder selbst executet
//STRIP001 	// wird. Im Array ist der Slot selbst initial vorhanden, damit das
//STRIP001 	// Image richtig angezeigt wird.
//STRIP001 	if( nSId == nSlot )
//STRIP001 		return( 0 );
//STRIP001 
//STRIP001 	return( nSlot );
//STRIP001 }

/*************************************************************************
|*
|* Gibt die Nummer des HauptSlots im SlotArray zurueck
|*
\************************************************************************/

/*N*/ USHORT SdDrawViewShell::GetArrayId( USHORT nSId )
/*N*/ {
/*N*/ 	for( int i = 0; i < SLOTARRAY_COUNT; i += 2 )
/*N*/ 	{
/*N*/ 		if( pSlotArray[ i ] == nSId )
/*N*/ 			return( i );
/*N*/ 	}
/*N*/ 	DBG_ERROR( "Slot im Array nicht gefunden!" );
/*N*/ 	return( USHRT_MAX );
/*N*/ }


/*************************************************************************
|*
|* IMap-Dlg updaten
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::UpdateIMapDlg( SdrObject* pObj )
//STRIP001 {
//STRIP001 	if( ( pObj->ISA( SdrGrafObj ) || pObj->ISA( SdrOle2Obj ) ) && !pDrView->IsTextEdit() &&
//STRIP001 		 GetViewFrame()->HasChildWindow( SvxIMapDlgChildWindow::GetChildWindowId() ) )
//STRIP001 	{
//STRIP001 		Graphic 	aGraphic;
//STRIP001 		ImageMap*	pIMap = NULL;
//STRIP001 		TargetList*	pTargetList = NULL;
//STRIP001 		SdIMapInfo* pIMapInfo = pDoc->GetIMapInfo( pObj );
//STRIP001 
//STRIP001 		// Grafik vom Objekt besorgen
//STRIP001 		if ( pObj->ISA( SdrGrafObj ) )
//STRIP001 			aGraphic = ( (SdrGrafObj*) pObj )->GetGraphic();
//STRIP001 		else
//STRIP001 			aGraphic = pDoc->GetGraphicFromOle2Obj( (const SdrOle2Obj*) pObj );
//STRIP001 
//STRIP001 		if ( pIMapInfo )
//STRIP001 		{
//STRIP001 			pIMap = (ImageMap*) &pIMapInfo->GetImageMap();
//STRIP001 			pTargetList = new TargetList;
//STRIP001 			GetViewFrame()->GetTargetList( *pTargetList );
//STRIP001 		}
//STRIP001 
//STRIP001 		SvxIMapDlgChildWindow::UpdateIMapDlg( aGraphic, pIMap, pTargetList, pObj );
//STRIP001 
//STRIP001 		// TargetListe kann von uns wieder geloescht werden
//STRIP001 		if ( pTargetList )
//STRIP001 		{
//STRIP001 			String* pEntry = pTargetList->First();
//STRIP001 			while( pEntry )
//STRIP001 			{
//STRIP001 				delete pEntry;
//STRIP001 				pEntry = pTargetList->Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pTargetList;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SdDrawViewShell, NameObjectHdl, SvxNameDialog*, pDialog )
//STRIP001 {
//STRIP001     String aName;
//STRIP001 
//STRIP001     if( pDialog )
//STRIP001         pDialog->GetName( aName );
//STRIP001 
//STRIP001     return( ( !aName.Len() || ( pDoc && !pDoc->GetObj( aName ) ) ) ? 1 : 0 ); 
//STRIP001 }
}
