/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlaccelcfg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:57:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SFX_XMLACCELCFG_HXX
#define INCLUDED_SFX_XMLACCELCFG_HXX

#include "accelcfg.hxx"

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef __COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#include <hash_map>

namespace binfilter {

//STRIP001 class OReadAcceleratorDocumentHandler : public ::com::sun::star::xml::sax::XDocumentHandler,
//STRIP001 										public ::cppu::OWeakObject
//STRIP001 {
//STRIP001 	public:
//STRIP001 		struct OUStringHashCode
//STRIP001 		{
//STRIP001 			size_t operator()( const ::rtl::OUString& sString ) const
//STRIP001 			{
//STRIP001 				return sString.hashCode();
//STRIP001 			}
//STRIP001 		};
//STRIP001 
//STRIP001 		enum Accelerator_XML_Entry
//STRIP001 		{
//STRIP001 			AC_ELEMENT_ACCELERATORLIST,
//STRIP001 			AC_ELEMENT_ITEM,
//STRIP001 			AC_ATTRIBUTE_KEYCODE,
//STRIP001 			AC_ATTRIBUTE_MOD_SHIFT,
//STRIP001 			AC_ATTRIBUTE_MOD_MOD1,
//STRIP001 			AC_ATTRIBUTE_MOD_MOD2,
//STRIP001 			AC_ATTRIBUTE_URL,
//STRIP001 			AC_XML_ENTRY_COUNT
//STRIP001 		};
//STRIP001 
//STRIP001 		enum Accelerator_XML_Namespace
//STRIP001 		{
//STRIP001 			AC_NS_ACCEL,
//STRIP001 			AC_NS_XLINK,
//STRIP001 			AC_XML_NAMESPACES_COUNT
//STRIP001 		};
//STRIP001 
//STRIP001         OReadAcceleratorDocumentHandler( SfxAcceleratorItemList& aNewAcceleratorItemList );
//STRIP001 		virtual ~OReadAcceleratorDocumentHandler() {}
//STRIP001 
//STRIP001 		// XInterface
//STRIP001 		virtual void SAL_CALL acquire() throw()
//STRIP001 			{ OWeakObject::acquire(); }
//STRIP001 		virtual void SAL_CALL release() throw()
//STRIP001 			{ OWeakObject::release(); }
//STRIP001 		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface(
//STRIP001 			const ::com::sun::star::uno::Type & rType ) throw( ::com::sun::star::uno::RuntimeException );
//STRIP001 
//STRIP001 		// XDocumentHandler
//STRIP001 		virtual void SAL_CALL startDocument(void)
//STRIP001 			throw ( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL endDocument(void)
//STRIP001 			throw ( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL startElement(
//STRIP001 			const ::rtl::OUString& aName,
//STRIP001 			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > &xAttribs )
//STRIP001 			throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL endElement(const ::rtl::OUString& aName) throw
//STRIP001 			( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL characters(const ::rtl::OUString& aChars)
//STRIP001 			throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL ignorableWhitespace(const ::rtl::OUString& aWhitespaces)
//STRIP001 			throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData )
//STRIP001 			throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 		virtual void SAL_CALL setDocumentLocator(
//STRIP001 			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator > &xLocator)
//STRIP001 			throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );
//STRIP001 
//STRIP001 	private:
//STRIP001 		::rtl::OUString getErrorLineString();
//STRIP001 
//STRIP001 		class AcceleratorHashMap : public ::std::hash_map< ::rtl::OUString				,
//STRIP001 															Accelerator_XML_Entry		,
//STRIP001 															OUStringHashCode			,
//STRIP001 															::std::equal_to< ::rtl::OUString >	>
//STRIP001 		{
//STRIP001 			public:
//STRIP001 				inline void free()
//STRIP001 				{
//STRIP001 					AcceleratorHashMap().swap( *this );
//STRIP001 				}
//STRIP001 		};
//STRIP001 
//STRIP001 		sal_Bool				m_bAcceleratorListStartFound;
//STRIP001 		sal_Bool				m_bAcceleratorListEndFound;
//STRIP001 		sal_Bool				m_bAcceleratorItemStartFound;
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator >	m_xLocator;
//STRIP001         SfxAcceleratorItemList& m_aReadAcceleratorList;
//STRIP001 		AcceleratorHashMap		m_aAcceleratorHashMap;
//STRIP001 };


class OWriteAcceleratorDocumentHandler
{
	public:
		OWriteAcceleratorDocumentHandler(
            const SfxAcceleratorItemList& aWriteAcceleratorList,
			::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > );
		virtual ~OWriteAcceleratorDocumentHandler();

		void WriteAcceleratorDocument() throw ( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );

	private:
        void WriteAcceleratorItem( const SfxAcceleratorConfigItem& aAcceleratorItem ) throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );

		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > m_xWriteDocumentHandler;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > m_xEmptyList;
		::rtl::OUString											m_aXMLAccelNS;
		::rtl::OUString											m_aXMLXlinkNS;
		::rtl::OUString											m_aAttributeType;
		::rtl::OUString											m_aAttributeURL;
		::rtl::OUString											m_aAttributeKeycode;
		::rtl::OUString											m_aAttributeModShift;
		::rtl::OUString											m_aAttributeModMod1;
		::rtl::OUString											m_aAttributeModMod2;
		::rtl::OUString											m_aAttributeModCTRL;
		::rtl::OUString											m_aAttributeBooleanTRUE;
        const SfxAcceleratorItemList&                           m_aWriteAcceleratorList;
};

}//end of namespace binfilter
#endif // INCLUDED_SVTOOLS_XMLACCELCFG_HXX
