/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_gallery1.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:56:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS

#include <tools/vcompat.hxx>
#include <ucbhelper/content.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <svtools/pathoptions.hxx>
#include <bf_sfx2/docfile.hxx>
#include "gallery.hxx"
#include "galmisc.hxx"
#include "galtheme.hxx"
#include "gallery1.hxx"

#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
namespace binfilter {

#define ENABLE_BYTESTRING_STREAM_OPERATORS

// --------------
// - Namespaces -
// --------------

using namespace ::ucb;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::ucb;

// ---------------------
// - GalleryCacheEntry -
// ---------------------

//STRIP001 class GalleryCacheEntry
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	Gallery*				mpGallery;
//STRIP001 	String					maMultiPath;
//STRIP001 	ULONG					mnRefCount;
//STRIP001 							
//STRIP001 public:						
//STRIP001 							
//STRIP001 							GalleryCacheEntry( Gallery* pGallery, const String& rMultiPath ) :
//STRIP001 								mpGallery( pGallery ), maMultiPath( rMultiPath ) {}
//STRIP001 							~GalleryCacheEntry() { delete mpGallery; }
//STRIP001 
//STRIP001 	Gallery*				GetGallery() const { return mpGallery; }
//STRIP001 	const String&			GetMultiPath() const { return maMultiPath; }
//STRIP001 
//STRIP001 	ULONG					GetRefCount() const { return mnRefCount; }
//STRIP001 	void					IncRefCount() { mnRefCount++; }
//STRIP001 	void					DecRefCount() { mnRefCount--; }
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------------
//STRIP001 // - GalleryThemeEntry -
//STRIP001 // ---------------------
//STRIP001 
//STRIP001 GalleryThemeEntry::GalleryThemeEntry( const INetURLObject& rBaseURL, const String& rName,
//STRIP001 									  UINT32 _nFileNumber, BOOL _bReadOnly, BOOL _bImported,
//STRIP001 									  BOOL _bNewFile, UINT32 _nId, BOOL _bThemeNameFromResource ) :
//STRIP001 		nFileNumber                             ( _nFileNumber ),
//STRIP001 		nId                                     ( _nId ),
//STRIP001 		bReadOnly                               ( _bReadOnly || _bImported ),
//STRIP001 		bImported                               ( _bImported ),
//STRIP001 		bThemeNameFromResource  ( _bThemeNameFromResource )
//STRIP001 {
//STRIP001 	INetURLObject aURL( rBaseURL );
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 	String aFileName( String( RTL_CONSTASCII_USTRINGPARAM( "sg" ) ) );
//STRIP001 
//STRIP001 	aURL.Append( ( aFileName += String::CreateFromInt32( nFileNumber ) ) += String( RTL_CONSTASCII_USTRINGPARAM( ".thm" ) ) );
//STRIP001 	aThmURL = ImplGetURLIgnoreCase( aURL );
//STRIP001 
//STRIP001 	aURL.setExtension( String( RTL_CONSTASCII_USTRINGPARAM( "sdg" ) ) );
//STRIP001 	aSdgURL = ImplGetURLIgnoreCase( aURL );
//STRIP001 
//STRIP001 	aURL.setExtension( String( RTL_CONSTASCII_USTRINGPARAM( "sdv" ) ) );
//STRIP001 	aSdvURL = ImplGetURLIgnoreCase( aURL );
//STRIP001 
//STRIP001 	SetModified( _bNewFile );
//STRIP001 
//STRIP001 	if( nId && bThemeNameFromResource )
//STRIP001 		aName = String( GAL_RESID( RID_GALLERYSTR_THEME_START + (USHORT) nId ) );
//STRIP001 
//STRIP001 	if( !aName.Len() )
//STRIP001 		aName = rName;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 INetURLObject GalleryThemeEntry::ImplGetURLIgnoreCase( const INetURLObject& rURL ) const
//STRIP001 {
//STRIP001 	INetURLObject	aURL( rURL );
//STRIP001 	String			aFileName;
//STRIP001 	BOOL			bExists = FALSE;
//STRIP001 
//STRIP001 	// check original file name
//STRIP001 	if( FileExists( aURL ) )
//STRIP001 		bExists = TRUE;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// check upper case file name
//STRIP001 		aURL.setName( aURL.getName().ToUpperAscii() );
//STRIP001 
//STRIP001 		if( FileExists( aURL ) )
//STRIP001 			bExists = TRUE;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// check lower case file name
//STRIP001 			aURL.setName( aURL.getName().ToLowerAscii() );
//STRIP001 
//STRIP001 			if( FileExists( aURL ) )
//STRIP001 				bExists = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aURL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemeEntry::SetName( const String& rNewName )
//STRIP001 {
//STRIP001 	if( aName != rNewName )
//STRIP001 	{
//STRIP001 		aName = rNewName;
//STRIP001 		SetModified( TRUE );
//STRIP001 		bThemeNameFromResource = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemeEntry::SetId( UINT32 nNewId, BOOL bResetThemeName )
//STRIP001 {
//STRIP001 	nId = nNewId;
//STRIP001 	SetModified( TRUE );
//STRIP001 	bThemeNameFromResource = ( nId && bResetThemeName );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------------
//STRIP001 // - GalleryImportThemeEntry -
//STRIP001 // ---------------------------
//STRIP001 
//STRIP001 SvStream& operator<<( SvStream& rOut, const GalleryImportThemeEntry& rEntry )
//STRIP001 {
//STRIP001 	ByteString aDummy;
//STRIP001 
//STRIP001 	rOut << ByteString( rEntry.aThemeName, RTL_TEXTENCODING_UTF8 ) <<
//STRIP001 			ByteString( rEntry.aUIName, RTL_TEXTENCODING_UTF8 ) <<
//STRIP001 			ByteString( rEntry.aURL.GetMainURL( INetURLObject::NO_DECODE ), RTL_TEXTENCODING_UTF8 ) <<
//STRIP001 			ByteString( rEntry.aImportName, RTL_TEXTENCODING_UTF8 ) <<
//STRIP001 			aDummy;
//STRIP001 
//STRIP001 	return rOut;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, GalleryImportThemeEntry& rEntry )
//STRIP001 {
//STRIP001 	ByteString aTmpStr;
//STRIP001 
//STRIP001 	rIn >> aTmpStr; rEntry.aThemeName = String( aTmpStr, RTL_TEXTENCODING_UTF8 );
//STRIP001 	rIn >> aTmpStr; rEntry.aUIName = String( aTmpStr, RTL_TEXTENCODING_UTF8 );
//STRIP001 	rIn >> aTmpStr; rEntry.aURL = INetURLObject( String( aTmpStr, RTL_TEXTENCODING_UTF8 ) );
//STRIP001 	rIn >> aTmpStr; rEntry.aImportName = String( aTmpStr, RTL_TEXTENCODING_UTF8 );
//STRIP001 	rIn >> aTmpStr;
//STRIP001 
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 // --------------------------
//STRIP001 // - GalleryThemeCacheEntry -
//STRIP001 // --------------------------
//STRIP001 
//STRIP001 class GalleryThemeCacheEntry
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	const GalleryThemeEntry*        mpThemeEntry;
//STRIP001 	GalleryTheme*                           mpTheme;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 								GalleryThemeCacheEntry( const GalleryThemeEntry* pThemeEntry, GalleryTheme* pTheme ) :
//STRIP001 									mpThemeEntry( pThemeEntry ), mpTheme( pTheme ) {}
//STRIP001 								~GalleryThemeCacheEntry() { delete mpTheme; }
//STRIP001 
//STRIP001 	const GalleryThemeEntry*        GetThemeEntry() const { return mpThemeEntry; }
//STRIP001 	GalleryTheme*                           GetTheme() const { return mpTheme; }
//STRIP001 };
//STRIP001 
//STRIP001 // -----------
//STRIP001 // - Statics -
//STRIP001 // -----------
//STRIP001 
//STRIP001 List Gallery::aGalleryCache;
//STRIP001 
//STRIP001 // -----------
//STRIP001 // - Gallery -
//STRIP001 // -----------
//STRIP001 
//STRIP001 Gallery::Gallery( const String& rMultiPath ) :
//STRIP001 		bMultiPath			( FALSE ),
//STRIP001 		nReadTextEncoding	( gsl_getSystemTextEncoding() ),
//STRIP001 		nLastFileNumber		( 0 )
//STRIP001 {
//STRIP001 	ImplLoad( rMultiPath );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 Gallery::~Gallery()
//STRIP001 {
//STRIP001 	// Themen-Liste loeschen
//STRIP001 	for( GalleryThemeEntry* pThemeEntry = aThemeList.First(); pThemeEntry; pThemeEntry = aThemeList.Next() )
//STRIP001 		delete pThemeEntry;
//STRIP001 
//STRIP001 	// Import-Liste loeschen
//STRIP001 	for( GalleryImportThemeEntry* pImportEntry = aImportList.First(); pImportEntry; pImportEntry = aImportList.Next() )
//STRIP001 		delete pImportEntry;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 Gallery* Gallery::AcquireGallery( const String& rMultiPath )
//STRIP001 {
//STRIP001 	Gallery*                pGallery = NULL;
//STRIP001 	GalleryCacheEntry*      pEntry;
//STRIP001 	GalleryCacheEntry*      pFound;
//STRIP001 
//STRIP001 	for( pEntry = (GalleryCacheEntry*) aGalleryCache.First(); pEntry && !pGallery; pEntry = (GalleryCacheEntry*) aGalleryCache.Next() )
//STRIP001 		if( rMultiPath == pEntry->GetMultiPath() )
//STRIP001 			pGallery = ( pFound = pEntry )->GetGallery();
//STRIP001 
//STRIP001 	if( !pGallery )
//STRIP001 		aGalleryCache.Insert( pFound = new GalleryCacheEntry( new Gallery( rMultiPath ), rMultiPath ), LIST_APPEND );
//STRIP001 
//STRIP001 	pFound->IncRefCount();
//STRIP001 
//STRIP001 	return( pFound->GetGallery() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ReleaseGallery( Gallery* pGallery )
//STRIP001 {
//STRIP001 	GalleryCacheEntry*      pFound = NULL;
//STRIP001 	GalleryCacheEntry*      pEntry;
//STRIP001 
//STRIP001 	for( pEntry = (GalleryCacheEntry*) aGalleryCache.First(); pEntry && !pFound; pEntry = (GalleryCacheEntry*) aGalleryCache.Next() )
//STRIP001 		if( pGallery == pEntry->GetGallery() )
//STRIP001 			pFound = pEntry;
//STRIP001 
//STRIP001 	DBG_ASSERT( pFound, "Gallery::ReleaseGallery(...): Gallery entry not found" );
//STRIP001 	pFound->DecRefCount();
//STRIP001 
//STRIP001 	if( !pFound->GetRefCount() )
//STRIP001 		delete (GalleryCacheEntry*) aGalleryCache.Remove( pFound );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ImplLoad( const String& rMultiPath )
//STRIP001 {
//STRIP001     INetURLObject   aCurURL;
//STRIP001 	const USHORT    nTokenCount = rMultiPath.GetTokenCount( ';' );
//STRIP001     sal_Bool        bIsReadOnlyDir;
//STRIP001 
//STRIP001 	bMultiPath = ( nTokenCount > 0 );
//STRIP001 	
//STRIP001 	aCurURL = SvtPathOptions().GetConfigPath();
//STRIP001 	ImplLoadSubDirs( aCurURL, bIsReadOnlyDir );
//STRIP001 	
//STRIP001 	if( !bIsReadOnlyDir )
//STRIP001 	    aUserURL = aCurURL;
//STRIP001 
//STRIP001 	if( bMultiPath )
//STRIP001 	{
//STRIP001 		aRelURL = INetURLObject( rMultiPath.GetToken( 0, ';' ) );
//STRIP001 
//STRIP001 		for( USHORT i = 0UL; i < nTokenCount; i++ )
//STRIP001 		{
//STRIP001 		    aCurURL = rMultiPath.GetToken( i, ';' );
//STRIP001 			
//STRIP001 			ImplLoadSubDirs( aCurURL, bIsReadOnlyDir );
//STRIP001 			
//STRIP001 			if( !bIsReadOnlyDir )
//STRIP001 			    aUserURL = aCurURL;
//STRIP001 	    }
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aRelURL = INetURLObject( rMultiPath );
//STRIP001 
//STRIP001 	DBG_ASSERT( aUserURL.GetProtocol() != INET_PROT_NOT_VALID, "no writable Gallery user directory available" );
//STRIP001 	DBG_ASSERT( aRelURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	ImplLoadImports();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ImplLoadSubDirs( const INetURLObject& rBaseURL, sal_Bool& rbDirIsReadOnly )
//STRIP001 {
//STRIP001     rbDirIsReadOnly = sal_False;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		uno::Reference< XCommandEnvironment >   xEnv;
//STRIP001 		Content	   							    aCnt( rBaseURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 
//STRIP001 		uno::Sequence< OUString > aProps( 1 );
//STRIP001 		aProps.getArray()[ 0 ] = OUString::createFromAscii( "Url" );
//STRIP001 
//STRIP001 		uno::Reference< sdbc::XResultSet > xResultSet( aCnt.createCursor( aProps, INCLUDE_DOCUMENTS_ONLY ) );
//STRIP001 		
//STRIP001 		try
//STRIP001 		{
//STRIP001 		    // check readonlyness the very hard way
//STRIP001         	INetURLObject   aTestURL( rBaseURL );
//STRIP001 	        String          aTestFile( RTL_CONSTASCII_USTRINGPARAM( "cdefghij.klm" ) );
//STRIP001 
//STRIP001     	    aTestURL.Append( aTestFile );
//STRIP001 	        SvStream* pTestStm = ::utl::UcbStreamHelper::CreateStream( aTestURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE );
//STRIP001 	    
//STRIP001 	        if( pTestStm )
//STRIP001 	        {
//STRIP001 	            *pTestStm << 1;
//STRIP001 	            
//STRIP001 	            if( pTestStm->GetError() )
//STRIP001 	                rbDirIsReadOnly = sal_True;
//STRIP001 	                
//STRIP001 	            delete pTestStm;
//STRIP001 	            KillFile( aTestURL );
//STRIP001 	        }
//STRIP001 	        else
//STRIP001 	            rbDirIsReadOnly = sal_True;
//STRIP001 	    }
//STRIP001 	    catch( const ContentCreationException& )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 	    catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 	    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 
//STRIP001 		if( xResultSet.is() )
//STRIP001 		{
//STRIP001 			uno::Reference< XContentAccess > xContentAccess( xResultSet, uno::UNO_QUERY );
//STRIP001 
//STRIP001 			if( xContentAccess.is() )
//STRIP001 			{
//STRIP001 				while( xResultSet->next() )
//STRIP001 				{
//STRIP001 					INetURLObject aThmURL( xContentAccess->queryContentIdentifierString() );
//STRIP001 					
//STRIP001 					if( aThmURL.GetExtension().CompareIgnoreCaseToAscii( "thm" ) == COMPARE_EQUAL )
//STRIP001 					{
//STRIP001 						INetURLObject	aSdgURL( aThmURL); aSdgURL.SetExtension( OUString::createFromAscii( "sdg" ) );
//STRIP001 						INetURLObject	aSdvURL( aThmURL ); aSdvURL.SetExtension( OUString::createFromAscii( "sdv" ) );
//STRIP001 						const OUString	aTitleProp( OUString::createFromAscii( "Title" ) );
//STRIP001                         const OUString  aReadOnlyProp( OUString::createFromAscii( "IsReadOnly" ) );
//STRIP001 						OUString		aTitle;
//STRIP001 						sal_Bool		bReadOnly = sal_False;
//STRIP001 						
//STRIP001 						try
//STRIP001 						{
//STRIP001 						    Content aThmCnt( aThmURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 						    Content aSdgCnt( aSdgURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 						    Content aSdvCnt( aSdvURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 
//STRIP001 						    try
//STRIP001 						    {
//STRIP001 						        aThmCnt.getPropertyValue( aTitleProp ) >>= aTitle;
//STRIP001 						    }
//STRIP001 	                        catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                        {
//STRIP001 	                        }
//STRIP001 	                        catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                        {
//STRIP001 	                        }
//STRIP001 
//STRIP001 						    if( aTitle.getLength() )
//STRIP001 						    {
//STRIP001 						        try
//STRIP001 						        {
//STRIP001 							        aThmCnt.getPropertyValue( aReadOnlyProp ) >>= bReadOnly;
//STRIP001 						        }
//STRIP001 	                            catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                            {
//STRIP001 	                            }
//STRIP001 	                            catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                            {
//STRIP001 	                            }
//STRIP001 
//STRIP001 							    if( !bReadOnly )
//STRIP001 							    {
//STRIP001 							        try
//STRIP001 							        {
//STRIP001 								        aSdgCnt.getPropertyValue( aTitleProp ) >>= aTitle;
//STRIP001 						            }
//STRIP001 	                                catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                                {
//STRIP001 	                                }
//STRIP001 	                                catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                                {
//STRIP001 	                                }
//STRIP001 
//STRIP001 								    if( aTitle.getLength() )
//STRIP001 								    {
//STRIP001 								        try
//STRIP001 								        {
//STRIP001 	    								    aSdgCnt.getPropertyValue( aReadOnlyProp ) >>= bReadOnly;
//STRIP001     					                }
//STRIP001 	                                    catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                                    {
//STRIP001 	                                    }
//STRIP001 	                                    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                                    {
//STRIP001 	                                    }
//STRIP001 							        }
//STRIP001 							    }
//STRIP001 
//STRIP001 							    if( !bReadOnly )
//STRIP001 							    {
//STRIP001 							        try
//STRIP001 							        {
//STRIP001 								        aSdvCnt.getPropertyValue( aTitleProp ) >>= aTitle;
//STRIP001     					            }
//STRIP001 	                                catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                                {
//STRIP001 	                                }
//STRIP001 	                                catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                                {
//STRIP001 	                                }
//STRIP001 
//STRIP001 								    if( aTitle.getLength() )
//STRIP001 								    {
//STRIP001 								        try
//STRIP001 								        {
//STRIP001     									    aSdvCnt.getPropertyValue( aReadOnlyProp ) >>= bReadOnly;
//STRIP001     					                }
//STRIP001 	                                    catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                                    {
//STRIP001 	                                    }
//STRIP001 	                                    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                                    {
//STRIP001 	                                    }
//STRIP001 								    }
//STRIP001 							    }
//STRIP001 
//STRIP001 							    GalleryThemeEntry* pEntry = GalleryTheme::CreateThemeEntry( aThmURL, rbDirIsReadOnly || bReadOnly );
//STRIP001 
//STRIP001 							    if( pEntry )
//STRIP001 							    {
//STRIP001 								    const ULONG nFileNumber = (ULONG) aThmURL.GetBase().Erase( 0, 2 ).Erase( 6 ).ToInt32();
//STRIP001 
//STRIP001 								    aThemeList.Insert( pEntry, LIST_APPEND );
//STRIP001 
//STRIP001 								    if( nFileNumber > nLastFileNumber )
//STRIP001 									    nLastFileNumber = nFileNumber;
//STRIP001 							    }
//STRIP001 						    }
//STRIP001 						}
//STRIP001 	                    catch( const ContentCreationException& )
//STRIP001 	                    {
//STRIP001 	                    }
//STRIP001 	                    catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	                    {
//STRIP001 	                    }
//STRIP001 	                    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	                    {
//STRIP001 	                    }
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( const ContentCreationException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ImplLoadImports()
//STRIP001 {
//STRIP001 	INetURLObject aURL( GetUserURL() );
//STRIP001 
//STRIP001 	aURL.Append( String( RTL_CONSTASCII_USTRINGPARAM( "gallery.sdi" ) ) );
//STRIP001 
//STRIP001 	if( FileExists( aURL ) )
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			GalleryThemeEntry*			pThemeEntry;
//STRIP001 			GalleryImportThemeEntry*	pImportEntry;
//STRIP001 			INetURLObject               aFile;
//STRIP001 			UINT32                      nInventor;
//STRIP001 			UINT32                      nCount;
//STRIP001 			UINT16                      nId;
//STRIP001 			UINT16                      i;
//STRIP001 			UINT16                      nTempCharSet;
//STRIP001 
//STRIP001 			for( pImportEntry = aImportList.First(); pImportEntry; pImportEntry = aImportList.Next() )
//STRIP001 				delete pImportEntry;
//STRIP001 
//STRIP001 			aImportList.Clear();
//STRIP001 			*pIStm >> nInventor;
//STRIP001 
//STRIP001 			if( nInventor == COMPAT_FORMAT( 'S', 'G', 'A', '3' ) )
//STRIP001 			{
//STRIP001 				*pIStm >> nId >> nCount >> nTempCharSet;
//STRIP001 
//STRIP001 				for( i = 0; i < nCount; i++ )
//STRIP001 				{
//STRIP001 					pImportEntry = new GalleryImportThemeEntry;
//STRIP001 
//STRIP001 					*pIStm >> *pImportEntry;
//STRIP001 					aImportList.Insert( pImportEntry, LIST_APPEND );
//STRIP001 					aFile = INetURLObject( pImportEntry->aURL );
//STRIP001 					pThemeEntry = new GalleryThemeEntry( aFile,
//STRIP001 														 pImportEntry->aUIName,
//STRIP001 														 aFile.GetBase().Erase( 0, 2 ).Erase( 6 ).ToInt32(),
//STRIP001 														 TRUE, TRUE, FALSE, 0, FALSE );
//STRIP001 
//STRIP001 					aThemeList.Insert( pThemeEntry, LIST_APPEND );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ImplWriteImportList()
//STRIP001 {
//STRIP001 	INetURLObject aURL( GetUserURL() ); 
//STRIP001 	aURL.Append( ( String( "gallery.sdi", RTL_TEXTENCODING_UTF8 ) ) );
//STRIP001 	SvStream* pOStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC );
//STRIP001 
//STRIP001 	if( pOStm )
//STRIP001 	{
//STRIP001 		const UINT32 nInventor = (UINT32) COMPAT_FORMAT( 'S', 'G', 'A', '3' );
//STRIP001 		const UINT16 nId = 0x0004;
//STRIP001 
//STRIP001 		*pOStm << nInventor << nId << (UINT32) aImportList.Count() << (UINT16) gsl_getSystemTextEncoding();
//STRIP001 
//STRIP001 		for( GalleryImportThemeEntry* pImportEntry = aImportList.First(); pImportEntry; pImportEntry = aImportList.Next() )
//STRIP001 			*pOStm << *pImportEntry;
//STRIP001 
//STRIP001 		if( pOStm->GetError() )
//STRIP001 			ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
//STRIP001 
//STRIP001 		delete pOStm;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryThemeEntry* Gallery::ImplGetThemeEntry( const String& rThemeName )
//STRIP001 {
//STRIP001 	GalleryThemeEntry* pFound = NULL;
//STRIP001 
//STRIP001 	if( rThemeName.Len() )
//STRIP001 		for( GalleryThemeEntry* pEntry = aThemeList.First(); pEntry && !pFound; pEntry = aThemeList.Next() )
//STRIP001 			if( rThemeName == pEntry->GetThemeName() )
//STRIP001 				pFound = pEntry;
//STRIP001 
//STRIP001 	return pFound;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryImportThemeEntry* Gallery::ImplGetImportThemeEntry( const String& rImportName )
//STRIP001 {
//STRIP001 	GalleryImportThemeEntry* pFound = NULL;
//STRIP001 
//STRIP001 	for( GalleryImportThemeEntry* pImportEntry = aImportList.First(); pImportEntry && !pFound; pImportEntry = aImportList.Next() )
//STRIP001 		if ( rImportName == pImportEntry->aUIName )
//STRIP001 			pFound = pImportEntry;
//STRIP001 
//STRIP001 	return pFound;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 String Gallery::GetThemeName( ULONG nThemeId ) const
//STRIP001 {
//STRIP001 	GalleryThemeEntry* pFound = NULL;
//STRIP001 
//STRIP001 	for( ULONG n = 0, nCount = aThemeList.Count(); n < nCount; n++ )
//STRIP001 	{
//STRIP001 		GalleryThemeEntry* pEntry = aThemeList.GetObject( n );
//STRIP001 
//STRIP001 		if( nThemeId == pEntry->GetId() )
//STRIP001 			pFound = pEntry;
//STRIP001 	}
//STRIP001 
//STRIP001 	// try fallback, if no entry was found
//STRIP001 	if( !pFound )
//STRIP001 	{
//STRIP001 		ByteString      aFallback;
//STRIP001 
//STRIP001 		switch( nThemeId )
//STRIP001 		{
//STRIP001 			case( GALLERY_THEME_3D ): aFallback = "3D"; break;
//STRIP001 			case( GALLERY_THEME_BULLETS ): aFallback = "Bullets"; break;
//STRIP001 			case( GALLERY_THEME_HOMEPAGE ): aFallback = "Homepage"; break;
//STRIP001 			case( GALLERY_THEME_HTMLBUTTONS ): aFallback = "private://gallery/hidden/HtmlExportButtons"; break;
//STRIP001 			case( GALLERY_THEME_POWERPOINT ): aFallback = "private://gallery/hidden/imgppt"; break;
//STRIP001 			case( GALLERY_THEME_RULERS ): aFallback = "Rulers"; break;
//STRIP001 			case( GALLERY_THEME_SOUNDS ): aFallback = "Sounds"; break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		pFound = ( (Gallery*) this )->ImplGetThemeEntry( String::CreateFromAscii( aFallback.GetBuffer() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( pFound ? pFound->GetThemeName() : String() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Gallery::HasTheme( const String& rThemeName )
//STRIP001 {
//STRIP001 	return( ImplGetThemeEntry( rThemeName ) != NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Gallery::CreateTheme( const String& rThemeName )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( !HasTheme( rThemeName ) && ( GetUserURL().GetProtocol() != INET_PROT_NOT_VALID ) )
//STRIP001 	{
//STRIP001 		GalleryThemeEntry* pNewEntry = new GalleryThemeEntry( GetUserURL(), rThemeName,
//STRIP001 															  ++nLastFileNumber,
//STRIP001 															  FALSE, FALSE, TRUE, 0, FALSE );
//STRIP001 
//STRIP001 		aThemeList.Insert( pNewEntry, LIST_APPEND );
//STRIP001 		delete( new GalleryTheme( this, pNewEntry ) );
//STRIP001 		Broadcast( GalleryHint( GALLERY_HINT_THEME_CREATED, rThemeName ) );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Gallery::CreateImportTheme( const INetURLObject& rURL, const String& rImportName )
//STRIP001 {
//STRIP001 	INetURLObject	aURL( rURL );
//STRIP001 	BOOL			bRet = FALSE;
//STRIP001 
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( FileExists( aURL ) )
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			ULONG   nStmErr;
//STRIP001 			UINT16  nId;
//STRIP001 
//STRIP001 			*pIStm >> nId;
//STRIP001 
//STRIP001 			if( nId > 0x0004 )
//STRIP001 				ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ByteString				aTmpStr;
//STRIP001 				String                  aThemeName; *pIStm >> aTmpStr; aThemeName = String( aTmpStr, RTL_TEXTENCODING_UTF8 );
//STRIP001 				GalleryThemeEntry*      pThemeEntry = new GalleryThemeEntry( aURL, rImportName,
//STRIP001 																			 aURL.GetBase().Erase( 0, 2 ).Erase( 6 ).ToInt32(),
//STRIP001 																			 TRUE, TRUE, TRUE, 0, FALSE );
//STRIP001 				GalleryTheme*           pImportTheme = new GalleryTheme( this, pThemeEntry );
//STRIP001 
//STRIP001 				pIStm->Seek( STREAM_SEEK_TO_BEGIN );
//STRIP001 				*pIStm >> *pImportTheme;
//STRIP001 				nStmErr = pIStm->GetError();
//STRIP001 
//STRIP001 				if( nStmErr )
//STRIP001 				{
//STRIP001 					delete pThemeEntry;
//STRIP001 					ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					String  aName( rImportName );
//STRIP001 					String  aNewName( aName );
//STRIP001 					ULONG   nCount = 0;
//STRIP001 
//STRIP001 					aName += ' ';
//STRIP001 
//STRIP001 					while ( HasTheme( aNewName ) && ( nCount++ < 16000 ) )
//STRIP001 					{
//STRIP001 						aNewName = aName;
//STRIP001 						aNewName += String::CreateFromInt32( nCount );
//STRIP001 					}
//STRIP001 
//STRIP001 					pImportTheme->SetImportName( aNewName );
//STRIP001 					aThemeList.Insert( pThemeEntry, LIST_APPEND );
//STRIP001 
//STRIP001 					// Thema in Import-Liste eintragen und Import-Liste     speichern
//STRIP001 					GalleryImportThemeEntry* pImportEntry = new GalleryImportThemeEntry;
//STRIP001 					pImportEntry->aThemeName = pImportEntry->aUIName = aNewName;
//STRIP001 					pImportEntry->aURL = rURL;
//STRIP001 					pImportEntry->aImportName = rImportName;
//STRIP001 					aImportList.Insert( pImportEntry, LIST_APPEND );
//STRIP001 					ImplWriteImportList();
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 
//STRIP001 				delete pImportTheme;
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Gallery::RenameTheme( const String& rOldName, const String& rNewName )
//STRIP001 {
//STRIP001 	GalleryThemeEntry*      pThemeEntry = ImplGetThemeEntry( rOldName );
//STRIP001 	BOOL                            bRet = FALSE;
//STRIP001 
//STRIP001 	// Ueberpruefen, ob neuer Themenname schon vorhanden ist
//STRIP001 	if( pThemeEntry && !HasTheme( rNewName ) && ( !pThemeEntry->IsReadOnly() || pThemeEntry->IsImported() ) )
//STRIP001 	{
//STRIP001 		SfxListener             aDummyListener;
//STRIP001 		GalleryTheme*   pThm = AcquireTheme( rOldName, aDummyListener );
//STRIP001 
//STRIP001 		if( pThm )
//STRIP001 		{
//STRIP001 			const String aOldName( rOldName );
//STRIP001 
//STRIP001 			pThemeEntry->SetName( rNewName );
//STRIP001 			pThm->ImplWrite();
//STRIP001 
//STRIP001 			if( pThemeEntry->IsImported() )
//STRIP001 			{
//STRIP001 				pThm->SetImportName( rNewName );
//STRIP001 
//STRIP001 				GalleryImportThemeEntry* pImportEntry = ImplGetImportThemeEntry( rOldName );
//STRIP001 
//STRIP001 				if( pImportEntry )
//STRIP001 				{
//STRIP001 					pImportEntry->aUIName = rNewName;
//STRIP001 					ImplWriteImportList();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			Broadcast( GalleryHint( GALLERY_HINT_THEME_RENAMED, aOldName, pThm->GetName() ) );
//STRIP001 			ReleaseTheme( pThm, aDummyListener );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Gallery::RemoveTheme( const String& rThemeName )
//STRIP001 {
//STRIP001 	GalleryThemeEntry*	pThemeEntry = ImplGetThemeEntry( rThemeName );
//STRIP001 	BOOL                bRet = FALSE;
//STRIP001 
//STRIP001 	if( pThemeEntry && ( !pThemeEntry->IsReadOnly() || pThemeEntry->IsImported() ) )
//STRIP001 	{
//STRIP001 		Broadcast( GalleryHint( GALLERY_HINT_CLOSE_THEME, rThemeName ) );
//STRIP001 
//STRIP001 		if( pThemeEntry->IsImported() )
//STRIP001 		{
//STRIP001 			GalleryImportThemeEntry* pImportEntry = ImplGetImportThemeEntry( rThemeName );
//STRIP001 
//STRIP001 			if( pImportEntry )
//STRIP001 			{
//STRIP001 				delete aImportList.Remove( pImportEntry );
//STRIP001 				ImplWriteImportList();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxListener		aDummyListener;
//STRIP001 			GalleryTheme*	pThm = AcquireTheme( rThemeName, aDummyListener );
//STRIP001 			INetURLObject	aThmURL( pThm->GetThmURL() );
//STRIP001 			INetURLObject	aSdgURL( pThm->GetSdgURL() );
//STRIP001 			INetURLObject	aSdvURL( pThm->GetSdvURL() );
//STRIP001 
//STRIP001 			ReleaseTheme( pThm, aDummyListener );
//STRIP001 
//STRIP001 			KillFile( aThmURL );
//STRIP001 			KillFile( aSdgURL );
//STRIP001 			KillFile( aSdvURL );
//STRIP001 		}
//STRIP001 
//STRIP001 		delete aThemeList.Remove( pThemeEntry );
//STRIP001 		Broadcast( GalleryHint( GALLERY_HINT_THEME_REMOVED, rThemeName ) );
//STRIP001 
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 INetURLObject Gallery::GetImportURL( const String& rThemeName )
//STRIP001 {
//STRIP001 	INetURLObject				aURL;
//STRIP001 	GalleryImportThemeEntry*	pImportEntry = ImplGetImportThemeEntry( rThemeName );
//STRIP001 
//STRIP001 	if( pImportEntry )
//STRIP001 	{
//STRIP001 		aURL = pImportEntry->aURL;
//STRIP001 		DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aURL;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryTheme* Gallery::ImplGetCachedTheme( const GalleryThemeEntry* pThemeEntry )
//STRIP001 {
//STRIP001 	GalleryTheme* pTheme = NULL;
//STRIP001 
//STRIP001 	if( pThemeEntry )
//STRIP001 	{
//STRIP001 		GalleryThemeCacheEntry* pEntry;
//STRIP001 
//STRIP001 		for( pEntry = (GalleryThemeCacheEntry*) aThemeCache.First(); pEntry && !pTheme; pEntry = (GalleryThemeCacheEntry*) aThemeCache.Next() )
//STRIP001 			if( pThemeEntry == pEntry->GetThemeEntry() )
//STRIP001 				pTheme = pEntry->GetTheme();
//STRIP001 
//STRIP001 		if( !pTheme )
//STRIP001 		{
//STRIP001 			INetURLObject aURL;
//STRIP001 
//STRIP001 			if( !pThemeEntry->IsImported() )
//STRIP001 				aURL = pThemeEntry->GetThmURL();
//STRIP001 			else
//STRIP001 				aURL = GetImportURL( pThemeEntry->GetThemeName() );
//STRIP001 
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 			if( FileExists( aURL ) )
//STRIP001 			{
//STRIP001 				SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 				if( pIStm )
//STRIP001 				{
//STRIP001 					pTheme = new GalleryTheme( this, (GalleryThemeEntry*) pThemeEntry );
//STRIP001 					*pIStm >> *pTheme;
//STRIP001 
//STRIP001 					if( pIStm->GetError() )
//STRIP001 						delete pTheme, pTheme = NULL;
//STRIP001 					else if( pThemeEntry->IsImported() )
//STRIP001 						pTheme->SetImportName( pThemeEntry->GetThemeName() );
//STRIP001 
//STRIP001 					delete pIStm;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( pTheme )
//STRIP001 				aThemeCache.Insert( new GalleryThemeCacheEntry( pThemeEntry, pTheme ), LIST_APPEND );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pTheme;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ImplDeleteCachedTheme( GalleryTheme* pTheme )
//STRIP001 {
//STRIP001 	GalleryThemeCacheEntry* pEntry;
//STRIP001 	BOOL                                    bDone = FALSE;
//STRIP001 
//STRIP001 	for( pEntry = (GalleryThemeCacheEntry*) aThemeCache.First(); pEntry && !bDone; pEntry = (GalleryThemeCacheEntry*) aThemeCache.Next() )
//STRIP001 	{
//STRIP001 		if( pTheme == pEntry->GetTheme() )
//STRIP001 		{
//STRIP001 			delete (GalleryThemeCacheEntry*) aThemeCache.Remove( pEntry );
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryTheme* Gallery::AcquireTheme( const String& rThemeName, SfxListener& rListener )
//STRIP001 {
//STRIP001 	GalleryTheme*           pTheme = NULL;
//STRIP001 	GalleryThemeEntry*      pThemeEntry = ImplGetThemeEntry( rThemeName );
//STRIP001 
//STRIP001 	if( pThemeEntry && ( ( pTheme = ImplGetCachedTheme( pThemeEntry ) ) != NULL ) )
//STRIP001 		rListener.StartListening( *pTheme );
//STRIP001 
//STRIP001 	return pTheme;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Gallery::ReleaseTheme( GalleryTheme* pTheme, SfxListener& rListener )
//STRIP001 {
//STRIP001 	if( pTheme )
//STRIP001 	{
//STRIP001 		rListener.EndListening( *pTheme );
//STRIP001 
//STRIP001 		if( !pTheme->HasListeners() )
//STRIP001 			ImplDeleteCachedTheme( pTheme );
//STRIP001 	}
//STRIP001 }
}
