/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_drawbase.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:26:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #pragma hdrstop
//STRIP001 #include <hintids.hxx>
//STRIP001 #ifndef _UIPARAM_HXX
//STRIP001 #include <uiparam.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _LIST_HXX //autogen
//STRIP001 #include <tools/list.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVDVIEW_HXX //autogen
//STRIP001 #include <bf_svx/svdview.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVDOBJ_HXX //autogen
//STRIP001 #include <bf_svx/svdobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXPTITEM_HXX //autogen
//STRIP001 #include <svtools/ptitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SIZEITEM_HXX //autogen
//STRIP001 #include <bf_svx/sizeitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXREQUEST_HXX //autogen
//STRIP001 #include <bf_sfx2/request.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_BINDINGS_HXX //autogen
//STRIP001 #include <bf_sfx2/bindings.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FMTCLDS_HXX
//STRIP001 #include <fmtclds.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FRMFMT_HXX //autogen
//STRIP001 #include <frmfmt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXVIEWFRM_HXX
//STRIP001 #include <bf_sfx2/viewfrm.hxx>
//STRIP001 #endif
//STRIP001 #include "cmdid.h"
//STRIP001 #include "basesh.hxx"
//STRIP001 #include "view.hxx"
//STRIP001 #include "wrtsh.hxx"
//STRIP001 #include "drawbase.hxx"
//STRIP001 #include "edtwin.hxx"
//STRIP001 #include "caption.hxx"
//STRIP001 #include "swundo.hxx"
//STRIP001 
//STRIP001 extern BOOL bNoInterrupt;		// in mainwn.cxx
//STRIP001 
//STRIP001 #define MINMOVE ((USHORT)pSh->GetOut()->PixelToLogic(Size(pSh->GetDrawView()->GetMarkHdlSizePixel()/2,0)).Width())
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 SwDrawBase::SwDrawBase(SwWrtShell* pSwWrtShell, SwEditWin* pWindow, SwView* pSwView) :
//STRIP001 	pSh(pSwWrtShell),
//STRIP001 	pWin(pWindow),
//STRIP001 	pView(pSwView),
//STRIP001     nSlotId(USHRT_MAX),
//STRIP001 	bInsForm(FALSE),
//STRIP001 	bCreateObj(TRUE)
//STRIP001 {
//STRIP001 	if ( !pSh->HasDrawView() )
//STRIP001 		pSh->MakeDrawView();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 __EXPORT SwDrawBase::~SwDrawBase()
//STRIP001 {
//STRIP001 	if (pView->GetWrtShellPtr())	// Im view-Dtor koennte die wrtsh bereits geloescht worden sein...
//STRIP001 		pSh->GetDrawView()->SetEditMode(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonDown-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwDrawBase::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 
//STRIP001 	pSdrView->SetOrtho(rMEvt.IsShift());
//STRIP001 	pSdrView->SetAngleSnapEnabled(rMEvt.IsShift());
//STRIP001 
//STRIP001 	if (rMEvt.IsMod2())
//STRIP001 	{
//STRIP001 		pSdrView->SetCreate1stPointAsCenter(TRUE);
//STRIP001 		pSdrView->SetResizeAtCenter(TRUE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pSdrView->SetCreate1stPointAsCenter(FALSE);
//STRIP001 		pSdrView->SetResizeAtCenter(FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	SdrViewEvent aVEvt;
//STRIP001 	SdrHitKind eHit = pSdrView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001 	// Nur neues Objekt, wenn nicht im Basismode (bzw reinem Selektionsmode)
//STRIP001 	if (rMEvt.IsLeft() && !pWin->IsDrawAction())
//STRIP001 	{
//STRIP001 		if (IsCreateObj() && (eHit == SDRHIT_UNMARKEDOBJECT || eHit == SDRHIT_NONE || pSh->IsDrawCreate()))
//STRIP001 		{
//STRIP001 			bNoInterrupt = TRUE;
//STRIP001 			pWin->CaptureMouse();
//STRIP001 
//STRIP001 			aStartPos = pWin->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 
//STRIP001 			bReturn = pSh->BeginCreate(pWin->GetDrawMode(), aStartPos);
//STRIP001 
//STRIP001 			SetDrawPointer();
//STRIP001 
//STRIP001 			if ( bReturn )
//STRIP001 				pWin->SetDrawAction(TRUE);
//STRIP001 		}
//STRIP001 		else if (!pSdrView->IsAction())
//STRIP001 		{
//STRIP001 			/**********************************************************************
//STRIP001 			* BEZIER-EDITOR
//STRIP001 			**********************************************************************/
//STRIP001 			pWin->CaptureMouse();
//STRIP001 			aStartPos = pWin->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 			UINT16 nEditMode = pWin->GetBezierMode();
//STRIP001 
//STRIP001 			if (eHit == SDRHIT_HANDLE && aVEvt.pHdl->GetKind() == HDL_BWGT)
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Handle draggen
//STRIP001 				******************************************************************/
//STRIP001 				bNoInterrupt = TRUE;
//STRIP001 				bReturn = pSdrView->BegDragObj(aStartPos, (OutputDevice*) NULL, aVEvt.pHdl);
//STRIP001 				pWin->SetDrawAction(TRUE);
//STRIP001 			}
//STRIP001 			else if (eHit == SDRHIT_MARKEDOBJECT && nEditMode == SID_BEZIER_INSERT)
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Klebepunkt einfuegen
//STRIP001 				******************************************************************/
//STRIP001 				bNoInterrupt = TRUE;
//STRIP001 				bReturn = pSdrView->BegInsObjPoint(aStartPos, rMEvt.IsMod1(), NULL, 0);
//STRIP001 				pWin->SetDrawAction(TRUE);
//STRIP001 			}
//STRIP001 			else if (eHit == SDRHIT_MARKEDOBJECT && rMEvt.IsMod1())
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Klebepunkt selektieren
//STRIP001 				******************************************************************/
//STRIP001 				if (!rMEvt.IsShift())
//STRIP001 					pSdrView->UnmarkAllPoints();
//STRIP001 
//STRIP001 				bReturn = pSdrView->BegMarkPoints(aStartPos, (OutputDevice*) NULL);
//STRIP001 				pWin->SetDrawAction(TRUE);
//STRIP001 			}
//STRIP001 			else if (eHit == SDRHIT_MARKEDOBJECT && !rMEvt.IsShift() && !rMEvt.IsMod2())
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Objekt verschieben
//STRIP001 				******************************************************************/
//STRIP001 				return FALSE;
//STRIP001 			}
//STRIP001 			else if (eHit == SDRHIT_HANDLE)
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Klebepunkt selektieren
//STRIP001 				******************************************************************/
//STRIP001 				if (pSdrView->HasMarkablePoints() && (!pSdrView->IsPointMarked(*aVEvt.pHdl) || rMEvt.IsShift()))
//STRIP001 				{
//STRIP001 					SdrHdl*	pHdl = NULL;
//STRIP001 
//STRIP001 					if (!rMEvt.IsShift())
//STRIP001 					{
//STRIP001 						pSdrView->UnmarkAllPoints();
//STRIP001 						pHdl = pSdrView->HitHandle(aStartPos, *pWin);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if (pSdrView->IsPointMarked(*aVEvt.pHdl))
//STRIP001 						{
//STRIP001 							bReturn = pSdrView->UnmarkPoint(*aVEvt.pHdl);
//STRIP001 							pHdl = NULL;
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							pHdl = pSdrView->HitHandle(aStartPos, *pWin);
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if (pHdl)
//STRIP001 					{
//STRIP001 						bNoInterrupt = TRUE;
//STRIP001 						pSdrView->MarkPoint(*pHdl);
//STRIP001 //			            bReturn = pSdrView->BegDragObj(aStartPos, (OutputDevice*) NULL, pHdl);
//STRIP001 //						pWin->SetDrawAction(TRUE);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				/******************************************************************
//STRIP001 				* Objekt selektieren oder draggen
//STRIP001 				******************************************************************/
//STRIP001 				if (pSh->IsObjSelectable(aStartPos) && eHit == SDRHIT_UNMARKEDOBJECT)
//STRIP001 				{
//STRIP001 					if (pSdrView->HasMarkablePoints())
//STRIP001 						pSdrView->UnmarkAllPoints();
//STRIP001 
//STRIP001 					bNoInterrupt = FALSE;
//STRIP001 					// Drag im edtwin verwenden
//STRIP001 					return FALSE;
//STRIP001 				}
//STRIP001 
//STRIP001 				bNoInterrupt = TRUE;
//STRIP001 
//STRIP001 				if (pSh->IsObjSelected())
//STRIP001 				{
//STRIP001 					if (!rMEvt.IsShift())
//STRIP001 					{
//STRIP001 						if (!pSdrView->HasMarkablePoints())
//STRIP001 						{
//STRIP001 							//JP 10.10.2001: Bug 89619 - don't scroll the
//STRIP001 							//				cursor into the visible area
//STRIP001 							BOOL bUnlockView = !pSh->IsViewLocked();
//STRIP001 							pSh->LockView( TRUE );	//lock visible section
//STRIP001 							pSh->SelectObj(Point(LONG_MAX, LONG_MAX));	// Alles deselektieren
//STRIP001 							if( bUnlockView )
//STRIP001 								pSh->LockView( FALSE );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							pSdrView->UnmarkAllPoints();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				BOOL bMarked = FALSE;
//STRIP001 
//STRIP001 				if (!pSh->IsSelFrmMode())
//STRIP001 					pSh->EnterSelFrmMode(NULL);
//STRIP001 
//STRIP001 				if( 0 != (bReturn = pSh->BeginMark(aStartPos)) )
//STRIP001 					pWin->SetDrawAction(TRUE);
//STRIP001 
//STRIP001 				SetDrawPointer();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bReturn;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseMove-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwDrawBase::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 	Point aPnt(pWin->PixelToLogic(rMEvt.GetPosPixel()));
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if (IsCreateObj() && !pWin->IsDrawSelMode() && pSdrView->IsCreateObj())
//STRIP001 	{
//STRIP001 		pSdrView->SetOrtho(rMEvt.IsShift());
//STRIP001 		pSdrView->SetAngleSnapEnabled(rMEvt.IsShift());
//STRIP001 
//STRIP001 		pSh->MoveCreate(aPnt);
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else if (pSdrView->IsAction() || pSdrView->IsInsObjPoint() || pSdrView->IsMarkPoints())
//STRIP001 	{
//STRIP001 		pSh->MoveMark(aPnt);
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bRet);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonUp-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwDrawBase::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 	BOOL bCheckShell = FALSE;
//STRIP001 	BOOL bAutoCap = FALSE;
//STRIP001 
//STRIP001 	Point aPnt(pWin->PixelToLogic(rMEvt.GetPosPixel()));
//STRIP001 
//STRIP001 	if (IsCreateObj() && pSh->IsDrawCreate() && !pWin->IsDrawSelMode())
//STRIP001 	{
//STRIP001         const USHORT nDrawMode = pWin->GetDrawMode();
//STRIP001 		//objects with multiple point may end at the start position
//STRIP001 		BOOL bMultiPoint = OBJ_PLIN == nDrawMode ||
//STRIP001                                 OBJ_PATHLINE == nDrawMode ||
//STRIP001 								OBJ_FREELINE == nDrawMode;
//STRIP001         if(rMEvt.IsRight() || (aPnt == aStartPos && !bMultiPoint))
//STRIP001 		{
//STRIP001 			pSh->BreakCreate();
//STRIP001 			pView->LeaveDrawCreate();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             if (OBJ_NONE == nDrawMode)
//STRIP001 				pSh->StartUndo(UNDO_INSERT);
//STRIP001 
//STRIP001 			pSh->EndCreate(SDRCREATE_FORCEEND);
//STRIP001             if (OBJ_NONE == nDrawMode)   // Textrahmen eingefuegt
//STRIP001 			{
//STRIP001                ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                     pSh->GetView().GetViewFrame()->GetBindings().GetRecorder();
//STRIP001                 if ( xRecorder.is() )
//STRIP001                 {
//STRIP001                     SfxRequest aReq(pSh->GetView().GetViewFrame(),FN_INSERT_FRAME);
//STRIP001                         aReq.AppendItem(SfxUInt16Item( FN_INSERT_FRAME, (USHORT)FLY_AT_CNTNT ));
//STRIP001 						aReq.AppendItem(SfxPointItem( FN_PARAM_1, pSh->GetAnchorObjDiff()));
//STRIP001 						aReq.AppendItem(SvxSizeItem( FN_PARAM_2, pSh->GetObjSize()));
//STRIP001 					aReq.Done();
//STRIP001 				}
//STRIP001                 bAutoCap = TRUE;
//STRIP001 				if(pWin->GetFrmColCount() > 1)
//STRIP001 				{
//STRIP001 					SfxItemSet aSet(pView->GetPool(),RES_COL,RES_COL);
//STRIP001 					SwFmtCol aCol((const SwFmtCol&)aSet.Get(RES_COL));
//STRIP001 					aCol.Init(pWin->GetFrmColCount(), aCol.GetGutterWidth(), aCol.GetWishWidth());
//STRIP001 					aSet.Put(aCol);
//STRIP001 					// Vorlagen-AutoUpdate
//STRIP001 					SwFrmFmt* pFmt = pSh->GetCurFrmFmt();
//STRIP001 					if(pFmt && pFmt->IsAutoUpdateFmt())
//STRIP001 						pSh->AutoUpdateFrame(pFmt, aSet);
//STRIP001 					else
//STRIP001 						pSh->SetFlyFrmAttr( aSet );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (pWin->GetDrawMode() == OBJ_NONE)
//STRIP001 				pSh->EndUndo(UNDO_INSERT);
//STRIP001 		}
//STRIP001 
//STRIP001 		bReturn = TRUE;
//STRIP001 
//STRIP001 		EnterSelectMode(rMEvt);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 
//STRIP001 		if (!pSdrView->HasMarkablePoints())
//STRIP001 		{
//STRIP001 			/**********************************************************************
//STRIP001 			* KEIN BEZIER_EDITOR
//STRIP001 			**********************************************************************/
//STRIP001 			if ((pSh->GetDrawView()->IsMarkObj() || pSh->GetDrawView()->IsMarkPoints())
//STRIP001 				 && rMEvt.IsLeft())
//STRIP001 			{
//STRIP001 				bReturn = pSh->EndMark();
//STRIP001 
//STRIP001 				pWin->SetDrawAction(FALSE);
//STRIP001 
//STRIP001 				if (aPnt == aStartPos && pSh->IsObjSelectable(aPnt))
//STRIP001 				{
//STRIP001                     pSh->SelectObj(aPnt, ( rMEvt.IsShift() &&
//STRIP001                                    pSh->IsSelFrmMode()) ? SW_ADD_SELECT : 0);
//STRIP001 
//STRIP001 					if (!pSh->IsObjSelected())
//STRIP001 					{
//STRIP001 						pView->LeaveDrawCreate();	// In Selektionsmode wechseln
//STRIP001 
//STRIP001 						pSh->GetView().GetViewFrame()->GetBindings().Invalidate(SID_INSERT_DRAW);
//STRIP001 
//STRIP001 						if (pSh->IsSelFrmMode())
//STRIP001 							pSh->LeaveSelFrmMode();
//STRIP001 					}
//STRIP001 					pView->NoRotate();
//STRIP001 
//STRIP001 					bCheckShell = TRUE;	// ggf BezierShell anwerfen
//STRIP001 				}
//STRIP001 				else if (!pSh->IsObjSelected() && !pWin->IsDrawAction())
//STRIP001 				{
//STRIP001 					if (pSh->IsObjSelectable(aPnt))
//STRIP001                         pSh->SelectObj(aPnt, ( rMEvt.IsShift() &&
//STRIP001                             pSh->IsSelFrmMode() ) ? SW_ADD_SELECT : 0 );
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pView->LeaveDrawCreate();
//STRIP001 						if (pSh->IsSelFrmMode())
//STRIP001 							pSh->LeaveSelFrmMode();
//STRIP001 					}
//STRIP001 					pView->NoRotate();
//STRIP001 
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			/**********************************************************************
//STRIP001 			* BEZIER_EDITOR
//STRIP001 			**********************************************************************/
//STRIP001 			if ( pSdrView->IsAction() )
//STRIP001 			{
//STRIP001 				if ( pSdrView->IsInsObjPoint() )
//STRIP001 					bReturn = pSdrView->EndInsObjPoint(SDRCREATE_FORCEEND);
//STRIP001 				else if (pSdrView->IsMarkPoints() )
//STRIP001 					bReturn = pSdrView->EndMarkPoints();
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pSdrView->EndAction();
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 				pWin->SetDrawAction(FALSE);
//STRIP001 
//STRIP001 				if (aPnt == aStartPos)
//STRIP001 				{
//STRIP001 					if (!pSh->IsObjSelectable(aPnt))
//STRIP001 						pSh->SelectObj(Point(LONG_MAX, LONG_MAX));
//STRIP001 					else if (!bReturn)
//STRIP001 					{
//STRIP001 						if (!rMEvt.IsShift())
//STRIP001 							pSdrView->UnmarkAllPoints();
//STRIP001                         pSh->SelectObj(aPnt, (rMEvt.IsShift() &&
//STRIP001                                        pSh->IsSelFrmMode()) ? SW_ADD_SELECT :0);
//STRIP001 					}
//STRIP001 
//STRIP001 					if (!pSh->IsObjSelected())
//STRIP001 					{
//STRIP001 						pView->LeaveDrawCreate();	// In Selektionsmode wechseln
//STRIP001 
//STRIP001 						pSh->GetView().GetViewFrame()->GetBindings().Invalidate(SID_INSERT_DRAW);
//STRIP001 
//STRIP001 						if (pSh->IsSelFrmMode())
//STRIP001 							pSh->LeaveSelFrmMode();
//STRIP001 					}
//STRIP001 					pView->NoRotate();
//STRIP001 
//STRIP001 					bCheckShell = TRUE;	// ggf BezierShell anwerfen
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			SetDrawPointer();
//STRIP001 
//STRIP001 			if (!pSh->IsObjSelected() && !pWin->IsDrawAction())
//STRIP001 			{
//STRIP001 				pView->LeaveDrawCreate();
//STRIP001 				if (pSh->IsSelFrmMode())
//STRIP001 					pSh->LeaveSelFrmMode();
//STRIP001 
//STRIP001 				pView->NoRotate();
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bCheckShell)
//STRIP001 		pView->AttrChangedNotify( pSh );	// ggf BezierShell anwerfen
//STRIP001 
//STRIP001 	//!!!!!!!!!! Achtung Suizid !!!!!!!!!!! Sollte alles mal erneuert werden
//STRIP001 	if ( bAutoCap )
//STRIP001 		pView->AutoCaption(FRAME_CAP);	//Kann derzeit nur FRAME sein, sonst auf
//STRIP001 										//enums umstellen
//STRIP001 	return (bReturn);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function aktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwDrawBase::Activate(const USHORT nSlot)
//STRIP001 {
//STRIP001     SetSlotId(nSlot);
//STRIP001     SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 
//STRIP001 	pSdrView->SetCurrentObj(pWin->GetDrawMode());
//STRIP001 	pSdrView->SetEditMode(FALSE);
//STRIP001 
//STRIP001 	SetDrawPointer();
//STRIP001 	pSh->NoEdit();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function deaktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void __EXPORT SwDrawBase::Deactivate()
//STRIP001 {
//STRIP001 	SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 	pSdrView->SetOrtho(FALSE);
//STRIP001 	pSdrView->SetAngleSnapEnabled(FALSE);
//STRIP001 
//STRIP001 	if (pWin->IsDrawAction() && pSh->IsDrawCreate())
//STRIP001 		pSh->BreakCreate();
//STRIP001 
//STRIP001 	pWin->SetDrawAction(FALSE);
//STRIP001 
//STRIP001 	pWin->ReleaseMouse();
//STRIP001 	bNoInterrupt = FALSE;
//STRIP001 
//STRIP001 //	if(!pSh->IsObjSelected())
//STRIP001 //		pSh->Edit();
//STRIP001 
//STRIP001 	if(pWin->GetApplyTemplate())
//STRIP001 		pWin->SetApplyTemplate(SwApplyTemplate());
//STRIP001 	pSh->GetView().GetViewFrame()->GetBindings().Invalidate(SID_INSERT_DRAW);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Tastaturereignisse bearbeiten
//STRIP001 |*
//STRIP001 |* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
//STRIP001 |* FALSE.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwDrawBase::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 	USHORT nCode = rKEvt.GetKeyCode().GetCode();
//STRIP001 
//STRIP001 	switch (nCode)
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			if (pWin->IsDrawAction())
//STRIP001 			{
//STRIP001 				BreakCreate();
//STRIP001 				pView->LeaveDrawCreate();
//STRIP001 			}
//STRIP001 
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_DELETE:
//STRIP001 		{
//STRIP001 			pSh->DelSelectedObj();
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_UP:
//STRIP001 		case KEY_DOWN:
//STRIP001 		case KEY_LEFT:
//STRIP001 		case KEY_RIGHT:
//STRIP001 		{
//STRIP001 			SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 
//STRIP001 			if (!pSdrView->IsTextEdit())
//STRIP001 			{
//STRIP001 				long nX = 0;
//STRIP001 				long nY = 0;
//STRIP001 
//STRIP001 				if (nCode == KEY_UP)
//STRIP001 				{
//STRIP001 					// Scroll nach oben
//STRIP001 					nX = 0;
//STRIP001 					nY =-1;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_DOWN)
//STRIP001 				{
//STRIP001 					// Scroll nach unten
//STRIP001 					nX = 0;
//STRIP001 					nY = 1;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_LEFT)
//STRIP001 				{
//STRIP001 					// Scroll nach links
//STRIP001 					nX =-1;
//STRIP001 					nY = 0;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_RIGHT)
//STRIP001 				{
//STRIP001 					// Scroll nach rechts
//STRIP001 					nX = 1;
//STRIP001 					nY = 0;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (pSdrView->HasMarkedObj() && rKEvt.GetKeyCode().IsMod2())
//STRIP001 				{
//STRIP001 					// Objekte verschieben
//STRIP001 					nX *= 100;
//STRIP001 					nY *= 100;
//STRIP001 					pSdrView->MoveAllMarked(Size(nX, nY));
//STRIP001 				}
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Tastaturereignisse bearbeiten
//STRIP001 |*
//STRIP001 |* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
//STRIP001 |* FALSE.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwDrawBase::BreakCreate()
//STRIP001 {
//STRIP001 	pSh->BreakCreate();
//STRIP001 	pWin->SetDrawAction(FALSE);
//STRIP001 	pWin->ReleaseMouse();
//STRIP001 
//STRIP001 	Deactivate();
//STRIP001 //	pView->LeaveDrawCreate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Mauspointer umschalten
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwDrawBase::SetDrawPointer()
//STRIP001 {
//STRIP001 	SdrView *pSdrView = pSh->GetDrawView();
//STRIP001 		Point aPnt(pWin->OutputToScreenPixel(pWin->GetPointerPosPixel()));
//STRIP001 	aPnt = pWin->PixelToLogic(pWin->ScreenToOutputPixel(aPnt));
//STRIP001 	const Pointer aPointTyp = pSdrView->GetPreferedPointer(aPnt, pSh->GetOut());
//STRIP001 	const Pointer aDrawPt(aPointTyp);
//STRIP001 	pWin->SetPointer(aDrawPt);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ggf in Selektionsmode wechseln
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SwDrawBase::EnterSelectMode(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	pWin->SetDrawAction(FALSE);
//STRIP001 
//STRIP001 	if (!pSh->IsObjSelected() && !pWin->IsDrawAction())
//STRIP001 	{
//STRIP001 		Point aPnt(pWin->PixelToLogic(rMEvt.GetPosPixel()));
//STRIP001 
//STRIP001 		if (pSh->IsObjSelectable(aPnt))
//STRIP001 		{
//STRIP001 			pSh->SelectObj(aPnt);
//STRIP001 			if (rMEvt.GetModifier() == KEY_SHIFT || !pSh->IsObjSelected())
//STRIP001 			{
//STRIP001 				pView->LeaveDrawCreate();	// In Selektionsmode wechseln
//STRIP001 
//STRIP001 				pSh->GetView().GetViewFrame()->GetBindings().Invalidate(SID_INSERT_DRAW);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pView->LeaveDrawCreate();
//STRIP001 			if (pSh->IsSelFrmMode())
//STRIP001 				pSh->LeaveSelFrmMode();
//STRIP001 		}
//STRIP001 		pView->NoRotate();
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------03.04.2002 10:52------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwDrawBase::CreateDefaultObject()
//STRIP001 {
//STRIP001     Point aStartPos = GetDefaultCenterPos();
//STRIP001     Point aEndPos(aStartPos);
//STRIP001     aStartPos.X() -= 8 * MM50;
//STRIP001     aStartPos.Y() -= 4 * MM50;
//STRIP001     aEndPos.X() += 8 * MM50;
//STRIP001     aEndPos.Y() += 4 * MM50;
//STRIP001     Rectangle aRect(aStartPos, aEndPos);
//STRIP001     pSh->CreateDefaultShape(pWin->GetDrawMode(), aRect, nSlotId);
//STRIP001 }
//STRIP001 /* -----------------25.10.2002 14:14-----------------
//STRIP001  * 
//STRIP001  * --------------------------------------------------*/
//STRIP001 Point  SwDrawBase::GetDefaultCenterPos()
//STRIP001 {
//STRIP001     Size aDocSz(pSh->GetDocSize());
//STRIP001     const SwRect& rVisArea = pSh->VisArea();
//STRIP001     Point aStartPos = rVisArea.Center();
//STRIP001     if(rVisArea.Width() > aDocSz.Width())
//STRIP001         aStartPos.X() = aDocSz.Width() / 2 + rVisArea.Left();
//STRIP001     if(rVisArea.Height() > aDocSz.Height())
//STRIP001         aStartPos.Y() = aDocSz.Height() / 2 + rVisArea.Top();
//STRIP001     return aStartPos;
//STRIP001 }        

}
