// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2015 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
// USA

#include "video_capture_device_factory_override.h"

#include <utility>

namespace media {

namespace {
VideoCaptureDeviceFactoryOverrideFactory* g_factory;
}

std::unique_ptr<VideoCaptureDeviceFactory>
CreateOverrideVideoCaptureDeviceFactory(
    std::unique_ptr<VideoCaptureDeviceFactory> factory) {
  if (!g_factory) {
    return std::move(factory);
  }

  return g_factory(std::move(factory));
}

void SetVideoCaptureDeviceFactoryOverrideFactory(
    VideoCaptureDeviceFactoryOverrideFactory* factory) {
  g_factory = factory;
}

} // namespace media
