# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
    # These files lists are shared with the GN build.
    'ash_sources': [
      'accelerators/accelerator_commands.cc',
      'accelerators/accelerator_commands.h',
      'accelerators/accelerator_controller.cc',
      'accelerators/accelerator_controller.h',
      'accelerators/accelerator_delegate.cc',
      'accelerators/accelerator_delegate.h',
      'accelerators/accelerator_table.cc',
      'accelerators/accelerator_table.h',
      'accelerators/debug_commands.cc',
      'accelerators/debug_commands.h',
      'accelerators/exit_warning_handler.cc',
      'accelerators/exit_warning_handler.h',
      'accelerators/focus_manager_factory.cc',
      'accelerators/focus_manager_factory.h',
      'accelerators/key_hold_detector.cc',
      'accelerators/key_hold_detector.h',
      'accelerators/magnifier_key_scroller.cc',
      'accelerators/magnifier_key_scroller.h',
      'accelerators/spoken_feedback_toggler.cc',
      'accelerators/spoken_feedback_toggler.h',
      'app_list/app_list_presenter_delegate.cc',
      'app_list/app_list_presenter_delegate.h',
      'app_list/app_list_presenter_delegate_factory.cc',
      'app_list/app_list_presenter_delegate_factory.h',
      'ash_export.h',
      'ash_touch_exploration_manager_chromeos.cc',
      'ash_touch_exploration_manager_chromeos.h',
      'audio/sounds.cc',
      'audio/sounds.h',
      'aura/aura_layout_manager_adapter.cc',
      'aura/aura_layout_manager_adapter.h',
      'aura/wm_lookup_aura.cc',
      'aura/wm_lookup_aura.h',
      'aura/wm_root_window_controller_aura.cc',
      'aura/wm_root_window_controller_aura.h',
      'aura/wm_shelf_aura.cc',
      'aura/wm_shelf_aura.h',
      'aura/wm_shell_aura.cc',
      'aura/wm_shell_aura.h',
      'aura/wm_window_aura.cc',
      'aura/wm_window_aura.h',
      'autoclick/autoclick_controller.cc',
      'autoclick/autoclick_controller.h',
      'cancel_mode.cc',
      'cancel_mode.h',
      'common/accessibility_delegate.h',
      'common/accessibility_types.h',
      'common/ash_constants.cc',
      'common/ash_constants.h',
      'common/ash_layout_constants.cc',
      'common/ash_layout_constants.h',
      'common/ash_switches.cc',
      'common/ash_switches.h',
      'common/cast_config_delegate.cc',
      'common/cast_config_delegate.h',
      'common/default_accessibility_delegate.cc',
      'common/default_accessibility_delegate.h',
      'common/display/display_info.cc',
      'common/display/display_info.h',
      'common/focus_cycler.cc',
      'common/focus_cycler.h',
      'common/keyboard/keyboard_ui.cc',
      'common/keyboard/keyboard_ui.h',
      'common/keyboard/keyboard_ui_observer.h',
      'common/login_status.h',
      'common/material_design/material_design_controller.cc',
      'common/material_design/material_design_controller.h',
      'common/metrics/user_metrics_action.h',
      'common/root_window_controller_common.cc',
      'common/root_window_controller_common.h',
      'common/session/session_state_delegate.cc',
      'common/session/session_state_delegate.h',
      'common/session/session_state_observer.cc',
      'common/session/session_state_observer.h',
      'common/session/session_types.h',
      'common/shelf/shelf_alignment_menu.cc',
      'common/shelf/shelf_alignment_menu.h',
      'common/shelf/shelf_constants.cc',
      'common/shelf/shelf_constants.h',
      'common/shelf/shelf_item_delegate.h',
      'common/shelf/shelf_item_delegate_manager.cc',
      'common/shelf/shelf_item_delegate_manager.h',
      'common/shelf/shelf_item_types.cc',
      'common/shelf/shelf_item_types.h',
      'common/shelf/shelf_menu_model.h',
      'common/shelf/shelf_model.cc',
      'common/shelf/shelf_model.h',
      'common/shelf/shelf_model_observer.h',
      'common/shelf/shelf_types.h',
      'common/shelf/wm_shelf.h',
      'common/shelf/wm_shelf_observer.h',
      'common/shelf/wm_shelf_util.cc',
      'common/shelf/wm_shelf_util.h',
      'common/shell_window_ids.cc',
      'common/shell_window_ids.h',
      'common/system/accessibility_observer.h',
      'common/system/audio/audio_observer.h',
      'common/system/audio/tray_audio.cc',
      'common/system/audio/tray_audio.h',
      'common/system/audio/tray_audio_delegate.h',
      'common/system/audio/volume_view.cc',
      'common/system/audio/volume_view.h',
      'common/system/cast/tray_cast.cc',
      'common/system/cast/tray_cast.h',
      'common/system/chromeos/audio/audio_detailed_view.cc',
      'common/system/chromeos/audio/audio_detailed_view.h',
      'common/system/chromeos/audio/tray_audio_chromeos.cc',
      'common/system/chromeos/audio/tray_audio_chromeos.h',
      'common/system/chromeos/audio/tray_audio_delegate_chromeos.cc',
      'common/system/chromeos/audio/tray_audio_delegate_chromeos.h',
      'common/system/chromeos/bluetooth/bluetooth_observer.h',
      'common/system/chromeos/devicetype_utils.cc',
      'common/system/chromeos/devicetype_utils.h',
      'common/system/chromeos/enterprise/enterprise_domain_observer.h',
      'common/system/chromeos/media_security/media_capture_observer.h',
      'common/system/chromeos/network/network_detailed_view.h',
      'common/system/chromeos/network/network_observer.h',
      'common/system/chromeos/network/network_portal_detector_observer.h',
      'common/system/chromeos/network/network_state_list_detailed_view.cc',
      'common/system/chromeos/network/network_state_list_detailed_view.h',
      'common/system/chromeos/network/tray_network.cc',
      'common/system/chromeos/network/tray_network.h',
      'common/system/chromeos/network/tray_network_state_observer.cc',
      'common/system/chromeos/network/tray_network_state_observer.h',
      'common/system/chromeos/network/tray_sms.cc',
      'common/system/chromeos/network/tray_sms.h',
      'common/system/chromeos/network/tray_vpn.cc',
      'common/system/chromeos/network/tray_vpn.h',
      'common/system/chromeos/network/vpn_delegate.cc',
      'common/system/chromeos/network/vpn_delegate.h',
      'common/system/chromeos/network/vpn_list_view.cc',
      'common/system/chromeos/network/vpn_list_view.h',
      'common/system/chromeos/power/battery_notification.cc',
      'common/system/chromeos/power/battery_notification.h',
      'common/system/chromeos/power/dual_role_notification.cc',
      'common/system/chromeos/power/dual_role_notification.h',
      'common/system/chromeos/power/power_status.cc',
      'common/system/chromeos/power/power_status.h',
      'common/system/chromeos/power/power_status_view.cc',
      'common/system/chromeos/power/power_status_view.h',
      'common/system/chromeos/power/tray_power.cc',
      'common/system/chromeos/power/tray_power.h',
      'common/system/chromeos/screen_security/screen_capture_observer.h',
      'common/system/chromeos/screen_security/screen_capture_tray_item.cc',
      'common/system/chromeos/screen_security/screen_capture_tray_item.h',
      'common/system/chromeos/screen_security/screen_share_observer.h',
      'common/system/chromeos/screen_security/screen_share_tray_item.cc',
      'common/system/chromeos/screen_security/screen_share_tray_item.h',
      'common/system/chromeos/screen_security/screen_tray_item.cc',
      'common/system/chromeos/screen_security/screen_tray_item.h',
      'common/system/chromeos/session/last_window_closed_observer.h',
      'common/system/chromeos/session/logout_button_observer.h',
      'common/system/chromeos/session/logout_button_tray.cc',
      'common/system/chromeos/session/logout_button_tray.h',
      'common/system/chromeos/session/logout_confirmation_controller.cc',
      'common/system/chromeos/session/logout_confirmation_controller.h',
      'common/system/chromeos/session/logout_confirmation_dialog.cc',
      'common/system/chromeos/session/logout_confirmation_dialog.h',
      'common/system/chromeos/session/session_length_limit_observer.h',
      'common/system/chromeos/session/tray_session_length_limit.cc',
      'common/system/chromeos/session/tray_session_length_limit.h',
      'common/system/chromeos/settings/tray_settings.cc',
      'common/system/chromeos/settings/tray_settings.h',
      'common/system/chromeos/shutdown_policy_observer.h',
      'common/system/chromeos/system_clock_observer.cc',
      'common/system/chromeos/system_clock_observer.h',
      'common/system/chromeos/tray_tracing.cc',
      'common/system/chromeos/tray_tracing.h',
      'common/system/chromeos/virtual_keyboard/virtual_keyboard_observer.h',
      'common/system/chromeos/virtual_keyboard/virtual_keyboard_tray.cc',
      'common/system/chromeos/virtual_keyboard/virtual_keyboard_tray.h',
      'common/system/date/clock_observer.h',
      'common/system/date/date_default_view.cc',
      'common/system/date/date_default_view.h',
      'common/system/date/date_view.cc',
      'common/system/date/date_view.h',
      'common/system/date/tray_date.cc',
      'common/system/date/tray_date.h',
      'common/system/ime/ime_observer.h',
      'common/system/ime/tray_ime_chromeos.cc',
      'common/system/ime/tray_ime_chromeos.h',
      'common/system/locale/locale_notification_controller.cc',
      'common/system/locale/locale_notification_controller.h',
      'common/system/locale/locale_observer.h',
      'common/system/networking_config_delegate.cc',
      'common/system/networking_config_delegate.h',
      'common/system/status_area_widget_delegate.cc',
      'common/system/status_area_widget_delegate.h',
      'common/system/system_notifier.cc',
      'common/system/system_notifier.h',
      'common/system/tray/actionable_view.cc',
      'common/system/tray/actionable_view.h',
      'common/system/tray/default_system_tray_delegate.cc',
      'common/system/tray/default_system_tray_delegate.h',
      'common/system/tray/fixed_sized_image_view.cc',
      'common/system/tray/fixed_sized_image_view.h',
      'common/system/tray/fixed_sized_scroll_view.cc',
      'common/system/tray/fixed_sized_scroll_view.h',
      'common/system/tray/hover_highlight_view.cc',
      'common/system/tray/hover_highlight_view.h',
      'common/system/tray/label_tray_view.cc',
      'common/system/tray/label_tray_view.h',
      'common/system/tray/special_popup_row.cc',
      'common/system/tray/special_popup_row.h',
      'common/system/tray/system_tray_bubble.cc',
      'common/system/tray/system_tray_bubble.h',
      'common/system/tray/system_tray_delegate.cc',
      'common/system/tray/system_tray_delegate.h',
      'common/system/tray/system_tray_item.cc',
      'common/system/tray/system_tray_item.h',
      'common/system/tray/system_tray_notifier.cc',
      'common/system/tray/system_tray_notifier.h',
      'common/system/tray/throbber_view.cc',
      'common/system/tray/throbber_view.h',
      'common/system/tray/tray_background_view.cc',
      'common/system/tray/tray_background_view.h',
      'common/system/tray/tray_bar_button_with_title.cc',
      'common/system/tray/tray_bar_button_with_title.h',
      'common/system/tray/tray_bubble_wrapper.cc',
      'common/system/tray/tray_bubble_wrapper.h',
      'common/system/tray/tray_constants.cc',
      'common/system/tray/tray_constants.h',
      'common/system/tray/tray_details_view.cc',
      'common/system/tray/tray_details_view.h',
      'common/system/tray/tray_event_filter.cc',
      'common/system/tray/tray_event_filter.h',
      'common/system/tray/tray_image_item.cc',
      'common/system/tray/tray_image_item.h',
      'common/system/tray/tray_item_more.cc',
      'common/system/tray/tray_item_more.h',
      'common/system/tray/tray_item_view.cc',
      'common/system/tray/tray_item_view.h',
      'common/system/tray/tray_notification_view.cc',
      'common/system/tray/tray_notification_view.h',
      'common/system/tray/tray_popup_header_button.cc',
      'common/system/tray/tray_popup_header_button.h',
      'common/system/tray/tray_popup_item_container.cc',
      'common/system/tray/tray_popup_item_container.h',
      'common/system/tray/tray_popup_label_button.cc',
      'common/system/tray/tray_popup_label_button.h',
      'common/system/tray/tray_popup_label_button_border.cc',
      'common/system/tray/tray_popup_label_button_border.h',
      'common/system/tray/tray_utils.cc',
      'common/system/tray/tray_utils.h',
      'common/system/tray/view_click_listener.h',
      'common/system/tray_accessibility.cc',
      'common/system/tray_accessibility.h',
      'common/system/update/tray_update.cc',
      'common/system/update/tray_update.h',
      'common/system/update/update_observer.h',
      'common/system/user/button_from_view.cc',
      'common/system/user/button_from_view.h',
      'common/system/user/login_status.cc',
      'common/system/user/login_status.h',
      'common/system/user/rounded_image_view.cc',
      'common/system/user/rounded_image_view.h',
      'common/system/user/tray_user_separator.cc',
      'common/system/user/tray_user_separator.h',
      'common/system/user/user_observer.h',
      'common/system/volume_control_delegate.h',
      'common/system/web_notification/ash_popup_alignment_delegate.cc',
      'common/system/web_notification/ash_popup_alignment_delegate.h',
      'common/system/web_notification/web_notification_tray.cc',
      'common/system/web_notification/web_notification_tray.h',
      'common/wm/always_on_top_controller.cc',
      'common/wm/always_on_top_controller.h',
      'common/wm/background_animator.cc',
      'common/wm/background_animator.h',
      'common/wm/container_finder.cc',
      'common/wm/container_finder.h',
      'common/wm/default_state.cc',
      'common/wm/default_state.h',
      'common/wm/default_window_resizer.cc',
      'common/wm/default_window_resizer.h',
      'common/wm/dock/docked_window_layout_manager.cc',
      'common/wm/dock/docked_window_layout_manager.h',
      'common/wm/dock/docked_window_layout_manager_observer.h',
      'common/wm/dock/docked_window_resizer.cc',
      'common/wm/dock/docked_window_resizer.h',
      'common/wm/drag_details.cc',
      'common/wm/drag_details.h',
      'common/wm/focus_rules.cc',
      'common/wm/focus_rules.h',
      'common/wm/fullscreen_window_finder.cc',
      'common/wm/fullscreen_window_finder.h',
      'common/wm/maximize_mode/maximize_mode_event_handler.cc',
      'common/wm/maximize_mode/maximize_mode_event_handler.h',
      'common/wm/maximize_mode/maximize_mode_window_manager.cc',
      'common/wm/maximize_mode/maximize_mode_window_manager.h',
      'common/wm/maximize_mode/maximize_mode_window_state.cc',
      'common/wm/maximize_mode/maximize_mode_window_state.h',
      'common/wm/maximize_mode/workspace_backdrop_delegate.cc',
      'common/wm/maximize_mode/workspace_backdrop_delegate.h',
      'common/wm/mru_window_tracker.cc',
      'common/wm/mru_window_tracker.h',
      'common/wm/overview/cleanup_animation_observer.cc',
      'common/wm/overview/cleanup_animation_observer.h',
      'common/wm/overview/overview_animation_type.h',
      'common/wm/overview/scoped_overview_animation_settings.h',
      'common/wm/overview/scoped_overview_animation_settings_factory.cc',
      'common/wm/overview/scoped_overview_animation_settings_factory.h',
      'common/wm/overview/scoped_transform_overview_window.cc',
      'common/wm/overview/scoped_transform_overview_window.h',
      'common/wm/overview/window_grid.cc',
      'common/wm/overview/window_grid.h',
      'common/wm/overview/window_selector.cc',
      'common/wm/overview/window_selector.h',
      'common/wm/overview/window_selector_controller.cc',
      'common/wm/overview/window_selector_controller.h',
      'common/wm/overview/window_selector_item.cc',
      'common/wm/overview/window_selector_item.h',
      'common/wm/panels/panel_layout_manager.cc',
      'common/wm/panels/panel_layout_manager.h',
      'common/wm/panels/panel_window_resizer.cc',
      'common/wm/panels/panel_window_resizer.h',
      'common/wm/root_window_finder.cc',
      'common/wm/root_window_finder.h',
      'common/wm/root_window_layout_manager.cc',
      'common/wm/root_window_layout_manager.h',
      'common/wm/switchable_windows.cc',
      'common/wm/switchable_windows.h',
      'common/wm/window_animation_types.h',
      'common/wm/window_parenting_utils.cc',
      'common/wm/window_parenting_utils.h',
      'common/wm/window_positioner.cc',
      'common/wm/window_positioner.h',
      'common/wm/window_positioning_utils.cc',
      'common/wm/window_positioning_utils.h',
      'common/wm/window_resizer.cc',
      'common/wm/window_resizer.h',
      'common/wm/window_state.cc',
      'common/wm/window_state.h',
      'common/wm/window_state_delegate.cc',
      'common/wm/window_state_delegate.h',
      'common/wm/window_state_observer.h',
      'common/wm/window_state_util.cc',
      'common/wm/window_state_util.h',
      'common/wm/wm_event.cc',
      'common/wm/wm_event.h',
      'common/wm/wm_screen_util.cc',
      'common/wm/wm_screen_util.h',
      'common/wm/wm_snap_to_pixel_layout_manager.cc',
      'common/wm/wm_snap_to_pixel_layout_manager.h',
      'common/wm/wm_toplevel_window_event_handler.cc',
      'common/wm/wm_toplevel_window_event_handler.h',
      'common/wm/wm_types.cc',
      'common/wm/wm_types.h',
      'common/wm/workspace/magnetism_matcher.cc',
      'common/wm/workspace/magnetism_matcher.h',
      'common/wm/workspace/multi_window_resize_controller.cc',
      'common/wm/workspace/multi_window_resize_controller.h',
      'common/wm/workspace/phantom_window_controller.cc',
      'common/wm/workspace/phantom_window_controller.h',
      'common/wm/workspace/two_step_edge_cycler.cc',
      'common/wm/workspace/two_step_edge_cycler.h',
      'common/wm/workspace/workspace_layout_manager.cc',
      'common/wm/workspace/workspace_layout_manager.h',
      'common/wm/workspace/workspace_layout_manager_backdrop_delegate.h',
      'common/wm/workspace/workspace_layout_manager_delegate.h',
      'common/wm/workspace/workspace_types.h',
      'common/wm/workspace/workspace_window_resizer.cc',
      'common/wm/workspace/workspace_window_resizer.h',
      'common/wm_activation_observer.h',
      'common/wm_display_observer.h',
      'common/wm_layout_manager.h',
      'common/wm_lookup.cc',
      'common/wm_lookup.h',
      'common/wm_root_window_controller.h',
      'common/wm_root_window_controller_observer.h',
      'common/wm_shell.cc',
      'common/wm_shell.h',
      'common/wm_window.h',
      'common/wm_window_observer.h',
      'common/wm_window_property.h',
      'common/wm_window_tracker.h',
      'debug.cc',
      'debug.h',
      'default_user_wallpaper_delegate.cc',
      'default_user_wallpaper_delegate.h',
      'desktop_background/desktop_background_controller.cc',
      'desktop_background/desktop_background_controller.h',
      'desktop_background/desktop_background_controller_observer.h',
      'desktop_background/desktop_background_view.cc',
      'desktop_background/desktop_background_view.h',
      'desktop_background/desktop_background_widget_controller.cc',
      'desktop_background/desktop_background_widget_controller.h',
      'desktop_background/user_wallpaper_delegate.h',
      'display/cursor_window_controller.cc',
      'display/cursor_window_controller.h',
      'display/display_animator.h',
      'display/display_animator_chromeos.cc',
      'display/display_animator_chromeos.h',
      'display/display_change_observer_chromeos.cc',
      'display/display_change_observer_chromeos.h',
      'display/display_color_manager_chromeos.cc',
      'display/display_color_manager_chromeos.h',
      'display/display_configuration_controller.cc',
      'display/display_configuration_controller.h',
      'display/display_error_observer_chromeos.cc',
      'display/display_error_observer_chromeos.h',
      'display/display_layout_store.cc',
      'display/display_layout_store.h',
      'display/display_manager.cc',
      'display/display_manager.h',
      'display/display_pref_util.h',
      'display/display_util.cc',
      'display/display_util.h',
      'display/event_transformation_handler.cc',
      'display/event_transformation_handler.h',
      'display/extended_mouse_warp_controller.cc',
      'display/extended_mouse_warp_controller.h',
      'display/json_converter.cc',
      'display/json_converter.h',
      'display/mirror_window_controller.cc',
      'display/mirror_window_controller.h',
      'display/mouse_cursor_event_filter.cc',
      'display/mouse_cursor_event_filter.h',
      'display/mouse_warp_controller.h',
      'display/null_mouse_warp_controller.cc',
      'display/null_mouse_warp_controller.h',
      'display/projecting_observer_chromeos.cc',
      'display/projecting_observer_chromeos.h',
      'display/resolution_notification_controller.cc',
      'display/resolution_notification_controller.h',
      'display/root_window_transformers.cc',
      'display/root_window_transformers.h',
      'display/screen_ash.cc',
      'display/screen_ash.h',
      'display/screen_orientation_controller_chromeos.cc',
      'display/screen_orientation_controller_chromeos.h',
      'display/screen_position_controller.cc',
      'display/screen_position_controller.h',
      'display/shared_display_edge_indicator.cc',
      'display/shared_display_edge_indicator.h',
      'display/unified_mouse_warp_controller.cc',
      'display/unified_mouse_warp_controller.h',
      'display/window_tree_host_manager.cc',
      'display/window_tree_host_manager.h',
      'drag_drop/drag_drop_controller.cc',
      'drag_drop/drag_drop_controller.h',
      'drag_drop/drag_drop_tracker.cc',
      'drag_drop/drag_drop_tracker.h',
      'drag_drop/drag_image_view.cc',
      'drag_drop/drag_image_view.h',
      'first_run/desktop_cleaner.cc',
      'first_run/desktop_cleaner.h',
      'first_run/first_run_helper.cc',
      'first_run/first_run_helper.h',
      'first_run/first_run_helper_impl.cc',
      'first_run/first_run_helper_impl.h',
      'frame/caption_buttons/caption_button_types.h',
      'frame/caption_buttons/frame_caption_button.cc',
      'frame/caption_buttons/frame_caption_button.h',
      'frame/caption_buttons/frame_caption_button_container_view.cc',
      'frame/caption_buttons/frame_caption_button_container_view.h',
      'frame/caption_buttons/frame_size_button.cc',
      'frame/caption_buttons/frame_size_button.h',
      'frame/caption_buttons/frame_size_button_delegate.h',
      'frame/custom_frame_view_ash.cc',
      'frame/custom_frame_view_ash.h',
      'frame/default_header_painter.cc',
      'frame/default_header_painter.h',
      'frame/frame_border_hit_test_controller.cc',
      'frame/frame_border_hit_test_controller.h',
      'frame/header_painter.h',
      'frame/header_painter_util.cc',
      'frame/header_painter_util.h',
      'gpu_support.h',
      'gpu_support_stub.cc',
      'gpu_support_stub.h',
      'high_contrast/high_contrast_controller.cc',
      'high_contrast/high_contrast_controller.h',
      'host/ash_window_tree_host.cc',
      'host/ash_window_tree_host.h',
      'host/ash_window_tree_host_init_params.cc',
      'host/ash_window_tree_host_init_params.h',
      'host/ash_window_tree_host_platform.cc',
      'host/ash_window_tree_host_platform.h',
      'host/ash_window_tree_host_unified.cc',
      'host/ash_window_tree_host_unified.h',
      'host/ash_window_tree_host_win.cc',
      'host/ash_window_tree_host_win.h',
      'host/ash_window_tree_host_x11.cc',
      'host/ash_window_tree_host_x11.h',
      'host/root_window_transformer.h',
      'host/transformer_helper.cc',
      'host/transformer_helper.h',
      'ime/input_method_event_handler.cc',
      'ime/input_method_event_handler.h',
      'keyboard_uma_event_filter.cc',
      'keyboard_uma_event_filter.h',
      'link_handler_model.cc',
      'link_handler_model.h',
      'link_handler_model_factory.cc',
      'link_handler_model_factory.h',
      'magnifier/magnification_controller.cc',
      'magnifier/magnification_controller.h',
      'magnifier/partial_magnification_controller.cc',
      'magnifier/partial_magnification_controller.h',
      'metrics/desktop_task_switch_metric_recorder.cc',
      'metrics/desktop_task_switch_metric_recorder.h',
      'metrics/task_switch_metrics_recorder.cc',
      'metrics/task_switch_metrics_recorder.h',
      'metrics/task_switch_time_tracker.cc',
      'metrics/task_switch_time_tracker.h',
      'metrics/user_metrics_recorder.cc',
      'metrics/user_metrics_recorder.h',
      'multi_profile_uma.cc',
      'multi_profile_uma.h',
      'pointer_watcher_delegate.h',
      'pointer_watcher_delegate_aura.cc',
      'pointer_watcher_delegate_aura.h',
      'popup_message.cc',
      'popup_message.h',
      'root_window_controller.cc',
      'root_window_controller.h',
      'root_window_settings.cc',
      'root_window_settings.h',
      'rotator/screen_rotation_animation.cc',
      'rotator/screen_rotation_animation.h',
      'rotator/screen_rotation_animator.cc',
      'rotator/screen_rotation_animator.h',
      'rotator/window_rotation.cc',
      'rotator/window_rotation.h',
      'scoped_target_root_window.cc',
      'scoped_target_root_window.h',
      'screen_util.cc',
      'screen_util.h',
      'screenshot_delegate.h',
      'shelf/app_list_button.cc',
      'shelf/app_list_button.h',
      'shelf/app_list_shelf_item_delegate.cc',
      'shelf/app_list_shelf_item_delegate.h',
      'shelf/ink_drop_button_listener.h',
      'shelf/overflow_bubble.cc',
      'shelf/overflow_bubble.h',
      'shelf/overflow_bubble_view.cc',
      'shelf/overflow_bubble_view.h',
      'shelf/overflow_button.cc',
      'shelf/overflow_button.h',
      'shelf/scoped_observer_with_duplicated_sources.h',
      'shelf/shelf.cc',
      'shelf/shelf.h',
      'shelf/shelf_bezel_event_filter.cc',
      'shelf/shelf_bezel_event_filter.h',
      'shelf/shelf_button.cc',
      'shelf/shelf_button.h',
      'shelf/shelf_button_pressed_metric_tracker.cc',
      'shelf/shelf_button_pressed_metric_tracker.h',
      'shelf/shelf_delegate.h',
      'shelf/shelf_icon_observer.h',
      'shelf/shelf_layout_manager.cc',
      'shelf/shelf_layout_manager.h',
      'shelf/shelf_layout_manager_observer.h',
      'shelf/shelf_locking_manager.cc',
      'shelf/shelf_locking_manager.h',
      'shelf/shelf_navigator.cc',
      'shelf/shelf_navigator.h',
      'shelf/shelf_tooltip_manager.cc',
      'shelf/shelf_tooltip_manager.h',
      'shelf/shelf_util.cc',
      'shelf/shelf_util.h',
      'shelf/shelf_view.cc',
      'shelf/shelf_view.h',
      'shelf/shelf_widget.cc',
      'shelf/shelf_widget.h',
      'shelf/shelf_window_watcher.cc',
      'shelf/shelf_window_watcher.h',
      'shelf/shelf_window_watcher_item_delegate.cc',
      'shelf/shelf_window_watcher_item_delegate.h',
      'shell.cc',
      'shell.h',
      'shell_delegate.h',
      'shell_factory.h',
      'shell_init_params.cc',
      'shell_init_params.h',
      'snap_to_pixel_layout_manager.cc',
      'snap_to_pixel_layout_manager.h',
      'sticky_keys/sticky_keys_controller.cc',
      'sticky_keys/sticky_keys_controller.h',
      'sticky_keys/sticky_keys_overlay.cc',
      'sticky_keys/sticky_keys_overlay.h',
      'sticky_keys/sticky_keys_state.h',
      'system/brightness_control_delegate.h',
      'system/chromeos/bluetooth/bluetooth_notification_controller.cc',
      'system/chromeos/bluetooth/bluetooth_notification_controller.h',
      'system/chromeos/bluetooth/tray_bluetooth.cc',
      'system/chromeos/bluetooth/tray_bluetooth.h',
      'system/chromeos/brightness/brightness_controller_chromeos.cc',
      'system/chromeos/brightness/brightness_controller_chromeos.h',
      'system/chromeos/brightness/tray_brightness.cc',
      'system/chromeos/brightness/tray_brightness.h',
      'system/chromeos/enterprise/tray_enterprise.cc',
      'system/chromeos/enterprise/tray_enterprise.h',
      'system/chromeos/keyboard_brightness_controller.cc',
      'system/chromeos/keyboard_brightness_controller.h',
      'system/chromeos/media_security/multi_profile_media_tray_item.cc',
      'system/chromeos/media_security/multi_profile_media_tray_item.h',
      'system/chromeos/multi_user/user_switch_util.cc',
      'system/chromeos/multi_user/user_switch_util.h',
      'system/chromeos/power/power_event_observer.cc',
      'system/chromeos/power/power_event_observer.h',
      'system/chromeos/power/video_activity_notifier.cc',
      'system/chromeos/power/video_activity_notifier.h',
      'system/chromeos/rotation/tray_rotation_lock.cc',
      'system/chromeos/rotation/tray_rotation_lock.h',
      'system/chromeos/supervised/custodian_info_tray_observer.h',
      'system/chromeos/supervised/tray_supervised_user.cc',
      'system/chromeos/supervised/tray_supervised_user.h',
      'system/chromeos/tray_caps_lock.cc',
      'system/chromeos/tray_caps_lock.h',
      'system/chromeos/tray_display.cc',
      'system/chromeos/tray_display.h',
      'system/keyboard_brightness/keyboard_brightness_control_delegate.h',
      'system/overview/overview_button_tray.cc',
      'system/overview/overview_button_tray.h',
      'system/status_area_widget.cc',
      'system/status_area_widget.h',
      'system/toast/toast_data.cc',
      'system/toast/toast_data.h',
      'system/toast/toast_manager.cc',
      'system/toast/toast_manager.h',
      'system/toast/toast_overlay.cc',
      'system/toast/toast_overlay.h',
      'system/tray/system_tray.cc',
      'system/tray/system_tray.h',
      'system/user/tray_user.cc',
      'system/user/tray_user.h',
      'system/user/user_card_view.cc',
      'system/user/user_card_view.h',
      'system/user/user_view.cc',
      'system/user/user_view.h',
      'touch/touch_hud_debug.cc',
      'touch/touch_hud_debug.h',
      'touch/touch_hud_projection.cc',
      'touch/touch_hud_projection.h',
      'touch/touch_observer_hud.cc',
      'touch/touch_observer_hud.h',
      'touch/touch_transformer_controller.cc',
      'touch/touch_transformer_controller.h',
      'touch/touch_uma.cc',
      'touch/touch_uma.h',
      'touch/touchscreen_util.cc',
      'touch/touchscreen_util.h',
      'utility/screenshot_controller.cc',
      'utility/screenshot_controller.h',
      'virtual_keyboard_controller.cc',
      'virtual_keyboard_controller.h',
      'wm/ash_focus_rules.cc',
      'wm/ash_focus_rules.h',
      'wm/ash_native_cursor_manager.cc',
      'wm/ash_native_cursor_manager.h',
      'wm/boot_splash_screen_chromeos.cc',
      'wm/boot_splash_screen_chromeos.h',
      'wm/cursor_manager_chromeos.cc',
      'wm/cursor_manager_chromeos.h',
      'wm/dim_window.cc',
      'wm/dim_window.h',
      'wm/drag_window_controller.cc',
      'wm/drag_window_controller.h',
      'wm/drag_window_resizer.cc',
      'wm/drag_window_resizer.h',
      'wm/event_client_impl.cc',
      'wm/event_client_impl.h',
      'wm/gestures/overview_gesture_handler.cc',
      'wm/gestures/overview_gesture_handler.h',
      'wm/gestures/shelf_gesture_handler.cc',
      'wm/gestures/shelf_gesture_handler.h',
      'wm/immersive_fullscreen_controller.cc',
      'wm/immersive_fullscreen_controller.h',
      'wm/immersive_revealed_lock.cc',
      'wm/immersive_revealed_lock.h',
      'wm/lock_layout_manager.cc',
      'wm/lock_layout_manager.h',
      'wm/lock_state_controller.cc',
      'wm/lock_state_controller.h',
      'wm/lock_state_observer.h',
      'wm/lock_window_state.cc',
      'wm/lock_window_state.h',
      'wm/maximize_mode/maximize_mode_controller.cc',
      'wm/maximize_mode/maximize_mode_controller.h',
      'wm/maximize_mode/maximize_mode_event_handler_aura.cc',
      'wm/maximize_mode/maximize_mode_event_handler_aura.h',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard.h',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_ozone.cc',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_ozone.h',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_x11.cc',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_x11.h',
      'wm/overlay_event_filter.cc',
      'wm/overlay_event_filter.h',
      'wm/overview/scoped_overview_animation_settings_aura.cc',
      'wm/overview/scoped_overview_animation_settings_aura.h',
      'wm/overview/scoped_overview_animation_settings_factory_aura.cc',
      'wm/overview/scoped_overview_animation_settings_factory_aura.h',
      'wm/panels/attached_panel_window_targeter.cc',
      'wm/panels/attached_panel_window_targeter.h',
      'wm/panels/panel_frame_view.cc',
      'wm/panels/panel_frame_view.h',
      'wm/panels/panel_window_event_handler.cc',
      'wm/panels/panel_window_event_handler.h',
      'wm/power_button_controller.cc',
      'wm/power_button_controller.h',
      'wm/resize_handle_window_targeter.cc',
      'wm/resize_handle_window_targeter.h',
      'wm/resize_shadow.cc',
      'wm/resize_shadow.h',
      'wm/resize_shadow_controller.cc',
      'wm/resize_shadow_controller.h',
      'wm/screen_dimmer.cc',
      'wm/screen_dimmer.h',
      'wm/screen_pinning_controller.cc',
      'wm/screen_pinning_controller.h',
      'wm/session_state_animator.cc',
      'wm/session_state_animator.h',
      'wm/session_state_animator_impl.cc',
      'wm/session_state_animator_impl.h',
      'wm/stacking_controller.cc',
      'wm/stacking_controller.h',
      'wm/status_area_layout_manager.cc',
      'wm/status_area_layout_manager.h',
      'wm/system_background_controller.cc',
      'wm/system_background_controller.h',
      'wm/system_gesture_event_filter.cc',
      'wm/system_gesture_event_filter.h',
      'wm/system_modal_container_event_filter.cc',
      'wm/system_modal_container_event_filter.h',
      'wm/system_modal_container_event_filter_delegate.h',
      'wm/system_modal_container_layout_manager.cc',
      'wm/system_modal_container_layout_manager.h',
      'wm/toplevel_window_event_handler.cc',
      'wm/toplevel_window_event_handler.h',
      'wm/video_detector.cc',
      'wm/video_detector.h',
      'wm/window_animations.cc',
      'wm/window_animations.h',
      'wm/window_cycle_controller.cc',
      'wm/window_cycle_controller.h',
      'wm/window_cycle_list.cc',
      'wm/window_cycle_list.h',
      'wm/window_properties.cc',
      'wm/window_properties.h',
      'wm/window_state_aura.cc',
      'wm/window_state_aura.h',
      'wm/window_util.cc',
      'wm/window_util.h',
      'wm/workspace/workspace_event_handler.cc',
      'wm/workspace/workspace_event_handler.h',
      'wm/workspace_controller.cc',
      'wm/workspace_controller.h',
    ],
    'ash_with_content_sources': [
      'content/ash_with_content_export.h',
      'content/gpu_support_impl.cc',
      'content/gpu_support_impl.h',
      'content/keyboard_overlay/keyboard_overlay_delegate.cc',
      'content/keyboard_overlay/keyboard_overlay_delegate.h',
      'content/keyboard_overlay/keyboard_overlay_view.cc',
      'content/keyboard_overlay/keyboard_overlay_view.h',
      'content/screen_orientation_delegate_chromeos.cc',
      'content/screen_orientation_delegate_chromeos.h',
      'content/shell_content_state.cc',
      'content/shell_content_state.h',
    ],
    'ash_test_support_sources': [
      'desktop_background/desktop_background_controller_test_api.cc',
      'desktop_background/desktop_background_controller_test_api.h',
      'shell/toplevel_window.cc',
      'shell/toplevel_window.h',
      'test/ash_md_test_base.cc',
      'test/ash_md_test_base.h',
      'test/ash_test_base.cc',
      'test/ash_test_base.h',
      'test/ash_test_helper.cc',
      'test/ash_test_helper.h',
      'test/ash_test_views_delegate.cc',
      'test/ash_test_views_delegate.h',
      'test/child_modal_window.cc',
      'test/child_modal_window.h',
      'test/cursor_manager_test_api.cc',
      'test/cursor_manager_test_api.h',
      'test/display_manager_test_api.cc',
      'test/display_manager_test_api.h',
      'test/material_design_controller_test_api.cc',
      'test/material_design_controller_test_api.h',
      'test/mirror_window_test_api.cc',
      'test/mirror_window_test_api.h',
      'test/overflow_bubble_view_test_api.cc',
      'test/overflow_bubble_view_test_api.h',
      'test/shelf_button_pressed_metric_tracker_test_api.cc',
      'test/shelf_button_pressed_metric_tracker_test_api.h',
      'test/shelf_item_delegate_manager_test_api.cc',
      'test/shelf_item_delegate_manager_test_api.h',
      'test/shelf_test_api.h',
      'test/shelf_view_test_api.cc',
      'test/shelf_view_test_api.h',
      'test/shell_test_api.cc',
      'test/shell_test_api.h',
      'test/status_area_widget_test_helper.cc',
      'test/status_area_widget_test_helper.h',
      'test/task_switch_time_tracker_test_api.cc',
      'test/task_switch_time_tracker_test_api.h',
      'test/test_activation_delegate.cc',
      'test/test_activation_delegate.h',
      'test/test_keyboard_ui.cc',
      'test/test_keyboard_ui.h',
      'test/test_lock_state_controller_delegate.cc',
      'test/test_lock_state_controller_delegate.h',
      'test/test_overlay_delegate.cc',
      'test/test_overlay_delegate.h',
      'test/test_screenshot_delegate.cc',
      'test/test_screenshot_delegate.h',
      'test/test_session_state_animator.cc',
      'test/test_session_state_animator.h',
      'test/test_session_state_delegate.cc',
      'test/test_session_state_delegate.h',
      'test/test_shelf_delegate.cc',
      'test/test_shelf_delegate.h',
      'test/test_shelf_item_delegate.cc',
      'test/test_shelf_item_delegate.h',
      'test/test_shell_delegate.cc',
      'test/test_shell_delegate.h',
      'test/test_suite.cc',
      'test/test_suite.h',
      'test/test_suite_init.h',
      'test/test_suite_init.mm',
      'test/test_system_tray_delegate.cc',
      'test/test_system_tray_delegate.h',
      'test/test_system_tray_item.cc',
      'test/test_system_tray_item.h',
      'test/test_user_wallpaper_delegate.cc',
      'test/test_user_wallpaper_delegate.h',
      'test/test_volume_control_delegate.cc',
      'test/test_volume_control_delegate.h',
      'test/tray_cast_test_api.cc',
      'test/tray_cast_test_api.h',
      'test/ui_controls_factory_ash.cc',
      'test/ui_controls_factory_ash.h',
      'test/user_metrics_recorder_test_api.cc',
      'test/user_metrics_recorder_test_api.h',
      'test/virtual_keyboard_test_helper.cc',
      'test/virtual_keyboard_test_helper.h',
    ],
    'ash_test_support_with_content_sources': [
      'test/content/test_shell_content_state.cc',
      'test/content/test_shell_content_state.h',
    ],
    'ash_shell_lib_sources': [
      '../ui/views/test/test_views_delegate_aura.cc',
      'shell/app_list.cc',
      'shell/bubble.cc',
      'shell/context_menu.cc',
      'shell/context_menu.h',
      'shell/example_factory.h',
      'shell/lock_view.cc',
      'shell/panel_window.cc',
      'shell/panel_window.h',
      'shell/shelf_delegate_impl.cc',
      'shell/shelf_delegate_impl.h',
      'shell/shell_delegate_impl.cc',
      'shell/shell_delegate_impl.h',
      'shell/toplevel_window.cc',
      'shell/toplevel_window.h',
      'shell/widgets.cc',
      'shell/window_type_launcher.cc',
      'shell/window_type_launcher.h',
      'shell/window_watcher.cc',
      'shell/window_watcher.h',
      'shell/window_watcher_shelf_item_delegate.cc',
      'shell/window_watcher_shelf_item_delegate.h',
    ],
    'ash_shell_with_content_lib_sources': [
      'shell/content/client/shell_browser_main_parts.cc',
      'shell/content/client/shell_browser_main_parts.h',
      'shell/content/client/shell_content_browser_client.cc',
      'shell/content/client/shell_content_browser_client.h',
      'shell/content/client/shell_main_delegate.cc',
      'shell/content/client/shell_main_delegate.h',
      'shell/content/shell_content_state_impl.cc',
      'shell/content/shell_content_state_impl.h',
    ],
    'ash_unittests_sources': [
      'accelerators/accelerator_commands_unittest.cc',
      'accelerators/accelerator_controller_unittest.cc',
      'accelerators/accelerator_filter_unittest.cc',
      'accelerators/accelerator_table_unittest.cc',
      'accelerators/magnifier_key_scroller_unittest.cc',
      'accelerators/spoken_feedback_toggler_unittest.cc',
      'app_list/app_list_presenter_delegate_unittest.cc',
      'ash_touch_exploration_manager_chromeos_unittest.cc',
      'autoclick/autoclick_unittest.cc',
      'common/display/display_info_unittest.cc',
      'common/material_design/material_design_controller_unittest.cc',
      'common/shelf/shelf_model_unittest.cc',
      'common/system/chromeos/power/power_status_unittest.cc',
      'common/system/chromeos/power/power_status_view_unittest.cc',
      'common/system/chromeos/power/tray_power_unittest.cc',
      'common/system/chromeos/screen_security/screen_tray_item_unittest.cc',
      'common/system/chromeos/session/logout_confirmation_controller_unittest.cc',
      'common/system/chromeos/session/tray_session_length_limit_unittest.cc',
      'common/system/date/date_view_unittest.cc',
      'common/system/ime/tray_ime_chromeos_unittest.cc',
      'common/system/tray/tray_details_view_unittest.cc',
      'common/system/update/tray_update_unittest.cc',
      'common/wm/overview/cleanup_animation_observer_unittest.cc',
      'content/display/screen_orientation_controller_chromeos_unittest.cc',
      'content/keyboard_overlay/keyboard_overlay_delegate_unittest.cc',
      'content/keyboard_overlay/keyboard_overlay_view_unittest.cc',
      'desktop_background/desktop_background_controller_unittest.cc',
      'dip_unittest.cc',
      'display/cursor_window_controller_unittest.cc',
      'display/display_change_observer_chromeos_unittest.cc',
      'display/display_color_manager_chromeos_unittest.cc',
      'display/display_error_observer_chromeos_unittest.cc',
      'display/display_manager_unittest.cc',
      'display/display_util_unittest.cc',
      'display/extended_mouse_warp_controller_unittest.cc',
      'display/json_converter_unittest.cc',
      'display/mirror_window_controller_unittest.cc',
      'display/mouse_cursor_event_filter_unittest.cc',
      'display/projecting_observer_chromeos_unittest.cc',
      'display/resolution_notification_controller_unittest.cc',
      'display/root_window_transformers_unittest.cc',
      'display/screen_ash_unittest.cc',
      'display/screen_position_controller_unittest.cc',
      'display/unified_mouse_warp_controller_unittest.cc',
      'display/window_tree_host_manager_unittest.cc',
      'drag_drop/drag_drop_controller_unittest.cc',
      'drag_drop/drag_drop_tracker_unittest.cc',
      'extended_desktop_unittest.cc',
      'focus_cycler_unittest.cc',
      'frame/caption_buttons/frame_caption_button_container_view_unittest.cc',
      'frame/caption_buttons/frame_size_button_unittest.cc',
      'frame/custom_frame_view_ash_unittest.cc',
      'frame/default_header_painter_unittest.cc',
      'host/ash_window_tree_host_x11_unittest.cc',
      'magnifier/magnification_controller_unittest.cc',
      'metrics/desktop_task_switch_metric_recorder_unittest.cc',
      'metrics/task_switch_metrics_recorder_unittest.cc',
      'metrics/task_switch_time_tracker_unittest.cc',
      'metrics/user_metrics_recorder_unittest.cc',
      'popup_message_unittest.cc',
      'root_window_controller_unittest.cc',
      'rotator/screen_rotation_animation_unittest.cc',
      'screen_util_unittest.cc',
      'shelf/scoped_observer_with_duplicated_sources_unittest.cc',
      'shelf/shelf_button_pressed_metric_tracker_unittest.cc',
      'shelf/shelf_layout_manager_unittest.cc',
      'shelf/shelf_locking_manager_unittest.cc',
      'shelf/shelf_navigator_unittest.cc',
      'shelf/shelf_tooltip_manager_unittest.cc',
      'shelf/shelf_unittest.cc',
      'shelf/shelf_view_unittest.cc',
      'shelf/shelf_widget_unittest.cc',
      'shelf/shelf_window_watcher_unittest.cc',
      'shell_unittest.cc',
      'sticky_keys/sticky_keys_overlay_unittest.cc',
      'sticky_keys/sticky_keys_unittest.cc',
      'system/chromeos/brightness/tray_brightness_unittest.cc',
      'system/chromeos/media_security/multi_profile_media_tray_item_unittest.cc',
      'system/chromeos/multi_user/user_switch_util_unittest.cc',
      'system/chromeos/power/power_event_observer_unittest.cc',
      'system/chromeos/rotation/tray_rotation_lock_unittest.cc',
      'system/chromeos/supervised/tray_supervised_user_unittest.cc',
      'system/chromeos/tray_display_unittest.cc',
      'system/overview/overview_button_tray_unittest.cc',
      'system/toast/toast_manager_unittest.cc',
      'system/tray/system_tray_unittest.cc',
      'system/user/tray_user_unittest.cc',
      'system/web_notification/ash_popup_alignment_delegate_unittest.cc',
      'system/web_notification/web_notification_tray_unittest.cc',
      'test/ash_test_helper_unittest.cc',
      'test/ash_unittests.cc',
      'tooltips/tooltip_controller_unittest.cc',
      'touch/touch_observer_hud_unittest.cc',
      'touch/touch_transformer_controller_unittest.cc',
      'touch/touchscreen_util_unittest.cc',
      'utility/screenshot_controller_unittest.cc',
      'virtual_keyboard_controller_unittest.cc',
      'wm/always_on_top_controller_unittest.cc',
      'wm/ash_focus_rules_unittest.cc',
      'wm/ash_native_cursor_manager_unittest.cc',
      'wm/dock/docked_window_layout_manager_unittest.cc',
      'wm/dock/docked_window_resizer_unittest.cc',
      'wm/drag_window_resizer_unittest.cc',
      'wm/gestures/overview_gesture_handler_unittest.cc',
      'wm/immersive_fullscreen_controller_unittest.cc',
      'wm/lock_layout_manager_unittest.cc',
      'wm/lock_state_controller_unittest.cc',
      'wm/maximize_mode/accelerometer_test_data_literals.cc',
      'wm/maximize_mode/maximize_mode_controller_unittest.cc',
      'wm/maximize_mode/maximize_mode_window_manager_unittest.cc',
      'wm/mru_window_tracker_unittest.cc',
      'wm/overlay_event_filter_unittest.cc',
      'wm/overview/window_selector_unittest.cc',
      'wm/panels/panel_layout_manager_unittest.cc',
      'wm/panels/panel_window_resizer_unittest.cc',
      'wm/resize_shadow_and_cursor_unittest.cc',
      'wm/root_window_layout_manager_unittest.cc',
      'wm/screen_dimmer_unittest.cc',
      'wm/screen_pinning_controller_unittest.cc',
      'wm/session_state_animator_impl_unittest.cc',
      'wm/stacking_controller_unittest.cc',
      'wm/system_gesture_event_filter_unittest.cc',
      'wm/system_modal_container_layout_manager_unittest.cc',
      'wm/toplevel_window_event_handler_unittest.cc',
      'wm/video_detector_unittest.cc',
      'wm/window_animations_unittest.cc',
      'wm/window_cycle_controller_unittest.cc',
      'wm/window_manager_unittest.cc',
      'wm/window_modality_controller_unittest.cc',
      'wm/window_positioner_unittest.cc',
      'wm/window_state_unittest.cc',
      'wm/window_util_unittest.cc',
      'wm/workspace/magnetism_matcher_unittest.cc',
      'wm/workspace/multi_window_resize_controller_unittest.cc',
      'wm/workspace/workspace_event_handler_test_helper.cc',
      'wm/workspace/workspace_event_handler_test_helper.h',
      'wm/workspace/workspace_event_handler_unittest.cc',
      'wm/workspace/workspace_layout_manager_unittest.cc',
      'wm/workspace/workspace_window_resizer_unittest.cc',
      'wm/workspace_controller_test_helper.cc',
      'wm/workspace_controller_test_helper.h',
      'wm/workspace_controller_unittest.cc',
    ],
  },
  'targets': [
    {
      # GN version: //ash
      'target_name': 'ash',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../cc/cc.gyp:cc',
        '../components/components.gyp:device_event_log_component',
        '../components/components.gyp:onc_component',
        '../components/components.gyp:signin_core_account_id',
        '../components/components.gyp:user_manager',
        '../components/components.gyp:wallpaper',
        '../media/media.gyp:media',
        '../net/net.gyp:net',
        '../skia/skia.gyp:skia',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/accessibility/accessibility.gyp:accessibility',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/app_list/presenter/app_list_presenter.gyp:app_list_presenter',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/base/ui_base.gyp:ui_data_pack',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/display/display.gyp:display',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/events/events.gyp:events',
        '../ui/events/events.gyp:events_base',
        '../ui/events/events.gyp:gesture_detection',
        '../ui/events/platform/events_platform.gyp:events_platform',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/gfx/gfx.gyp:gfx_range',
        '../ui/gfx/gfx.gyp:gfx_vector_icons',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/native_theme/native_theme.gyp:native_theme',
        '../ui/platform_window/stub/stub_window.gyp:stub_window',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../ui/views/views.gyp:views',
        '../ui/wm/wm.gyp:wm',
        '../url/url.gyp:url_lib',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
      ],
      'defines': [
        'ASH_IMPLEMENTATION',
      ],
      'sources': [
        '<@(ash_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'sources!': [
            # Note: sources list duplicated in GN build.
            "sticky_keys/sticky_keys_controller.cc",
            "sticky_keys/sticky_keys_controller.h",
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [ 4267, ],
        }],
        ['use_x11==1', {
          'dependencies': [
            '../build/linux/system.gyp:x11',
            '../build/linux/system.gyp:xfixes',
            '../ui/base/x/ui_base_x.gyp:ui_base_x',
            '../ui/events/devices/x11/events_devices_x11.gyp:events_devices_x11',
            '../ui/gfx/x/gfx_x11.gyp:gfx_x11',
           ],
        }],
        ['use_ozone==1', {
          'dependencies': [
            '../ui/events/ozone/events_ozone.gyp:events_ozone',
            '../ui/ozone/ozone.gyp:ozone',
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos',
            # Ash #includes power_supply_properties.pb.h directly.
            '../chromeos/chromeos.gyp:power_manager_proto',
            '../components/components.gyp:quirks',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../third_party/qcms/qcms.gyp:qcms',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_strings',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos',
            '../ui/display/display.gyp:display_util',
          ],
        }, { # else: chromeos!=1
          'sources!': [
            'accelerators/key_hold_detector.cc',
            'accelerators/key_hold_detector.h',
            'accelerators/magnifier_key_scroller.cc',
            'accelerators/magnifier_key_scroller.h',
            'accelerators/spoken_feedback_toggler.cc',
            'accelerators/spoken_feedback_toggler.h',
            'display/resolution_notification_controller.cc',
            'display/resolution_notification_controller.h',
            'touch/touch_transformer_controller.cc',
            'touch/touch_transformer_controller.h',
            'touch/touchscreen_util.cc',
            'touch/touchscreen_util.h',
            'virtual_keyboard_controller.cc',
            'virtual_keyboard_controller.h'
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_with_content
      'target_name': 'ash_with_content',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../content/content.gyp:content_browser',
        '../ipc/ipc.gyp:ipc',
        '../skia/skia.gyp:skia',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/display/display.gyp:display',
        '../ui/events/events.gyp:events',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard_with_content',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/views/views.gyp:views',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
        '../url/url.gyp:url_lib',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
      ],
      'defines': [
        'ASH_WITH_CONTENT_IMPLEMENTATION',
      ],
      'sources': [
        '<@(ash_with_content_sources)',
      ],
    },
    {
      # GN version: //ash:test_support
      'target_name': 'ash_test_support',
      'type': 'static_library',
      'dependencies': [
        '../skia/skia.gyp:skia',
        '../testing/gtest.gyp:gtest',
        '../ui/accessibility/accessibility.gyp:ax_gen',
        '../ui/app_list/app_list.gyp:app_list_test_support',
        '../ui/app_list/presenter/app_list_presenter.gyp:app_list_presenter',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/views/views.gyp:views_test_support',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_test_support_with_content',
      ],
      'sources': [
        '<@(ash_test_support_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'dependencies': [
            '../ui/platform_window/win/win_window.gyp:win_window',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:test_support_with_content
      'target_name': 'ash_test_support_with_content',
      'type': 'static_library',
      'dependencies': [
        '../skia/skia.gyp:skia',
        'ash_with_content',
      ],
      'sources': [
        '<@(ash_test_support_with_content_sources)',
      ],
    },
    {
      # GN version: //ash:interactive_ui_test_support
      'target_name': 'ash_interactive_ui_test_support',
      'type': 'static_library',
      'dependencies': [
        '../skia/skia.gyp:skia',
        '../testing/gtest.gyp:gtest',
        'ash',
        'ash_test_support',
      ],
      'sources': [
        'test/ash_interactive_ui_test_base.cc',
        'test/ash_interactive_ui_test_base.h',
      ],
    },
    {
      # GN version: //ash:ash_unittests
      'target_name': 'ash_unittests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../chrome/chrome_resources.gyp:packed_resources',
        '../components/components.gyp:signin_core_account_id',
        '../components/components.gyp:user_manager',
        '../content/content.gyp:content_browser',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../skia/skia.gyp:skia',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/accessibility/accessibility.gyp:accessibility',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/app_list/presenter/app_list_presenter.gyp:app_list_presenter',
        '../ui/aura/aura.gyp:aura',
        '../ui/aura/aura.gyp:aura_test_support',
        '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/base/ui_base.gyp:ui_base_test_support',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/compositor/compositor.gyp:compositor_test_support',
        '../ui/display/display.gyp:display',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/events/events.gyp:events',
        '../ui/events/events.gyp:events_test_support',
        '../ui/events/events.gyp:gesture_detection',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/keyboard/keyboard.gyp:keyboard_with_content',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/message_center/message_center.gyp:message_center_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/views/controls/webview/webview_tests.gyp:webview_test_support',
        '../ui/views/views.gyp:views',
        '../ui/views/views.gyp:views_test_support',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs_test_support',
        '../ui/wm/wm.gyp:wm',
        '../ui/wm/wm.gyp:wm_test_support',
        '../url/url.gyp:url_lib',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_resources.gyp:ash_test_resources_100_percent',
        'ash_resources.gyp:ash_test_resources_200_percent',
        'ash_strings.gyp:ash_strings',
        'ash_strings.gyp:ash_test_strings',
        'ash_test_support',
        'ash_with_content',
      ],
      'sources': [
        '<@(ash_unittests_sources)',
      ],
      'conditions': [
        ['chromeos==0', {
          'sources!': [
            # TODO(zork): fix this test to build on Windows. See: crosbug.com/26906
            'focus_cycler_unittest.cc',

            # All tests for multiple displays: not supported on Windows Ash.
            'wm/drag_window_resizer_unittest.cc',

            # Can't resize on Windows Ash. http://crbug.com/165962
            'autoclick/autoclick_unittest.cc',
            'magnifier/magnification_controller_unittest.cc',
            'sticky_keys/sticky_keys_overlay_unittest.cc',
            'sticky_keys/sticky_keys_unittest.cc',
            'system/chromeos/rotation/tray_rotation_lock_unittest.cc',
            'virtual_keyboard_controller_unittest.cc',
            'wm/maximize_mode/maximize_mode_controller_unittest.cc',
            'wm/workspace/workspace_window_resizer_unittest.cc',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/ui/resources/ui_unscaled_resources.rc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [ 4267, ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos_test_support_without_gmock',
            '../chromeos/chromeos.gyp:power_manager_proto',
            '../components/components.gyp:quirks',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../ui/display/display.gyp:display_test_support',
            '../ui/display/display.gyp:display_test_util',
            '../ui/display/display.gyp:display_types',
          ],
          'sources': [
            'first_run/first_run_helper_unittest.cc',
          ],
        }, { # else: chromeos!=1
          'sources!': [
            'accelerators/magnifier_key_scroller_unittest.cc',
            'accelerators/spoken_feedback_toggler_unittest.cc',
            'display/resolution_notification_controller_unittest.cc',
            'touch/touch_transformer_controller_unittest.cc',
            'touch/touchscreen_util_unittest.cc',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_shell_lib
      'target_name': 'ash_shell_lib',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../chrome/chrome_resources.gyp:packed_resources',
        '../skia/skia.gyp:skia',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/app_list/presenter/app_list_presenter.gyp:app_list_presenter',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/events/events.gyp:events',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/keyboard/keyboard.gyp:keyboard_with_content',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/views/examples/examples.gyp:views_examples_lib',
        '../ui/views/examples/examples.gyp:views_examples_with_content_lib',
        '../ui/views/views.gyp:views',
        '../ui/views/views.gyp:views_test_support',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
        'ash_test_support',
        'ash_with_content',
      ],
      'sources': [
        '<@(ash_shell_lib_sources)',
      ],
    },
    {
      # GN version: //ash:ash_shell_lib_with_content
      'target_name': 'ash_shell_lib_with_content',
      'type': 'static_library',
      'dependencies': [
        'ash_shell_lib',
        '../content/content_shell_and_tests.gyp:content_shell_lib',
        '../content/content.gyp:content',
        '../skia/skia.gyp:skia',
      ],
      'sources': [
        '<@(ash_shell_with_content_lib_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'dependencies': [
            '../content/content.gyp:sandbox_helper_win',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_shell_with_content
      'target_name': 'ash_shell_with_content',
      'type': 'executable',
      'dependencies': [
        'ash_shell_lib_with_content',
        '../components/components.gyp:user_manager',
      ],
      'sources': [
        'shell/content/shell_with_content_main.cc',
      ],
      'conditions': [
        ['OS=="win"', {
          'msvs_settings': {
            'VCLinkerTool': {
              'SubSystem': '2',  # Set /SUBSYSTEM:WINDOWS
            },
          },
          'dependencies': [
            '../sandbox/sandbox.gyp:sandbox',
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'ash_unittests_run',
          'type': 'none',
          'dependencies': [
            'ash_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'ash_unittests.isolate',
          ],
          'conditions': [
            ['use_x11==1',
              {
                'dependencies': [
                  '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
                ],
              }
            ],
          ],
        },
      ],
    }],
  ],
}
