// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2014 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include "content/public/browser/native_web_keyboard_event.h"

#include "base/logging.h"

namespace content {

NativeWebKeyboardEvent::NativeWebKeyboardEvent()
    : os_event(nullptr),
      skip_in_browser(false),
      extra_data_release_function_(nullptr),
      extra_data_copy_function_(nullptr),
      extra_data_(nullptr) {}

NativeWebKeyboardEvent::NativeWebKeyboardEvent(gfx::NativeEvent native_event)
    : NativeWebKeyboardEvent() {
  NOTREACHED();
}

NativeWebKeyboardEvent::NativeWebKeyboardEvent(const ui::KeyEvent& key_event)
    : NativeWebKeyboardEvent() {
  NOTREACHED();
}

NativeWebKeyboardEvent::NativeWebKeyboardEvent(const ui::KeyEvent& key_event,
                                               base::char16 character)
    : NativeWebKeyboardEvent() {
  NOTREACHED();
}

NativeWebKeyboardEvent::NativeWebKeyboardEvent(
    const NativeWebKeyboardEvent& other)
    : WebKeyboardEvent(other),
      os_event(nullptr),
      skip_in_browser(other.skip_in_browser),
      extra_data_release_function_(other.extra_data_release_function_),
      extra_data_copy_function_(other.extra_data_copy_function_),
      extra_data_(nullptr) {
  DCHECK(!other.os_event);
  if (other.extra_data_) {
    extra_data_ = extra_data_copy_function_(other.extra_data_);
  }
}

NativeWebKeyboardEvent::~NativeWebKeyboardEvent() {
  DCHECK(!os_event);
  if (extra_data_) {
    extra_data_release_function_(extra_data_);
  }
}

NativeWebKeyboardEvent& NativeWebKeyboardEvent::operator=(
    const NativeWebKeyboardEvent& other) {
  DCHECK(!other.os_event);
  WebKeyboardEvent::operator=(other);
  extra_data_release_function_ = other.extra_data_release_function_;
  extra_data_copy_function_ = other.extra_data_copy_function_;
  if (other.extra_data_) {
    extra_data_ = extra_data_copy_function_(extra_data_);
  }
  skip_in_browser = other.skip_in_browser;
  return *this;
}

void NativeWebKeyboardEvent::SetExtraData(
    void* data,
    ExtraDataReleaseFunction release_function,
    ExtraDataCopyFunction copy_function) {
  CHECK(!data || (release_function && copy_function));
  extra_data_ = data;
  extra_data_release_function_ = release_function;
  extra_data_copy_function_ = copy_function;
}

} // namespace content
