# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'dependencies': [
    '../base/base.gyp:base',
    '../cc/cc.gyp:cc',
    '../cc/ipc/cc_ipc.gyp:cc_ipc',
    '../components/tracing.gyp:tracing',
    '../gpu/command_buffer/command_buffer.gyp:gles2_utils',
    '../gpu/gpu.gyp:command_buffer_service',
    '../gpu/gpu.gyp:gles2_c_lib',
    '../gpu/gpu.gyp:gles2_implementation',
    '../gpu/gpu.gyp:gpu',
    '../gpu/skia_bindings/skia_bindings.gyp:gpu_skia_bindings',
    '../ipc/ipc.gyp:ipc',
    '../media/base/ipc/media_base_ipc.gyp:media_base_ipc',
    '../media/capture/capture.gyp:capture',
    '../media/media.gyp:media',
    '../media/media.gyp:media_gpu',
    '../media/media.gyp:shared_memory_support',
    '../media/gpu/ipc/media_ipc.gyp:media_gpu_ipc_client',
    '../media/gpu/ipc/media_ipc.gyp:media_gpu_ipc_common',
    '../media/midi/midi.gyp:midi',
    '../mojo/mojo_edk.gyp:mojo_system_impl',
    '../mojo/mojo_public.gyp:mojo_cpp_bindings',
    '../net/net.gyp:net',
    '../services/shell/shell.gyp:shell_runner_common_lib',
    '../services/shell/shell_public.gyp:shell_public',
    '../skia/skia.gyp:skia',
    '../storage/storage_common.gyp:storage_common',
    '../third_party/WebKit/public/blink.gyp:blink',
    '../third_party/WebKit/public/blink.gyp:mojo_bindings',
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
    '../third_party/boringssl/boringssl.gyp:boringssl',
    '../third_party/icu/icu.gyp:icuuc',
    '../ui/accessibility/accessibility.gyp:accessibility',
    '../ui/accessibility/accessibility.gyp:ax_gen',
    '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
    '../ui/base/ui_base.gyp:ui_base',
    '../ui/events/events.gyp:events_ipc',
    '../ui/gfx/gfx.gyp:gfx',
    '../ui/gfx/gfx.gyp:gfx_geometry',
    '../ui/gfx/ipc/geometry/gfx_ipc_geometry.gyp:gfx_ipc_geometry',
    '../ui/gfx/ipc/gfx_ipc.gyp:gfx_ipc',
    '../ui/gfx/ipc/skia/gfx_ipc_skia.gyp:gfx_ipc_skia',
    '../ui/gl/gl.gyp:gl',
    '../ui/gl/init/gl_init.gyp:gl_init',
    '../ui/shell_dialogs/shell_dialogs.gyp:shell_dialogs',
    '../url/url.gyp:url_lib',
    '../url/ipc/url_ipc.gyp:url_ipc',
    'content.gyp:common_features',
    'content_common_mojo_bindings.gyp:content_common_mojo_bindings',
  ],
  # content/public/common/common_param_traits_macros.h includes a generated
  # header from blink.gyp:mojo_bindings. We need to be sure any targets that
  # depend on content_common also depend upon blink.gyp:mojo_bindings so
  # that the header is generated before compile starts.
  'hard_dependency': '1',
  'include_dirs': [
    '..',
  ],
  'actions': [
    {
      'action_name': 'generate_webkit_version',
      'inputs': [
        '<(script)',
        '<(lastchange)',
        '<(template)',
      ],
      'outputs': [
        '<(SHARED_INTERMEDIATE_DIR)/build/util/webkit_version.h',
      ],
      'action': ['python',
                 '<(script)',
                 '-f', '<(lastchange)',
                 '<(template)',
                 '<@(_outputs)',
      ],
      'variables': {
        'script': '<(DEPTH)/build/util/version.py',
        'lastchange': '<(DEPTH)/build/util/LASTCHANGE.blink',
        'template': '<(DEPTH)/build/util/webkit_version.h.in',
      },
    },
  ],
  'export_dependent_settings': [
    '../base/base.gyp:base',
    '../mojo/mojo_public.gyp:mojo_cpp_bindings',
    '../services/shell/shell_public.gyp:shell_public',
    # The public content API headers directly include Blink API headers, so we
    # have to export the blink header settings so that relative paths in these
    # headers resolve correctly.
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
    '../ui/accessibility/accessibility.gyp:ax_gen',
  ],
  'variables': {
    'public_common_sources': [
      'public/common/appcache_info.h',
      'public/common/bindings_policy.h',
      'public/common/browser_plugin_guest_mode.cc',
      'public/common/browser_plugin_guest_mode.h',
      'public/common/browser_side_navigation_policy.cc',
      'public/common/browser_side_navigation_policy.h',
      'public/common/cdm_info.h',
      'public/common/child_process_host.h',
      'public/common/child_process_host_delegate.cc',
      'public/common/child_process_host_delegate.h',
      'public/common/child_process_sandbox_support_linux.h',
      'public/common/color_suggestion.cc',
      'public/common/color_suggestion.h',
      'public/common/common_param_traits.cc',
      'public/common/common_param_traits.h',
      'public/common/common_param_traits_macros.h',
      'public/common/console_message_level.h',
      'public/common/content_client.cc',
      'public/common/content_client.h',
      'public/common/content_constants.cc',
      'public/common/content_constants.h',
      'public/common/content_descriptors.h',
      'public/common/content_features.cc',
      'public/common/content_features.h',
      'public/common/content_ipc_logging.h',
      'public/common/content_paths.h',
      'public/common/content_switches.cc',
      'public/common/content_switches.h',
      'public/common/context_menu_params.cc',
      'public/common/context_menu_params.h',
      'public/common/drop_data.cc',
      'public/common/drop_data.h',
      'public/common/favicon_url.cc',
      'public/common/favicon_url.h',
      'public/common/file_chooser_file_info.cc',
      'public/common/file_chooser_file_info.h',
      'public/common/file_chooser_params.cc',
      'public/common/file_chooser_params.h',
      'public/common/frame_navigate_params.cc',
      'public/common/frame_navigate_params.h',
      'public/common/geoposition.cc',
      'public/common/geoposition.h',
      'public/common/injection_test_mac.h',
      'public/common/injection_test_win.h',
      'public/common/javascript_message_type.h',
      'public/common/main_function_params.h',
      'public/common/manifest.cc',
      'public/common/manifest.h',
      'public/common/media_metadata.cc',
      'public/common/media_metadata.h',
      'public/common/media_stream_request.cc',
      'public/common/media_stream_request.h',
      'public/common/menu_item.cc',
      'public/common/menu_item.h',
      'public/common/mhtml_generation_params.cc',
      'public/common/mhtml_generation_params.h',
      'public/common/mojo_application_info.cc',
      'public/common/mojo_application_info.h',
      'public/common/mojo_channel_switches.cc',
      'public/common/mojo_channel_switches.h',
      'public/common/mojo_shell_connection.h',
      'public/common/notification_resources.cc',
      'public/common/notification_resources.h',
      'public/common/origin_util.h',
      'public/common/page_state.cc',
      'public/common/page_state.h',
      'public/common/page_type.h',
      'public/common/page_zoom.h',
      'public/common/pepper_plugin_info.cc',
      'public/common/pepper_plugin_info.h',
      'public/common/persistent_notification_status.h',
      'public/common/platform_notification_data.cc',
      'public/common/platform_notification_data.h',
      'public/common/presentation_constants.cc',
      'public/common/presentation_constants.h',
      'public/common/process_type.h',
      'public/common/push_messaging_status.cc',
      'public/common/push_messaging_status.h',
      'public/common/referrer.cc',
      'public/common/referrer.h',
      'public/common/renderer_preferences.cc',
      'public/common/renderer_preferences.h',
      'public/common/request_context_frame_type.h',
      'public/common/request_context_type.h',
      'public/common/resource_devtools_info.cc',
      'public/common/resource_devtools_info.h',
      'public/common/resource_request_body.cc',
      'public/common/resource_request_body.h',
      'public/common/resource_response.cc',
      'public/common/resource_response.h',
      'public/common/resource_response_info.cc',
      'public/common/resource_response_info.h',
      'public/common/resource_type.cc',
      'public/common/resource_type.h',
      'public/common/result_codes.h',
      'public/common/sandbox_init.h',
      'public/common/sandbox_linux.h',
      'public/common/sandbox_type.h',
      'public/common/sandboxed_process_launcher_delegate.cc',
      'public/common/sandboxed_process_launcher_delegate.h',
      'public/common/screen_orientation_values.h',
      'public/common/security_style.h',
      'public/common/send_zygote_child_ping_linux.h',
      'public/common/speech_recognition_error.h',
      'public/common/speech_recognition_grammar.h',
      'public/common/speech_recognition_result.cc',
      'public/common/speech_recognition_result.h',
      'public/common/ssl_status.cc',
      'public/common/ssl_status.h',
      'public/common/stop_find_action.h',
      'public/common/storage_quota_params.h',
      'public/common/three_d_api_types.h',
      'public/common/top_controls_state.h',
      'public/common/transition_element.h',
      'public/common/url_constants.cc',
      'public/common/url_constants.h',
      'public/common/url_fetcher.h',
      'public/common/url_utils.cc',
      'public/common/url_utils.h',
      'public/common/user_agent.h',
      'public/common/web_preferences.cc',
      'public/common/web_preferences.h',
      'public/common/webplugininfo.cc',
      'public/common/webplugininfo.h',
      'public/common/window_container_type.cc',
      'public/common/window_container_type.h',
      'public/common/zygote_fork_delegate_linux.h',
      'public/common/zygote_handle.h',
    ],
    'private_common_sources': [
      'common/accessibility_messages.h',
      'common/all_messages.h',
      'common/android/address_parser.cc',
      'common/android/address_parser.h',
      'common/android/address_parser_internal.cc',
      'common/android/address_parser_internal.h',
      'common/android/common_jni_registrar.cc',
      'common/android/common_jni_registrar.h',
      'common/android/gin_java_bridge_errors.cc',
      'common/android/gin_java_bridge_errors.h',
      'common/android/gin_java_bridge_value.cc',
      'common/android/gin_java_bridge_value.h',
      'common/android/hash_set.cc',
      'common/android/hash_set.h',
      'common/android/media_metadata_android.cc',
      'common/android/media_metadata_android.h',
      'common/android/resource_request_body_android.cc',
      'common/android/resource_request_body_android.h',
      'common/android/sync_compositor_messages.cc',
      'common/android/sync_compositor_messages.h',
      'common/android/sync_compositor_statics.cc',
      'common/android/sync_compositor_statics.h',
      'common/appcache_interfaces.cc',
      'common/appcache_interfaces.h',
      'common/appcache_messages.h',
      'common/ax_content_node_data.cc',
      'common/ax_content_node_data.h',
      'common/browser_plugin/browser_plugin_constants.cc',
      'common/browser_plugin/browser_plugin_constants.h',
      'common/browser_plugin/browser_plugin_messages.h',
      'common/cache_storage/cache_storage_messages.h',
      'common/cache_storage/cache_storage_types.cc',
      'common/cache_storage/cache_storage_types.h',
      'common/child_process_host_impl.cc',
      'common/child_process_host_impl.h',
      'common/child_process_messages.h',
      'common/child_process_sandbox_support_impl_linux.cc',
      'common/child_process_sandbox_support_impl_linux.h',
      'common/child_process_sandbox_support_impl_shm_linux.cc',
      'common/clipboard_format.h',
      'common/clipboard_messages.h',
      'common/content_constants_internal.cc',
      'common/content_constants_internal.h',
      'common/content_export.h',
      'common/content_ipc_logging.cc',
      'common/content_message_generator.cc',
      'common/content_message_generator.h',
      'common/content_param_traits.cc',
      'common/content_param_traits.h',
      'common/content_param_traits_macros.h',
      'common/content_paths.cc',
      'common/content_security_policy_header.h',
      'common/content_switches_internal.cc',
      'common/content_switches_internal.h',
      'common/cross_site_document_classifier.cc',
      'common/cross_site_document_classifier.h',
      'common/cursors/webcursor.cc',
      'common/cursors/webcursor.h',
      'common/cursors/webcursor_android.cc',
      'common/cursors/webcursor_aura.cc',
      'common/cursors/webcursor_aurawin.cc',
      'common/cursors/webcursor_aurax11.cc',
      'common/cursors/webcursor_mac.mm',
      'common/cursors/webcursor_ozone.cc',
      'common/database_messages.h',
      'common/date_time_suggestion.h',
      'common/device_sensors/device_light_data.h',
      'common/device_sensors/device_light_hardware_buffer.h',
      'common/device_sensors/device_light_messages.h',
      'common/device_sensors/device_motion_hardware_buffer.h',
      'common/device_sensors/device_motion_messages.h',
      'common/device_sensors/device_orientation_hardware_buffer.h',
      'common/device_sensors/device_orientation_messages.h',
      'common/devtools_messages.h',
      'common/discardable_shared_memory_heap.cc',
      'common/discardable_shared_memory_heap.h',
      'common/dom_storage/dom_storage_map.cc',
      'common/dom_storage/dom_storage_map.h',
      'common/dom_storage/dom_storage_messages.h',
      'common/drag_event_source_info.h',
      'common/drag_messages.h',
      'common/drag_traits.h',
      'common/dwrite_font_proxy_messages.h',
      'common/edit_command.h',
      'common/establish_channel_params.cc',
      'common/establish_channel_params.h',
      'common/file_utilities_messages.h',
      'common/fileapi/file_system_messages.h',
      'common/font_cache_dispatcher_win.cc',
      'common/font_cache_dispatcher_win.h',
      'common/font_config_ipc_linux.cc',
      'common/font_config_ipc_linux.h',
      'common/font_list.cc',
      'common/font_list.h',
      'common/font_list_android.cc',
      'common/font_list_mac.mm',
      'common/font_list_ozone.cc',
      'common/font_list_pango.cc',
      'common/font_list_win.cc',
      'common/frame_message_enums.h',
      'common/frame_messages.h',
      'common/frame_replication_state.cc',
      'common/frame_replication_state.h',
      'common/gamepad_hardware_buffer.h',
      'common/gamepad_messages.h',
      'common/gamepad_param_traits.cc',
      'common/gamepad_param_traits.h',
      'common/generic_shared_memory_id_generator.cc',
      'common/generic_shared_memory_id_generator.h',
      'common/gin_java_bridge_messages.h',
      'common/gpu/client/command_buffer_metrics.cc',
      'common/gpu/client/command_buffer_metrics.h',
      'common/gpu/client/context_provider_command_buffer.cc',
      'common/gpu/client/context_provider_command_buffer.h',
      'common/gpu_host_messages.h',
      'common/gpu_process_launch_causes.h',
      'common/host_discardable_shared_memory_manager.cc',
      'common/host_discardable_shared_memory_manager.h',
      'common/host_shared_bitmap_manager.cc',
      'common/host_shared_bitmap_manager.h',
      'common/in_process_child_thread_params.cc',
      'common/in_process_child_thread_params.h',
      'common/indexed_db/indexed_db_constants.h',
      'common/indexed_db/indexed_db_key.cc',
      'common/indexed_db/indexed_db_key.h',
      'common/indexed_db/indexed_db_key_path.cc',
      'common/indexed_db/indexed_db_key_path.h',
      'common/indexed_db/indexed_db_key_range.cc',
      'common/indexed_db/indexed_db_key_range.h',
      'common/indexed_db/indexed_db_messages.h',
      'common/indexed_db/indexed_db_param_traits.cc',
      'common/indexed_db/indexed_db_param_traits.h',
      'common/input/did_overscroll_params.cc',
      'common/input/did_overscroll_params.h',
      'common/input/event_with_latency_info.h',
      'common/input/gesture_event_stream_validator.cc',
      'common/input/gesture_event_stream_validator.h',
      'common/input/input_event.cc',
      'common/input/input_event.h',
      'common/input/input_event_ack.cc',
      'common/input/input_event_ack.h',
      'common/input/input_event_dispatch_type.h',
      'common/input/input_event_stream_validator.cc',
      'common/input/input_event_stream_validator.h',
      'common/input/input_param_traits.cc',
      'common/input/input_param_traits.h',
      'common/input/scoped_web_input_event.cc',
      'common/input/scoped_web_input_event.h',
      'common/input/synthetic_gesture_packet.cc',
      'common/input/synthetic_gesture_packet.h',
      'common/input/synthetic_gesture_params.cc',
      'common/input/synthetic_gesture_params.h',
      'common/input/synthetic_pinch_gesture_params.cc',
      'common/input/synthetic_pinch_gesture_params.h',
      'common/input/synthetic_pointer_action_params.cc',
      'common/input/synthetic_pointer_action_params.h',
      'common/input/synthetic_smooth_drag_gesture_params.cc',
      'common/input/synthetic_smooth_drag_gesture_params.h',
      'common/input/synthetic_smooth_scroll_gesture_params.cc',
      'common/input/synthetic_smooth_scroll_gesture_params.h',
      'common/input/synthetic_tap_gesture_params.cc',
      'common/input/synthetic_tap_gesture_params.h',
      'common/input/synthetic_web_input_event_builders.cc',
      'common/input/synthetic_web_input_event_builders.h',
      'common/input/touch_event_stream_validator.cc',
      'common/input/touch_event_stream_validator.h',
      'common/input/web_input_event_queue.h',
      'common/input/web_input_event_traits.cc',
      'common/input/web_input_event_traits.h',
      'common/input/web_touch_event_traits.cc',
      'common/input/web_touch_event_traits.h',
      'common/input_messages.h',
      'common/inter_process_time_ticks_converter.cc',
      'common/inter_process_time_ticks_converter.h',
      'common/mac/attributed_string_coder.h',
      'common/mac/attributed_string_coder.mm',
      'common/mac/font_descriptor.h',
      'common/mac/font_descriptor.mm',
      'common/mac/font_loader.h',
      'common/mac/font_loader.mm',
      'common/manifest_manager_messages.h',
      'common/media/aec_dump_messages.h',
      'common/media/audio_messages.h',
      'common/media/cdm_info.cc',
      'common/media/cdm_messages.h',
      'common/media/cdm_messages_enums.h',
      'common/media/media_player_delegate_messages.h',
      'common/media/media_player_messages_android.h',
      'common/media/media_session_messages_android.h',
      'common/media/media_stream_messages.h',
      'common/media/media_stream_options.cc',
      'common/media/media_stream_options.h',
      'common/media/media_stream_track_metrics_host_messages.h',
      'common/media/midi_messages.h',
      'common/media/surface_view_manager_messages_android.h',
      'common/media/video_capture.h',
      'common/media/video_capture_messages.h',
      'common/media/webrtc_identity_messages.h',
      'common/memory_messages.h',
      'common/message_port_messages.h',
      'common/mojo/embedded_application_runner.cc',
      'common/mojo/embedded_application_runner.h',
      'common/mojo/mojo_shell_connection_impl.cc',
      'common/mojo/mojo_shell_connection_impl.h',
      'common/navigation_gesture.h',
      'common/navigation_params.cc',
      'common/navigation_params.h',
      'common/net/url_fetcher.cc',
      'common/net/url_request_service_worker_data.cc',
      'common/net/url_request_service_worker_data.h',
      'common/net/url_request_user_data.cc',
      'common/net/url_request_user_data.h',
      'common/one_writer_seqlock.cc',
      'common/one_writer_seqlock.h',
      'common/origin_trials/trial_token.cc',
      'common/origin_trials/trial_token.h',
      'common/origin_trials/trial_token_validator.cc',
      'common/origin_trials/trial_token_validator.h',
      'common/origin_util.cc',
      'common/p2p_messages.h',
      'common/page_state_serialization.cc',
      'common/page_state_serialization.h',
      'common/page_zoom.cc',
      'common/pepper_file_util.cc',
      'common/pepper_file_util.h',
      'common/pepper_plugin_list.cc',
      'common/pepper_plugin_list.h',
      'common/pepper_renderer_instance_data.cc',
      'common/pepper_renderer_instance_data.h',
      'common/platform_notification_messages.h',
      'common/plugin_list.cc',
      'common/plugin_list.h',
      'common/power_monitor_messages.h',
      'common/process_type.cc',
      'common/push_messaging_messages.h',
      'common/quota_messages.h',
      'common/render_process_messages.h',
      'common/resize_params.cc',
      'common/resize_params.h',
      'common/resource_messages.cc',
      'common/resource_messages.h',
      'common/resource_request.cc',
      'common/resource_request.h',
      'common/resource_request_body_impl.cc',
      'common/resource_request_body_impl.h',
      'common/resource_request_completion_status.cc',
      'common/resource_request_completion_status.h',
      'common/sandbox_init_mac.cc',
      'common/sandbox_init_mac.h',
      'common/sandbox_init_win.cc',
      'common/sandbox_linux/android/sandbox_bpf_base_policy_android.cc',
      'common/sandbox_linux/android/sandbox_bpf_base_policy_android.h',
      'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.cc',
      'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.h',
      'common/sandbox_linux/bpf_gpu_policy_linux.cc',
      'common/sandbox_linux/bpf_gpu_policy_linux.h',
      'common/sandbox_linux/bpf_ppapi_policy_linux.cc',
      'common/sandbox_linux/bpf_ppapi_policy_linux.h',
      'common/sandbox_linux/bpf_renderer_policy_linux.cc',
      'common/sandbox_linux/bpf_renderer_policy_linux.h',
      'common/sandbox_linux/bpf_utility_policy_linux.cc',
      'common/sandbox_linux/bpf_utility_policy_linux.h',
      'common/sandbox_linux/sandbox_bpf_base_policy_linux.cc',
      'common/sandbox_linux/sandbox_bpf_base_policy_linux.h',
      'common/sandbox_linux/sandbox_debug_handling_linux.cc',
      'common/sandbox_linux/sandbox_debug_handling_linux.h',
      'common/sandbox_linux/sandbox_init_linux.cc',
      'common/sandbox_linux/sandbox_linux.cc',
      'common/sandbox_linux/sandbox_linux.h',
      'common/sandbox_linux/sandbox_seccomp_bpf_linux.cc',
      'common/sandbox_linux/sandbox_seccomp_bpf_linux.h',
      'common/sandbox_mac.h',
      'common/sandbox_mac.mm',
      'common/sandbox_win.cc',
      'common/sandbox_win.h',
      'common/savable_subframe.h',
      'common/savable_url_schemes.cc',
      'common/savable_url_schemes.h',
      'common/screen_orientation_messages.h',
      'common/send_zygote_child_ping_linux.cc',
      'common/service_worker/embedded_worker_messages.h',
      'common/service_worker/embedded_worker_settings.h',
      'common/service_worker/service_worker_client_info.cc',
      'common/service_worker/service_worker_client_info.h',
      'common/service_worker/service_worker_messages.h',
      'common/service_worker/service_worker_status_code.cc',
      'common/service_worker/service_worker_status_code.h',
      'common/service_worker/service_worker_type_converters.cc',
      'common/service_worker/service_worker_type_converters.h',
      'common/service_worker/service_worker_types.cc',
      'common/service_worker/service_worker_types.h',
      'common/service_worker/service_worker_utils.cc',
      'common/service_worker/service_worker_utils.h',
      'common/set_process_title.cc',
      'common/set_process_title.h',
      'common/set_process_title_linux.cc',
      'common/set_process_title_linux.h',
      'common/site_isolation_policy.cc',
      'common/site_isolation_policy.h',
      'common/speech_recognition_messages.h',
      'common/ssl_status_serialization.cc',
      'common/ssl_status_serialization.h',
      'common/swapped_out_messages.cc',
      'common/swapped_out_messages.h',
      'common/text_input_client_messages.h',
      'common/text_input_state.cc',
      'common/text_input_state.h',
      'common/url_schemes.cc',
      'common/url_schemes.h',
      'common/user_agent.cc',
      'common/utility_messages.h',
      'common/view_message_enums.h',
      'common/view_messages.h',
      'common/websocket.cc',
      'common/websocket.h',
      'common/websocket_messages.h',
      'common/worker_messages.h',
      'common/zygote_commands_linux.h',
    ],
  },
  'sources': [
    '<@(public_common_sources)',
    '<@(private_common_sources)',
  ],
  'target_conditions': [
    ['OS=="android" and <(use_seccomp_bpf)==1', {
      'sources/': [
        ['include', '^common/sandbox_linux/sandbox_bpf_base_policy_linux\\.cc$'],
        ['include', '^common/sandbox_linux/sandbox_bpf_base_policy_linux\\.h$'],
      ],
    }],
  ],
  'conditions': [
    ['OS=="mac"', {
      'dependencies': [ '../sandbox/sandbox.gyp:seatbelt' ],
      'variables': {
        'vt_stubs_output_root': '<(SHARED_INTERMEDIATE_DIR)/vt_stubs',
      },
      'include_dirs': [
        '<(vt_stubs_output_root)',
      ],
    }],
    ['OS=="android"',{
      'link_settings': {
        'libraries': [
          '-landroid',  # ANativeWindow
        ],
      },
     'dependencies': [
        'content.gyp:content_jni_headers',
        'content.gyp:common_aidl',
      ],
    }],
    ['use_pango == 1', {
      'dependencies': [
        '../build/linux/system.gyp:pangocairo',
      ],
      'sources!': [
        'common/font_list_ozone.cc',
      ],
    }],
    ['use_x11 == 1', {
      'include_dirs': [
        '<(DEPTH)/third_party/khronos',
      ],
      'dependencies': [
         '<(DEPTH)/build/linux/system.gyp:xcomposite',
      ],
    }],
    ['enable_plugins==1', {
      'dependencies': [
        '../ppapi/ppapi_internal.gyp:ppapi_shared',
      ],
    }, {  # enable_plugins == 0
      'sources!': [
        'common/pepper_file_util.cc',
        'common/pepper_file_util.h',
        'common/pepper_plugin_list.cc',
        'common/pepper_plugin_list.h',
        'common/pepper_renderer_instance_data.cc',
        'common/pepper_renderer_instance_data.h',
        'common/plugin_list.cc',
        'common/plugin_list.h',
        'public/common/pepper_plugin_info.cc',
        'public/common/pepper_plugin_info.h',
      ],
    }],
    ['enable_webrtc==1', {
      'dependencies': [
        '../third_party/libjingle/libjingle.gyp:libjingle',
      ],
      'sources': [
        'public/common/webrtc_ip_handling_policy.cc',
        'public/common/webrtc_ip_handling_policy.h',
      ],
    }],
    ['use_seccomp_bpf==0', {
      'sources!': [
        'common/sandbox_linux/android/sandbox_bpf_base_policy_android.cc',
        'common/sandbox_linux/android/sandbox_bpf_base_policy_android.h',
        'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.cc',
        'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.h',
        'common/sandbox_linux/bpf_gpu_policy_linux.cc',
        'common/sandbox_linux/bpf_gpu_policy_linux.h',
        'common/sandbox_linux/bpf_ppapi_policy_linux.cc',
        'common/sandbox_linux/bpf_ppapi_policy_linux.h',
        'common/sandbox_linux/bpf_renderer_policy_linux.cc',
        'common/sandbox_linux/bpf_renderer_policy_linux.h',
        'common/sandbox_linux/bpf_utility_policy_linux.cc',
        'common/sandbox_linux/bpf_utility_policy_linux.h',
        'common/sandbox_linux/sandbox_bpf_base_policy_linux.cc',
        'common/sandbox_linux/sandbox_bpf_base_policy_linux.h',
      ],
    }, {
      'defines': ['USE_SECCOMP_BPF'],
    }],
    ['use_ozone==1', {
      'dependencies': [
        '../ui/ozone/ozone.gyp:ozone',
        '../ui/ozone/ozone.gyp:ozone_base',
      ],
      'sources!': [
        'common/gpu/gpu_memory_buffer_factory_linux.cc',
      ],
    }, {  # use_ozone!=1
      'sources!': [
        'common/cursors/webcursor_ozone.cc',
        'common/font_list_ozone.cc',
        'common/gpu/gpu_memory_buffer_factory_ozone.cc',
        'common/gpu/gpu_memory_buffer_factory_ozone_native_pixmap.cc',
        'common/gpu/gpu_memory_buffer_factory_ozone_native_pixmap.h',
      ],
    }],
    ['enable_ipc_fuzzer==1', {
      'sources': [
        'common/external_ipc_dumper.cc',
        'common/external_ipc_dumper.h',
      ],
    }],
  ],
}
