// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2014 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include "power_save_blocker_oxide.h"

#include "base/logging.h"

namespace device {

namespace {
PowerSaveBlocker::OxideDelegateFactory* g_factory;
}

// static
void PowerSaveBlocker::SetOxideDelegateFactory(OxideDelegateFactory* factory) {
  g_factory = factory;
}

class PowerSaveBlocker::Delegate
    : public base::RefCounted<PowerSaveBlocker::Delegate> {
 public:
  Delegate(PowerSaveBlockerType type,
           Reason reason,
           const std::string& description,
           scoped_refptr<base::SequencedTaskRunner> ui_task_runner,
           scoped_refptr<base::SingleThreadTaskRunner> blocking_task_runner) {
    DCHECK(g_factory);

    delegate_ = g_factory(type, reason, description,
                          ui_task_runner, blocking_task_runner);
    if (!delegate_.get()) {
      NOTIMPLEMENTED();
      return;
    }

    delegate_->Init();
  }

  ~Delegate() {
    if (delegate_.get()) {
      delegate_->CleanUp();
    }
  }

 private:
  scoped_refptr<PowerSaveBlockerOxideDelegate> delegate_;

  DISALLOW_COPY_AND_ASSIGN(Delegate);
};

PowerSaveBlocker::PowerSaveBlocker(
    PowerSaveBlockerType type,
    Reason reason,
    const std::string& description,
    scoped_refptr<base::SequencedTaskRunner> ui_task_runner,
    scoped_refptr<base::SingleThreadTaskRunner> blocking_task_runner)
    : delegate_(new Delegate(type,
                             reason,
                             description,
                             ui_task_runner,
                             blocking_task_runner)) {}

PowerSaveBlocker::~PowerSaveBlocker() {}

} // namespace device
