#!/usr/bin/python
# Copyright 2008 The Native Client Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.


"""
This tool generates bad NaCl modules that should never be generated by
a conformant compiler.  These bad modules are used to test that
sel_ldr correctly detects that these are bad modules.

"""

import sys

EHDR_SIZE=52
EI_ABIVERSION_OFFSET=8  # eventually take over set_abi_version?

PHDR_SIZE=32
P_MEMSZ_OFF=(5*4)
PT_LOAD=1
PT_PHDR=6


FILE_MODIFICATIONS=[
    [ "fib_scalar.nexe", "integer_overflow_while_madvising.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0xbf)),
        ]
      ],
    [ "fib_scalar.nexe", "negative_hole.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0xf)),
        ],
      ],
    [ "fib_scalar.nexe", "text_too_big.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0x5f)),
        ],
      ],
    ]


def UpdateData(data, change_list):
  for ix, replacement_byte in change_list:
    data = data[:ix] + replacement_byte + data[ix+1:]
  return data


def UpdateFileWithChangeList(src_file, dst_file, change_list):
  data = open(src_file).read()
  data = UpdateData(data, change_list)
  open(dst_file, 'w').write(data)

if __name__ == '__main__':
  for src_file, dst_file, cl in FILE_MODIFICATIONS:
    UpdateFileWithChangeList(src_file, dst_file, cl)
  sys.exit(0)
