// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2013 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _OXIDE_QT_CORE_API_STORAGE_PERMISSION_REQUEST_P_H_
#define _OXIDE_QT_CORE_API_STORAGE_PERMISSION_REQUEST_P_H_

#include <QtGlobal>
#include <QUrl>

#include "shared/browser/oxide_browser_context_delegate.h"
#include "qt/core/api/oxideqstoragepermissionrequest.h"

class OxideQStoragePermissionRequestPrivate final {
 public:
  ~OxideQStoragePermissionRequestPrivate();

  static OxideQStoragePermissionRequestPrivate* get(
      OxideQStoragePermissionRequest* q);

  oxide::StoragePermission permission;
 
 private:
  friend class OxideQStoragePermissionRequest;

  OxideQStoragePermissionRequestPrivate(
      const QUrl& url,
      const QUrl& first_party_url,
      bool write,
      OxideQStoragePermissionRequest::Type type);

  QUrl url_;
  QUrl first_party_url_;
  bool write_;
  OxideQStoragePermissionRequest::Type type_;
};

#endif // _OXIDE_QT_CORE_API_STORAGE_PERMISSION_REQUEST_P_H_
