// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2014-2015 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _OXIDE_SHARED_BROWSER_COMPOSITOR_COMPOSITOR_OUTPUT_SURFACE_GL_H_
#define _OXIDE_SHARED_BROWSER_COMPOSITOR_COMPOSITOR_OUTPUT_SURFACE_GL_H_

#include <deque>
#include <queue>

#include "base/compiler_specific.h"
#include "base/macros.h"
#include "gpu/command_buffer/common/mailbox.h"
#include "ui/gfx/geometry/size.h"

#include "shared/browser/compositor/oxide_compositor_output_surface.h"

namespace oxide {

class CompositorOutputSurfaceGL final : public CompositorOutputSurface {
 public:
  CompositorOutputSurfaceGL(
      uint32_t surface_id,
      scoped_refptr<cc::ContextProvider> context_provider,
      scoped_refptr<CompositorThreadProxy> proxy);
  ~CompositorOutputSurfaceGL();

 private:
  // cc::OutputSurface implementation
  void EnsureBackbuffer() final;
  void DiscardBackbuffer() final;
  void Reshape(const gfx::Size& size, float scale_factor) final;
  void BindFramebuffer() final;
  void SwapBuffers(cc::CompositorFrame* frame) final;

  // CompositorOutputSurface implementation
  void ReclaimResources(const cc::CompositorFrameAck& ack) final;

  struct BufferData {
    BufferData() : texture_id(0), sync_point(0) {}

    uint32_t texture_id;
    gpu::Mailbox mailbox;
    gfx::Size size;
    uint32_t sync_point;
  };

  void DiscardBuffer(BufferData* buffer);

  BufferData back_buffer_;
  std::deque<BufferData> pending_buffers_;
  std::queue<BufferData> returned_buffers_;

  bool is_backbuffer_discarded_;
  uint32_t fbo_;

  DISALLOW_COPY_AND_ASSIGN(CompositorOutputSurfaceGL);
};

} // namespace oxide

#endif // _OXIDE_SHARED_BROWSER_COMPOSITOR_COMPOSITOR_OUTPUT_SURFACE_GL_H_
