# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'dependencies': [
    '../base/base.gyp:base',
    '../components/tracing.gyp:tracing',
    '../gpu/command_buffer/command_buffer.gyp:gles2_utils',
    '../net/net.gyp:net',
    '../skia/skia.gyp:skia',
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
    '../third_party/icu/icu.gyp:icuuc',
    '../ui/accessibility/accessibility.gyp:accessibility',
    '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
    '../ui/base/ui_base.gyp:ui_base',
    '../ui/events/ipc/events_ipc.gyp:events_ipc',
    '../ui/gfx/gfx.gyp:gfx',
    '../ui/gfx/gfx.gyp:gfx_geometry',
    '../ui/gfx/ipc/gfx_ipc.gyp:gfx_ipc',
    '../ui/shell_dialogs/shell_dialogs.gyp:shell_dialogs',
    '../url/url.gyp:url_lib',
  ],
  'include_dirs': [
    '..',
    '<(DEPTH)/../../..',
  ],
  'export_dependent_settings': [
    '../base/base.gyp:base',
    # The public content API headers directly include Blink API headers, so we
    # have to export the blink header settings so that relative paths in these
    # headers resolve correctly.
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
  ],
  'variables': {
    'use_v4lplugin%': 0,
    'use_v4l2_codec%': 0,
    'public_common_sources': [
      'public/common/appcache_info.h',
      'public/common/bindings_policy.h',
      'public/common/child_process_host.h',
      'public/common/child_process_host_delegate.cc',
      'public/common/child_process_host_delegate.h',
      'public/common/child_process_sandbox_support_linux.h',
      'public/common/color_suggestion.cc',
      'public/common/color_suggestion.h',
      'public/common/common_param_traits.cc',
      'public/common/common_param_traits.h',
      'public/common/common_param_traits_macros.h',
      'public/common/console_message_level.h',
      'public/common/content_client.cc',
      'public/common/content_client.h',
      'public/common/content_constants.cc',
      'public/common/content_constants.h',
      'public/common/content_descriptors.h',
      'public/common/content_ipc_logging.h',
      'public/common/content_paths.h',
      'public/common/content_switches.cc',
      'public/common/content_switches.h',
      'public/common/context_menu_params.cc',
      'public/common/context_menu_params.h',
      'public/common/drop_data.cc',
      'public/common/drop_data.h',
      'public/common/dwrite_font_platform_win.h',
      'public/common/favicon_url.cc',
      'public/common/favicon_url.h',
      'public/common/file_chooser_file_info.cc',
      'public/common/file_chooser_file_info.h',
      'public/common/file_chooser_params.cc',
      'public/common/file_chooser_params.h',
      'public/common/frame_navigate_params.cc',
      'public/common/frame_navigate_params.h',
      'public/common/geoposition.cc',
      'public/common/geoposition.h',
      'public/common/gpu_memory_stats.cc',
      'public/common/gpu_memory_stats.h',
      'public/common/injection_test_mac.h',
      'public/common/injection_test_win.h',
      'public/common/javascript_message_type.h',
      'public/common/main_function_params.h',
      'public/common/manifest.cc',
      'public/common/manifest.h',
      'public/common/media_stream_request.cc',
      'public/common/media_stream_request.h',
      'public/common/menu_item.cc',
      'public/common/menu_item.h',
      'public/common/message_port_types.cc',
      'public/common/message_port_types.h',
      'public/common/mojo_channel_switches.cc',
      'public/common/mojo_channel_switches.h',
      'public/common/navigator_connect_client.cc',
      'public/common/navigator_connect_client.h',
      'public/common/page_state.cc',
      'public/common/page_state.h',
      'public/common/page_type.h',
      'public/common/page_zoom.h',
      'public/common/pepper_plugin_info.cc',
      'public/common/pepper_plugin_info.h',
      'public/common/persistent_notification_status.h',
      'public/common/platform_notification_data.cc',
      'public/common/platform_notification_data.h',
      'public/common/process_type.h',
      'public/common/push_messaging_status.cc',
      'public/common/push_messaging_status.h',
      'public/common/referrer.cc',
      'public/common/referrer.h',
      'public/common/renderer_preferences.cc',
      'public/common/renderer_preferences.h',
      'public/common/request_context_frame_type.h',
      'public/common/request_context_type.h',
      'public/common/resource_devtools_info.cc',
      'public/common/resource_devtools_info.h',
      'public/common/resource_response.cc',
      'public/common/resource_response.h',
      'public/common/resource_response_info.cc',
      'public/common/resource_response_info.h',
      'public/common/resource_type.cc',
      'public/common/resource_type.h',
      'public/common/result_codes.h',
      'public/common/sandbox_init.h',
      'public/common/sandbox_linux.h',
      'public/common/sandbox_type_mac.h',
      'public/common/sandboxed_process_launcher_delegate.cc',
      'public/common/sandboxed_process_launcher_delegate.h',
      'public/common/security_style.h',
      'public/common/send_zygote_child_ping_linux.h',
      'public/common/service_registry.h',
      'public/common/signed_certificate_timestamp_id_and_status.cc',
      'public/common/signed_certificate_timestamp_id_and_status.h',
      'public/common/speech_recognition_error.h',
      'public/common/speech_recognition_grammar.h',
      'public/common/speech_recognition_result.cc',
      'public/common/speech_recognition_result.h',
      'public/common/ssl_status.cc',
      'public/common/ssl_status.h',
      'public/common/stop_find_action.h',
      'public/common/storage_quota_params.h',
      'public/common/three_d_api_types.h',
      'public/common/top_controls_state.h',
      'public/common/transition_element.h',
      'public/common/url_constants.cc',
      'public/common/url_constants.h',
      'public/common/url_fetcher.h',
      'public/common/url_utils.cc',
      'public/common/url_utils.h',
      'public/common/user_agent.h',
      'public/common/web_preferences.cc',
      'public/common/web_preferences.h',
      'public/common/webplugininfo.cc',
      'public/common/webplugininfo.h',
      'public/common/window_container_type.cc',
      'public/common/window_container_type.h',
      'public/common/zygote_fork_delegate_linux.h',
    ],
    'private_common_sources': [
      'common/accessibility_messages.h',
      'common/all_messages.h',
      'common/android/address_parser.cc',
      'common/android/address_parser.h',
      'common/android/address_parser_internal.cc',
      'common/android/address_parser_internal.h',
      'common/android/common_jni_registrar.cc',
      'common/android/common_jni_registrar.h',
      'common/android/gin_java_bridge_errors.cc',
      'common/android/gin_java_bridge_errors.h',
      'common/android/gin_java_bridge_value.cc',
      'common/android/gin_java_bridge_value.h',
      'common/android/hash_set.cc',
      'common/android/hash_set.h',
      'common/android/surface_texture_manager.cc',
      'common/android/surface_texture_manager.h',
      'common/android/surface_texture_peer.cc',
      'common/android/surface_texture_peer.h',
      'common/appcache_interfaces.cc',
      'common/appcache_interfaces.h',
      'common/appcache_messages.h',
      'common/bluetooth/bluetooth_device.cc',
      'common/bluetooth/bluetooth_device.h',
      'common/bluetooth/bluetooth_error.h',
      'common/bluetooth/bluetooth_messages.h',
      'common/browser_plugin/browser_plugin_constants.cc',
      'common/browser_plugin/browser_plugin_constants.h',
      'common/browser_plugin/browser_plugin_messages.h',
      'common/cache_storage/cache_storage_messages.h',
      'common/cache_storage/cache_storage_types.cc',
      'common/cache_storage/cache_storage_types.h',
      'common/cc_messages.cc',
      'common/cc_messages.h',
      'common/child_process_host_impl.cc',
      'common/child_process_host_impl.h',
      'common/child_process_messages.h',
      'common/child_process_sandbox_support_impl_linux.cc',
      'common/child_process_sandbox_support_impl_linux.h',
      'common/child_process_sandbox_support_impl_shm_linux.cc',
      'common/clipboard_format.h',
      'common/clipboard_messages.h',
      'common/content_constants_internal.cc',
      'common/content_constants_internal.h',
      'common/content_export.h',
      'common/content_ipc_logging.cc',
      'common/content_message_generator.cc',
      'common/content_message_generator.h',
      'common/content_param_traits.cc',
      'common/content_param_traits.h',
      'common/content_param_traits_macros.h',
      'common/content_paths.cc',
      'common/content_switches_internal.cc',
      'common/content_switches_internal.h',
      'common/cookie_data.cc',
      'common/cookie_data.h',
      'common/cursors/webcursor.cc',
      'common/cursors/webcursor.h',
      'common/cursors/webcursor_android.cc',
      'common/cursors/webcursor_aura.cc',
      'common/cursors/webcursor_aurawin.cc',
      'common/cursors/webcursor_aurax11.cc',
      'common/cursors/webcursor_mac.mm',
      'common/cursors/webcursor_ozone.cc',
      'common/database_messages.h',
      'common/date_time_suggestion.h',
      'common/device_sensors/device_light_data.h',
      'common/device_sensors/device_light_hardware_buffer.h',
      'common/device_sensors/device_light_messages.h',
      'common/device_sensors/device_motion_hardware_buffer.h',
      'common/device_sensors/device_motion_messages.h',
      'common/device_sensors/device_orientation_hardware_buffer.h',
      'common/device_sensors/device_orientation_messages.h',
      'common/devtools_messages.h',
      'common/discardable_shared_memory_heap.cc',
      'common/discardable_shared_memory_heap.h',
      'common/dom_storage/dom_storage_map.cc',
      'common/dom_storage/dom_storage_map.h',
      'common/dom_storage/dom_storage_messages.h',
      'common/drag_event_source_info.h',
      'common/drag_messages.h',
      'common/drag_traits.h',
      'common/dwrite_font_platform_win.cc',
      'common/edit_command.h',
      'common/file_utilities_messages.h',
      'common/fileapi/file_system_messages.h',
      'common/fileapi/webblob_messages.h',
      'common/font_cache_dispatcher_win.cc',
      'common/font_cache_dispatcher_win.h',
      'common/font_config_ipc_linux.cc',
      'common/font_config_ipc_linux.h',
      'common/font_list.cc',
      'common/font_list.h',
      'common/font_list_android.cc',
      'common/font_list_mac.mm',
      'common/font_list_ozone.cc',
      'common/font_list_pango.cc',
      'common/font_list_win.cc',
      'common/frame_message_enums.h',
      'common/frame_messages.h',
      'common/frame_param.cc',
      'common/frame_param.h',
      'common/frame_param_macros.h',
      'common/frame_replication_state.cc',
      'common/frame_replication_state.h',
      'common/gamepad_hardware_buffer.h',
      'common/gamepad_messages.h',
      'common/gamepad_param_traits.cc',
      'common/gamepad_param_traits.h',
      'common/gamepad_user_gesture.cc',
      'common/gamepad_user_gesture.h',
      'common/geofencing_messages.h',
      'common/geofencing_types.cc',
      'common/geofencing_types.h',
      'common/gin_java_bridge_messages.h',
      'common/gpu/client/command_buffer_proxy_impl.cc',
      'common/gpu/client/command_buffer_proxy_impl.h',
      'common/gpu/client/context_provider_command_buffer.cc',
      'common/gpu/client/context_provider_command_buffer.h',
      'common/gpu/client/gl_helper.cc',
      'common/gpu/client/gl_helper.h',
      'common/gpu/client/gl_helper_readback_support.cc',
      'common/gpu/client/gl_helper_readback_support.h',
      'common/gpu/client/gl_helper_scaling.cc',
      'common/gpu/client/gl_helper_scaling.h',
      'common/gpu/client/gpu_channel_host.cc',
      'common/gpu/client/gpu_channel_host.h',
      'common/gpu/client/gpu_memory_buffer_factory_host.h',
      'common/gpu/client/gpu_memory_buffer_impl.cc',
      'common/gpu/client/gpu_memory_buffer_impl.h',
      'common/gpu/client/gpu_memory_buffer_impl_ozone_native_buffer.cc',
      'common/gpu/client/gpu_memory_buffer_impl_ozone_native_buffer.h',
      'common/gpu/client/gpu_memory_buffer_impl_shared_memory.cc',
      'common/gpu/client/gpu_memory_buffer_impl_shared_memory.h',
      'common/gpu/client/gpu_video_decode_accelerator_host.cc',
      'common/gpu/client/gpu_video_decode_accelerator_host.h',
      'common/gpu/client/gpu_video_encode_accelerator_host.cc',
      'common/gpu/client/gpu_video_encode_accelerator_host.h',
      'common/gpu/client/webgraphicscontext3d_command_buffer_impl.cc',
      'common/gpu/client/webgraphicscontext3d_command_buffer_impl.h',
      'common/gpu/gpu_channel.cc',
      'common/gpu/gpu_channel.h',
      'common/gpu/gpu_channel_manager.cc',
      'common/gpu/gpu_channel_manager.h',
      'common/gpu/gpu_command_buffer_stub.cc',
      'common/gpu/gpu_command_buffer_stub.h',
      'common/gpu/gpu_config.h',
      'common/gpu/gpu_memory_buffer_factory.cc',
      'common/gpu/gpu_memory_buffer_factory.h',
      'common/gpu/gpu_memory_buffer_factory_ozone_native_buffer.cc',
      'common/gpu/gpu_memory_buffer_factory_ozone_native_buffer.h',
      'common/gpu/gpu_memory_buffer_factory_shared_memory.cc',
      'common/gpu/gpu_memory_buffer_factory_shared_memory.h',
      'common/gpu/gpu_memory_manager.cc',
      'common/gpu/gpu_memory_manager.h',
      'common/gpu/gpu_memory_manager_client.cc',
      'common/gpu/gpu_memory_manager_client.h',
      'common/gpu/gpu_memory_tracking.cc',
      'common/gpu/gpu_memory_tracking.h',
      'common/gpu/gpu_memory_uma_stats.h',
      'common/gpu/gpu_messages.h',
      'common/gpu/gpu_process_launch_causes.h',
      'common/gpu/gpu_result_codes.h',
      'common/gpu/gpu_surface_lookup.cc',
      'common/gpu/gpu_surface_lookup.h',
      'common/gpu/gpu_watchdog.h',
      'common/gpu/image_transport_surface.cc',
      'common/gpu/image_transport_surface.h',
      'common/gpu/image_transport_surface_android.cc',
      'common/gpu/image_transport_surface_calayer_mac.h',
      'common/gpu/image_transport_surface_calayer_mac.mm',
      'common/gpu/image_transport_surface_fbo_mac.h',
      'common/gpu/image_transport_surface_fbo_mac.mm',
      'common/gpu/image_transport_surface_iosurface_mac.cc',
      'common/gpu/image_transport_surface_iosurface_mac.h',
      'common/gpu/image_transport_surface_linux.cc',
      'common/gpu/image_transport_surface_mac.mm',
      'common/gpu/image_transport_surface_win.cc',
      'common/gpu/media/fake_video_decode_accelerator.cc',
      'common/gpu/media/fake_video_decode_accelerator.h',
      'common/gpu/media/gpu_video_decode_accelerator.cc',
      'common/gpu/media/gpu_video_decode_accelerator.h',
      'common/gpu/media/gpu_video_encode_accelerator.cc',
      'common/gpu/media/gpu_video_encode_accelerator.h',
      'common/gpu/null_transport_surface.cc',
      'common/gpu/null_transport_surface.h',
      'common/gpu/stream_texture_android.cc',
      'common/gpu/stream_texture_android.h',
      'common/handle_enumerator_win.cc',
      'common/handle_enumerator_win.h',
      'common/host_discardable_shared_memory_manager.cc',
      'common/host_discardable_shared_memory_manager.h',
      'common/host_shared_bitmap_manager.cc',
      'common/host_shared_bitmap_manager.h',
      'common/image_messages.h',
      'common/indexed_db/indexed_db_constants.h',
      'common/indexed_db/indexed_db_key.cc',
      'common/indexed_db/indexed_db_key.h',
      'common/indexed_db/indexed_db_key_path.cc',
      'common/indexed_db/indexed_db_key_path.h',
      'common/indexed_db/indexed_db_key_range.cc',
      'common/indexed_db/indexed_db_key_range.h',
      'common/indexed_db/indexed_db_messages.h',
      'common/indexed_db/indexed_db_param_traits.cc',
      'common/indexed_db/indexed_db_param_traits.h',
      'common/input/did_overscroll_params.cc',
      'common/input/did_overscroll_params.h',
      'common/input/gesture_event_stream_validator.cc',
      'common/input/gesture_event_stream_validator.h',
      'common/input/input_event.cc',
      'common/input/input_event.h',
      'common/input/input_event_stream_validator.cc',
      'common/input/input_event_stream_validator.h',
      'common/input/input_param_traits.cc',
      'common/input/input_param_traits.h',
      'common/input/scoped_web_input_event.cc',
      'common/input/scoped_web_input_event.h',
      'common/input/synthetic_gesture_packet.cc',
      'common/input/synthetic_gesture_packet.h',
      'common/input/synthetic_gesture_params.cc',
      'common/input/synthetic_gesture_params.h',
      'common/input/synthetic_pinch_gesture_params.cc',
      'common/input/synthetic_pinch_gesture_params.h',
      'common/input/synthetic_smooth_drag_gesture_params.cc',
      'common/input/synthetic_smooth_drag_gesture_params.h',
      'common/input/synthetic_smooth_scroll_gesture_params.cc',
      'common/input/synthetic_smooth_scroll_gesture_params.h',
      'common/input/synthetic_tap_gesture_params.cc',
      'common/input/synthetic_tap_gesture_params.h',
      'common/input/synthetic_web_input_event_builders.cc',
      'common/input/synthetic_web_input_event_builders.h',
      'common/input/touch_event_stream_validator.cc',
      'common/input/touch_event_stream_validator.h',
      'common/input/web_input_event_traits.cc',
      'common/input/web_input_event_traits.h',
      'common/input/web_touch_event_traits.cc',
      'common/input/web_touch_event_traits.h',
      'common/input_messages.h',
      'common/inter_process_time_ticks_converter.cc',
      'common/inter_process_time_ticks_converter.h',
      'common/in_process_child_thread_params.cc',
      'common/in_process_child_thread_params.h',
      'common/mac/attributed_string_coder.h',
      'common/mac/attributed_string_coder.mm',
      'common/mac/font_descriptor.h',
      'common/mac/font_descriptor.mm',
      'common/mac/font_loader.h',
      'common/mac/font_loader.mm',
      'common/manifest_manager_messages.h',
      'common/media/aec_dump_messages.h',
      'common/media/audio_messages.h',
      'common/media/cdm_messages.h',
      'common/media/cdm_messages_enums.h',
      'common/media/media_param_traits.cc',
      'common/media/media_param_traits.h',
      'common/media/media_player_messages_android.h',
      'common/media/media_player_messages_enums_android.h',
      'common/media/media_stream_messages.h',
      'common/media/media_stream_options.cc',
      'common/media/media_stream_options.h',
      'common/media/media_stream_track_metrics_host_messages.h',
      'common/media/midi_messages.h',
      'common/media/video_capture.h',
      'common/media/video_capture_messages.h',
      'common/media/webrtc_identity_messages.h',
      'common/memory_benchmark_messages.h',
      'common/message_port_messages.h',
      'common/message_router.cc',
      'common/message_router.h',
      'common/mime_registry_messages.h',
      'common/mojo/channel_init.cc',
      'common/mojo/channel_init.h',
      'common/mojo/mojo_messages.h',
      'common/mojo/service_registry_impl.cc',
      'common/mojo/service_registry_impl.h',
      'common/navigation_gesture.h',
      'common/navigation_params.cc',
      'common/navigation_params.h',
      'common/navigator_connect_messages.h',
      'common/net/url_fetcher.cc',
      'common/net/url_request_user_data.cc',
      'common/net/url_request_user_data.h',
      'common/one_writer_seqlock.cc',
      'common/one_writer_seqlock.h',
      'common/p2p_messages.h',
      'common/page_state_serialization.cc',
      'common/page_state_serialization.h',
      'common/page_zoom.cc',
      'common/pepper_file_util.cc',
      'common/pepper_file_util.h',
      'common/pepper_messages.h',
      'common/pepper_plugin_list.cc',
      'common/pepper_plugin_list.h',
      'common/pepper_renderer_instance_data.cc',
      'common/pepper_renderer_instance_data.h',
      'common/platform_notification_messages.h',
      'common/plugin_constants_win.cc',
      'common/plugin_constants_win.h',
      'common/plugin_list.cc',
      'common/plugin_list.h',
      'common/plugin_list_mac.mm',
      'common/plugin_list_posix.cc',
      'common/plugin_list_win.cc',
      'common/plugin_process_messages.h',
      'common/power_monitor_messages.h',
      'common/process_type.cc',
      'common/push_messaging_messages.h',
      'common/quota_messages.h',
      'common/resource_messages.cc',
      'common/resource_messages.h',
      'common/resource_request_body.cc',
      'common/resource_request_body.h',
      'common/sandbox_init_mac.cc',
      'common/sandbox_init_mac.h',
      'common/sandbox_init_win.cc',
      'common/sandbox_linux/android/sandbox_bpf_base_policy_android.cc',
      'common/sandbox_linux/android/sandbox_bpf_base_policy_android.h',
      'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.cc',
      'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.h',
      'common/sandbox_linux/bpf_gpu_policy_linux.cc',
      'common/sandbox_linux/bpf_gpu_policy_linux.h',
      'common/sandbox_linux/bpf_ppapi_policy_linux.cc',
      'common/sandbox_linux/bpf_ppapi_policy_linux.h',
      'common/sandbox_linux/bpf_renderer_policy_linux.cc',
      'common/sandbox_linux/bpf_renderer_policy_linux.h',
      'common/sandbox_linux/bpf_utility_policy_linux.cc',
      'common/sandbox_linux/bpf_utility_policy_linux.h',
      'common/sandbox_linux/sandbox_bpf_base_policy_linux.cc',
      'common/sandbox_linux/sandbox_bpf_base_policy_linux.h',
      'common/sandbox_linux/sandbox_debug_handling_linux.cc',
      'common/sandbox_linux/sandbox_debug_handling_linux.h',
      'common/sandbox_linux/sandbox_init_linux.cc',
      'common/sandbox_linux/sandbox_linux.cc',
      'common/sandbox_linux/sandbox_linux.h',
      'common/sandbox_linux/sandbox_seccomp_bpf_linux.cc',
      'common/sandbox_linux/sandbox_seccomp_bpf_linux.h',
      'common/sandbox_mac.h',
      'common/sandbox_mac.mm',
      'common/sandbox_util.cc',
      'common/sandbox_util.h',
      'common/sandbox_win.cc',
      'common/sandbox_win.h',
      'common/savable_url_schemes.cc',
      'common/savable_url_schemes.h',
      'common/screen_orientation_messages.h',
      'common/send_zygote_child_ping_linux.cc',
      'common/service_worker/embedded_worker_messages.h',
      'common/service_worker/service_worker_client_info.cc',
      'common/service_worker/service_worker_client_info.h',
      'common/service_worker/service_worker_messages.h',
      'common/service_worker/service_worker_status_code.cc',
      'common/service_worker/service_worker_status_code.h',
      'common/service_worker/service_worker_types.cc',
      'common/service_worker/service_worker_types.h',
      'common/set_process_title.cc',
      'common/set_process_title.h',
      'common/set_process_title_linux.cc',
      'common/set_process_title_linux.h',
      'common/speech_recognition_messages.h',
      'common/ssl_status_serialization.cc',
      'common/ssl_status_serialization.h',
      'common/swapped_out_messages.cc',
      'common/swapped_out_messages.h',
      'common/text_input_client_messages.h',
      'common/url_schemes.cc',
      'common/url_schemes.h',
      'common/user_agent.cc',
      'common/utility_messages.h',
      'common/view_message_enums.h',
      'common/view_messages.h',
      'common/webplugin_geometry.cc',
      'common/webplugin_geometry.h',
      'common/websocket.cc',
      'common/websocket.h',
      'common/websocket_messages.h',
      'common/worker_messages.h',
      'common/zygote_commands_linux.h',
      '<(DEPTH)/../../../shared/port/content/common/gpu_client_shim_oxide.cc',
      '<(DEPTH)/../../../shared/port/content/common/gpu_client_shim_oxide.h',
      '<(DEPTH)/../../../shared/port/content/common/gpu_service_shim_oxide.cc',
      '<(DEPTH)/../../../shared/port/content/common/gpu_service_shim_oxide.h',
    ],
  },
  'sources': [
    '<@(public_common_sources)',
    '<@(private_common_sources)',
  ],
  'target_conditions': [
    ['OS=="android" and <(use_seccomp_bpf)==1', {
      'sources/': [
        ['include', '^common/sandbox_linux/sandbox_bpf_base_policy_linux\\.cc$'],
        ['include', '^common/sandbox_linux/sandbox_bpf_base_policy_linux\\.h$'],
      ],
    }],
  ],
  'conditions': [
    ['OS=="ios"', {
      # iOS has different user-agent construction utilities, since the
      # version strings is not derived from webkit_version, and follows
      # a different format.
      'sources!': [
        'common/user_agent.cc',
      ],
      'sources/': [
        # iOS only needs a small portion of content; exclude all the
        # implementation, and re-include what is used.
        ['exclude', '\\.(cc|mm)$'],
        ['include', '_ios\\.(cc|mm)$'],
        ['include', '^public/common/content_client\\.cc$'],
        ['include', '^public/common/content_constants\\.cc$'],
        ['include', '^public/common/content_switches\\.cc$'],
        ['include', '^public/common/frame_navigate_params\\.cc$'],
        ['include', '^public/common/media_stream_request\\.cc$'],
        ['include', '^public/common/page_state\\.cc$'],
        ['include', '^public/common/password_form\\.cc$'],
        ['include', '^public/common/signed_certificate_timestamp_id_and_status\\.cc$'],
        ['include', '^public/common/speech_recognition_result\\.cc$'],
        ['include', '^public/common/ssl_status\\.cc$'],
        ['include', '^public/common/url_constants\\.cc$'],
        ['include', '^common/content_paths\\.cc$'],
        ['include', '^common/media/media_stream_options\\.cc$'],
        ['include', '^common/net/url_fetcher\\.cc$'],
        ['include', '^common/net/url_request_user_data\\.cc$'],
        ['include', '^common/page_state_serialization\\.cc$'],
        ['include', '^common/savable_url_schemes\\.cc$'],
        ['include', '^common/url_schemes\\.cc$'],
      ],
    }, {  # OS!="ios"
      'dependencies': [
        '../cc/cc.gyp:cc',
        '../gpu/blink/gpu_blink.gyp:gpu_blink',
        '../gpu/gpu.gyp:command_buffer_service',
        '../gpu/gpu.gyp:gles2_c_lib',
        '../gpu/gpu.gyp:gles2_implementation',
        # TODO: the dependency on gl_in_process_context should be decoupled from
        # content and moved to android_webview. See crbug.com/365797.
        '../gpu/gpu.gyp:gl_in_process_context',
        '../gpu/gpu.gyp:gpu_ipc',
        '../gpu/skia_bindings/skia_bindings.gyp:gpu_skia_bindings',
        '../ipc/ipc.gyp:ipc',
        '../ipc/mojo/ipc_mojo.gyp:ipc_mojo',
        '../media/media.gyp:media',
        '../media/media.gyp:shared_memory_support',
        '../mojo/mojo_base.gyp:mojo_environment_chromium',
        '../storage/storage_common.gyp:storage_common',
        '../third_party/WebKit/public/blink.gyp:blink',
        '../third_party/mojo/mojo_edk.gyp:mojo_system_impl',
        '../third_party/mojo/mojo_public.gyp:mojo_application_bindings',
        '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
        '../ui/gl/gl.gyp:gl',
        '../webkit/common/gpu/webkit_gpu.gyp:webkit_gpu',
      ],
      'export_dependent_settings' : [
        '../third_party/mojo/mojo_public.gyp:mojo_application_bindings',
        '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
      ],
      'actions': [
        {
          'action_name': 'generate_webkit_version',
          'inputs': [
            '<(script)',
            '<(lastchange)',
            '<(template)',
          ],
          'outputs': [
            '<(SHARED_INTERMEDIATE_DIR)/webkit_version.h',
          ],
          'action': ['python',
                     '<(script)',
                     '-f', '<(lastchange)',
                     '<(template)',
                     '<@(_outputs)',
          ],
          'variables': {
            'script': '<(DEPTH)/build/util/version.py',
            'lastchange': '<(DEPTH)/build/util/LASTCHANGE.blink',
            'template': 'webkit_version.h.in',
          },
        },
      ],
    }],
    ['OS=="mac"', {
      'dependencies': [
        '../media/media.gyp:media',
        'app/resources/content_resources.gyp:content_resources',
        '../ui/accelerated_widget_mac/accelerated_widget_mac.gyp:accelerated_widget_mac'
      ],
      'sources': [
        'common/gpu/client/gpu_memory_buffer_impl_io_surface.cc',
        'common/gpu/client/gpu_memory_buffer_impl_io_surface.h',
        'common/gpu/gpu_memory_buffer_factory_io_surface.cc',
        'common/gpu/gpu_memory_buffer_factory_io_surface.h',
        'common/gpu/media/vt.h',
        'common/gpu/media/vt_video_decode_accelerator.cc',
        'common/gpu/media/vt_video_decode_accelerator.h',
      ],
      'sources!': [
        'common/plugin_list_posix.cc',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/System/Library/Frameworks/IOSurface.framework',
          '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
        ],
      },
      'variables': {
        'generate_stubs_script': '../tools/generate_stubs/generate_stubs.py',
        'extra_header': 'common/gpu/media/vt_stubs_header.fragment',
        'sig_files': ['common/gpu/media/vt.sig'],
        'outfile_type': 'posix_stubs',
        'stubs_filename_root': 'vt_stubs',
        'project_path': 'content/common/gpu/media',
        'intermediate_dir': '<(INTERMEDIATE_DIR)',
        'output_root': '<(SHARED_INTERMEDIATE_DIR)/vt_stubs',
      },
      'include_dirs': [
        '<(output_root)',
      ],
      'actions': [
        {
          'action_name': 'generate_stubs',
          'inputs': [
            '<(generate_stubs_script)',
            '<(extra_header)',
            '<@(sig_files)',
          ],
          'outputs': [
            '<(intermediate_dir)/<(stubs_filename_root).cc',
            '<(output_root)/<(project_path)/<(stubs_filename_root).h',
          ],
          'action': ['python',
                     '<(generate_stubs_script)',
                     '-i', '<(intermediate_dir)',
                     '-o', '<(output_root)/<(project_path)',
                     '-t', '<(outfile_type)',
                     '-e', '<(extra_header)',
                     '-s', '<(stubs_filename_root)',
                     '-p', '<(project_path)',
                     '<@(_inputs)',
          ],
          'process_outputs_as_sources': 1,
          'message': 'Generating VideoToolbox stubs for dynamic loading',
        },
      ],
    }],
    ['OS=="android"',{
      'sources': [
        'common/gpu/client/gpu_memory_buffer_impl_surface_texture.cc',
        'common/gpu/client/gpu_memory_buffer_impl_surface_texture.h',
        'common/gpu/gpu_memory_buffer_factory_surface_texture.cc',
        'common/gpu/gpu_memory_buffer_factory_surface_texture.h',
      ],
      'link_settings': {
        'libraries': [
          '-landroid',  # ANativeWindow
        ],
      },
     'dependencies': [
        'content.gyp:content_jni_headers',
        'content.gyp:common_aidl',
      ],
    }],
    ['use_pango == 1', {
      'dependencies': [
        '../build/linux/system.gyp:pangocairo',
      ],
      'sources!': [
        'common/font_list_ozone.cc',
      ],
    }],
    ['use_x11 == 1', {
      'include_dirs': [
        '<(DEPTH)/third_party/khronos',
      ],
      'dependencies': [
         '<(DEPTH)/build/linux/system.gyp:xcomposite',
      ],
    }],
    ['use_x11 == 1 and (target_arch != "arm" or chromeos == 0)', {
      'sources': [
        'common/gpu/x_util.h',
      ],
    }],
    ['enable_plugins==1', {
      'dependencies': [
        '../ppapi/ppapi_internal.gyp:ppapi_shared',
      ],
    }, {  # enable_plugins == 0
      'sources!': [
        'common/pepper_file_util.cc',
        'common/pepper_file_util.h',
        'common/pepper_messages.h',
        'common/pepper_plugin_list.cc',
        'common/pepper_plugin_list.h',
        'common/pepper_renderer_instance_data.cc',
        'common/pepper_renderer_instance_data.h',
        'common/plugin_list.cc',
        'common/plugin_list.h',
        'common/plugin_list_posix.cc',
        'common/sandbox_util.cc',
        'public/common/pepper_plugin_info.cc',
        'public/common/pepper_plugin_info.h',
      ],
    }],
    ['OS=="android"', {
      'dependencies': [
        '../media/media.gyp:media',
      ],
      'sources': [
        'common/gpu/media/android_video_decode_accelerator.cc',
        'common/gpu/media/android_video_decode_accelerator.h',
      ],
    }],
    ['OS=="android" and enable_webrtc==1', {
      'dependencies': [
        '../third_party/libyuv/libyuv.gyp:libyuv',
      ],
      'sources': [
        'common/gpu/media/android_video_encode_accelerator.cc',
        'common/gpu/media/android_video_encode_accelerator.h',
      ],
    }],
    ['enable_webrtc==1', {
      'dependencies': [
        '../third_party/libjingle/libjingle.gyp:libjingle',
      ],
    }],
    ['use_v4lplugin==1 and chromeos==1', {
      'defines': [
        'USE_LIBV4L2'
      ],
      'variables': {
        'generate_stubs_script': '../tools/generate_stubs/generate_stubs.py',
        'extra_header': 'common/gpu/media/v4l2_stub_header.fragment',
        'sig_files': ['common/gpu/media/v4l2.sig'],
        'outfile_type': 'posix_stubs',
        'stubs_filename_root': 'v4l2_stubs',
        'project_path': 'content/common/gpu/media',
        'intermediate_dir': '<(INTERMEDIATE_DIR)',
        'output_root': '<(SHARED_INTERMEDIATE_DIR)/v4l2',
      },
      'include_dirs': [
        '<(output_root)',
      ],
      'actions': [
        {
          'action_name': 'generate_stubs',
          'inputs': [
            '<(generate_stubs_script)',
            '<(extra_header)',
            '<@(sig_files)',
          ],
          'outputs': [
            '<(intermediate_dir)/<(stubs_filename_root).cc',
            '<(output_root)/<(project_path)/<(stubs_filename_root).h',
          ],
          'action': ['python',
            '<(generate_stubs_script)',
            '-i', '<(intermediate_dir)',
            '-o', '<(output_root)/<(project_path)',
            '-t', '<(outfile_type)',
            '-e', '<(extra_header)',
            '-s', '<(stubs_filename_root)',
            '-p', '<(project_path)',
            '<@(_inputs)',
          ],
          'process_outputs_as_sources': 1,
          'message': 'Generating libv4l2 stubs for dynamic loading',
        },
      ],
    }],
    ['chromeos==1 and use_v4l2_codec==1', {
      'direct_dependent_settings': {
        'defines': [
          'USE_V4L2_CODEC'
        ],
      },
      'defines': [
        'USE_V4L2_CODEC'
      ],
      'dependencies': [
        '../media/media.gyp:media',
      ],
      'sources': [
        'common/gpu/media/accelerated_video_decoder.h',
        'common/gpu/media/generic_v4l2_device.cc',
        'common/gpu/media/generic_v4l2_device.h',
        'common/gpu/media/h264_decoder.cc',
        'common/gpu/media/h264_decoder.h',
        'common/gpu/media/h264_dpb.cc',
        'common/gpu/media/h264_dpb.h',
        'common/gpu/media/v4l2_device.cc',
        'common/gpu/media/v4l2_device.h',
        'common/gpu/media/v4l2_image_processor.cc',
        'common/gpu/media/v4l2_image_processor.h',
        'common/gpu/media/v4l2_slice_video_decode_accelerator.cc',
        'common/gpu/media/v4l2_slice_video_decode_accelerator.h',
        'common/gpu/media/v4l2_video_decode_accelerator.cc',
        'common/gpu/media/v4l2_video_decode_accelerator.h',
        'common/gpu/media/v4l2_video_encode_accelerator.cc',
        'common/gpu/media/v4l2_video_encode_accelerator.h',
        'common/gpu/media/vp8_decoder.cc',
        'common/gpu/media/vp8_decoder.h',
        'common/gpu/media/vp8_picture.cc',
        'common/gpu/media/vp8_picture.h',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/khronos',
      ],
    }],
    ['target_arch == "arm" and chromeos == 1', {
      'sources': [
        'common/gpu/media/tegra_v4l2_device.cc',
        'common/gpu/media/tegra_v4l2_device.h',
      ],
    }],
    ['target_arch != "arm" and chromeos == 1', {
      'dependencies': [
        '../media/media.gyp:media',
        '../third_party/libyuv/libyuv.gyp:libyuv',
      ],
      'sources': [
        'common/gpu/media/va_surface.h',
        'common/gpu/media/vaapi_h264_decoder.cc',
        'common/gpu/media/vaapi_h264_decoder.h',
        'common/gpu/media/vaapi_h264_dpb.cc',
        'common/gpu/media/vaapi_h264_dpb.h',
        'common/gpu/media/vaapi_jpeg_decoder.cc',
        'common/gpu/media/vaapi_jpeg_decoder.h',
        'common/gpu/media/vaapi_picture.cc',
        'common/gpu/media/vaapi_picture.h',
        'common/gpu/media/vaapi_video_decode_accelerator.cc',
        'common/gpu/media/vaapi_video_decode_accelerator.h',
        'common/gpu/media/vaapi_video_encode_accelerator.cc',
        'common/gpu/media/vaapi_video_encode_accelerator.h',
        'common/gpu/media/vaapi_wrapper.cc',
        'common/gpu/media/vaapi_wrapper.h',
      ],
      'conditions': [
        ['use_x11 == 1', {
          'variables': {
            'sig_files': [
              'common/gpu/media/va.sigs',
              'common/gpu/media/va_x11.sigs',
            ],
          },
          'sources': [
            'common/gpu/media/vaapi_tfp_picture.cc',
            'common/gpu/media/vaapi_tfp_picture.h',
          ],
        }, {
          'variables': {
            'sig_files': [
              'common/gpu/media/va.sigs',
              'common/gpu/media/va_drm.sigs',
            ],
          },
          'sources': [
            'common/gpu/media/vaapi_drm_picture.cc',
            'common/gpu/media/vaapi_drm_picture.h',
          ],
        }],
      ],
      'variables': {
        'generate_stubs_script': '../tools/generate_stubs/generate_stubs.py',
        'extra_header': 'common/gpu/media/va_stub_header.fragment',
        'outfile_type': 'posix_stubs',
        'stubs_filename_root': 'va_stubs',
        'project_path': 'content/common/gpu/media',
        'intermediate_dir': '<(INTERMEDIATE_DIR)',
        'output_root': '<(SHARED_INTERMEDIATE_DIR)/va',
      },
      'include_dirs': [
        '<(DEPTH)/third_party/libva',
        '<(DEPTH)/third_party/libyuv',
        '<(output_root)',
      ],
      'actions': [
        {
          'action_name': 'generate_stubs',
          'inputs': [
            '<(generate_stubs_script)',
            '<(extra_header)',
            '<@(sig_files)',
          ],
          'outputs': [
            '<(intermediate_dir)/<(stubs_filename_root).cc',
            '<(output_root)/<(project_path)/<(stubs_filename_root).h',
          ],
          'action': ['python',
                     '<(generate_stubs_script)',
                     '-i', '<(intermediate_dir)',
                     '-o', '<(output_root)/<(project_path)',
                     '-t', '<(outfile_type)',
                     '-e', '<(extra_header)',
                     '-s', '<(stubs_filename_root)',
                     '-p', '<(project_path)',
                     '<@(_inputs)',
          ],
          'process_outputs_as_sources': 1,
          'message': 'Generating libva stubs for dynamic loading',
        },
     ]
    }],
    ['OS=="win"', {
      'dependencies': [
        '../media/media.gyp:media',
        '../ui/gl/gl.gyp:gl',
      ],
      'link_settings': {
        'libraries': [
           '-ld3d9.lib',
           '-ld3d11.lib',
           '-ldxva2.lib',
           '-lstrmiids.lib',
           '-lmf.lib',
           '-lmfplat.lib',
           '-lmfuuid.lib',
        ],
        'msvs_settings': {
          'VCLinkerTool': {
            'DelayLoadDLLs': [
              'd3d9.dll',
			  'd3d11.dll',
              'dxva2.dll',
              'mf.dll',
              'mfplat.dll',
            ],
          },
        },
      },
      'sources': [
        'common/gpu/media/dxva_video_decode_accelerator.cc',
        'common/gpu/media/dxva_video_decode_accelerator.h',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/khronos',
      ],
    }],
    ['OS=="win" and directxsdk_exists=="True"', {
      'actions': [
      {
        'action_name': 'extract_xinput',
        'variables': {
          'input': 'APR2007_xinput_<(winsdk_arch).cab',
          'output': 'xinput1_3.dll',
        },
        'inputs': [
          '../third_party/directxsdk/files/Redist/<(input)',
        ],
        'outputs': [
          '<(PRODUCT_DIR)/<(output)',
        ],
        'action': [
          'python',
        '../build/extract_from_cab.py',
        '..\\third_party\\directxsdk\\files\\Redist\\<(input)',
        '<(output)',
        '<(PRODUCT_DIR)',
        ],
      },
     ]
    }],
    ['use_seccomp_bpf==0', {
      'sources!': [
        'common/sandbox_linux/android/sandbox_bpf_base_policy_android.cc',
        'common/sandbox_linux/android/sandbox_bpf_base_policy_android.h',
        'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.cc',
        'common/sandbox_linux/bpf_cros_arm_gpu_policy_linux.h',
        'common/sandbox_linux/bpf_gpu_policy_linux.cc',
        'common/sandbox_linux/bpf_gpu_policy_linux.h',
        'common/sandbox_linux/bpf_ppapi_policy_linux.cc',
        'common/sandbox_linux/bpf_ppapi_policy_linux.h',
        'common/sandbox_linux/bpf_renderer_policy_linux.cc',
        'common/sandbox_linux/bpf_renderer_policy_linux.h',
        'common/sandbox_linux/bpf_utility_policy_linux.cc',
        'common/sandbox_linux/bpf_utility_policy_linux.h',
        'common/sandbox_linux/sandbox_bpf_base_policy_linux.cc',
        'common/sandbox_linux/sandbox_bpf_base_policy_linux.h',
      ],
    }, {
      'defines': ['USE_SECCOMP_BPF'],
    }],
    ['use_ozone==1', {
      'dependencies': [
        '../ui/ozone/ozone.gyp:ozone',
        '../ui/ozone/ozone.gyp:ozone_base',
        '../ui/ozone/gpu/ozone_gpu.gyp:ozone_gpu',
      ],
      'sources!': [
        'common/gpu/client/gpu_memory_buffer_impl_linux.cc',
        'common/gpu/gpu_memory_buffer_factory_linux.cc',
      ],
    }, {  # use_ozone!=1
      'sources!': [
        'common/cursors/webcursor_ozone.cc',
        'common/font_list_ozone.cc',
        'common/gpu/client/gpu_memory_buffer_impl_ozone.cc',
        'common/gpu/client/gpu_memory_buffer_impl_ozone_native_buffer.cc',
        'common/gpu/client/gpu_memory_buffer_impl_ozone_native_buffer.h',
        'common/gpu/gpu_memory_buffer_factory_ozone.cc',
        'common/gpu/gpu_memory_buffer_factory_ozone_native_buffer.cc',
        'common/gpu/gpu_memory_buffer_factory_ozone_native_buffer.h',
      ],
    }],
  ],
}
