/* Copyright (c) 2015, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

 /* This file was generated by err_data_generate.go. */

#include <openssl/base.h>
#include <openssl/err.h>
#include <openssl/type_check.h>


OPENSSL_COMPILE_ASSERT(ERR_LIB_NONE == 1, library_values_changed_1);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SYS == 2, library_values_changed_2);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BN == 3, library_values_changed_3);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RSA == 4, library_values_changed_4);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DH == 5, library_values_changed_5);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EVP == 6, library_values_changed_6);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BUF == 7, library_values_changed_7);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OBJ == 8, library_values_changed_8);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PEM == 9, library_values_changed_9);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DSA == 10, library_values_changed_10);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509 == 11, library_values_changed_11);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ASN1 == 12, library_values_changed_12);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CONF == 13, library_values_changed_13);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CRYPTO == 14, library_values_changed_14);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EC == 15, library_values_changed_15);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SSL == 16, library_values_changed_16);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BIO == 17, library_values_changed_17);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS7 == 18, library_values_changed_18);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS8 == 19, library_values_changed_19);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509V3 == 20, library_values_changed_20);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RAND == 21, library_values_changed_21);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ENGINE == 22, library_values_changed_22);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OCSP == 23, library_values_changed_23);
OPENSSL_COMPILE_ASSERT(ERR_LIB_UI == 24, library_values_changed_24);
OPENSSL_COMPILE_ASSERT(ERR_LIB_COMP == 25, library_values_changed_25);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDSA == 26, library_values_changed_26);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDH == 27, library_values_changed_27);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HMAC == 28, library_values_changed_28);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DIGEST == 29, library_values_changed_29);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CIPHER == 30, library_values_changed_30);
OPENSSL_COMPILE_ASSERT(ERR_LIB_USER == 31, library_values_changed_31);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HKDF == 32, library_values_changed_32);
OPENSSL_COMPILE_ASSERT(ERR_NUM_LIBS == 33, library_values_changed_num);

const uint32_t kOpenSSLFunctionValues[] = {
    0xc320540,
    0xc32854b,
    0xc330556,
    0xc338563,
    0xc34056d,
    0xc348577,
    0xc35057e,
    0xc35858a,
    0xc360591,
    0xc3685a7,
    0xc3705bc,
    0xc3785cd,
    0xc3805dd,
    0xc3885f7,
    0xc39060c,
    0xc39861b,
    0xc3a0634,
    0xc3a8648,
    0xc3b0654,
    0xc3b865b,
    0xc3c0663,
    0xc3c8671,
    0xc3d0679,
    0xc3d8681,
    0xc3e068c,
    0x103217ce,
    0x103297e5,
    0x103317fe,
    0x10339814,
    0x10341824,
    0x10349837,
    0x10351845,
    0x10359854,
    0x10361874,
    0x10369893,
    0x103718b0,
    0x103798cd,
    0x103818e2,
    0x10389904,
    0x10391923,
    0x10399942,
    0x103a1959,
    0x103a9970,
    0x103b1979,
    0x103b9984,
    0x103c199e,
    0x103c99a6,
    0x103d19ae,
    0x103d99b5,
    0x103e19c8,
    0x103e99da,
    0x103f19ed,
    0x103f99f6,
    0x14320a25,
    0x14328a33,
    0x14330a3f,
    0x14338a4c,
    0x18321065,
    0x1832907d,
    0x1833109f,
    0x183390b1,
    0x183410e3,
    0x183490fc,
    0x1835110d,
    0x18359123,
    0x18361133,
    0x18369148,
    0x18371161,
    0x18379172,
    0x18381188,
    0x18389199,
    0x183911ab,
    0x183991c0,
    0x183a11d2,
    0x183a91e2,
    0x183b11f7,
    0x183b9204,
    0x183c1216,
    0x183c9224,
    0x183d1237,
    0x183d9247,
    0x183e125c,
    0x183e926d,
    0x183f1280,
    0x183f928f,
    0x1840129f,
    0x184092ac,
    0x184112bb,
    0x184192cc,
    0x184212df,
    0x184292f1,
    0x18431303,
    0x18439314,
    0x18441325,
    0x18449336,
    0x18451347,
    0x18459354,
    0x18461362,
    0x18469375,
    0x18471389,
    0x18479396,
    0x184813a5,
    0x184893b4,
    0x184913c5,
    0x184993e1,
    0x184a13ef,
    0x184a9400,
    0x184b1411,
    0x184b941f,
    0x184c142f,
    0x184c9455,
    0x184d1464,
    0x184d9474,
    0x184e1484,
    0x184e9493,
    0x184f13d2,
    0x184f90c2,
    0x1c320699,
    0x1c3286a5,
    0x1c3306b0,
    0x1c3386bc,
    0x203214a7,
    0x203294b2,
    0x203314ba,
    0x203394c6,
    0x243214d2,
    0x243294e0,
    0x243314f2,
    0x24339501,
    0x24341514,
    0x24349527,
    0x2435153e,
    0x24359556,
    0x24361564,
    0x2436957c,
    0x24371585,
    0x24379597,
    0x243815ab,
    0x243895b8,
    0x243915ce,
    0x243995e6,
    0x243a15fe,
    0x243a9608,
    0x243b161d,
    0x243b962b,
    0x243c1643,
    0x243c965a,
    0x243d1665,
    0x243d9673,
    0x28320a85,
    0x28328a94,
    0x28330a9f,
    0x28338aa4,
    0x28340aaf,
    0x2c3228da,
    0x2c32a8e6,
    0x2c3328f9,
    0x2c33a90a,
    0x2c342923,
    0x2c34a94b,
    0x2c352962,
    0x2c35a97f,
    0x2c36299c,
    0x2c36a9b9,
    0x2c3729d2,
    0x2c37a9eb,
    0x2c382a01,
    0x2c38aa0f,
    0x2c392a21,
    0x2c39aa3e,
    0x2c3a2a5b,
    0x2c3aaa69,
    0x2c3b2a87,
    0x2c3baaa5,
    0x2c3c2ac0,
    0x2c3caad4,
    0x2c3d2ae6,
    0x2c3daaf6,
    0x2c3e2b04,
    0x2c3eab14,
    0x2c3f2b24,
    0x2c3fab3f,
    0x2c402b50,
    0x2c40ab6b,
    0x2c412b7f,
    0x2c41ab92,
    0x2c422bb1,
    0x2c42abc5,
    0x2c432bd8,
    0x2c43abe7,
    0x2c442bf6,
    0x2c44ac0d,
    0x2c452c28,
    0x2c45ac40,
    0x2c462c54,
    0x2c46ac67,
    0x2c472c78,
    0x2c47ac89,
    0x2c482c9a,
    0x2c48acab,
    0x2c492cba,
    0x2c49acc7,
    0x2c4a2cd4,
    0x2c4aace1,
    0x2c4b2cea,
    0x2c4bacfe,
    0x2c4c2d0d,
    0x2c4cad1b,
    0x2c4d2d3d,
    0x2c4dad4e,
    0x2c4e2d5f,
    0x2c4ead2a,
    0x2c4f293c,
    0x30320000,
    0x30328018,
    0x3033002c,
    0x30338042,
    0x3034005b,
    0x3034806c,
    0x3035007f,
    0x3035808f,
    0x3036009d,
    0x303680b3,
    0x303700c3,
    0x303780d8,
    0x303800e6,
    0x303880f7,
    0x30390103,
    0x3039810c,
    0x303a011d,
    0x303a812d,
    0x303b013a,
    0x303b8146,
    0x303c0157,
    0x303c8165,
    0x303d0176,
    0x303d8188,
    0x303e0199,
    0x303e81a8,
    0x303f01b9,
    0x303f81cd,
    0x304001df,
    0x304081ec,
    0x30410202,
    0x30418215,
    0x30420225,
    0x30428239,
    0x3043024a,
    0x3043825a,
    0x30440265,
    0x3044826d,
    0x3045027d,
    0x30458294,
    0x304602a1,
    0x304682b7,
    0x304702c9,
    0x304782d5,
    0x304802e1,
    0x304882ef,
    0x30490308,
    0x30498316,
    0x304a032b,
    0x304a8343,
    0x304b034d,
    0x304b8361,
    0x304c0372,
    0x304c8382,
    0x304d038f,
    0x304d83a0,
    0x304e03b0,
    0x304e83c2,
    0x304f03d3,
    0x304f83e2,
    0x305003f6,
    0x30508404,
    0x30510413,
    0x3051841c,
    0x343209b7,
    0x343289c7,
    0x343309d2,
    0x343389df,
    0x383209e8,
    0x383289fb,
    0x38330a05,
    0x38338a17,
    0x3c320ab6,
    0x3c328ac4,
    0x3c330adb,
    0x3c338aef,
    0x3c340b0a,
    0x3c348b1b,
    0x3c350b27,
    0x3c358b3b,
    0x3c360b4d,
    0x3c368b76,
    0x3c370b83,
    0x3c378b90,
    0x3c380b9e,
    0x3c388bab,
    0x3c390bb8,
    0x3c398bdc,
    0x3c3a0bec,
    0x3c3a8c04,
    0x3c3b0c19,
    0x3c3b8c2e,
    0x3c3c0c3b,
    0x3c3c8c4e,
    0x3c3d0c61,
    0x3c3d8c85,
    0x3c3e0cad,
    0x3c3e8cc6,
    0x3c3f0cdc,
    0x3c3f8ce9,
    0x3c400cfc,
    0x3c408d0d,
    0x3c410d1e,
    0x3c418d37,
    0x3c420d50,
    0x3c428d66,
    0x3c430d83,
    0x3c438d99,
    0x3c440db5,
    0x3c448ddc,
    0x3c450dfa,
    0x3c458e14,
    0x3c460e2c,
    0x3c468e44,
    0x3c470e6f,
    0x3c478e9a,
    0x3c480ebb,
    0x3c488ee4,
    0x3c490eff,
    0x3c498f1a,
    0x3c4a0f27,
    0x3c4a8f3e,
    0x3c4b0f55,
    0x3c4b8f7e,
    0x3c4c0f8e,
    0x3c4c8f9a,
    0x3c4d0fb2,
    0x3c4d8fc5,
    0x3c4e0fd6,
    0x3c4e8fe7,
    0x3c4f0ff7,
    0x40321a01,
    0x40329a1b,
    0x40331a27,
    0x40339a3f,
    0x40341a5d,
    0x40349a7c,
    0x40351a93,
    0x40359aaf,
    0x40361acb,
    0x40369ae5,
    0x40371b04,
    0x40379b23,
    0x40381b3b,
    0x40389b58,
    0x40391b7b,
    0x40399b98,
    0x403a1bb6,
    0x403a9bc6,
    0x403b1bdb,
    0x403b9bf7,
    0x403c1c11,
    0x403c9c1c,
    0x403d1c3f,
    0x403d9c63,
    0x403e1c79,
    0x403e9c83,
    0x403f1c8f,
    0x403f9ca0,
    0x40401cb8,
    0x40409cc0,
    0x40411cc9,
    0x40419cd2,
    0x40421ce2,
    0x40429cf6,
    0x40431d01,
    0x40439d0d,
    0x40441d28,
    0x40449d34,
    0x40451d41,
    0x40459d54,
    0x40461d6c,
    0x40469d84,
    0x40471d9a,
    0x40479db5,
    0x40481dd0,
    0x40489de4,
    0x40491dfd,
    0x40499e16,
    0x404a1e30,
    0x404a9e3a,
    0x404b1e4a,
    0x404b9e6b,
    0x404c1e86,
    0x404c9e94,
    0x404d1ea1,
    0x404d9eb5,
    0x404e1ecd,
    0x404e9edb,
    0x404f1f05,
    0x404f9f1c,
    0x40501f2e,
    0x40509f5f,
    0x40511f90,
    0x40519fa5,
    0x40521fb6,
    0x40529fd6,
    0x40531ff1,
    0x4053a001,
    0x4054200d,
    0x4054a020,
    0x40552036,
    0x4055a054,
    0x40562061,
    0x4056a06b,
    0x40572079,
    0x4057a094,
    0x405820af,
    0x4058a0ce,
    0x405920e3,
    0x4059a0f8,
    0x405a2115,
    0x405aa129,
    0x405b2145,
    0x405ba15b,
    0x405c2178,
    0x405ca18a,
    0x405d21a1,
    0x405da1b2,
    0x405e21ce,
    0x405ea1e2,
    0x405f21f2,
    0x405fa20e,
    0x40602223,
    0x4060a239,
    0x40612256,
    0x4061a26f,
    0x40622282,
    0x4062a28b,
    0x4063229b,
    0x4063a2a7,
    0x406422bd,
    0x4064a2db,
    0x406522f0,
    0x4065a30d,
    0x40662324,
    0x4066a342,
    0x4067235f,
    0x4067a376,
    0x40682394,
    0x4068a3ab,
    0x406923c3,
    0x4069a3d4,
    0x406a23e7,
    0x406aa3fa,
    0x406b240e,
    0x406ba432,
    0x406c244d,
    0x406ca46e,
    0x406d2492,
    0x406da4ad,
    0x406e24ce,
    0x406ea4e3,
    0x406f24fc,
    0x406fa509,
    0x40702517,
    0x4070a524,
    0x40712541,
    0x4071a561,
    0x4072257c,
    0x4072a595,
    0x407325ac,
    0x4073a5c6,
    0x407425ea,
    0x4074a600,
    0x40752614,
    0x4075a629,
    0x40762643,
    0x4076a655,
    0x4077266a,
    0x4077a690,
    0x407826ad,
    0x4078a6d0,
    0x407926f6,
    0x4079a713,
    0x407a2736,
    0x407aa752,
    0x407b276e,
    0x407ba780,
    0x407c278d,
    0x407ca79a,
    0x407d27b7,
    0x407da7ce,
    0x407e27ea,
    0x407ea800,
    0x407f2818,
    0x407fa82b,
    0x40802840,
    0x4080a859,
    0x40812877,
    0x4081a897,
    0x408228a0,
    0x4082a8bc,
    0x408328c5,
    0x40839eea,
    0x40841f79,
    0x40849f49,
    0x4432042a,
    0x4432843c,
    0x44330445,
    0x4433844d,
    0x4434045a,
    0x4434846a,
    0x44350485,
    0x443584a5,
    0x443604c1,
    0x443684e2,
    0x443704e9,
    0x443784f7,
    0x44380501,
    0x4438850d,
    0x44390517,
    0x44398522,
    0x443a052c,
    0x443a8536,
    0x4c32167b,
    0x4c32968a,
    0x4c331699,
    0x4c3396b2,
    0x4c3416cd,
    0x4c3496e9,
    0x4c3516fb,
    0x4c359709,
    0x4c36171e,
    0x4c36972f,
    0x4c37173d,
    0x4c37974b,
    0x4c38175d,
    0x4c38976d,
    0x4c391777,
    0x4c39978f,
    0x4c3a17a7,
    0x4c3a97ba,
    0x50322d70,
    0x5032ad85,
    0x50332d96,
    0x5033ada9,
    0x50342dba,
    0x5034adcd,
    0x50352ddc,
    0x5035adf1,
    0x50362e01,
    0x5036ae10,
    0x50372e21,
    0x5037ae31,
    0x50382e42,
    0x5038ae55,
    0x50392e67,
    0x5039ae7d,
    0x503a2e8f,
    0x503aaea0,
    0x503b2eb1,
    0x503baec2,
    0x503c2ecd,
    0x503caed9,
    0x503d2ee4,
    0x503daeef,
    0x503e2efc,
    0x503eaf11,
    0x503f2f1f,
    0x503faf33,
    0x50402f46,
    0x5040af57,
    0x50412f71,
    0x5041af80,
    0x50422f89,
    0x5042af98,
    0x50432faa,
    0x5043afb6,
    0x50442fbe,
    0x5044afd1,
    0x50452fe2,
    0x5045aff8,
    0x50463004,
    0x5046b018,
    0x50473026,
    0x5047b03a,
    0x50483054,
    0x5048b068,
    0x5049307e,
    0x5049b095,
    0x504a30a7,
    0x504ab0bb,
    0x504b30d0,
    0x504bb0e7,
    0x504c30fb,
    0x504cb104,
    0x504d310c,
    0x504db11b,
    0x504e312b,
    0x68321018,
    0x68329029,
    0x68331039,
    0x68339047,
    0x68341054,
    0x6c321007,
    0x74320a60,
    0x74328a72,
    0x783206c9,
    0x783286fc,
    0x7833070e,
    0x78338720,
    0x78340734,
    0x78348748,
    0x78350766,
    0x78358778,
    0x7836078c,
    0x783687fa,
    0x7837080c,
    0x7837881e,
    0x78380830,
    0x78388847,
    0x7839085e,
    0x78398875,
    0x783a0891,
    0x783a88ad,
    0x783b08c9,
    0x783b88df,
    0x783c08f5,
    0x783c890b,
    0x783d0928,
    0x783d8937,
    0x783e0946,
    0x783e8955,
    0x783f0971,
    0x783f897f,
    0x7840098d,
    0x7840899b,
    0x784109a8,
    0x784186db,
    0x784207a0,
    0x784287be,
    0x784307dc,
    0x803214a2,
};

const size_t kOpenSSLFunctionValuesLen = sizeof(kOpenSSLFunctionValues) / sizeof(kOpenSSLFunctionValues[0]);

const char kOpenSSLFunctionStringData[] =
    "ASN1_BIT_STRING_set_bit\0"
    "ASN1_ENUMERATED_set\0"
    "ASN1_ENUMERATED_to_BN\0"
    "ASN1_GENERALIZEDTIME_adj\0"
    "ASN1_INTEGER_set\0"
    "ASN1_INTEGER_to_BN\0"
    "ASN1_OBJECT_new\0"
    "ASN1_PCTX_new\0"
    "ASN1_STRING_TABLE_add\0"
    "ASN1_STRING_set\0"
    "ASN1_STRING_type_new\0"
    "ASN1_TIME_adj\0"
    "ASN1_UTCTIME_adj\0"
    "ASN1_d2i_fp\0"
    "ASN1_dup\0"
    "ASN1_generate_v3\0"
    "ASN1_get_object\0"
    "ASN1_i2d_bio\0"
    "ASN1_i2d_fp\0"
    "ASN1_item_d2i_fp\0"
    "ASN1_item_dup\0"
    "ASN1_item_ex_d2i\0"
    "ASN1_item_i2d_bio\0"
    "ASN1_item_i2d_fp\0"
    "ASN1_item_pack\0"
    "ASN1_item_unpack\0"
    "ASN1_mbstring_ncopy\0"
    "ASN1_template_new\0"
    "BIO_new_NDEF\0"
    "BN_to_ASN1_ENUMERATED\0"
    "BN_to_ASN1_INTEGER\0"
    "a2d_ASN1_OBJECT\0"
    "a2i_ASN1_ENUMERATED\0"
    "a2i_ASN1_INTEGER\0"
    "a2i_ASN1_STRING\0"
    "append_exp\0"
    "asn1_cb\0"
    "asn1_check_tlen\0"
    "asn1_collate_primitive\0"
    "asn1_collect\0"
    "asn1_d2i_ex_primitive\0"
    "asn1_d2i_read_bio\0"
    "asn1_do_adb\0"
    "asn1_ex_c2i\0"
    "asn1_find_end\0"
    "asn1_item_ex_combine_new\0"
    "asn1_str2type\0"
    "asn1_template_ex_d2i\0"
    "asn1_template_noexp_d2i\0"
    "bitstr_cb\0"
    "c2i_ASN1_BIT_STRING\0"
    "c2i_ASN1_INTEGER\0"
    "c2i_ASN1_OBJECT\0"
    "collect_data\0"
    "d2i_ASN1_BOOLEAN\0"
    "d2i_ASN1_OBJECT\0"
    "d2i_ASN1_UINTEGER\0"
    "d2i_ASN1_UTCTIME\0"
    "d2i_ASN1_bytes\0"
    "d2i_ASN1_type_bytes\0"
    "i2d_ASN1_TIME\0"
    "i2d_PrivateKey\0"
    "long_c2i\0"
    "parse_tagging\0"
    "BIO_callback_ctrl\0"
    "BIO_ctrl\0"
    "BIO_new\0"
    "BIO_new_file\0"
    "BIO_new_mem_buf\0"
    "BIO_zero_copy_get_read_buf\0"
    "BIO_zero_copy_get_read_buf_done\0"
    "BIO_zero_copy_get_write_buf\0"
    "BIO_zero_copy_get_write_buf_done\0"
    "bio_io\0"
    "bio_make_pair\0"
    "bio_write\0"
    "buffer_ctrl\0"
    "conn_ctrl\0"
    "conn_state\0"
    "file_ctrl\0"
    "file_read\0"
    "mem_write\0"
    "BN_CTX_get\0"
    "BN_CTX_new\0"
    "BN_CTX_start\0"
    "BN_bn2dec\0"
    "BN_bn2hex\0"
    "BN_div\0"
    "BN_div_recp\0"
    "BN_exp\0"
    "BN_generate_dsa_nonce\0"
    "BN_generate_prime_ex\0"
    "BN_mod_exp2_mont\0"
    "BN_mod_exp_mont\0"
    "BN_mod_exp_mont_consttime\0"
    "BN_mod_exp_mont_word\0"
    "BN_mod_inverse\0"
    "BN_mod_inverse_no_branch\0"
    "BN_mod_lshift_quick\0"
    "BN_mod_sqrt\0"
    "BN_new\0"
    "BN_rand\0"
    "BN_rand_range\0"
    "BN_sqrt\0"
    "BN_usub\0"
    "bn_wexpand\0"
    "mod_exp_recp\0"
    "BUF_MEM_new\0"
    "BUF_memdup\0"
    "BUF_strndup\0"
    "buf_mem_grow\0"
    "EVP_AEAD_CTX_init\0"
    "EVP_AEAD_CTX_init_with_direction\0"
    "EVP_AEAD_CTX_open\0"
    "EVP_AEAD_CTX_seal\0"
    "EVP_CIPHER_CTX_copy\0"
    "EVP_CIPHER_CTX_ctrl\0"
    "EVP_CIPHER_CTX_set_key_length\0"
    "EVP_CipherInit_ex\0"
    "EVP_DecryptFinal_ex\0"
    "EVP_EncryptFinal_ex\0"
    "aead_aes_ctr_hmac_sha256_init\0"
    "aead_aes_ctr_hmac_sha256_open\0"
    "aead_aes_ctr_hmac_sha256_seal\0"
    "aead_aes_gcm_init\0"
    "aead_aes_gcm_open\0"
    "aead_aes_gcm_seal\0"
    "aead_aes_key_wrap_init\0"
    "aead_aes_key_wrap_open\0"
    "aead_aes_key_wrap_seal\0"
    "aead_chacha20_poly1305_init\0"
    "aead_chacha20_poly1305_open\0"
    "aead_chacha20_poly1305_seal\0"
    "aead_rc4_md5_tls_init\0"
    "aead_rc4_md5_tls_open\0"
    "aead_rc4_md5_tls_seal\0"
    "aead_ssl3_ensure_cipher_init\0"
    "aead_ssl3_init\0"
    "aead_ssl3_open\0"
    "aead_ssl3_seal\0"
    "aead_tls_ensure_cipher_init\0"
    "aead_tls_init\0"
    "aead_tls_open\0"
    "aead_tls_seal\0"
    "aes_init_key\0"
    "aesni_init_key\0"
    "CONF_parse_list\0"
    "NCONF_load\0"
    "def_load_bio\0"
    "str_copy\0"
    "CRYPTO_set_ex_data\0"
    "get_class\0"
    "get_func_pointers\0"
    "get_new_index\0"
    "DH_new_method\0"
    "compute_key\0"
    "generate_key\0"
    "generate_parameters\0"
    "EVP_DigestInit_ex\0"
    "EVP_MD_CTX_copy_ex\0"
    "DSA_new_method\0"
    "dsa_sig_cb\0"
    "sign\0"
    "sign_setup\0"
    "verify\0"
    "EC_GROUP_copy\0"
    "EC_GROUP_get_curve_GFp\0"
    "EC_GROUP_get_degree\0"
    "EC_GROUP_new_by_curve_name\0"
    "EC_KEY_check_key\0"
    "EC_KEY_copy\0"
    "EC_KEY_generate_key\0"
    "EC_KEY_new_method\0"
    "EC_KEY_set_public_key_affine_coordinates\0"
    "EC_POINT_add\0"
    "EC_POINT_cmp\0"
    "EC_POINT_copy\0"
    "EC_POINT_dbl\0"
    "EC_POINT_dup\0"
    "EC_POINT_get_affine_coordinates_GFp\0"
    "EC_POINT_invert\0"
    "EC_POINT_is_at_infinity\0"
    "EC_POINT_is_on_curve\0"
    "EC_POINT_make_affine\0"
    "EC_POINT_new\0"
    "EC_POINT_oct2point\0"
    "EC_POINT_point2oct\0"
    "EC_POINT_set_affine_coordinates_GFp\0"
    "EC_POINT_set_compressed_coordinates_GFp\0"
    "EC_POINT_set_to_infinity\0"
    "EC_POINTs_make_affine\0"
    "compute_wNAF\0"
    "d2i_ECPKParameters\0"
    "d2i_ECParameters\0"
    "d2i_ECPrivateKey\0"
    "ec_GFp_mont_field_decode\0"
    "ec_GFp_mont_field_encode\0"
    "ec_GFp_mont_field_mul\0"
    "ec_GFp_mont_field_set_to_one\0"
    "ec_GFp_mont_field_sqr\0"
    "ec_GFp_mont_group_set_curve\0"
    "ec_GFp_simple_group_check_discriminant\0"
    "ec_GFp_simple_group_set_curve\0"
    "ec_GFp_simple_make_affine\0"
    "ec_GFp_simple_oct2point\0"
    "ec_GFp_simple_point2oct\0"
    "ec_GFp_simple_point_get_affine_coordinates\0"
    "ec_GFp_simple_point_set_affine_coordinates\0"
    "ec_GFp_simple_points_make_affine\0"
    "ec_GFp_simple_set_compressed_coordinates\0"
    "ec_asn1_group2pkparameters\0"
    "ec_asn1_pkparameters2group\0"
    "ec_group_new\0"
    "ec_group_new_curve_GFp\0"
    "ec_group_new_from_data\0"
    "ec_point_set_Jprojective_coordinates_GFp\0"
    "ec_pre_comp_new\0"
    "ec_wNAF_mul\0"
    "ec_wNAF_precompute_mult\0"
    "i2d_ECPKParameters\0"
    "i2d_ECParameters\0"
    "i2d_ECPrivateKey\0"
    "i2o_ECPublicKey\0"
    "o2i_ECPublicKey\0"
    "ECDH_compute_key\0"
    "ECDSA_do_sign_ex\0"
    "ECDSA_do_verify\0"
    "ECDSA_sign_ex\0"
    "digest_to_bn\0"
    "ecdsa_sign_setup\0"
    "EVP_DigestSignAlgorithm\0"
    "EVP_DigestVerifyInitFromAlgorithm\0"
    "EVP_PKEY_CTX_ctrl\0"
    "EVP_PKEY_CTX_dup\0"
    "EVP_PKEY_CTX_get0_rsa_oaep_label\0"
    "EVP_PKEY_copy_parameters\0"
    "EVP_PKEY_decrypt\0"
    "EVP_PKEY_decrypt_init\0"
    "EVP_PKEY_derive\0"
    "EVP_PKEY_derive_init\0"
    "EVP_PKEY_derive_set_peer\0"
    "EVP_PKEY_encrypt\0"
    "EVP_PKEY_encrypt_init\0"
    "EVP_PKEY_get1_DH\0"
    "EVP_PKEY_get1_DSA\0"
    "EVP_PKEY_get1_EC_KEY\0"
    "EVP_PKEY_get1_RSA\0"
    "EVP_PKEY_keygen\0"
    "EVP_PKEY_keygen_init\0"
    "EVP_PKEY_new\0"
    "EVP_PKEY_set_type\0"
    "EVP_PKEY_sign\0"
    "EVP_PKEY_sign_init\0"
    "EVP_PKEY_verify\0"
    "EVP_PKEY_verify_init\0"
    "check_padding_md\0"
    "d2i_AutoPrivateKey\0"
    "d2i_PrivateKey\0"
    "do_EC_KEY_print\0"
    "do_rsa_print\0"
    "do_sigver_init\0"
    "eckey_param2type\0"
    "eckey_param_decode\0"
    "eckey_priv_decode\0"
    "eckey_priv_encode\0"
    "eckey_pub_decode\0"
    "eckey_pub_encode\0"
    "eckey_type2param\0"
    "evp_pkey_ctx_new\0"
    "hmac_signctx\0"
    "i2d_PublicKey\0"
    "old_ec_priv_decode\0"
    "old_rsa_priv_decode\0"
    "pkey_ec_ctrl\0"
    "pkey_ec_derive\0"
    "pkey_ec_keygen\0"
    "pkey_ec_paramgen\0"
    "pkey_ec_sign\0"
    "pkey_hmac_ctrl\0"
    "pkey_rsa_ctrl\0"
    "pkey_rsa_decrypt\0"
    "pkey_rsa_encrypt\0"
    "pkey_rsa_sign\0"
    "rsa_algor_to_md\0"
    "rsa_digest_verify_init_from_algorithm\0"
    "rsa_mgf1_to_md\0"
    "rsa_priv_decode\0"
    "rsa_priv_encode\0"
    "rsa_pss_to_ctx\0"
    "rsa_pub_decode\0"
    "HKDF\0"
    "OBJ_create\0"
    "OBJ_dup\0"
    "OBJ_nid2obj\0"
    "OBJ_txt2obj\0"
    "PEM_ASN1_read\0"
    "PEM_ASN1_read_bio\0"
    "PEM_ASN1_write\0"
    "PEM_ASN1_write_bio\0"
    "PEM_X509_INFO_read\0"
    "PEM_X509_INFO_read_bio\0"
    "PEM_X509_INFO_write_bio\0"
    "PEM_do_header\0"
    "PEM_get_EVP_CIPHER_INFO\0"
    "PEM_read\0"
    "PEM_read_DHparams\0"
    "PEM_read_PrivateKey\0"
    "PEM_read_bio\0"
    "PEM_read_bio_DHparams\0"
    "PEM_read_bio_Parameters\0"
    "PEM_read_bio_PrivateKey\0"
    "PEM_write\0"
    "PEM_write_PrivateKey\0"
    "PEM_write_bio\0"
    "d2i_PKCS8PrivateKey_bio\0"
    "d2i_PKCS8PrivateKey_fp\0"
    "do_pk8pkey\0"
    "do_pk8pkey_fp\0"
    "load_iv\0"
    "EVP_PKCS82PKEY\0"
    "EVP_PKEY2PKCS8\0"
    "PKCS12_get_key_and_certs\0"
    "PKCS12_handle_content_info\0"
    "PKCS12_handle_content_infos\0"
    "PKCS5_pbe2_set_iv\0"
    "PKCS5_pbe_set\0"
    "PKCS5_pbe_set0_algor\0"
    "PKCS5_pbkdf2_set\0"
    "PKCS8_decrypt\0"
    "PKCS8_encrypt\0"
    "PKCS8_encrypt_pbe\0"
    "pbe_cipher_init\0"
    "pbe_crypt\0"
    "pkcs12_item_decrypt_d2i\0"
    "pkcs12_item_i2d_encrypt\0"
    "pkcs12_key_gen_raw\0"
    "pkcs12_pbe_keyivgen\0"
    "BN_BLINDING_convert_ex\0"
    "BN_BLINDING_create_param\0"
    "BN_BLINDING_invert_ex\0"
    "BN_BLINDING_new\0"
    "BN_BLINDING_update\0"
    "RSA_check_key\0"
    "RSA_new_method\0"
    "RSA_padding_add_PKCS1_OAEP_mgf1\0"
    "RSA_padding_add_PKCS1_PSS_mgf1\0"
    "RSA_padding_add_PKCS1_type_1\0"
    "RSA_padding_add_PKCS1_type_2\0"
    "RSA_padding_add_none\0"
    "RSA_padding_check_PKCS1_OAEP_mgf1\0"
    "RSA_padding_check_PKCS1_type_1\0"
    "RSA_padding_check_PKCS1_type_2\0"
    "RSA_padding_check_none\0"
    "RSA_recover_crt_params\0"
    "RSA_sign\0"
    "RSA_verify\0"
    "RSA_verify_PKCS1_PSS_mgf1\0"
    "decrypt\0"
    "encrypt\0"
    "keygen\0"
    "pkcs1_prefixed_msg\0"
    "private_transform\0"
    "rsa_setup_blinding\0"
    "sign_raw\0"
    "verify_raw\0"
    "SSL_CTX_check_private_key\0"
    "SSL_CTX_new\0"
    "SSL_CTX_set_cipher_list\0"
    "SSL_CTX_set_cipher_list_tls11\0"
    "SSL_CTX_set_session_id_context\0"
    "SSL_CTX_use_PrivateKey\0"
    "SSL_CTX_use_PrivateKey_ASN1\0"
    "SSL_CTX_use_PrivateKey_file\0"
    "SSL_CTX_use_RSAPrivateKey\0"
    "SSL_CTX_use_RSAPrivateKey_ASN1\0"
    "SSL_CTX_use_RSAPrivateKey_file\0"
    "SSL_CTX_use_certificate\0"
    "SSL_CTX_use_certificate_ASN1\0"
    "SSL_CTX_use_certificate_chain_file\0"
    "SSL_CTX_use_certificate_file\0"
    "SSL_CTX_use_psk_identity_hint\0"
    "SSL_SESSION_new\0"
    "SSL_SESSION_print_fp\0"
    "SSL_SESSION_set1_id_context\0"
    "SSL_SESSION_to_bytes_full\0"
    "SSL_accept\0"
    "SSL_add_dir_cert_subjects_to_stack\0"
    "SSL_add_file_cert_subjects_to_stack\0"
    "SSL_check_private_key\0"
    "SSL_clear\0"
    "SSL_connect\0"
    "SSL_do_handshake\0"
    "SSL_load_client_CA_file\0"
    "SSL_new\0"
    "SSL_peek\0"
    "SSL_read\0"
    "SSL_renegotiate\0"
    "SSL_set_cipher_list\0"
    "SSL_set_fd\0"
    "SSL_set_rfd\0"
    "SSL_set_session_id_context\0"
    "SSL_set_wfd\0"
    "SSL_shutdown\0"
    "SSL_use_PrivateKey\0"
    "SSL_use_PrivateKey_ASN1\0"
    "SSL_use_PrivateKey_file\0"
    "SSL_use_RSAPrivateKey\0"
    "SSL_use_RSAPrivateKey_ASN1\0"
    "SSL_use_RSAPrivateKey_file\0"
    "SSL_use_certificate\0"
    "SSL_use_certificate_ASN1\0"
    "SSL_use_certificate_file\0"
    "SSL_use_psk_identity_hint\0"
    "SSL_write\0"
    "d2i_SSL_SESSION\0"
    "d2i_SSL_SESSION_get_octet_string\0"
    "d2i_SSL_SESSION_get_string\0"
    "do_ssl3_write\0"
    "dtls1_accept\0"
    "dtls1_buffer_record\0"
    "dtls1_check_timeout_num\0"
    "dtls1_connect\0"
    "dtls1_do_write\0"
    "dtls1_get_buffered_message\0"
    "dtls1_get_hello_verify\0"
    "dtls1_get_message\0"
    "dtls1_get_message_fragment\0"
    "dtls1_hm_fragment_new\0"
    "dtls1_preprocess_fragment\0"
    "dtls1_process_fragment\0"
    "dtls1_process_record\0"
    "dtls1_read_bytes\0"
    "dtls1_send_hello_verify_request\0"
    "dtls1_write_app_data_bytes\0"
    "i2d_SSL_SESSION\0"
    "ssl3_accept\0"
    "ssl3_callback_ctrl\0"
    "ssl3_cert_verify_hash\0"
    "ssl3_check_cert_and_algorithm\0"
    "ssl3_connect\0"
    "ssl3_ctrl\0"
    "ssl3_ctx_ctrl\0"
    "ssl3_digest_cached_records\0"
    "ssl3_do_change_cipher_spec\0"
    "ssl3_expect_change_cipher_spec\0"
    "ssl3_get_cert_status\0"
    "ssl3_get_cert_verify\0"
    "ssl3_get_certificate_request\0"
    "ssl3_get_channel_id\0"
    "ssl3_get_client_certificate\0"
    "ssl3_get_client_hello\0"
    "ssl3_get_client_key_exchange\0"
    "ssl3_get_finished\0"
    "ssl3_get_initial_bytes\0"
    "ssl3_get_message\0"
    "ssl3_get_new_session_ticket\0"
    "ssl3_get_next_proto\0"
    "ssl3_get_record\0"
    "ssl3_get_server_certificate\0"
    "ssl3_get_server_done\0"
    "ssl3_get_server_hello\0"
    "ssl3_get_server_key_exchange\0"
    "ssl3_get_v2_client_hello\0"
    "ssl3_handshake_mac\0"
    "ssl3_prf\0"
    "ssl3_read_bytes\0"
    "ssl3_read_n\0"
    "ssl3_send_cert_verify\0"
    "ssl3_send_certificate_request\0"
    "ssl3_send_channel_id\0"
    "ssl3_send_client_certificate\0"
    "ssl3_send_client_hello\0"
    "ssl3_send_client_key_exchange\0"
    "ssl3_send_server_certificate\0"
    "ssl3_send_server_hello\0"
    "ssl3_send_server_key_exchange\0"
    "ssl3_setup_read_buffer\0"
    "ssl3_setup_write_buffer\0"
    "ssl3_write_bytes\0"
    "ssl3_write_pending\0"
    "ssl_add_cert_chain\0"
    "ssl_add_cert_to_buf\0"
    "ssl_add_clienthello_renegotiate_ext\0"
    "ssl_add_clienthello_tlsext\0"
    "ssl_add_clienthello_use_srtp_ext\0"
    "ssl_add_serverhello_renegotiate_ext\0"
    "ssl_add_serverhello_tlsext\0"
    "ssl_add_serverhello_use_srtp_ext\0"
    "ssl_build_cert_chain\0"
    "ssl_bytes_to_cipher_list\0"
    "ssl_cert_dup\0"
    "ssl_cert_inst\0"
    "ssl_cert_new\0"
    "ssl_check_serverhello_tlsext\0"
    "ssl_check_srvr_ecc_cert_and_alg\0"
    "ssl_cipher_process_rulestr\0"
    "ssl_cipher_strength_sort\0"
    "ssl_create_cipher_list\0"
    "ssl_ctx_log_master_secret\0"
    "ssl_ctx_log_rsa_client_key_exchange\0"
    "ssl_ctx_make_profiles\0"
    "ssl_get_new_session\0"
    "ssl_get_prev_session\0"
    "ssl_get_server_cert_index\0"
    "ssl_get_sign_pkey\0"
    "ssl_init_wbio_buffer\0"
    "ssl_parse_clienthello_renegotiate_ext\0"
    "ssl_parse_clienthello_tlsext\0"
    "ssl_parse_clienthello_use_srtp_ext\0"
    "ssl_parse_serverhello_renegotiate_ext\0"
    "ssl_parse_serverhello_tlsext\0"
    "ssl_parse_serverhello_use_srtp_ext\0"
    "ssl_scan_clienthello_tlsext\0"
    "ssl_scan_serverhello_tlsext\0"
    "ssl_sess_cert_new\0"
    "ssl_set_cert\0"
    "ssl_set_pkey\0"
    "ssl_undefined_const_function\0"
    "ssl_undefined_function\0"
    "ssl_undefined_void_function\0"
    "ssl_verify_cert_chain\0"
    "tls12_check_peer_sigalg\0"
    "tls1_aead_ctx_init\0"
    "tls1_cert_verify_mac\0"
    "tls1_change_cipher_state\0"
    "tls1_change_cipher_state_aead\0"
    "tls1_check_duplicate_extensions\0"
    "tls1_enc\0"
    "tls1_export_keying_material\0"
    "tls1_prf\0"
    "tls1_setup_key_block\0"
    "ASN1_digest\0"
    "ASN1_item_sign_ctx\0"
    "ASN1_item_verify\0"
    "NETSCAPE_SPKI_b64_decode\0"
    "NETSCAPE_SPKI_b64_encode\0"
    "PKCS7_get_CRLs\0"
    "PKCS7_get_certificates\0"
    "X509_ATTRIBUTE_create_by_NID\0"
    "X509_ATTRIBUTE_create_by_OBJ\0"
    "X509_ATTRIBUTE_create_by_txt\0"
    "X509_ATTRIBUTE_get0_data\0"
    "X509_ATTRIBUTE_set1_data\0"
    "X509_CRL_add0_revoked\0"
    "X509_CRL_diff\0"
    "X509_CRL_print_fp\0"
    "X509_EXTENSION_create_by_NID\0"
    "X509_EXTENSION_create_by_OBJ\0"
    "X509_INFO_new\0"
    "X509_NAME_ENTRY_create_by_NID\0"
    "X509_NAME_ENTRY_create_by_txt\0"
    "X509_NAME_ENTRY_set_object\0"
    "X509_NAME_add_entry\0"
    "X509_NAME_oneline\0"
    "X509_NAME_print\0"
    "X509_PKEY_new\0"
    "X509_PUBKEY_get\0"
    "X509_PUBKEY_set\0"
    "X509_REQ_check_private_key\0"
    "X509_REQ_to_X509\0"
    "X509_STORE_CTX_get1_issuer\0"
    "X509_STORE_CTX_init\0"
    "X509_STORE_CTX_new\0"
    "X509_STORE_CTX_purpose_inherit\0"
    "X509_STORE_add_cert\0"
    "X509_STORE_add_crl\0"
    "X509_TRUST_add\0"
    "X509_TRUST_set\0"
    "X509_check_private_key\0"
    "X509_get_pubkey_parameters\0"
    "X509_load_cert_crl_file\0"
    "X509_load_cert_file\0"
    "X509_load_crl_file\0"
    "X509_print_ex_fp\0"
    "X509_to_X509_REQ\0"
    "X509_verify_cert\0"
    "X509at_add1_attr\0"
    "X509v3_add_ext\0"
    "add_cert_dir\0"
    "by_file_ctrl\0"
    "check_policy\0"
    "dir_ctrl\0"
    "get_cert_by_subject\0"
    "i2d_DSA_PUBKEY\0"
    "i2d_EC_PUBKEY\0"
    "i2d_RSA_PUBKEY\0"
    "pkcs7_parse_header\0"
    "x509_name_encode\0"
    "x509_name_ex_d2i\0"
    "x509_name_ex_new\0"
    "SXNET_add_id_INTEGER\0"
    "SXNET_add_id_asc\0"
    "SXNET_add_id_ulong\0"
    "SXNET_get_id_asc\0"
    "SXNET_get_id_ulong\0"
    "X509V3_EXT_add\0"
    "X509V3_EXT_add_alias\0"
    "X509V3_EXT_free\0"
    "X509V3_EXT_i2d\0"
    "X509V3_EXT_nconf\0"
    "X509V3_add1_i2d\0"
    "X509V3_add_value\0"
    "X509V3_get_section\0"
    "X509V3_get_string\0"
    "X509V3_get_value_bool\0"
    "X509V3_parse_list\0"
    "X509_PURPOSE_add\0"
    "X509_PURPOSE_set\0"
    "a2i_GENERAL_NAME\0"
    "copy_email\0"
    "copy_issuer\0"
    "do_dirname\0"
    "do_ext_i2d\0"
    "do_ext_nconf\0"
    "gnames_from_sectname\0"
    "hex_to_string\0"
    "i2s_ASN1_ENUMERATED\0"
    "i2s_ASN1_IA5STRING\0"
    "i2s_ASN1_INTEGER\0"
    "i2v_AUTHORITY_INFO_ACCESS\0"
    "notice_section\0"
    "nref_nos\0"
    "policy_section\0"
    "process_pci_value\0"
    "r2i_certpol\0"
    "r2i_pci\0"
    "s2i_ASN1_IA5STRING\0"
    "s2i_ASN1_INTEGER\0"
    "s2i_ASN1_OCTET_STRING\0"
    "s2i_skey_id\0"
    "set_dist_point_name\0"
    "string_to_hex\0"
    "v2i_ASN1_BIT_STRING\0"
    "v2i_AUTHORITY_INFO_ACCESS\0"
    "v2i_AUTHORITY_KEYID\0"
    "v2i_BASIC_CONSTRAINTS\0"
    "v2i_EXTENDED_KEY_USAGE\0"
    "v2i_GENERAL_NAMES\0"
    "v2i_GENERAL_NAME_ex\0"
    "v2i_NAME_CONSTRAINTS\0"
    "v2i_POLICY_CONSTRAINTS\0"
    "v2i_POLICY_MAPPINGS\0"
    "v2i_crld\0"
    "v2i_idp\0"
    "v2i_issuer_alt\0"
    "v2i_subject_alt\0"
    "v3_generic_extension\0"
    "";

const uint32_t kOpenSSLReasonValues[] = {
    0xc3207ba,
    0xc3287c7,
    0xc3307d6,
    0xc3387e6,
    0xc3407f5,
    0xc34880e,
    0xc35081a,
    0xc358837,
    0xc360849,
    0xc368857,
    0xc370867,
    0xc378874,
    0xc380884,
    0xc38888f,
    0xc3908a5,
    0xc3988b4,
    0xc3a08c8,
    0x10321417,
    0x10329423,
    0x1033143c,
    0x1033944f,
    0x10340da9,
    0x10349462,
    0x10351477,
    0x1035948a,
    0x103614a3,
    0x103694b8,
    0x103714d6,
    0x103794e5,
    0x10381501,
    0x1038951c,
    0x1039152b,
    0x10399547,
    0x103a1562,
    0x103a9579,
    0x103b158a,
    0x103b959e,
    0x103c15bd,
    0x103c95cc,
    0x103d15e3,
    0x103d95f6,
    0x103e0b5f,
    0x103e9609,
    0x103f161c,
    0x103f9636,
    0x10401646,
    0x1040965a,
    0x10411670,
    0x10419688,
    0x1042169d,
    0x104296b1,
    0x104316c3,
    0x104385d0,
    0x104408b4,
    0x104496d8,
    0x104516ef,
    0x10459704,
    0x10461712,
    0x14320b42,
    0x14328b50,
    0x14330b5f,
    0x14338b71,
    0x18320083,
    0x18328dff,
    0x18330e15,
    0x18338094,
    0x18340e2d,
    0x18348e41,
    0x18350e56,
    0x18358e78,
    0x18360e90,
    0x18368ea5,
    0x18370eb8,
    0x18378ecc,
    0x18380ef0,
    0x18388efe,
    0x18390f14,
    0x18398f28,
    0x183a0f38,
    0x183a89cc,
    0x183b0f48,
    0x183b8f5d,
    0x183c0f74,
    0x183c8f88,
    0x183d0f9c,
    0x183d8fac,
    0x183e0b8e,
    0x183e8fb9,
    0x183f0fcb,
    0x183f8fd6,
    0x18400fe6,
    0x18408ff7,
    0x18411008,
    0x1841901a,
    0x18421043,
    0x1842905c,
    0x1843106b,
    0x1843907f,
    0x184410a0,
    0x184490b8,
    0x184510d4,
    0x184590ea,
    0x18461105,
    0x1846866b,
    0x18471120,
    0x1847913b,
    0x20321162,
    0x2432116e,
    0x243288fa,
    0x24331180,
    0x2433918d,
    0x2434119a,
    0x243491ac,
    0x243511bb,
    0x243591d8,
    0x243611e5,
    0x243691f3,
    0x24371201,
    0x2437920f,
    0x24381218,
    0x24389225,
    0x24391238,
    0x28320b82,
    0x28328b8e,
    0x28330b5f,
    0x28338ba1,
    0x2c3229d2,
    0x2c32a9e0,
    0x2c3329f2,
    0x2c33aa04,
    0x2c342a18,
    0x2c34aa2a,
    0x2c352a45,
    0x2c35aa57,
    0x2c362a6a,
    0x2c3682f3,
    0x2c372a77,
    0x2c37aa89,
    0x2c382a9c,
    0x2c38aaaa,
    0x2c392aba,
    0x2c39aacc,
    0x2c3a2ae0,
    0x2c3aaaf1,
    0x2c3b12f8,
    0x2c3bab02,
    0x2c3c2b16,
    0x2c3cab2c,
    0x2c3d2b45,
    0x2c3dab73,
    0x2c3e2b81,
    0x2c3eab99,
    0x2c3f2bb1,
    0x2c3fabbe,
    0x2c402be1,
    0x2c40ac00,
    0x2c411162,
    0x2c41ac11,
    0x2c422c24,
    0x2c4290d4,
    0x2c432c35,
    0x2c4386a2,
    0x2c442b62,
    0x30320000,
    0x30328015,
    0x3033001f,
    0x30338038,
    0x3034004a,
    0x30348064,
    0x3035006b,
    0x30358083,
    0x30360094,
    0x303680a1,
    0x303700b0,
    0x303780bd,
    0x303800d0,
    0x303880eb,
    0x30390100,
    0x30398114,
    0x303a0128,
    0x303a8139,
    0x303b0152,
    0x303b816f,
    0x303c017d,
    0x303c8191,
    0x303d01a1,
    0x303d81ba,
    0x303e01ca,
    0x303e81dd,
    0x303f01ec,
    0x303f81f8,
    0x3040020d,
    0x3040821d,
    0x30410234,
    0x30418241,
    0x30420254,
    0x30428263,
    0x30430278,
    0x30438299,
    0x304402ac,
    0x304482bf,
    0x304502d8,
    0x304582f3,
    0x30460310,
    0x30468329,
    0x30470337,
    0x30478348,
    0x30480357,
    0x3048836f,
    0x30490381,
    0x30498395,
    0x304a03b4,
    0x304a83c7,
    0x304b03d2,
    0x304b83e1,
    0x304c03f2,
    0x304c83fe,
    0x304d0414,
    0x304d8422,
    0x304e0438,
    0x304e844a,
    0x304f045c,
    0x304f846f,
    0x30500482,
    0x30508493,
    0x305104a3,
    0x305184bb,
    0x305204d0,
    0x305284e8,
    0x305304fc,
    0x30538514,
    0x3054052d,
    0x30548546,
    0x30550563,
    0x3055856e,
    0x30560586,
    0x30568596,
    0x305705a7,
    0x305785ba,
    0x305805d0,
    0x305885d9,
    0x305905ee,
    0x30598601,
    0x305a0610,
    0x305a8630,
    0x305b063f,
    0x305b864b,
    0x305c066b,
    0x305c8687,
    0x305d0698,
    0x305d86a2,
    0x34320abc,
    0x34328ad0,
    0x34330aed,
    0x34338b00,
    0x34340b0f,
    0x34348b2c,
    0x3c320083,
    0x3c328bb7,
    0x3c330bd0,
    0x3c338beb,
    0x3c340c08,
    0x3c348c23,
    0x3c350c3e,
    0x3c358c53,
    0x3c360c6c,
    0x3c368c84,
    0x3c370c95,
    0x3c378ca3,
    0x3c380cb0,
    0x3c388cc4,
    0x3c390b8e,
    0x3c398cd8,
    0x3c3a0cec,
    0x3c3a8874,
    0x3c3b0cfc,
    0x3c3b8d17,
    0x3c3c0d29,
    0x3c3c8d3f,
    0x3c3d0d49,
    0x3c3d8d5d,
    0x3c3e0d6b,
    0x3c3e8d79,
    0x40321729,
    0x4032973f,
    0x4033176d,
    0x40339777,
    0x4034178e,
    0x403497ac,
    0x403517bc,
    0x403597ce,
    0x403617db,
    0x403697e7,
    0x403717fc,
    0x40379811,
    0x40381823,
    0x4038982e,
    0x40391840,
    0x40398da9,
    0x403a1850,
    0x403a9863,
    0x403b1884,
    0x403b9895,
    0x403c18a5,
    0x403c8064,
    0x403d18b1,
    0x403d98cd,
    0x403e18e3,
    0x403e98f2,
    0x403f1905,
    0x403f991f,
    0x4040192d,
    0x40409942,
    0x40411956,
    0x40419973,
    0x4042198c,
    0x404299a7,
    0x404319c0,
    0x404399d3,
    0x404419e7,
    0x404499ff,
    0x40451a0f,
    0x40459a1d,
    0x40461a3b,
    0x40468094,
    0x40471a50,
    0x40479a62,
    0x40481a86,
    0x40489aa6,
    0x40491aba,
    0x40499acf,
    0x404a1ae8,
    0x404a9b0b,
    0x404b1b25,
    0x404b9b43,
    0x404c1b5e,
    0x404c9b78,
    0x404d1b8f,
    0x404d9bb7,
    0x404e1bce,
    0x404e9bea,
    0x404f1c06,
    0x404f9c27,
    0x40501c49,
    0x40509c65,
    0x40511c79,
    0x40519c86,
    0x40521c9d,
    0x40529cad,
    0x40531cbd,
    0x40539cd1,
    0x40541cec,
    0x40549cfc,
    0x40551d13,
    0x40559d22,
    0x40561d3d,
    0x40569d55,
    0x40571d71,
    0x40579d8a,
    0x40581d9d,
    0x40589db2,
    0x40591dd5,
    0x40599de3,
    0x405a1df0,
    0x405a9e09,
    0x405b1e21,
    0x405b9e34,
    0x405c1e49,
    0x405c9e5b,
    0x405d1e70,
    0x405d9e80,
    0x405e1e99,
    0x405e9ead,
    0x405f1ebd,
    0x405f9ed5,
    0x40601ee6,
    0x40609ef9,
    0x40611f0a,
    0x40619f28,
    0x40621f39,
    0x40629f46,
    0x40631f5d,
    0x40639f7d,
    0x40641f94,
    0x40649fa1,
    0x40651faf,
    0x40659fd1,
    0x40661ff9,
    0x4066a00e,
    0x40672025,
    0x4067a036,
    0x40682047,
    0x4068a058,
    0x4069206d,
    0x4069a084,
    0x406a2095,
    0x406aa0ae,
    0x406b20c9,
    0x406ba0e0,
    0x406c20f8,
    0x406ca119,
    0x406d212c,
    0x406da14d,
    0x406e2168,
    0x406ea183,
    0x406f21a4,
    0x406fa1ca,
    0x407021ea,
    0x4070a206,
    0x40712393,
    0x4071a3b6,
    0x407223cc,
    0x4072a3eb,
    0x40732403,
    0x4073a423,
    0x4074264d,
    0x4074a672,
    0x4075268d,
    0x4075a6ac,
    0x407626db,
    0x4076a703,
    0x4077271c,
    0x4077a73b,
    0x40782760,
    0x4078a777,
    0x4079278a,
    0x4079a7a7,
    0x407a0782,
    0x407aa7b9,
    0x407b27cc,
    0x407ba7e5,
    0x407c27fd,
    0x407c905c,
    0x407d2811,
    0x407da82b,
    0x407e283c,
    0x407ea850,
    0x407f285e,
    0x407fa879,
    0x40801225,
    0x4080a89e,
    0x408128c0,
    0x4081a8db,
    0x408228f0,
    0x4082a908,
    0x40832920,
    0x4083a937,
    0x4084294d,
    0x4084a959,
    0x4085296c,
    0x4085a981,
    0x40862993,
    0x4086a9a8,
    0x408729b1,
    0x40879ba5,
    0x41f422be,
    0x41f92350,
    0x41fe2243,
    0x41fea474,
    0x41ff2565,
    0x420322d7,
    0x420822f9,
    0x4208a335,
    0x42092227,
    0x4209a36f,
    0x420a227e,
    0x420aa25e,
    0x420b229e,
    0x420ba317,
    0x420c2581,
    0x420ca441,
    0x420d245b,
    0x420da492,
    0x421224ac,
    0x42172548,
    0x4217a4ee,
    0x421c2510,
    0x421f24cb,
    0x42212598,
    0x4226252b,
    0x422b2631,
    0x422ba5fa,
    0x422c2619,
    0x422ca5d4,
    0x422d25b3,
    0x443206ad,
    0x443286bc,
    0x443306c8,
    0x443386d6,
    0x443406e9,
    0x443486fa,
    0x44350701,
    0x4435870b,
    0x4436071e,
    0x44368734,
    0x44370746,
    0x44378753,
    0x44380762,
    0x4438876a,
    0x44390782,
    0x44398790,
    0x443a07a3,
    0x4c32124f,
    0x4c32925f,
    0x4c331272,
    0x4c339292,
    0x4c340094,
    0x4c3480b0,
    0x4c35129e,
    0x4c3592ac,
    0x4c3612c8,
    0x4c3692db,
    0x4c3712ea,
    0x4c3792f8,
    0x4c38130d,
    0x4c389319,
    0x4c391339,
    0x4c399363,
    0x4c3a137c,
    0x4c3a9395,
    0x4c3b05d0,
    0x4c3b93ae,
    0x4c3c13c0,
    0x4c3c93cf,
    0x4c3d105c,
    0x4c3d93e8,
    0x4c3e13f5,
    0x50322c47,
    0x5032ac56,
    0x50332c61,
    0x5033ac71,
    0x50342c8a,
    0x5034aca4,
    0x50352cb2,
    0x5035acc8,
    0x50362cda,
    0x5036acf0,
    0x50372d09,
    0x5037ad1c,
    0x50382d34,
    0x5038ad45,
    0x50392d5a,
    0x5039ad6e,
    0x503a2d8e,
    0x503aada4,
    0x503b2dbc,
    0x503badce,
    0x503c2dea,
    0x503cae01,
    0x503d2e1a,
    0x503dae30,
    0x503e2e3d,
    0x503eae53,
    0x503f2e65,
    0x503f8348,
    0x50402e78,
    0x5040ae88,
    0x50412ea2,
    0x5041aeb1,
    0x50422ecb,
    0x5042aee8,
    0x50432ef8,
    0x5043af08,
    0x50442f17,
    0x50448414,
    0x50452f2b,
    0x5045af49,
    0x50462f5c,
    0x5046af72,
    0x50472f84,
    0x5047af99,
    0x50482fbf,
    0x5048afcd,
    0x50492fe0,
    0x5049aff5,
    0x504a300b,
    0x504ab01b,
    0x504b303b,
    0x504bb04e,
    0x504c3071,
    0x504cb09f,
    0x504d30b1,
    0x504db0ce,
    0x504e30e9,
    0x504eb105,
    0x504f3117,
    0x504fb12e,
    0x5050313d,
    0x50508687,
    0x50513150,
    0x58320de7,
    0x68320da9,
    0x68328b8e,
    0x68330ba1,
    0x68338db7,
    0x68340dc7,
    0x6c320d85,
    0x6c328b71,
    0x6c330d90,
    0x74320980,
    0x783208e5,
    0x783288fa,
    0x78330906,
    0x78338083,
    0x78340915,
    0x7834892a,
    0x78350949,
    0x7835896b,
    0x78360980,
    0x78368996,
    0x783709a6,
    0x783789b9,
    0x783809cc,
    0x783889de,
    0x783909eb,
    0x78398a0a,
    0x783a0a1f,
    0x783a8a2d,
    0x783b0a37,
    0x783b8a4b,
    0x783c0a62,
    0x783c8a77,
    0x783d0a8e,
    0x783d8aa3,
    0x783e09f9,
    0x80321151,
};

const size_t kOpenSSLReasonValuesLen = sizeof(kOpenSSLReasonValues) / sizeof(kOpenSSLReasonValues[0]);

const char kOpenSSLReasonStringData[] =
    "ASN1_LENGTH_MISMATCH\0"
    "AUX_ERROR\0"
    "BAD_GET_ASN1_OBJECT_CALL\0"
    "BAD_OBJECT_HEADER\0"
    "BMPSTRING_IS_WRONG_LENGTH\0"
    "BN_LIB\0"
    "BOOLEAN_IS_WRONG_LENGTH\0"
    "BUFFER_TOO_SMALL\0"
    "DECODE_ERROR\0"
    "DEPTH_EXCEEDED\0"
    "ENCODE_ERROR\0"
    "ERROR_GETTING_TIME\0"
    "EXPECTING_AN_ASN1_SEQUENCE\0"
    "EXPECTING_AN_INTEGER\0"
    "EXPECTING_AN_OBJECT\0"
    "EXPECTING_A_BOOLEAN\0"
    "EXPECTING_A_TIME\0"
    "EXPLICIT_LENGTH_MISMATCH\0"
    "EXPLICIT_TAG_NOT_CONSTRUCTED\0"
    "FIELD_MISSING\0"
    "FIRST_NUM_TOO_LARGE\0"
    "HEADER_TOO_LONG\0"
    "ILLEGAL_BITSTRING_FORMAT\0"
    "ILLEGAL_BOOLEAN\0"
    "ILLEGAL_CHARACTERS\0"
    "ILLEGAL_FORMAT\0"
    "ILLEGAL_HEX\0"
    "ILLEGAL_IMPLICIT_TAG\0"
    "ILLEGAL_INTEGER\0"
    "ILLEGAL_NESTED_TAGGING\0"
    "ILLEGAL_NULL\0"
    "ILLEGAL_NULL_VALUE\0"
    "ILLEGAL_OBJECT\0"
    "ILLEGAL_OPTIONAL_ANY\0"
    "ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE\0"
    "ILLEGAL_TAGGED_ANY\0"
    "ILLEGAL_TIME_VALUE\0"
    "INTEGER_NOT_ASCII_FORMAT\0"
    "INTEGER_TOO_LARGE_FOR_LONG\0"
    "INVALID_BIT_STRING_BITS_LEFT\0"
    "INVALID_BMPSTRING_LENGTH\0"
    "INVALID_DIGIT\0"
    "INVALID_MODIFIER\0"
    "INVALID_NUMBER\0"
    "INVALID_OBJECT_ENCODING\0"
    "INVALID_SEPARATOR\0"
    "INVALID_TIME_FORMAT\0"
    "INVALID_UNIVERSALSTRING_LENGTH\0"
    "INVALID_UTF8STRING\0"
    "LIST_ERROR\0"
    "MALLOC_FAILURE\0"
    "MISSING_ASN1_EOS\0"
    "MISSING_EOC\0"
    "MISSING_SECOND_NUMBER\0"
    "MISSING_VALUE\0"
    "MSTRING_NOT_UNIVERSAL\0"
    "MSTRING_WRONG_TAG\0"
    "NESTED_ASN1_ERROR\0"
    "NESTED_ASN1_STRING\0"
    "NON_HEX_CHARACTERS\0"
    "NOT_ASCII_FORMAT\0"
    "NOT_ENOUGH_DATA\0"
    "NO_MATCHING_CHOICE_TYPE\0"
    "NULL_IS_WRONG_LENGTH\0"
    "OBJECT_NOT_ASCII_FORMAT\0"
    "ODD_NUMBER_OF_CHARS\0"
    "SECOND_NUMBER_TOO_LARGE\0"
    "SEQUENCE_LENGTH_MISMATCH\0"
    "SEQUENCE_NOT_CONSTRUCTED\0"
    "SEQUENCE_OR_SET_NEEDS_CONFIG\0"
    "SHORT_LINE\0"
    "STREAMING_NOT_SUPPORTED\0"
    "STRING_TOO_LONG\0"
    "STRING_TOO_SHORT\0"
    "TAG_VALUE_TOO_HIGH\0"
    "TIME_NOT_ASCII_FORMAT\0"
    "TOO_LONG\0"
    "TYPE_NOT_CONSTRUCTED\0"
    "TYPE_NOT_PRIMITIVE\0"
    "UNEXPECTED_EOC\0"
    "UNIVERSALSTRING_IS_WRONG_LENGTH\0"
    "UNKNOWN_FORMAT\0"
    "UNKNOWN_TAG\0"
    "UNSUPPORTED_ANY_DEFINED_BY_TYPE\0"
    "UNSUPPORTED_PUBLIC_KEY_TYPE\0"
    "UNSUPPORTED_TYPE\0"
    "WRONG_TAG\0"
    "WRONG_TYPE\0"
    "BAD_FOPEN_MODE\0"
    "BROKEN_PIPE\0"
    "CONNECT_ERROR\0"
    "ERROR_SETTING_NBIO\0"
    "INVALID_ARGUMENT\0"
    "IN_USE\0"
    "KEEPALIVE\0"
    "NBIO_CONNECT_ERROR\0"
    "NO_HOSTNAME_SPECIFIED\0"
    "NO_PORT_SPECIFIED\0"
    "NO_SUCH_FILE\0"
    "NULL_PARAMETER\0"
    "SYS_LIB\0"
    "UNABLE_TO_CREATE_SOCKET\0"
    "UNINITIALIZED\0"
    "UNSUPPORTED_METHOD\0"
    "WRITE_TO_READ_ONLY_BIO\0"
    "ARG2_LT_ARG3\0"
    "BAD_RECIPROCAL\0"
    "BIGNUM_TOO_LONG\0"
    "BITS_TOO_SMALL\0"
    "CALLED_WITH_EVEN_MODULUS\0"
    "DIV_BY_ZERO\0"
    "EXPAND_ON_STATIC_BIGNUM_DATA\0"
    "INPUT_NOT_REDUCED\0"
    "INVALID_RANGE\0"
    "NEGATIVE_NUMBER\0"
    "NOT_A_SQUARE\0"
    "NOT_INITIALIZED\0"
    "NO_INVERSE\0"
    "PRIVATE_KEY_TOO_LARGE\0"
    "P_IS_NOT_PRIME\0"
    "TOO_MANY_ITERATIONS\0"
    "TOO_MANY_TEMPORARY_VARIABLES\0"
    "AES_KEY_SETUP_FAILED\0"
    "BAD_DECRYPT\0"
    "BAD_KEY_LENGTH\0"
    "CTRL_NOT_IMPLEMENTED\0"
    "CTRL_OPERATION_NOT_IMPLEMENTED\0"
    "DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH\0"
    "INITIALIZATION_ERROR\0"
    "INPUT_NOT_INITIALIZED\0"
    "INVALID_AD_SIZE\0"
    "INVALID_KEY_LENGTH\0"
    "INVALID_NONCE_SIZE\0"
    "INVALID_OPERATION\0"
    "IV_TOO_LARGE\0"
    "NO_CIPHER_SET\0"
    "NO_DIRECTION_SET\0"
    "OUTPUT_ALIASES_INPUT\0"
    "TAG_TOO_LARGE\0"
    "TOO_LARGE\0"
    "UNSUPPORTED_AD_SIZE\0"
    "UNSUPPORTED_INPUT_SIZE\0"
    "UNSUPPORTED_KEY_SIZE\0"
    "UNSUPPORTED_NONCE_SIZE\0"
    "UNSUPPORTED_TAG_SIZE\0"
    "WRONG_FINAL_BLOCK_LENGTH\0"
    "LIST_CANNOT_BE_NULL\0"
    "MISSING_CLOSE_SQUARE_BRACKET\0"
    "MISSING_EQUAL_SIGN\0"
    "NO_CLOSE_BRACE\0"
    "UNABLE_TO_CREATE_NEW_SECTION\0"
    "VARIABLE_HAS_NO_VALUE\0"
    "BAD_GENERATOR\0"
    "INVALID_PUBKEY\0"
    "MODULUS_TOO_LARGE\0"
    "NO_PRIVATE_VALUE\0"
    "BAD_Q_VALUE\0"
    "MISSING_PARAMETERS\0"
    "NEED_NEW_SETUP_VALUES\0"
    "COORDINATES_OUT_OF_RANGE\0"
    "D2I_ECPKPARAMETERS_FAILURE\0"
    "EC_GROUP_NEW_BY_NAME_FAILURE\0"
    "GROUP2PKPARAMETERS_FAILURE\0"
    "I2D_ECPKPARAMETERS_FAILURE\0"
    "INCOMPATIBLE_OBJECTS\0"
    "INVALID_COMPRESSED_POINT\0"
    "INVALID_COMPRESSION_BIT\0"
    "INVALID_ENCODING\0"
    "INVALID_FIELD\0"
    "INVALID_FORM\0"
    "INVALID_GROUP_ORDER\0"
    "INVALID_PRIVATE_KEY\0"
    "MISSING_PRIVATE_KEY\0"
    "NON_NAMED_CURVE\0"
    "PKPARAMETERS2GROUP_FAILURE\0"
    "POINT_AT_INFINITY\0"
    "POINT_IS_NOT_ON_CURVE\0"
    "SLOT_FULL\0"
    "UNDEFINED_GENERATOR\0"
    "UNKNOWN_GROUP\0"
    "UNKNOWN_ORDER\0"
    "WRONG_ORDER\0"
    "KDF_FAILED\0"
    "POINT_ARITHMETIC_FAILURE\0"
    "BAD_SIGNATURE\0"
    "NOT_IMPLEMENTED\0"
    "RANDOM_NUMBER_GENERATION_FAILED\0"
    "OPERATION_NOT_SUPPORTED\0"
    "COMMAND_NOT_SUPPORTED\0"
    "CONTEXT_NOT_INITIALISED\0"
    "DIFFERENT_KEY_TYPES\0"
    "DIFFERENT_PARAMETERS\0"
    "DIGEST_AND_KEY_TYPE_NOT_SUPPORTED\0"
    "EXPECTING_AN_EC_KEY_KEY\0"
    "EXPECTING_AN_RSA_KEY\0"
    "EXPECTING_A_DH_KEY\0"
    "EXPECTING_A_DSA_KEY\0"
    "ILLEGAL_OR_UNSUPPORTED_PADDING_MODE\0"
    "INVALID_CURVE\0"
    "INVALID_DIGEST_LENGTH\0"
    "INVALID_DIGEST_TYPE\0"
    "INVALID_KEYBITS\0"
    "INVALID_MGF1_MD\0"
    "INVALID_PADDING_MODE\0"
    "INVALID_PSS_PARAMETERS\0"
    "INVALID_PSS_SALTLEN\0"
    "INVALID_SALT_LENGTH\0"
    "INVALID_TRAILER\0"
    "KEYS_NOT_SET\0"
    "NO_DEFAULT_DIGEST\0"
    "NO_KEY_SET\0"
    "NO_MDC2_SUPPORT\0"
    "NO_NID_FOR_CURVE\0"
    "NO_OPERATION_SET\0"
    "NO_PARAMETERS_SET\0"
    "OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE\0"
    "OPERATON_NOT_INITIALIZED\0"
    "UNKNOWN_DIGEST\0"
    "UNKNOWN_MASK_DIGEST\0"
    "UNKNOWN_MESSAGE_DIGEST_ALGORITHM\0"
    "UNKNOWN_PUBLIC_KEY_TYPE\0"
    "UNKNOWN_SIGNATURE_ALGORITHM\0"
    "UNSUPPORTED_ALGORITHM\0"
    "UNSUPPORTED_MASK_ALGORITHM\0"
    "UNSUPPORTED_MASK_PARAMETER\0"
    "UNSUPPORTED_SIGNATURE_TYPE\0"
    "WRONG_PUBLIC_KEY_TYPE\0"
    "OUTPUT_TOO_LARGE\0"
    "UNKNOWN_NID\0"
    "BAD_BASE64_DECODE\0"
    "BAD_END_LINE\0"
    "BAD_IV_CHARS\0"
    "BAD_PASSWORD_READ\0"
    "CIPHER_IS_NULL\0"
    "ERROR_CONVERTING_PRIVATE_KEY\0"
    "NOT_DEK_INFO\0"
    "NOT_ENCRYPTED\0"
    "NOT_PROC_TYPE\0"
    "NO_START_LINE\0"
    "READ_KEY\0"
    "SHORT_HEADER\0"
    "UNSUPPORTED_CIPHER\0"
    "UNSUPPORTED_ENCRYPTION\0"
    "BAD_PKCS12_DATA\0"
    "BAD_PKCS12_VERSION\0"
    "CIPHER_HAS_NO_OBJECT_IDENTIFIER\0"
    "CRYPT_ERROR\0"
    "ENCRYPT_ERROR\0"
    "ERROR_SETTING_CIPHER_PARAMS\0"
    "INCORRECT_PASSWORD\0"
    "KEYGEN_FAILURE\0"
    "KEY_GEN_ERROR\0"
    "METHOD_NOT_SUPPORTED\0"
    "MISSING_MAC\0"
    "MULTIPLE_PRIVATE_KEYS_IN_PKCS12\0"
    "PKCS12_PUBLIC_KEY_INTEGRITY_NOT_SUPPORTED\0"
    "PKCS12_TOO_DEEPLY_NESTED\0"
    "PRIVATE_KEY_DECODE_ERROR\0"
    "PRIVATE_KEY_ENCODE_ERROR\0"
    "UNKNOWN_ALGORITHM\0"
    "UNKNOWN_CIPHER\0"
    "UNKNOWN_CIPHER_ALGORITHM\0"
    "UNKNOWN_HASH\0"
    "UNSUPPORTED_PRIVATE_KEY_ALGORITHM\0"
    "BAD_E_VALUE\0"
    "BAD_FIXED_HEADER_DECRYPT\0"
    "BAD_PAD_BYTE_COUNT\0"
    "BAD_RSA_PARAMETERS\0"
    "BLOCK_TYPE_IS_NOT_01\0"
    "BN_NOT_INITIALIZED\0"
    "CRT_PARAMS_ALREADY_GIVEN\0"
    "CRT_VALUES_INCORRECT\0"
    "DATA_LEN_NOT_EQUAL_TO_MOD_LEN\0"
    "DATA_TOO_LARGE\0"
    "DATA_TOO_LARGE_FOR_KEY_SIZE\0"
    "DATA_TOO_LARGE_FOR_MODULUS\0"
    "DATA_TOO_SMALL\0"
    "DATA_TOO_SMALL_FOR_KEY_SIZE\0"
    "DIGEST_TOO_BIG_FOR_RSA_KEY\0"
    "D_E_NOT_CONGRUENT_TO_1\0"
    "EMPTY_PUBLIC_KEY\0"
    "FIRST_OCTET_INVALID\0"
    "INCONSISTENT_SET_OF_CRT_VALUES\0"
    "INTERNAL_ERROR\0"
    "INVALID_MESSAGE_LENGTH\0"
    "KEY_SIZE_TOO_SMALL\0"
    "LAST_OCTET_INVALID\0"
    "NO_PUBLIC_EXPONENT\0"
    "NULL_BEFORE_BLOCK_MISSING\0"
    "N_NOT_EQUAL_P_Q\0"
    "OAEP_DECODING_ERROR\0"
    "ONLY_ONE_OF_P_Q_GIVEN\0"
    "OUTPUT_BUFFER_TOO_SMALL\0"
    "PADDING_CHECK_FAILED\0"
    "PKCS_DECODING_ERROR\0"
    "SLEN_CHECK_FAILED\0"
    "SLEN_RECOVERY_FAILED\0"
    "UNKNOWN_ALGORITHM_TYPE\0"
    "UNKNOWN_PADDING_TYPE\0"
    "VALUE_MISSING\0"
    "WRONG_SIGNATURE_LENGTH\0"
    "APP_DATA_IN_HANDSHAKE\0"
    "ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT\0"
    "BAD_ALERT\0"
    "BAD_CHANGE_CIPHER_SPEC\0"
    "BAD_DATA_RETURNED_BY_CALLBACK\0"
    "BAD_DH_P_LENGTH\0"
    "BAD_DIGEST_LENGTH\0"
    "BAD_ECC_CERT\0"
    "BAD_ECPOINT\0"
    "BAD_HANDSHAKE_LENGTH\0"
    "BAD_HANDSHAKE_RECORD\0"
    "BAD_HELLO_REQUEST\0"
    "BAD_LENGTH\0"
    "BAD_PACKET_LENGTH\0"
    "BAD_RSA_ENCRYPT\0"
    "BAD_SRTP_MKI_VALUE\0"
    "BAD_SRTP_PROTECTION_PROFILE_LIST\0"
    "BAD_SSL_FILETYPE\0"
    "BAD_WRITE_RETRY\0"
    "BIO_NOT_SET\0"
    "CANNOT_SERIALIZE_PUBLIC_KEY\0"
    "CA_DN_LENGTH_MISMATCH\0"
    "CA_DN_TOO_LONG\0"
    "CCS_RECEIVED_EARLY\0"
    "CERTIFICATE_VERIFY_FAILED\0"
    "CERT_CB_ERROR\0"
    "CERT_LENGTH_MISMATCH\0"
    "CHANNEL_ID_NOT_P256\0"
    "CHANNEL_ID_SIGNATURE_INVALID\0"
    "CIPHER_CODE_WRONG_LENGTH\0"
    "CIPHER_OR_HASH_UNAVAILABLE\0"
    "CLIENTHELLO_PARSE_FAILED\0"
    "CLIENTHELLO_TLSEXT\0"
    "CONNECTION_REJECTED\0"
    "CONNECTION_TYPE_NOT_SET\0"
    "COOKIE_MISMATCH\0"
    "D2I_ECDSA_SIG\0"
    "DATA_BETWEEN_CCS_AND_FINISHED\0"
    "DATA_LENGTH_TOO_LONG\0"
    "DECRYPTION_FAILED\0"
    "DECRYPTION_FAILED_OR_BAD_RECORD_MAC\0"
    "DH_PUBLIC_VALUE_LENGTH_IS_WRONG\0"
    "DIGEST_CHECK_FAILED\0"
    "DTLS_MESSAGE_TOO_BIG\0"
    "ECC_CERT_NOT_FOR_SIGNING\0"
    "EMPTY_SRTP_PROTECTION_PROFILE_LIST\0"
    "ENCRYPTED_LENGTH_TOO_LONG\0"
    "ERROR_IN_RECEIVED_CIPHER_LIST\0"
    "EVP_DIGESTSIGNFINAL_FAILED\0"
    "EVP_DIGESTSIGNINIT_FAILED\0"
    "EXCESSIVE_MESSAGE_SIZE\0"
    "EXTRA_DATA_IN_MESSAGE\0"
    "FRAGMENT_MISMATCH\0"
    "GOT_A_FIN_BEFORE_A_CCS\0"
    "GOT_CHANNEL_ID_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_WITHOUT_EXTENSION\0"
    "HANDSHAKE_FAILURE_ON_CLIENT_HELLO\0"
    "HANDSHAKE_RECORD_BEFORE_CCS\0"
    "HTTPS_PROXY_REQUEST\0"
    "HTTP_REQUEST\0"
    "INAPPROPRIATE_FALLBACK\0"
    "INVALID_COMMAND\0"
    "INVALID_MESSAGE\0"
    "INVALID_SSL_SESSION\0"
    "INVALID_TICKET_KEYS_LENGTH\0"
    "LENGTH_MISMATCH\0"
    "LIBRARY_HAS_NO_CIPHERS\0"
    "MISSING_DH_KEY\0"
    "MISSING_ECDSA_SIGNING_CERT\0"
    "MISSING_RSA_CERTIFICATE\0"
    "MISSING_RSA_ENCRYPTING_CERT\0"
    "MISSING_RSA_SIGNING_CERT\0"
    "MISSING_TMP_DH_KEY\0"
    "MISSING_TMP_ECDH_KEY\0"
    "MIXED_SPECIAL_OPERATOR_WITH_GROUPS\0"
    "MTU_TOO_SMALL\0"
    "NESTED_GROUP\0"
    "NO_CERTIFICATES_RETURNED\0"
    "NO_CERTIFICATE_ASSIGNED\0"
    "NO_CERTIFICATE_SET\0"
    "NO_CIPHERS_AVAILABLE\0"
    "NO_CIPHERS_PASSED\0"
    "NO_CIPHERS_SPECIFIED\0"
    "NO_CIPHER_MATCH\0"
    "NO_COMPRESSION_SPECIFIED\0"
    "NO_METHOD_SPECIFIED\0"
    "NO_P256_SUPPORT\0"
    "NO_PRIVATE_KEY_ASSIGNED\0"
    "NO_RENEGOTIATION\0"
    "NO_REQUIRED_DIGEST\0"
    "NO_SHARED_CIPHER\0"
    "NO_SHARED_SIGATURE_ALGORITHMS\0"
    "NO_SRTP_PROFILES\0"
    "NULL_SSL_CTX\0"
    "NULL_SSL_METHOD_PASSED\0"
    "OLD_SESSION_CIPHER_NOT_RETURNED\0"
    "PACKET_LENGTH_TOO_LONG\0"
    "PARSE_TLSEXT\0"
    "PATH_TOO_LONG\0"
    "PEER_DID_NOT_RETURN_A_CERTIFICATE\0"
    "PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE\0"
    "PROTOCOL_IS_SHUTDOWN\0"
    "PSK_IDENTITY_NOT_FOUND\0"
    "PSK_NO_CLIENT_CB\0"
    "PSK_NO_SERVER_CB\0"
    "READ_BIO_NOT_SET\0"
    "READ_TIMEOUT_EXPIRED\0"
    "RECORD_LENGTH_MISMATCH\0"
    "RECORD_TOO_LARGE\0"
    "RENEGOTIATE_EXT_TOO_LONG\0"
    "RENEGOTIATION_ENCODING_ERR\0"
    "RENEGOTIATION_MISMATCH\0"
    "REQUIRED_CIPHER_MISSING\0"
    "SCSV_RECEIVED_WHEN_RENEGOTIATING\0"
    "SERVERHELLO_TLSEXT\0"
    "SESSION_ID_CONTEXT_UNINITIALIZED\0"
    "SESSION_MAY_NOT_BE_CREATED\0"
    "SIGNATURE_ALGORITHMS_ERROR\0"
    "SRTP_COULD_NOT_ALLOCATE_PROFILES\0"
    "SRTP_PROTECTION_PROFILE_LIST_TOO_LONG\0"
    "SRTP_UNKNOWN_PROTECTION_PROFILE\0"
    "SSL3_EXT_INVALID_SERVERNAME\0"
    "SSL3_EXT_INVALID_SERVERNAME_TYPE\0"
    "SSLV3_ALERT_BAD_CERTIFICATE\0"
    "SSLV3_ALERT_BAD_RECORD_MAC\0"
    "SSLV3_ALERT_CERTIFICATE_EXPIRED\0"
    "SSLV3_ALERT_CERTIFICATE_REVOKED\0"
    "SSLV3_ALERT_CERTIFICATE_UNKNOWN\0"
    "SSLV3_ALERT_CLOSE_NOTIFY\0"
    "SSLV3_ALERT_DECOMPRESSION_FAILURE\0"
    "SSLV3_ALERT_HANDSHAKE_FAILURE\0"
    "SSLV3_ALERT_ILLEGAL_PARAMETER\0"
    "SSLV3_ALERT_NO_CERTIFICATE\0"
    "SSLV3_ALERT_UNEXPECTED_MESSAGE\0"
    "SSLV3_ALERT_UNSUPPORTED_CERTIFICATE\0"
    "SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION\0"
    "SSL_HANDSHAKE_FAILURE\0"
    "SSL_SESSION_ID_CALLBACK_FAILED\0"
    "SSL_SESSION_ID_CONFLICT\0"
    "SSL_SESSION_ID_CONTEXT_TOO_LONG\0"
    "SSL_SESSION_ID_HAS_BAD_LENGTH\0"
    "TLSV1_ALERT_ACCESS_DENIED\0"
    "TLSV1_ALERT_DECODE_ERROR\0"
    "TLSV1_ALERT_DECRYPTION_FAILED\0"
    "TLSV1_ALERT_DECRYPT_ERROR\0"
    "TLSV1_ALERT_EXPORT_RESTRICTION\0"
    "TLSV1_ALERT_INAPPROPRIATE_FALLBACK\0"
    "TLSV1_ALERT_INSUFFICIENT_SECURITY\0"
    "TLSV1_ALERT_INTERNAL_ERROR\0"
    "TLSV1_ALERT_NO_RENEGOTIATION\0"
    "TLSV1_ALERT_PROTOCOL_VERSION\0"
    "TLSV1_ALERT_RECORD_OVERFLOW\0"
    "TLSV1_ALERT_UNKNOWN_CA\0"
    "TLSV1_ALERT_USER_CANCELLED\0"
    "TLSV1_BAD_CERTIFICATE_HASH_VALUE\0"
    "TLSV1_BAD_CERTIFICATE_STATUS_RESPONSE\0"
    "TLSV1_CERTIFICATE_UNOBTAINABLE\0"
    "TLSV1_UNRECOGNIZED_NAME\0"
    "TLSV1_UNSUPPORTED_EXTENSION\0"
    "TLS_CLIENT_CERT_REQ_WITH_ANON_CIPHER\0"
    "TLS_ILLEGAL_EXPORTER_LABEL\0"
    "TLS_INVALID_ECPOINTFORMAT_LIST\0"
    "TLS_PEER_DID_NOT_RESPOND_WITH_CERTIFICATE_LIST\0"
    "TLS_RSA_ENCRYPTED_VALUE_LENGTH_IS_WRONG\0"
    "TOO_MANY_EMPTY_FRAGMENTS\0"
    "UNABLE_TO_FIND_ECDH_PARAMETERS\0"
    "UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS\0"
    "UNEXPECTED_GROUP_CLOSE\0"
    "UNEXPECTED_MESSAGE\0"
    "UNEXPECTED_OPERATOR_IN_GROUP\0"
    "UNEXPECTED_RECORD\0"
    "UNKNOWN_ALERT_TYPE\0"
    "UNKNOWN_CERTIFICATE_TYPE\0"
    "UNKNOWN_CIPHER_RETURNED\0"
    "UNKNOWN_CIPHER_TYPE\0"
    "UNKNOWN_KEY_EXCHANGE_TYPE\0"
    "UNKNOWN_PROTOCOL\0"
    "UNKNOWN_SSL_VERSION\0"
    "UNKNOWN_STATE\0"
    "UNPROCESSED_HANDSHAKE_DATA\0"
    "UNSAFE_LEGACY_RENEGOTIATION_DISABLED\0"
    "UNSUPPORTED_COMPRESSION_ALGORITHM\0"
    "UNSUPPORTED_ELLIPTIC_CURVE\0"
    "UNSUPPORTED_PROTOCOL\0"
    "UNSUPPORTED_SSL_VERSION\0"
    "USE_SRTP_NOT_NEGOTIATED\0"
    "WRONG_CERTIFICATE_TYPE\0"
    "WRONG_CIPHER_RETURNED\0"
    "WRONG_CURVE\0"
    "WRONG_MESSAGE_TYPE\0"
    "WRONG_SIGNATURE_TYPE\0"
    "WRONG_SSL_VERSION\0"
    "WRONG_VERSION_NUMBER\0"
    "X509_LIB\0"
    "X509_VERIFICATION_SETUP_PROBLEMS\0"
    "AKID_MISMATCH\0"
    "BAD_PKCS7_VERSION\0"
    "BAD_X509_FILETYPE\0"
    "BASE64_DECODE_ERROR\0"
    "CANT_CHECK_DH_KEY\0"
    "CERT_ALREADY_IN_HASH_TABLE\0"
    "CRL_ALREADY_DELTA\0"
    "CRL_VERIFY_FAILURE\0"
    "IDP_MISMATCH\0"
    "INVALID_DIRECTORY\0"
    "INVALID_FIELD_NAME\0"
    "INVALID_TRUST\0"
    "ISSUER_MISMATCH\0"
    "KEY_TYPE_MISMATCH\0"
    "KEY_VALUES_MISMATCH\0"
    "LOADING_CERT_DIR\0"
    "LOADING_DEFAULTS\0"
    "NEWER_CRL_NOT_NEWER\0"
    "NOT_PKCS7_SIGNED_DATA\0"
    "NO_CERTIFICATES_INCLUDED\0"
    "NO_CERT_SET_FOR_US_TO_VERIFY\0"
    "NO_CRLS_INCLUDED\0"
    "NO_CRL_NUMBER\0"
    "PUBLIC_KEY_DECODE_ERROR\0"
    "PUBLIC_KEY_ENCODE_ERROR\0"
    "SHOULD_RETRY\0"
    "UNABLE_TO_FIND_PARAMETERS_IN_CHAIN\0"
    "UNABLE_TO_GET_CERTS_PUBLIC_KEY\0"
    "UNKNOWN_KEY_TYPE\0"
    "UNKNOWN_PURPOSE_ID\0"
    "UNKNOWN_TRUST_ID\0"
    "WRONG_LOOKUP_TYPE\0"
    "BAD_IP_ADDRESS\0"
    "BAD_OBJECT\0"
    "BN_DEC2BN_ERROR\0"
    "BN_TO_ASN1_INTEGER_ERROR\0"
    "CANNOT_FIND_FREE_FUNCTION\0"
    "DIRNAME_ERROR\0"
    "DISTPOINT_ALREADY_SET\0"
    "DUPLICATE_ZONE_ID\0"
    "ERROR_CONVERTING_ZONE\0"
    "ERROR_CREATING_EXTENSION\0"
    "ERROR_IN_EXTENSION\0"
    "EXPECTED_A_SECTION_NAME\0"
    "EXTENSION_EXISTS\0"
    "EXTENSION_NAME_ERROR\0"
    "EXTENSION_NOT_FOUND\0"
    "EXTENSION_SETTING_NOT_SUPPORTED\0"
    "EXTENSION_VALUE_ERROR\0"
    "ILLEGAL_EMPTY_EXTENSION\0"
    "ILLEGAL_HEX_DIGIT\0"
    "INCORRECT_POLICY_SYNTAX_TAG\0"
    "INVALID_BOOLEAN_STRING\0"
    "INVALID_EXTENSION_STRING\0"
    "INVALID_MULTIPLE_RDNS\0"
    "INVALID_NAME\0"
    "INVALID_NULL_ARGUMENT\0"
    "INVALID_NULL_NAME\0"
    "INVALID_NULL_VALUE\0"
    "INVALID_NUMBERS\0"
    "INVALID_OBJECT_IDENTIFIER\0"
    "INVALID_OPTION\0"
    "INVALID_POLICY_IDENTIFIER\0"
    "INVALID_PROXY_POLICY_SETTING\0"
    "INVALID_PURPOSE\0"
    "INVALID_SECTION\0"
    "INVALID_SYNTAX\0"
    "ISSUER_DECODE_ERROR\0"
    "NEED_ORGANIZATION_AND_NUMBERS\0"
    "NO_CONFIG_DATABASE\0"
    "NO_ISSUER_CERTIFICATE\0"
    "NO_ISSUER_DETAILS\0"
    "NO_POLICY_IDENTIFIER\0"
    "NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED\0"
    "NO_PUBLIC_KEY\0"
    "NO_SUBJECT_DETAILS\0"
    "ODD_NUMBER_OF_DIGITS\0"
    "OPERATION_NOT_DEFINED\0"
    "OTHERNAME_ERROR\0"
    "POLICY_LANGUAGE_ALREADY_DEFINED\0"
    "POLICY_PATH_LENGTH\0"
    "POLICY_PATH_LENGTH_ALREADY_DEFINED\0"
    "POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY\0"
    "SECTION_NOT_FOUND\0"
    "UNABLE_TO_GET_ISSUER_DETAILS\0"
    "UNABLE_TO_GET_ISSUER_KEYID\0"
    "UNKNOWN_BIT_STRING_ARGUMENT\0"
    "UNKNOWN_EXTENSION\0"
    "UNKNOWN_EXTENSION_NAME\0"
    "UNKNOWN_OPTION\0"
    "UNSUPPORTED_OPTION\0"
    "USER_TOO_LONG\0"
    "";

