
    Polymer('paper-dropdown-transition', {

      publish: {

        /**
         * The duration of the transition in ms. You can also set the duration by
         * setting a `duration` attribute on the target:
         *
         *    <paper-dropdown duration="1000"></paper-dropdown>
         *
         * @attribute duration
         * @type number
         * @default 500
         */
        duration: 500

      },

      setup: function(node) {
        this.super(arguments);

        var to = {
          'top': '0%',
          'left': '0%',
          'bottom': '100%',
          'right': '100%'
        };

        var bg = node.$.background;
        bg.style.webkitTransformOrigin = to[node.halign] + ' ' + to[node.valign];
        bg.style.transformOrigin = to[node.halign] + ' ' + to[node.valign];
      },

      transitionOpened: function(node, opened) {
        this.super(arguments);

        if (opened) {
          if (this.player) {
            this.player.cancel();
          }

          var duration = Number(node.getAttribute('duration')) || this.duration;

          var anims = [];

          var size = node.getBoundingClientRect();

          var ink = node.$.ripple;
          // var offset = 40 / Math.max(size.width, size.height);
          var offset = 0.2;
          anims.push(new Animation(ink, [{
            'opacity': 0.9,
            'transform': 'scale(0)',
          }, {
            'opacity': 0.9,
            'transform': 'scale(1)'
          }], {
            duration: duration * offset
          }));

          var bg = node.$.background;
          var sx = 40 / size.width;
          var sy = 40 / size.height;
          anims.push(new Animation(bg, [{
            'opacity': 0.9,
            'transform': 'scale(' + sx + ',' + sy + ')',
          }, {
            'opacity': 1,
            'transform': 'scale(' + Math.max(sx, 0.95) + ',' + Math.max(sy, 0.5) + ')'
          }, {
            'opacity': 1,
            'transform': 'scale(1, 1)'
          }], {
            delay: duration * offset,
            duration: duration * (1 - offset),
            fill: 'forwards'
          }));

          var menu = node.querySelector('.menu');
          if (menu) {
            var items = menu.items || menu.children.array();
            var itemDelay = offset + (1 - offset) / 2;
            var itemDuration = duration * (1 - itemDelay) / items.length;
            var reverse = this.valign === 'bottom';

            items.forEach(function(item, i) {
              anims.push(new Animation(item, [{
                'opacity': 0
              }, {
                'opacity': 1
              }], {
                delay: duration * itemDelay + itemDuration * (reverse ? items.length - 1 - i : i),
                duration: itemDuration,
                fill: 'both'
              }));
            }.bind(this));

            anims.push(new Animation(node.$.scroller, [{
              'opacity': 1
            }, {
              'opacity': 1
            }], {
              delay: duration * itemDelay,
              duration: itemDuration * items.length,
              fill: 'both'
            }));

          } else {
            anims.push(new Animation(node.$.scroller, [{
              'opacity': 0
            }, {
              'opacity': 1
            }], {
              delay: duration * (offset + (1 - offset) / 2),
              duration: duration * 0.5,
              fill: 'both'
            }));
          }

          var group = new AnimationGroup(anims, {
            easing: 'cubic-bezier(0.4, 0, 0.2, 1)'
          });
          this.player = document.timeline.play(group);
          this.player.onfinish = function() {
            this.fire('core-transitionend', this, node);
          }.bind(this);

        } else {
          this.fire('core-transitionend', this, node);
        }
      },

    });
  