#include <QtGui>
#include <math.h>
#include "scene.h"

#define windowWidth     800
#define windowHeight    480
#define refreshInterval 450

static QTime timeClock;

Scene::Scene(QZionCanvas *cnv, int item_count)
{
    canvas = cnv;

    for (int i=0; i < item_count; i++) {
        QZionImage *pixmap = new QZionImage(canvas, "image.png");
        pixmap->show();
        pixmap->setPos(random() % windowWidth,
                       random() % windowHeight);

        images.append(pixmap);
    }

    ncount = 0;
}

void Scene::tick_all()
{
    int i;
    int x, y;
    int w, h;
    int win_h, win_w, SLOW;

    w = 120;
    h = 160;
    win_h = 400;
    win_w = 400;
    SLOW = 5;

    ncount++;

    for (int i=0; i < images.size(); i++) {
        QZionImage *pixmap = (QZionImage *) images[i];

        x = (win_w / 2) - (w / 2);
        x += sin((double)(ncount + (i * 13)) / (36.7 * SLOW)) * (w / 2);
        y = (win_h / 2) - (h / 2);
        y += cos((double)(ncount + (i * 28)) / (43.8 * SLOW)) * (h / 2);

        pixmap->setPos(x, y);
    }
}

int main(int argc, char **argv)
{
    QTimer timer;
    QApplication app(argc, argv);
    QZionCanvas canvas;
    Scene *scene = new Scene(&canvas);

    QObject::connect(&timer, SIGNAL(timeout()), scene, SLOT(tick_all()));
    canvas.show();
    timer.start(0);

    return app.exec();
}
