/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE  klass;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return STR2CSTR(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else
    Data_Get_Struct(obj, void, *ptr);
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (!rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (flags)
	    rb_raise(rb_eTypeError, "wrong argument type (expected %s)", ty->str);
	  else
	    return -1;
	}
        if (*ptr == 0)
	  rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
    } else {
      if ((c = SWIG_MangleStr(obj)) == NULL) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      tc = SWIG_TypeCheck(c, ty);
      if (!tc) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      *ptr = SWIG_TypeCast(tc, *ptr);
    }
  }
  return 0;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

SWIGRUNTIME(VALUE)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = STR2CSTR(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_librdf_model swig_types[0] 
#define  SWIGTYPE_p_size_t swig_types[1] 
#define  SWIGTYPE_p_librdf_query_results swig_types[2] 
#define  SWIGTYPE_p_librdf_hash swig_types[3] 
#define  SWIGTYPE_p_librdf_query swig_types[4] 
#define  SWIGTYPE_p_librdf_world swig_types[5] 
#define  SWIGTYPE_p_librdf_parser swig_types[6] 
#define  SWIGTYPE_p_librdf_node swig_types[7] 
#define  SWIGTYPE_p_librdf_stream swig_types[8] 
#define  SWIGTYPE_p_librdf_statement swig_types[9] 
#define  SWIGTYPE_p_librdf_uri swig_types[10] 
#define  SWIGTYPE_p_librdf_storage swig_types[11] 
#define  SWIGTYPE_p_librdf_serializer swig_types[12] 
#define  SWIGTYPE_p_librdf_iterator swig_types[13] 
static swig_type_info *swig_types[15];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_redland
#define SWIG_name    "Redland"

static VALUE mRedland;

#ifdef __cplusplus
extern "C" {
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
struct timeval rb_time_timeval(VALUE);
#endif
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
#include "rubyio.h"
#ifdef __cplusplus
}
#endif



/* compile-time include (inside a % ... % block) */
#ifdef REDLAND_PRE_I
#include <redland-pre.i>
#endif

#include <redland.h>

/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif

/* compile-time include (inside a % ... % block) */
#ifdef REDLAND_POST_I
#include <redland-post.i>
#endif

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);


/* prototypes for internal routines called below - NOT PART OF API */
void librdf_test_error(librdf_world* world, const char *message);
void librdf_test_warning(librdf_world* world, const char *message);

/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_test_error(world, "test error message number 1.");
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_test_warning(world, "test warning message number 2.");
}


extern char const *const librdf_short_copyright_string;
extern char const *const librdf_copyright_string;
extern char const *const librdf_version_string;
extern unsigned int const librdf_version_major;
extern unsigned int const librdf_version_minor;
extern unsigned int const librdf_version_release;
extern unsigned int const librdf_version_decimal;
static VALUE
_wrap_librdf_new_world(int argc, VALUE *argv, VALUE self) {
    librdf_world *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (librdf_world *)librdf_new_world();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_world,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_world(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    librdf_free_world(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_world_open(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    librdf_world_open(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_free_iterator(int argc, VALUE *argv, VALUE self) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_iterator, 1);
    librdf_free_iterator(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_iterator_end(int argc, VALUE *argv, VALUE self) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_iterator, 1);
    result = (int)librdf_iterator_end(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_iterator_get_object(int argc, VALUE *argv, VALUE self) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_iterator, 1);
    result = (librdf_node *)librdf_iterator_get_object(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_iterator_get_context(int argc, VALUE *argv, VALUE self) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_iterator, 1);
    result = (librdf_node *)librdf_iterator_get_context(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_iterator_next(int argc, VALUE *argv, VALUE self) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_iterator, 1);
    result = (int)librdf_iterator_next(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_new_uri(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    result = (librdf_uri *)librdf_new_uri(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_uri_from_uri(int argc, VALUE *argv, VALUE self) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_uri_from_filename(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri,0);
    return vresult;
}


static VALUE
_wrap_librdf_free_uri(int argc, VALUE *argv, VALUE self) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_uri, 1);
    librdf_free_uri(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_uri_to_string(int argc, VALUE *argv, VALUE self) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_uri, 1);
    result = (char *)librdf_uri_to_string(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    free(result);
    return vresult;
}


static VALUE
_wrap_librdf_uri_equals(int argc, VALUE *argv, VALUE self) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    result = (int)librdf_uri_equals(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_new_node(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    result = (librdf_node *)librdf_new_node(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_uri_string(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    result = (librdf_node *)librdf_new_node_from_uri_string(arg1,(char const *)arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_uri(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_literal(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 = (char *) NULL ;
    int arg4 = (int) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    if (argc > 2) {
        {
            arg3 = (argv[2] == Qnil) ? NULL : STR2CSTR(argv[2]);
        }
    }
    if (argc > 3) {
        arg4 = NUM2INT(argv[3]);
    }
    result = (librdf_node *)librdf_new_node_from_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_typed_literal(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 = (char *) NULL ;
    librdf_uri *arg4 = (librdf_uri *) NULL ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    if (argc > 2) {
        {
            arg3 = (argv[2] == Qnil) ? NULL : STR2CSTR(argv[2]);
        }
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_uri, 1);
    }
    result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_node(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_node *)librdf_new_node_from_node(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_node_from_blank_identifier(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 = (char *) NULL ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    if (argc > 1) {
        {
            arg2 = (argv[1] == Qnil) ? NULL : STR2CSTR(argv[1]);
        }
    }
    result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_node(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    librdf_free_node(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_node_get_uri(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_uri *)librdf_node_get_uri(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri,0);
    return vresult;
}


static VALUE
_wrap_librdf_node_get_type(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_get_type(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_get_literal_value(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (char *)librdf_node_get_literal_value(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    return vresult;
}


static VALUE
_wrap_librdf_node_get_literal_value_as_latin1(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    return vresult;
}


static VALUE
_wrap_librdf_node_get_literal_value_language(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (char *)librdf_node_get_literal_value_language(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    return vresult;
}


static VALUE
_wrap_librdf_node_get_literal_value_datatype_uri(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_uri,0);
    return vresult;
}


static VALUE
_wrap_librdf_node_get_literal_value_is_wf_xml(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_to_string(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (char *)librdf_node_to_string(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    free(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_get_blank_identifier(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (char *)librdf_node_get_blank_identifier(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    return vresult;
}


static VALUE
_wrap_librdf_node_is_resource(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_is_resource(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_is_literal(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_is_literal(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_is_blank(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_is_blank(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_node_equals(int argc, VALUE *argv, VALUE self) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_node_equals(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_new_statement(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_statement *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    result = (librdf_statement *)librdf_new_statement(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_statement_from_statement(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_statement_from_nodes(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    librdf_statement *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_statement(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    librdf_free_statement(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_statement_get_subject(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    result = (librdf_node *)librdf_statement_get_subject(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_statement_set_subject(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    librdf_statement_set_subject(arg1,arg2);
    
    return Qnil;
}


static VALUE
_wrap_librdf_statement_get_predicate(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    result = (librdf_node *)librdf_statement_get_predicate(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_statement_set_predicate(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    librdf_statement_set_predicate(arg1,arg2);
    
    return Qnil;
}


static VALUE
_wrap_librdf_statement_get_object(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    result = (librdf_node *)librdf_statement_get_object(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_statement_set_object(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    librdf_statement_set_object(arg1,arg2);
    
    return Qnil;
}


static VALUE
_wrap_librdf_statement_equals(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_statement_equals(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_statement_match(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_statement_match(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_statement_to_string(int argc, VALUE *argv, VALUE self) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_statement, 1);
    result = (char *)librdf_statement_to_string(arg1);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    free(result);
    return vresult;
}


static VALUE
_wrap_librdf_new_model(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    char *arg3 ;
    librdf_model *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_storage, 1);
    arg3 = STR2CSTR(argv[2]);
    result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_model_with_options(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    librdf_hash *arg3 = (librdf_hash *) 0 ;
    librdf_model *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_storage, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_hash, 1);
    result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_model_from_model(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_model *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    result = (librdf_model *)librdf_new_model_from_model(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_model,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_model(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    librdf_free_model(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_model_size(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    result = (int)librdf_model_size(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_add(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_add_typed_literal_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    char *arg4 ;
    char *arg5 ;
    librdf_uri *arg6 = (librdf_uri *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    arg4 = STR2CSTR(argv[3]);
    arg5 = STR2CSTR(argv[4]);
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_librdf_uri, 1);
    result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_add_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_model_add_statement(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_add_statements(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *arg2 = (librdf_stream *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_stream, 1);
    result = (int)librdf_model_add_statements(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_remove_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_model_remove_statement(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_contains_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_model_contains_statement(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    result = (librdf_stream *)librdf_model_as_stream(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_find_statements(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_find_statements_in_context(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_statement, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_stream *)librdf_model_find_statements_in_context(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_sources(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_arcs(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_targets(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_source(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_arc(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_arcs_out(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_get_arcs_out(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_arcs_in(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_get_arcs_in(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_has_arc_in(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_has_arc_in(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,0);
    return vresult;
}


static VALUE
_wrap_librdf_model_has_arc_out(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_iterator *)librdf_model_has_arc_out(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,0);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_target(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_context_add_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_context_add_statements(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *arg3 = (librdf_stream *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_stream, 1);
    result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_context_remove_statement(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_statement, 1);
    result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_context_remove_statements(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_model_context_remove_statements(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_context_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_node, 1);
    result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_sync(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    librdf_model_sync(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_model_get_contexts(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_iterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    result = (librdf_iterator *)librdf_model_get_contexts(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_iterator,1);
    return vresult;
}


static VALUE
_wrap_librdf_model_get_feature(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_node *)librdf_model_get_feature(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_model_set_feature(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_model_set_feature(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_load(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 = (char *) NULL ;
    char *arg4 = (char *) NULL ;
    librdf_uri *arg5 = (librdf_uri *) NULL ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    if (argc > 2) {
        {
            arg3 = (argv[2] == Qnil) ? NULL : STR2CSTR(argv[2]);
        }
    }
    if (argc > 3) {
        {
            arg4 = (argv[3] == Qnil) ? NULL : STR2CSTR(argv[3]);
        }
    }
    if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_librdf_uri, 1);
    }
    result = (int)librdf_model_load(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_model_query_execute(int argc, VALUE *argv, VALUE self) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_query *arg2 = (librdf_query *) 0 ;
    librdf_query_results *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_model, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_query, 1);
    result = (librdf_query_results *)librdf_model_query_execute(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_query_results,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_storage(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    librdf_storage *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    arg3 = STR2CSTR(argv[2]);
    arg4 = STR2CSTR(argv[3]);
    result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_storage,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_storage_from_storage(int argc, VALUE *argv, VALUE self) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    librdf_storage *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_storage, 1);
    result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_storage,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_storage(int argc, VALUE *argv, VALUE self) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_storage, 1);
    librdf_free_storage(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_new_parser(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_parser *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    arg3 = STR2CSTR(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_parser,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_parser(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    librdf_free_parser(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_parser_parse_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_parser_parse_into_model(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_model, 1);
    result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_parser_parse_string_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    arg2 = STR2CSTR(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_parser_parse_string_into_model(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    arg2 = STR2CSTR(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_model, 1);
    result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_parser_parse_counted_string_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    size_t arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    arg2 = STR2CSTR(argv[1]);
    arg3 = NUM2LONG(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_stream *)librdf_parser_parse_counted_string_as_stream(arg1,(char const *)arg2,arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,0);
    return vresult;
}


static VALUE
_wrap_librdf_parser_parse_counted_string_into_model(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    size_t arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_model *arg5 = (librdf_model *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    arg2 = STR2CSTR(argv[1]);
    arg3 = NUM2LONG(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_librdf_model, 1);
    result = (int)librdf_parser_parse_counted_string_into_model(arg1,(char const *)arg2,arg3,arg4,arg5);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_parser_get_feature(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_node *)librdf_parser_get_feature(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_parser_set_feature(int argc, VALUE *argv, VALUE self) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_parser, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_parser_set_feature(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_new_query(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    char *arg4 ;
    librdf_query *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    arg4 = STR2CSTR(argv[3]);
    result = (librdf_query *)librdf_new_query(arg1,(char const *)arg2,arg3,(char const *)arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_query,1);
    return vresult;
}


static VALUE
_wrap_librdf_new_query_from_query(int argc, VALUE *argv, VALUE self) {
    librdf_query *arg1 = (librdf_query *) 0 ;
    librdf_query *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query, 1);
    result = (librdf_query *)librdf_new_query_from_query(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_query,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_query(int argc, VALUE *argv, VALUE self) {
    librdf_query *arg1 = (librdf_query *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query, 1);
    librdf_free_query(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_query_execute(int argc, VALUE *argv, VALUE self) {
    librdf_query *arg1 = (librdf_query *) 0 ;
    librdf_model *arg2 = (librdf_model *) 0 ;
    librdf_query_results *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_model, 1);
    result = (librdf_query_results *)librdf_query_execute(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_query_results,1);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_as_stream(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    librdf_stream *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    result = (librdf_stream *)librdf_query_results_as_stream(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_stream,1);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_get_count(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    result = (int)librdf_query_results_get_count(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_next(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    result = (int)librdf_query_results_next(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_finished(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    result = (int)librdf_query_results_finished(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_get_binding_value(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int arg2 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    arg2 = NUM2INT(argv[1]);
    result = (librdf_node *)librdf_query_results_get_binding_value(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_get_binding_name(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int arg2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    arg2 = NUM2INT(argv[1]);
    result = (char *)librdf_query_results_get_binding_name(arg1,arg2);
    
    {
        vresult = (result == NULL) ? Qnil : rb_str_new2(result);
    }
    return vresult;
}


static VALUE
_wrap_librdf_query_results_get_binding_value_by_name(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    char *arg2 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    arg2 = STR2CSTR(argv[1]);
    result = (librdf_node *)librdf_query_results_get_binding_value_by_name(arg1,(char const *)arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,1);
    return vresult;
}


static VALUE
_wrap_librdf_query_results_get_bindings_count(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    result = (int)librdf_query_results_get_bindings_count(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_free_query_results(int argc, VALUE *argv, VALUE self) {
    librdf_query_results *arg1 = (librdf_query_results *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_query_results, 1);
    librdf_free_query_results(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_new_serializer(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_serializer *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    arg2 = STR2CSTR(argv[1]);
    arg3 = STR2CSTR(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_serializer,1);
    return vresult;
}


static VALUE
_wrap_librdf_free_serializer(int argc, VALUE *argv, VALUE self) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_serializer, 1);
    librdf_free_serializer(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_serializer_serialize_model_to_file(int argc, VALUE *argv, VALUE self) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_serializer, 1);
    arg2 = STR2CSTR(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_librdf_model, 1);
    result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_serializer_get_feature(int argc, VALUE *argv, VALUE self) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_serializer, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    result = (librdf_node *)librdf_serializer_get_feature(arg1,arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_serializer_set_feature(int argc, VALUE *argv, VALUE self) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_serializer, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_librdf_node, 1);
    result = (int)librdf_serializer_set_feature(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_serializer_set_namespace(int argc, VALUE *argv, VALUE self) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_serializer, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_librdf_uri, 1);
    arg3 = STR2CSTR(argv[2]);
    result = (int)librdf_serializer_set_namespace(arg1,arg2,(char const *)arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_free_stream(int argc, VALUE *argv, VALUE self) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_stream, 1);
    librdf_free_stream(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_stream_end(int argc, VALUE *argv, VALUE self) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_stream, 1);
    result = (int)librdf_stream_end(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_stream_next(int argc, VALUE *argv, VALUE self) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_stream, 1);
    result = (int)librdf_stream_next(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_librdf_stream_get_object(int argc, VALUE *argv, VALUE self) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_statement *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_stream, 1);
    result = (librdf_statement *)librdf_stream_get_object(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_statement,0);
    return vresult;
}


static VALUE
_wrap_librdf_stream_get_context(int argc, VALUE *argv, VALUE self) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_node *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_stream, 1);
    result = (librdf_node *)librdf_stream_get_context(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_librdf_node,0);
    return vresult;
}


static VALUE
_wrap_librdf_internal_test_error(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    librdf_internal_test_error(arg1);
    
    return Qnil;
}


static VALUE
_wrap_librdf_internal_test_warning(int argc, VALUE *argv, VALUE self) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_librdf_world, 1);
    librdf_internal_test_warning(arg1);
    
    return Qnil;
}


static VALUE
librdf_short_copyright_string_get(VALUE self) {
    VALUE _val;
    
    _val = rb_str_new2(librdf_short_copyright_string);    return _val;
}


static VALUE
librdf_copyright_string_get(VALUE self) {
    VALUE _val;
    
    _val = rb_str_new2(librdf_copyright_string);    return _val;
}


static VALUE
librdf_version_string_get(VALUE self) {
    VALUE _val;
    
    _val = rb_str_new2(librdf_version_string);    return _val;
}


static VALUE
librdf_version_major_get(VALUE self) {
    VALUE _val;
    
    _val = UINT2NUM(librdf_version_major);    return _val;
}


static VALUE
librdf_version_minor_get(VALUE self) {
    VALUE _val;
    
    _val = UINT2NUM(librdf_version_minor);    return _val;
}


static VALUE
librdf_version_release_get(VALUE self) {
    VALUE _val;
    
    _val = UINT2NUM(librdf_version_release);    return _val;
}


static VALUE
librdf_version_decimal_get(VALUE self) {
    VALUE _val;
    
    _val = UINT2NUM(librdf_version_decimal);    return _val;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_librdf_model[] = {{"_p_librdf_model", 0, "librdf_model *", 0},{"_p_librdf_model"},{0}};
static swig_type_info _swigt__p_size_t[] = {{"_p_size_t", 0, "size_t *", 0},{"_p_size_t"},{0}};
static swig_type_info _swigt__p_librdf_query_results[] = {{"_p_librdf_query_results", 0, "librdf_query_results *", 0},{"_p_librdf_query_results"},{0}};
static swig_type_info _swigt__p_librdf_hash[] = {{"_p_librdf_hash", 0, "librdf_hash *", 0},{"_p_librdf_hash"},{0}};
static swig_type_info _swigt__p_librdf_query[] = {{"_p_librdf_query", 0, "librdf_query *", 0},{"_p_librdf_query"},{0}};
static swig_type_info _swigt__p_librdf_world[] = {{"_p_librdf_world", 0, "librdf_world *", 0},{"_p_librdf_world"},{0}};
static swig_type_info _swigt__p_librdf_parser[] = {{"_p_librdf_parser", 0, "librdf_parser *", 0},{"_p_librdf_parser"},{0}};
static swig_type_info _swigt__p_librdf_node[] = {{"_p_librdf_node", 0, "librdf_node *", 0},{"_p_librdf_node"},{0}};
static swig_type_info _swigt__p_librdf_stream[] = {{"_p_librdf_stream", 0, "librdf_stream *", 0},{"_p_librdf_stream"},{0}};
static swig_type_info _swigt__p_librdf_statement[] = {{"_p_librdf_statement", 0, "librdf_statement *", 0},{"_p_librdf_statement"},{0}};
static swig_type_info _swigt__p_librdf_uri[] = {{"_p_librdf_uri", 0, "librdf_uri *", 0},{"_p_librdf_uri"},{0}};
static swig_type_info _swigt__p_librdf_storage[] = {{"_p_librdf_storage", 0, "librdf_storage *", 0},{"_p_librdf_storage"},{0}};
static swig_type_info _swigt__p_librdf_serializer[] = {{"_p_librdf_serializer", 0, "librdf_serializer *", 0},{"_p_librdf_serializer"},{0}};
static swig_type_info _swigt__p_librdf_iterator[] = {{"_p_librdf_iterator", 0, "librdf_iterator *", 0},{"_p_librdf_iterator"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_librdf_model, 
_swigt__p_size_t, 
_swigt__p_librdf_query_results, 
_swigt__p_librdf_hash, 
_swigt__p_librdf_query, 
_swigt__p_librdf_world, 
_swigt__p_librdf_parser, 
_swigt__p_librdf_node, 
_swigt__p_librdf_stream, 
_swigt__p_librdf_statement, 
_swigt__p_librdf_uri, 
_swigt__p_librdf_storage, 
_swigt__p_librdf_serializer, 
_swigt__p_librdf_iterator, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_redland(void) {
    int i;
    
    SWIG_InitRuntime();
    mRedland = rb_define_module("Redland");
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    /* compile-time include (inside a % ... % block) */
    #ifdef REDLAND_INIT_I
    #include <redland-init.i>
    #endif
    
    rb_define_module_function(mRedland, "librdf_new_world", _wrap_librdf_new_world, -1);
    rb_define_module_function(mRedland, "librdf_free_world", _wrap_librdf_free_world, -1);
    rb_define_module_function(mRedland, "librdf_world_open", _wrap_librdf_world_open, -1);
    rb_define_module_function(mRedland, "librdf_free_iterator", _wrap_librdf_free_iterator, -1);
    rb_define_module_function(mRedland, "librdf_iterator_end", _wrap_librdf_iterator_end, -1);
    rb_define_module_function(mRedland, "librdf_iterator_get_object", _wrap_librdf_iterator_get_object, -1);
    rb_define_module_function(mRedland, "librdf_iterator_get_context", _wrap_librdf_iterator_get_context, -1);
    rb_define_module_function(mRedland, "librdf_iterator_next", _wrap_librdf_iterator_next, -1);
    rb_define_module_function(mRedland, "librdf_new_uri", _wrap_librdf_new_uri, -1);
    rb_define_module_function(mRedland, "librdf_new_uri_from_uri", _wrap_librdf_new_uri_from_uri, -1);
    rb_define_module_function(mRedland, "librdf_new_uri_from_filename", _wrap_librdf_new_uri_from_filename, -1);
    rb_define_module_function(mRedland, "librdf_free_uri", _wrap_librdf_free_uri, -1);
    rb_define_module_function(mRedland, "librdf_uri_to_string", _wrap_librdf_uri_to_string, -1);
    rb_define_module_function(mRedland, "librdf_uri_equals", _wrap_librdf_uri_equals, -1);
    rb_define_module_function(mRedland, "librdf_new_node", _wrap_librdf_new_node, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_uri_string", _wrap_librdf_new_node_from_uri_string, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_uri", _wrap_librdf_new_node_from_uri, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_literal", _wrap_librdf_new_node_from_literal, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_typed_literal", _wrap_librdf_new_node_from_typed_literal, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_node", _wrap_librdf_new_node_from_node, -1);
    rb_define_module_function(mRedland, "librdf_new_node_from_blank_identifier", _wrap_librdf_new_node_from_blank_identifier, -1);
    rb_define_module_function(mRedland, "librdf_free_node", _wrap_librdf_free_node, -1);
    rb_define_module_function(mRedland, "librdf_node_get_uri", _wrap_librdf_node_get_uri, -1);
    rb_define_module_function(mRedland, "librdf_node_get_type", _wrap_librdf_node_get_type, -1);
    rb_define_module_function(mRedland, "librdf_node_get_literal_value", _wrap_librdf_node_get_literal_value, -1);
    rb_define_module_function(mRedland, "librdf_node_get_literal_value_as_latin1", _wrap_librdf_node_get_literal_value_as_latin1, -1);
    rb_define_module_function(mRedland, "librdf_node_get_literal_value_language", _wrap_librdf_node_get_literal_value_language, -1);
    rb_define_module_function(mRedland, "librdf_node_get_literal_value_datatype_uri", _wrap_librdf_node_get_literal_value_datatype_uri, -1);
    rb_define_module_function(mRedland, "librdf_node_get_literal_value_is_wf_xml", _wrap_librdf_node_get_literal_value_is_wf_xml, -1);
    rb_define_module_function(mRedland, "librdf_node_to_string", _wrap_librdf_node_to_string, -1);
    rb_define_module_function(mRedland, "librdf_node_get_blank_identifier", _wrap_librdf_node_get_blank_identifier, -1);
    rb_define_module_function(mRedland, "librdf_node_is_resource", _wrap_librdf_node_is_resource, -1);
    rb_define_module_function(mRedland, "librdf_node_is_literal", _wrap_librdf_node_is_literal, -1);
    rb_define_module_function(mRedland, "librdf_node_is_blank", _wrap_librdf_node_is_blank, -1);
    rb_define_module_function(mRedland, "librdf_node_equals", _wrap_librdf_node_equals, -1);
    rb_define_module_function(mRedland, "librdf_new_statement", _wrap_librdf_new_statement, -1);
    rb_define_module_function(mRedland, "librdf_new_statement_from_statement", _wrap_librdf_new_statement_from_statement, -1);
    rb_define_module_function(mRedland, "librdf_new_statement_from_nodes", _wrap_librdf_new_statement_from_nodes, -1);
    rb_define_module_function(mRedland, "librdf_free_statement", _wrap_librdf_free_statement, -1);
    rb_define_module_function(mRedland, "librdf_statement_get_subject", _wrap_librdf_statement_get_subject, -1);
    rb_define_module_function(mRedland, "librdf_statement_set_subject", _wrap_librdf_statement_set_subject, -1);
    rb_define_module_function(mRedland, "librdf_statement_get_predicate", _wrap_librdf_statement_get_predicate, -1);
    rb_define_module_function(mRedland, "librdf_statement_set_predicate", _wrap_librdf_statement_set_predicate, -1);
    rb_define_module_function(mRedland, "librdf_statement_get_object", _wrap_librdf_statement_get_object, -1);
    rb_define_module_function(mRedland, "librdf_statement_set_object", _wrap_librdf_statement_set_object, -1);
    rb_define_module_function(mRedland, "librdf_statement_equals", _wrap_librdf_statement_equals, -1);
    rb_define_module_function(mRedland, "librdf_statement_match", _wrap_librdf_statement_match, -1);
    rb_define_module_function(mRedland, "librdf_statement_to_string", _wrap_librdf_statement_to_string, -1);
    rb_define_module_function(mRedland, "librdf_new_model", _wrap_librdf_new_model, -1);
    rb_define_module_function(mRedland, "librdf_new_model_with_options", _wrap_librdf_new_model_with_options, -1);
    rb_define_module_function(mRedland, "librdf_new_model_from_model", _wrap_librdf_new_model_from_model, -1);
    rb_define_module_function(mRedland, "librdf_free_model", _wrap_librdf_free_model, -1);
    rb_define_module_function(mRedland, "librdf_model_size", _wrap_librdf_model_size, -1);
    rb_define_module_function(mRedland, "librdf_model_add", _wrap_librdf_model_add, -1);
    rb_define_module_function(mRedland, "librdf_model_add_typed_literal_statement", _wrap_librdf_model_add_typed_literal_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_add_statement", _wrap_librdf_model_add_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_add_statements", _wrap_librdf_model_add_statements, -1);
    rb_define_module_function(mRedland, "librdf_model_remove_statement", _wrap_librdf_model_remove_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_contains_statement", _wrap_librdf_model_contains_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_as_stream", _wrap_librdf_model_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_model_find_statements", _wrap_librdf_model_find_statements, -1);
    rb_define_module_function(mRedland, "librdf_model_find_statements_in_context", _wrap_librdf_model_find_statements_in_context, -1);
    rb_define_module_function(mRedland, "librdf_model_get_sources", _wrap_librdf_model_get_sources, -1);
    rb_define_module_function(mRedland, "librdf_model_get_arcs", _wrap_librdf_model_get_arcs, -1);
    rb_define_module_function(mRedland, "librdf_model_get_targets", _wrap_librdf_model_get_targets, -1);
    rb_define_module_function(mRedland, "librdf_model_get_source", _wrap_librdf_model_get_source, -1);
    rb_define_module_function(mRedland, "librdf_model_get_arc", _wrap_librdf_model_get_arc, -1);
    rb_define_module_function(mRedland, "librdf_model_get_arcs_out", _wrap_librdf_model_get_arcs_out, -1);
    rb_define_module_function(mRedland, "librdf_model_get_arcs_in", _wrap_librdf_model_get_arcs_in, -1);
    rb_define_module_function(mRedland, "librdf_model_has_arc_in", _wrap_librdf_model_has_arc_in, -1);
    rb_define_module_function(mRedland, "librdf_model_has_arc_out", _wrap_librdf_model_has_arc_out, -1);
    rb_define_module_function(mRedland, "librdf_model_get_target", _wrap_librdf_model_get_target, -1);
    rb_define_module_function(mRedland, "librdf_model_context_add_statement", _wrap_librdf_model_context_add_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_context_add_statements", _wrap_librdf_model_context_add_statements, -1);
    rb_define_module_function(mRedland, "librdf_model_context_remove_statement", _wrap_librdf_model_context_remove_statement, -1);
    rb_define_module_function(mRedland, "librdf_model_context_remove_statements", _wrap_librdf_model_context_remove_statements, -1);
    rb_define_module_function(mRedland, "librdf_model_context_as_stream", _wrap_librdf_model_context_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_model_sync", _wrap_librdf_model_sync, -1);
    rb_define_module_function(mRedland, "librdf_model_get_contexts", _wrap_librdf_model_get_contexts, -1);
    rb_define_module_function(mRedland, "librdf_model_get_feature", _wrap_librdf_model_get_feature, -1);
    rb_define_module_function(mRedland, "librdf_model_set_feature", _wrap_librdf_model_set_feature, -1);
    rb_define_module_function(mRedland, "librdf_model_load", _wrap_librdf_model_load, -1);
    rb_define_module_function(mRedland, "librdf_model_query_execute", _wrap_librdf_model_query_execute, -1);
    rb_define_module_function(mRedland, "librdf_new_storage", _wrap_librdf_new_storage, -1);
    rb_define_module_function(mRedland, "librdf_new_storage_from_storage", _wrap_librdf_new_storage_from_storage, -1);
    rb_define_module_function(mRedland, "librdf_free_storage", _wrap_librdf_free_storage, -1);
    rb_define_module_function(mRedland, "librdf_new_parser", _wrap_librdf_new_parser, -1);
    rb_define_module_function(mRedland, "librdf_free_parser", _wrap_librdf_free_parser, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_as_stream", _wrap_librdf_parser_parse_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_into_model", _wrap_librdf_parser_parse_into_model, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_string_as_stream", _wrap_librdf_parser_parse_string_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_string_into_model", _wrap_librdf_parser_parse_string_into_model, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_counted_string_as_stream", _wrap_librdf_parser_parse_counted_string_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_parser_parse_counted_string_into_model", _wrap_librdf_parser_parse_counted_string_into_model, -1);
    rb_define_module_function(mRedland, "librdf_parser_get_feature", _wrap_librdf_parser_get_feature, -1);
    rb_define_module_function(mRedland, "librdf_parser_set_feature", _wrap_librdf_parser_set_feature, -1);
    rb_define_module_function(mRedland, "librdf_new_query", _wrap_librdf_new_query, -1);
    rb_define_module_function(mRedland, "librdf_new_query_from_query", _wrap_librdf_new_query_from_query, -1);
    rb_define_module_function(mRedland, "librdf_free_query", _wrap_librdf_free_query, -1);
    rb_define_module_function(mRedland, "librdf_query_execute", _wrap_librdf_query_execute, -1);
    rb_define_module_function(mRedland, "librdf_query_results_as_stream", _wrap_librdf_query_results_as_stream, -1);
    rb_define_module_function(mRedland, "librdf_query_results_get_count", _wrap_librdf_query_results_get_count, -1);
    rb_define_module_function(mRedland, "librdf_query_results_next", _wrap_librdf_query_results_next, -1);
    rb_define_module_function(mRedland, "librdf_query_results_finished", _wrap_librdf_query_results_finished, -1);
    rb_define_module_function(mRedland, "librdf_query_results_get_binding_value", _wrap_librdf_query_results_get_binding_value, -1);
    rb_define_module_function(mRedland, "librdf_query_results_get_binding_name", _wrap_librdf_query_results_get_binding_name, -1);
    rb_define_module_function(mRedland, "librdf_query_results_get_binding_value_by_name", _wrap_librdf_query_results_get_binding_value_by_name, -1);
    rb_define_module_function(mRedland, "librdf_query_results_get_bindings_count", _wrap_librdf_query_results_get_bindings_count, -1);
    rb_define_module_function(mRedland, "librdf_free_query_results", _wrap_librdf_free_query_results, -1);
    rb_define_module_function(mRedland, "librdf_new_serializer", _wrap_librdf_new_serializer, -1);
    rb_define_module_function(mRedland, "librdf_free_serializer", _wrap_librdf_free_serializer, -1);
    rb_define_module_function(mRedland, "librdf_serializer_serialize_model_to_file", _wrap_librdf_serializer_serialize_model_to_file, -1);
    rb_define_module_function(mRedland, "librdf_serializer_get_feature", _wrap_librdf_serializer_get_feature, -1);
    rb_define_module_function(mRedland, "librdf_serializer_set_feature", _wrap_librdf_serializer_set_feature, -1);
    rb_define_module_function(mRedland, "librdf_serializer_set_namespace", _wrap_librdf_serializer_set_namespace, -1);
    rb_define_module_function(mRedland, "librdf_free_stream", _wrap_librdf_free_stream, -1);
    rb_define_module_function(mRedland, "librdf_stream_end", _wrap_librdf_stream_end, -1);
    rb_define_module_function(mRedland, "librdf_stream_next", _wrap_librdf_stream_next, -1);
    rb_define_module_function(mRedland, "librdf_stream_get_object", _wrap_librdf_stream_get_object, -1);
    rb_define_module_function(mRedland, "librdf_stream_get_context", _wrap_librdf_stream_get_context, -1);
    rb_define_module_function(mRedland, "librdf_internal_test_error", _wrap_librdf_internal_test_error, -1);
    rb_define_module_function(mRedland, "librdf_internal_test_warning", _wrap_librdf_internal_test_warning, -1);
    rb_define_singleton_method(mRedland, "librdf_short_copyright_string", librdf_short_copyright_string_get, 0);
    rb_define_singleton_method(mRedland, "librdf_copyright_string", librdf_copyright_string_get, 0);
    rb_define_singleton_method(mRedland, "librdf_version_string", librdf_version_string_get, 0);
    rb_define_singleton_method(mRedland, "librdf_version_major", librdf_version_major_get, 0);
    rb_define_singleton_method(mRedland, "librdf_version_minor", librdf_version_minor_get, 0);
    rb_define_singleton_method(mRedland, "librdf_version_release", librdf_version_release_get, 0);
    rb_define_singleton_method(mRedland, "librdf_version_decimal", librdf_version_decimal_get, 0);
}

