// ==UserScript==
// @include       http://news.google.*/*
// @include       https://news.google.*/*
// @require       utils.js
// @require       google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['main-wrapper', 'main'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    setInterval(wrapCallback(function () {
        var i, recent = document.getElementById('s_BREAKING_NEWS_BOX');

        if (!recent) {
            return;
        }

        var res = document.evaluate('div[2]/div', recent, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
        for (i = 0; i < res.snapshotLength; i++) {
            var node = res.snapshotItem(i);
            var id = node.className.match(/\d+/)[0];
            var title = document.evaluate('div[@class="title"]', node, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;

            if (!localStorage.getItem(id)) {
                localStorage.setItem(id, true);
                Unity.Notification.showNotification(_("Google News"), title, null);
            }
        }
    }), 2000);
    doMainMenuIntegration(document);
}

if (isCorrectPage()) {
    Unity.init({ name: _("Google News"),
		 homepage: 'http://' + window.location.hostname + '/',
		 domain: window.location.hostname,
		 iconUrl: "icon://unity-webapps-google-news",
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
