// ==UserScript==
// @include       http://edition.cnn.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['hdr-banner-title', 'hdr-search'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function markAsRead(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        localStorage.setItem(items[i], true);
    }
}

function getHeaders(doc) {
    var res = [], i;
    var snapshot = doc.evaluate('//ul[@class="cnn_bulletbin"]/li/a',
                                doc, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);

    reportTestState('total:' + snapshot.snapshotLength);
    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);
        if (node.textContent.length && !localStorage.getItem(node.textContent)) {
            res.push(node.textContent);
        }
    }
    reportTestState('new:' + res.length);
    return res;
}

function showNotifications(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        Unity.Notification.showNotification("CNN", items[i], null);
    }
    markAsRead(items);
}

function messagingIndicatorSetup() {
    var iframe = document.createElement('iframe');
    iframe.width = 0;
    iframe.height = 0;
    iframe.src = "http://edition.cnn.com/?sdas";
    document.body.appendChild(iframe);
    markAsRead(getHeaders(document));

    function retry() {
        iframe.src = "http://edition.cnn.com/?sda";
    }
    iframe.onload = wrapCallback(function () {
        showNotifications(getHeaders(iframe.contentWindow.document));
        setTimeout(retry, 5000);
    });
    retry();
}

if (isCorrectPage()) {
    Unity.toDataURL('http://i.cdn.turner.com/cnn/.e/img/3.0/global/header/intl/hdr-globe-central.gif', function (aResult, uri) {
        Unity.init({ name: "CNN",
		     homepage: 'http://edition.cnn.com/',
		     domain: 'cnn.com',
                     iconUrl: uri,
		     onInit: wrapCallback(messagingIndicatorSetup) });
    });
}
