// ==UserScript==
// @include       http://mail.yandex.*/*
// @include       https://mail.yandex.*/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function messagingIndicatorSetup() {
    function checkMessangesCount() {
        var snapshot = document.evaluate('//div[@class="b-folders"]/div/span[@class="b-folders__folder__name"]',
                                         document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);
        var selfTest = snapshot.snapshotLength > 1, i;

        Unity.MessagingIndicator.clearIndicators();
        for (i = 0; i < snapshot.snapshotLength; i++) {
            var node = snapshot.snapshotItem(i);

            var title = node.textContent;
            if (node.parentNode.firstChild.firstChild.className !== 'b-folders__counters') {
                console.log(node.parentNode.firstChild.firstChild.className);
                selfTest = false;
            } else {
                var count = node.parentNode.firstChild.firstChild.textContent;
                if (!count.match(/^\d+/)) {
                    count = '0';
                } else {
                    count = count.match(/^\d+/)[0];
                }
                Unity.MessagingIndicator.showIndicator(title, { count: count });
            }
        }
        if (selfTest) {
            reportTestState('PASS SELF TEST');
        }
    }
    setInterval(wrapCallback(checkMessangesCount), 6000);
    checkMessangesCount();
}

if (document.getElementsByClassName('b-folders__counters').length) {
    Unity.init({ name: _("Yandex"),
		 domains: [['mail.yandex.com', 'http://mail.yandex.com'], ['mail.yandex.ru', 'http://mail.yandex.ru']],
                 iconUrl: "icon://unity-webapps-yandex-mail",
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
