// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_3_3_autogen.cpp:
//   Defines the GL 3.3 entry points.

#include "libGL/entry_points_gl_3_3_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL33_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BindFragDataLocationIndexed(GLuint program,
                                             GLuint colorNumber,
                                             GLuint index,
                                             const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindFragDataLocationIndexed",
          "context = %d, GLuint program = %u, GLuint colorNumber = %u, GLuint index = %u, const "
          "GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindFragDataLocationIndexed(context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexed, isCallValid, context, programPacked, colorNumber,
                      index, name);
    }
}

void GL_APIENTRY BindSampler(GLuint unit, GLuint sampler)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindSampler", "context = %d, GLuint unit = %u, GLuint sampler = %u", CID(context),
          unit, sampler);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindSampler(context, unit, samplerPacked));
        if (isCallValid)
        {
            context->bindSampler(unit, samplerPacked);
        }
        ANGLE_CAPTURE(BindSampler, isCallValid, context, unit, samplerPacked);
    }
}

void GL_APIENTRY ColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glColorP3ui", "context = %d, GLenum type = %s, GLuint color = %u", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP3ui(context, type, color));
        if (isCallValid)
        {
            context->colorP3ui(type, color);
        }
        ANGLE_CAPTURE(ColorP3ui, isCallValid, context, type, color);
    }
}

void GL_APIENTRY ColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glColorP3uiv", "context = %d, GLenum type = %s, const GLuint *color = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP3uiv(context, type, color));
        if (isCallValid)
        {
            context->colorP3uiv(type, color);
        }
        ANGLE_CAPTURE(ColorP3uiv, isCallValid, context, type, color);
    }
}

void GL_APIENTRY ColorP4ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glColorP4ui", "context = %d, GLenum type = %s, GLuint color = %u", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP4ui(context, type, color));
        if (isCallValid)
        {
            context->colorP4ui(type, color);
        }
        ANGLE_CAPTURE(ColorP4ui, isCallValid, context, type, color);
    }
}

void GL_APIENTRY ColorP4uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glColorP4uiv", "context = %d, GLenum type = %s, const GLuint *color = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP4uiv(context, type, color));
        if (isCallValid)
        {
            context->colorP4uiv(type, color);
        }
        ANGLE_CAPTURE(ColorP4uiv, isCallValid, context, type, color);
    }
}

void GL_APIENTRY DeleteSamplers(GLsizei count, const GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteSamplers",
          "context = %d, GLsizei count = %d, const GLuint *samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context)
    {
        const SamplerID *samplersPacked                       = FromGL<const SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->deleteSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(DeleteSamplers, isCallValid, context, count, samplersPacked);
    }
}

void GL_APIENTRY GenSamplers(GLsizei count, GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenSamplers", "context = %d, GLsizei count = %d, GLuint *samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context)
    {
        SamplerID *samplersPacked                             = FromGL<SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->genSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(GenSamplers, isCallValid, context, count, samplersPacked);
    }
}

GLint GL_APIENTRY GetFragDataIndex(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFragDataIndex",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFragDataIndex(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndex, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndex, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndex, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetQueryObjecti64v",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjecti64v(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64v, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryObjectui64v",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectui64v(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64v, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIiv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIuiv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterfv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterfv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterfv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameteriv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameteriv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameteriv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameteriv, isCallValid, context, samplerPacked, pname, params);
    }
}

GLboolean GL_APIENTRY IsSampler(GLuint sampler)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsSampler", "context = %d, GLuint sampler = %u", CID(context), sampler);

    GLboolean returnValue;
    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSampler(context, samplerPacked));
        if (isCallValid)
        {
            returnValue = context->isSampler(samplerPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
        }
        ANGLE_CAPTURE(IsSampler, isCallValid, context, samplerPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY MultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiTexCoordP1ui",
          "context = %d, GLenum texture = %s, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP1ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP1ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP1ui, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glMultiTexCoordP1uiv",
        "context = %d, GLenum texture = %s, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureUnit, texture),
        GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP1uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP1uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP1uiv, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiTexCoordP2ui",
          "context = %d, GLenum texture = %s, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP2ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP2ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP2ui, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glMultiTexCoordP2uiv",
        "context = %d, GLenum texture = %s, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureUnit, texture),
        GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP2uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP2uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP2uiv, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiTexCoordP3ui",
          "context = %d, GLenum texture = %s, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP3ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP3ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP3ui, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glMultiTexCoordP3uiv",
        "context = %d, GLenum texture = %s, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureUnit, texture),
        GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP3uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP3uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP3uiv, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiTexCoordP4ui",
          "context = %d, GLenum texture = %s, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP4ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP4ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP4ui, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY MultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glMultiTexCoordP4uiv",
        "context = %d, GLenum texture = %s, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureUnit, texture),
        GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP4uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP4uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP4uiv, isCallValid, context, texture, type, coords);
    }
}

void GL_APIENTRY NormalP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNormalP3ui", "context = %d, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormalP3ui(context, type, coords));
        if (isCallValid)
        {
            context->normalP3ui(type, coords);
        }
        ANGLE_CAPTURE(NormalP3ui, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY NormalP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNormalP3uiv",
          "context = %d, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateNormalP3uiv(context, type, coords));
        if (isCallValid)
        {
            context->normalP3uiv(type, coords);
        }
        ANGLE_CAPTURE(NormalP3uiv, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY QueryCounter(GLuint id, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glQueryCounter", "context = %d, GLuint id = %u, GLenum target = %s", CID(context), id,
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        QueryType targetPacked                                = FromGL<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryCounter(context, idPacked, targetPacked));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE(QueryCounter, isCallValid, context, idPacked, targetPacked);
    }
}

void GL_APIENTRY SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glSamplerParameterIiv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIiv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glSamplerParameterIuiv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLuint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIuiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuiv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterf",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLfloat param = %f", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterf(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterf(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterf, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterfv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLfloat *param = "
          "0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterfv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterfv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterfv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameteri",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint param = %d", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameteri(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteri(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteri, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glSamplerParameteriv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameteriv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteriv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteriv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SecondaryColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSecondaryColorP3ui", "context = %d, GLenum type = %s, GLuint color = %u", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSecondaryColorP3ui(context, type, color));
        if (isCallValid)
        {
            context->secondaryColorP3ui(type, color);
        }
        ANGLE_CAPTURE(SecondaryColorP3ui, isCallValid, context, type, color);
    }
}

void GL_APIENTRY SecondaryColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSecondaryColorP3uiv",
          "context = %d, GLenum type = %s, const GLuint *color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSecondaryColorP3uiv(context, type, color));
        if (isCallValid)
        {
            context->secondaryColorP3uiv(type, color);
        }
        ANGLE_CAPTURE(SecondaryColorP3uiv, isCallValid, context, type, color);
    }
}

void GL_APIENTRY TexCoordP1ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP1ui", "context = %d, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP1ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP1ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP1ui, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP1uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP1uiv",
          "context = %d, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP1uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP1uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP1uiv, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP2ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP2ui", "context = %d, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP2ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP2ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP2ui, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP2uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP2uiv",
          "context = %d, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP2uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP2uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP2uiv, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP3ui", "context = %d, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP3ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP3ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP3ui, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP3uiv",
          "context = %d, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP3uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP3uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP3uiv, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP4ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP4ui", "context = %d, GLenum type = %s, GLuint coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP4ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP4ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP4ui, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY TexCoordP4uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexCoordP4uiv",
          "context = %d, GLenum type = %s, const GLuint *coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP4uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP4uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP4uiv, isCallValid, context, type, coords);
    }
}

void GL_APIENTRY VertexAttribDivisor(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribDivisor", "context = %d, GLuint index = %u, GLuint divisor = %u",
          CID(context), index, divisor);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribDivisor(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisor, isCallValid, context, index, divisor);
    }
}

void GL_APIENTRY VertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP1ui",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, GLuint "
          "value = %u",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP1ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP1ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP1ui, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP1uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP1uiv",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP1uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP1uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP1uiv, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP2ui",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, GLuint "
          "value = %u",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP2ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP2ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP2ui, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP2uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP2uiv",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP2uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP2uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP2uiv, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP3ui",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, GLuint "
          "value = %u",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP3ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP3ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP3ui, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP3uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP3uiv",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP3uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP3uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP3uiv, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP4ui",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, GLuint "
          "value = %u",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP4ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP4ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP4ui, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexAttribP4uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribP4uiv",
          "context = %d, GLuint index = %u, GLenum type = %s, GLboolean normalized = %s, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP4uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP4uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP4uiv, isCallValid, context, index, type, normalized, value);
    }
}

void GL_APIENTRY VertexP2ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP2ui", "context = %d, GLenum type = %s, GLuint value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP2ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP2ui(type, value);
        }
        ANGLE_CAPTURE(VertexP2ui, isCallValid, context, type, value);
    }
}

void GL_APIENTRY VertexP2uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP2uiv",
          "context = %d, GLenum type = %s, const GLuint *value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP2uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP2uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP2uiv, isCallValid, context, type, value);
    }
}

void GL_APIENTRY VertexP3ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP3ui", "context = %d, GLenum type = %s, GLuint value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP3ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP3ui(type, value);
        }
        ANGLE_CAPTURE(VertexP3ui, isCallValid, context, type, value);
    }
}

void GL_APIENTRY VertexP3uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP3uiv",
          "context = %d, GLenum type = %s, const GLuint *value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP3uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP3uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP3uiv, isCallValid, context, type, value);
    }
}

void GL_APIENTRY VertexP4ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP4ui", "context = %d, GLenum type = %s, GLuint value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP4ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP4ui(type, value);
        }
        ANGLE_CAPTURE(VertexP4ui, isCallValid, context, type, value);
    }
}

void GL_APIENTRY VertexP4uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexP4uiv",
          "context = %d, GLenum type = %s, const GLuint *value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP4uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP4uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP4uiv, isCallValid, context, type, value);
    }
}
}  // namespace gl
