'\" t
.TH x3270 1 "29 November 2003"
.SH "NAME"
x3270 \-
\s-1IBM\s+1 host access tool
.SH "SYNOPSIS"
\fBx3270\fP
[\fIoptions\fP]
[\fIhost\fP]

.SH "DESCRIPTION"
\fBx3270\fP opens
a telnet connection to an \s-1IBM\s+1
host in an X window.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection),
and supports IND$FILE file transfer.
The window created by \fBx3270\fP
can use its own font for displaying characters, so it is a fairly accurate
representation of an \s-1IBM\s+1 3278 or 3279.
It is similar to \fItn3270\fP(1) except that it is X-based, not curses-based.
.LP
The full syntax for \fIhost\fP is:
.RS
[\fIprefix\fP:]...[\fILUname\fP@]\fIhostname\fP[:\fIport\fP]
.RE
.LP
Prepending a \fBP:\fP onto \fIhostname\fP causes the connection to go
through the \fItelnet-passthru\fP service rather than directly to the host.
See \s-1PASSTHRU\s+1 below.
.LP
Prepending an \fBS:\fP onto \fIhostname\fP removes the "extended data
stream" option reported to the host.
See \fB\-tn\fP below for further information.
.LP
Prepending an \fBN:\fP onto \fIhostname\fP
turns off TN3270E support for the session.
.LP
Prepending an \fBL:\fP onto \fIhostname\fP
causes \fBx3270\fP to first create an SSL tunnel to the host, and then
create a TN3270 session inside the tunnel.  (This function is supported only if
\fBx3270\fP was built with SSL/TLS support).
Note that TLS-encrypted sessions using the TELNET START-TLS option are
negotiated with the host automatically; for these sessions the \fBL:\fP prefix
should not be used.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP with an `\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
On systems that support the \fIforkpty\fP library call, the
\fIhostname\fP may be replaced with \fB\-e\fP and a command string.
This will cause \fBx3270\fP to connect to a local child process, such as
a shell.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden with the \fB\-port\fP option, or by appending
a \fIport\fP to the \fIhostname\fP with a colon
`\fB:\fP'.
(For compatability with previous versions of \fBx3270\fP
and with \fItn3270\fP(1), the \fIport\fP
may also be specified as a second, separate argument.)
.SH "OPTIONS"
\fBx3270\fP is a toolkit based program, so it understands standard Xt options and
resources.
It also understands
the following options:
.TP
\fB\-activeicon\fP
Specifies that the icon should be a miniature version of the screen image.
See \s-1ICONS\s+1 below.
.TP
\fB\-apl\fP
Sets up \s-1APL\s+1 mode.
This is actually an abbreviation for several options.
See \s-1APL SUPPORT\s+1 below.
.TP
\fB\-cc\fP \fIrange\fP:\fIvalue\fP[,...]
Sets character classes.
See \s-1CHARACTER CLASSES\s+1, below.
.TP
\fB\-charset\fP \fIname\fP
Specifies an \s-1EBCDIC\s+1 host character set.
See \s-1CHARACTER SETS\s+1 below.
.TP
\fB\-clear\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBfalse\fP.
The list of toggle names is under \s-1MENUS\s+1
below.
.TP
\fB\-efont\fP \fIname\fP
Specifies a font for the emulator window.
See \s-1FONTS\s+1 below.
.TP
\fB\-iconname\fP \fIname\fP
Specifies an alternate title for the program icon.
.TP
\fB\-iconx\fP \fIx\fP
Specifies the initial x coordinate for the program icon.
.TP
\fB\-icony\fP \fIy\fP
Specifies the initial y coordinate for the program icon.
.TP
\fB\-im\fP \fImethod\fP
Specifies the name of the input method to use for multi-byte input.
(Supported only when x3270 is compiled with DBCS support.)
.TP
\fB\-keymap\fP \fIname\fP
Specifies a keymap name and optional modifiers.
See \s-1KEYMAPS\s+1 below.
.TP
\fB\-keypad\fP
Turns on the keypad as soon as \fBx3270\fP starts.
.TP
\fB\-km\fP \fIname\fP
Specifies the local encoding method for multi-byte text.
\fIname\fP is an encoding name recognized by the ICU library.
(Supported only when x3270 is compiled with DBCS support, and necessary
only when x3270 cannot figure it out from the locale.)
.TP
\fB\-model\fP \fIname\fP
The model of 3270 display to be emulated.
The model name is in two parts, either of which may be omitted:
.IP
The first part is the
\fBbase model\fP,
which is either \fB3278\fP or \fB3279\fP.
\fB3278\fP specifies a monochrome 3270 display;
\fB3279\fP specifies a color 3270 display.
When 3278 emulation is specified for a color X display, fields are displayed
using pseudo-colors; see \s-1PSEUDO-COLOR\s+1 below.
.IP
The second part is the
\fBmodel number\fP,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.TS
center;
c c c .
T{
.na
.nh
Model Number
T}	T{
.na
.nh
Columns
T}	T{
.na
.nh
Rows
T}
_
T{
.na
.nh
2
T}	T{
.na
.nh
80
T}	T{
.na
.nh
24
T}
T{
.na
.nh
3
T}	T{
.na
.nh
80
T}	T{
.na
.nh
30
T}
T{
.na
.nh
4
T}	T{
.na
.nh
80
T}	T{
.na
.nh
43
T}
T{
.na
.nh
5
T}	T{
.na
.nh
132
T}	T{
.na
.nh
27
T}
.TE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The default model
for a color X display
is \fB3279\-4\fP.
For a monochrome X display, it is
\fB3278\-4\fP.
(The behavior of early versions of \fBx3270\fP on color X displays
can be specified as \fB3278\-4)\fP.
.TP
\fB\-mono\fP
Forces \fBx3270\fP to believe it is running on a monochrome X display.
.TP
\fB\-once\fP
Causes \fBx3270\fP to exit after a host disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
\fB\-oversize\fP \fIcols\fP\fBx\fP\fIrows\fP
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(controlled by the "x3270.extended" resource), and only if the host
supports the Query Reply structured field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.TP
\fB\-port\fP \fIn\fP
Specifies a different \s-1TCP\s+1 port to connect to.
\fIn\fP can be a name from \fB/etc/services\fP like \fBtelnet\fP, or a
number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
\fB\-printerlu \fIluname\fP\fP
Causes \fBx3270\fP to automatically start a \fIpr3287\fP printer
session.
If \fIluname\fP is ".", then the printer session will be associated with the
interactive terminal session (this requires that the host support TN3270E).
Otherwise, the value is used as the explicit LU name to associate with the
printer session.
.TP
\fB\-pt\fP \fItype\fP
Specifies the preedit type for the multi-byte input method.
Valid values are \fBOverTheSpot\fP, \fBOffTheSpot\fP, \fBRoot\fP and
\fBOnTheSpot\fP.
The value for \fBOverTheSpot\fP can include an optional suffix, a signed
number indicating the vertical distance in rows of the preedit window from the
cursor position, e.g. \fBOverTheSpot+1\fP or \fBOverTheSpot-2\fP.
The default value is \fBOverTheSpot+1\fP.
(Supported only when x3270 is compiled with DBCS support.)
.TP
\fB\-reconnect\fP
Causes \fBx3270\fP
to automatically reconnect to the host if it ever disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
\fB\-sb\fP
Turns on the scrollbar.
.TP
\fB+sb\fP
Turns the scrollbar off.
.TP
\fB\-scheme\fP \fIname\fP
Specifes a color scheme to use in 3279 mode.
This option has effect only in combination with 3279 emulation.
See \s-1COLOR SCHEMES\s+1 below.
.TP
\fB\-script\fP
Causes
\fBx3270\fP
to read commands from standard input, with the results written to standard
output.
The protocol for these commands is documented in
\fIx3270-script\fP(1).
.TP
\fB\-sl\fP \fIn\fP
Specifies that \fIn\fP lines should be saved for scrolling back.
The default is 64.
.TP
\fB\-set\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBtrue\fP.
The list of toggle names is under \s-1MENUS\s+1
below.
.TP
\fB\-tn\fP \fIname\fP
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
\fBIBM\-\fP\fImodel_name\fP\fB\-E\fP,
for example,
\fBIBM\-3279\-4\-E\fP
for a color X display, or
\fBIBM\-3278\-4\-E\fP
for a monochrome X display.
.IP
Some hosts are confused by the \fB\-E\fP
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an \fBs:\fP on the hostname, or setting the "x3270.extended"
resource to "false", removes the \fB\-E\fP
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "x3270.termName" resource.
.TP
\fB\-trace\fP
Turns on data stream tracing at startup.
Unlike turning it on from a menu option,
there is no pop-up to confirm the file name, which defaults to
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
.TP
\fB\-tracefile\fP \fIfile\fP
Specifies a file to save data stream and event traces into, overriding the
default of
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
If the value \fBstdout\fP
is given, then traces will be written to standard output.
If the value \fBnone\fP
is given, then traces will be piped directly to the monitor window, and no
file will be created.
.TP
\fB\-tracefilesize\fP \fIsize\fP
Places a limit on the size of a trace file.
If this option is not specified, or is specified as \fB0\fP or \fBnone\fP,
the trace file will be unlimited.
If specified, the trace file cannot already exist, and the (silently enforced)
minimum size is 64 Kbytes.
The value of \fIsize\fP can have a \fBK\fP or \fBM\fP suffix, indicating
kilobytes or megabytes respectively.
.LP
After reading resource definitions from the X server
and any standandard X11 resource definition files
(\fB$HOME/.Xdefaults\fP, etc.), \fBx3270\fP will read definitions
from the file \fB$HOME/.x3270pro\fP.
This file contains local customizations and is also used to save changed
options by the \fBSave Changed Options in File\fP menu option.
.LP
Note that \fB\-xrm\fP options override any definitions in
the \fB.x3270pro\fP file.
.SH "FONTS"
\fBx3270\fP does not use the "*font" resource for its main
window.
Instead, it uses a custom 14-point font called
\fB3270\fP,
which is a close
approximation of a real 3270 display and allows \fBx3270\fP
to display the \s-1ISO\s+1 8859\-1 (Latin\-1)
character set and special status-line symbols.
A more compact font, \fB3270\-12\fP, is also supported, as are the
various sized fonts \fB3270gt8\fP, \fB3270gt12\fP, \fB3270gt16\fP,
\fB3270-20\fP, \fB3270gt24\fP, and \fB3270gt32\fP.
The fonts \fB3270h\fP and \fB3270gr\fP are also included to allow display of
Hebrew and Greek text, respectively.
.LP
The font may be specified with the \fB\-efont\fP
option or the "x3270.emulatorFont" resource.
.LP
\fBx3270\fP can also use any X11 font that implements the
display character set required by the host \s-1EBCDIC\s+1 character set.
.PP
An additional font,
\fB3270d\fP,
is supplied.
This font is identical to the default \fB3270\fP
font, except that it has bitmaps defined for field attribute characters.
This means that field attributes, which are normally displayed as blanks,
are now visible on the screen.
The characters displayed are hexadecimal codes, which can be translated
using a document provided with the \fBx3270\fP sources.
.LP
The font can be changed at any time through a menu option.
It can also be implicitly changed by changing the size of the \fBx3270\fP
window with the mouse: if the window is made larger, x3270 will try to
change to a larger font, and vice-versa.
.SH "CHARACTER SETS"
The \fB\-charset\fP
option or the "x3270.charset" resource controls the \s-1EBCDIC\s+1
host character set used by \fBx3270\fP.
Available sets include:
.PP
.TS
center;
l l l
lfB l l.
T{
.na
.nh
Charset Name
T}	T{
.na
.nh
Code Page
T}	T{
.na
.nh
Display Character Sets
T}
_
T{
.na
.nh
apl
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a
T}
T{
.na
.nh
belgian
T}	T{
.na
.nh
500
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
bracket
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
brazilian
T}	T{
.na
.nh
275
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
finnish
T}	T{
.na
.nh
278
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
french
T}	T{
.na
.nh
297
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
german
T}	T{
.na
.nh
273
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
greek
T}	T{
.na
.nh
423
T}	T{
.na
.nh
3270cg-7
T}
T{
.na
.nh
hebrew
T}	T{
.na
.nh
424
T}	T{
.na
.nh
3270cg-8
T}
T{
.na
.nh
icelandic
T}	T{
.na
.nh
871
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
iso-hebrew
T}	T{
.na
.nh
424
T}	T{
.na
.nh
iso8859-8
T}
T{
.na
.nh
iso-turkish
T}	T{
.na
.nh
1026
T}	T{
.na
.nh
iso8859-9
T}
T{
.na
.nh
italian
T}	T{
.na
.nh
280
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
japanese
T}	T{
.na
.nh
1027+300
T}	T{
.na
.nh
jisx0201.1976-0 + jisx0208.1983-0
T}
T{
.na
.nh
norwegian
T}	T{
.na
.nh
277
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
russian
T}	T{
.na
.nh
880
T}	T{
.na
.nh
koi8-r
T}
T{
.na
.nh
simplified-chinese
T}	T{
.na
.nh
836+837
T}	T{
.na
.nh
3270cg-1a iso8859-1 + gb2312.1980-0
T}
T{
.na
.nh
slovenian
T}	T{
.na
.nh
870
T}	T{
.na
.nh
iso8859-2
T}
T{
.na
.nh
thai
T}	T{
.na
.nh
838
T}	T{
.na
.nh
iso8859-11 tis620.2529-0
T}
T{
.na
.nh
uk
T}	T{
.na
.nh
285
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
T{
.na
.nh
us-intl
T}	T{
.na
.nh
37
T}	T{
.na
.nh
3270cg-1a 3270-cg1 iso8859-1
T}
.TE
.PP
The default character set is
\fBbracket\fP,
which is useful for common \s-1IBM\s+1 hosts which use \s-1EBCDIC\s+1
codes 0xAD and 0xBD for the `[' and `]' characters,
respectively.
.PP
Most 3270 fonts implement the 3270cg-1 display
character set, which is a reordered version of
the \s-1ISO\s+1 8859\-1 character set.
Some implement the 3270cg-1a display character set, which is a superset
of 3270cg-1 that includes APL2 characters.
3270h and 3270gr implement special character sets for Hebrew
and Greek, respectively.
.PP
You can also specify national-language translations for your keyboard;
see \s-1KEYMAPS\s+1 below.
.SH "CHARACTER CLASSES"
\fBx3270\fP supports character classes (groupings of characters chosen
with a double mouse click) in the same manner as \fIxterm\fP(1).
The "x3270.charClass" resource or the
\fB\-cc\fP option can be used to alter the character class table.
The default table is the same as
\fIxterm\fP's;
It groups letters together, and puts most punctuation characters in individual
classes.
To put all non-whitespace characters together in the same class (and
duplicate the behavior of some early versions of
\fBx3270\fP,
use the following value:
.PP
.RS
33-127:48,161-255:48
.RE
.PP
See \fIxterm\fP(1) for further syntax details.
.SH "KEYPAD"
A keypad may optionally be displayed, with a mouse-clickable button for each
3270 function key (these functions are also available from the keyboard).
The keypad can be turned on and off by clicking on the "keypad" button in the
upper-right-hand corner of the window.
The "x3270.keypad" resource controls where it is displayed.
Options are:
.PP
.TS
center;
l l.
T{
.na
.nh
left
T}	T{
.na
.nh
in a separate window, to the left of the screen
T}
T{
.na
.nh
right
T}	T{
.na
.nh
in a separate window, to the right of the screen
T}
T{
.na
.nh
bottom
T}	T{
.na
.nh
in a separate window, below the screen
T}
T{
.na
.nh
integral
T}	T{
.na
.nh
in the same window as the screen, below it
T}
.TE
.PP
The default is \fBright\fP.
.PP
If the "x3270.keypadOn" resource is set to
\fBtrue\fP,
the keypad will be displayed at startup.
.SH "HOSTS DATABASE"
\fBx3270\fP uses the \fIibm_hosts\fP database to
construct a pull-down menu of hosts to connect to.
It also allows host name aliases to be defined, as well as specifying
macros to be executed when a connection is first made.
See \fIibm_hosts\fP(5) for details.
.LP
You may specify a different \fIibm_hosts\fP
database with the "x3270.hostsFile" resource.
.SH "COLOR SCHEMES"
When emulating a 3279 display, the X colors used to draw the display
are selected by two resources: the "x3270.colorScheme" resource, which gives
the name of the color scheme to use, and the
individual "x3270.colorScheme.\fIxxx\fP" resources, which
give the actual definitions.
The color scheme resources are documented in the \fBResources\fP
file with the \fBx3270\fP source.
.LP
The color scheme may also be changed while \fBx3270\fP
is running with a selection from the \fBOptions\fP menu.
.SH "PSEUDO-COLOR"
When emulating a 3278 display on a color X display, \fBx3270\fP
does not understand \s-1IBM\s+1 3270 color protocols.
Instead, it draws text in one of three colors depending on the field attributes.
Those colors may be customized using the following resources (shown with their
default values):
.RS
.br
x3270.normalColor:	green
.br
x3270.boldColor:	cyan
.br
x3270.inputColor:	orange
.br
x3270.colorBackground:	black
.br
x3270.selectBackground:	dim gray
.RE
.SH "NVT (ANSI) MODE"
Some hosts use an \s-1ASCII\s+1 front-end to do initial login negotiation,
then later switch to 3270 mode.
\fBx3270\fP will emulate an \s-1ANSI\s+1 X.64 terminal until the host
places it in 3270 mode (telnet \s-1BINARY\s+1 and \s-1SEND EOR\s+1 modes, or
\s-1TN3270E\s+1 mode negotiation).
The emulation is fairly complete; however, it is
not intended to make \fBx3270\fP a replacement for \fIxterm\fP(1).
.PP
If the host later negotiates to stop functioning in 3270 mode,
\fBx3270\fP will return to \s-1ANSI\s+1 emulation.
.PP
In \s-1NVT\s+1 mode, \fBx3270\fP
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
T{
.na
.nh
Mode/Character
T}	T{
.na
.nh
Resource
T}	T{
.na
.nh
Default
T}
_
T{
.na
.nh
Translate CR to NL
T}	T{
.na
.nh
x3270.icrnl
T}	T{
.na
.nh
true
T}
T{
.na
.nh
Translate NL to CR
T}	T{
.na
.nh
x3270.inlcr
T}	T{
.na
.nh
false
T}
T{
.na
.nh
Erase previous character
T}	T{
.na
.nh
x3270.erase
T}	T{
.na
.nh
^?
T}
T{
.na
.nh
Erase entire line
T}	T{
.na
.nh
x3270.kill
T}	T{
.na
.nh
^U
T}
T{
.na
.nh
Erase previous word
T}	T{
.na
.nh
x3270.werase
T}	T{
.na
.nh
^W
T}
T{
.na
.nh
Redisplay line
T}	T{
.na
.nh
x3270.rprnt
T}	T{
.na
.nh
^R
T}
T{
.na
.nh
Ignore special meaning of next character
T}	T{
.na
.nh
x3270.lnext
T}	T{
.na
.nh
^V
T}
T{
.na
.nh
Interrupt
T}	T{
.na
.nh
x3270.intr
T}	T{
.na
.nh
^C
T}
T{
.na
.nh
Quit
T}	T{
.na
.nh
x3270.quit
T}	T{
.na
.nh
^\e
T}
T{
.na
.nh
End of file
T}	T{
.na
.nh
x3270.eof
T}	T{
.na
.nh
^D
T}
.TE
.LP
Separate keymaps can be defined for use only when \fBx3270\fP is in
3270 mode or \s-1NVT\s+1 mode.
See \s-1KEYMAPS\s+1 for details.
.SH "MENUS"
\fBx3270\fP has a menu bar with three pull-down menus (File, Options, and
Connect) and a button to turn the keypad on and off.
The pull-down menus are also available as pop-up menus by using the "Ctrl"
key and the left, middle and right mouse buttons, respectively.
.PP
The menu bar can be turned off by setting the "x3270.menuBar" resource to
\fBfalse.\fP
.PP
Many sections of the File and Options menus are toggles,
options that may be either on or off.
The entries under the File menu are as follows:
.TP
\fBFile Transfer\fP
Initiates transferring a file between the IBM host and the local workstation,
using the \fBIND$FILE\fP protocol.
A pop-up menu allows specifying the file names and other attributes of the
transfer.
.br
The IND$FILE program must be installed on the IBM host, and the 3270 cursor
must be located in a field that will accept a TSO or VM/CMS command.
.TP
\fBPrinter Session\fP
Starts or stops a printer session.
.TP
\fBTrace Data Stream\fP
If set, network traffic (both a hexadecimal representation and its
interpretation) are logged to the file
\fB/tmp/x3trc.\fP\fIprocess_id\fP,
and a window is popped up to monitor the data.
The file name is confirmed with a pop-up; the default directory name for the
trace file can be changed with the "x3270.traceDir" resource.
.TP
\fBTrace Keyboard/Mouse Events\fP
If set, information about keyboard and mouse events and the actions that
\fBx3270\fP takes in response are logged to a file.
This is the same file as used for tracing the data stream, above.
Event tracing is useful for creating and debugging custom keymaps, macros
and scripts.
For example, it will tell you precisely what action was taken in response to
pressing a particular key.
If the key is not mapped, it will tell you the keysym name and keycode so you
can add it to a custom keymap.
.TP
\fBSave Screen(s) in File\fP
If set, saves an \s-1ASCII\s+1 representation of the current screen image in
the file \fB/tmp/x3scr.\fP\fIprocess_id\fP.
A pop-up allows the file name to be changed; the default directory name can be
changed with the "x3270.traceDir" resource.
The pop-up also has buttons to choose between saving just the current image,
or continuously saving it as it is redrawn.
.TP
\fBSave Changed Options in File\fP
Saves into a file the values of all options that have been changed since
\fBx3270\fP was started.
A pop-up allows the file name to be changed; the default file
is \fB.x3270pro\fP in the user's home directory.
If the file already exists, it is appended to.
\fBx3270\fP will read the contents of this file the next time it starts up.
The options settings in the file override any resources defined
with \fBxrdb\fP or in the user's \fB.Xdefaults\fP
file; command-line switches override the file.
A different options file can be specified by the \fBX3270PRO\fP
environment variable.
If the environment variable \fBNOX3270PRO\fP
is set, no options file will be read.
.TP
\fBExecute an Action\fP
Allows an action name and parameters to be entered from the keyboard.
This allows experimentation with actions without having to edit keymaps
and repeatedly restart \fBx3270\fP.
.LP
The toggles under the Options menu are as follows:
.TP
\fBMonocase\fP
If set, \fBx3270\fP operates in uppercase-only mode.
.TP
\fBBlinking Cursor\fP
If set, the cursor blinks once per second.
.TP
\fBBlank Fill\fP
If set, \fBx3270\fP behaves in some un-3270-like ways.
First, when a character is typed into a field, all nulls in the field to the
left of that character are changed to blanks.
This eliminates a common 3270 data-entry surprise.
Second, in insert mode, trailing blanks in a field are treated like nulls,
eliminating the annoying `lock-up' that often occurs when inserting into an
field with (apparent) space at the end.
.TP
\fBShow Timing\fP
If set, the time taken by the host to process an \s-1AID\s+1 is displayed on
the status line.
.TP
\fBTrack Cursor\fP
If set, the cursor position is displayed on the status line.
.TP
\fBScrollbar\fP
If set, the scrollbar appears.
.TP
\fBWraparound\fP
If set, the \s-1ANSI\s+1 terminal emulator automatically assumes a \s-1NEWLINE\s+1
character when it reaches the end of a line.
.TP
\fBPaste with Left Margin\fP
If set, puts restrictions on how pasted text is placed on the screen.
The position of the cursor at the time the paste operation is begun is
used as a left margin.
No pasted text will fill any area of the screen to the left of that
position.
This option is useful for pasting into certain \s-1IBM\s+1 editors that use the
left side of the screen for control information.
.TP
\fBSelect by Rectangles\fP
If set, \fBx3270\fP will always select rectangular areas of the screen.
Otherwise, \fBx3270\fP
selects by rectangles when in 3270 mode, but in \s-1ANSI\s+1 mode it selects
continuous regions of the screen like \fIxterm\fP(1).
.TP
\fBCrosshair Cursor\fP
If set, \fBx3270\fP will display a crosshair over the cursor: lines extending
the full width and height of the screen, centered over the cursor position.
This makes locating the cursor on the screen much easier.
.LP
The names of the toggles for use with the \fB\-set\fP
and \fB\-clear\fP
options are as follows:
.LP
.TS
center;
l l .
T{
.na
.nh
Menu Option
T}	T{
.na
.nh
Name
T}
_
T{
.na
.nh
Monocase
T}	T{
.na
.nh
monoCase
T}
T{
.na
.nh
Blinking Cursor
T}	T{
.na
.nh
cursorBlink
T}
T{
.na
.nh
Blank Fill
T}	T{
.na
.nh
blankFill
T}
T{
.na
.nh
Show Timing
T}	T{
.na
.nh
showTiming
T}
T{
.na
.nh
Track Cursor
T}	T{
.na
.nh
cursorPos
T}
T{
.na
.nh
Trace Data Stream
T}	T{
.na
.nh
dsTrace
T}
T{
.na
.nh
Trace Keyboard/Mouse Events
T}	T{
.na
.nh
eventTrace
T}
T{
.na
.nh
Save Screen(s) in File
T}	T{
.na
.nh
screenTrace
T}
T{
.na
.nh
Scrollbar
T}	T{
.na
.nh
scrollBar
T}
T{
.na
.nh
Wraparound
T}	T{
.na
.nh
lineWrap
T}
T{
.na
.nh
Paste with Left Margin
T}	T{
.na
.nh
marginedPaste
T}
T{
.na
.nh
Select by Rectangles
T}	T{
.na
.nh
rectangleSelect
T}
T{
.na
.nh
Crosshair Cursor
T}	T{
.na
.nh
crosshair
T}
.TE
.LP
In addition, the toggle \fBaltCursor\fP can be used to select the cursor type.
If set, an underline cursor will be used.
If clear, the normal block cursor will be used.
.LP
These names also represent resources that can be set in your .Xdefaults
or .x3270pro file.
For example, if you always want to have the scrollbar on, you can add
the following to your .Xdefaults or .x3270pro:
.br
.RS
x3270.scrollBar:	true
.RE
.br
.LP
These names are also used as the first parameter to the \fBToggle\fP
action.
.SH "STATUS LINE"
The \fBx3270\fP status line contains a variety of information.
From left to right, the fields are:
.TP
\fBcomm status\fP
Three symbols indicate the state of the connection to the host.
If connected, the right-hand symbol is a solid box; if not, it is a
question mark.
.TP
\fBkeyboard lock\fP
If the keyboard is locked, an "X" symbol and a message field indicate the
reason for the keyboard lock.
.TP
\fBshift\fP
Three characters indicate the keyboard modifier status.
"M" indicates the Meta key, "A" the Alt key, and an up-arrow or "^"
indicates the Shift key.
.TP
\fBcompose\fP
The letter "C" indicates that a composite character is in progress.
If another symbol follows the "C", it is the first character of the
composite.
.TP
\fBtypeahead\fP
The letter "T" indicates that one or more keystrokes are in the typeahead
buffer.
.TP
\fBtemporary keymap\fP
The letter "K" indicates that a temporary keymap is in effect.
.TP
\fBreverse\fP
The letter "R" indicates that the keyboard is in reverse field entry mode.
.TP
\fBinsert mode\fP
A thick caret "^" or the 
letter "I" indicates that the keyboard is in insert mode.
.TP
\fBprinter session\fP
The letter "P" indicates that a \fIpr3287\fP session is active.
.TP
\fBscript\fP
The letter "S" indicates that a script is active.
.TP
\fBLU name\fP
The LU name associated with the session, if there is one.
.TP
\fBtiming\fP
A clock symbol and a time in seconds indicate the time it took to process
the last \s-1AID\s+1 or the time to connect to a host.
This display is optional.
.TP
\fBcursor position\fP
The cursor row and column are optionally displayed, separated by a "/".
.SH "ICONS"
If the \fB\-activeicon\fP
option is given (or the "x3270.activeIcon" resource is set to
\fBtrue\fP),
\fBx3270\fP will attempt to make its icon a miniature version of the
current screen image.
This function is highly dependent on your window manager:
.TP
\fBmwm\fP
The size of the icon is limited by the "Mwm.iconImageMaximum" resource, which
defaults to \fB50x50\fP.
The image will be clipped at the bottom and right.
The icon cannot accept keyboard input.
.TP
\fBolwm\fP
The full screen image of all 3270 models can be displayed on the icon.
However, the icon cannot be resized, so if the model is later changed with an
\fBx3270\fP menu option, the icon image will be corrupted.
The icon cannot accept keyboard input.
.TP
\fBtwm\fP and \fBtvtwm\fP
The full screen image of all 3270 models can be displayed on the icon, and the
icon can be resized.
The icon can accept keyboard input.
.IP
However, \fBtwm\fP does not put labels on application-supplied icon windows.
You can have \fBx3270\fP
add its own label to the icon by setting the "x3270.labelIcon" resource to
\fBtrue\fP.
The default font for icon labels is
\fB8x13\fP;
you may change it with the "x3270.iconLabelFont" resource.
.SH "KEYMAPS"
.PP
The type of keyboard may be specified with the \fB\-keymap\fP
switch or using either the \s-1KEYMAP\s+1 or \s-1KEYBD\s+1 environment variables.
The types of supported keyboards include
\fBsun_k3\fP,
\fBsun_k4\fP,
\fBsun_k5\fP,
\fBhp\-k1\fP,
\fBhp\-pc\fP
and
\fBncd\fP.
.PP
The keymap may also be specified as a comma-separated list of names.
Later definitions override earlier ones.
This is used to specify both a primary keyboard type and a set of modifiers.
The modifiers defined include:
.TP
\fBow\fP
(OpenWindows) Swaps the middle and right mouse button definitions, so the
middle button performs the "Extend" function and the right-hand button
performs the "Paste" function.
Also changes the cut and paste actions to use the OpenWindows \s-1CLIPBOARD\s+1.
.TP
\fBalt\fP
Replaces the default "Meta" key definitions with "Alt" definitions,
for keyboards which do not have a "Meta" key.
.TP
\fBapl\fP
Allows entry of \s-1APL\s+1 characters (see \s-1APL SUPPORT\s+1
below).
.TP
\fBfinnish7\fP
Replaces the bracket, brace and bar keys with common Finnish characters.
.TP
\fBnorwegian7\fP
Replaces the bracket, brace and bar keys with common Norwegian characters.
.PP
A temporary keymap can also be specified while \fBx3270\fP
is running with the \fBKeymap\fP action.
When the action \fBKeymap\fP(\fIn\fP) is executed, temporary keymap
\fIn\fP
is added to or deleted from the current keymap.
Multiple temporary keymaps can be active simultaneously.
The action \fBKeymap(None)\fP restores the original keymap.
\fBNote:\fP
When Keymap() is specified as part of a list of multiple actions in a keymap,
it must be the last action in the list.
.PP
The temporary keymap \fBhebrew\fP
is provided to allow entry of Hebrew characters.
.PP
The X Toolkit translation mechanism is used to provide keyboard emulation.
It maps \fBevents\fP into \fBactions.\fP
The best documentation can be found with X toolkit documents, but the
following should suffice for simple customization.
.PP
An Xt event consists of (at least) four fields.  The first is called a
\fBmodifier\fP.
It may be any combination of \fBMeta\fP, \fBShift\fP and \fBCtrl\fP.  If it
is prefaced by \fB!\fP,
it means those modifiers only.  The second field is the specific event,
in \fBx3270\fP
usually just <Key>.
The third field is the detail field, which gives the actual key.
The name of the key may be determined using the \fIxev\fP
program or with the "Trace X Events" menu option.
The last field is the action, which is the internal emulator function.
A complete list of actions may be found later in the manual.
.PP
There are three levels of translation tables in \fBx3270\fP.
The first is a defined by the resource
\fBx3270.keymap.base\fP.
It defines alphabetic, numeric,
function keys, and such basic functions as Enter and Delete.
It allows a minimal useful functionality.
It is generally compiled in \fBx3270\fP, but can be overridden.
.PP
The second level is a keyboard specific table, which is selected by the
\fBx3270.keymap\fP resource, and defined by the
\fBx3270.keymap.\fP\fIname\fP resource (where \fIname\fP is the value
of the \fBx3270.keymap\fP resource).
This keymap defines actions for such things as keypad
keys, and keys unique to certain keyboards.
Several predefined keymaps are included with \fBx3270\fP.
.PP
The third level is a user customizable table which may be used to augment or
override key definitions.
This keymap is defined by the \fBx3270.keymap.\fP\fIname\fP\fB.user\fP
resource.
.PP
In addition, keymaps may be defined for use in 3270 mode or \s-1NVT\s+1 mode
only.
These keymaps use the suffixes \fB.3270\fP and \fB.nvt\fP in their names,
respectively.
If a keymap \fBx3270.keymap.\fP\fIname\fP.\fImode\fP is defined, it
will augment the keymap \fBx3270.keymap.\fP\fIname\fP when \fBx3270\fP
is in the given \fImode\fP.
If a keymap \fBx3270.keymap.\fP\fIname\fP.\fBuser\fP.\fImode\fP is
defined, it will augment the
keymap \fBx3270.keymap\fP.\fIname\fP.\fBuser\fP when
\fBx3270\fP
is in the given \fImode\fP.
.PP
The default translation table \fBx3270.keymap.base\fP is:
.TS
l l .
T{
.na
.nh
<Key>Multi_key
T}	T{
.na
.nh
Compose()
T}
T{
.na
.nh
Shift<Key>Left
T}	T{
.na
.nh
KybdSelect(Left,PRIMARY)
T}
T{
.na
.nh
<Key>Left
T}	T{
.na
.nh
Left()
T}
T{
.na
.nh
Meta<Key>Right
T}	T{
.na
.nh
NextWord()
T}
T{
.na
.nh
Shift<Key>Right
T}	T{
.na
.nh
KybdSelect(Right,PRIMARY)
T}
T{
.na
.nh
<Key>Right
T}	T{
.na
.nh
Right()
T}
T{
.na
.nh
Shift<Key>Up
T}	T{
.na
.nh
KybdSelect(Up,PRIMARY)
T}
T{
.na
.nh
<Key>Up
T}	T{
.na
.nh
Up()
T}
T{
.na
.nh
Shift<Key>Down
T}	T{
.na
.nh
KybdSelect(Down,PRIMARY)
T}
T{
.na
.nh
<Key>Down
T}	T{
.na
.nh
Down()
T}
T{
.na
.nh
Ctrl<Btn1Down>
T}	T{
.na
.nh
HandleMenu(quitMenu)
T}
T{
.na
.nh
Ctrl<Btn2Down>
T}	T{
.na
.nh
HandleMenu(optionsMenu)
T}
T{
.na
.nh
Ctrl<Btn3Down>
T}	T{
.na
.nh
HandleMenu(hostMenu)
T}
T{
.na
.nh
Shift<Btn1Down>
T}	T{
.na
.nh
MoveCursor()
T}
T{
.na
.nh
<Btn1Down>
T}	T{
.na
.nh
select\-start()
T}
T{
.na
.nh
<Btn1Motion>
T}	T{
.na
.nh
select\-extend()
T}
T{
.na
.nh
<Btn2Down>
T}	T{
.na
.nh
ignore()
T}
T{
.na
.nh
<Btn2Motion>
T}	T{
.na
.nh
ignore()
T}
T{
.na
.nh
<Btn2Up>
T}	T{
.na
.nh
insert\-selection(PRIMARY)
T}
T{
.na
.nh
<Btn3Down>
T}	T{
.na
.nh
start\-extend()
T}
T{
.na
.nh
<Btn3Motion>
T}	T{
.na
.nh
select\-extend()
T}
T{
.na
.nh
<BtnUp>
T}	T{
.na
.nh
select\-end(PRIMARY)
T}
T{
.na
.nh
Meta<Key>F1
T}	T{
.na
.nh
PF(13)
T}
T{
.na
.nh
Meta<Key>F2
T}	T{
.na
.nh
PF(14)
T}
T{
.na
.nh
Meta<Key>F3
T}	T{
.na
.nh
PF(15)
T}
T{
.na
.nh
Meta<Key>F4
T}	T{
.na
.nh
PF(16)
T}
T{
.na
.nh
Meta<Key>F5
T}	T{
.na
.nh
PF(17)
T}
T{
.na
.nh
Meta<Key>F6
T}	T{
.na
.nh
PF(18)
T}
T{
.na
.nh
Meta<Key>F7
T}	T{
.na
.nh
PF(19)
T}
T{
.na
.nh
Meta<Key>F8
T}	T{
.na
.nh
PF(20)
T}
T{
.na
.nh
Meta<Key>F9
T}	T{
.na
.nh
PF(21)
T}
T{
.na
.nh
Meta<Key>F10
T}	T{
.na
.nh
PF(22)
T}
T{
.na
.nh
Meta<Key>F11
T}	T{
.na
.nh
PF(23)
T}
T{
.na
.nh
Meta<Key>F12
T}	T{
.na
.nh
PF(24)
T}
T{
.na
.nh
<Key>F1
T}	T{
.na
.nh
PF(1)
T}
T{
.na
.nh
<Key>F2
T}	T{
.na
.nh
PF(2)
T}
T{
.na
.nh
<Key>F3
T}	T{
.na
.nh
PF(3)
T}
T{
.na
.nh
<Key>F4
T}	T{
.na
.nh
PF(4)
T}
T{
.na
.nh
<Key>F5
T}	T{
.na
.nh
PF(5)
T}
T{
.na
.nh
<Key>F6
T}	T{
.na
.nh
PF(6)
T}
T{
.na
.nh
<Key>F7
T}	T{
.na
.nh
PF(7)
T}
T{
.na
.nh
<Key>F8
T}	T{
.na
.nh
PF(8)
T}
T{
.na
.nh
<Key>F9
T}	T{
.na
.nh
PF(9)
T}
T{
.na
.nh
<Key>F10
T}	T{
.na
.nh
PF(10)
T}
T{
.na
.nh
<Key>F11
T}	T{
.na
.nh
PF(11)
T}
T{
.na
.nh
<Key>F12
T}	T{
.na
.nh
PF(12)
T}
T{
.na
.nh
Alt<Key>q
T}	T{
.na
.nh
Quit()
T}
T{
.na
.nh
:<Key>
T}	T{
.na
.nh
Default()
T}
.TE
.PP
The default 3270-mode table \fBx3270.keymap.base.3270\fP adds the
following definitions:
.TS
l l .
T{
.na
.nh
Shift<Key>Return
T}	T{
.na
.nh
Newline()
T}
T{
.na
.nh
<Key>Return
T}	T{
.na
.nh
Enter()
T}
T{
.na
.nh
<Key>Linefeed
T}	T{
.na
.nh
Newline()
T}
T{
.na
.nh
Shift<Key>Tab
T}	T{
.na
.nh
BackTab()
T}
T{
.na
.nh
<Key>Tab
T}	T{
.na
.nh
Tab()
T}
T{
.na
.nh
<Key>Home
T}	T{
.na
.nh
Home()
T}
T{
.na
.nh
Meta<Key>Left
T}	T{
.na
.nh
PreviousWord()
T}
T{
.na
.nh
Meta<Key>Right
T}	T{
.na
.nh
NextWord()
T}
T{
.na
.nh
<Key>Insert
T}	T{
.na
.nh
Insert()
T}
T{
.na
.nh
<Key>Delete
T}	T{
.na
.nh
Delete()
T}
T{
.na
.nh
<Key>BackSpace
T}	T{
.na
.nh
BackSpace()
T}
T{
.na
.nh
Ctrl Shift<Btn1Down>
T}	T{
.na
.nh
MouseSelect()
T}
T{
.na
.nh
Shift<Btn1Down>
T}	T{
.na
.nh
MoveCursor()
T}
T{
.na
.nh
Meta<Key>1
T}	T{
.na
.nh
PA(1)
T}
T{
.na
.nh
Meta<Key>2
T}	T{
.na
.nh
PA(2)
T}
T{
.na
.nh
Meta<Key>3
T}	T{
.na
.nh
PA(3)
T}
T{
.na
.nh
Meta<Key>a
T}	T{
.na
.nh
Attn()
T}
T{
.na
.nh
Meta<Key>b
T}	T{
.na
.nh
PrintWindow()
T}
T{
.na
.nh
Meta<Key>c
T}	T{
.na
.nh
Clear()
T}
T{
.na
.nh
Meta<Key>d
T}	T{
.na
.nh
Delete()
T}
T{
.na
.nh
Meta<Key>h
T}	T{
.na
.nh
Home()
T}
T{
.na
.nh
Meta<Key>i
T}	T{
.na
.nh
Insert()
T}
T{
.na
.nh
Meta<Key>l
T}	T{
.na
.nh
Redraw()
T}
T{
.na
.nh
Meta<Key>p
T}	T{
.na
.nh
PrintText()
T}
T{
.na
.nh
Meta<Key>r
T}	T{
.na
.nh
Reset()
T}
T{
.na
.nh
Meta<Key>u
T}	T{
.na
.nh
Unselect()
T}
T{
.na
.nh
Ctrl<Key>u
T}	T{
.na
.nh
DeleteField()
T}
T{
.na
.nh
Ctrl<Key>w
T}	T{
.na
.nh
DeleteWord()
T}
T{
.na
.nh
:Meta<Key>asciicircum
T}	T{
.na
.nh
Key(notsign)
T}
.TE
.PP
Meta is the diamond shaped key on a sun_k4, "Alt" on an \s-1NCD\s+1,
"Extend Char" on an \s-1HP\s+1.
The following
\fIxmodmap\fP
command must be used on the \s-1NCD\s+1 to allow use the the "Alt"
key:
.PP
.RS
xmodmap \-e "keysym Alt_L = Meta_L"
.RE
.PP
The left mouse button may be used to make a selection.
Clicking once unselects the current selection.
Clicking twice selects the word under the mouse cursor.
Clicking three times selects the line under the mouse cursor.
Clicking and dragging selects a rectangular area of the display.
.PP
The middle mouse button may be used to paste a selection.
.PP
The right mouse button may also be used for selections, selecting the
rectangular area between the current position and where the left button was
last pressed.
.PP
.PP
On color X displays, the "x3270.selectBackground" resource is used to
distinguish the selected text from the rest of the screen.
On monochrome X displays, selected text is in reverse video.
(It can be distinguished from a block cursor because the block cursor covers
slightly less than an entire character position on the screen.)
.PP
The left mouse button, when pressed with the "Shift" key held down, moves the
3270 cursor to the where the mouse cursor is pointing.
.PP
This is the complete list of keymap-callable actions.
Other actions are defined for use by scripts and are documented in
\fIx3270-script\fP(1);
still others are defined for internal use by \fBx3270\fP
and are not documented here.
.PP
Actions marked with an asterisk (*) may block, sending data to the host and
possibly waiting for a response.
.PP
.TS
center; lw(3i) lw(3i).
T{
.na
.nh
.in +2
.ti -2
*Attn
T}	T{
.na
.nh
attention key
T}
T{
.na
.nh
.in +2
.ti -2
AltCursor
T}	T{
.na
.nh
switch between block and underscore cursor
T}
T{
.na
.nh
.in +2
.ti -2
BackSpace
T}	T{
.na
.nh
move cursor left (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
BackTab
T}	T{
.na
.nh
tab to start of previous input field
T}
T{
.na
.nh
.in +2
.ti -2
CircumNot
T}	T{
.na
.nh
input "^" in \s-1NVT\s+1 mode, or "notsign" in 3270 mode
T}
T{
.na
.nh
.in +2
.ti -2
*Clear
T}	T{
.na
.nh
clear screen
T}
T{
.na
.nh
.in +2
.ti -2
Compose
T}	T{
.na
.nh
next two keys form a special symbol
T}
T{
.na
.nh
.in +2
.ti -2
*Connect(\fIhost\fP)
T}	T{
.na
.nh
connect to \fIhost\fP
T}
T{
.na
.nh
.in +2
.ti -2
*CursorSelect
T}	T{
.na
.nh
Cursor Select \s-1AID\s+1
T}
T{
.na
.nh
.in +2
.ti -2
Cut
T}	T{
.na
.nh
erase selected text
T}
T{
.na
.nh
.in +2
.ti -2
Default
T}	T{
.na
.nh
enter key literally
T}
T{
.na
.nh
.in +2
.ti -2
Delete
T}	T{
.na
.nh
delete character under cursor (or send \s-1ASCII DEL\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
DeleteField
T}	T{
.na
.nh
delete the entire field
T}
T{
.na
.nh
.in +2
.ti -2
DeleteWord
T}	T{
.na
.nh
delete the current or previous word
T}
T{
.na
.nh
.in +2
.ti -2
*Disconnect
T}	T{
.na
.nh
disconnect from host
T}
T{
.na
.nh
.in +2
.ti -2
Down
T}	T{
.na
.nh
move cursor down
T}
T{
.na
.nh
.in +2
.ti -2
Dup
T}	T{
.na
.nh
duplicate field
T}
T{
.na
.nh
.in +2
.ti -2
*Enter
T}	T{
.na
.nh
Enter \s-1AID\s+1 (or send \s-1ASCII CR\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
Erase
T}	T{
.na
.nh
erase previous character (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
EraseEOF
T}	T{
.na
.nh
erase to end of current field
T}
T{
.na
.nh
.in +2
.ti -2
EraseInput
T}	T{
.na
.nh
erase all input fields
T}
T{
.na
.nh
.in +2
.ti -2
Execute(\fIcmd\fP)
T}	T{
.na
.nh
execute a command in a shell
T}
T{
.na
.nh
.in +2
.ti -2
FieldEnd
T}	T{
.na
.nh
move cursor to end of field
T}
T{
.na
.nh
.in +2
.ti -2
FieldExit
T}	T{
.na
.nh
clear to end of field and skip to next (5250 emulation)
T}
T{
.na
.nh
.in +2
.ti -2
FieldMark
T}	T{
.na
.nh
mark field
T}
T{
.na
.nh
.in +2
.ti -2
HandleMenu(\fIname\fP)
T}	T{
.na
.nh
pop up a menu
T}
T{
.na
.nh
.in +2
.ti -2
HexString(\fIhex_digits\fP)
T}	T{
.na
.nh
insert control-character string
T}
T{
.na
.nh
.in +2
.ti -2
Home
T}	T{
.na
.nh
move cursor to first input field
T}
T{
.na
.nh
.in +2
.ti -2
Insert
T}	T{
.na
.nh
set insert mode
T}
T{
.na
.nh
.in +2
.ti -2
*Interrupt
T}	T{
.na
.nh
send \s-1TELNET IP\s+1 to host
T}
T{
.na
.nh
.in +2
.ti -2
Key(\fIkeysym\fP)
T}	T{
.na
.nh
insert key \fIkeysym\fP
T}
T{
.na
.nh
.in +2
.ti -2
Key(0x\fIxx\fP)
T}	T{
.na
.nh
insert key with \s-1ASCII\s+1 code \fIxx\fP
T}
T{
.na
.nh
.in +2
.ti -2
Keymap(\fIkeymap\fP)
T}	T{
.na
.nh
toggle alternate \fIkeymap\fP (or remove with \fBNone\fP)
T}
T{
.na
.nh
.in +2
.ti -2
KybdSelect(\fIdirection\fP[,\fIatom\fP...])
T}	T{
.na
.nh
Extend selection by one row or column
T}
T{
.na
.nh
.in +2
.ti -2
Left
T}	T{
.na
.nh
move cursor left
T}
T{
.na
.nh
.in +2
.ti -2
Left2
T}	T{
.na
.nh
move cursor left 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
*Macro(\fImacro\fP)
T}	T{
.na
.nh
run a macro
T}
T{
.na
.nh
.in +2
.ti -2
MonoCase
T}	T{
.na
.nh
toggle uppercase-only mode
T}
T{
.na
.nh
.in +2
.ti -2
MoveCursor
T}	T{
.na
.nh
move cursor to mouse position
T}
T{
.na
.nh
.in +2
.ti -2
MoveCursor(\fIrow\fP, \fIcol\fP)
T}	T{
.na
.nh
move cursor to (\fIrow\fP,\fIcol\fP)
T}
T{
.na
.nh
.in +2
.ti -2
*MoveCursorSelect
T}	T{
.na
.nh
move cursor to mouse position, light pen selection
T}
T{
.na
.nh
.in +2
.ti -2
Newline
T}	T{
.na
.nh
move cursor to first field on next line (or send \s-1ASCII LF\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
NextWord
T}	T{
.na
.nh
move cursor to next word
T}
T{
.na
.nh
.in +2
.ti -2
*PA(\fIn\fP)
T}	T{
.na
.nh
Program Attention \s-1AID\s+1 (\fIn\fP from 1 to 3)
T}
T{
.na
.nh
.in +2
.ti -2
*PF(\fIn\fP)
T}	T{
.na
.nh
Program Function \s-1AID\s+1 (\fIn\fP from 1 to 24)
T}
T{
.na
.nh
.in +2
.ti -2
PreviousWord
T}	T{
.na
.nh
move cursor to previous word
T}
T{
.na
.nh
.in +2
.ti -2
Printer(Start[,\fIlu\fP]|Stop)
T}	T{
.na
.nh
Start or stop printer session
T}
T{
.na
.nh
.in +2
.ti -2
PrintText(\fIcommand\fP)
T}	T{
.na
.nh
print screen text on printer
T}
T{
.na
.nh
.in +2
.ti -2
PrintWindow(\fIcommand\fP)
T}	T{
.na
.nh
print screen image (bitmap) on printer
T}
T{
.na
.nh
.in +2
.ti -2
Quit
T}	T{
.na
.nh
exit \fBx3270\fP
T}
T{
.na
.nh
.in +2
.ti -2
*Reconnect
T}	T{
.na
.nh
reconnect to previous host
T}
T{
.na
.nh
.in +2
.ti -2
Redraw
T}	T{
.na
.nh
redraw window
T}
T{
.na
.nh
.in +2
.ti -2
Reset
T}	T{
.na
.nh
reset locked keyboard
T}
T{
.na
.nh
.in +2
.ti -2
Right
T}	T{
.na
.nh
move cursor right
T}
T{
.na
.nh
.in +2
.ti -2
Right2
T}	T{
.na
.nh
move cursor right 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
SetFont(\fIfont\fP)
T}	T{
.na
.nh
change emulator font
T}
T{
.na
.nh
.in +2
.ti -2
*Script(\fIcommand\fP[,\fIarg\fP...])
T}	T{
.na
.nh
run a script
T}
T{
.na
.nh
.in +2
.ti -2
*String(\fIstring\fP)
T}	T{
.na
.nh
insert string (simple macro facility)
T}
T{
.na
.nh
.in +2
.ti -2
*SysReq
T}	T{
.na
.nh
System Request \s-1AID\s+1
T}
T{
.na
.nh
.in +2
.ti -2
Tab
T}	T{
.na
.nh
move cursor to next input field
T}
T{
.na
.nh
.in +2
.ti -2
Toggle(\fIoption\fP[,\fIset|clear\fP])
T}	T{
.na
.nh
toggle an option
T}
T{
.na
.nh
.in +2
.ti -2
ToggleInsert
T}	T{
.na
.nh
toggle insert mode
T}
T{
.na
.nh
.in +2
.ti -2
ToggleReverse
T}	T{
.na
.nh
toggle reverse-input mode
T}
T{
.na
.nh
.in +2
.ti -2
*Transfer(\fIoption\fP=\fIvalue\fP...)
T}	T{
.na
.nh
file transfer
T}
T{
.na
.nh
.in +2
.ti -2
Unselect
T}	T{
.na
.nh
release selection
T}
T{
.na
.nh
.in +2
.ti -2
Up
T}	T{
.na
.nh
move cursor up
T}
_
T{
.na
.nh
.in +2
.ti -2
(the following are similar to xterm)
T}
_
T{
.na
.nh
.in +2
.ti -2
ignore
T}	T{
.na
.nh
do nothing
T}
T{
.na
.nh
.in +2
.ti -2
insert-selection([\fIatom\fP[,\fIatom\fP...]])
T}	T{
.na
.nh
paste selection
T}
T{
.na
.nh
.in +2
.ti -2
move-select
T}	T{
.na
.nh
a combination of \fBMoveCursor\fP and \fBselect-start\fP
T}
T{
.na
.nh
.in +2
.ti -2
select-end(\fIatom\fP[,\fIatom\fP...]])
T}	T{
.na
.nh
complete selection and assign to atom(s)
T}
T{
.na
.nh
.in +2
.ti -2
select-extend
T}	T{
.na
.nh
move the end of a selection
T}
T{
.na
.nh
.in +2
.ti -2
select-start
T}	T{
.na
.nh
mark the beginning of a selection
T}
T{
.na
.nh
.in +2
.ti -2
set-select(\fIatom\fP[,\fIatom\fP...]])
T}	T{
.na
.nh
assign existing selection to atom(s)
T}
T{
.na
.nh
.in +2
.ti -2
start-extend
T}	T{
.na
.nh
begin marking the end of a selection
T}
.TE
.SH "MACROS AND SCRIPTS"
There are several types of
macros and script functions available.
.TP
\fBThe String Action\fP
The simplest method for
macros is provided via the \fBString\fP
action.
The arguments to \fBString\fP are one or more double-quoted strings which are
inserted directly as if typed.
The C backslash conventions are honored as follows.
(Entries marked * mean that after sending the \s-1AID\s+1 code to the host,
\fBx3270\fP will wait for the host to unlock the keyboard before further
processing the string.)
.TS
l l.
T{
.na
.nh
\eb
T}	T{
.na
.nh
Left
T}
T{
.na
.nh
\ef
T}	T{
.na
.nh
Clear*
T}
T{
.na
.nh
\en
T}	T{
.na
.nh
Enter*
T}
T{
.na
.nh
\epa\fIn\fP
T}	T{
.na
.nh
PA(\fIn\fP)*
T}
T{
.na
.nh
\epf\fInn\fP
T}	T{
.na
.nh
PF(\fInn\fP)*
T}
T{
.na
.nh
\er
T}	T{
.na
.nh
Newline
T}
T{
.na
.nh
\et
T}	T{
.na
.nh
Tab
T}
T{
.na
.nh
\eT
T}	T{
.na
.nh
BackTab
T}
.TE
.IP
An example keymap entry would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.IP
\fBNote:\fP
The strings are in \s-1ASCII\s+1 and converted to \s-1EBCDIC\s+1,
so beware of inserting
control codes.
Also, a backslash before a \fBp\fP may need to be
doubled so it will not be removed when a resource file is read.
.IP
There is also an alternate form of the \fBString\fP action, \fBHexString\fP,
which is used to enter non-printing data.
The argument to \fBHexString\fP is a string of hexadecimal digits, two per
character.  A leading 0x or 0X is optional.
In 3270 mode, the hexadecimal data represent \s-1EBCDIC\s+1 characters, which
are entered into the current field.
In \s-1NVT\s+1 mode, the hexadecimal data represent \s-1ASCII\s+1 characters,
which are sent directly to the host.
.TP
\fBThe Script Action\fP
This action causes \fBx3270\fP to start a child process which can
execute \fBx3270\fP actions.
Standard input and output from the child process are piped back to
\fBx3270\fP.
The \fBScript\fP action is fully documented in
\fIx3270-script\fP(1).
.TP
\fBThe macros Resource\fP
An alternate method of defining macros is the "x3270.macros" resource.
This resource is similar to a keymap, but instead of defining keyboard
mappings, it associates a list of X actions with a name.
These names are displayed on a Macros menu that appears when \fBx3270\fP
is connected to a host.
Selecting one of the names on the menu executes the X actions associated with
it.
Typically the actions are \fBString\fP calls, but any action may be specified.
Here is a sample macros resource definition, which would result in a four-entry
Macros menu:
.RS
x3270.macros: \e
.br
	log off: String("logout\en")\en\e
.br
	vtam: String("dial vtam\en")\en\e
.br
	pa1: PA(1)\en\e
.br
	alt printer: PrintText("lpr -Plw2")
.RE
.IP
You can also define a different set of macros for each host.
If there is a resource named
`x3270.\fImacros\fP.\fIsomehost\fP',
it defines the macros menu for when \fBx3270\fP
is connected to \fIsomehost\fP.
.TP
\fBThe \-script Option\fP
This facility allows \fBx3270\fP
to operate under the complete control of a script.
\fBx3270\fP
accepts actions from standard input, and prints results on standard output.
The \fB\-script\fP option is fully documented in
\fIx3270-script\fP(1).
.SH "COMPOSITE CHARACTERS"
\fBx3270\fP
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A C on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "x3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "x3270.composeMap.\fIname\fP".
The default is "latin1", which gives mappings for most of the symbols in
the \s-1ISO\s+1 8859-1 Latin-1 character set that are not in the
7-bit \s-1ASCII\s+1
character set.
.PP
\fBNote:\fP
The default keymap defines
the "Multi_key" keysym
as the "Compose" key.
If your keyboard lacks such a key, you
may set up your own "Compose" key with
a keymap that maps some other keysym onto the \fBCompose\fP action.
.SH "APL SUPPORT"
\fBx3270\fP supports the full \s-1APL2\s+1 character set and the entry of
\s-1APL\s+1 characters from the keyboard.
.PP
\s-1APL\s+1 characters are supported only in the special \fB3270\fP font.
.PP
Keyboard entry of \s-1APL\s+1 characters is supported through the \fBapl\fP
keymap modifier.
This modifier defines the "Alt" key as an \s-1APL\s+1  key, with a
typical \s-1APL\s+1 keyboard layout, e.g.,
"Alt" pressed with the \fBA\fP key results in the \s-1APL\s+1 "alpha" symbol.
Overstruck characters such as "quad-quote" are not defined as single
keystrokes; instead they are entered as
composites (see \s-1COMPOSITE CHARACTERS\s+1
above).
A special composite map,
\fBapl\fP,
is provided for this purpose.
.PP
\fBNote:\fP
Some keyboards do not define the "Alt" key as a modifier, so keymaps that use
the "Alt" key will not function.
On a Sun for example, this can be remedied with the command:
.IP
.RS
xmodmap \-e "add mod2 = Alt_L"
.RE
.PP
For convenience, an \fB\-apl\fP
option is defined, which is an abbreviation for the following resource
definitions:
.RS
x3270.keymap: \fIyour_keymap_name\fP,apl
.br
x3270.charset: apl
.br
x3270.composeMap: apl
.br
.RE
.PP
There are a number of \s-1APL\s+1 characters that are similar in appearance to
non-\s-1APL\s+1
characters.
In particular, the \s-1APL\s+1 "stile", "slope," "tilde" and "quotedot"
characters are similar to the \s-1EBCDIC\s+1 "bar", "backslash," "tilde"
and "exclaim" characters.
The \s-1APL\s+1 characters are entered with the "Alt" key, and have slightly
different appearances.
.PP
The complete list of special \s-1APL\s+1 keysyms is as follows.
Entries marked with an asterisk (*) represent
simple aliases for standard \s-1EBCDIC\s+1 characters.
Entries marked with an (S) represent Sharp APL charatcers.
.PP
.TS
l c l l l.
T{
.na
.nh
APL Symbol
T}	T{
.na
.nh
Hex
T}	T{
.na
.nh
x3270 Keysym
T}	T{
.na
.nh
x3270 Key
T}	T{
.na
.nh
x3270 Composed Keys
T}
_
T{
.na
.nh
A underbar
T}	T{
.na
.nh
41
T}	T{
.na
.nh
apl_Aunderbar
T}	T{
.na
.nh
Alt-A
T}	T{
.na
.nh
A + underbar
T}
T{
.na
.nh
alpha
T}	T{
.na
.nh
B0
T}	T{
.na
.nh
apl_alpha
T}	T{
.na
.nh
Alt-a
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
B underbar
T}	T{
.na
.nh
42
T}	T{
.na
.nh
apl_Bunderbar
T}	T{
.na
.nh
Alt-B
T}	T{
.na
.nh
B + underbar
T}
T{
.na
.nh
bar
T}	T{
.na
.nh
60*
T}	T{
.na
.nh
apl_bar
T}	T{
.na
.nh
-
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
brace left
T}	T{
.na
.nh
C0
T}	T{
.na
.nh
apl_braceleft
T}	T{
.na
.nh
Alt-{
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
brace right
T}	T{
.na
.nh
D0
T}	T{
.na
.nh
apl_braceright
T}	T{
.na
.nh
Alt-}
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
C underbar
T}	T{
.na
.nh
43
T}	T{
.na
.nh
apl_Cunderbar
T}	T{
.na
.nh
Alt-C
T}	T{
.na
.nh
C + underbar
T}
T{
.na
.nh
circle
T}	T{
.na
.nh
9D
T}	T{
.na
.nh
apl_circle
T}	T{
.na
.nh
Alt-o
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
circle bar
T}	T{
.na
.nh
ED
T}	T{
.na
.nh
apl_circlebar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
circle + bar
T}
T{
.na
.nh
circle slope
T}	T{
.na
.nh
CF
T}	T{
.na
.nh
apl_circleslope
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
circle + slope
T}
T{
.na
.nh
circle star
T}	T{
.na
.nh
FD
T}	T{
.na
.nh
apl_circlestar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
circle + star
T}
T{
.na
.nh
circle stile
T}	T{
.na
.nh
CD
T}	T{
.na
.nh
apl_circlestile
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
circle + stile
T}
T{
.na
.nh
colon
T}	T{
.na
.nh
7A*
T}	T{
.na
.nh
apl_colon
T}	T{
.na
.nh
:
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
comma
T}	T{
.na
.nh
6B*
T}	T{
.na
.nh
apl_comma
T}	T{
.na
.nh
,
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
comma bar (S)
T}	T{
.na
.nh
E5
T}	T{
.na
.nh
apl_commabar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
comma + bar
T}
T{
.na
.nh
D underbar
T}	T{
.na
.nh
44
T}	T{
.na
.nh
apl_Dunderbar
T}	T{
.na
.nh
Alt-D
T}	T{
.na
.nh
D + underbar
T}
T{
.na
.nh
del
T}	T{
.na
.nh
BA
T}	T{
.na
.nh
apl_del
T}	T{
.na
.nh
Alt-g
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
del stile
T}	T{
.na
.nh
DC
T}	T{
.na
.nh
apl_delstile
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
del + stile
T}
T{
.na
.nh
del tilde
T}	T{
.na
.nh
FB
T}	T{
.na
.nh
apl_deltilde
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
del + tilde
T}
T{
.na
.nh
delta
T}	T{
.na
.nh
BB
T}	T{
.na
.nh
apl_delta
T}	T{
.na
.nh
Alt-h
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
delta stile
T}	T{
.na
.nh
DD
T}	T{
.na
.nh
apl_deltastile
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
delta + stile
T}
T{
.na
.nh
delta underbar
T}	T{
.na
.nh
FC
T}	T{
.na
.nh
apl_deltaunderbar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
delta + underbar
T}
T{
.na
.nh
diamond
T}	T{
.na
.nh
70
T}	T{
.na
.nh
apl_diamond
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
up caret + down caret
T}
T{
.na
.nh
dieresis
T}	T{
.na
.nh
72
T}	T{
.na
.nh
apl_dieresis
T}	T{
.na
.nh
Alt-1
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
dieresis circle (S)
T}	T{
.na
.nh
E5
T}	T{
.na
.nh
apl_dieresiscircle
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
dieresis + circle
T}
T{
.na
.nh
dieresis dot
T}	T{
.na
.nh
EC
T}	T{
.na
.nh
apl_dieresisdot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
dieresis + dot
T}
T{
.na
.nh
dieresis jot (S)
T}	T{
.na
.nh
E4
T}	T{
.na
.nh
apl_dieresisjot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
dieresis + jot
T}
T{
.na
.nh
divide
T}	T{
.na
.nh
B8
T}	T{
.na
.nh
apl_divide
T}	T{
.na
.nh
Alt-+
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
dot
T}	T{
.na
.nh
4B*
T}	T{
.na
.nh
apl_dot
T}	T{
.na
.nh
.
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down arrow
T}	T{
.na
.nh
8B
T}	T{
.na
.nh
apl_downarrow
T}	T{
.na
.nh
Alt-u
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down caret
T}	T{
.na
.nh
78
T}	T{
.na
.nh
apl_downcaret
T}	T{
.na
.nh
Alt-9
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down caret tilde
T}	T{
.na
.nh
CB
T}	T{
.na
.nh
apl_downcarettilde
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
down caret + tilde
T}
T{
.na
.nh
down shoe
T}	T{
.na
.nh
AB
T}	T{
.na
.nh
apl_downshoe
T}	T{
.na
.nh
Alt-v
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down stile
T}	T{
.na
.nh
8E
T}	T{
.na
.nh
apl_downstile
T}	T{
.na
.nh
Alt-d
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down tack
T}	T{
.na
.nh
AC
T}	T{
.na
.nh
apl_downtack
T}	T{
.na
.nh
Alt-b
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
down tack jot
T}	T{
.na
.nh
FE
T}	T{
.na
.nh
apl_downtackjot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
down tack + jot
T}
T{
.na
.nh
down tack up tack
T}	T{
.na
.nh
DA
T}	T{
.na
.nh
apl_downtackuptack
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
down tack + up tack
T}
T{
.na
.nh
E underbar
T}	T{
.na
.nh
45
T}	T{
.na
.nh
apl_Eunderbar
T}	T{
.na
.nh
Alt-E
T}	T{
.na
.nh
E + underbar
T}
T{
.na
.nh
epsilon
T}	T{
.na
.nh
B1
T}	T{
.na
.nh
apl_epsilon
T}	T{
.na
.nh
Alt-e
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
epsilon underbar
T}	T{
.na
.nh
75
T}	T{
.na
.nh
apl_epsilonunderbar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
epsilon + underbar
T}
T{
.na
.nh
equal
T}	T{
.na
.nh
7E*
T}	T{
.na
.nh
apl_equal
T}	T{
.na
.nh
"="
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
equal underbar
T}	T{
.na
.nh
E1
T}	T{
.na
.nh
apl_equalunderbar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
equal + underbar
T}
T{
.na
.nh
euro (S)
T}	T{
.na
.nh
E7
T}	T{
.na
.nh
apl_euro
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
C + =
T}
T{
.na
.nh
F underbar
T}	T{
.na
.nh
46
T}	T{
.na
.nh
apl_Funderbar
T}	T{
.na
.nh
Alt-F
T}	T{
.na
.nh
F + underbar
T}
T{
.na
.nh
G underbar
T}	T{
.na
.nh
47
T}	T{
.na
.nh
apl_Gunderbar
T}	T{
.na
.nh
Alt-G
T}	T{
.na
.nh
G + underbar
T}
T{
.na
.nh
greater
T}	T{
.na
.nh
6E*
T}	T{
.na
.nh
apl_greater
T}	T{
.na
.nh
>
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
H underbar
T}	T{
.na
.nh
48
T}	T{
.na
.nh
apl_Hunderbar
T}	T{
.na
.nh
Alt-H
T}	T{
.na
.nh
H + underbar
T}
T{
.na
.nh
I underbar
T}	T{
.na
.nh
49
T}	T{
.na
.nh
apl_Iunderbar
T}	T{
.na
.nh
Alt-I
T}	T{
.na
.nh
I + underbar
T}
T{
.na
.nh
iota
T}	T{
.na
.nh
B2
T}	T{
.na
.nh
apl_iota
T}	T{
.na
.nh
Alt-i
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
iota underbar
T}	T{
.na
.nh
74
T}	T{
.na
.nh
apl_iotaunderbar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
iota + underbar
T}
T{
.na
.nh
J underbar
T}	T{
.na
.nh
51
T}	T{
.na
.nh
apl_Junderbar
T}	T{
.na
.nh
Alt-J
T}	T{
.na
.nh
J + underbar
T}
T{
.na
.nh
jot
T}	T{
.na
.nh
AF
T}	T{
.na
.nh
apl_jot
T}	T{
.na
.nh
alt-j
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
K underbar
T}	T{
.na
.nh
52
T}	T{
.na
.nh
apl_Kunderbar
T}	T{
.na
.nh
Alt-K
T}	T{
.na
.nh
K + underbar
T}
T{
.na
.nh
L underbar
T}	T{
.na
.nh
53
T}	T{
.na
.nh
apl_Lunderbar
T}	T{
.na
.nh
Alt-L
T}	T{
.na
.nh
L + underbar
T}
T{
.na
.nh
left arrow
T}	T{
.na
.nh
9F
T}	T{
.na
.nh
apl_leftarrow
T}	T{
.na
.nh
Alt-[
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
left bracket
T}	T{
.na
.nh
AD
T}	T{
.na
.nh
apl_leftbracket
T}	T{
.na
.nh
[
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
left paren
T}	T{
.na
.nh
4D*
T}	T{
.na
.nh
apl_leftparen
T}	T{
.na
.nh
(
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
left shoe
T}	T{
.na
.nh
9B
T}	T{
.na
.nh
apl_leftshoe
T}	T{
.na
.nh
Alt-z
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
less
T}	T{
.na
.nh
4C*
T}	T{
.na
.nh
apl_less
T}	T{
.na
.nh
<
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
M underbar
T}	T{
.na
.nh
54
T}	T{
.na
.nh
apl_Munderbar
T}	T{
.na
.nh
Alt-M
T}	T{
.na
.nh
M + underbar
T}
T{
.na
.nh
N underbar
T}	T{
.na
.nh
55
T}	T{
.na
.nh
apl_Nunderbar
T}	T{
.na
.nh
Alt-N
T}	T{
.na
.nh
N + underbar
T}
T{
.na
.nh
not equal
T}	T{
.na
.nh
BE
T}	T{
.na
.nh
apl_notequal
T}	T{
.na
.nh
Alt-8
T}	T{
.na
.nh
equal + slash
T}
T{
.na
.nh
not greater
T}	T{
.na
.nh
8C
T}	T{
.na
.nh
apl_notgreater
T}	T{
.na
.nh
Alt-4
T}	T{
.na
.nh
less + equal
T}
T{
.na
.nh
not less
T}	T{
.na
.nh
AE
T}	T{
.na
.nh
apl_notless
T}	T{
.na
.nh
Alt-6
T}	T{
.na
.nh
greater + equal
T}
T{
.na
.nh
O underbar
T}	T{
.na
.nh
56
T}	T{
.na
.nh
apl_Ounderbar
T}	T{
.na
.nh
Alt-O
T}	T{
.na
.nh
O + underbar
T}
T{
.na
.nh
omega
T}	T{
.na
.nh
B4
T}	T{
.na
.nh
apl_omega
T}	T{
.na
.nh
Alt-w
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
overbar
T}	T{
.na
.nh
A0
T}	T{
.na
.nh
apl_overbar
T}	T{
.na
.nh
Alt-2
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
P underbar
T}	T{
.na
.nh
57
T}	T{
.na
.nh
apl_Punderbar
T}	T{
.na
.nh
Alt-P
T}	T{
.na
.nh
P + underbar
T}
T{
.na
.nh
plus
T}	T{
.na
.nh
4E*
T}	T{
.na
.nh
apl_plus
T}	T{
.na
.nh
+
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
Q underbar
T}	T{
.na
.nh
58
T}	T{
.na
.nh
apl_Qunderbar
T}	T{
.na
.nh
Alt-Q
T}	T{
.na
.nh
Q + underbar
T}
T{
.na
.nh
quad
T}	T{
.na
.nh
90
T}	T{
.na
.nh
apl_quad
T}	T{
.na
.nh
Alt-l
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
quad divide
T}	T{
.na
.nh
EE
T}	T{
.na
.nh
apl_quaddivide
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quad + divide
T}
T{
.na
.nh
quad jot
T}	T{
.na
.nh
73
T}	T{
.na
.nh
apl_quadjot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quad + jot
T}
T{
.na
.nh
quad quote
T}	T{
.na
.nh
DE
T}	T{
.na
.nh
apl_quadquote
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quad + quote
T}
T{
.na
.nh
quad slope
T}	T{
.na
.nh
CE
T}	T{
.na
.nh
apl_quadslope
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quad + slope
T}
T{
.na
.nh
query
T}	T{
.na
.nh
6F*
T}	T{
.na
.nh
apl_query
T}	T{
.na
.nh
?
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
quote
T}	T{
.na
.nh
7D*
T}	T{
.na
.nh
apl_quote
T}	T{
.na
.nh
'
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
quote dot
T}	T{
.na
.nh
DB
T}	T{
.na
.nh
apl_quotedot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quote + dot
T}
T{
.na
.nh
R underbar
T}	T{
.na
.nh
59
T}	T{
.na
.nh
apl_Runderbar
T}	T{
.na
.nh
Alt-R
T}	T{
.na
.nh
R + underbar
T}
T{
.na
.nh
rho
T}	T{
.na
.nh
B3
T}	T{
.na
.nh
apl_rho
T}	T{
.na
.nh
Alt-r
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
right arrow
T}	T{
.na
.nh
8F
T}	T{
.na
.nh
apl_rightarrow
T}	T{
.na
.nh
Alt-]
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
right bracket
T}	T{
.na
.nh
BD
T}	T{
.na
.nh
apl_rightbracket
T}	T{
.na
.nh
]
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
right paren
T}	T{
.na
.nh
5D*
T}	T{
.na
.nh
apl_rightparen
T}	T{
.na
.nh
)
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
right shoe
T}	T{
.na
.nh
9A
T}	T{
.na
.nh
apl_rightshoe
T}	T{
.na
.nh
Alt-x
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
S underbar
T}	T{
.na
.nh
62
T}	T{
.na
.nh
apl_Sunderbar
T}	T{
.na
.nh
Alt-S
T}	T{
.na
.nh
S + underbar
T}
T{
.na
.nh
semicolon
T}	T{
.na
.nh
5E*
T}	T{
.na
.nh
apl_semicolon
T}	T{
.na
.nh
;
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
slash
T}	T{
.na
.nh
61*
T}	T{
.na
.nh
apl_slash
T}	T{
.na
.nh
/
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
slash bar
T}	T{
.na
.nh
EA
T}	T{
.na
.nh
apl_slashbar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
slash + bar
T}
T{
.na
.nh
slope
T}	T{
.na
.nh
B7
T}	T{
.na
.nh
apl_slope
T}	T{
.na
.nh
Alt-\e
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
slope bar
T}	T{
.na
.nh
EB
T}	T{
.na
.nh
apl_slopebar
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
slope + bar
T}
T{
.na
.nh
squad
T}	T{
.na
.nh
CC
T}	T{
.na
.nh
apl_squad
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
quad + quad
T}
T{
.na
.nh
star
T}	T{
.na
.nh
5C*
T}	T{
.na
.nh
apl_star
T}	T{
.na
.nh
*
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
stile
T}	T{
.na
.nh
BF
T}	T{
.na
.nh
apl_stile
T}	T{
.na
.nh
Alt-|
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
T underbar
T}	T{
.na
.nh
63
T}	T{
.na
.nh
apl_Tunderbar
T}	T{
.na
.nh
Alt-T
T}	T{
.na
.nh
T + underbar
T}
T{
.na
.nh
tilde
T}	T{
.na
.nh
80
T}	T{
.na
.nh
apl_tilde
T}	T{
.na
.nh
Alt-~
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
times
T}	T{
.na
.nh
B6
T}	T{
.na
.nh
apl_times
T}	T{
.na
.nh
Alt-=
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
U underbar
T}	T{
.na
.nh
64
T}	T{
.na
.nh
apl_Uunderbar
T}	T{
.na
.nh
Alt-U
T}	T{
.na
.nh
U + underbar
T}
T{
.na
.nh
underbar
T}	T{
.na
.nh
6D*
T}	T{
.na
.nh
apl_underbar
T}	T{
.na
.nh
"_"
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up arrow
T}	T{
.na
.nh
8A
T}	T{
.na
.nh
apl_uparrow
T}	T{
.na
.nh
Alt-y
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up caret
T}	T{
.na
.nh
71
T}	T{
.na
.nh
apl_upcaret
T}	T{
.na
.nh
Alt-0
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up caret tilde
T}	T{
.na
.nh
CA
T}	T{
.na
.nh
apl_upcarettilde
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
up caret + tilde
T}
T{
.na
.nh
up shoe
T}	T{
.na
.nh
AA
T}	T{
.na
.nh
apl_upshoe
T}	T{
.na
.nh
Alt-c
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up shoe jot
T}	T{
.na
.nh
DF
T}	T{
.na
.nh
apl_upshoejot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
up shoe + jot
T}
T{
.na
.nh
up stile
T}	T{
.na
.nh
8D
T}	T{
.na
.nh
apl_upstile
T}	T{
.na
.nh
Alt-s
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up tack
T}	T{
.na
.nh
BC
T}	T{
.na
.nh
apl_uptack
T}	T{
.na
.nh
Alt-n
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
up tack jot
T}	T{
.na
.nh
EF
T}	T{
.na
.nh
apl_uptackjot
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
up tack + jot
T}
T{
.na
.nh
V underbar
T}	T{
.na
.nh
65
T}	T{
.na
.nh
apl_Vunderbar
T}	T{
.na
.nh
Alt-V
T}	T{
.na
.nh
V + underbar
T}
T{
.na
.nh
W underbar
T}	T{
.na
.nh
66
T}	T{
.na
.nh
apl_Wunderbar
T}	T{
.na
.nh
Alt-W
T}	T{
.na
.nh
W + underbar
T}
T{
.na
.nh
X underbar
T}	T{
.na
.nh
67
T}	T{
.na
.nh
apl_Xunderbar
T}	T{
.na
.nh
Alt-X
T}	T{
.na
.nh
X + underbar
T}
T{
.na
.nh
Y underbar
T}	T{
.na
.nh
68
T}	T{
.na
.nh
apl_Yunderbar
T}	T{
.na
.nh
Alt-Y
T}	T{
.na
.nh
Y + underbar
T}
T{
.na
.nh
Z underbar
T}	T{
.na
.nh
69
T}	T{
.na
.nh
apl_Zunderbar
T}	T{
.na
.nh
Alt-Z
T}	T{
.na
.nh
Z + underbar
T}
.TE
.SH "XIM SUPPORT"
When compiled with DBCS support, \fBx3270\fP supports multi-byte input methods
via the XIM protocol.
.LP
The input method is selected by the XMODIFIERS environment variable or the
\fB\-im\fP command-line option.
.LP
The preedit type is specified by the \fB\-pt\fP command-line option,
with a default of \fBOverTheSpot+1\fP.
.SH "5250 (AS/400) SUPPORT"
\fBx3270\fP provides limited support for 5250 (AS/400) emulation.
This is not native 5250 terminal emulation, but rather for use with hosts
which allow a 3270 terminal to emulate a 5250.
A \fB5250\fP
keymap is defined, which maps the keyboard function keys to the 5250 emulators
PA/PF key sequences, as well as redefining the Return key to use the special
\fBFieldExit\fP action.
The command line for 5250 support is:
.br
.RS
x3270 -model 2 -keymap 5250
.RE
.br
.SH "SCREEN PRINTING"
Screen printing is handled through options on the \fBFile\fP menu or by the
\fBPrintText\fP and \fBPrintWindow\fP actions.
Each results in a pop-up to confirm the print command.
.PP
The \fBPrintText\fP action (usually assigned to the key <Meta>p) sends
the current
screen image to the printer as \s-1ASCII\s+1 characters.
The default command used to print the data is controlled by
the "x3270.printTextCommand" resource; the default is
\fBlpr\fP.
You may also use a keymap definition to pass a print command the
\fBPrintText\fP action itself.
The command receives the screen text as its standard input.
For example, the following keymap will save the screen text in a file:
.IP
.RS
Meta<Key>f: PrintText("cat >screen.image")
.RE
.PP
Note: \fBHardPrint\fP is an alias for \fBPrintText\fP.
.PP
The \fBPrintWindow\fP action (usually assigned to the key <Meta>b) sends the current
screen image to the printer as a bitmap.
The default command used to print the data is controlled by
the "x3270.printWindowCommand" resource; the default is
.IP
.RS
\fBxwd \-id %d | xpr | lpr\fP.
.RE
.PP
You may also use a keymap definition to pass a print command to the
\fBPrintWindow\fP action itself.
If the command contains the text "%d", the window ID of
\fBx3270\fP will be substituted before it is run.
For example, the following keymap will pop up a duplicate of the current
screen image:
.IP
.RS
Meta<Key>g: PrintWindow("xwd \-id %d | xwud &")
.RE
.LP
If the command for PrintWindow or PrintText begins with an "@" character,
the initial pop-up menu to confirm the print command is not displayed and
the command cannot be edited.
.SH "BUGS"
Cursor highlighting will not work with if you use the \fBNoTitleFocus\fP
option in your .twmrc file.
.SH "PASSTHRU"
\fBx3270\fP supports the Sun \fItelnet-passthru\fP
service provided by the \fIin.telnet-gw\fP server.
This allows outbound telnet connections through a firewall machine.
When a \fBp:\fP is prepended to a hostname, \fBx3270\fP
acts much like the \fIitelnet\fP(1) command.
It contacts the machine named \fBinternet-gateway\fP at the port defined in
\fB/etc/services\fP as \fBtelnet-passthru\fP
(which defaults to 3514).
It then passes the requested hostname and port to the
\fBin.telnet-gw\fP server.
.SH "FILES"
/usr/lib/X11/x3270/ibm_hosts
.br
$HOME/.x3270pro

.SH "ENVIRONMENT VARIABLES"
\fB3270PRO\fP Path of profile file, containing resource definitions.
Merged after the system resource database, but before \fBX3270RDB\fP.
Defaults to $HOME/.x3270pro.
.br
\fBNOX3270PRO\fP If set, do not read the profile.
.br
\fBX3270RDB\fP Additional resource definitions, merged after the profile
file but before the command-line options.
.br
\fBKEYMAP\fP Keymap name.
.br
\fBKEYBD\fP Keymap name.
.SH "SEE ALSO"
s3270(1), c3270(1), tcl3270(1), ibm_hosts(5), x3270-script(1), pr3287(1), telnet(1), tn3270(1)
.br
X Toolkit Intrinsics
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
.LP
Modifications Copyright 1993, 1994, 1995, 1996, 1997, 1999, 2000, 2001, 2002 by Paul Mattes.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
5250 Emulation Code Copyright Minolta (Schweiz) AG, Beat Rubischon.
.br
x3270 is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the file LICENSE for more details.
.SH "VERSION"
x3270 3.3.2
