/*
 * mtrev22.c   Adachi, J.   1995.12.01
 * Copyright (C) 1995 J. Adachi & M. Hasegawa. All rights reserved.
 */

#include "protml.h"

void 
mtrev(r, f) /* Data of Amino Acid Substitution Model */
	dmattpmty r;    /* Relative Substitution Rate Matrix */
	double *f;      /* Frequency */
{
	int i, j;

	/*
	 * mtREV(22) model data.
	 * complete sequence data of mtDNA from 22 vertebrate species.
	 * Adachi, J. and Hasegawa, M. (1995)
	 * sum of lower triangular is 100000 and lower limit is 10.
	 */

	/* Relative Substitution Rate Matrix (lower triangular) */
	r[ 1][ 0]=5.7194581896405e+01;
	r[ 2][ 0]=1.4129927667766e+02; r[ 2][ 1]=5.8227538094453e+01;
	r[ 3][ 0]=5.9716612672058e+01; r[ 3][ 1]=1.0000000000000e+01;
	r[ 3][ 2]=4.3279634324236e+03;
	r[ 4][ 0]=2.9659245931323e+02; r[ 4][ 1]=6.3563461376582e+02;
	r[ 4][ 2]=2.1163165317139e+02; r[ 4][ 3]=1.0000000000000e+01;
	r[ 5][ 0]=1.7085504247216e+01; r[ 5][ 1]=1.2440815477509e+03;
	r[ 5][ 2]=7.6580036316885e+02; r[ 5][ 3]=3.3339516394008e+02;
	r[ 5][ 4]=2.1196975693560e+02;
	r[ 6][ 0]=5.8919178805212e+01; r[ 6][ 1]=1.0000000000000e+01;
	r[ 6][ 2]=4.3376267497145e+02; r[ 6][ 3]=3.3896606706334e+03;
	r[ 6][ 4]=1.0000000000000e+01; r[ 6][ 5]=1.8305036337501e+03;
	r[ 7][ 0]=6.9461855614213e+02; r[ 7][ 1]=1.4147637821925e+02;
	r[ 7][ 2]=2.7134181435446e+02; r[ 7][ 3]=3.4751336274251e+02;
	r[ 7][ 4]=1.9019151814609e+02; r[ 7][ 5]=4.0562734050792e+01;
	r[ 7][ 6]=1.1482083716028e+02;
	r[ 8][ 0]=8.7087322893801e+01; r[ 8][ 1]=8.2482874641018e+02;
	r[ 8][ 2]=2.4591848359726e+03; r[ 8][ 3]=7.3578857061983e+02;
	r[ 8][ 4]=8.8118209123867e+02; r[ 8][ 5]=3.2151098480772e+03;
	r[ 8][ 6]=2.6446890015375e+02; r[ 8][ 7]=1.0000000000000e+01;
	r[ 9][ 0]=5.8944988567695e+02; r[ 9][ 1]=1.0000000000000e+01;
	r[ 9][ 2]=1.5161713777536e+02; r[ 9][ 3]=3.6687063737867e+01;
	r[ 9][ 4]=2.9658876647101e+02; r[ 9][ 5]=6.9426288431845e+01;
	r[ 9][ 6]=1.0000000000000e+01; r[ 9][ 7]=3.7962635723136e+01;
	r[ 9][ 8]=9.1976845918157e+01;
	r[10][ 0]=1.2925625929027e+02; r[10][ 1]=8.1658320069739e+01;
	r[10][ 2]=1.0900588214166e+02; r[10][ 3]=1.0000000000000e+01;
	r[10][ 4]=2.1841089078526e+02; r[10][ 5]=2.0723732667837e+02;
	r[10][ 6]=1.0000000000000e+01; r[10][ 7]=1.0000000000000e+01;
	r[10][ 8]=6.0842045251914e+01; r[10][ 9]=1.6934175512647e+03;
	r[11][ 0]=1.0000000000000e+01; r[11][ 1]=7.7043117416880e+02;
	r[11][ 2]=2.6784259664261e+03; r[11][ 3]=6.6212920313606e+01;
	r[11][ 4]=1.0000000000000e+01; r[11][ 5]=2.5610566342309e+03;
	r[11][ 6]=1.5435917282315e+03; r[11][ 7]=8.2688894414241e+01;
	r[11][ 8]=3.9076625438064e+02; r[11][ 9]=5.3169546331067e+01;
	r[11][10]=4.4929721089821e+01;
	r[12][ 0]=7.2747442467813e+02; r[12][ 1]=1.0000000000000e+01;
	r[12][ 2]=1.9422230465772e+02; r[12][ 3]=1.0000000000000e+01;
	r[12][ 4]=1.0000000000000e+01; r[12][ 5]=2.9144589160742e+02;
	r[12][ 6]=1.0000000000000e+01; r[12][ 7]=1.0000000000000e+01;
	r[12][ 8]=1.0000000000000e+01; r[12][ 9]=2.4848152262094e+03;
	r[12][10]=2.8111925942543e+03; r[12][11]=3.9763581555686e+02;
	r[13][ 0]=4.7432478088420e+01; r[13][ 1]=2.9816204672590e+01;
	r[13][ 2]=4.0166217787776e+01; r[13][ 3]=3.4906410413692e+01;
	r[13][ 4]=4.0241083663083e+02; r[13][ 5]=1.6611620117501e+02;
	r[13][ 6]=1.0000000000000e+01; r[13][ 7]=1.0000000000000e+01;
	r[13][ 8]=2.1437117056492e+02; r[13][ 9]=4.0332299081595e+02;
	r[13][10]=1.1946668700396e+03; r[13][11]=5.0536520233572e+01;
	r[13][12]=4.2967642618493e+02;
	r[14][ 0]=2.9416616460091e+02; r[14][ 1]=1.5920171715686e+02;
	r[14][ 2]=4.3366387897783e+02; r[14][ 3]=5.0072565470708e+01;
	r[14][ 4]=8.9717766346212e+01; r[14][ 5]=7.6009139702166e+02;
	r[14][ 6]=4.0746537847971e+01; r[14][ 7]=1.0000000000000e+01;
	r[14][ 8]=2.3283852553820e+02; r[14][ 9]=6.8177126815061e+01;
	r[14][10]=2.2694423483167e+02; r[14][11]=2.5168435532223e+02;
	r[14][12]=8.5238828580084e+01; r[14][13]=9.3981296492701e+01;
	r[15][ 0]=2.0685341171422e+03; r[15][ 1]=4.0538359291795e+01;
	r[15][ 2]=2.7813357040863e+03; r[15][ 3]=3.6012426027008e+02;
	r[15][ 4]=1.7049607757424e+03; r[15][ 5]=3.6924210023359e+02;
	r[15][ 6]=3.3423720285715e+02; r[15][ 7]=6.8504752403888e+02;
	r[15][ 8]=3.4239593370082e+02; r[15][ 9]=1.9805837194956e+02;
	r[15][10]=4.2064019746382e+02; r[15][11]=5.1272583934587e+02;
	r[15][12]=6.2623254480631e+02; r[15][13]=3.5790505048538e+02;
	r[15][14]=8.5169212578921e+02;
	r[16][ 0]=2.6487011932093e+03; r[16][ 1]=1.6291843278733e+01;
	r[16][ 2]=1.1193953883228e+03; r[16][ 3]=1.6259385188288e+02;
	r[16][ 4]=9.7438648295664e+02; r[16][ 5]=5.4495878643728e+02;
	r[16][ 6]=7.7695849907671e+01; r[16][ 7]=4.8124090179527e+01;
	r[16][ 8]=3.0484674326514e+02; r[16][ 9]=1.9842290468047e+03;
	r[16][10]=6.2753850400893e+02; r[16][11]=7.0925938427733e+02;
	r[16][12]=2.8383277051526e+03; r[16][13]=1.5692103979344e+02;
	r[16][14]=6.7308757371259e+02; r[16][15]=3.1436053261598e+03;
	r[17][ 0]=1.0000000000000e+01; r[17][ 1]=1.3483776388495e+02;
	r[17][ 2]=5.7103660271913e+01; r[17][ 3]=4.9999546398002e+01;
	r[17][ 4]=2.0752921178059e+02; r[17][ 5]=1.0000000000000e+01;
	r[17][ 6]=1.0000000000000e+01; r[17][ 7]=4.5312041124180e+01;
	r[17][ 8]=4.1492038091486e+01; r[17][ 9]=1.0000000000000e+01;
	r[17][10]=1.7472372565657e+02; r[17][11]=1.6439115448354e+02;
	r[17][12]=1.2882637901547e+02; r[17][13]=5.0437962206704e+01;
	r[17][14]=2.7938565494449e+01; r[17][15]=1.7550030392658e+02;
	r[17][16]=8.2083350457831e+01;
	r[18][ 0]=3.4625179852200e+01; r[18][ 1]=1.0000000000000e+01;
	r[18][ 2]=8.1608662407824e+02; r[18][ 3]=5.8176251308929e+01;
	r[18][ 4]=1.3887266830632e+03; r[18][ 5]=2.0028256992692e+02;
	r[18][ 6]=1.0782052349643e+02; r[18][ 7]=1.0000000000000e+01;
	r[18][ 8]=3.6633508794637e+03; r[18][ 9]=1.6020147441586e+02;
	r[18][10]=2.2782754501741e+02; r[18][11]=2.7254470282569e+02;
	r[18][12]=1.6230714586380e+02; r[18][13]=2.2946713849648e+03;
	r[18][14]=8.1780448889565e+01; r[18][15]=2.9045554521070e+02;
	r[18][16]=1.5308093404010e+02; r[18][17]=1.3477620760531e+02;
	r[19][ 0]=9.4444413654427e+02; r[19][ 1]=4.7242141594223e+01;
	r[19][ 2]=6.2450553351128e+01; r[19][ 3]=1.0000000000000e+01;
	r[19][ 4]=1.0000000000000e+01; r[19][ 5]=6.6415881904407e+01;
	r[19][ 6]=1.2395120559907e+02; r[19][ 7]=1.6285049187252e+01;
	r[19][ 8]=1.0000000000000e+01; r[19][ 9]=6.4486128802762e+03;
	r[19][10]=4.6686082498034e+02; r[19][11]=1.0000000000000e+01;
	r[19][12]=2.1648732019540e+03; r[19][13]=3.3365635873817e+01;
	r[19][14]=4.7811115596696e+01; r[19][15]=1.0000000000000e+01;
	r[19][16]=1.1125417153245e+03; r[19][17]=3.2983109848540e+01;
	r[19][18]=2.8566089408702e+01; /* sum: 100000.083157 */

	/* Amino Acid Frequency */
	f[ 0]=0.072; f[ 1]=0.019; f[ 2]=0.039; f[ 3]=0.019; f[ 4]=0.006;
	f[ 5]=0.025; f[ 6]=0.024; f[ 7]=0.056; f[ 8]=0.028; f[ 9]=0.087;
	f[10]=0.168; f[11]=0.023; f[12]=0.053; f[13]=0.060; f[14]=0.055;
	f[15]=0.072; f[16]=0.088; f[17]=0.029; f[18]=0.033; f[19]=0.044;

	for (i = 1; i < 20; i++) {
		for (j = 0; j < i; j++) r[j][i] = r[i][j];
	}
	for (i = 0; i < 20; i++) r[i][i] = 0.0;

} /* mtrev */
