// $ANTLR 2.7.2a2 (20020112-1): "../src_new/org/argouml/uml/reveng/java/java.g" -> "JavaRecognizer.java"$

package org.argouml.uml.reveng.java;

import java.util.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/** 
 * This is the Java parser for reverse engineering Java source code
 * to a UML model.
 * 
 * <p>It is generated by the ANTLR parser generator (www.antlr.org). Antlr
 *    uses the java.g grammar file to generate the JavaRecogniser.java
 *    parser.
 * 
 * <p><strong>DO NOT MODIFY JavaRecogniser.java</strong>
 * 
 * <p>If you need to modify how Argo parses Java files then:
 * <ol>
 *     <li>modify <strong>java.g</strong>. See the antlr website
 *         for examples of how to modify a antlr grammar file</li>
 *     <li>save java.g and run argo's build script with the 
 *         "<strong>generateparser</strong>" target.</li>
 *     <li>build argo again.</li>
 * </ol>
 * 
 * --------- old notes: -------------------------------------------
 * <pre>
 * Java 1.5 Recognizer
 *
 * Run 'java Main [-showtree] directory-full-of-java-files'
 *
 * [The -showtree option pops up a Swing frame that shows
 *  the AST constructed from the parser.]
 *
 * Run 'java Main <directory full of java files>'
 *
 * Contributing authors:
 *        John Mitchell        johnm@non.net
 *        Terence Parr        parrt@magelang.com
 *        John Lilley        jlilley@empathy.com
 *        Scott Stanchfield    thetick@magelang.com
 *        Markus Mohnen        mohnen@informatik.rwth-aachen.de
 *        Peter Williams        pete.williams@sun.com
 *        Allan Jacobs        Allan.Jacobs@eng.sun.com
 *        Steve Messick        messick@redhills.com
 *        John Pybus        john@pybus.org
 *
 * Version 1.00 December 9, 1997 -- initial release
 * Version 1.01 December 10, 1997
 *        fixed bug in octal def (0..7 not 0..8)
 * Version 1.10 August 1998 (parrt)
 *        added tree construction
 *        fixed definition of WS,comments for mac,pc,unix newlines
 *        added unary plus
 * Version 1.11 (Nov 20, 1998)
 *        Added "shutup" option to turn off last ambig warning.
 *        Fixed inner class def to allow named class defs as statements
 *        synchronized requires compound not simple statement
 *        add [] after builtInType DOT class in primaryExpression
 *        "const" is reserved but not valid..removed from modifiers
 * Version 1.12 (Feb 2, 1999)
 *        Changed LITERAL_xxx to xxx in tree grammar.
 *        Updated java.g to use tokens {...} now for 2.6.0 (new feature).
 *
 * Version 1.13 (Apr 23, 1999)
 *        Didn't have (stat)? for else clause in tree parser.
 *        Didn't gen ASTs for interface extends.  Updated tree parser too.
 *        Updated to 2.6.0.
 * Version 1.14 (Jun 20, 1999)
 *        Allowed final/abstract on local classes.
 *        Removed local interfaces from methods
 *        Put instanceof precedence where it belongs...in relationalExpr
 *            It also had expr not type as arg; fixed it.
 *        Missing ! on SEMI in classBlock
 *        fixed: (expr) + "string" was parsed incorrectly (+ as unary plus).
 *        fixed: didn't like Object[].class in parser or tree parser
 * Version 1.15 (Jun 26, 1999)
 *        Screwed up rule with instanceof in it. :(  Fixed.
 *        Tree parser didn't like (expr).something; fixed.
 *        Allowed multiple inheritance in tree grammar. oops.
 * Version 1.16 (August 22, 1999)
 *        Extending an interface built a wacky tree: had extra EXTENDS.
 *        Tree grammar didn't allow multiple superinterfaces.
 *        Tree grammar didn't allow empty var initializer: {}
 * Version 1.17 (October 12, 1999)
 *        ESC lexer rule allowed 399 max not 377 max.
 *        java.tree.g didn't handle the expression of synchronized
 *        statements.
 * Version 1.18 (August 12, 2001)
 *          Terence updated to Java 2 Version 1.3 by
 *        observing/combining work of Allan Jacobs and Steve
 *        Messick.  Handles 1.3 src.  Summary:
 *        o  primary didn't include boolean.class kind of thing
 *        o  constructor calls parsed explicitly now:
 *            see explicitConstructorInvocation
 *        o  add strictfp modifier
 *        o  missing objBlock after new expression in tree grammar
 *        o  merged local class definition alternatives, moved after declaration
 *        o  fixed problem with ClassName.super.field
 *        o  reordered some alternatives to make things more efficient
 *        o  long and double constants were not differentiated from int/float
 *        o  whitespace rule was inefficient: matched only one char
 *        o  add an examples directory with some nasty 1.3 cases
 *        o  made Main.java use buffered IO and a Reader for Unicode support
 *        o  supports UNICODE?
 *           Using Unicode charVocabulay makes code file big, but only
 *           in the bitsets at the end. I need to make ANTLR generate
 *           unicode bitsets more efficiently.
 * Version 1.19 (April 25, 2002)
 *        Terence added in nice fixes by John Pybus concerning floating
 *        constants and problems with super() calls.  John did a nice
 *        reorg of the primary/postfix expression stuff to read better
 *        and makes f.g.super() parse properly (it was METHOD_CALL not
 *        a SUPER_CTOR_CALL).  Also:
 *
 *        o  "finally" clause was a root...made it a child of "try"
 *        o  Added stuff for asserts too for Java 1.4, but *commented out*
 *           as it is not backward compatible.
 *
 * Version 1.20 (October 27, 2002)
 *
 *      Terence ended up reorging John Pybus' stuff to
 *      remove some nondeterminisms and some syntactic predicates.
 *      Note that the grammar is stricter now; e.g., this(...) must
 *    be the first statement.
 *
 *      Trinary ?: operator wasn't working as array name:
 *          (isBig ? bigDigits : digits)[i];
 *
 *      Checked parser/tree parser on source for
 *          Resin-2.0.5, jive-2.1.1, jdk 1.3.1, Lucene, antlr 2.7.2a4,
 *        and the 110k-line jGuru server source.
 *
 * Version 1.21 (October 17, 2003)
 *  Fixed lots of problems including:
 *  Ray Waldin: add typeDefinition to interfaceBlock in java.tree.g
 *  He found a problem/fix with floating point that start with 0
 *  Ray also fixed problem that (int.class) was not recognized.
 *  Thorsten van Ellen noticed that \n are allowed incorrectly in strings.
 *  TJP fixed CHAR_LITERAL analogously.
 *
 * Version 1.21.2 (March, 2003)
 *      Changes by Matt Quail to support generics (as per JDK1.5/JSR14)
 *      Notes:
 *      o We only allow the "extends" keyword and not the "implements"
 *        keyword, since thats what JSR14 seems to imply.
 *      o Thanks to Monty Zukowski for his help on the antlr-interest
 *        mail list.
 *      o Thanks to Alan Eliasen for testing the grammar over his
 *        Fink source base
 *
 * Version 1.22 (July, 2004)
 *      Changes by Michael Studman to support Java 1.5 language extensions
 *      Notes:
 *      o Added support for annotations types
 *      o Finished off Matt Quail's generics enhancements to support bound type arguments
 *      o Added support for new for statement syntax
 *      o Added support for static import syntax
 *      o Added support for enum types
 *      o Tested against JDK 1.5 source base and source base of jdigraph project
 *      o Thanks to Matt Quail for doing the hard part by doing most of the generics work
 *
 * Version 1.22.1 (July 28, 2004)
 *      Bug/omission fixes for Java 1.5 language support
 *      o Fixed tree structure bug with classOrInterface - thanks to Pieter Vangorpto for
 *        spotting this
 *      o Fixed bug where incorrect handling of SR and BSR tokens would cause type
 *        parameters to be recognised as type arguments.
 *      o Enabled type parameters on constructors, annotations on enum constants
 *        and package definitions
 *      o Fixed problems when parsing if ((char.class.equals(c))) {} - solution by Matt Quail at Cenqua
 *
 * Version 1.22.2 (July 28, 2004)
 *      Slight refactoring of Java 1.5 language support
 *      o Refactored for/"foreach" productions so that original literal "for" literal
 *        is still used but the for sub-clauses vary by token type
 *      o Fixed bug where type parameter was not included in generic constructor's branch of AST
 *
 * Version 1.22.3 (August 26, 2004)
 *      Bug fixes as identified by Michael Stahl; clean up of tabs/spaces
 *        and other refactorings
 *      o Fixed typeParameters omission in identPrimary and newStatement
 *      o Replaced GT reconcilliation code with simple semantic predicate
 *      o Adapted enum/assert keyword checking support from Michael Stahl's java15 grammar
 *      o Refactored typeDefinition production and field productions to reduce duplication
 *
 * Version 1.22.4 (October 21, 2004)
 *    Small bux fixes
 *    o Added typeArguments to explicitConstructorInvocation, e.g. new <String>MyParameterised()
 *    o Added typeArguments to postfixExpression productions for anonymous inner class super
 *      constructor invocation, e.g. new Outer().<String>super()
 *    o Fixed bug in array declarations identified by Geoff Roy
 *
 * Version 1.22.5 (January 03, 2005)
 *    Small change to tree structure
 *    o Flattened classOrInterfaceType tree so IDENT no longer has children. TYPE_ARGUMENTS are now
 *      always siblings of IDENT rather than children. Fully.qualified.names trees now
 *      look a little less clean when TYPE_ARGUMENTS are present though.
 *
 * This grammar is in the PUBLIC DOMAIN
 *
 * Modified by Thomas Neustupny (July 06, 2005)
 *    Update to Java 1.5 for the Import feature of ArgoUML
 *    o Removed all AST stuff
 *    o Added a lot of stuff for the UML Modeller
 *    o Not passing typeArguments and typeParameters to the Modeller (don't how they map to UML)
 *    o Not passing enumDefinition and annotationDefinition to the Modeller (TODO)
 *    o Not passing variableLengthParameterDeclaration to the Modeller (don't how they map to UML)
 *
 * This grammar is in the PUBLIC DOMAIN
 * </pre>
 */
public class JavaRecognizer extends antlr.LLkParser
       implements JavaTokenTypes
 {

    /**
     * Counts the number of LT seen in the typeArguments production.
     * It is used in semantic predicates to ensure we have seen
     * enough closing '>' characters; which actually may have been
     * either GT, SR or BSR tokens.
     */
    private int ltCounter = 0;

    // Constants for access modifiers according to the JVM specs chapter 4
    public static final short ACC_PUBLIC    = 0x0001;
    public static final short ACC_PRIVATE   = 0x0002;
    public static final short ACC_PROTECTED = 0x0004;
    public static final short ACC_STATIC    = 0x0008;
    public static final short ACC_FINAL     = 0x0010;
    public static final short ACC_SUPER     = 0x0020;
    public static final short ACC_VOLATILE  = 0x0040;
    public static final short ACC_TRANSIENT = 0x0080;
    public static final short ACC_NATIVE    = 0x0100;
    public static final short ACC_INTERFACE = 0x0200;
    public static final short ACC_ABSTRACT  = 0x0400;                     

    /** Parser mode for the first pass of the import from sources */
    public static final int MODE_IMPORT_PASS1 = 1;
    /** Parser mode for the second pass of the import from sources */
    public static final int MODE_IMPORT_PASS2 = 2;
    /** Parser mode for the source code generation in update mode */
    public static final int MODE_GENERATION_UPDATE = 4;
    /** Parser mode for the reverse engineering of a sequence diagram */
    public static final int MODE_REVENG_SEQUENCE = 8;

    /** The parser mode, that controls which semantic expressions will be active */
    private int parserMode = 0;

    /** The name of the variable to which a created object (new...) is assigned to */
    private String createdObjectVarName = null;
   
    /** Import details level */
    private int level = 2;

    /** Set the parser mode, to control which semantic expressions will be active */
    public void setParserMode(int mode) {
        parserMode = mode;
    }
    
    // This one is not(!) in the JVM specs, but required
    public static final short ACC_SYNCHRONIZED  = 0x0800;

    /**
     * To get direct access to the lexer (for the javadoc
     * comments), we store a reference to it.
     */
    private JavaLexer _lexer = null;

    /**
     * Set the lexer for this parser.
     * 
     * @param lexer The lexer for this parser.
     */
    private void setLexer(JavaLexer lexer) {
        _lexer = lexer;
    }
    
    /**
     * Get the last parsed javadoc comment from the lexer.
     */
    private String getJavadocComment() {
        return _lexer.getJavadocComment();
    }
    
        private Modeller _modeller;

    public Modeller getModeller() {
        return _modeller;
    }

    public void setModeller(Modeller modeller) {
        _modeller = modeller;
        Object lvl = modeller.getAttribute("level");
        if (lvl != null) {
          level = ((Integer)lvl).intValue();
        }
        }
    
        // A reference to the last added MOperation (here: method)
        private Object _currentMethod = null;

    /**
     * get reference to the last added MOperation (here: method)
     */
    Object getMethod() {
        return _currentMethod;
    }

    /**
     * set reference to the last added MOperation (here: method)
     */
    void setMethod(Object method) {
        _currentMethod = method;
    }

    // A method body
    private String _methodBody = null;

    /**
     * get last method body
     */
    String getBody() {
        return _methodBody;
    }

    /**
     * set last method body
     */
    void setBody(String body) {
        _methodBody = body + '\n';
    }

    // A flag to indicate if we track the tokens for a expression.
    private boolean      _trackExpression  = false;    

    // A flag to indicate if we are inside a compoundStatement
    private boolean      _inCompoundStatement  = false;    

    // A string buffer for the current expression.
    private StringBuffer _expressionBuffer = new StringBuffer();   

    /**
     * set if we are inside a compoundStatement
     */
    void setIsInCompoundStatement(boolean flag) {
        _inCompoundStatement = flag;
    }

    /**
     * check if we are inside a compoundStatement
     */
    boolean isInCompoundStatement() {
        return _inCompoundStatement;
    }

    /**
     * Activate the tracking of expressions.
     */
    void activateExpressionTracking() {
        _trackExpression = true;
    }

    /**
     * Deactivate the tracking of expressions.
     */
    void deactivateExpressionTracking() {
        _trackExpression = false;
    }

    /**
     * Get a tracked expression.
     *
     * @return the tracked expression.
     */
    public String getExpression() {
        String result = _expressionBuffer.toString();

        _expressionBuffer = new StringBuffer();

        return result;
    }
        
    /**
     * Add a call that appears after a dot.
     */
    private void addDotCall(String id, String thisOrSuper, boolean parenths) {
        StringBuffer sb = new StringBuffer();
        String prev = (String)getModeller().getMethodCalls().lastElement();
        if (thisOrSuper != null) {
            sb.append(thisOrSuper);
        } else if (prev != null) {
            if (parenths) {
                sb.append('(');
            }
            sb.append(prev).append("()");
            if (parenths) {
                sb.append(')');
            }
            sb.append('.');
        }
        sb.append(id);
        getModeller().addCall(sb.toString());
    }

    /**
     * Appends to a tracked expression. (used to restore it)
     */
    public void appendExpression(String expr) {
        _expressionBuffer.append(expr);
    }      

    public void match(int t) throws MismatchedTokenException, TokenStreamException {
        String text = ((ArgoToken)LT(1)).getWhitespace() + LT(1).getText();

        super.match(t);

        // '== 0' to avoid the following when backtracking
        if(_trackExpression && inputState.guessing==0)
            appendExpression(text);
    }     

protected JavaRecognizer(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public JavaRecognizer(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected JavaRecognizer(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public JavaRecognizer(TokenStream lexer) {
  this(lexer,2);
}

public JavaRecognizer(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
}

	public final void compilationUnit(
		 Modeller modeller, JavaLexer lexer
	) throws RecognitionException, TokenStreamException {
		
		setModeller(modeller);
		setLexer(lexer);
		if ( inputState.guessing==0 ) {
		getModeller().addComponent();
		}
		
		
		{
		boolean synPredMatched4 = false;
		if (((LA(1)==LITERAL_package||LA(1)==AT) && (LA(2)==IDENT))) {
			int _m4 = mark();
			synPredMatched4 = true;
			inputState.guessing++;
			try {
				{
				annotations();
				match(LITERAL_package);
				}
			}
			catch (RecognitionException pe) {
				synPredMatched4 = false;
			}
			rewind(_m4);
			inputState.guessing--;
		}
		if ( synPredMatched4 ) {
			packageDefinition();
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop6:
		do {
			if ((LA(1)==LITERAL_import)) {
				importDefinition();
			}
			else {
				break _loop6;
			}
			
		} while (true);
		}
		{
		_loop8:
		do {
			if ((_tokenSet_2.member(LA(1)))) {
				typeDefinition();
			}
			else {
				break _loop8;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
	}
	
	public final void annotations() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop62:
		do {
			if ((LA(1)==AT)) {
				annotation();
			}
			else {
				break _loop62;
			}
			
		} while (true);
		}
	}
	
	public final void packageDefinition() throws RecognitionException, TokenStreamException {
		
		String packageName = null;
		
		try {      // for error handling
			annotations();
			match(LITERAL_package);
			packageName=identifier();
			match(SEMI);
			if ( inputState.guessing==0 ) {
				getModeller().addPackage(packageName);
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				consume();
				consumeUntil(_tokenSet_0);
			} else {
			  throw ex;
			}
		}
	}
	
	public final void importDefinition() throws RecognitionException, TokenStreamException {
		
		String name=null;
		
		try {      // for error handling
			match(LITERAL_import);
			{
			switch ( LA(1)) {
			case LITERAL_static:
			{
				match(LITERAL_static);
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			name=identifierStar();
			match(SEMI);
			if ( inputState.guessing==0 ) {
				getModeller().addImport(name);
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				consume();
				consumeUntil(_tokenSet_0);
			} else {
			  throw ex;
			}
		}
	}
	
	public final void typeDefinition() throws RecognitionException, TokenStreamException {
		
		short m = 0;
		
		try {      // for error handling
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_static:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_threadsafe:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case AT:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				m=modifiers();
				typeDefinitionInternal(m);
				break;
			}
			case SEMI:
			{
				match(SEMI);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				consume();
				consumeUntil(_tokenSet_3);
			} else {
			  throw ex;
			}
		}
	}
	
	public final String  identifier() throws RecognitionException, TokenStreamException {
		String name=null;
		
		Token  t1 = null;
		Token  t2 = null;
		
		t1 = LT(1);
		match(IDENT);
		if ( inputState.guessing==0 ) {
			name = t1.getText();
		}
		{
		_loop48:
		do {
			if ((LA(1)==DOT)) {
				match(DOT);
				t2 = LT(1);
				match(IDENT);
				if ( inputState.guessing==0 ) {
					name += "." + t2.getText();
				}
			}
			else {
				break _loop48;
			}
			
		} while (true);
		}
		return name;
	}
	
	public final String  identifierStar() throws RecognitionException, TokenStreamException {
		String name=null;
		
		Token  t1 = null;
		Token  t2 = null;
		
		t1 = LT(1);
		match(IDENT);
		if ( inputState.guessing==0 ) {
			name = t1.getText();
		}
		{
		_loop51:
		do {
			if ((LA(1)==DOT) && (LA(2)==IDENT)) {
				match(DOT);
				t2 = LT(1);
				match(IDENT);
				if ( inputState.guessing==0 ) {
					name = name + "." + t2.getText();
				}
			}
			else {
				break _loop51;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case DOT:
		{
			match(DOT);
			match(STAR);
			if ( inputState.guessing==0 ) {
				name = name + "." + "*";
			}
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return name;
	}
	
	public final  short  modifiers() throws RecognitionException, TokenStreamException {
		 short mod_flags;
		
		mod_flags = 0;
		short cur_flag;
		
		{
		_loop55:
		do {
			if ((_tokenSet_4.member(LA(1)))) {
				cur_flag=modifier();
				if ( inputState.guessing==0 ) {
					mod_flags |= cur_flag;
				}
			}
			else if (((LA(1)==AT) && (LA(2)==IDENT))&&(LA(1)==AT && !LT(2).getText().equals("interface"))) {
				annotation();
			}
			else {
				break _loop55;
			}
			
		} while (true);
		}
		return mod_flags;
	}
	
	protected final void typeDefinitionInternal(
		short mods
	) throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case LITERAL_class:
		{
			classDefinition(getJavadocComment(), mods);
			break;
		}
		case LITERAL_interface:
		{
			interfaceDefinition(getJavadocComment(), mods);
			break;
		}
		case LITERAL_enum:
		{
			enumDefinition(getJavadocComment(), mods);
			break;
		}
		case AT:
		{
			annotationDefinition(getJavadocComment(), mods);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void classDefinition(
		String javadoc, short modifiers
	) throws RecognitionException, TokenStreamException {
		
		Token  className = null;
		String superClassName = null; Vector ic = null;
		
		match(LITERAL_class);
		className = LT(1);
		match(IDENT);
		{
		switch ( LA(1)) {
		case LT:
		{
			typeParameters();
			break;
		}
		case LITERAL_extends:
		case LCURLY:
		case LITERAL_implements:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		superClassName=superClassClause();
		ic=implementsClause();
		if ( inputState.guessing==0 ) {
			
			if (!isInCompoundStatement()) {
			getModeller().addClass(className.getText(), modifiers, superClassName, ic, javadoc);
			}
			
		}
		classBlock();
		if ( inputState.guessing==0 ) {
			
			if (!isInCompoundStatement()) {
			getModeller().popClassifier();
			}
			
		}
	}
	
	public final void interfaceDefinition(
		String javadoc, short modifiers
	) throws RecognitionException, TokenStreamException {
		
		Token  interfaceName = null;
		Vector ie=null;
		
		match(LITERAL_interface);
		interfaceName = LT(1);
		match(IDENT);
		{
		switch ( LA(1)) {
		case LT:
		{
			typeParameters();
			break;
		}
		case LITERAL_extends:
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		ie=interfaceExtends();
		if ( inputState.guessing==0 ) {
			getModeller().addInterface(interfaceName.getText(), modifiers,
			ie, javadoc);
		}
		interfaceBlock();
		if ( inputState.guessing==0 ) {
			getModeller().popClassifier();
		}
	}
	
	public final void enumDefinition(
		String javadoc, short modifiers
	) throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_enum);
		match(IDENT);
		implementsClause();
		enumBlock();
	}
	
	public final void annotationDefinition(
		String javadoc, short modifiers
	) throws RecognitionException, TokenStreamException {
		
		
		match(AT);
		match(LITERAL_interface);
		match(IDENT);
		annotationBlock();
	}
	
	public final void declaration() throws RecognitionException, TokenStreamException {
		
		short m = 0; String t=null;
		
		m=modifiers();
		t=typeSpec();
		variableDefinitions("", m, t);
	}
	
	public final String  typeSpec() throws RecognitionException, TokenStreamException {
		String type=null;
		
		String c=null, b=null;
		
		switch ( LA(1)) {
		case IDENT:
		{
			c=classTypeSpec();
			if ( inputState.guessing==0 ) {
				type=c;
			}
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			b=builtInTypeSpec();
			if ( inputState.guessing==0 ) {
				type=b;
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return type;
	}
	
	public final void variableDefinitions(
		String javadoc, short modifiers, String returnType
	) throws RecognitionException, TokenStreamException {
		
		
		variableDeclarator(javadoc, modifiers, returnType);
		{
		_loop155:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				variableDeclarator(javadoc, modifiers, returnType);
			}
			else {
				break _loop155;
			}
			
		} while (true);
		}
	}
	
	public final String  classTypeSpec() throws RecognitionException, TokenStreamException {
		String type=null;
		
		
		type=classOrInterfaceType();
		{
		_loop18:
		do {
			if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
				match(LBRACK);
				match(RBRACK);
				if ( inputState.guessing==0 ) {
					type += "[]";
				}
			}
			else {
				break _loop18;
			}
			
		} while (true);
		}
		return type;
	}
	
	public final String  builtInTypeSpec() throws RecognitionException, TokenStreamException {
		String type=null;
		
		
		type=builtInType();
		{
		_loop43:
		do {
			if ((LA(1)==LBRACK)) {
				match(LBRACK);
				match(RBRACK);
				if ( inputState.guessing==0 ) {
					type += "[]";
				}
			}
			else {
				break _loop43;
			}
			
		} while (true);
		}
		return type;
	}
	
	public final String  classOrInterfaceType() throws RecognitionException, TokenStreamException {
		String type=null;
		
		Token  t1 = null;
		Token  t3 = null;
		StringBuffer sb = new StringBuffer();
		
		t1 = LT(1);
		match(IDENT);
		if ( inputState.guessing==0 ) {
			sb.append(t1.getText());
		}
		{
		switch ( LA(1)) {
		case LT:
		{
			typeArguments();
			break;
		}
		case SEMI:
		case LBRACK:
		case RBRACK:
		case IDENT:
		case DOT:
		case QUESTION:
		case LITERAL_extends:
		case LITERAL_super:
		case COMMA:
		case GT:
		case SR:
		case BSR:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case RPAREN:
		case ASSIGN:
		case LCURLY:
		case RCURLY:
		case BAND:
		case LITERAL_implements:
		case LITERAL_this:
		case TRIPLE_DOT:
		case COLON:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		case LOR:
		case LAND:
		case BOR:
		case BXOR:
		case NOT_EQUAL:
		case EQUAL:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop23:
		do {
			if ((LA(1)==DOT) && (LA(2)==IDENT)) {
				match(DOT);
				t3 = LT(1);
				match(IDENT);
				if ( inputState.guessing==0 ) {
					sb.append('.').append(t3.getText());
				}
				{
				switch ( LA(1)) {
				case LT:
				{
					typeArguments();
					break;
				}
				case SEMI:
				case LBRACK:
				case RBRACK:
				case IDENT:
				case DOT:
				case QUESTION:
				case LITERAL_extends:
				case LITERAL_super:
				case COMMA:
				case GT:
				case SR:
				case BSR:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case LPAREN:
				case RPAREN:
				case ASSIGN:
				case LCURLY:
				case RCURLY:
				case BAND:
				case LITERAL_implements:
				case LITERAL_this:
				case TRIPLE_DOT:
				case COLON:
				case PLUS_ASSIGN:
				case MINUS_ASSIGN:
				case STAR_ASSIGN:
				case DIV_ASSIGN:
				case MOD_ASSIGN:
				case SR_ASSIGN:
				case BSR_ASSIGN:
				case SL_ASSIGN:
				case BAND_ASSIGN:
				case BXOR_ASSIGN:
				case BOR_ASSIGN:
				case LOR:
				case LAND:
				case BOR:
				case BXOR:
				case NOT_EQUAL:
				case EQUAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			else {
				break _loop23;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			type = sb.toString();
		}
		return type;
	}
	
	public final void typeArguments() throws RecognitionException, TokenStreamException {
		
		int currentLtLevel = 0;
		
		if ( inputState.guessing==0 ) {
			currentLtLevel = ltCounter;
		}
		match(LT);
		if ( inputState.guessing==0 ) {
			ltCounter++;
		}
		typeArgument();
		{
		_loop33:
		do {
			if (((LA(1)==COMMA) && (_tokenSet_5.member(LA(2))))&&(inputState.guessing !=0 || ltCounter == currentLtLevel + 1)) {
				match(COMMA);
				typeArgument();
			}
			else {
				break _loop33;
			}
			
		} while (true);
		}
		{
		if (((LA(1) >= GT && LA(1) <= BSR)) && (_tokenSet_6.member(LA(2)))) {
			typeArgumentsOrParametersEnd();
		}
		else if ((_tokenSet_6.member(LA(1))) && (_tokenSet_7.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if (!((currentLtLevel != 0) || ltCounter == currentLtLevel))
		  throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
	}
	
	public final void typeArgumentSpec() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case IDENT:
		{
			classTypeSpec();
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInTypeArraySpec();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void builtInTypeArraySpec() throws RecognitionException, TokenStreamException {
		
		
		builtInType();
		{
		int _cnt40=0;
		_loop40:
		do {
			if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
				match(LBRACK);
				match(RBRACK);
			}
			else {
				if ( _cnt40>=1 ) { break _loop40; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt40++;
		} while (true);
		}
	}
	
	public final void typeArgument() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			typeArgumentSpec();
			break;
		}
		case QUESTION:
		{
			wildcardType();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void wildcardType() throws RecognitionException, TokenStreamException {
		
		
		match(QUESTION);
		{
		boolean synPredMatched30 = false;
		if (((LA(1)==LITERAL_extends||LA(1)==LITERAL_super) && (LA(2)==IDENT))) {
			int _m30 = mark();
			synPredMatched30 = true;
			inputState.guessing++;
			try {
				{
				switch ( LA(1)) {
				case LITERAL_extends:
				{
					match(LITERAL_extends);
					break;
				}
				case LITERAL_super:
				{
					match(LITERAL_super);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			catch (RecognitionException pe) {
				synPredMatched30 = false;
			}
			rewind(_m30);
			inputState.guessing--;
		}
		if ( synPredMatched30 ) {
			typeArgumentBounds();
		}
		else if ((_tokenSet_8.member(LA(1))) && (_tokenSet_9.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
	}
	
	public final void typeArgumentBounds() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			match(LITERAL_extends);
			break;
		}
		case LITERAL_super:
		{
			match(LITERAL_super);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		classOrInterfaceType();
	}
	
	protected final void typeArgumentsOrParametersEnd() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case GT:
		{
			match(GT);
			if ( inputState.guessing==0 ) {
				ltCounter-=1;
			}
			break;
		}
		case SR:
		{
			match(SR);
			if ( inputState.guessing==0 ) {
				ltCounter-=2;
			}
			break;
		}
		case BSR:
		{
			match(BSR);
			if ( inputState.guessing==0 ) {
				ltCounter-=3;
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final String  builtInType() throws RecognitionException, TokenStreamException {
		String type=null;
		
		
		switch ( LA(1)) {
		case LITERAL_void:
		{
			match(LITERAL_void);
			if ( inputState.guessing==0 ) {
				type="void";
			}
			break;
		}
		case LITERAL_boolean:
		{
			match(LITERAL_boolean);
			if ( inputState.guessing==0 ) {
				type="boolean";
			}
			break;
		}
		case LITERAL_byte:
		{
			match(LITERAL_byte);
			if ( inputState.guessing==0 ) {
				type="byte";
			}
			break;
		}
		case LITERAL_char:
		{
			match(LITERAL_char);
			if ( inputState.guessing==0 ) {
				type="char";
			}
			break;
		}
		case LITERAL_short:
		{
			match(LITERAL_short);
			if ( inputState.guessing==0 ) {
				type="short";
			}
			break;
		}
		case LITERAL_int:
		{
			match(LITERAL_int);
			if ( inputState.guessing==0 ) {
				type="int";
			}
			break;
		}
		case LITERAL_float:
		{
			match(LITERAL_float);
			if ( inputState.guessing==0 ) {
				type="float";
			}
			break;
		}
		case LITERAL_long:
		{
			match(LITERAL_long);
			if ( inputState.guessing==0 ) {
				type="long";
			}
			break;
		}
		case LITERAL_double:
		{
			match(LITERAL_double);
			if ( inputState.guessing==0 ) {
				type="double";
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return type;
	}
	
	public final String  type() throws RecognitionException, TokenStreamException {
		String type=null;
		
		
		switch ( LA(1)) {
		case IDENT:
		{
			type=classOrInterfaceType();
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			type=builtInType();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return type;
	}
	
	public final short  modifier() throws RecognitionException, TokenStreamException {
		short mod_flag = 0;
		
		
		switch ( LA(1)) {
		case LITERAL_private:
		{
			match(LITERAL_private);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_PRIVATE;
			}
			break;
		}
		case LITERAL_public:
		{
			match(LITERAL_public);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_PUBLIC;
			}
			break;
		}
		case LITERAL_protected:
		{
			match(LITERAL_protected);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_PROTECTED;
			}
			break;
		}
		case LITERAL_static:
		{
			match(LITERAL_static);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_STATIC;
			}
			break;
		}
		case LITERAL_transient:
		{
			match(LITERAL_transient);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_TRANSIENT;
			}
			break;
		}
		case FINAL:
		{
			match(FINAL);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_FINAL;
			}
			break;
		}
		case ABSTRACT:
		{
			match(ABSTRACT);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_ABSTRACT;
			}
			break;
		}
		case LITERAL_native:
		{
			match(LITERAL_native);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_NATIVE;
			}
			break;
		}
		case LITERAL_threadsafe:
		{
			match(LITERAL_threadsafe);
			break;
		}
		case LITERAL_synchronized:
		{
			match(LITERAL_synchronized);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_SYNCHRONIZED;
			}
			break;
		}
		case LITERAL_volatile:
		{
			match(LITERAL_volatile);
			if ( inputState.guessing==0 ) {
				mod_flag = ACC_VOLATILE;
			}
			break;
		}
		case STRICTFP:
		{
			match(STRICTFP);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return mod_flag;
	}
	
	public final void annotation() throws RecognitionException, TokenStreamException {
		
		
		match(AT);
		identifier();
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			match(LPAREN);
			{
			switch ( LA(1)) {
			case IDENT:
			case LITERAL_super:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case AT:
			case LPAREN:
			case LCURLY:
			case LITERAL_this:
			case PLUS:
			case MINUS:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				annotationArguments();
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(RPAREN);
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case LITERAL_package:
		case SEMI:
		case LITERAL_static:
		case IDENT:
		case LT:
		case COMMA:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_threadsafe:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case AT:
		case RPAREN:
		case RCURLY:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_enum:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void annotationArguments() throws RecognitionException, TokenStreamException {
		
		
		if ((_tokenSet_10.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
			annotationMemberValueInitializer();
		}
		else if ((LA(1)==IDENT) && (LA(2)==ASSIGN)) {
			anntotationMemberValuePairs();
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
	}
	
	public final void annotationMemberValueInitializer() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			conditionalExpression();
			break;
		}
		case AT:
		{
			annotation();
			break;
		}
		case LCURLY:
		{
			annotationMemberArrayInitializer();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void anntotationMemberValuePairs() throws RecognitionException, TokenStreamException {
		
		
		annotationMemberValuePair();
		{
		_loop66:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				annotationMemberValuePair();
			}
			else {
				break _loop66;
			}
			
		} while (true);
		}
	}
	
	public final void annotationMemberValuePair() throws RecognitionException, TokenStreamException {
		
		
		match(IDENT);
		match(ASSIGN);
		annotationMemberValueInitializer();
	}
	
	public final void conditionalExpression() throws RecognitionException, TokenStreamException {
		
		
		logicalOrExpression();
		{
		switch ( LA(1)) {
		case QUESTION:
		{
			match(QUESTION);
			assignmentExpression();
			match(COLON);
			conditionalExpression();
			break;
		}
		case SEMI:
		case RBRACK:
		case COMMA:
		case RPAREN:
		case ASSIGN:
		case RCURLY:
		case COLON:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void annotationMemberArrayInitializer() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case AT:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			annotationMemberArrayValueInitializer();
			{
			_loop72:
			do {
				if ((LA(1)==COMMA) && (_tokenSet_12.member(LA(2)))) {
					match(COMMA);
					annotationMemberArrayValueInitializer();
				}
				else {
					break _loop72;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				break;
			}
			case RCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(RCURLY);
	}
	
	public final void annotationMemberArrayValueInitializer() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			conditionalExpression();
			break;
		}
		case AT:
		{
			annotation();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final String  superClassClause() throws RecognitionException, TokenStreamException {
		String superClassName = null;
		
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			match(LITERAL_extends);
			superClassName=classOrInterfaceType();
			break;
		}
		case LCURLY:
		case LITERAL_implements:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return superClassName;
	}
	
	public final void typeParameters() throws RecognitionException, TokenStreamException {
		
		int currentLtLevel = 0;
		
		if ( inputState.guessing==0 ) {
			currentLtLevel = ltCounter;
		}
		match(LT);
		if ( inputState.guessing==0 ) {
			ltCounter++;
		}
		typeParameter();
		{
		_loop85:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				typeParameter();
			}
			else {
				break _loop85;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case GT:
		case SR:
		case BSR:
		{
			typeArgumentsOrParametersEnd();
			break;
		}
		case IDENT:
		case LITERAL_extends:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LCURLY:
		case LITERAL_implements:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if (!((currentLtLevel != 0) || ltCounter == currentLtLevel))
		  throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
	}
	
	public final Vector  implementsClause() throws RecognitionException, TokenStreamException {
		Vector names=new Vector();
		
		String n=null;
		
		{
		switch ( LA(1)) {
		case LITERAL_implements:
		{
			match(LITERAL_implements);
			n=classOrInterfaceType();
			if ( inputState.guessing==0 ) {
				names.addElement(n);
			}
			{
			_loop133:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					n=classOrInterfaceType();
					if ( inputState.guessing==0 ) {
						names.addElement(n);
					}
				}
				else {
					break _loop133;
				}
				
			} while (true);
			}
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return names;
	}
	
	public final void classBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		_loop95:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_static:
			case IDENT:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_threadsafe:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case AT:
			case LCURLY:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				classField();
				break;
			}
			case SEMI:
			{
				match(SEMI);
				break;
			}
			default:
			{
				break _loop95;
			}
			}
		} while (true);
		}
		match(RCURLY);
	}
	
	public final Vector  interfaceExtends() throws RecognitionException, TokenStreamException {
		Vector names=new Vector();
		
		String n=null;
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			match(LITERAL_extends);
			n=classOrInterfaceType();
			if ( inputState.guessing==0 ) {
				names.addElement(n);
			}
			{
			_loop129:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					n=classOrInterfaceType();
					if ( inputState.guessing==0 ) {
						names.addElement(n);
					}
				}
				else {
					break _loop129;
				}
				
			} while (true);
			}
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return names;
	}
	
	public final void interfaceBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		_loop98:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_static:
			case IDENT:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_threadsafe:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case AT:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				interfaceField();
				break;
			}
			case SEMI:
			{
				match(SEMI);
				break;
			}
			default:
			{
				break _loop98;
			}
			}
		} while (true);
		}
		match(RCURLY);
	}
	
	public final void enumBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		{
			enumConstant();
			{
			_loop105:
			do {
				if ((LA(1)==COMMA) && (LA(2)==IDENT||LA(2)==AT)) {
					match(COMMA);
					enumConstant();
				}
				else {
					break _loop105;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				break;
			}
			case SEMI:
			case RCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case SEMI:
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case SEMI:
		{
			match(SEMI);
			{
			_loop109:
			do {
				switch ( LA(1)) {
				case FINAL:
				case ABSTRACT:
				case STRICTFP:
				case LITERAL_static:
				case IDENT:
				case LT:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case LITERAL_private:
				case LITERAL_public:
				case LITERAL_protected:
				case LITERAL_transient:
				case LITERAL_native:
				case LITERAL_threadsafe:
				case LITERAL_synchronized:
				case LITERAL_volatile:
				case AT:
				case LCURLY:
				case LITERAL_class:
				case LITERAL_interface:
				case LITERAL_enum:
				{
					classField();
					break;
				}
				case SEMI:
				{
					match(SEMI);
					break;
				}
				default:
				{
					break _loop109;
				}
				}
			} while (true);
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(RCURLY);
	}
	
	public final void annotationBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		_loop101:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_static:
			case IDENT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_threadsafe:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case AT:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				annotationField();
				break;
			}
			case SEMI:
			{
				match(SEMI);
				break;
			}
			default:
			{
				break _loop101;
			}
			}
		} while (true);
		}
		match(RCURLY);
	}
	
	public final void typeParameter() throws RecognitionException, TokenStreamException {
		
		
		{
		match(IDENT);
		}
		{
		if ((LA(1)==LITERAL_extends) && (LA(2)==IDENT)) {
			typeParameterBounds();
		}
		else if ((_tokenSet_13.member(LA(1))) && (_tokenSet_14.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
	}
	
	public final void typeParameterBounds() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_extends);
		classOrInterfaceType();
		{
		_loop92:
		do {
			if ((LA(1)==BAND)) {
				match(BAND);
				classOrInterfaceType();
			}
			else {
				break _loop92;
			}
			
		} while (true);
		}
	}
	
	public final void classField() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		short mods=0; String t=null; Vector param=null; String a=null;
		boolean isOutestCompStat = !isInCompoundStatement();
		
		if ((_tokenSet_15.member(LA(1))) && (_tokenSet_16.member(LA(2)))) {
			mods=modifiers();
			{
			switch ( LA(1)) {
			case AT:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				typeDefinitionInternal(mods);
				break;
			}
			case IDENT:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				{
				switch ( LA(1)) {
				case LT:
				{
					typeParameters();
					break;
				}
				case IDENT:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				if ((LA(1)==IDENT) && (LA(2)==LPAREN)) {
					ctorHead(mods);
					constructorBody();
					if ( inputState.guessing==0 ) {
						if (isOutestCompStat && level > 0) {
						getModeller().addBodyToOperation(getMethod(), level>1?getBody():"");
						setMethod(null);
						setBody(null);
						}
					}
				}
				else if ((_tokenSet_17.member(LA(1))) && (_tokenSet_18.member(LA(2)))) {
					t=typeSpec();
					{
					if ((LA(1)==IDENT) && (LA(2)==LPAREN)) {
						name = LT(1);
						match(IDENT);
						match(LPAREN);
						param=parameterDeclarationList();
						match(RPAREN);
						a=declaratorBrackets();
						if ( inputState.guessing==0 ) {
							t += a;
						}
						{
						switch ( LA(1)) {
						case LITERAL_throws:
						{
							throwsClause();
							break;
						}
						case SEMI:
						case LCURLY:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						{
						switch ( LA(1)) {
						case LCURLY:
						{
							compoundStatement();
							break;
						}
						case SEMI:
						{
							match(SEMI);
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						if ( inputState.guessing==0 ) {
							if (isOutestCompStat && level > 0) {
							setMethod(getModeller().addOperation(mods, t, name.getText(), param, getJavadocComment()));
							getModeller().addBodyToOperation(getMethod(), level>1?getBody():"");
							setMethod(null);
							setBody(null);
							}
						}
					}
					else if ((LA(1)==IDENT) && (_tokenSet_19.member(LA(2)))) {
						variableDefinitions(getJavadocComment(), mods, t);
						match(SEMI);
					}
					else {
						throw new NoViableAltException(LT(1), getFilename());
					}
					
					}
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((LA(1)==LITERAL_static) && (LA(2)==LCURLY)) {
			match(LITERAL_static);
			compoundStatement();
		}
		else if ((LA(1)==LCURLY)) {
			compoundStatement();
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
	}
	
	public final void interfaceField() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		short mods=0; String t=null; Vector param=null; String a=null;
		boolean isOutestCompStat = !isInCompoundStatement();
		
		mods=modifiers();
		{
		switch ( LA(1)) {
		case AT:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_enum:
		{
			typeDefinitionInternal(mods);
			break;
		}
		case IDENT:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			{
			switch ( LA(1)) {
			case LT:
			{
				typeParameters();
				break;
			}
			case IDENT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			t=typeSpec();
			{
			if ((LA(1)==IDENT) && (LA(2)==LPAREN)) {
				name = LT(1);
				match(IDENT);
				match(LPAREN);
				param=parameterDeclarationList();
				match(RPAREN);
				a=declaratorBrackets();
				if ( inputState.guessing==0 ) {
					t += a;
				}
				{
				switch ( LA(1)) {
				case LITERAL_throws:
				{
					throwsClause();
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(SEMI);
				if ( inputState.guessing==0 ) {
					if (isOutestCompStat && level > 0) {
					setMethod(getModeller().addOperation(mods, t, name.getText(), param, getJavadocComment()));
					setMethod(null);
					}
				}
			}
			else if ((LA(1)==IDENT) && (_tokenSet_19.member(LA(2)))) {
				variableDefinitions(getJavadocComment(), mods, t);
				match(SEMI);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void annotationField() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		short mods=0; String t=null; Vector param=null; String a=null;
		boolean isOutestCompStat = !isInCompoundStatement();
		
		mods=modifiers();
		{
		switch ( LA(1)) {
		case AT:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_enum:
		{
			typeDefinitionInternal(mods);
			break;
		}
		case IDENT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			t=typeSpec();
			{
			if ((LA(1)==IDENT) && (LA(2)==LPAREN)) {
				name = LT(1);
				match(IDENT);
				match(LPAREN);
				match(RPAREN);
				a=declaratorBrackets();
				if ( inputState.guessing==0 ) {
					t += a;
				}
				{
				switch ( LA(1)) {
				case LITERAL_default:
				{
					match(LITERAL_default);
					annotationMemberValueInitializer();
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(SEMI);
			}
			else if ((LA(1)==IDENT) && (_tokenSet_19.member(LA(2)))) {
				variableDefinitions(getJavadocComment(), mods, t);
				match(SEMI);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void enumConstant() throws RecognitionException, TokenStreamException {
		
		
		annotations();
		match(IDENT);
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			match(LPAREN);
			argList();
			match(RPAREN);
			break;
		}
		case SEMI:
		case COMMA:
		case LCURLY:
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LCURLY:
		{
			enumConstantBlock();
			break;
		}
		case SEMI:
		case COMMA:
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final String  declaratorBrackets() throws RecognitionException, TokenStreamException {
		String b="";
		
		
		{
		_loop160:
		do {
			if ((LA(1)==LBRACK)) {
				match(LBRACK);
				match(RBRACK);
				if ( inputState.guessing==0 ) {
					b += "[]";
				}
			}
			else {
				break _loop160;
			}
			
		} while (true);
		}
		return b;
	}
	
	public final void argList() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			expressionList();
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void enumConstantBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		_loop119:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_static:
			case IDENT:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_threadsafe:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case AT:
			case LCURLY:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				enumConstantField();
				break;
			}
			case SEMI:
			{
				match(SEMI);
				break;
			}
			default:
			{
				break _loop119;
			}
			}
		} while (true);
		}
		match(RCURLY);
	}
	
	public final void enumConstantField() throws RecognitionException, TokenStreamException {
		
		short mods=0; String t=null; Vector param=null; String a=null;
		boolean isOutestCompStat = !isInCompoundStatement();
		
		switch ( LA(1)) {
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case LITERAL_static:
		case IDENT:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_threadsafe:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case AT:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_enum:
		{
			mods=modifiers();
			{
			switch ( LA(1)) {
			case AT:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_enum:
			{
				typeDefinitionInternal(mods);
				break;
			}
			case IDENT:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				{
				switch ( LA(1)) {
				case LT:
				{
					typeParameters();
					break;
				}
				case IDENT:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				t=typeSpec();
				{
				if ((LA(1)==IDENT) && (LA(2)==LPAREN)) {
					match(IDENT);
					match(LPAREN);
					param=parameterDeclarationList();
					match(RPAREN);
					a=declaratorBrackets();
					if ( inputState.guessing==0 ) {
						t += a;
					}
					{
					switch ( LA(1)) {
					case LITERAL_throws:
					{
						throwsClause();
						break;
					}
					case SEMI:
					case LCURLY:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					{
					switch ( LA(1)) {
					case LCURLY:
					{
						compoundStatement();
						break;
					}
					case SEMI:
					{
						match(SEMI);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
				}
				else if ((LA(1)==IDENT) && (_tokenSet_19.member(LA(2)))) {
					variableDefinitions(getJavadocComment(), mods, t);
					match(SEMI);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case LCURLY:
		{
			compoundStatement();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final Vector  parameterDeclarationList() throws RecognitionException, TokenStreamException {
		Vector paramList=new Vector();
		
		Vector currentParameter=null;
		
		{
		boolean synPredMatched177 = false;
		if (((_tokenSet_20.member(LA(1))) && (_tokenSet_21.member(LA(2))))) {
			int _m177 = mark();
			synPredMatched177 = true;
			inputState.guessing++;
			try {
				{
				parameterDeclaration();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched177 = false;
			}
			rewind(_m177);
			inputState.guessing--;
		}
		if ( synPredMatched177 ) {
			currentParameter=parameterDeclaration();
			if ( inputState.guessing==0 ) {
				paramList.add(currentParameter);
			}
			{
			_loop181:
			do {
				boolean synPredMatched180 = false;
				if (((LA(1)==COMMA) && (_tokenSet_20.member(LA(2))))) {
					int _m180 = mark();
					synPredMatched180 = true;
					inputState.guessing++;
					try {
						{
						match(COMMA);
						parameterDeclaration();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched180 = false;
					}
					rewind(_m180);
					inputState.guessing--;
				}
				if ( synPredMatched180 ) {
					match(COMMA);
					currentParameter=parameterDeclaration();
					if ( inputState.guessing==0 ) {
						paramList.add(currentParameter);
					}
				}
				else {
					break _loop181;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				variableLengthParameterDeclaration();
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((_tokenSet_20.member(LA(1))) && (_tokenSet_22.member(LA(2)))) {
			variableLengthParameterDeclaration();
		}
		else if ((LA(1)==RPAREN)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		return paramList;
	}
	
	public final void throwsClause() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_throws);
		identifier();
		{
		_loop173:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				identifier();
			}
			else {
				break _loop173;
			}
			
		} while (true);
		}
	}
	
	public final void compoundStatement() throws RecognitionException, TokenStreamException {
		
		boolean isOutestCompStat = !isInCompoundStatement();
		
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			if (isOutestCompStat) {
			setIsInCompoundStatement(true);
			activateExpressionTracking();}
		}
		{
		_loop193:
		do {
			if ((_tokenSet_23.member(LA(1)))) {
				statement();
			}
			else {
				break _loop193;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			if (isOutestCompStat) {
			setBody(getExpression());
			deactivateExpressionTracking();
			setIsInCompoundStatement(false);}
		}
		match(RCURLY);
	}
	
	public final void ctorHead(
		 short mods
	) throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		Vector param = null;
		boolean isOutestCompStat = !isInCompoundStatement();
		
		name = LT(1);
		match(IDENT);
		match(LPAREN);
		param=parameterDeclarationList();
		match(RPAREN);
		if ( inputState.guessing==0 ) {
			if (isOutestCompStat && level > 0) {
			setMethod(getModeller().addOperation(mods, null, 
			name.getText(), param, getJavadocComment()));
			}
		}
		{
		switch ( LA(1)) {
		case LITERAL_throws:
		{
			throwsClause();
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void constructorBody() throws RecognitionException, TokenStreamException {
		
		boolean isOutestCompStat = !isInCompoundStatement();
		
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			if (isOutestCompStat) {
			setIsInCompoundStatement(true);
			activateExpressionTracking();}
		}
		{
		if ((_tokenSet_24.member(LA(1))) && (_tokenSet_25.member(LA(2)))) {
			explicitConstructorInvocation();
		}
		else if ((_tokenSet_26.member(LA(1))) && (_tokenSet_27.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop149:
		do {
			if ((_tokenSet_23.member(LA(1)))) {
				statement();
			}
			else {
				break _loop149;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			if (isOutestCompStat) {
			setBody(getExpression());
			deactivateExpressionTracking();
			setIsInCompoundStatement(false);}
		}
		match(RCURLY);
	}
	
/** Catch obvious constructor calls, but not the expr.super(...) calls */
	public final void explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case LT:
		{
			typeArguments();
			break;
		}
		case LITERAL_super:
		case LITERAL_this:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_this:
		{
			match(LITERAL_this);
			match(LPAREN);
			argList();
			match(RPAREN);
			match(SEMI);
			break;
		}
		case LITERAL_super:
		{
			match(LITERAL_super);
			match(LPAREN);
			argList();
			match(RPAREN);
			match(SEMI);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void statement() throws RecognitionException, TokenStreamException {
		
		short m;
		
		switch ( LA(1)) {
		case LCURLY:
		{
			compoundStatement();
			break;
		}
		case LITERAL_if:
		{
			match(LITERAL_if);
			match(LPAREN);
			expression();
			match(RPAREN);
			statement();
			{
			if ((LA(1)==LITERAL_else) && (_tokenSet_23.member(LA(2)))) {
				match(LITERAL_else);
				statement();
			}
			else if ((_tokenSet_28.member(LA(1))) && (_tokenSet_29.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case LITERAL_for:
		{
			forStatement();
			break;
		}
		case LITERAL_while:
		{
			match(LITERAL_while);
			match(LPAREN);
			expression();
			match(RPAREN);
			statement();
			break;
		}
		case LITERAL_do:
		{
			match(LITERAL_do);
			statement();
			match(LITERAL_while);
			match(LPAREN);
			expression();
			match(RPAREN);
			match(SEMI);
			break;
		}
		case LITERAL_break:
		{
			match(LITERAL_break);
			{
			switch ( LA(1)) {
			case IDENT:
			{
				match(IDENT);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			break;
		}
		case LITERAL_continue:
		{
			match(LITERAL_continue);
			{
			switch ( LA(1)) {
			case IDENT:
			{
				match(IDENT);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			break;
		}
		case LITERAL_return:
		{
			match(LITERAL_return);
			{
			switch ( LA(1)) {
			case IDENT:
			case LITERAL_super:
			case LT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case LPAREN:
			case LITERAL_this:
			case PLUS:
			case MINUS:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				expression();
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			break;
		}
		case LITERAL_switch:
		{
			match(LITERAL_switch);
			match(LPAREN);
			expression();
			match(RPAREN);
			match(LCURLY);
			{
			_loop202:
			do {
				if ((LA(1)==LITERAL_default||LA(1)==LITERAL_case)) {
					casesGroup();
				}
				else {
					break _loop202;
				}
				
			} while (true);
			}
			match(RCURLY);
			break;
		}
		case LITERAL_try:
		{
			tryBlock();
			break;
		}
		case LITERAL_throw:
		{
			match(LITERAL_throw);
			expression();
			match(SEMI);
			break;
		}
		case LITERAL_assert:
		{
			match(LITERAL_assert);
			expression();
			{
			switch ( LA(1)) {
			case COLON:
			{
				match(COLON);
				expression();
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			break;
		}
		case SEMI:
		{
			match(SEMI);
			break;
		}
		default:
			boolean synPredMatched196 = false;
			if (((_tokenSet_30.member(LA(1))) && (_tokenSet_31.member(LA(2))))) {
				int _m196 = mark();
				synPredMatched196 = true;
				inputState.guessing++;
				try {
					{
					declaration();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched196 = false;
				}
				rewind(_m196);
				inputState.guessing--;
			}
			if ( synPredMatched196 ) {
				declaration();
				match(SEMI);
			}
			else if ((_tokenSet_32.member(LA(1))) && (_tokenSet_33.member(LA(2)))) {
				expression();
				match(SEMI);
			}
			else if ((_tokenSet_34.member(LA(1))) && (_tokenSet_35.member(LA(2)))) {
				m=modifiers();
				classDefinition("", m);
			}
			else if ((LA(1)==IDENT) && (LA(2)==COLON)) {
				match(IDENT);
				match(COLON);
				statement();
			}
			else if ((LA(1)==LITERAL_synchronized) && (LA(2)==LPAREN)) {
				match(LITERAL_synchronized);
				match(LPAREN);
				expression();
				match(RPAREN);
				compoundStatement();
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
/** Declaration of a variable. This can be a class/instance variable,
 *  or a local variable in a method
 *  It can also include possible initialization.
 */
	public final void variableDeclarator(
		String javadoc, short modifiers, String varType
	) throws RecognitionException, TokenStreamException {
		
		Token  id = null;
		String initializer=null; String b=null;
		
		{
		id = LT(1);
		match(IDENT);
		b=declaratorBrackets();
		initializer=varInitializer();
		}
		if ( inputState.guessing==0 ) {
			
			if (!isInCompoundStatement() && level > 0) {
			getModeller().addAttribute(modifiers, varType+b, id.getText(), initializer, javadoc);
			}
			if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
			getModeller().addLocalVariableDeclaration(varType+b, id.getText());
			}
			
		}
	}
	
	public final String  varInitializer() throws RecognitionException, TokenStreamException {
		String expression=null;
		
		String trackedSoFar = null;
		
		{
		switch ( LA(1)) {
		case ASSIGN:
		{
			if ( inputState.guessing==0 ) {
				if ((parserMode & MODE_REVENG_SEQUENCE) != 0
				&& "new".equals(LT(2).getText())) {
				createdObjectVarName = LT(0).getText();
				}
				
			}
			match(ASSIGN);
			if ( inputState.guessing==0 ) {
				trackedSoFar=getExpression();
				if (!isInCompoundStatement())
				activateExpressionTracking();
				
			}
			initializer();
			if ( inputState.guessing==0 ) {
				expression=getExpression();
				if (isInCompoundStatement()) {
				activateExpressionTracking();
				appendExpression(trackedSoFar);
				appendExpression(expression);
				} else {
				deactivateExpressionTracking();
				}
				createdObjectVarName = null;
				
			}
			break;
		}
		case SEMI:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return expression;
	}
	
	public final void initializer() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			expression();
			break;
		}
		case LCURLY:
		{
			arrayInitializer();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void arrayInitializer() throws RecognitionException, TokenStreamException {
		
		
		match(LCURLY);
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LCURLY:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			initializer();
			{
			_loop166:
			do {
				if ((LA(1)==COMMA) && (_tokenSet_36.member(LA(2)))) {
					match(COMMA);
					initializer();
				}
				else {
					break _loop166;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				break;
			}
			case RCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(RCURLY);
	}
	
	public final void expression() throws RecognitionException, TokenStreamException {
		
		
		assignmentExpression();
	}
	
	public final Vector  parameterDeclaration() throws RecognitionException, TokenStreamException {
		Vector pd=new Vector();
		
		Token  id = null;
		short pm=0; String ts=null; String pdb=null;
		
		pm=parameterModifier();
		ts=typeSpec();
		id = LT(1);
		match(IDENT);
		pdb=declaratorBrackets();
		if ( inputState.guessing==0 ) {
			pd.add(new Short(pm));
			pd.add(ts + pdb);
			pd.add(id.getText());
		}
		return pd;
	}
	
	public final void variableLengthParameterDeclaration() throws RecognitionException, TokenStreamException {
		
		
		parameterModifier();
		typeSpec();
		match(TRIPLE_DOT);
		match(IDENT);
		declaratorBrackets();
	}
	
	public final short  parameterModifier() throws RecognitionException, TokenStreamException {
		short mods=0;;
		
		
		{
		_loop187:
		do {
			if ((LA(1)==AT) && (LA(2)==IDENT)) {
				annotation();
			}
			else {
				break _loop187;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case FINAL:
		{
			match(FINAL);
			if ( inputState.guessing==0 ) {
				mods |= ACC_FINAL;
			}
			break;
		}
		case IDENT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case AT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop190:
		do {
			if ((LA(1)==AT)) {
				annotation();
			}
			else {
				break _loop190;
			}
			
		} while (true);
		}
		return mods;
	}
	
	public final void forStatement() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_for);
		match(LPAREN);
		{
		boolean synPredMatched207 = false;
		if (((_tokenSet_37.member(LA(1))) && (_tokenSet_38.member(LA(2))))) {
			int _m207 = mark();
			synPredMatched207 = true;
			inputState.guessing++;
			try {
				{
				forInit();
				match(SEMI);
				}
			}
			catch (RecognitionException pe) {
				synPredMatched207 = false;
			}
			rewind(_m207);
			inputState.guessing--;
		}
		if ( synPredMatched207 ) {
			traditionalForClause();
		}
		else if ((_tokenSet_20.member(LA(1))) && (_tokenSet_21.member(LA(2)))) {
			forEachClause();
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		match(RPAREN);
		statement();
	}
	
	public final void casesGroup() throws RecognitionException, TokenStreamException {
		
		
		{
		int _cnt212=0;
		_loop212:
		do {
			if ((LA(1)==LITERAL_default||LA(1)==LITERAL_case) && (_tokenSet_39.member(LA(2)))) {
				aCase();
			}
			else {
				if ( _cnt212>=1 ) { break _loop212; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt212++;
		} while (true);
		}
		caseSList();
	}
	
	public final void tryBlock() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_try);
		compoundStatement();
		{
		_loop228:
		do {
			if ((LA(1)==LITERAL_catch)) {
				handler();
			}
			else {
				break _loop228;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case LITERAL_finally:
		{
			finallyClause();
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case LITERAL_static:
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_threadsafe:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case AT:
		case LPAREN:
		case LCURLY:
		case RCURLY:
		case LITERAL_class:
		case LITERAL_default:
		case LITERAL_this:
		case LITERAL_if:
		case LITERAL_else:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_assert:
		case LITERAL_for:
		case LITERAL_case:
		case LITERAL_try:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void forInit() throws RecognitionException, TokenStreamException {
		
		
		{
		boolean synPredMatched221 = false;
		if (((_tokenSet_30.member(LA(1))) && (_tokenSet_31.member(LA(2))))) {
			int _m221 = mark();
			synPredMatched221 = true;
			inputState.guessing++;
			try {
				{
				declaration();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched221 = false;
			}
			rewind(_m221);
			inputState.guessing--;
		}
		if ( synPredMatched221 ) {
			declaration();
		}
		else if ((_tokenSet_32.member(LA(1))) && (_tokenSet_40.member(LA(2)))) {
			expressionList();
		}
		else if ((LA(1)==SEMI)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
	}
	
	public final void traditionalForClause() throws RecognitionException, TokenStreamException {
		
		
		forInit();
		match(SEMI);
		forCond();
		match(SEMI);
		forIter();
	}
	
	public final void forEachClause() throws RecognitionException, TokenStreamException {
		
		
		parameterDeclaration();
		match(COLON);
		expression();
	}
	
	public final void forCond() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			expression();
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void forIter() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			expressionList();
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void aCase() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case LITERAL_case:
		{
			match(LITERAL_case);
			expression();
			break;
		}
		case LITERAL_default:
		{
			match(LITERAL_default);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(COLON);
	}
	
	public final void caseSList() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop217:
		do {
			if ((_tokenSet_23.member(LA(1)))) {
				statement();
			}
			else {
				break _loop217;
			}
			
		} while (true);
		}
	}
	
	public final void expressionList() throws RecognitionException, TokenStreamException {
		
		
		expression();
		{
		_loop235:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				expression();
			}
			else {
				break _loop235;
			}
			
		} while (true);
		}
	}
	
	public final void handler() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_catch);
		match(LPAREN);
		parameterDeclaration();
		match(RPAREN);
		compoundStatement();
	}
	
	public final void finallyClause() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_finally);
		compoundStatement();
	}
	
	public final void assignmentExpression() throws RecognitionException, TokenStreamException {
		
		
		conditionalExpression();
		{
		switch ( LA(1)) {
		case ASSIGN:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		{
			{
			switch ( LA(1)) {
			case ASSIGN:
			{
				if ( inputState.guessing==0 ) {
					if ((parserMode & MODE_REVENG_SEQUENCE) != 0
					&& "new".equals(LT(2).getText())) {
					createdObjectVarName = LT(0).getText();
					}
					
				}
				match(ASSIGN);
				break;
			}
			case PLUS_ASSIGN:
			{
				match(PLUS_ASSIGN);
				break;
			}
			case MINUS_ASSIGN:
			{
				match(MINUS_ASSIGN);
				break;
			}
			case STAR_ASSIGN:
			{
				match(STAR_ASSIGN);
				break;
			}
			case DIV_ASSIGN:
			{
				match(DIV_ASSIGN);
				break;
			}
			case MOD_ASSIGN:
			{
				match(MOD_ASSIGN);
				break;
			}
			case SR_ASSIGN:
			{
				match(SR_ASSIGN);
				break;
			}
			case BSR_ASSIGN:
			{
				match(BSR_ASSIGN);
				break;
			}
			case SL_ASSIGN:
			{
				match(SL_ASSIGN);
				break;
			}
			case BAND_ASSIGN:
			{
				match(BAND_ASSIGN);
				break;
			}
			case BXOR_ASSIGN:
			{
				match(BXOR_ASSIGN);
				break;
			}
			case BOR_ASSIGN:
			{
				match(BOR_ASSIGN);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			assignmentExpression();
			if ( inputState.guessing==0 ) {
				createdObjectVarName = null;
			}
			break;
		}
		case SEMI:
		case RBRACK:
		case COMMA:
		case RPAREN:
		case RCURLY:
		case COLON:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void logicalOrExpression() throws RecognitionException, TokenStreamException {
		
		
		logicalAndExpression();
		{
		_loop243:
		do {
			if ((LA(1)==LOR)) {
				match(LOR);
				logicalAndExpression();
			}
			else {
				break _loop243;
			}
			
		} while (true);
		}
	}
	
	public final void logicalAndExpression() throws RecognitionException, TokenStreamException {
		
		
		inclusiveOrExpression();
		{
		_loop246:
		do {
			if ((LA(1)==LAND)) {
				match(LAND);
				inclusiveOrExpression();
			}
			else {
				break _loop246;
			}
			
		} while (true);
		}
	}
	
	public final void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		
		exclusiveOrExpression();
		{
		_loop249:
		do {
			if ((LA(1)==BOR)) {
				match(BOR);
				exclusiveOrExpression();
			}
			else {
				break _loop249;
			}
			
		} while (true);
		}
	}
	
	public final void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		
		andExpression();
		{
		_loop252:
		do {
			if ((LA(1)==BXOR)) {
				match(BXOR);
				andExpression();
			}
			else {
				break _loop252;
			}
			
		} while (true);
		}
	}
	
	public final void andExpression() throws RecognitionException, TokenStreamException {
		
		
		equalityExpression();
		{
		_loop255:
		do {
			if ((LA(1)==BAND)) {
				match(BAND);
				equalityExpression();
			}
			else {
				break _loop255;
			}
			
		} while (true);
		}
	}
	
	public final void equalityExpression() throws RecognitionException, TokenStreamException {
		
		
		relationalExpression();
		{
		_loop259:
		do {
			if ((LA(1)==NOT_EQUAL||LA(1)==EQUAL)) {
				{
				switch ( LA(1)) {
				case NOT_EQUAL:
				{
					match(NOT_EQUAL);
					break;
				}
				case EQUAL:
				{
					match(EQUAL);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				relationalExpression();
			}
			else {
				break _loop259;
			}
			
		} while (true);
		}
	}
	
	public final void relationalExpression() throws RecognitionException, TokenStreamException {
		
		
		shiftExpression();
		{
		switch ( LA(1)) {
		case SEMI:
		case RBRACK:
		case QUESTION:
		case LT:
		case COMMA:
		case GT:
		case RPAREN:
		case ASSIGN:
		case RCURLY:
		case BAND:
		case COLON:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		case LOR:
		case LAND:
		case BOR:
		case BXOR:
		case NOT_EQUAL:
		case EQUAL:
		case LE:
		case GE:
		{
			{
			_loop264:
			do {
				if ((_tokenSet_41.member(LA(1)))) {
					{
					switch ( LA(1)) {
					case LT:
					{
						match(LT);
						break;
					}
					case GT:
					{
						match(GT);
						break;
					}
					case LE:
					{
						match(LE);
						break;
					}
					case GE:
					{
						match(GE);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					shiftExpression();
				}
				else {
					break _loop264;
				}
				
			} while (true);
			}
			break;
		}
		case LITERAL_instanceof:
		{
			match(LITERAL_instanceof);
			typeSpec();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void shiftExpression() throws RecognitionException, TokenStreamException {
		
		
		additiveExpression();
		{
		_loop268:
		do {
			if ((_tokenSet_42.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case SL:
				{
					match(SL);
					break;
				}
				case SR:
				{
					match(SR);
					break;
				}
				case BSR:
				{
					match(BSR);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				additiveExpression();
			}
			else {
				break _loop268;
			}
			
		} while (true);
		}
	}
	
	public final void additiveExpression() throws RecognitionException, TokenStreamException {
		
		
		multiplicativeExpression();
		{
		_loop272:
		do {
			if ((LA(1)==PLUS||LA(1)==MINUS)) {
				{
				switch ( LA(1)) {
				case PLUS:
				{
					match(PLUS);
					break;
				}
				case MINUS:
				{
					match(MINUS);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				multiplicativeExpression();
			}
			else {
				break _loop272;
			}
			
		} while (true);
		}
	}
	
	public final void multiplicativeExpression() throws RecognitionException, TokenStreamException {
		
		
		unaryExpression();
		{
		_loop276:
		do {
			if ((_tokenSet_43.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case STAR:
				{
					match(STAR);
					break;
				}
				case DIV:
				{
					match(DIV);
					break;
				}
				case MOD:
				{
					match(MOD);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				unaryExpression();
			}
			else {
				break _loop276;
			}
			
		} while (true);
		}
	}
	
	public final void unaryExpression() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case INC:
		{
			match(INC);
			unaryExpression();
			break;
		}
		case DEC:
		{
			match(DEC);
			unaryExpression();
			break;
		}
		case MINUS:
		{
			match(MINUS);
			unaryExpression();
			break;
		}
		case PLUS:
		{
			match(PLUS);
			unaryExpression();
			break;
		}
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			unaryExpressionNotPlusMinus();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case BNOT:
		{
			match(BNOT);
			unaryExpression();
			break;
		}
		case LNOT:
		{
			match(LNOT);
			unaryExpression();
			break;
		}
		case IDENT:
		case LITERAL_super:
		case LT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			{
			boolean synPredMatched281 = false;
			if (((LA(1)==LPAREN) && ((LA(2) >= LITERAL_void && LA(2) <= LITERAL_double)))) {
				int _m281 = mark();
				synPredMatched281 = true;
				inputState.guessing++;
				try {
					{
					match(LPAREN);
					builtInTypeSpec();
					match(RPAREN);
					unaryExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched281 = false;
				}
				rewind(_m281);
				inputState.guessing--;
			}
			if ( synPredMatched281 ) {
				match(LPAREN);
				builtInTypeSpec();
				match(RPAREN);
				unaryExpression();
			}
			else {
				boolean synPredMatched283 = false;
				if (((LA(1)==LPAREN) && (LA(2)==IDENT))) {
					int _m283 = mark();
					synPredMatched283 = true;
					inputState.guessing++;
					try {
						{
						match(LPAREN);
						classTypeSpec();
						match(RPAREN);
						unaryExpressionNotPlusMinus();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched283 = false;
					}
					rewind(_m283);
					inputState.guessing--;
				}
				if ( synPredMatched283 ) {
					match(LPAREN);
					classTypeSpec();
					match(RPAREN);
					unaryExpressionNotPlusMinus();
				}
				else if ((_tokenSet_44.member(LA(1))) && (_tokenSet_45.member(LA(2)))) {
					postfixExpression();
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		
	public final void postfixExpression() throws RecognitionException, TokenStreamException {
		
		Token  id = null;
		String thisOrSuper = null;
		boolean parenths = LA(1) == LPAREN;
		
		primaryExpression();
		{
		_loop292:
		do {
			if ((LA(1)==DOT) && (_tokenSet_46.member(LA(2)))) {
				if ( inputState.guessing==0 ) {
					if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
					if ("this".equals(LT(0).getText())) {
					thisOrSuper = "this.";
					} else if ("super".equals(LT(0).getText())) {
					thisOrSuper = "super.";
					}
					}
					
				}
				match(DOT);
				{
				switch ( LA(1)) {
				case LT:
				{
					typeArguments();
					break;
				}
				case IDENT:
				case LITERAL_super:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				switch ( LA(1)) {
				case IDENT:
				{
					id = LT(1);
					match(IDENT);
					{
					switch ( LA(1)) {
					case LPAREN:
					{
						match(LPAREN);
						argList();
						match(RPAREN);
						if ( inputState.guessing==0 ) {
							if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
							addDotCall(id.getText(), thisOrSuper, parenths);
							}
							
						}
						break;
					}
					case SEMI:
					case LBRACK:
					case RBRACK:
					case DOT:
					case QUESTION:
					case LT:
					case COMMA:
					case GT:
					case SR:
					case BSR:
					case STAR:
					case RPAREN:
					case ASSIGN:
					case RCURLY:
					case BAND:
					case COLON:
					case PLUS_ASSIGN:
					case MINUS_ASSIGN:
					case STAR_ASSIGN:
					case DIV_ASSIGN:
					case MOD_ASSIGN:
					case SR_ASSIGN:
					case BSR_ASSIGN:
					case SL_ASSIGN:
					case BAND_ASSIGN:
					case BXOR_ASSIGN:
					case BOR_ASSIGN:
					case LOR:
					case LAND:
					case BOR:
					case BXOR:
					case NOT_EQUAL:
					case EQUAL:
					case LE:
					case GE:
					case LITERAL_instanceof:
					case SL:
					case PLUS:
					case MINUS:
					case DIV:
					case MOD:
					case INC:
					case DEC:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					break;
				}
				case LITERAL_super:
				{
					match(LITERAL_super);
					{
					switch ( LA(1)) {
					case LPAREN:
					{
						match(LPAREN);
						argList();
						match(RPAREN);
						break;
					}
					case DOT:
					{
						match(DOT);
						{
						switch ( LA(1)) {
						case LT:
						{
							typeArguments();
							break;
						}
						case IDENT:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						match(IDENT);
						{
						switch ( LA(1)) {
						case LPAREN:
						{
							match(LPAREN);
							argList();
							match(RPAREN);
							if ( inputState.guessing==0 ) {
								if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
								addDotCall(id.getText(), thisOrSuper, parenths);
								}
								
							}
							break;
						}
						case SEMI:
						case LBRACK:
						case RBRACK:
						case DOT:
						case QUESTION:
						case LT:
						case COMMA:
						case GT:
						case SR:
						case BSR:
						case STAR:
						case RPAREN:
						case ASSIGN:
						case RCURLY:
						case BAND:
						case COLON:
						case PLUS_ASSIGN:
						case MINUS_ASSIGN:
						case STAR_ASSIGN:
						case DIV_ASSIGN:
						case MOD_ASSIGN:
						case SR_ASSIGN:
						case BSR_ASSIGN:
						case SL_ASSIGN:
						case BAND_ASSIGN:
						case BXOR_ASSIGN:
						case BOR_ASSIGN:
						case LOR:
						case LAND:
						case BOR:
						case BXOR:
						case NOT_EQUAL:
						case EQUAL:
						case LE:
						case GE:
						case LITERAL_instanceof:
						case SL:
						case PLUS:
						case MINUS:
						case DIV:
						case MOD:
						case INC:
						case DEC:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			else if ((LA(1)==DOT) && (LA(2)==LITERAL_this)) {
				match(DOT);
				match(LITERAL_this);
			}
			else if ((LA(1)==DOT) && (LA(2)==LITERAL_new)) {
				match(DOT);
				newExpression();
			}
			else if ((LA(1)==LBRACK)) {
				match(LBRACK);
				expression();
				match(RBRACK);
			}
			else {
				break _loop292;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case INC:
		{
			match(INC);
			break;
		}
		case DEC:
		{
			match(DEC);
			break;
		}
		case SEMI:
		case RBRACK:
		case QUESTION:
		case LT:
		case COMMA:
		case GT:
		case SR:
		case BSR:
		case STAR:
		case RPAREN:
		case ASSIGN:
		case RCURLY:
		case BAND:
		case COLON:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		case LOR:
		case LAND:
		case BOR:
		case BXOR:
		case NOT_EQUAL:
		case EQUAL:
		case LE:
		case GE:
		case LITERAL_instanceof:
		case SL:
		case PLUS:
		case MINUS:
		case DIV:
		case MOD:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void primaryExpression() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case IDENT:
		case LT:
		{
			identPrimary();
			{
			if ((LA(1)==DOT) && (LA(2)==LITERAL_class)) {
				match(DOT);
				match(LITERAL_class);
			}
			else if ((_tokenSet_47.member(LA(1))) && (_tokenSet_48.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		{
			constant();
			break;
		}
		case LITERAL_true:
		{
			match(LITERAL_true);
			break;
		}
		case LITERAL_false:
		{
			match(LITERAL_false);
			break;
		}
		case LITERAL_null:
		{
			match(LITERAL_null);
			break;
		}
		case LITERAL_new:
		{
			newExpression();
			break;
		}
		case LITERAL_this:
		{
			match(LITERAL_this);
			break;
		}
		case LITERAL_super:
		{
			match(LITERAL_super);
			break;
		}
		case LPAREN:
		{
			match(LPAREN);
			assignmentExpression();
			match(RPAREN);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInType();
			{
			_loop297:
			do {
				if ((LA(1)==LBRACK)) {
					match(LBRACK);
					match(RBRACK);
				}
				else {
					break _loop297;
				}
				
			} while (true);
			}
			match(DOT);
			match(LITERAL_class);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
/** object instantiation.
 *  Trees are built as illustrated by the following input/tree pairs:
 *
 *  new T()
 *
 *  new
 *   |
 *   T --  ELIST
 *           |
 *          arg1 -- arg2 -- .. -- argn
 *
 *  new int[]
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *
 *  new int[] {1,2}
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR -- ARRAY_INIT
 *                                  |
 *                                EXPR -- EXPR
 *                                  |      |
 *                                  1      2
 *
 *  new int[3]
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *                |
 *              EXPR
 *                |
 *                3
 *
 *  new int[1][2]
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *               |
 *         ARRAY_DECLARATOR -- EXPR
 *               |              |
 *             EXPR             1
 *               |
 *               2
 *
 */
	public final void newExpression() throws RecognitionException, TokenStreamException {
		
		String t = null;
		
		match(LITERAL_new);
		{
		switch ( LA(1)) {
		case LT:
		{
			typeArguments();
			break;
		}
		case IDENT:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		t=type();
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			match(LPAREN);
			argList();
			match(RPAREN);
			if ( inputState.guessing==0 ) {
				if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
				StringBuffer sb = new StringBuffer();
				if (";".equals(LT(1).getText()) && createdObjectVarName != null) {
				sb.append(createdObjectVarName).append('=');
				}
				sb.append("new ").append(t);
				getModeller().addCall(sb.toString());
				}
				
			}
			{
			switch ( LA(1)) {
			case LCURLY:
			{
				if ( inputState.guessing==0 ) {
					getModeller().addAnonymousClass(t);
				}
				classBlock();
				if ( inputState.guessing==0 ) {
					getModeller().popClassifier();
				}
				break;
			}
			case SEMI:
			case LBRACK:
			case RBRACK:
			case DOT:
			case QUESTION:
			case LT:
			case COMMA:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case RPAREN:
			case ASSIGN:
			case RCURLY:
			case BAND:
			case COLON:
			case PLUS_ASSIGN:
			case MINUS_ASSIGN:
			case STAR_ASSIGN:
			case DIV_ASSIGN:
			case MOD_ASSIGN:
			case SR_ASSIGN:
			case BSR_ASSIGN:
			case SL_ASSIGN:
			case BAND_ASSIGN:
			case BXOR_ASSIGN:
			case BOR_ASSIGN:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case LBRACK:
		{
			newArrayDeclarator();
			{
			switch ( LA(1)) {
			case LCURLY:
			{
				arrayInitializer();
				break;
			}
			case SEMI:
			case LBRACK:
			case RBRACK:
			case DOT:
			case QUESTION:
			case LT:
			case COMMA:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case RPAREN:
			case ASSIGN:
			case RCURLY:
			case BAND:
			case COLON:
			case PLUS_ASSIGN:
			case MINUS_ASSIGN:
			case STAR_ASSIGN:
			case DIV_ASSIGN:
			case MOD_ASSIGN:
			case SR_ASSIGN:
			case BSR_ASSIGN:
			case SL_ASSIGN:
			case BAND_ASSIGN:
			case BXOR_ASSIGN:
			case BOR_ASSIGN:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
/** Match a, a.b.c refs, a.b.c(...) refs, a.b.c[], a.b.c[].class,
 *  and a.b.c.class refs. Also this(...) and super(...). Match
 *  this or super.
 */
	public final void identPrimary() throws RecognitionException, TokenStreamException {
		
		Token  id = null;
		Token  id2 = null;
		StringBuffer sb = null;
		
		{
		switch ( LA(1)) {
		case LT:
		{
			typeArguments();
			break;
		}
		case IDENT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		id = LT(1);
		match(IDENT);
		if ( inputState.guessing==0 ) {
			if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
			sb = new StringBuffer(id.getText());
			}
			
		}
		{
		_loop305:
		do {
			boolean synPredMatched303 = false;
			if (((LA(1)==DOT) && (LA(2)==IDENT||LA(2)==LT))) {
				int _m303 = mark();
				synPredMatched303 = true;
				inputState.guessing++;
				try {
					{
					match(DOT);
					{
					switch ( LA(1)) {
					case LT:
					{
						typeArguments();
						break;
					}
					case IDENT:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					match(IDENT);
					}
				}
				catch (RecognitionException pe) {
					synPredMatched303 = false;
				}
				rewind(_m303);
				inputState.guessing--;
			}
			if ( synPredMatched303 ) {
				match(DOT);
				{
				switch ( LA(1)) {
				case LT:
				{
					typeArguments();
					break;
				}
				case IDENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				id2 = LT(1);
				match(IDENT);
				if ( inputState.guessing==0 ) {
					if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
					sb.append('.').append(id2.getText());
					}
					
				}
			}
			else if (((_tokenSet_49.member(LA(1))) && (_tokenSet_48.member(LA(2))))&&(false)) {
			}
			else {
				break _loop305;
			}
			
		} while (true);
		}
		{
		if ((LA(1)==LPAREN)) {
			{
			match(LPAREN);
			argList();
			match(RPAREN);
			if ( inputState.guessing==0 ) {
				if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
				getModeller().addCall(sb.toString());
				}
				
			}
			}
		}
		else if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
			{
			int _cnt309=0;
			_loop309:
			do {
				if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
					match(LBRACK);
					match(RBRACK);
				}
				else {
					if ( _cnt309>=1 ) { break _loop309; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt309++;
			} while (true);
			}
		}
		else if ((_tokenSet_47.member(LA(1))) && (_tokenSet_48.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
	}
	
	public final void constant() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case NUM_INT:
		{
			match(NUM_INT);
			break;
		}
		case CHAR_LITERAL:
		{
			match(CHAR_LITERAL);
			break;
		}
		case STRING_LITERAL:
		{
			match(STRING_LITERAL);
			break;
		}
		case NUM_FLOAT:
		{
			match(NUM_FLOAT);
			break;
		}
		case NUM_LONG:
		{
			match(NUM_LONG);
			break;
		}
		case NUM_DOUBLE:
		{
			match(NUM_DOUBLE);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void newArrayDeclarator() throws RecognitionException, TokenStreamException {
		
		
		{
		int _cnt320=0;
		_loop320:
		do {
			if ((LA(1)==LBRACK) && (_tokenSet_50.member(LA(2)))) {
				match(LBRACK);
				{
				switch ( LA(1)) {
				case IDENT:
				case LITERAL_super:
				case LT:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case LPAREN:
				case LITERAL_this:
				case PLUS:
				case MINUS:
				case INC:
				case DEC:
				case BNOT:
				case LNOT:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				{
					expression();
					break;
				}
				case RBRACK:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(RBRACK);
			}
			else {
				if ( _cnt320>=1 ) { break _loop320; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt320++;
		} while (true);
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"BLOCK",
		"MODIFIERS",
		"OBJBLOCK",
		"SLIST",
		"CTOR_DEF",
		"METHOD_DEF",
		"VARIABLE_DEF",
		"INSTANCE_INIT",
		"STATIC_INIT",
		"TYPE",
		"CLASS_DEF",
		"INTERFACE_DEF",
		"PACKAGE_DEF",
		"ARRAY_DECLARATOR",
		"EXTENDS_CLAUSE",
		"IMPLEMENTS_CLAUSE",
		"PARAMETERS",
		"PARAMETER_DEF",
		"LABELED_STAT",
		"TYPECAST",
		"INDEX_OP",
		"POST_INC",
		"POST_DEC",
		"METHOD_CALL",
		"EXPR",
		"ARRAY_INIT",
		"IMPORT",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"CASE_GROUP",
		"ELIST",
		"FOR_INIT",
		"FOR_CONDITION",
		"FOR_ITERATOR",
		"EMPTY_STAT",
		"\"final\"",
		"\"abstract\"",
		"\"strictfp\"",
		"SUPER_CTOR_CALL",
		"CTOR_CALL",
		"VARIABLE_PARAMETER_DEF",
		"STATIC_IMPORT",
		"ENUM_DEF",
		"ENUM_CONSTANT_DEF",
		"FOR_EACH_CLAUSE",
		"ANNOTATION_DEF",
		"ANNOTATIONS",
		"ANNOTATION",
		"ANNOTATION_MEMBER_VALUE_PAIR",
		"ANNOTATION_FIELD_DEF",
		"ANNOTATION_ARRAY_INIT",
		"TYPE_ARGUMENTS",
		"TYPE_ARGUMENT",
		"TYPE_PARAMETERS",
		"TYPE_PARAMETER",
		"WILDCARD_TYPE",
		"TYPE_UPPER_BOUNDS",
		"TYPE_LOWER_BOUNDS",
		"\"package\"",
		"SEMI",
		"\"import\"",
		"\"static\"",
		"LBRACK",
		"RBRACK",
		"IDENT",
		"DOT",
		"QUESTION",
		"\"extends\"",
		"\"super\"",
		"LT",
		"COMMA",
		"GT",
		"SR",
		"BSR",
		"\"void\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"STAR",
		"\"private\"",
		"\"public\"",
		"\"protected\"",
		"\"transient\"",
		"\"native\"",
		"\"threadsafe\"",
		"\"synchronized\"",
		"\"volatile\"",
		"AT",
		"LPAREN",
		"RPAREN",
		"ASSIGN",
		"LCURLY",
		"RCURLY",
		"\"class\"",
		"\"interface\"",
		"\"enum\"",
		"BAND",
		"\"default\"",
		"\"implements\"",
		"\"this\"",
		"\"throws\"",
		"TRIPLE_DOT",
		"COLON",
		"\"if\"",
		"\"else\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"\"continue\"",
		"\"return\"",
		"\"switch\"",
		"\"throw\"",
		"\"assert\"",
		"\"for\"",
		"\"case\"",
		"\"try\"",
		"\"finally\"",
		"\"catch\"",
		"PLUS_ASSIGN",
		"MINUS_ASSIGN",
		"STAR_ASSIGN",
		"DIV_ASSIGN",
		"MOD_ASSIGN",
		"SR_ASSIGN",
		"BSR_ASSIGN",
		"SL_ASSIGN",
		"BAND_ASSIGN",
		"BXOR_ASSIGN",
		"BOR_ASSIGN",
		"LOR",
		"LAND",
		"BOR",
		"BXOR",
		"NOT_EQUAL",
		"EQUAL",
		"LE",
		"GE",
		"\"instanceof\"",
		"SL",
		"PLUS",
		"MINUS",
		"DIV",
		"MOD",
		"INC",
		"DEC",
		"BNOT",
		"LNOT",
		"\"true\"",
		"\"false\"",
		"\"null\"",
		"\"new\"",
		"NUM_INT",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"NUM_FLOAT",
		"NUM_LONG",
		"NUM_DOUBLE",
		"WS",
		"SL_COMMENT",
		"JAVADOC",
		"ML_COMMENT",
		"ESC",
		"HEX_DIGIT",
		"VOCAB",
		"EXPONENT",
		"FLOAT_SUFFIX"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { -9223368188564078590L, 1932718505987L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { -9223368188564078590L, 1932718506002L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { -9223368188564078592L, 1932718505986L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { -9223368188564078590L, 1932718505986L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 3848290697216L, 4278190082L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 0L, 8372304L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { -9223372036854775808L, -9223132077023560196L, 65535L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { -4611682170136690688L, -6917564212013170690L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 0L, 28664620121524L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { -9223368188564078592L, -9223130144296665090L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 0L, 17673798796048L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 0L, 19958729800564L, 274877905920L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 0L, 17605079319312L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 0L, 8864820886672L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { -9223368188564078592L, 10943568265910L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 3848290697216L, 1932726878738L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 3848290697216L, 1941316813366L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 0L, 8372240L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 0L, 564L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = { -9223372036854775808L, 34359739396L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	private static final long[] mk_tokenSet_20() {
		long[] data = { 549755813888L, 4303339536L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_20 = new BitSet(mk_tokenSet_20());
	private static final long[] mk_tokenSet_21() {
		long[] data = { 0L, 4303340084L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_21 = new BitSet(mk_tokenSet_21());
	private static final long[] mk_tokenSet_22() {
		long[] data = { 0L, 70373047517748L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_22 = new BitSet(mk_tokenSet_22());
	private static final long[] mk_tokenSet_23() {
		long[] data = { -9223368188564078592L, 1728555784935031570L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_23 = new BitSet(mk_tokenSet_23());
	private static final long[] mk_tokenSet_24() {
		long[] data = { 0L, 17592186045184L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_24 = new BitSet(mk_tokenSet_24());
	private static final long[] mk_tokenSet_25() {
		long[] data = { 0L, 8598306896L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_25 = new BitSet(mk_tokenSet_25());
	private static final long[] mk_tokenSet_26() {
		long[] data = { -9223368188564078592L, 1728555922373985042L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_26 = new BitSet(mk_tokenSet_26());
	private static final long[] mk_tokenSet_27() {
		long[] data = { -9223368188564078592L, -7494671494333596810L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_27 = new BitSet(mk_tokenSet_27());
	private static final long[] mk_tokenSet_28() {
		long[] data = { -9223368188564078592L, 2305584022677340946L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_28 = new BitSet(mk_tokenSet_28());
	private static final long[] mk_tokenSet_29() {
		long[] data = { -9223368188564078592L, -114366389159050L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_29 = new BitSet(mk_tokenSet_29());
	private static final long[] mk_tokenSet_30() {
		long[] data = { 3848290697216L, 8581529618L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_30 = new BitSet(mk_tokenSet_30());
	private static final long[] mk_tokenSet_31() {
		long[] data = { 3848290697216L, 8581530166L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_31 = new BitSet(mk_tokenSet_31());
	private static final long[] mk_tokenSet_32() {
		long[] data = { 0L, 17600784352016L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_32 = new BitSet(mk_tokenSet_32());
	private static final long[] mk_tokenSet_33() {
		long[] data = { -9223372036854775808L, -9223352202679026828L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_33 = new BitSet(mk_tokenSet_33());
	private static final long[] mk_tokenSet_34() {
		long[] data = { 3848290697216L, 283451064322L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_34 = new BitSet(mk_tokenSet_34());
	private static final long[] mk_tokenSet_35() {
		long[] data = { 3848290697216L, 283451064338L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_35 = new BitSet(mk_tokenSet_35());
	private static final long[] mk_tokenSet_36() {
		long[] data = { 0L, 17669503828752L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_36 = new BitSet(mk_tokenSet_36());
	private static final long[] mk_tokenSet_37() {
		long[] data = { -9223368188564078592L, 17609357509394L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_37 = new BitSet(mk_tokenSet_37());
	private static final long[] mk_tokenSet_38() {
		long[] data = { -9223368188564078592L, -9223352194105868426L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_38 = new BitSet(mk_tokenSet_38());
	private static final long[] mk_tokenSet_39() {
		long[] data = { 0L, 158338272707344L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_39 = new BitSet(mk_tokenSet_39());
	private static final long[] mk_tokenSet_40() {
		long[] data = { -9223372036854775808L, -9223352202679025804L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_40 = new BitSet(mk_tokenSet_40());
	private static final long[] mk_tokenSet_41() {
		long[] data = { 0L, 2560L, 196608L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_41 = new BitSet(mk_tokenSet_41());
	private static final long[] mk_tokenSet_42() {
		long[] data = { 0L, 12288L, 524288L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_42 = new BitSet(mk_tokenSet_42());
	private static final long[] mk_tokenSet_43() {
		long[] data = { 0L, 8388608L, 12582912L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_43 = new BitSet(mk_tokenSet_43());
	private static final long[] mk_tokenSet_44() {
		long[] data = { 0L, 17600784352016L, 274609471488L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_44 = new BitSet(mk_tokenSet_44());
	private static final long[] mk_tokenSet_45() {
		long[] data = { -9223372036854775808L, -9223211310571847812L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_45 = new BitSet(mk_tokenSet_45());
	private static final long[] mk_tokenSet_46() {
		long[] data = { 0L, 784L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_46 = new BitSet(mk_tokenSet_46());
	private static final long[] mk_tokenSet_47() {
		long[] data = { -9223372036854775808L, -9223228911356199316L, 67108863L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_47 = new BitSet(mk_tokenSet_47());
	private static final long[] mk_tokenSet_48() {
		long[] data = { -4611682170136690688L, -6917643376850370690L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_48 = new BitSet(mk_tokenSet_48());
	private static final long[] mk_tokenSet_49() {
		long[] data = { -9223372036854775808L, -9223228902766264724L, 67108863L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_49 = new BitSet(mk_tokenSet_49());
	private static final long[] mk_tokenSet_50() {
		long[] data = { 0L, 17600784352024L, 274864275456L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_50 = new BitSet(mk_tokenSet_50());
	
	}
